import * as React from "react";

import * as QueryString from "query-string";
import Helmet from "react-helmet";
import { RouteComponentProps } from "react-router";

import { EnforcementSearch, EnforcementSearchQueryProps } from "aegis/features/enforcement-search";

export interface EnforcementSearchQueryProps {
  user?: string;
  admin?: string;
}

export class EnforcementPage extends React.Component<RouteComponentProps<EnforcementSearchQueryProps>> {
  render() {
    const { location } = this.props;
    let queryProps: EnforcementSearchQueryProps = {};
    if (location.search) {
      queryProps = QueryString.parse(location.search) as EnforcementSearchQueryProps;
    }
    return (
      <>
        <Helmet>
          <title>Enforcement Search</title>
        </Helmet>
        <EnforcementSearch admin={queryProps.admin} user={queryProps.user} />
      </>
    );
  }
}
