import * as React from "react";

import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { PartnerEscalation } from "aegis/features/partner-escalation";

export interface QueryProps {
  tabID?: string;
  page?: string;
}

export class PartnerEscalationPage extends React.Component<RouteComponentProps<QueryProps>> {
  render() {
    const { location } = this.props;
    let queryProps: QueryProps = {};
    if (location.search) {
      queryProps = QueryString.parse(location.search) as QueryProps;
    }
    return (
      <>
        <Helmet>
          <title>Partner Escalations</title>
        </Helmet>
        <PartnerEscalation queryProps={queryProps} />
      </>
    );
  }
}
