import * as React from "react";

import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { ReportSearch, ReportSearchQueryProps } from "aegis/features/reports/report-search";
import { Display, FlexDirection, Layout } from "twitch-core-ui";

export class ReportSearchPage extends React.Component<RouteComponentProps<ReportSearchQueryProps>> {
  render() {
    const { location } = this.props;
    let queryProps: ReportSearchQueryProps = {};
    if (location.search) {
      queryProps = QueryString.parse(location.search) as ReportSearchQueryProps;
    }
    return (
      <>
        <Helmet>
          <title>Report Search</title>
        </Helmet>
        <Layout padding={2} flexDirection={FlexDirection.Column} display={Display.Flex}>
          <ReportSearch queryProps={queryProps} />
        </Layout>
      </>
    );
  }
}
