import * as React from "react";

import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { ReportDetail } from "aegis/features/report-detail";

interface QueryProps {
  id: string;
}

export class ReportDetailPage extends React.Component<RouteComponentProps<QueryProps>> {
  render() {
    const { location } = this.props;
    let queryProps: QueryProps = { id: "1" };
    if (location.search) {
      queryProps = QueryString.parse(location.search) as QueryProps;
    }
    return (
      <>
        <Helmet>
          <title>Report - {queryProps.id}</title>
        </Helmet>
        <ReportDetail {...queryProps} />
      </>
    );
  }
}
