import * as React from "react";

import * as QueryString from "query-string";
import { RouteComponentProps } from "react-router";

import { ActiveAutoResolveCard } from "aegis/features/active-auto-resolve-card";
import { Reports } from "aegis/features/reports";
import { ActiveShiftsCard } from "aegis/features/shifts";
import { CheckInButton } from "aegis/features/shifts/components/check-in-button";
import { UnresolvedReportsCard } from "aegis/features/unresolved-reports-card";

import { AlignItems, Display, FlexDirection, InjectLayout, JustifyContent, Layout, StyledLayout } from "twitch-core-ui";

import "./styles.scss";

interface QueryProps {
  first?: Number;
  after?: string;
}
export const reportQueueId = "report-queue-container"; // This Id surrounds the entier report queue, and is used to scroll it.

export class ReportQueuePage extends React.Component<RouteComponentProps<QueryProps>> {
  render() {
    const { location } = this.props;
    let queryProps: QueryProps = { first: 10 };
    if (location.search) {
      queryProps = QueryString.parse(location.search) as QueryProps;
    }
    return (
      <Layout
        fullWidth
        className="report-page-container"
        display={Display.Flex}
        justifyContent={JustifyContent.Between}
      >
        <InjectLayout padding={{ x: 1 }} className="report-queue-container">
          <div id={reportQueueId}>
            <Reports {...queryProps} />
          </div>
        </InjectLayout>
        <Layout margin={{ right: 1 }} padding={1} className="reports-sidebar">
          <StyledLayout
            display={Display.Flex}
            justifyContent={JustifyContent.Center}
            flexDirection={FlexDirection.Column}
            alignItems={AlignItems.Center}
          >
            <CheckInButton />
            <ActiveAutoResolveCard />
            <ActiveShiftsCard />
            <UnresolvedReportsCard />
          </StyledLayout>
        </Layout>
      </Layout>
    );
  }
}
