import { action, computed, observable } from "mobx";

import { AltUserInfo } from "aegis/models";

export class AltLookUpStore {
  @computed
  get selectedUsers() {
    return this._selectedRows.reduce((users: string[], selected, index) => {
      if (selected) {
        users.push(this._altUsers[index].user.id || `"${this._altUsers[index].user.login}"`);
      }
      return users;
    }, []);
  }

  @computed
  get numberSelectedUsers() {
    return this._selectedRows.reduce((count, value) => {
      return value ? count + 1 : count;
    }, 0);
  }

  @computed
  get selectedRows(): boolean[] {
    return this._selectedRows;
  }

  @computed
  get allSelected(): boolean {
    return this._allSelected;
  }

  @computed
  get altUsers(): AltUserInfo[] {
    return this._altUsers;
  }

  @computed
  get refDelegates(): ((e: HTMLInputElement) => void)[] {
    return this._refDelegates;
  }

  @computed
  get refs(): HTMLInputElement[] {
    return this._refs;
  }

  @computed
  get checkAllRefDelegate(): (e: HTMLInputElement) => void {
    return (e: HTMLInputElement) => {
      this._checkAllRef = e;
    };
  }

  @observable private _altUsers: AltUserInfo[] = [];
  @observable private _selectedRows: boolean[] = [];
  @observable private _allSelected: boolean = false;

  @observable private _refs: HTMLInputElement[] = [];
  @observable private _refDelegates: ((e: HTMLInputElement) => void)[];
  @observable private _checkAllRef: HTMLInputElement = {} as HTMLInputElement;

  @action
  setAllSelected(checked: boolean) {
    if (this._checkAllRef) {
      this._checkAllRef.checked = checked;
    }
    this._allSelected = checked;
  }

  @action
  setAltUsers(altUsers: AltUserInfo[]) {
    this._altUsers = altUsers;

    this._refs = new Array(altUsers.length);
    this._refDelegates = altUsers.map((_, index) => (e: HTMLInputElement) => {
      this._refs[index] = e;
    });

    this._selectedRows = new Array(altUsers.length).fill(false);
  }

  @action
  updateSelected() {
    return () => {
      this._selectedRows = this._refs.map(input => input.checked);
    };
  }

  @action
  toggleAll() {
    return () => {
      this._allSelected = !this._allSelected;
      this._selectedRows = this._selectedRows.map(() => this._allSelected);

      this._checkAllRef.checked = this._allSelected;
      this._refs.forEach(ref => {
        ref.checked = this._allSelected;
      });
    };
  }

  @action
  toggleRow(index: number) {
    this._selectedRows[index] = !this._selectedRows[index];
  }
}
