import { MockAdmin } from "aegis/models/mocks";
import { AuthStore } from "./authstore";

describe("authStore", () => {
  const dummyToken = "dummy";
  const store = new AuthStore();

  test("initial state", () => {
    expect(store).toMatchSnapshot();
    expect(store.hasToken).toBe(false);
    expect(store.token).toBe(null);
  });

  test("set a token", () => {
    store.tokenReceived(dummyToken);
    expect(store).toMatchSnapshot();
    expect(store.hasToken).toBe(true);
    expect(store.token).toBe(dummyToken);
  });

  test("reset", () => {
    store.userLogin(MockAdmin());
    expect(store.hasLoggedInUser).toBeTruthy();
    store.reset();

    expect(store).toMatchSnapshot();
    expect(store.hasToken).toBe(false);
    expect(store.token).toBe(null);
    expect(store.hasLoggedInUser).toBeFalsy();
  });
});
