import { DeferredEmoteStore } from ".";
import { DeferredEmotes, storageKey, ttlMillis } from "./deferredEmotesStore";

describe("deferredEmotesStore", () => {
  it("initailizes with garbage data", () => {
    localStorage.setItem(storageKey, "garabge");

    spyOn(console, "error"); // console error is expected

    const store = new DeferredEmoteStore();
    expect(store).toBeTruthy();
  });

  it("initailizes with no data", () => {
    localStorage.clear();

    const store = new DeferredEmoteStore();
    expect(store).toBeTruthy();
  });

  it("updates deferred and persist data", () => {
    const emoteID = "emoteID";
    const store = new DeferredEmoteStore();
    store.updateDeferred([emoteID]);
    expect(store.isDeferred(emoteID)).toBe(true);

    const newStore = new DeferredEmoteStore();
    expect(newStore.isDeferred(emoteID)).toBe(true);
  });

  it("does not persist data if entry is expired", () => {
    const emoteID = "emoteID";
    const store = new DeferredEmoteStore();
    store.updateDeferred([emoteID]);
    expect(store.isDeferred(emoteID)).toBe(true);

    // Manually update date to be past TTL
    const storedValue = localStorage.getItem(storageKey);
    expect(storedValue).toBeTruthy();
    const emotes = JSON.parse(storedValue!) as DeferredEmotes;
    expect(emotes.updatedAt).toBeTruthy();
    emotes.updatedAt = new Date(new Date(emotes.updatedAt!).getTime() - ttlMillis - 1).toISOString();
    localStorage.setItem(storageKey, JSON.stringify(emotes));

    const newStore = new DeferredEmoteStore();
    expect(newStore.isDeferred(emoteID)).toBe(false);
  });
});
