import { TrackingClient } from "aegis/features/tracking/client";
import { SpadeReporter } from "tachyon-spade-reporter";
import { AuthStore, AuthStoreProps } from "./authstore";
import { ChatStore, ChatStoreParams } from "./chatstore";
import { DeferredEmoteStore, DeferredEmoteStoreProps } from "./deferredEmotesStore";
import { Modal, ModalProps } from "./modal";
import { PageViewStore, PageViewStoreProps } from "./pageViewStore";
import { ReportStore, ReportStoreProps } from "./reportstore";
import { SettingsStore, SettingsStoreProps, Theme } from "./settingsstore";
import { StackedModalStore } from "./stackedModalStore";

const authStore = new AuthStore();
const chatStore = new ChatStore();
const deferredEmoteStore = new DeferredEmoteStore();
const modal = new Modal();
const pageViewStore = new PageViewStore();
const settingsStore = new SettingsStore();
const stackedModalStore = new StackedModalStore();
const trackingClient = new TrackingClient(new SpadeReporter("https://spade.twitch.tv"), authStore);
const reportStore = new ReportStore();

export {
  authStore,
  AuthStore,
  AuthStoreProps,
  chatStore,
  ChatStore,
  ChatStoreParams,
  deferredEmoteStore,
  DeferredEmoteStore,
  DeferredEmoteStoreProps,
  modal,
  Modal,
  ModalProps,
  pageViewStore,
  PageViewStore,
  PageViewStoreProps,
  reportStore,
  ReportStore,
  ReportStoreProps,
  settingsStore,
  SettingsStoreProps,
  stackedModalStore,
  StackedModalStore,
  trackingClient,
  Theme
};
