import * as React from "react";

import { Modal } from "./modal";

describe("modal", () => {
  const modal = new Modal();

  test("initial state", () => {
    expect(modal).toMatchSnapshot();
    expect(modal.isVisible).toBe(false);
    expect(modal.component).toBe(null);
    expect(modal.componentProps).toBe(null);
  });

  test("show modal and close it", () => {
    const component = TestComponent as React.ComponentClass;
    const props: TestProps = {
      label: "best label na"
    };
    modal.showModal(component, props);
    expect(modal).toMatchSnapshot();
    expect(modal.isVisible).toBe(true);
    expect(modal.component).toBe(component);
    expect(modal.componentProps).toEqual(props);

    modal.closeModal();
    expect(modal).toMatchSnapshot();
    expect(modal.isVisible).toBe(false);
    expect(modal.component).toBe(null);
    expect(modal.componentProps).toBe(null);
  });

  test("show modal multiple times and close it", () => {
    spyOn(console, "error");
    const component = TestComponent as React.ComponentClass;
    const props: TestProps = {
      label: "best label na"
    };
    const props2: TestProps = {
      label: "this label should not shown"
    };
    modal.showModal(component, props);
    modal.showModal(component, props2);
    expect(modal).toMatchSnapshot();
    expect(modal.isVisible).toBe(true);
    expect(modal.component).toBe(component);
    expect(modal.componentProps).toEqual(props);

    modal.closeModal();
    expect(modal).toMatchSnapshot();
    expect(modal.isVisible).toBe(false);
    expect(modal.component).toBe(null);
    expect(modal.componentProps).toBe(null);
  });
});

class TestProps {
  label: string;
}

class TestComponent extends React.Component<TestProps, {}> {
  render() {
    return <div>Hello world! label is {this.props.label}</div>;
  }
}
