import * as React from "react";

import { action, computed, observable } from "mobx";

// Global states for displaying a modal. Only one modal can be displayed at a time currently
export class Modal {
  @observable private _component: React.ComponentClass<{}> | null = null;
  @observable private _componentProps: {} | null = null;

  @computed
  get isVisible(): boolean {
    return !!this._component;
  }

  @computed
  get component(): React.ComponentClass<{}> | null {
    return this._component;
  }

  @computed
  get componentProps(): {} | null {
    return this._componentProps;
  }

  @action
  showModal<T>(component: React.ComponentClass<T>, componentProps: T): void {
    if (this.isVisible) {
      console.error("Invalid Action. Attempting to open another modal when a modal is already shown");
      return;
    }
    this._component = component;
    this._componentProps = componentProps;
  }

  @action
  closeModal = (): void => {
    this._component = null;
    this._componentProps = null;
  };
}

export class ModalProps {
  modal?: Modal;
}
