import { action, computed, observable } from "mobx";

export interface PageViewStoreProps {
  pageViewStore?: PageViewStore;
}

export class PageViewStore {
  @observable private _previousLocation: string | undefined = undefined;

  @computed
  get previousLocation(): string | undefined {
    return this._previousLocation;
  }

  @action
  setPreviousLocation(location: string) {
    this._previousLocation = location;
  }
}
