import { action, autorun, computed, observable } from "mobx";

const localStorageKeyPrefix = "aegis:settings:";

export enum Theme {
  Light = "LIGHT_THEME",
  Dark = "DARK_THEME"
}

export interface SettingsStoreProps {
  settingsStore?: SettingsStore;
}

export class SettingsStore {
  @observable private _theme: Theme = Theme.Light;

  constructor() {
    this._theme = Theme.Light;
    const userTheme = localStorage.getItem(localStorageKeyPrefix + "theme");

    switch (userTheme) {
      case Theme.Dark:
        this._theme = Theme.Dark;
        break;
      default:
        this._theme = Theme.Light;
    }

    autorun(() => localStorage.setItem(localStorageKeyPrefix + "theme", this._theme));
  }

  @computed
  get dark(): boolean {
    return this._theme === Theme.Dark;
  }

  @computed
  get light(): boolean {
    return this._theme === Theme.Light;
  }

  @computed
  get theme(): Theme {
    return this._theme;
  }

  @action
  setTheme(theme: Theme) {
    this._theme = theme;
  }
}
