import { action, computed, observable } from "mobx";

export class StackedModalStore {
  @observable private _openModals: JSX.Element[] = [];

  @computed
  get currentModal(): JSX.Element {
    return this._openModals.slice(-1)[0];
  }

  @computed
  get openModals(): JSX.Element[] {
    return this._openModals;
  }

  shouldRender(modal: JSX.Element): boolean {
    return this._openModals.slice(-1)[0] === modal;
  }

  isOnlyModal(modal: JSX.Element): boolean {
    return this._openModals.length === 1 && this.shouldRender(modal);
  }

  @action
  openModal(modal: JSX.Element) {
    this._openModals.push(modal);
  }

  @action
  closeModal(modal: JSX.Element) {
    const index = this._openModals.findIndex(element => element === modal);
    if (index !== -1) {
      this._openModals.splice(index, 1);
    }
  }
}
