import { InMemoryCache, NormalizedCacheObject } from "apollo-cache-inmemory";
import { ApolloQueryResult } from "apollo-client";
import { ApolloClient } from "apollo-client";
import { ApolloLink } from "apollo-link";
import { addTypenameToDocument } from "apollo-utilities";
import { DocumentNode } from "graphql";
import { GraphqlQueryControls } from "react-apollo";

import { MockedResponse } from "aegis/tests/graphql";

export const MockApolloClient = new ApolloClient({
  link: new ApolloLink(),
  cache: new InMemoryCache()
});

export function mockApolloClient<Data>(responseData: Data) {
  return ({
    query(): Promise<ApolloQueryResult<Data>> {
      return Promise.resolve({
        data: responseData,
        loading: false,
        networkStatus: 7,
        stale: false
      });
    }
  } as {}) as ApolloClient<NormalizedCacheObject>;
}

/**
 * Creates a mock GQL error response. The query should be the query you expect to fail, and the variables
 * are those that you'd provide to the query.
 */
export function mockErrorResponse(query: DocumentNode, variables?: {}): MockedResponse {
  return {
    request: {
      query: addTypenameToDocument(query),
      variables: variables || {}
    },
    result: {
      data: {}
    },
    error: new Error("MockError: Unable to resolve GQL response")
  };
}

/**
 * Mocks a GQL success state response for a given query and variables.
 */
export function mockSuccessResponse(query: DocumentNode, variables: {}, result: {}): MockedResponse {
  return {
    request: {
      query: addTypenameToDocument(query),
      variables
    },
    result
  };
}

export function mockGraphqlQueryControls(overrides?: Partial<GraphqlQueryControls>) {
  return {
    networkStatus: 0,
    loading: false,
    variables: {},
    fetchMore: jest.fn(),
    refetch: jest.fn(),
    startPolling: jest.fn(),
    stopPolling: jest.fn(),
    subscribeToMore: jest.fn(),
    updateQuery: jest.fn(),
    ...overrides
  };
}
