// Typing for https://www.npmjs.com/package/react-countdown-now
declare module "react-countdown-now" {
  import * as React from "react";

  export type Props = {
    date: Date | string | number;
    precision?: number;
    controlled?: boolean;
    daysInHours?: boolean;
    zeroPadLength?: number;
    intervalDelay?: number;
    children?: JSX.Element;
    renderer?: (delta: Delta) => JSX.Element;
    onTick?: (delta: Delta) => void;
    onComplete?: (delta: Delta) => void;
  };

  export interface Delta {
    total: number;
    days: number;
    hours: number;
    minutes: number;
    seconds: number;
    milliseconds: number;
    completed: boolean;
  }

  export function getTimeDifference(
    date: Date,
    props?: {
      date: Date;
      now?: Date;
      precision?: number;
      controlled?: boolean;
    }
  ): Delta;

  export function zeroPad(value: number, length?: number): number;

  // Countdown is a default class. Must be typed and exported as default =(
  class Countdown<P> extends React.Component<Props> {}
  export default Countdown;
}
