#!/bin/bash
# Prereqs:
# - terraform
# First we run: terraform get -update
# Next we run: terraform init

if [ ! $(which terraform) ]; then
  echo "Please install terraform and ensure it is in your $PATH"
  exit 1
fi

echo "Running 'terraform get -update'"
terraform get -update

if [ $? -gt 0 ]; then
  echo "Failed running 'terraform get -update'"
  exit 1
fi

echo "Running 'terraform init'"
terraform init

if [ $? -gt 0 ]; then
  echo "Failed running terraform init"
  exit 1
fi

exit 0
