resource "aws_iam_role_policy" "pod_role_policy" {
  name = "aegis-pod"
  role = "${aws_iam_role.pod_role.id}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "s3",
            "Effect": "Allow",
            "Action": [
                "s3:PutObject",
                "s3:PutObjectACL",
                "s3:GetObject",
                "s3:ListBucket",
                "s3:DeleteObject"
            ],
            "Resource": [
                "${aws_s3_bucket.aegis-uploads.arn}",
                "${aws_s3_bucket.aegis-uploads.arn}/*"
            ]
        },
        {
            "Sid": "dynamo",
            "Effect": "Allow",
            "Action": [
                "dynamodb:GetItem",
                "dynamodb:Scan",
                "dynamodb:Query",
                "dynamodb:BatchGetItem"
            ],
            "Resource": [
            "arn:aws:dynamodb:us-west-2:654663525958:table/Chatlogs",
            "arn:aws:dynamodb:us-west-2:654663525958:table/Chatlogs/*",
            "arn:aws:dynamodb:us-west-2:654663525958:table/ChatActivityLog",
            "arn:aws:dynamodb:us-west-2:654663525958:table/ChatActivityLog/*"
            ]

        },
        {
            "Sid": "sandstorm",
            "Effect": "Allow",
            "Action": [
                "sts:AssumeRole"
            ],
            "Resource": [
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/safety-aegis-production"
            ]
        },
{
            "Sid": "s2s",
            "Effect": "Allow",
            "Action": [
                "sts:AssumeRole"
            ],
            "Resource": [
               "arn:aws:iam::180116294062:role/malachai/*"
            ]
}
    ]
}
EOF
}

resource "aws_iam_role" "pod_role" {
  name = "aegis"
  path = "/pods/"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::654663525958:role/eks_nodes",
        "Service": "ec2.amazonaws.com"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "lambda_role" {
  role = "${aws_iam_role.pod_role.id}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaRole"
}
