resource "aws_s3_bucket" "aegis-uploads" {
  bucket = "aegis-uploads-${data.aws_caller_identity.current.account_id}"

  logging {
    target_bucket = "${var.log_bucket}"
    target_prefix = "aegis-uploads-${data.aws_caller_identity.current.account_id}/"
  }

  tags {
    Owner       = "safety@twitch.tv"
    Provisioner = "terraform"
  }
}
