// Code generated by protoc-gen-twirp v5.7.0, DO NOT EDIT.
// source: code.justin.tv/amzn/JaegerLambdaTwirp/twirp.proto

/*
Package JaegerLambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.7.0.

It is generated from these files:
	code.justin.tv/amzn/JaegerLambdaTwirp/twirp.proto
*/
package JaegerLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =======================
// JaegerService Interface
// =======================

type JaegerService interface {
	ModerateBounty(context.Context, *ModerateBountyRequest) (*ModerateBountyResponse, error)

	GetBounties(context.Context, *GetBountiesRequest) (*GetBountiesResponse, error)
}

// =============================
// JaegerService Protobuf Client
// =============================

type jaegerServiceProtobufClient struct {
	client HTTPClient
	urls   [2]string
}

// NewJaegerServiceProtobufClient creates a Protobuf client that implements the JaegerService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewJaegerServiceProtobufClient(addr string, client HTTPClient) JaegerService {
	prefix := urlBase(addr) + JaegerServicePathPrefix
	urls := [2]string{
		prefix + "ModerateBounty",
		prefix + "GetBounties",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &jaegerServiceProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &jaegerServiceProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *jaegerServiceProtobufClient) ModerateBounty(ctx context.Context, in *ModerateBountyRequest) (*ModerateBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.jaegerservice")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	out := new(ModerateBountyResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jaegerServiceProtobufClient) GetBounties(ctx context.Context, in *GetBountiesRequest) (*GetBountiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.jaegerservice")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	out := new(GetBountiesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =========================
// JaegerService JSON Client
// =========================

type jaegerServiceJSONClient struct {
	client HTTPClient
	urls   [2]string
}

// NewJaegerServiceJSONClient creates a JSON client that implements the JaegerService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewJaegerServiceJSONClient(addr string, client HTTPClient) JaegerService {
	prefix := urlBase(addr) + JaegerServicePathPrefix
	urls := [2]string{
		prefix + "ModerateBounty",
		prefix + "GetBounties",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &jaegerServiceJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &jaegerServiceJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *jaegerServiceJSONClient) ModerateBounty(ctx context.Context, in *ModerateBountyRequest) (*ModerateBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.jaegerservice")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	out := new(ModerateBountyResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jaegerServiceJSONClient) GetBounties(ctx context.Context, in *GetBountiesRequest) (*GetBountiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.jaegerservice")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	out := new(GetBountiesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ============================
// JaegerService Server Handler
// ============================

type jaegerServiceServer struct {
	JaegerService
	hooks *twirp.ServerHooks
}

func NewJaegerServiceServer(svc JaegerService, hooks *twirp.ServerHooks) TwirpServer {
	return &jaegerServiceServer{
		JaegerService: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *jaegerServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// JaegerServicePathPrefix is used for all URL paths on a twirp JaegerService server.
// Requests are always: POST JaegerServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const JaegerServicePathPrefix = "/twirp/twitch.fulton.example.jaegerservice.JaegerService/"

func (s *jaegerServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.jaegerservice")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.jaegerservice.JaegerService/ModerateBounty":
		s.serveModerateBounty(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.jaegerservice.JaegerService/GetBounties":
		s.serveGetBounties(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *jaegerServiceServer) serveModerateBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveModerateBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveModerateBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveModerateBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ModerateBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *ModerateBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.ModerateBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ModerateBountyResponse and nil error while calling ModerateBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveModerateBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ModerateBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *ModerateBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.ModerateBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ModerateBountyResponse and nil error while calling ModerateBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBounties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBountiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *GetBountiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBounties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesResponse and nil error while calling GetBounties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *GetBountiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBounties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesResponse and nil error while calling GetBounties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *jaegerServiceServer) ProtocGenTwirpVersion() string {
	return "v5.7.0"
}

func (s *jaegerServiceServer) PathPrefix() string {
	return JaegerServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Cause() error  { return e.cause }
func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause, accessible
// by github.com/pkg/errors.Cause, but the original error message is not exposed on Msg().
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Cause() error                                { return e.cause }
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return wrapInternal(err, "failed to unmarshal proto response")
	}
	return nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return wrapInternal(err, "could not build request")
	}
	resp, err := client.Do(req)
	if err != nil {
		return wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return wrapInternal(err, "aborted because context was done")
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1334 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0x5f, 0x73, 0xdb, 0xc4,
	0x17, 0x8d, 0x6c, 0xcb, 0x89, 0xaf, 0xd3, 0x44, 0xdd, 0x26, 0x1d, 0xfd, 0x32, 0xbf, 0x81, 0x8c,
	0x80, 0xa1, 0x04, 0x6a, 0xb7, 0xa1, 0x0c, 0x6d, 0x79, 0xc1, 0x71, 0x14, 0x57, 0x60, 0xcb, 0x61,
	0xad, 0xa4, 0x53, 0x66, 0xa8, 0x67, 0x6d, 0x6d, 0x5c, 0x35, 0xfa, 0x63, 0xb4, 0xeb, 0xb4, 0xe6,
	0x89, 0x17, 0x1e, 0x78, 0xe7, 0x99, 0xe1, 0xbb, 0xf0, 0xc6, 0xa7, 0x62, 0x76, 0x25, 0xd9, 0x4e,
	0xec, 0x61, 0x6c, 0x06, 0x78, 0xf1, 0xe8, 0x5e, 0xe9, 0x9c, 0xdd, 0x3d, 0x7b, 0xf6, 0xde, 0x35,
	0x3c, 0xec, 0x47, 0x2e, 0xad, 0xbc, 0x1e, 0x31, 0xee, 0x85, 0x15, 0x7e, 0x55, 0x25, 0xc1, 0x0f,
	0x61, 0xf5, 0x2b, 0x42, 0x07, 0x34, 0x6e, 0x92, 0xa0, 0xe7, 0x12, 0xe7, 0x8d, 0x17, 0x0f, 0xab,
	0x5c, 0xfc, 0x56, 0x86, 0x71, 0xc4, 0x23, 0xf4, 0x1e, 0x7f, 0xe3, 0xf1, 0xfe, 0xab, 0xca, 0xc5,
	0xc8, 0xe7, 0x51, 0x58, 0xa1, 0x6f, 0x49, 0x30, 0xf4, 0x69, 0xe5, 0xb5, 0x04, 0x31, 0x1a, 0x5f,
	0x79, 0x7d, 0xba, 0xf7, 0xee, 0x20, 0x8a, 0x06, 0x3e, 0xad, 0x4a, 0x48, 0x6f, 0x74, 0x51, 0xe5,
	0x5e, 0x40, 0x19, 0x27, 0x41, 0xca, 0x62, 0xfc, 0x94, 0x83, 0xdd, 0x56, 0xe4, 0xd2, 0x98, 0x70,
	0x7a, 0x14, 0x8d, 0x42, 0x3e, 0xc6, 0xf4, 0xfb, 0x11, 0x65, 0x1c, 0xed, 0xc1, 0x46, 0x4f, 0x26,
	0x2c, 0x57, 0x57, 0xf6, 0x95, 0x7b, 0x25, 0x3c, 0x89, 0x11, 0x01, 0x2d, 0x48, 0x40, 0x5e, 0x14,
	0x76, 0x38, 0xe1, 0x23, 0xa6, 0xe7, 0xf6, 0x95, 0x7b, 0x5b, 0x87, 0x9f, 0x55, 0x96, 0x98, 0x56,
	0xa5, 0x75, 0x03, 0x8c, 0xe7, 0xe8, 0x50, 0x00, 0x3b, 0xd3, 0xdc, 0x09, 0xf1, 0x7c, 0x4c, 0x09,
	0x8b, 0x42, 0x3d, 0x2f, 0x87, 0x79, 0xb2, 0xe2, 0x30, 0x53, 0x02, 0xbc, 0x90, 0xd6, 0xf8, 0x0e,
	0xee, 0xde, 0x94, 0x81, 0x0d, 0xa3, 0x90, 0x51, 0x54, 0x87, 0x62, 0xb2, 0x6e, 0xa9, 0x42, 0xf9,
	0xf0, 0xe3, 0xa5, 0x86, 0x4e, 0x49, 0x52, 0xa8, 0xf1, 0x5b, 0x0e, 0x50, 0x83, 0x72, 0x99, 0xf5,
	0x28, 0xcb, 0x34, 0x5e, 0xa4, 0xa3, 0xf2, 0xcf, 0xea, 0xb8, 0x03, 0xaa, 0xef, 0x05, 0x1e, 0x97,
	0xfb, 0xa3, 0xe2, 0x24, 0x40, 0x07, 0xa0, 0xf1, 0x88, 0x13, 0xff, 0x68, 0xd4, 0xbf, 0xa4, 0xbc,
	0x2e, 0xa6, 0x25, 0x95, 0x55, 0xf1, 0x5c, 0x1e, 0xbd, 0x03, 0xd0, 0x93, 0xa1, 0x4d, 0x02, 0xaa,
	0x17, 0xa4, 0x15, 0x66, 0x32, 0xc8, 0x84, 0xf5, 0x0b, 0xcf, 0xe7, 0x34, 0x66, 0xba, 0xba, 0x9f,
	0x5f, 0x5a, 0xa1, 0x13, 0x89, 0xc1, 0x19, 0xd6, 0x78, 0x09, 0x77, 0xae, 0x29, 0x94, 0xca, 0xdf,
	0x48, 0x6d, 0xe8, 0x51, 0x21, 0x4d, 0x7e, 0xd5, 0x0d, 0x98, 0x80, 0x8d, 0x3f, 0x0a, 0x50, 0x4c,
	0x92, 0x68, 0x0b, 0x72, 0x5e, 0x66, 0xea, 0x9c, 0xe7, 0x22, 0x0b, 0x36, 0xfa, 0x24, 0x18, 0x12,
	0x6f, 0x10, 0x4a, 0x99, 0xca, 0x87, 0xf7, 0x97, 0x1a, 0xa3, 0x9e, 0x82, 0xf0, 0x04, 0x8e, 0x0c,
	0xd8, 0x64, 0x3c, 0xa6, 0x24, 0x70, 0x3c, 0xee, 0x53, 0x26, 0x45, 0x2d, 0xe1, 0x6b, 0x39, 0x64,
	0x82, 0xca, 0x09, 0xbb, 0x64, 0x7a, 0x41, 0xae, 0xa7, 0xba, 0xc2, 0x7a, 0x1c, 0xc2, 0x2e, 0x71,
	0x82, 0x5e, 0x68, 0x1e, 0xf5, 0xbf, 0x39, 0x84, 0xc5, 0x7f, 0xe5, 0x10, 0xa2, 0x4f, 0xe0, 0xb6,
	0x4f, 0x18, 0xcf, 0x0e, 0xa2, 0xeb, 0x78, 0x01, 0xd5, 0xd7, 0xf7, 0x95, 0x7b, 0x79, 0x3c, 0xff,
	0x02, 0xbd, 0x84, 0xed, 0x5e, 0x1c, 0x11, 0xb7, 0x4f, 0x18, 0xa7, 0xb1, 0x15, 0x5e, 0x44, 0xfa,
	0x86, 0xdc, 0xbc, 0x47, 0xcb, 0x09, 0x7a, 0x1d, 0x8b, 0x6f, 0x92, 0x89, 0x02, 0x38, 0xf4, 0x09,
	0xbf, 0x88, 0xe2, 0x40, 0x2f, 0x25, 0x05, 0x30, 0x8b, 0x8d, 0x7d, 0x80, 0xe9, 0x86, 0x20, 0x04,
	0x85, 0xab, 0xc8, 0x4d, 0xfc, 0x59, 0xc2, 0xf2, 0xd9, 0xe8, 0xc2, 0xf6, 0x8d, 0x11, 0xd0, 0x5d,
	0x28, 0x8e, 0x18, 0x8d, 0x27, 0xf5, 0x34, 0x8d, 0x90, 0x0e, 0xeb, 0x7d, 0x41, 0x16, 0x8f, 0xa5,
	0xfb, 0x4a, 0x38, 0x0b, 0xc5, 0x14, 0x7c, 0x12, 0x0e, 0x46, 0x64, 0x40, 0x53, 0x27, 0x4d, 0x62,
	0xe3, 0xf7, 0x22, 0x6c, 0x64, 0x06, 0x9c, 0x73, 0xf4, 0x0e, 0xa8, 0x5c, 0x98, 0x2d, 0x25, 0x4c,
	0x02, 0xf4, 0x25, 0xa8, 0xbd, 0x98, 0x84, 0xae, 0xe4, 0x2a, 0x1f, 0x1e, 0x2c, 0xa9, 0x13, 0x09,
	0x5d, 0x9c, 0x00, 0x51, 0x05, 0xd0, 0x8c, 0x4c, 0x2d, 0xca, 0x98, 0x98, 0x5a, 0x52, 0x13, 0x16,
	0xbc, 0x41, 0xff, 0x87, 0x52, 0x3f, 0x0a, 0x39, 0x0d, 0xb9, 0xe5, 0x4a, 0x73, 0x96, 0xf0, 0x34,
	0x21, 0xd8, 0xc8, 0x15, 0xf1, 0x7c, 0xd2, 0xf3, 0xe9, 0x69, 0x2a, 0x2d, 0xd3, 0x8b, 0x52, 0xc5,
	0x05, 0x6f, 0xd0, 0x23, 0x58, 0x67, 0x9c, 0xc4, 0xbc, 0xc6, 0xa5, 0x2b, 0xca, 0x87, 0x7b, 0x95,
	0xa4, 0xbf, 0x55, 0xb2, 0xfe, 0x56, 0x71, 0xb2, 0xfe, 0x86, 0xb3, 0x4f, 0xd1, 0x03, 0x50, 0x69,
	0xe8, 0xd6, 0x78, 0xea, 0x8e, 0xbf, 0xc2, 0x24, 0x1f, 0x8a, 0xea, 0x98, 0xd4, 0xed, 0x26, 0x0d,
	0x07, 0xfc, 0xd5, 0x31, 0x19, 0x33, 0xe9, 0x00, 0x15, 0xcf, 0xe5, 0xd1, 0x23, 0xd8, 0xe5, 0x34,
	0x0e, 0x58, 0x2d, 0x74, 0xeb, 0x51, 0xe8, 0x7a, 0xc2, 0xd2, 0xec, 0x2c, 0xf6, 0x75, 0x90, 0xab,
	0x5d, 0xfc, 0x12, 0x35, 0xb2, 0x12, 0x50, 0x96, 0x25, 0xe0, 0xe1, 0x4a, 0xe5, 0x66, 0xb6, 0x08,
	0x60, 0x28, 0xbb, 0x1e, 0x1b, 0xfa, 0x64, 0x2c, 0x0f, 0xc0, 0xa6, 0x5c, 0xe2, 0x83, 0xa5, 0xe8,
	0x8e, 0xa7, 0x38, 0x3c, 0x4b, 0x82, 0x1e, 0xc0, 0x9d, 0xa4, 0x5e, 0x25, 0xcb, 0xec, 0xd0, 0x7e,
	0x14, 0xba, 0x4c, 0xbf, 0x25, 0x0f, 0xe2, 0xa2, 0x57, 0xe8, 0x1b, 0x28, 0x5e, 0x79, 0x2e, 0x8d,
	0x98, 0xbe, 0x25, 0xd7, 0xf3, 0x64, 0xa5, 0xf5, 0x54, 0xce, 0x25, 0xd6, 0x14, 0x96, 0xc7, 0x29,
	0xd1, 0x1e, 0x85, 0xf2, 0x4c, 0x1a, 0x69, 0x90, 0xbf, 0xa4, 0xe3, 0xd4, 0xe1, 0xe2, 0x51, 0x98,
	0xf9, 0x8a, 0xf8, 0x23, 0x9a, 0x56, 0xec, 0xe5, 0xcc, 0x2c, 0x29, 0x71, 0x02, 0x7c, 0x9a, 0x7b,
	0xac, 0x18, 0xe7, 0xa0, 0x4a, 0x83, 0xcf, 0x9d, 0x20, 0x04, 0x85, 0x50, 0xf4, 0xbb, 0xe4, 0x00,
	0xc9, 0x67, 0xf4, 0x11, 0x68, 0xc4, 0x4d, 0x76, 0x91, 0xf8, 0xdd, 0x01, 0x09, 0x64, 0x81, 0x17,
	0x6e, 0xdd, 0x9e, 0xe6, 0x1b, 0x22, 0x6d, 0x78, 0x50, 0x9e, 0xd1, 0x17, 0xed, 0x4f, 0xb6, 0x49,
	0x36, 0xd1, 0x64, 0x98, 0xd9, 0x94, 0x38, 0x29, 0xbd, 0xe8, 0x6d, 0x2d, 0xe6, 0x67, 0xb8, 0x99,
	0x0e, 0x3a, 0x4d, 0x88, 0x42, 0xd0, 0x8f, 0xae, 0x68, 0x2c, 0x5e, 0xa6, 0x85, 0x20, 0x8b, 0x8d,
	0x2a, 0xa8, 0x72, 0x59, 0x42, 0xa3, 0x51, 0xec, 0x67, 0x1a, 0x8d, 0x62, 0x7f, 0x71, 0x19, 0x30,
	0x5e, 0xc0, 0xe6, 0xac, 0x95, 0x90, 0x05, 0x05, 0x3e, 0x1e, 0xd2, 0x95, 0x6e, 0x1e, 0xb3, 0x04,
	0xce, 0x78, 0x48, 0xb1, 0xa4, 0x30, 0x28, 0x14, 0x93, 0xbe, 0x8e, 0xea, 0xd7, 0x48, 0xab, 0x2b,
	0x5c, 0x09, 0xa6, 0x74, 0xa2, 0x62, 0xca, 0xad, 0x12, 0xb7, 0x4b, 0x21, 0x73, 0x1a, 0x1d, 0xbc,
	0x0f, 0x30, 0xfd, 0x16, 0x6d, 0x40, 0xc1, 0x6e, 0xdb, 0xa6, 0xb6, 0x86, 0x36, 0x61, 0xa3, 0x59,
	0xb3, 0x1b, 0x67, 0xb5, 0x86, 0xa9, 0x29, 0x07, 0xe7, 0xa0, 0xdd, 0x9c, 0x26, 0x2a, 0xc3, 0xfa,
	0x99, 0xfd, 0xb5, 0xdd, 0x7e, 0x6e, 0x6b, 0x6b, 0xe8, 0x36, 0xdc, 0x3a, 0xad, 0xbd, 0xe8, 0x3a,
	0xed, 0x6e, 0xc7, 0xc1, 0x66, 0xad, 0xa5, 0x29, 0x48, 0x83, 0xcd, 0x46, 0xad, 0x65, 0x76, 0x1d,
	0x5c, 0xb3, 0x9a, 0x26, 0xd6, 0x72, 0x22, 0xd3, 0xb2, 0x3a, 0xf5, 0x49, 0x26, 0x7f, 0xf0, 0x14,
	0xb4, 0x9b, 0xbd, 0x13, 0x21, 0xd8, 0x3a, 0x35, 0xed, 0x63, 0xcb, 0x6e, 0x74, 0xb1, 0x79, 0x6e,
	0x99, 0xcf, 0xb5, 0x35, 0x31, 0xaf, 0xd3, 0x5a, 0xa7, 0xa3, 0x29, 0xe2, 0xe9, 0xa4, 0x66, 0x35,
	0xb5, 0xdc, 0xc1, 0x2f, 0x0a, 0xec, 0x2c, 0xea, 0x88, 0xa8, 0x04, 0x6a, 0xdb, 0x79, 0x66, 0x62,
	0x6d, 0x0d, 0xe9, 0xb0, 0xd3, 0xb2, 0x6c, 0xab, 0x75, 0xd6, 0xea, 0x3a, 0x56, 0xcb, 0xec, 0xda,
	0x6d, 0xa7, 0xdb, 0x32, 0x1d, 0x4d, 0x41, 0xbb, 0x70, 0xdb, 0xb2, 0xeb, 0x6d, 0x8c, 0xcd, 0xba,
	0xd3, 0xad, 0xb7, 0x6d, 0xc7, 0xb4, 0x1d, 0x2d, 0x87, 0xb6, 0xa1, 0x7c, 0x54, 0x3b, 0x6e, 0xb5,
	0xcf, 0x9c, 0x67, 0x96, 0xdd, 0xd0, 0xf2, 0xe8, 0x7f, 0xb0, 0x2b, 0xc9, 0xb2, 0x6f, 0xba, 0xe7,
	0x56, 0xc7, 0x3a, 0x6a, 0x9a, 0x5a, 0x41, 0x4c, 0xc5, 0x3a, 0x6e, 0x9a, 0x9a, 0x8a, 0x00, 0x8a,
	0x76, 0xbb, 0x7b, 0xde, 0x3e, 0xd6, 0x8a, 0x07, 0xf7, 0x61, 0xa3, 0x99, 0x36, 0x16, 0x54, 0x84,
	0x9c, 0x29, 0xd4, 0x29, 0x81, 0x6a, 0xda, 0xdd, 0xc6, 0x91, 0xa6, 0x88, 0xd4, 0x89, 0xd0, 0xa2,
	0x08, 0xb9, 0x63, 0x53, 0xcb, 0x1f, 0xfe, 0x9a, 0x83, 0x5b, 0xc9, 0xbf, 0x93, 0x4e, 0xb2, 0x75,
	0xe8, 0x67, 0x05, 0xb6, 0xae, 0x5f, 0xa0, 0xd1, 0xd3, 0x55, 0xae, 0x07, 0xd7, 0xff, 0x7c, 0xec,
	0x7d, 0xf1, 0xb7, 0xb0, 0xe9, 0x95, 0xf1, 0x47, 0x05, 0xca, 0x33, 0x57, 0x49, 0xf4, 0xf9, 0x52,
	0x64, 0xf3, 0xd7, 0xf3, 0xbd, 0xc7, 0xab, 0x03, 0x93, 0x29, 0x1c, 0x7d, 0xf8, 0xed, 0x07, 0x4b,
	0xfd, 0xa3, 0xeb, 0x15, 0x65, 0x17, 0xfa, 0xf4, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x56, 0xb6,
	0xf1, 0xd1, 0x01, 0x0e, 0x00, 0x00,
}
