// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: main.proto

/*
Package TwitchBeefcakeTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	main.proto
*/
package TwitchBeefcakeTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ========================
// TwitchBeefcake Interface
// ========================

type TwitchBeefcake interface {
	// GetRoles gets all role
	GetRoles(context.Context, *GetRolesRequest) (*GetRolesResponse, error)

	// CreateRole creates a role
	CreateRole(context.Context, *CreateRoleRequest) (*CreateRoleResponse, error)

	// GetRole gets a role
	GetRole(context.Context, *GetRoleRequest) (*Role, error)

	// UpdateRole updates an existing role
	UpdateRole(context.Context, *UpdateRoleRequest) (*UpdateRoleResponse, error)

	// OverrideRole overrides all permissions for a role
	OverrideRole(context.Context, *OverrideRoleRequest) (*OverrideRoleResponse, error)

	// DeleteRole deletes a role
	DeleteRole(context.Context, *DeleteRoleRequest) (*DeleteRoleResponse, error)

	// AddRolePermission adds a permission for a role
	AddRolePermission(context.Context, *AddRolePermissionRequest) (*AddRolePermissionResponse, error)

	// RemoveRolePermission removes a permission for a role
	RemoveRolePermission(context.Context, *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error)

	// UpdateRolePermissionScope updates the scope of a permission for a role.
	// Permissions by default apply to all objects but this will scope a permission
	// to a list of beefcake.PermissionScope.
	//
	// An example would be the Support role with the tos_ban permission. They will
	// be able to tos_ban anyone. If the scope were limited to
	// PermissionScope_ChannelPayoutType_NO_PAYOUT_TYPE, they would only be able
	// to tos_ban on users that have no payout type (i.e. non-partner,
	// non-affiliate, non-developer).
	UpdateRolePermissionScope(context.Context, *UpdateRolePermissionScopeRequest) (*UpdateRolePermissionScopeResponse, error)

	// Add a legacy string permission to a role
	AddLegacyPermissionToRole(context.Context, *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error)

	// Remove a legacy string permission to a role
	RemoveLegacyPermissionFromRole(context.Context, *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error)

	// AddUserToRole adds a user to a role
	AddUserToRole(context.Context, *AddUserToRoleRequest) (*AddUserToRoleResponse, error)

	// RemoveUserFromRole removes a user to a role
	RemoveUserFromRole(context.Context, *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error)

	// User returns a user
	GetUser(context.Context, *GetUserRequest) (*User, error)

	// GetLegacyPermissions returns a single legacy permission
	GetLegacyPermissions(context.Context, *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error)

	// CreateLegacyPermission creates a legacy permission
	CreateLegacyPermission(context.Context, *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error)

	// GetLegacyPermission returns a single legacy permission
	GetLegacyPermission(context.Context, *GetLegacyPermissionRequest) (*LegacyPermission, error)

	// UpdateLegacyPermission updates a legacy permission
	UpdateLegacyPermission(context.Context, *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error)

	// DeleteLegacyPermission deletes a legacy permission
	DeleteLegacyPermission(context.Context, *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error)
}

// ==============================
// TwitchBeefcake Protobuf Client
// ==============================

type twitchBeefcakeProtobufClient struct {
	client HTTPClient
	urls   [19]string
}

// NewTwitchBeefcakeProtobufClient creates a Protobuf client that implements the TwitchBeefcake interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchBeefcakeProtobufClient(addr string, client HTTPClient) TwitchBeefcake {
	prefix := urlBase(addr) + TwitchBeefcakePathPrefix
	urls := [19]string{
		prefix + "GetRoles",
		prefix + "CreateRole",
		prefix + "GetRole",
		prefix + "UpdateRole",
		prefix + "OverrideRole",
		prefix + "DeleteRole",
		prefix + "AddRolePermission",
		prefix + "RemoveRolePermission",
		prefix + "UpdateRolePermissionScope",
		prefix + "AddLegacyPermissionToRole",
		prefix + "RemoveLegacyPermissionFromRole",
		prefix + "AddUserToRole",
		prefix + "RemoveUserFromRole",
		prefix + "GetUser",
		prefix + "GetLegacyPermissions",
		prefix + "CreateLegacyPermission",
		prefix + "GetLegacyPermission",
		prefix + "UpdateLegacyPermission",
		prefix + "DeleteLegacyPermission",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &twitchBeefcakeProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &twitchBeefcakeProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *twitchBeefcakeProtobufClient) GetRoles(ctx context.Context, in *GetRolesRequest) (*GetRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	out := new(GetRolesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) CreateRole(ctx context.Context, in *CreateRoleRequest) (*CreateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	out := new(CreateRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) GetRole(ctx context.Context, in *GetRoleRequest) (*Role, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	out := new(Role)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	out := new(UpdateRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) OverrideRole(ctx context.Context, in *OverrideRoleRequest) (*OverrideRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	out := new(OverrideRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	out := new(DeleteRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) AddRolePermission(ctx context.Context, in *AddRolePermissionRequest) (*AddRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	out := new(AddRolePermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) RemoveRolePermission(ctx context.Context, in *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	out := new(RemoveRolePermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) UpdateRolePermissionScope(ctx context.Context, in *UpdateRolePermissionScopeRequest) (*UpdateRolePermissionScopeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	out := new(UpdateRolePermissionScopeResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) AddLegacyPermissionToRole(ctx context.Context, in *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	out := new(AddLegacyPermissionToRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) RemoveLegacyPermissionFromRole(ctx context.Context, in *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	out := new(RemoveLegacyPermissionFromRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) AddUserToRole(ctx context.Context, in *AddUserToRoleRequest) (*AddUserToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	out := new(AddUserToRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) RemoveUserFromRole(ctx context.Context, in *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	out := new(RemoveUserFromRoleResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) GetUser(ctx context.Context, in *GetUserRequest) (*User, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(User)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) GetLegacyPermissions(ctx context.Context, in *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	out := new(GetLegacyPermissionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) CreateLegacyPermission(ctx context.Context, in *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	out := new(CreateLegacyPermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) GetLegacyPermission(ctx context.Context, in *GetLegacyPermissionRequest) (*LegacyPermission, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	out := new(LegacyPermission)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) UpdateLegacyPermission(ctx context.Context, in *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	out := new(UpdateLegacyPermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	return out, err
}

func (c *twitchBeefcakeProtobufClient) DeleteLegacyPermission(ctx context.Context, in *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	out := new(DeleteLegacyPermissionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	return out, err
}

// ==========================
// TwitchBeefcake JSON Client
// ==========================

type twitchBeefcakeJSONClient struct {
	client HTTPClient
	urls   [19]string
}

// NewTwitchBeefcakeJSONClient creates a JSON client that implements the TwitchBeefcake interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchBeefcakeJSONClient(addr string, client HTTPClient) TwitchBeefcake {
	prefix := urlBase(addr) + TwitchBeefcakePathPrefix
	urls := [19]string{
		prefix + "GetRoles",
		prefix + "CreateRole",
		prefix + "GetRole",
		prefix + "UpdateRole",
		prefix + "OverrideRole",
		prefix + "DeleteRole",
		prefix + "AddRolePermission",
		prefix + "RemoveRolePermission",
		prefix + "UpdateRolePermissionScope",
		prefix + "AddLegacyPermissionToRole",
		prefix + "RemoveLegacyPermissionFromRole",
		prefix + "AddUserToRole",
		prefix + "RemoveUserFromRole",
		prefix + "GetUser",
		prefix + "GetLegacyPermissions",
		prefix + "CreateLegacyPermission",
		prefix + "GetLegacyPermission",
		prefix + "UpdateLegacyPermission",
		prefix + "DeleteLegacyPermission",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &twitchBeefcakeJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &twitchBeefcakeJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *twitchBeefcakeJSONClient) GetRoles(ctx context.Context, in *GetRolesRequest) (*GetRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	out := new(GetRolesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) CreateRole(ctx context.Context, in *CreateRoleRequest) (*CreateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	out := new(CreateRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) GetRole(ctx context.Context, in *GetRoleRequest) (*Role, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	out := new(Role)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	out := new(UpdateRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) OverrideRole(ctx context.Context, in *OverrideRoleRequest) (*OverrideRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	out := new(OverrideRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	out := new(DeleteRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) AddRolePermission(ctx context.Context, in *AddRolePermissionRequest) (*AddRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	out := new(AddRolePermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) RemoveRolePermission(ctx context.Context, in *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	out := new(RemoveRolePermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) UpdateRolePermissionScope(ctx context.Context, in *UpdateRolePermissionScopeRequest) (*UpdateRolePermissionScopeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	out := new(UpdateRolePermissionScopeResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) AddLegacyPermissionToRole(ctx context.Context, in *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	out := new(AddLegacyPermissionToRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) RemoveLegacyPermissionFromRole(ctx context.Context, in *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	out := new(RemoveLegacyPermissionFromRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) AddUserToRole(ctx context.Context, in *AddUserToRoleRequest) (*AddUserToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	out := new(AddUserToRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) RemoveUserFromRole(ctx context.Context, in *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	out := new(RemoveUserFromRoleResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) GetUser(ctx context.Context, in *GetUserRequest) (*User, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(User)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) GetLegacyPermissions(ctx context.Context, in *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	out := new(GetLegacyPermissionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) CreateLegacyPermission(ctx context.Context, in *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	out := new(CreateLegacyPermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) GetLegacyPermission(ctx context.Context, in *GetLegacyPermissionRequest) (*LegacyPermission, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	out := new(LegacyPermission)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) UpdateLegacyPermission(ctx context.Context, in *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	out := new(UpdateLegacyPermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	return out, err
}

func (c *twitchBeefcakeJSONClient) DeleteLegacyPermission(ctx context.Context, in *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	out := new(DeleteLegacyPermissionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	return out, err
}

// =============================
// TwitchBeefcake Server Handler
// =============================

type twitchBeefcakeServer struct {
	TwitchBeefcake
	hooks *twirp.ServerHooks
}

func NewTwitchBeefcakeServer(svc TwitchBeefcake, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchBeefcakeServer{
		TwitchBeefcake: svc,
		hooks:          hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchBeefcakeServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchBeefcakePathPrefix is used for all URL paths on a twirp TwitchBeefcake server.
// Requests are always: POST TwitchBeefcakePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchBeefcakePathPrefix = "/twirp/twitch.fulton.beefcake.TwitchBeefcake/"

func (s *twitchBeefcakeServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetRoles":
		s.serveGetRoles(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/CreateRole":
		s.serveCreateRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetRole":
		s.serveGetRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/UpdateRole":
		s.serveUpdateRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/OverrideRole":
		s.serveOverrideRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/DeleteRole":
		s.serveDeleteRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/AddRolePermission":
		s.serveAddRolePermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/RemoveRolePermission":
		s.serveRemoveRolePermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/UpdateRolePermissionScope":
		s.serveUpdateRolePermissionScope(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/AddLegacyPermissionToRole":
		s.serveAddLegacyPermissionToRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/RemoveLegacyPermissionFromRole":
		s.serveRemoveLegacyPermissionFromRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/AddUserToRole":
		s.serveAddUserToRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/RemoveUserFromRole":
		s.serveRemoveUserFromRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetUser":
		s.serveGetUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetLegacyPermissions":
		s.serveGetLegacyPermissions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/CreateLegacyPermission":
		s.serveCreateLegacyPermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetLegacyPermission":
		s.serveGetLegacyPermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/UpdateLegacyPermission":
		s.serveUpdateLegacyPermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/DeleteLegacyPermission":
		s.serveDeleteLegacyPermission(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchBeefcakeServer) serveGetRoles(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRolesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRolesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetRolesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRolesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRolesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRolesResponse and nil error while calling GetRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetRolesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRolesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRolesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRolesResponse and nil error while calling GetRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveCreateRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoleResponse and nil error while calling CreateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoleResponse and nil error while calling CreateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Role
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Role and nil error while calling GetRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Role
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Role and nil error while calling GetRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveUpdateRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoleResponse and nil error while calling UpdateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoleResponse and nil error while calling UpdateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveOverrideRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOverrideRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOverrideRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveOverrideRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OverrideRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OverrideRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OverrideRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OverrideRoleResponse and nil error while calling OverrideRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveOverrideRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OverrideRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OverrideRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.OverrideRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OverrideRoleResponse and nil error while calling OverrideRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveDeleteRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoleResponse and nil error while calling DeleteRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoleResponse and nil error while calling DeleteRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddRolePermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddRolePermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddRolePermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveAddRolePermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddRolePermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddRolePermissionResponse and nil error while calling AddRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddRolePermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddRolePermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddRolePermissionResponse and nil error while calling AddRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveRolePermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveRolePermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveRolePermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveRemoveRolePermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveRolePermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveRolePermissionResponse and nil error while calling RemoveRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveRolePermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveRolePermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveRolePermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveRolePermissionResponse and nil error while calling RemoveRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRolePermissionScope(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRolePermissionScopeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRolePermissionScopeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveUpdateRolePermissionScopeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRolePermissionScopeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRolePermissionScopeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRolePermissionScope(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRolePermissionScopeResponse and nil error while calling UpdateRolePermissionScope. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRolePermissionScopeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRolePermissionScopeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRolePermissionScopeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRolePermissionScope(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRolePermissionScopeResponse and nil error while calling UpdateRolePermissionScope. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddLegacyPermissionToRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddLegacyPermissionToRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddLegacyPermissionToRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveAddLegacyPermissionToRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddLegacyPermissionToRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddLegacyPermissionToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddLegacyPermissionToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLegacyPermissionToRoleResponse and nil error while calling AddLegacyPermissionToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddLegacyPermissionToRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddLegacyPermissionToRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddLegacyPermissionToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddLegacyPermissionToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLegacyPermissionToRoleResponse and nil error while calling AddLegacyPermissionToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveLegacyPermissionFromRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveLegacyPermissionFromRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveLegacyPermissionFromRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveRemoveLegacyPermissionFromRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveLegacyPermissionFromRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveLegacyPermissionFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveLegacyPermissionFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveLegacyPermissionFromRoleResponse and nil error while calling RemoveLegacyPermissionFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveLegacyPermissionFromRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveLegacyPermissionFromRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveLegacyPermissionFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveLegacyPermissionFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveLegacyPermissionFromRoleResponse and nil error while calling RemoveLegacyPermissionFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddUserToRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddUserToRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddUserToRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveAddUserToRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddUserToRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddUserToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddUserToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserToRoleResponse and nil error while calling AddUserToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddUserToRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AddUserToRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AddUserToRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AddUserToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserToRoleResponse and nil error while calling AddUserToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveUserFromRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveUserFromRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveUserFromRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveRemoveUserFromRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveUserFromRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveUserFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveUserFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserFromRoleResponse and nil error while calling RemoveUserFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveUserFromRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveUserFromRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveUserFromRoleResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RemoveUserFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserFromRoleResponse and nil error while calling RemoveUserFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *User
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *User and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *User
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *User and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyPermissionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyPermissionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyPermissionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyPermissionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermissions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyPermissionsResponse and nil error while calling GetLegacyPermissions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLegacyPermissionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyPermissionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermissions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyPermissionsResponse and nil error while calling GetLegacyPermissions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveCreateLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLegacyPermissionResponse and nil error while calling CreateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLegacyPermissionResponse and nil error while calling CreateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LegacyPermission
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LegacyPermission and nil error while calling GetLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LegacyPermission
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LegacyPermission and nil error while calling GetLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveUpdateLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLegacyPermissionResponse and nil error while calling UpdateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLegacyPermissionResponse and nil error while calling UpdateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveDeleteLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLegacyPermissionResponse and nil error while calling DeleteLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteLegacyPermissionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLegacyPermissionResponse and nil error while calling DeleteLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchBeefcakeServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1644 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x4f, 0x73, 0xd3, 0xd6,
	0x16, 0x8f, 0x6c, 0x27, 0x21, 0xc7, 0xc4, 0xd8, 0x17, 0x13, 0x8c, 0x48, 0xf2, 0xfc, 0xc4, 0x3c,
	0x12, 0x78, 0x41, 0x01, 0xd3, 0x52, 0xe8, 0x14, 0x66, 0x9c, 0x60, 0x88, 0x67, 0x02, 0xf1, 0x08,
	0x93, 0x16, 0xa6, 0x1d, 0x8f, 0x62, 0x5d, 0x12, 0xb5, 0xb6, 0xa5, 0x4a, 0x72, 0x42, 0xda, 0x55,
	0xa7, 0x8b, 0xee, 0x3a, 0xdd, 0x76, 0xd5, 0x76, 0xd5, 0x6e, 0xba, 0x29, 0x33, 0xfd, 0x16, 0xdd,
	0x74, 0xd3, 0x6f, 0xd1, 0x0d, 0x5f, 0xa0, 0x73, 0xa5, 0x1b, 0xeb, 0xef, 0x95, 0xe4, 0x10, 0x16,
	0xdd, 0x59, 0xbe, 0xe7, 0xcf, 0xef, 0x9e, 0x7b, 0xcf, 0xef, 0x9e, 0x73, 0x00, 0xfa, 0xb2, 0x3a,
	0x10, 0x75, 0x43, 0xb3, 0x34, 0x34, 0x67, 0x1d, 0xa8, 0x56, 0x77, 0x4f, 0x7c, 0x31, 0xec, 0x59,
	0xda, 0x40, 0xdc, 0xc1, 0xf8, 0x45, 0x57, 0xfe, 0x0c, 0xf3, 0xff, 0xd9, 0xd5, 0xb4, 0xdd, 0x1e,
	0x5e, 0xb5, 0xa5, 0x76, 0x86, 0x2f, 0x56, 0x2d, 0xb5, 0x8f, 0x4d, 0x4b, 0xee, 0xeb, 0x8e, 0x22,
	0xbf, 0x18, 0x14, 0x38, 0x30, 0x64, 0x5d, 0xc7, 0x86, 0xe9, 0xac, 0x0b, 0x4b, 0x50, 0x5a, 0x37,
	0xb0, 0x6c, 0x61, 0x49, 0xeb, 0x61, 0x09, 0x7f, 0x3e, 0xc4, 0xa6, 0x85, 0x10, 0xe4, 0x06, 0x72,
	0x1f, 0x57, 0xb8, 0x2a, 0xb7, 0x3c, 0x23, 0xd9, 0xbf, 0x85, 0xdb, 0x80, 0xbc, 0x82, 0xa6, 0xae,
	0x0d, 0x4c, 0x8c, 0x0a, 0x90, 0x51, 0x15, 0x2a, 0x97, 0x51, 0x95, 0x91, 0x66, 0xc6, 0xa3, 0x79,
	0x00, 0x95, 0xba, 0xa2, 0x10, 0xb5, 0x16, 0x36, 0xfa, 0xaa, 0x69, 0xaa, 0xda, 0xe0, 0xc8, 0xd3,
	0x79, 0x98, 0x36, 0xb4, 0x1e, 0xee, 0x8c, 0x8c, 0x4c, 0x91, 0xcf, 0xa6, 0x82, 0xd6, 0x00, 0xf4,
	0x91, 0xb4, 0x6d, 0x2e, 0x5f, 0x13, 0xc4, 0xe8, 0x28, 0x88, 0x1e, 0xbb, 0x1e, 0x2d, 0xe1, 0x22,
	0x5c, 0x88, 0x70, 0xec, 0x20, 0x17, 0xfa, 0x50, 0xad, 0x2b, 0xca, 0x26, 0xde, 0x95, 0xbb, 0x87,
	0xee, 0x72, 0x5b, 0xf3, 0xc6, 0x81, 0x89, 0xee, 0x3a, 0x94, 0x7b, 0xb6, 0x66, 0xc7, 0x75, 0x47,
	0xa4, 0x9c, 0x6d, 0xa3, 0x5e, 0xc0, 0x6a, 0x53, 0x11, 0x2e, 0xc1, 0x7f, 0x63, 0xdc, 0x51, 0x4c,
	0x06, 0xfc, 0x4f, 0xc2, 0x7d, 0x6d, 0x1f, 0x07, 0xe5, 0x1e, 0x18, 0x5a, 0xff, 0x2d, 0x01, 0x5b,
	0x86, 0xcb, 0x49, 0x3e, 0x29, 0xba, 0xbf, 0x38, 0x38, 0xbb, 0xb5, 0x8f, 0x0d, 0x43, 0x55, 0x7c,
	0xb7, 0x25, 0xc5, 0x1d, 0x40, 0xf7, 0x21, 0xef, 0x02, 0x32, 0x2b, 0xd9, 0x6a, 0x36, 0xe5, 0x79,
	0x7a, 0xd5, 0xd0, 0x36, 0x14, 0x87, 0x26, 0x36, 0x3a, 0x7d, 0xdc, 0xdf, 0xc1, 0x86, 0xb9, 0xa7,
	0xea, 0x66, 0x25, 0x67, 0x9b, 0xfa, 0x3f, 0xcb, 0x14, 0x01, 0x2a, 0x3e, 0x35, 0xb1, 0xf1, 0x68,
	0xa4, 0x23, 0x9d, 0x19, 0xfa, 0xbe, 0x4d, 0x61, 0x0e, 0xca, 0xfe, 0x8d, 0xd1, 0x1d, 0x97, 0xe0,
	0xcc, 0x43, 0x6c, 0x91, 0xbf, 0x4c, 0xba, 0x59, 0xe1, 0x6b, 0x0e, 0x8a, 0xee, 0x7f, 0x34, 0x0b,
	0xd6, 0x61, 0x92, 0xc4, 0xdf, 0xac, 0x70, 0x36, 0x98, 0x6b, 0x2c, 0x30, 0x41, 0x45, 0x1b, 0x9d,
	0xe4, 0xe8, 0xf2, 0x57, 0x21, 0x47, 0x3e, 0x53, 0xa5, 0x54, 0x15, 0x0a, 0xd4, 0x16, 0xe3, 0x10,
	0x84, 0xd7, 0x99, 0xf4, 0xe6, 0x22, 0xe3, 0x9a, 0x7d, 0xf3, 0xb8, 0xa2, 0x4d, 0xff, 0xa9, 0x3b,
	0x47, 0x75, 0x95, 0x65, 0xb2, 0x6e, 0x59, 0x72, 0x77, 0x0f, 0x2b, 0x8c, 0xd3, 0xe7, 0x7f, 0xe4,
	0xa0, 0xe0, 0xf7, 0x48, 0xf2, 0xc0, 0x06, 0xee, 0xe6, 0x01, 0xf9, 0x6c, 0x2a, 0xe8, 0x7d, 0x00,
	0xfc, 0x52, 0x57, 0x0d, 0xd9, 0x72, 0xe9, 0x83, 0x17, 0x1d, 0x2e, 0x14, 0x8f, 0xb8, 0x50, 0x6c,
	0x1f, 0x91, 0xa5, 0xe4, 0x91, 0x46, 0x77, 0x00, 0x14, 0xd9, 0xc2, 0x1d, 0x59, 0x51, 0xb0, 0x52,
	0xc9, 0x26, 0xea, 0xce, 0x10, 0xe9, 0x3a, 0x11, 0x16, 0x96, 0xa1, 0xf8, 0xc4, 0x32, 0xd4, 0xc1,
	0x6e, 0xdd, 0x30, 0xe4, 0xc3, 0x6d, 0xb9, 0x37, 0xc4, 0xa8, 0x0c, 0x93, 0xfb, 0xe4, 0x87, 0x7d,
	0x39, 0x66, 0x24, 0xe7, 0x43, 0x78, 0xc5, 0x41, 0xe9, 0xa9, 0xae, 0x04, 0x88, 0x37, 0x78, 0x58,
	0xd7, 0x3d, 0x87, 0x95, 0xaf, 0xcd, 0x87, 0x40, 0x38, 0xce, 0x6c, 0x3f, 0xf4, 0x28, 0x3f, 0x86,
	0x73, 0x51, 0x04, 0x60, 0xd2, 0x7d, 0x2c, 0xb3, 0x82, 0x1f, 0x84, 0x2d, 0x9d, 0x0d, 0x73, 0x85,
	0x29, 0x94, 0x01, 0x79, 0x41, 0xd3, 0x34, 0x51, 0xe0, 0xa2, 0x43, 0x21, 0x63, 0x72, 0xfc, 0x0a,
	0x20, 0x7b, 0x21, 0x8a, 0xaa, 0x8a, 0x86, 0xcf, 0x56, 0x53, 0x11, 0x16, 0x61, 0x3e, 0xda, 0x0b,
	0x45, 0xf1, 0x0b, 0x07, 0x55, 0x17, 0x9c, 0x2b, 0xf0, 0xa4, 0xab, 0xe9, 0xf8, 0x64, 0xb1, 0xa0,
	0xbb, 0x30, 0x69, 0x12, 0xb3, 0x34, 0x4b, 0x96, 0x92, 0x89, 0xcc, 0x41, 0xe1, 0x68, 0x91, 0xc7,
	0x20, 0x06, 0x29, 0xdd, 0xcf, 0xf7, 0x1c, 0x94, 0xeb, 0x8a, 0x42, 0x6e, 0x7c, 0xca, 0x57, 0xc9,
	0x93, 0x0d, 0x19, 0x5f, 0x36, 0x6c, 0xc1, 0x39, 0x37, 0xb5, 0x3b, 0x9e, 0xc4, 0x48, 0xbe, 0xdc,
	0x65, 0x57, 0xb1, 0x31, 0xd2, 0x13, 0xce, 0xc3, 0xb9, 0x00, 0x34, 0x0a, 0xfa, 0x11, 0x5c, 0x70,
	0x0e, 0x89, 0xac, 0xa5, 0x7e, 0xb5, 0x58, 0xc0, 0x85, 0x79, 0xe0, 0xa3, 0xcc, 0x51, 0x67, 0x97,
	0xa0, 0x74, 0x1f, 0xf7, 0x70, 0x6c, 0x0a, 0x91, 0x2b, 0xeb, 0x15, 0xa2, 0xaa, 0x0e, 0x81, 0x12,
	0xab, 0x2c, 0xbd, 0x3f, 0xb2, 0x90, 0x23, 0xeb, 0xa1, 0x9c, 0xdc, 0x06, 0xfb, 0x3e, 0xf8, 0xc8,
	0x32, 0x13, 0x4f, 0x96, 0xc4, 0x8e, 0xcd, 0x98, 0x5e, 0xb2, 0x34, 0x7c, 0xdf, 0x21, 0xb2, 0xcc,
	0xbe, 0x19, 0x59, 0x7e, 0x9b, 0x81, 0x82, 0xdf, 0x63, 0xaa, 0x97, 0xe0, 0xa4, 0x6f, 0xca, 0xc9,
	0x3e, 0x01, 0x01, 0x6a, 0x9e, 0x1c, 0x87, 0x9a, 0x17, 0xe0, 0xe2, 0x43, 0x6c, 0x05, 0x8b, 0x9c,
	0xd1, 0xbb, 0xfe, 0x37, 0x07, 0xf3, 0xd1, 0xeb, 0xf4, 0x8d, 0xb7, 0x00, 0x85, 0x88, 0xf5, 0xe8,
	0xc1, 0x6f, 0xc4, 0x3c, 0xf8, 0x4c, 0x8b, 0x62, 0x70, 0x45, 0x2a, 0x05, 0x29, 0xd7, 0xe4, 0x3f,
	0x82, 0x62, 0x50, 0x2c, 0xd5, 0x39, 0x56, 0x21, 0xaf, 0x60, 0xb3, 0x6b, 0xa8, 0xfa, 0xe8, 0xf4,
	0x66, 0x24, 0xef, 0x5f, 0x02, 0x86, 0x05, 0xa7, 0x9e, 0x0f, 0xc1, 0x18, 0xa3, 0xac, 0x4b, 0x76,
	0x53, 0x85, 0x45, 0x96, 0x1b, 0x9a, 0x8a, 0x2b, 0xc0, 0x47, 0x84, 0x89, 0x95, 0x96, 0xaf, 0x72,
	0x6f, 0x2b, 0x22, 0x6e, 0x15, 0x97, 0x8b, 0xaf, 0xe2, 0x82, 0xee, 0xbd, 0x55, 0x1c, 0x31, 0x42,
	0xb8, 0xcb, 0xac, 0x4c, 0x8e, 0x69, 0xc4, 0xe6, 0x22, 0x47, 0x97, 0xff, 0x7d, 0x9c, 0xe2, 0x6d,
	0x97, 0x59, 0xbc, 0x7d, 0x30, 0xd6, 0x0e, 0x92, 0xaa, 0xb9, 0x7f, 0x41, 0xfd, 0xc5, 0xcf, 0x45,
	0x73, 0xb6, 0xf0, 0x13, 0x07, 0x0b, 0xce, 0x8b, 0x9b, 0xf6, 0xb6, 0x8f, 0x5f, 0x79, 0xdd, 0x0b,
	0x5f, 0xb0, 0x24, 0xc5, 0x60, 0xa6, 0xb0, 0x20, 0xd2, 0x4c, 0x59, 0x85, 0x05, 0xe7, 0x29, 0x4b,
	0x9b, 0x2c, 0x55, 0x58, 0x64, 0x29, 0x50, 0x93, 0xbf, 0xe6, 0x00, 0x3c, 0x89, 0xf4, 0x08, 0xa6,
	0x1c, 0x0e, 0xb2, 0x8d, 0xe4, 0x6b, 0x37, 0x93, 0x0b, 0x9b, 0xd0, 0x65, 0xda, 0x98, 0x90, 0xa8,
	0x11, 0xf4, 0x1c, 0xf2, 0x8e, 0x7e, 0x87, 0x5c, 0x0b, 0x1a, 0xcb, 0xf7, 0x52, 0xd8, 0x6c, 0xdb,
	0x12, 0xe4, 0x28, 0x7d, 0x76, 0xc1, 0x1a, 0xfd, 0xcf, 0xdf, 0x3a, 0x1e, 0x0f, 0xf0, 0xbf, 0x65,
	0xa0, 0x1c, 0x65, 0x1e, 0x3d, 0x87, 0x29, 0xb9, 0x6b, 0x1f, 0x1d, 0x31, 0x50, 0xa8, 0xad, 0x1d,
	0x13, 0xa7, 0x58, 0xb7, 0xad, 0xb4, 0x0f, 0x75, 0x2c, 0x51, 0x8b, 0xe8, 0x43, 0xc8, 0xca, 0x83,
	0x43, 0x1a, 0x80, 0xf5, 0x63, 0x1b, 0x1e, 0x1c, 0x4a, 0xd8, 0xd4, 0x86, 0x46, 0x17, 0x6f, 0x4c,
	0x48, 0xc4, 0x22, 0xba, 0x0c, 0x05, 0x4f, 0x84, 0x49, 0x1e, 0xda, 0xc4, 0xb6, 0x31, 0x21, 0x9d,
	0x76, 0x63, 0xd5, 0x54, 0xf8, 0x59, 0xc8, 0x7b, 0xb4, 0x05, 0x01, 0xc0, 0x45, 0x89, 0xa6, 0x21,
	0x5b, 0x7f, 0xfc, 0xac, 0x38, 0x81, 0xf2, 0x30, 0xfd, 0xb0, 0xd1, 0xee, 0xb4, 0x9a, 0xcd, 0x22,
	0xb7, 0x06, 0x70, 0xca, 0xa0, 0xf2, 0x6b, 0xd3, 0xb4, 0x87, 0x11, 0x7e, 0xe6, 0x00, 0x85, 0x1f,
	0xe9, 0x50, 0xe0, 0x4f, 0x60, 0x7a, 0xf3, 0xa6, 0x35, 0xf6, 0x9f, 0x1c, 0x9c, 0x09, 0x2c, 0xa1,
	0x1d, 0x28, 0x74, 0xf7, 0xe4, 0xc1, 0x00, 0xf7, 0x3a, 0xba, 0x7c, 0xa8, 0x0d, 0x2d, 0x7a, 0xd4,
	0x77, 0x52, 0xda, 0x16, 0xd7, 0x1d, 0xed, 0x96, 0xad, 0x4c, 0x62, 0xb7, 0x31, 0x21, 0xcd, 0x76,
	0xbd, 0x7f, 0x0a, 0x12, 0x94, 0x42, 0x52, 0x08, 0x41, 0xe1, 0xf1, 0x56, 0xa7, 0x55, 0x7f, 0xb6,
	0xf5, 0xb4, 0xdd, 0x69, 0x3f, 0x6b, 0x35, 0x8a, 0x13, 0x68, 0x16, 0x66, 0xea, 0x0f, 0x1e, 0x34,
	0x37, 0x9b, 0xf5, 0x76, 0xa3, 0xc8, 0x91, 0xd8, 0xb7, 0xea, 0x52, 0xfb, 0x71, 0x43, 0x2a, 0x66,
	0xc8, 0xda, 0xfd, 0xc6, 0x76, 0x63, 0x73, 0xab, 0xd5, 0x90, 0x8a, 0x59, 0x12, 0x7e, 0x7b, 0x53,
	0xb5, 0xd7, 0x25, 0x28, 0x38, 0x57, 0x63, 0x8d, 0x42, 0x44, 0x9f, 0xc0, 0xa9, 0xa3, 0xb1, 0x02,
	0x5a, 0x4a, 0x1e, 0x3c, 0xd8, 0x44, 0xc1, 0x2f, 0xa7, 0x9d, 0x50, 0xa0, 0x2e, 0x80, 0x3b, 0xf6,
	0x43, 0x57, 0x58, 0x7a, 0xa1, 0x19, 0x22, 0x7f, 0x35, 0x8d, 0x28, 0x75, 0xb2, 0x05, 0xd3, 0xd4,
	0x31, 0xba, 0x9c, 0x80, 0xec, 0xc8, 0xfc, 0x7c, 0xdc, 0x60, 0x82, 0xa0, 0x76, 0x1b, 0x2c, 0x36,
	0xea, 0x50, 0x03, 0xce, 0x46, 0x1d, 0x6e, 0x7b, 0x91, 0x0a, 0xa7, 0xbd, 0x53, 0x23, 0xc4, 0x2c,
	0xff, 0x23, 0x86, 0x66, 0xfc, 0x4a, 0x3a, 0x61, 0xf7, 0x14, 0xdc, 0x26, 0x86, 0xbd, 0x9f, 0x50,
	0x37, 0xc4, 0xde, 0x4f, 0xb8, 0x27, 0x42, 0x2f, 0xa1, 0x14, 0x1a, 0x97, 0xa2, 0xeb, 0xcc, 0x52,
	0x9d, 0x31, 0xd2, 0xe5, 0x6f, 0x8c, 0xa1, 0x41, 0x3d, 0x7f, 0xc5, 0x41, 0x39, 0xaa, 0xb7, 0x47,
	0xcc, 0xf7, 0x27, 0x66, 0xde, 0xc0, 0xbf, 0x33, 0x9e, 0x12, 0xc5, 0xf0, 0x1d, 0x07, 0x17, 0x98,
	0x4d, 0x39, 0xba, 0x9d, 0x7c, 0x2f, 0xa2, 0x27, 0x0e, 0xfc, 0x9d, 0x63, 0x68, 0x7a, 0x20, 0x31,
	0x87, 0xc6, 0x6c, 0x48, 0x49, 0x63, 0x6d, 0x36, 0xa4, 0xc4, 0x09, 0x35, 0xfa, 0x81, 0x83, 0xc5,
	0xf8, 0x71, 0x31, 0xba, 0x1b, 0x1f, 0xfe, 0x84, 0xd1, 0x36, 0x7f, 0xef, 0xb8, 0xea, 0x14, 0x61,
	0x0f, 0x66, 0x7d, 0xa3, 0x09, 0xb4, 0x12, 0xb3, 0xdb, 0xd0, 0x70, 0x85, 0xbf, 0x96, 0x52, 0x9a,
	0x7a, 0xfb, 0x12, 0x50, 0x78, 0x40, 0x81, 0x6e, 0xc4, 0xef, 0x21, 0x62, 0x36, 0xc2, 0xd7, 0xc6,
	0x51, 0xf1, 0xd1, 0xa6, 0x5d, 0xf0, 0xc6, 0xd1, 0xa6, 0x67, 0xca, 0xc1, 0xa6, 0x4d, 0xdb, 0x0a,
	0xc9, 0xc3, 0xa8, 0x96, 0x95, 0x9d, 0x87, 0x31, 0x2d, 0x35, 0x3b, 0x0f, 0x63, 0xfb, 0xec, 0x6f,
	0x38, 0x98, 0x8b, 0xee, 0x18, 0xd1, 0xbb, 0xf1, 0x4f, 0x0a, 0xa3, 0x2a, 0xe6, 0x6f, 0x8d, 0xab,
	0x46, 0x91, 0x98, 0x70, 0x36, 0x02, 0x29, 0xaa, 0x8d, 0xb1, 0xad, 0xc4, 0xf7, 0x36, 0x64, 0x9d,
	0x6c, 0x3f, 0xba, 0x0d, 0x60, 0x6f, 0x3f, 0xb6, 0xb3, 0x61, 0x6f, 0x3f, 0xbe, 0xdb, 0xb0, 0x91,
	0x44, 0x77, 0x0f, 0x6c, 0x24, 0xb1, 0xed, 0x09, 0x1b, 0x49, 0x7c, 0x93, 0xb2, 0x76, 0xe5, 0xf9,
	0x52, 0x57, 0x53, 0xb0, 0xf8, 0xe9, 0xd0, 0xb4, 0xd4, 0x81, 0x68, 0xed, 0xaf, 0xca, 0xfd, 0x2f,
	0x06, 0xab, 0xfe, 0x42, 0xa8, 0x7d, 0xa0, 0x1a, 0xfa, 0xce, 0x94, 0xdd, 0x67, 0xdd, 0xfc, 0x27,
	0x00, 0x00, 0xff, 0xff, 0x56, 0x6b, 0x50, 0xbf, 0x3c, 0x1d, 0x00, 0x00,
}
