// Code generated by protoc-gen-go. DO NOT EDIT.
// source: rpc/chatrooms/chatrooms.proto

/*
Package chatrooms is a generated protocol buffer package.

It is generated from these files:
	rpc/chatrooms/chatrooms.proto

It has these top-level messages:
	JoinChannelRequest
	JoinChannelResponse
	LeaveChannelRequest
	LeaveChannelResponse
	ListMembersRequest
	ListMembersResponse
	IsChannelMemberRequest
	IsChannelMemberResponse
	GetRoomRequest
	GetRoomResponse
	CreateRoomRequest
	RoomPermissions
	RoomPermissionsUpdate
	CreateRoomResponse
	DeleteRoomRequest
	DeleteRoomResponse
	UpdateRoomRequest
	UpdateRoomResponse
	UpdateRoomViewRequest
	UpdateRoomViewResponse
	UpdateRoomModesRequest
	UpdateRoomModesResponse
	ListRoomsRequest
	ListRoomsResponse
	BulkGetRoomViewsRequest
	BulkGetRoomViewsResponse
	SendMessageRequest
	SendMessageResponse
	EditMessageRequest
	EditMessageResponse
	DeleteMessageRequest
	DeleteMessageResponse
	ListMessagesRequest
	ListMessagesResponse
	GetChannelPropertiesRequest
	GetChannelPropertiesResponse
	RoleTypeValue
	Room
	Modes
	RoomView
	Permissions
	MemberResult
	Member
	MessageResult
	Message
	MessageChange
	MessageContent
	MessageContentFragment
	MessageContentFragmentEmoticon
	MessageContentFragmentCheermote
	MessageContentFragmentGroupMention
	MessageContentFragmentLink
	MessageContentFragmentLinkEmbed
	MessageContentFragmentAutoMod
	TwitchEmbedMetadata
	TwitchClipMetadata
	TwitchVODMetadata
	TwitchStreamMetadata
	TwitchEventMetadata
	MessageContentFragmentMention
	MessageSender
	UserBadge
*/
package chatrooms

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/duration"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"
import google_protobuf2 "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SortOrder specifies whether to sort ascending or descending
type SortOrder int32

const (
	SortOrder_DEFAULT    SortOrder = 0
	SortOrder_DESCENDING SortOrder = 1
	SortOrder_ASCENDING  SortOrder = 2
)

var SortOrder_name = map[int32]string{
	0: "DEFAULT",
	1: "DESCENDING",
	2: "ASCENDING",
}
var SortOrder_value = map[string]int32{
	"DEFAULT":    0,
	"DESCENDING": 1,
	"ASCENDING":  2,
}

func (x SortOrder) String() string {
	return proto.EnumName(SortOrder_name, int32(x))
}
func (SortOrder) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// RoleType defines the role a user must be to be eligible to join a room.
type RoleType int32

const (
	RoleType_EVERYONE    RoleType = 0
	RoleType_MODERATOR   RoleType = 1
	RoleType_PRIVATE     RoleType = 2
	RoleType_BROADCASTER RoleType = 3
	RoleType_SUBSCRIBER  RoleType = 5
)

var RoleType_name = map[int32]string{
	0: "EVERYONE",
	1: "MODERATOR",
	2: "PRIVATE",
	3: "BROADCASTER",
	5: "SUBSCRIBER",
}
var RoleType_value = map[string]int32{
	"EVERYONE":    0,
	"MODERATOR":   1,
	"PRIVATE":     2,
	"BROADCASTER": 3,
	"SUBSCRIBER":  5,
}

func (x RoleType) String() string {
	return proto.EnumName(RoleType_name, int32(x))
}
func (RoleType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Type of user used to bucket users in the chatter list
type MemberType int32

const (
	MemberType_UNUSED    MemberType = 0
	MemberType_OWNER     MemberType = 1
	MemberType_STAFF     MemberType = 2
	MemberType_ADMIN     MemberType = 3
	MemberType_GLOBALMOD MemberType = 4
	MemberType_MOD       MemberType = 5
	MemberType_REGULAR   MemberType = 15
)

var MemberType_name = map[int32]string{
	0:  "UNUSED",
	1:  "OWNER",
	2:  "STAFF",
	3:  "ADMIN",
	4:  "GLOBALMOD",
	5:  "MOD",
	15: "REGULAR",
}
var MemberType_value = map[string]int32{
	"UNUSED":    0,
	"OWNER":     1,
	"STAFF":     2,
	"ADMIN":     3,
	"GLOBALMOD": 4,
	"MOD":       5,
	"REGULAR":   15,
}

func (x MemberType) String() string {
	return proto.EnumName(MemberType_name, int32(x))
}
func (MemberType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// MentionType describes the type of mention in a message. E.g. @here or mentioning a specific user (@bob).
type MentionType int32

const (
	MentionType_USER_MENTION MentionType = 0
	MentionType_HERE_MENTION MentionType = 1
)

var MentionType_name = map[int32]string{
	0: "USER_MENTION",
	1: "HERE_MENTION",
}
var MentionType_value = map[string]int32{
	"USER_MENTION": 0,
	"HERE_MENTION": 1,
}

func (x MentionType) String() string {
	return proto.EnumName(MentionType_name, int32(x))
}
func (MentionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// TwitchType defines the type of Twitch media link
type TwitchType int32

const (
	TwitchType_NONE   TwitchType = 0
	TwitchType_CLIP   TwitchType = 1
	TwitchType_VOD    TwitchType = 2
	TwitchType_STREAM TwitchType = 3
	TwitchType_EVENT  TwitchType = 4
)

var TwitchType_name = map[int32]string{
	0: "NONE",
	1: "CLIP",
	2: "VOD",
	3: "STREAM",
	4: "EVENT",
}
var TwitchType_value = map[string]int32{
	"NONE":   0,
	"CLIP":   1,
	"VOD":    2,
	"STREAM": 3,
	"EVENT":  4,
}

func (x TwitchType) String() string {
	return proto.EnumName(TwitchType_name, int32(x))
}
func (TwitchType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// JoinChannelRequest is the body of the JoinChannel rpc method.
type JoinChannelRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *JoinChannelRequest) Reset()                    { *m = JoinChannelRequest{} }
func (m *JoinChannelRequest) String() string            { return proto.CompactTextString(m) }
func (*JoinChannelRequest) ProtoMessage()               {}
func (*JoinChannelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *JoinChannelRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *JoinChannelRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// JoinChannelResponse is the response to a JoinChannel rpc request.
type JoinChannelResponse struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *JoinChannelResponse) Reset()                    { *m = JoinChannelResponse{} }
func (m *JoinChannelResponse) String() string            { return proto.CompactTextString(m) }
func (*JoinChannelResponse) ProtoMessage()               {}
func (*JoinChannelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *JoinChannelResponse) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *JoinChannelResponse) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// LeaveChannelRequest is the response to a LeaveChannel rpc request.
type LeaveChannelRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *LeaveChannelRequest) Reset()                    { *m = LeaveChannelRequest{} }
func (m *LeaveChannelRequest) String() string            { return proto.CompactTextString(m) }
func (*LeaveChannelRequest) ProtoMessage()               {}
func (*LeaveChannelRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *LeaveChannelRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *LeaveChannelRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// LeaveChannelResponse is the response to a LeaveChannel rpc request.
type LeaveChannelResponse struct {
}

func (m *LeaveChannelResponse) Reset()                    { *m = LeaveChannelResponse{} }
func (m *LeaveChannelResponse) String() string            { return proto.CompactTextString(m) }
func (*LeaveChannelResponse) ProtoMessage()               {}
func (*LeaveChannelResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// ListMembersRequest is the body of a ListMembers rpc request.
type ListMembersRequest struct {
	RoomId            string `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId            string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Limit             int64  `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	Cursor            string `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	IgnorePermissions bool   `protobuf:"varint,5,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
}

func (m *ListMembersRequest) Reset()                    { *m = ListMembersRequest{} }
func (m *ListMembersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListMembersRequest) ProtoMessage()               {}
func (*ListMembersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListMembersRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *ListMembersRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ListMembersRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListMembersRequest) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

func (m *ListMembersRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

// ListMembersResponse is the response to a ListMembers rpc request
type ListMembersResponse struct {
	Results         []*MemberResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
	HasPreviousPage bool            `protobuf:"varint,2,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool            `protobuf:"varint,3,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *ListMembersResponse) Reset()                    { *m = ListMembersResponse{} }
func (m *ListMembersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListMembersResponse) ProtoMessage()               {}
func (*ListMembersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ListMembersResponse) GetResults() []*MemberResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListMembersResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *ListMembersResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

// IsChannelMemberRequest is the body of the IsChannelMember rpc request
type IsChannelMemberRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *IsChannelMemberRequest) Reset()                    { *m = IsChannelMemberRequest{} }
func (m *IsChannelMemberRequest) String() string            { return proto.CompactTextString(m) }
func (*IsChannelMemberRequest) ProtoMessage()               {}
func (*IsChannelMemberRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *IsChannelMemberRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsChannelMemberRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// IsChannelMemberResponse is the responst to a IsChannelMember rpc request
type IsChannelMemberResponse struct {
	IsChannelMember bool `protobuf:"varint,1,opt,name=is_channel_member,json=isChannelMember" json:"is_channel_member,omitempty"`
}

func (m *IsChannelMemberResponse) Reset()                    { *m = IsChannelMemberResponse{} }
func (m *IsChannelMemberResponse) String() string            { return proto.CompactTextString(m) }
func (*IsChannelMemberResponse) ProtoMessage()               {}
func (*IsChannelMemberResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *IsChannelMemberResponse) GetIsChannelMember() bool {
	if m != nil {
		return m.IsChannelMember
	}
	return false
}

// GetRoomRequest is the response to a GetRoom rpc request.
type GetRoomRequest struct {
	RoomId            string                        `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId            *google_protobuf2.StringValue `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	IgnorePermissions bool                          `protobuf:"varint,3,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
}

func (m *GetRoomRequest) Reset()                    { *m = GetRoomRequest{} }
func (m *GetRoomRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRoomRequest) ProtoMessage()               {}
func (*GetRoomRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GetRoomRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *GetRoomRequest) GetUserId() *google_protobuf2.StringValue {
	if m != nil {
		return m.UserId
	}
	return nil
}

func (m *GetRoomRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

// GetRoomResponse is the response to a GetRoom rpc request.
type GetRoomResponse struct {
	Room *Room `protobuf:"bytes,1,opt,name=room" json:"room,omitempty"`
}

func (m *GetRoomResponse) Reset()                    { *m = GetRoomResponse{} }
func (m *GetRoomResponse) String() string            { return proto.CompactTextString(m) }
func (*GetRoomResponse) ProtoMessage()               {}
func (*GetRoomResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *GetRoomResponse) GetRoom() *Room {
	if m != nil {
		return m.Room
	}
	return nil
}

// CreateRoomRequest is the response to a CreateRoom rpc request.
type CreateRoomRequest struct {
	OwnerType          string           `protobuf:"bytes,1,opt,name=owner_type,json=ownerType" json:"owner_type,omitempty"`
	OwnerId            string           `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Name               string           `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	Topic              string           `protobuf:"bytes,4,opt,name=topic" json:"topic,omitempty"`
	IsPreviewable      bool             `protobuf:"varint,10,opt,name=is_previewable,json=isPreviewable" json:"is_previewable,omitempty"`
	MinimumAllowedRole RoleType         `protobuf:"varint,11,opt,name=minimum_allowed_role,json=minimumAllowedRole,enum=code.justin.tv.chat.chatrooms.RoleType" json:"minimum_allowed_role,omitempty"`
	Permissions        *RoomPermissions `protobuf:"bytes,12,opt,name=permissions" json:"permissions,omitempty"`
}

func (m *CreateRoomRequest) Reset()                    { *m = CreateRoomRequest{} }
func (m *CreateRoomRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateRoomRequest) ProtoMessage()               {}
func (*CreateRoomRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateRoomRequest) GetOwnerType() string {
	if m != nil {
		return m.OwnerType
	}
	return ""
}

func (m *CreateRoomRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateRoomRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateRoomRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *CreateRoomRequest) GetIsPreviewable() bool {
	if m != nil {
		return m.IsPreviewable
	}
	return false
}

func (m *CreateRoomRequest) GetMinimumAllowedRole() RoleType {
	if m != nil {
		return m.MinimumAllowedRole
	}
	return RoleType_EVERYONE
}

func (m *CreateRoomRequest) GetPermissions() *RoomPermissions {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// RoomPermissions contains the roles required to perform actions in a room, such as reading or
// sending messages.
type RoomPermissions struct {
	Read  RoleType `protobuf:"varint,1,opt,name=read,enum=code.justin.tv.chat.chatrooms.RoleType" json:"read,omitempty"`
	Write RoleType `protobuf:"varint,2,opt,name=write,enum=code.justin.tv.chat.chatrooms.RoleType" json:"write,omitempty"`
}

func (m *RoomPermissions) Reset()                    { *m = RoomPermissions{} }
func (m *RoomPermissions) String() string            { return proto.CompactTextString(m) }
func (*RoomPermissions) ProtoMessage()               {}
func (*RoomPermissions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *RoomPermissions) GetRead() RoleType {
	if m != nil {
		return m.Read
	}
	return RoleType_EVERYONE
}

func (m *RoomPermissions) GetWrite() RoleType {
	if m != nil {
		return m.Write
	}
	return RoleType_EVERYONE
}

// RoomPermissionsUpdate is used to update the permissions of a room.
type RoomPermissionsUpdate struct {
	Read  *RoleTypeValue `protobuf:"bytes,1,opt,name=read" json:"read,omitempty"`
	Write *RoleTypeValue `protobuf:"bytes,2,opt,name=write" json:"write,omitempty"`
}

func (m *RoomPermissionsUpdate) Reset()                    { *m = RoomPermissionsUpdate{} }
func (m *RoomPermissionsUpdate) String() string            { return proto.CompactTextString(m) }
func (*RoomPermissionsUpdate) ProtoMessage()               {}
func (*RoomPermissionsUpdate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *RoomPermissionsUpdate) GetRead() *RoleTypeValue {
	if m != nil {
		return m.Read
	}
	return nil
}

func (m *RoomPermissionsUpdate) GetWrite() *RoleTypeValue {
	if m != nil {
		return m.Write
	}
	return nil
}

// CreateRoomResponse is the response to a CreateRoom rpc request.
type CreateRoomResponse struct {
	Room *Room `protobuf:"bytes,1,opt,name=room" json:"room,omitempty"`
}

func (m *CreateRoomResponse) Reset()                    { *m = CreateRoomResponse{} }
func (m *CreateRoomResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateRoomResponse) ProtoMessage()               {}
func (*CreateRoomResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *CreateRoomResponse) GetRoom() *Room {
	if m != nil {
		return m.Room
	}
	return nil
}

// DeleteRoomRequest is the response to a DeleteRoom rpc request.
type DeleteRoomRequest struct {
	RoomId            string `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	DeleterId         string `protobuf:"bytes,2,opt,name=deleter_id,json=deleterId" json:"deleter_id,omitempty"`
	IgnorePermissions bool   `protobuf:"varint,3,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
}

func (m *DeleteRoomRequest) Reset()                    { *m = DeleteRoomRequest{} }
func (m *DeleteRoomRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRoomRequest) ProtoMessage()               {}
func (*DeleteRoomRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *DeleteRoomRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *DeleteRoomRequest) GetDeleterId() string {
	if m != nil {
		return m.DeleterId
	}
	return ""
}

func (m *DeleteRoomRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

// DeleteRoomResponse is the response to a DeleteRoom rpc request.
type DeleteRoomResponse struct {
	Room *Room `protobuf:"bytes,1,opt,name=room" json:"room,omitempty"`
}

func (m *DeleteRoomResponse) Reset()                    { *m = DeleteRoomResponse{} }
func (m *DeleteRoomResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRoomResponse) ProtoMessage()               {}
func (*DeleteRoomResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *DeleteRoomResponse) GetRoom() *Room {
	if m != nil {
		return m.Room
	}
	return nil
}

// UpdateRoomRequest is the response to a UpdateRoom rpc request.
type UpdateRoomRequest struct {
	RoomId             string                        `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId             string                        `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Name               *google_protobuf2.StringValue `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
	Topic              *google_protobuf2.StringValue `protobuf:"bytes,6,opt,name=topic" json:"topic,omitempty"`
	IgnorePermissions  bool                          `protobuf:"varint,7,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
	IsPreviewable      *google_protobuf2.BoolValue   `protobuf:"bytes,10,opt,name=is_previewable,json=isPreviewable" json:"is_previewable,omitempty"`
	MinimumAllowedRole *RoleTypeValue                `protobuf:"bytes,11,opt,name=minimum_allowed_role,json=minimumAllowedRole" json:"minimum_allowed_role,omitempty"`
	Permissions        *RoomPermissionsUpdate        `protobuf:"bytes,12,opt,name=permissions" json:"permissions,omitempty"`
}

func (m *UpdateRoomRequest) Reset()                    { *m = UpdateRoomRequest{} }
func (m *UpdateRoomRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRoomRequest) ProtoMessage()               {}
func (*UpdateRoomRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *UpdateRoomRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *UpdateRoomRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UpdateRoomRequest) GetName() *google_protobuf2.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *UpdateRoomRequest) GetTopic() *google_protobuf2.StringValue {
	if m != nil {
		return m.Topic
	}
	return nil
}

func (m *UpdateRoomRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

func (m *UpdateRoomRequest) GetIsPreviewable() *google_protobuf2.BoolValue {
	if m != nil {
		return m.IsPreviewable
	}
	return nil
}

func (m *UpdateRoomRequest) GetMinimumAllowedRole() *RoleTypeValue {
	if m != nil {
		return m.MinimumAllowedRole
	}
	return nil
}

func (m *UpdateRoomRequest) GetPermissions() *RoomPermissionsUpdate {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// UpdateRoomResponse is the response to a UpdateRoom rpc request.
type UpdateRoomResponse struct {
	Room *Room `protobuf:"bytes,1,opt,name=room" json:"room,omitempty"`
}

func (m *UpdateRoomResponse) Reset()                    { *m = UpdateRoomResponse{} }
func (m *UpdateRoomResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateRoomResponse) ProtoMessage()               {}
func (*UpdateRoomResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *UpdateRoomResponse) GetRoom() *Room {
	if m != nil {
		return m.Room
	}
	return nil
}

// UpdateRoomViewRequest is the response to a UpdateRoomView rpc request.
type UpdateRoomViewRequest struct {
	RoomId                  string                      `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId                  string                      `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	LastReadAt              *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=last_read_at,json=lastReadAt" json:"last_read_at,omitempty"`
	IsMuted                 *google_protobuf2.BoolValue `protobuf:"bytes,4,opt,name=is_muted,json=isMuted" json:"is_muted,omitempty"`
	IsArchived              *google_protobuf2.BoolValue `protobuf:"bytes,5,opt,name=is_archived,json=isArchived" json:"is_archived,omitempty"`
	ResetUnreadMentionCount bool                        `protobuf:"varint,11,opt,name=reset_unread_mention_count,json=resetUnreadMentionCount" json:"reset_unread_mention_count,omitempty"`
}

func (m *UpdateRoomViewRequest) Reset()                    { *m = UpdateRoomViewRequest{} }
func (m *UpdateRoomViewRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRoomViewRequest) ProtoMessage()               {}
func (*UpdateRoomViewRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *UpdateRoomViewRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *UpdateRoomViewRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UpdateRoomViewRequest) GetLastReadAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.LastReadAt
	}
	return nil
}

func (m *UpdateRoomViewRequest) GetIsMuted() *google_protobuf2.BoolValue {
	if m != nil {
		return m.IsMuted
	}
	return nil
}

func (m *UpdateRoomViewRequest) GetIsArchived() *google_protobuf2.BoolValue {
	if m != nil {
		return m.IsArchived
	}
	return nil
}

func (m *UpdateRoomViewRequest) GetResetUnreadMentionCount() bool {
	if m != nil {
		return m.ResetUnreadMentionCount
	}
	return false
}

// UpdateRoomViewResponse is the response to a UpdateRoomView rpc request.
type UpdateRoomViewResponse struct {
	RoomView *RoomView `protobuf:"bytes,1,opt,name=room_view,json=roomView" json:"room_view,omitempty"`
}

func (m *UpdateRoomViewResponse) Reset()                    { *m = UpdateRoomViewResponse{} }
func (m *UpdateRoomViewResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateRoomViewResponse) ProtoMessage()               {}
func (*UpdateRoomViewResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *UpdateRoomViewResponse) GetRoomView() *RoomView {
	if m != nil {
		return m.RoomView
	}
	return nil
}

// UpdateRoomModesRequest is the response to a UpdateRoomModes rpc request.
type UpdateRoomModesRequest struct {
	RoomId               string                      `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId               string                      `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	EnableEmotesOnlyMode *google_protobuf2.BoolValue `protobuf:"bytes,3,opt,name=enable_emotes_only_mode,json=enableEmotesOnlyMode" json:"enable_emotes_only_mode,omitempty"`
	EnableR9KMode        *google_protobuf2.BoolValue `protobuf:"bytes,4,opt,name=enable_r9k_mode,json=enableR9kMode" json:"enable_r9k_mode,omitempty"`
	EnableSlowMode       *google_protobuf2.BoolValue `protobuf:"bytes,5,opt,name=enable_slow_mode,json=enableSlowMode" json:"enable_slow_mode,omitempty"`
	SlowModeDuration     *google_protobuf.Duration   `protobuf:"bytes,6,opt,name=slow_mode_duration,json=slowModeDuration" json:"slow_mode_duration,omitempty"`
}

func (m *UpdateRoomModesRequest) Reset()                    { *m = UpdateRoomModesRequest{} }
func (m *UpdateRoomModesRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRoomModesRequest) ProtoMessage()               {}
func (*UpdateRoomModesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *UpdateRoomModesRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *UpdateRoomModesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UpdateRoomModesRequest) GetEnableEmotesOnlyMode() *google_protobuf2.BoolValue {
	if m != nil {
		return m.EnableEmotesOnlyMode
	}
	return nil
}

func (m *UpdateRoomModesRequest) GetEnableR9KMode() *google_protobuf2.BoolValue {
	if m != nil {
		return m.EnableR9KMode
	}
	return nil
}

func (m *UpdateRoomModesRequest) GetEnableSlowMode() *google_protobuf2.BoolValue {
	if m != nil {
		return m.EnableSlowMode
	}
	return nil
}

func (m *UpdateRoomModesRequest) GetSlowModeDuration() *google_protobuf.Duration {
	if m != nil {
		return m.SlowModeDuration
	}
	return nil
}

// UpdateRoomModesResponse is the response to a UpdateRoomModes rpc request.
type UpdateRoomModesResponse struct {
	Room *Room `protobuf:"bytes,1,opt,name=room" json:"room,omitempty"`
}

func (m *UpdateRoomModesResponse) Reset()                    { *m = UpdateRoomModesResponse{} }
func (m *UpdateRoomModesResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateRoomModesResponse) ProtoMessage()               {}
func (*UpdateRoomModesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *UpdateRoomModesResponse) GetRoom() *Room {
	if m != nil {
		return m.Room
	}
	return nil
}

// ListRoomsRequest is the response to a ListRooms rpc request.
type ListRoomsRequest struct {
	OwnerType         string                        `protobuf:"bytes,1,opt,name=owner_type,json=ownerType" json:"owner_type,omitempty"`
	OwnerId           string                        `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	UserId            *google_protobuf2.StringValue `protobuf:"bytes,3,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	IgnorePermissions bool                          `protobuf:"varint,4,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
}

func (m *ListRoomsRequest) Reset()                    { *m = ListRoomsRequest{} }
func (m *ListRoomsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListRoomsRequest) ProtoMessage()               {}
func (*ListRoomsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ListRoomsRequest) GetOwnerType() string {
	if m != nil {
		return m.OwnerType
	}
	return ""
}

func (m *ListRoomsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *ListRoomsRequest) GetUserId() *google_protobuf2.StringValue {
	if m != nil {
		return m.UserId
	}
	return nil
}

func (m *ListRoomsRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

// ListRoomResponse is the response to a ListRoom rpc request.
type ListRoomsResponse struct {
	Rooms []*Room `protobuf:"bytes,1,rep,name=rooms" json:"rooms,omitempty"`
}

func (m *ListRoomsResponse) Reset()                    { *m = ListRoomsResponse{} }
func (m *ListRoomsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListRoomsResponse) ProtoMessage()               {}
func (*ListRoomsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListRoomsResponse) GetRooms() []*Room {
	if m != nil {
		return m.Rooms
	}
	return nil
}

// BulkGetRoomViewsRequest is the response to a BulkGetRoomViews rpc request.
type BulkGetRoomViewsRequest struct {
	UserId  *google_protobuf2.StringValue `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	RoomIds []string                      `protobuf:"bytes,2,rep,name=room_ids,json=roomIds" json:"room_ids,omitempty"`
}

func (m *BulkGetRoomViewsRequest) Reset()                    { *m = BulkGetRoomViewsRequest{} }
func (m *BulkGetRoomViewsRequest) String() string            { return proto.CompactTextString(m) }
func (*BulkGetRoomViewsRequest) ProtoMessage()               {}
func (*BulkGetRoomViewsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *BulkGetRoomViewsRequest) GetUserId() *google_protobuf2.StringValue {
	if m != nil {
		return m.UserId
	}
	return nil
}

func (m *BulkGetRoomViewsRequest) GetRoomIds() []string {
	if m != nil {
		return m.RoomIds
	}
	return nil
}

// ListRoomResponse is the response to a ListRoom rpc request.
type BulkGetRoomViewsResponse struct {
	RoomViews map[string]*RoomView `protobuf:"bytes,1,rep,name=room_views,json=roomViews" json:"room_views,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *BulkGetRoomViewsResponse) Reset()                    { *m = BulkGetRoomViewsResponse{} }
func (m *BulkGetRoomViewsResponse) String() string            { return proto.CompactTextString(m) }
func (*BulkGetRoomViewsResponse) ProtoMessage()               {}
func (*BulkGetRoomViewsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *BulkGetRoomViewsResponse) GetRoomViews() map[string]*RoomView {
	if m != nil {
		return m.RoomViews
	}
	return nil
}

// SendMessageRequest is the body of a SendMessage rpc request.
type SendMessageRequest struct {
	SenderId    string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	RoomId      string `protobuf:"bytes,2,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	MessageText string `protobuf:"bytes,3,opt,name=message_text,json=messageText" json:"message_text,omitempty"`
	BitsAmount  int64  `protobuf:"varint,10,opt,name=bits_amount,json=bitsAmount" json:"bits_amount,omitempty"`
	Nonce       string `protobuf:"bytes,15,opt,name=nonce" json:"nonce,omitempty"`
}

func (m *SendMessageRequest) Reset()                    { *m = SendMessageRequest{} }
func (m *SendMessageRequest) String() string            { return proto.CompactTextString(m) }
func (*SendMessageRequest) ProtoMessage()               {}
func (*SendMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *SendMessageRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *SendMessageRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *SendMessageRequest) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

func (m *SendMessageRequest) GetBitsAmount() int64 {
	if m != nil {
		return m.BitsAmount
	}
	return 0
}

func (m *SendMessageRequest) GetNonce() string {
	if m != nil {
		return m.Nonce
	}
	return ""
}

// SendMessageResponse is the response to a SendMessage rpc request.
type SendMessageResponse struct {
	Success      bool              `protobuf:"varint,1,opt,name=success" json:"success,omitempty"`
	Message      *Message          `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	ResponseCode string            `protobuf:"bytes,10,opt,name=response_code,json=responseCode" json:"response_code,omitempty"`
	ResponseArgs map[string]string `protobuf:"bytes,11,rep,name=response_args,json=responseArgs" json:"response_args,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SendMessageResponse) Reset()                    { *m = SendMessageResponse{} }
func (m *SendMessageResponse) String() string            { return proto.CompactTextString(m) }
func (*SendMessageResponse) ProtoMessage()               {}
func (*SendMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *SendMessageResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *SendMessageResponse) GetMessage() *Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *SendMessageResponse) GetResponseCode() string {
	if m != nil {
		return m.ResponseCode
	}
	return ""
}

func (m *SendMessageResponse) GetResponseArgs() map[string]string {
	if m != nil {
		return m.ResponseArgs
	}
	return nil
}

// EditMessageRequest is the response to a EditMessage rpc request.
type EditMessageRequest struct {
	MessageId   string `protobuf:"bytes,1,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
	EditorId    string `protobuf:"bytes,2,opt,name=editor_id,json=editorId" json:"editor_id,omitempty"`
	RoomId      string `protobuf:"bytes,3,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	MessageText string `protobuf:"bytes,4,opt,name=message_text,json=messageText" json:"message_text,omitempty"`
}

func (m *EditMessageRequest) Reset()                    { *m = EditMessageRequest{} }
func (m *EditMessageRequest) String() string            { return proto.CompactTextString(m) }
func (*EditMessageRequest) ProtoMessage()               {}
func (*EditMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *EditMessageRequest) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *EditMessageRequest) GetEditorId() string {
	if m != nil {
		return m.EditorId
	}
	return ""
}

func (m *EditMessageRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *EditMessageRequest) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

// EditMessageResponse is the response to a EditMessage rpc request.
type EditMessageResponse struct {
	Message *Message `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *EditMessageResponse) Reset()                    { *m = EditMessageResponse{} }
func (m *EditMessageResponse) String() string            { return proto.CompactTextString(m) }
func (*EditMessageResponse) ProtoMessage()               {}
func (*EditMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *EditMessageResponse) GetMessage() *Message {
	if m != nil {
		return m.Message
	}
	return nil
}

// DeleteMessageRequest is the response to a DeleteMessage rpc request.
type DeleteMessageRequest struct {
	MessageId         string `protobuf:"bytes,1,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
	DeleterId         string `protobuf:"bytes,2,opt,name=deleter_id,json=deleterId" json:"deleter_id,omitempty"`
	RoomId            string `protobuf:"bytes,3,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	IgnorePermissions bool   `protobuf:"varint,4,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
}

func (m *DeleteMessageRequest) Reset()                    { *m = DeleteMessageRequest{} }
func (m *DeleteMessageRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteMessageRequest) ProtoMessage()               {}
func (*DeleteMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *DeleteMessageRequest) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *DeleteMessageRequest) GetDeleterId() string {
	if m != nil {
		return m.DeleterId
	}
	return ""
}

func (m *DeleteMessageRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *DeleteMessageRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

// DeleteMessageResponse is the response to a DeleteMessage rpc request.
type DeleteMessageResponse struct {
	Message *Message `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *DeleteMessageResponse) Reset()                    { *m = DeleteMessageResponse{} }
func (m *DeleteMessageResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteMessageResponse) ProtoMessage()               {}
func (*DeleteMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *DeleteMessageResponse) GetMessage() *Message {
	if m != nil {
		return m.Message
	}
	return nil
}

// ListMessagesRequest is the response to a ListMessages rpc request.
type ListMessagesRequest struct {
	RoomId            string `protobuf:"bytes,1,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId            string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	IgnorePermissions bool   `protobuf:"varint,3,opt,name=ignore_permissions,json=ignorePermissions" json:"ignore_permissions,omitempty"`
	Limit             int64  `protobuf:"varint,10,opt,name=limit" json:"limit,omitempty"`
	// Types that are valid to be assigned to ListStart:
	//	*ListMessagesRequest_Cursor
	//	*ListMessagesRequest_FromTime
	ListStart      isListMessagesRequest_ListStart `protobuf_oneof:"list_start"`
	SortOrder      SortOrder                       `protobuf:"varint,12,opt,name=sort_order,json=sortOrder,enum=code.justin.tv.chat.chatrooms.SortOrder" json:"sort_order,omitempty"`
	IncludeHistory bool                            `protobuf:"varint,14,opt,name=include_history,json=includeHistory" json:"include_history,omitempty"`
}

func (m *ListMessagesRequest) Reset()                    { *m = ListMessagesRequest{} }
func (m *ListMessagesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListMessagesRequest) ProtoMessage()               {}
func (*ListMessagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

type isListMessagesRequest_ListStart interface{ isListMessagesRequest_ListStart() }

type ListMessagesRequest_Cursor struct {
	Cursor string `protobuf:"bytes,11,opt,name=cursor,oneof"`
}
type ListMessagesRequest_FromTime struct {
	FromTime *google_protobuf1.Timestamp `protobuf:"bytes,13,opt,name=from_time,json=fromTime,oneof"`
}

func (*ListMessagesRequest_Cursor) isListMessagesRequest_ListStart()   {}
func (*ListMessagesRequest_FromTime) isListMessagesRequest_ListStart() {}

func (m *ListMessagesRequest) GetListStart() isListMessagesRequest_ListStart {
	if m != nil {
		return m.ListStart
	}
	return nil
}

func (m *ListMessagesRequest) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *ListMessagesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ListMessagesRequest) GetIgnorePermissions() bool {
	if m != nil {
		return m.IgnorePermissions
	}
	return false
}

func (m *ListMessagesRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListMessagesRequest) GetCursor() string {
	if x, ok := m.GetListStart().(*ListMessagesRequest_Cursor); ok {
		return x.Cursor
	}
	return ""
}

func (m *ListMessagesRequest) GetFromTime() *google_protobuf1.Timestamp {
	if x, ok := m.GetListStart().(*ListMessagesRequest_FromTime); ok {
		return x.FromTime
	}
	return nil
}

func (m *ListMessagesRequest) GetSortOrder() SortOrder {
	if m != nil {
		return m.SortOrder
	}
	return SortOrder_DEFAULT
}

func (m *ListMessagesRequest) GetIncludeHistory() bool {
	if m != nil {
		return m.IncludeHistory
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListMessagesRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListMessagesRequest_OneofMarshaler, _ListMessagesRequest_OneofUnmarshaler, _ListMessagesRequest_OneofSizer, []interface{}{
		(*ListMessagesRequest_Cursor)(nil),
		(*ListMessagesRequest_FromTime)(nil),
	}
}

func _ListMessagesRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListMessagesRequest)
	// list_start
	switch x := m.ListStart.(type) {
	case *ListMessagesRequest_Cursor:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Cursor)
	case *ListMessagesRequest_FromTime:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FromTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListMessagesRequest.ListStart has unexpected type %T", x)
	}
	return nil
}

func _ListMessagesRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListMessagesRequest)
	switch tag {
	case 11: // list_start.cursor
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ListStart = &ListMessagesRequest_Cursor{x}
		return true, err
	case 13: // list_start.from_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ListStart = &ListMessagesRequest_FromTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListMessagesRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListMessagesRequest)
	// list_start
	switch x := m.ListStart.(type) {
	case *ListMessagesRequest_Cursor:
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Cursor)))
		n += len(x.Cursor)
	case *ListMessagesRequest_FromTime:
		s := proto.Size(x.FromTime)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ListMessagesResponse is the response to a ListMessages rpc request.
type ListMessagesResponse struct {
	Results         []*MessageResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
	HasPreviousPage bool             `protobuf:"varint,2,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool             `protobuf:"varint,3,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *ListMessagesResponse) Reset()                    { *m = ListMessagesResponse{} }
func (m *ListMessagesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListMessagesResponse) ProtoMessage()               {}
func (*ListMessagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *ListMessagesResponse) GetResults() []*MessageResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListMessagesResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *ListMessagesResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

type GetChannelPropertiesRequest struct {
	OwnerType string `protobuf:"bytes,1,opt,name=owner_type,json=ownerType" json:"owner_type,omitempty"`
	OwnerId   string `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetChannelPropertiesRequest) Reset()                    { *m = GetChannelPropertiesRequest{} }
func (m *GetChannelPropertiesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelPropertiesRequest) ProtoMessage()               {}
func (*GetChannelPropertiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *GetChannelPropertiesRequest) GetOwnerType() string {
	if m != nil {
		return m.OwnerType
	}
	return ""
}

func (m *GetChannelPropertiesRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetChannelPropertiesResponse struct {
	MaxAllowedRooms int64 `protobuf:"varint,1,opt,name=max_allowed_rooms,json=maxAllowedRooms" json:"max_allowed_rooms,omitempty"`
}

func (m *GetChannelPropertiesResponse) Reset()                    { *m = GetChannelPropertiesResponse{} }
func (m *GetChannelPropertiesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetChannelPropertiesResponse) ProtoMessage()               {}
func (*GetChannelPropertiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *GetChannelPropertiesResponse) GetMaxAllowedRooms() int64 {
	if m != nil {
		return m.MaxAllowedRooms
	}
	return 0
}

// RoleTypeValue wraps a RoleType in a message so it can be used as an optional field.
type RoleTypeValue struct {
	Value RoleType `protobuf:"varint,1,opt,name=value,enum=code.justin.tv.chat.chatrooms.RoleType" json:"value,omitempty"`
}

func (m *RoleTypeValue) Reset()                    { *m = RoleTypeValue{} }
func (m *RoleTypeValue) String() string            { return proto.CompactTextString(m) }
func (*RoleTypeValue) ProtoMessage()               {}
func (*RoleTypeValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *RoleTypeValue) GetValue() RoleType {
	if m != nil {
		return m.Value
	}
	return RoleType_EVERYONE
}

// Room defines a chatroom that may have messages sent to it.
type Room struct {
	Id                 string           `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	OwnerType          string           `protobuf:"bytes,2,opt,name=owner_type,json=ownerType" json:"owner_type,omitempty"`
	OwnerId            string           `protobuf:"bytes,3,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Name               string           `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	Topic              string           `protobuf:"bytes,5,opt,name=topic" json:"topic,omitempty"`
	IsPreviewable      bool             `protobuf:"varint,10,opt,name=is_previewable,json=isPreviewable" json:"is_previewable,omitempty"`
	MinimumAllowedRole RoleType         `protobuf:"varint,11,opt,name=minimum_allowed_role,json=minimumAllowedRole,enum=code.justin.tv.chat.chatrooms.RoleType" json:"minimum_allowed_role,omitempty"`
	Permissions        *RoomPermissions `protobuf:"bytes,13,opt,name=permissions" json:"permissions,omitempty"`
	Modes              *Modes           `protobuf:"bytes,12,opt,name=modes" json:"modes,omitempty"`
	MemberCount        int64            `protobuf:"varint,15,opt,name=member_count,json=memberCount" json:"member_count,omitempty"`
}

func (m *Room) Reset()                    { *m = Room{} }
func (m *Room) String() string            { return proto.CompactTextString(m) }
func (*Room) ProtoMessage()               {}
func (*Room) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *Room) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Room) GetOwnerType() string {
	if m != nil {
		return m.OwnerType
	}
	return ""
}

func (m *Room) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Room) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Room) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Room) GetIsPreviewable() bool {
	if m != nil {
		return m.IsPreviewable
	}
	return false
}

func (m *Room) GetMinimumAllowedRole() RoleType {
	if m != nil {
		return m.MinimumAllowedRole
	}
	return RoleType_EVERYONE
}

func (m *Room) GetPermissions() *RoomPermissions {
	if m != nil {
		return m.Permissions
	}
	return nil
}

func (m *Room) GetModes() *Modes {
	if m != nil {
		return m.Modes
	}
	return nil
}

func (m *Room) GetMemberCount() int64 {
	if m != nil {
		return m.MemberCount
	}
	return 0
}

type Modes struct {
	SlowModeDuration      *google_protobuf.Duration `protobuf:"bytes,1,opt,name=slow_mode_duration,json=slowModeDuration" json:"slow_mode_duration,omitempty"`
	R9KModeEnabled        bool                      `protobuf:"varint,2,opt,name=r9k_mode_enabled,json=r9kModeEnabled" json:"r9k_mode_enabled,omitempty"`
	EmotesOnlyModeEnabled bool                      `protobuf:"varint,3,opt,name=emotes_only_mode_enabled,json=emotesOnlyModeEnabled" json:"emotes_only_mode_enabled,omitempty"`
}

func (m *Modes) Reset()                    { *m = Modes{} }
func (m *Modes) String() string            { return proto.CompactTextString(m) }
func (*Modes) ProtoMessage()               {}
func (*Modes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *Modes) GetSlowModeDuration() *google_protobuf.Duration {
	if m != nil {
		return m.SlowModeDuration
	}
	return nil
}

func (m *Modes) GetR9KModeEnabled() bool {
	if m != nil {
		return m.R9KModeEnabled
	}
	return false
}

func (m *Modes) GetEmotesOnlyModeEnabled() bool {
	if m != nil {
		return m.EmotesOnlyModeEnabled
	}
	return false
}

// RoomView defines per-user properties for a chatroom.
type RoomView struct {
	Id                 string                      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	RoomId             string                      `protobuf:"bytes,2,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	UserId             string                      `protobuf:"bytes,3,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	LastReadAt         *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=last_read_at,json=lastReadAt" json:"last_read_at,omitempty"`
	IsMuted            bool                        `protobuf:"varint,5,opt,name=is_muted,json=isMuted" json:"is_muted,omitempty"`
	IsArchived         bool                        `protobuf:"varint,6,opt,name=is_archived,json=isArchived" json:"is_archived,omitempty"`
	IsUnread           bool                        `protobuf:"varint,10,opt,name=is_unread,json=isUnread" json:"is_unread,omitempty"`
	UnreadMentionCount int64                       `protobuf:"varint,11,opt,name=unread_mention_count,json=unreadMentionCount" json:"unread_mention_count,omitempty"`
	Permissions        *Permissions                `protobuf:"bytes,12,opt,name=permissions" json:"permissions,omitempty"`
}

func (m *RoomView) Reset()                    { *m = RoomView{} }
func (m *RoomView) String() string            { return proto.CompactTextString(m) }
func (*RoomView) ProtoMessage()               {}
func (*RoomView) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *RoomView) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RoomView) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *RoomView) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *RoomView) GetLastReadAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.LastReadAt
	}
	return nil
}

func (m *RoomView) GetIsMuted() bool {
	if m != nil {
		return m.IsMuted
	}
	return false
}

func (m *RoomView) GetIsArchived() bool {
	if m != nil {
		return m.IsArchived
	}
	return false
}

func (m *RoomView) GetIsUnread() bool {
	if m != nil {
		return m.IsUnread
	}
	return false
}

func (m *RoomView) GetUnreadMentionCount() int64 {
	if m != nil {
		return m.UnreadMentionCount
	}
	return 0
}

func (m *RoomView) GetPermissions() *Permissions {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// Permissions represents the actions a user can take in a room
type Permissions struct {
	ReadMessages bool `protobuf:"varint,1,opt,name=read_messages,json=readMessages" json:"read_messages,omitempty"`
	SendMessages bool `protobuf:"varint,2,opt,name=send_messages,json=sendMessages" json:"send_messages,omitempty"`
	Moderate     bool `protobuf:"varint,3,opt,name=moderate" json:"moderate,omitempty"`
}

func (m *Permissions) Reset()                    { *m = Permissions{} }
func (m *Permissions) String() string            { return proto.CompactTextString(m) }
func (*Permissions) ProtoMessage()               {}
func (*Permissions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *Permissions) GetReadMessages() bool {
	if m != nil {
		return m.ReadMessages
	}
	return false
}

func (m *Permissions) GetSendMessages() bool {
	if m != nil {
		return m.SendMessages
	}
	return false
}

func (m *Permissions) GetModerate() bool {
	if m != nil {
		return m.Moderate
	}
	return false
}

// One element of a list of members
type MemberResult struct {
	Member *Member `protobuf:"bytes,1,opt,name=member" json:"member,omitempty"`
	Cursor string  `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
}

func (m *MemberResult) Reset()                    { *m = MemberResult{} }
func (m *MemberResult) String() string            { return proto.CompactTextString(m) }
func (*MemberResult) ProtoMessage()               {}
func (*MemberResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *MemberResult) GetMember() *Member {
	if m != nil {
		return m.Member
	}
	return nil
}

func (m *MemberResult) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

type Member struct {
	UserId string     `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Type   MemberType `protobuf:"varint,3,opt,name=type,enum=code.justin.tv.chat.chatrooms.MemberType" json:"type,omitempty"`
}

func (m *Member) Reset()                    { *m = Member{} }
func (m *Member) String() string            { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()               {}
func (*Member) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *Member) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Member) GetType() MemberType {
	if m != nil {
		return m.Type
	}
	return MemberType_UNUSED
}

// MessageResult defines a (Message, cursor) pair returned when a response expects a list of messages.
type MessageResult struct {
	Message *Message `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
	Cursor  string   `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
}

func (m *MessageResult) Reset()                    { *m = MessageResult{} }
func (m *MessageResult) String() string            { return proto.CompactTextString(m) }
func (*MessageResult) ProtoMessage()               {}
func (*MessageResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *MessageResult) GetMessage() *Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *MessageResult) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

// Message defines an individual chat message.
type Message struct {
	Id          string                      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	RoomId      string                      `protobuf:"bytes,2,opt,name=room_id,json=roomId" json:"room_id,omitempty"`
	SentAt      *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=sent_at,json=sentAt" json:"sent_at,omitempty"`
	IsPublished bool                        `protobuf:"varint,4,opt,name=is_published,json=isPublished" json:"is_published,omitempty"`
	DeletedAt   *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=deleted_at,json=deletedAt" json:"deleted_at,omitempty"`
	Content     *MessageContent             `protobuf:"bytes,10,opt,name=content" json:"content,omitempty"`
	Sender      *MessageSender              `protobuf:"bytes,11,opt,name=sender" json:"sender,omitempty"`
	History     []*MessageChange            `protobuf:"bytes,12,rep,name=history" json:"history,omitempty"`
	BitsAmount  int64                       `protobuf:"varint,13,opt,name=bits_amount,json=bitsAmount" json:"bits_amount,omitempty"`
}

func (m *Message) Reset()                    { *m = Message{} }
func (m *Message) String() string            { return proto.CompactTextString(m) }
func (*Message) ProtoMessage()               {}
func (*Message) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *Message) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Message) GetRoomId() string {
	if m != nil {
		return m.RoomId
	}
	return ""
}

func (m *Message) GetSentAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.SentAt
	}
	return nil
}

func (m *Message) GetIsPublished() bool {
	if m != nil {
		return m.IsPublished
	}
	return false
}

func (m *Message) GetDeletedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Message) GetContent() *MessageContent {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Message) GetSender() *MessageSender {
	if m != nil {
		return m.Sender
	}
	return nil
}

func (m *Message) GetHistory() []*MessageChange {
	if m != nil {
		return m.History
	}
	return nil
}

func (m *Message) GetBitsAmount() int64 {
	if m != nil {
		return m.BitsAmount
	}
	return 0
}

type MessageChange struct {
	UserId          *google_protobuf2.StringValue `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ActionType      string                        `protobuf:"bytes,2,opt,name=action_type,json=actionType" json:"action_type,omitempty"`
	UpdatedAt       *google_protobuf1.Timestamp   `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
	OriginalMessage *Message                      `protobuf:"bytes,4,opt,name=original_message,json=originalMessage" json:"original_message,omitempty"`
}

func (m *MessageChange) Reset()                    { *m = MessageChange{} }
func (m *MessageChange) String() string            { return proto.CompactTextString(m) }
func (*MessageChange) ProtoMessage()               {}
func (*MessageChange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *MessageChange) GetUserId() *google_protobuf2.StringValue {
	if m != nil {
		return m.UserId
	}
	return nil
}

func (m *MessageChange) GetActionType() string {
	if m != nil {
		return m.ActionType
	}
	return ""
}

func (m *MessageChange) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *MessageChange) GetOriginalMessage() *Message {
	if m != nil {
		return m.OriginalMessage
	}
	return nil
}

// MessageContent defines a message body and parsed metadata from the text.
type MessageContent struct {
	Text      string                    `protobuf:"bytes,1,opt,name=text" json:"text,omitempty"`
	Fragments []*MessageContentFragment `protobuf:"bytes,2,rep,name=fragments" json:"fragments,omitempty"`
}

func (m *MessageContent) Reset()                    { *m = MessageContent{} }
func (m *MessageContent) String() string            { return proto.CompactTextString(m) }
func (*MessageContent) ProtoMessage()               {}
func (*MessageContent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *MessageContent) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *MessageContent) GetFragments() []*MessageContentFragment {
	if m != nil {
		return m.Fragments
	}
	return nil
}

// MessageContentFragment defines fragments found in the message body.
type MessageContentFragment struct {
	Text         string                              `protobuf:"bytes,1,opt,name=text" json:"text,omitempty"`
	Emoticon     *MessageContentFragmentEmoticon     `protobuf:"bytes,5,opt,name=emoticon" json:"emoticon,omitempty"`
	UserMention  *MessageContentFragmentMention      `protobuf:"bytes,6,opt,name=user_mention,json=userMention" json:"user_mention,omitempty"`
	Link         *MessageContentFragmentLink         `protobuf:"bytes,7,opt,name=link" json:"link,omitempty"`
	GroupMention *MessageContentFragmentGroupMention `protobuf:"bytes,8,opt,name=group_mention,json=groupMention" json:"group_mention,omitempty"`
	Cheermote    *MessageContentFragmentCheermote    `protobuf:"bytes,9,opt,name=cheermote" json:"cheermote,omitempty"`
	Automod      *MessageContentFragmentAutoMod      `protobuf:"bytes,10,opt,name=automod" json:"automod,omitempty"`
}

func (m *MessageContentFragment) Reset()                    { *m = MessageContentFragment{} }
func (m *MessageContentFragment) String() string            { return proto.CompactTextString(m) }
func (*MessageContentFragment) ProtoMessage()               {}
func (*MessageContentFragment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *MessageContentFragment) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *MessageContentFragment) GetEmoticon() *MessageContentFragmentEmoticon {
	if m != nil {
		return m.Emoticon
	}
	return nil
}

func (m *MessageContentFragment) GetUserMention() *MessageContentFragmentMention {
	if m != nil {
		return m.UserMention
	}
	return nil
}

func (m *MessageContentFragment) GetLink() *MessageContentFragmentLink {
	if m != nil {
		return m.Link
	}
	return nil
}

func (m *MessageContentFragment) GetGroupMention() *MessageContentFragmentGroupMention {
	if m != nil {
		return m.GroupMention
	}
	return nil
}

func (m *MessageContentFragment) GetCheermote() *MessageContentFragmentCheermote {
	if m != nil {
		return m.Cheermote
	}
	return nil
}

func (m *MessageContentFragment) GetAutomod() *MessageContentFragmentAutoMod {
	if m != nil {
		return m.Automod
	}
	return nil
}

// MessageContentEmoticon defines emoticons found in the message body.
type MessageContentFragmentEmoticon struct {
	EmoticonID    string `protobuf:"bytes,1,opt,name=emoticonID" json:"emoticonID,omitempty"`
	EmoticonSetID string `protobuf:"bytes,2,opt,name=emoticonSetID" json:"emoticonSetID,omitempty"`
}

func (m *MessageContentFragmentEmoticon) Reset()                    { *m = MessageContentFragmentEmoticon{} }
func (m *MessageContentFragmentEmoticon) String() string            { return proto.CompactTextString(m) }
func (*MessageContentFragmentEmoticon) ProtoMessage()               {}
func (*MessageContentFragmentEmoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *MessageContentFragmentEmoticon) GetEmoticonID() string {
	if m != nil {
		return m.EmoticonID
	}
	return ""
}

func (m *MessageContentFragmentEmoticon) GetEmoticonSetID() string {
	if m != nil {
		return m.EmoticonSetID
	}
	return ""
}

// MessageContentCheermote defines cheermotes found in the message body.
type MessageContentFragmentCheermote struct {
	Prefix     string `protobuf:"bytes,1,opt,name=prefix" json:"prefix,omitempty"`
	BitsAmount int64  `protobuf:"varint,2,opt,name=bits_amount,json=bitsAmount" json:"bits_amount,omitempty"`
	Tier       int64  `protobuf:"varint,3,opt,name=tier" json:"tier,omitempty"`
}

func (m *MessageContentFragmentCheermote) Reset()         { *m = MessageContentFragmentCheermote{} }
func (m *MessageContentFragmentCheermote) String() string { return proto.CompactTextString(m) }
func (*MessageContentFragmentCheermote) ProtoMessage()    {}
func (*MessageContentFragmentCheermote) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{49}
}

func (m *MessageContentFragmentCheermote) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *MessageContentFragmentCheermote) GetBitsAmount() int64 {
	if m != nil {
		return m.BitsAmount
	}
	return 0
}

func (m *MessageContentFragmentCheermote) GetTier() int64 {
	if m != nil {
		return m.Tier
	}
	return 0
}

// MessageContentFragmentGroupMention is a fragment representing a group mention, such as @here.
type MessageContentFragmentGroupMention struct {
	Type MentionType `protobuf:"varint,1,opt,name=type,enum=code.justin.tv.chat.chatrooms.MentionType" json:"type,omitempty"`
}

func (m *MessageContentFragmentGroupMention) Reset()         { *m = MessageContentFragmentGroupMention{} }
func (m *MessageContentFragmentGroupMention) String() string { return proto.CompactTextString(m) }
func (*MessageContentFragmentGroupMention) ProtoMessage()    {}
func (*MessageContentFragmentGroupMention) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{50}
}

func (m *MessageContentFragmentGroupMention) GetType() MentionType {
	if m != nil {
		return m.Type
	}
	return MentionType_USER_MENTION
}

// MessageContentLink defines web URLs found in the message body.
type MessageContentFragmentLink struct {
	Host          string                           `protobuf:"bytes,1,opt,name=host" json:"host,omitempty"`
	EmbedMetadata *MessageContentFragmentLinkEmbed `protobuf:"bytes,2,opt,name=embed_metadata,json=embedMetadata" json:"embed_metadata,omitempty"`
}

func (m *MessageContentFragmentLink) Reset()                    { *m = MessageContentFragmentLink{} }
func (m *MessageContentFragmentLink) String() string            { return proto.CompactTextString(m) }
func (*MessageContentFragmentLink) ProtoMessage()               {}
func (*MessageContentFragmentLink) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *MessageContentFragmentLink) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *MessageContentFragmentLink) GetEmbedMetadata() *MessageContentFragmentLinkEmbed {
	if m != nil {
		return m.EmbedMetadata
	}
	return nil
}

// MessageContentFragmentLinkEmbed defines metadata for a rich media embed.
type MessageContentFragmentLinkEmbed struct {
	ErrorCode      string               `protobuf:"bytes,1,opt,name=error_code,json=errorCode" json:"error_code,omitempty"`
	RequestUrl     string               `protobuf:"bytes,2,opt,name=request_url,json=requestUrl" json:"request_url,omitempty"`
	Type           string               `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	Title          string               `protobuf:"bytes,4,opt,name=title" json:"title,omitempty"`
	Description    string               `protobuf:"bytes,5,opt,name=description" json:"description,omitempty"`
	AuthorName     string               `protobuf:"bytes,6,opt,name=author_name,json=authorName" json:"author_name,omitempty"`
	AuthorUrl      string               `protobuf:"bytes,7,opt,name=author_url,json=authorUrl" json:"author_url,omitempty"`
	ThumbnailUrl   string               `protobuf:"bytes,8,opt,name=thumbnail_url,json=thumbnailUrl" json:"thumbnail_url,omitempty"`
	ProviderName   string               `protobuf:"bytes,9,opt,name=provider_name,json=providerName" json:"provider_name,omitempty"`
	TwitchMetadata *TwitchEmbedMetadata `protobuf:"bytes,10,opt,name=twitch_metadata,json=twitchMetadata" json:"twitch_metadata,omitempty"`
}

func (m *MessageContentFragmentLinkEmbed) Reset()         { *m = MessageContentFragmentLinkEmbed{} }
func (m *MessageContentFragmentLinkEmbed) String() string { return proto.CompactTextString(m) }
func (*MessageContentFragmentLinkEmbed) ProtoMessage()    {}
func (*MessageContentFragmentLinkEmbed) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{52}
}

func (m *MessageContentFragmentLinkEmbed) GetErrorCode() string {
	if m != nil {
		return m.ErrorCode
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetRequestUrl() string {
	if m != nil {
		return m.RequestUrl
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetAuthorName() string {
	if m != nil {
		return m.AuthorName
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetAuthorUrl() string {
	if m != nil {
		return m.AuthorUrl
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetThumbnailUrl() string {
	if m != nil {
		return m.ThumbnailUrl
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetProviderName() string {
	if m != nil {
		return m.ProviderName
	}
	return ""
}

func (m *MessageContentFragmentLinkEmbed) GetTwitchMetadata() *TwitchEmbedMetadata {
	if m != nil {
		return m.TwitchMetadata
	}
	return nil
}

// MessageContentFragmentAutoMod defines metadata for auto moderated message content.
type MessageContentFragmentAutoMod struct {
	Topics map[string]int64 `protobuf:"bytes,1,rep,name=topics" json:"topics,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *MessageContentFragmentAutoMod) Reset()                    { *m = MessageContentFragmentAutoMod{} }
func (m *MessageContentFragmentAutoMod) String() string            { return proto.CompactTextString(m) }
func (*MessageContentFragmentAutoMod) ProtoMessage()               {}
func (*MessageContentFragmentAutoMod) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *MessageContentFragmentAutoMod) GetTopics() map[string]int64 {
	if m != nil {
		return m.Topics
	}
	return nil
}

// TwitchEmbedMetadata defines rich media metadata for some types of Twitch URLs.
type TwitchEmbedMetadata struct {
	TwitchType TwitchType            `protobuf:"varint,1,opt,name=twitch_type,json=twitchType,enum=code.justin.tv.chat.chatrooms.TwitchType" json:"twitch_type,omitempty"`
	Clip       *TwitchClipMetadata   `protobuf:"bytes,2,opt,name=clip" json:"clip,omitempty"`
	Vod        *TwitchVODMetadata    `protobuf:"bytes,3,opt,name=vod" json:"vod,omitempty"`
	Stream     *TwitchStreamMetadata `protobuf:"bytes,4,opt,name=stream" json:"stream,omitempty"`
	Event      *TwitchEventMetadata  `protobuf:"bytes,5,opt,name=event" json:"event,omitempty"`
}

func (m *TwitchEmbedMetadata) Reset()                    { *m = TwitchEmbedMetadata{} }
func (m *TwitchEmbedMetadata) String() string            { return proto.CompactTextString(m) }
func (*TwitchEmbedMetadata) ProtoMessage()               {}
func (*TwitchEmbedMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *TwitchEmbedMetadata) GetTwitchType() TwitchType {
	if m != nil {
		return m.TwitchType
	}
	return TwitchType_NONE
}

func (m *TwitchEmbedMetadata) GetClip() *TwitchClipMetadata {
	if m != nil {
		return m.Clip
	}
	return nil
}

func (m *TwitchEmbedMetadata) GetVod() *TwitchVODMetadata {
	if m != nil {
		return m.Vod
	}
	return nil
}

func (m *TwitchEmbedMetadata) GetStream() *TwitchStreamMetadata {
	if m != nil {
		return m.Stream
	}
	return nil
}

func (m *TwitchEmbedMetadata) GetEvent() *TwitchEventMetadata {
	if m != nil {
		return m.Event
	}
	return nil
}

// TwitchClipMetadata defines embed metadata for Twitch clips.
type TwitchClipMetadata struct {
	BroadcasterId      string                      `protobuf:"bytes,1,opt,name=broadcaster_id,json=broadcasterId" json:"broadcaster_id,omitempty"`
	BroadcasterLogin   string                      `protobuf:"bytes,2,opt,name=broadcaster_login,json=broadcasterLogin" json:"broadcaster_login,omitempty"`
	CreatedAt          *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	Game               string                      `protobuf:"bytes,4,opt,name=game" json:"game,omitempty"`
	VideoLengthSeconds int32                       `protobuf:"varint,5,opt,name=video_length_seconds,json=videoLengthSeconds" json:"video_length_seconds,omitempty"`
	ViewCount          int32                       `protobuf:"varint,6,opt,name=view_count,json=viewCount" json:"view_count,omitempty"`
}

func (m *TwitchClipMetadata) Reset()                    { *m = TwitchClipMetadata{} }
func (m *TwitchClipMetadata) String() string            { return proto.CompactTextString(m) }
func (*TwitchClipMetadata) ProtoMessage()               {}
func (*TwitchClipMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *TwitchClipMetadata) GetBroadcasterId() string {
	if m != nil {
		return m.BroadcasterId
	}
	return ""
}

func (m *TwitchClipMetadata) GetBroadcasterLogin() string {
	if m != nil {
		return m.BroadcasterLogin
	}
	return ""
}

func (m *TwitchClipMetadata) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *TwitchClipMetadata) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *TwitchClipMetadata) GetVideoLengthSeconds() int32 {
	if m != nil {
		return m.VideoLengthSeconds
	}
	return 0
}

func (m *TwitchClipMetadata) GetViewCount() int32 {
	if m != nil {
		return m.ViewCount
	}
	return 0
}

// TwitchVODMetadata defines embed metadata for Twitch VODs.
type TwitchVODMetadata struct {
	BroadcasterId      string                      `protobuf:"bytes,1,opt,name=broadcaster_id,json=broadcasterId" json:"broadcaster_id,omitempty"`
	BroadcasterLogin   string                      `protobuf:"bytes,2,opt,name=broadcaster_login,json=broadcasterLogin" json:"broadcaster_login,omitempty"`
	CreatedAt          *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	Game               string                      `protobuf:"bytes,4,opt,name=game" json:"game,omitempty"`
	VideoLengthSeconds int32                       `protobuf:"varint,5,opt,name=video_length_seconds,json=videoLengthSeconds" json:"video_length_seconds,omitempty"`
	ViewCount          int32                       `protobuf:"varint,6,opt,name=view_count,json=viewCount" json:"view_count,omitempty"`
}

func (m *TwitchVODMetadata) Reset()                    { *m = TwitchVODMetadata{} }
func (m *TwitchVODMetadata) String() string            { return proto.CompactTextString(m) }
func (*TwitchVODMetadata) ProtoMessage()               {}
func (*TwitchVODMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *TwitchVODMetadata) GetBroadcasterId() string {
	if m != nil {
		return m.BroadcasterId
	}
	return ""
}

func (m *TwitchVODMetadata) GetBroadcasterLogin() string {
	if m != nil {
		return m.BroadcasterLogin
	}
	return ""
}

func (m *TwitchVODMetadata) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *TwitchVODMetadata) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *TwitchVODMetadata) GetVideoLengthSeconds() int32 {
	if m != nil {
		return m.VideoLengthSeconds
	}
	return 0
}

func (m *TwitchVODMetadata) GetViewCount() int32 {
	if m != nil {
		return m.ViewCount
	}
	return 0
}

// TwitchStreamMetadata defines embed metadata for Twitch streams.
type TwitchStreamMetadata struct {
	BroadcasterId    string                      `protobuf:"bytes,1,opt,name=broadcaster_id,json=broadcasterId" json:"broadcaster_id,omitempty"`
	BroadcasterLogin string                      `protobuf:"bytes,2,opt,name=broadcaster_login,json=broadcasterLogin" json:"broadcaster_login,omitempty"`
	CreatedAt        *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	Game             string                      `protobuf:"bytes,4,opt,name=game" json:"game,omitempty"`
	StreamType       string                      `protobuf:"bytes,5,opt,name=stream_type,json=streamType" json:"stream_type,omitempty"`
	ViewCount        int32                       `protobuf:"varint,6,opt,name=view_count,json=viewCount" json:"view_count,omitempty"`
}

func (m *TwitchStreamMetadata) Reset()                    { *m = TwitchStreamMetadata{} }
func (m *TwitchStreamMetadata) String() string            { return proto.CompactTextString(m) }
func (*TwitchStreamMetadata) ProtoMessage()               {}
func (*TwitchStreamMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *TwitchStreamMetadata) GetBroadcasterId() string {
	if m != nil {
		return m.BroadcasterId
	}
	return ""
}

func (m *TwitchStreamMetadata) GetBroadcasterLogin() string {
	if m != nil {
		return m.BroadcasterLogin
	}
	return ""
}

func (m *TwitchStreamMetadata) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *TwitchStreamMetadata) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *TwitchStreamMetadata) GetStreamType() string {
	if m != nil {
		return m.StreamType
	}
	return ""
}

func (m *TwitchStreamMetadata) GetViewCount() int32 {
	if m != nil {
		return m.ViewCount
	}
	return 0
}

// TwitchEventMetadata defined embed metadata for Twitch events.
type TwitchEventMetadata struct {
	AuthorId    string                      `protobuf:"bytes,1,opt,name=author_id,json=authorId" json:"author_id,omitempty"`
	AuthorLogin string                      `protobuf:"bytes,2,opt,name=author_login,json=authorLogin" json:"author_login,omitempty"`
	Game        string                      `protobuf:"bytes,3,opt,name=game" json:"game,omitempty"`
	StartTime   *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	EndTime     *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *TwitchEventMetadata) Reset()                    { *m = TwitchEventMetadata{} }
func (m *TwitchEventMetadata) String() string            { return proto.CompactTextString(m) }
func (*TwitchEventMetadata) ProtoMessage()               {}
func (*TwitchEventMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *TwitchEventMetadata) GetAuthorId() string {
	if m != nil {
		return m.AuthorId
	}
	return ""
}

func (m *TwitchEventMetadata) GetAuthorLogin() string {
	if m != nil {
		return m.AuthorLogin
	}
	return ""
}

func (m *TwitchEventMetadata) GetGame() string {
	if m != nil {
		return m.Game
	}
	return ""
}

func (m *TwitchEventMetadata) GetStartTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TwitchEventMetadata) GetEndTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// MessageContentMention defines mentions found in the message body.
type MessageContentFragmentMention struct {
	UserID      string `protobuf:"bytes,1,opt,name=userID" json:"userID,omitempty"`
	Login       string `protobuf:"bytes,2,opt,name=login" json:"login,omitempty"`
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *MessageContentFragmentMention) Reset()                    { *m = MessageContentFragmentMention{} }
func (m *MessageContentFragmentMention) String() string            { return proto.CompactTextString(m) }
func (*MessageContentFragmentMention) ProtoMessage()               {}
func (*MessageContentFragmentMention) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

func (m *MessageContentFragmentMention) GetUserID() string {
	if m != nil {
		return m.UserID
	}
	return ""
}

func (m *MessageContentFragmentMention) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

func (m *MessageContentFragmentMention) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// MessageSender defines a user's render properties. These properties are
// snapshotted at the time the sender's message is created.
type MessageSender struct {
	UserId      string       `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Login       string       `protobuf:"bytes,2,opt,name=login" json:"login,omitempty"`
	DisplayName string       `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	ChatColor   string       `protobuf:"bytes,4,opt,name=chat_color,json=chatColor" json:"chat_color,omitempty"`
	Badges      []*UserBadge `protobuf:"bytes,5,rep,name=badges" json:"badges,omitempty"`
}

func (m *MessageSender) Reset()                    { *m = MessageSender{} }
func (m *MessageSender) String() string            { return proto.CompactTextString(m) }
func (*MessageSender) ProtoMessage()               {}
func (*MessageSender) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

func (m *MessageSender) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *MessageSender) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

func (m *MessageSender) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *MessageSender) GetChatColor() string {
	if m != nil {
		return m.ChatColor
	}
	return ""
}

func (m *MessageSender) GetBadges() []*UserBadge {
	if m != nil {
		return m.Badges
	}
	return nil
}

// UserBadge defines a user's chat badges that appear before their name.
type UserBadge struct {
	Id      string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (m *UserBadge) Reset()                    { *m = UserBadge{} }
func (m *UserBadge) String() string            { return proto.CompactTextString(m) }
func (*UserBadge) ProtoMessage()               {}
func (*UserBadge) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61} }

func (m *UserBadge) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UserBadge) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func init() {
	proto.RegisterType((*JoinChannelRequest)(nil), "code.justin.tv.chat.chatrooms.JoinChannelRequest")
	proto.RegisterType((*JoinChannelResponse)(nil), "code.justin.tv.chat.chatrooms.JoinChannelResponse")
	proto.RegisterType((*LeaveChannelRequest)(nil), "code.justin.tv.chat.chatrooms.LeaveChannelRequest")
	proto.RegisterType((*LeaveChannelResponse)(nil), "code.justin.tv.chat.chatrooms.LeaveChannelResponse")
	proto.RegisterType((*ListMembersRequest)(nil), "code.justin.tv.chat.chatrooms.ListMembersRequest")
	proto.RegisterType((*ListMembersResponse)(nil), "code.justin.tv.chat.chatrooms.ListMembersResponse")
	proto.RegisterType((*IsChannelMemberRequest)(nil), "code.justin.tv.chat.chatrooms.IsChannelMemberRequest")
	proto.RegisterType((*IsChannelMemberResponse)(nil), "code.justin.tv.chat.chatrooms.IsChannelMemberResponse")
	proto.RegisterType((*GetRoomRequest)(nil), "code.justin.tv.chat.chatrooms.GetRoomRequest")
	proto.RegisterType((*GetRoomResponse)(nil), "code.justin.tv.chat.chatrooms.GetRoomResponse")
	proto.RegisterType((*CreateRoomRequest)(nil), "code.justin.tv.chat.chatrooms.CreateRoomRequest")
	proto.RegisterType((*RoomPermissions)(nil), "code.justin.tv.chat.chatrooms.RoomPermissions")
	proto.RegisterType((*RoomPermissionsUpdate)(nil), "code.justin.tv.chat.chatrooms.RoomPermissionsUpdate")
	proto.RegisterType((*CreateRoomResponse)(nil), "code.justin.tv.chat.chatrooms.CreateRoomResponse")
	proto.RegisterType((*DeleteRoomRequest)(nil), "code.justin.tv.chat.chatrooms.DeleteRoomRequest")
	proto.RegisterType((*DeleteRoomResponse)(nil), "code.justin.tv.chat.chatrooms.DeleteRoomResponse")
	proto.RegisterType((*UpdateRoomRequest)(nil), "code.justin.tv.chat.chatrooms.UpdateRoomRequest")
	proto.RegisterType((*UpdateRoomResponse)(nil), "code.justin.tv.chat.chatrooms.UpdateRoomResponse")
	proto.RegisterType((*UpdateRoomViewRequest)(nil), "code.justin.tv.chat.chatrooms.UpdateRoomViewRequest")
	proto.RegisterType((*UpdateRoomViewResponse)(nil), "code.justin.tv.chat.chatrooms.UpdateRoomViewResponse")
	proto.RegisterType((*UpdateRoomModesRequest)(nil), "code.justin.tv.chat.chatrooms.UpdateRoomModesRequest")
	proto.RegisterType((*UpdateRoomModesResponse)(nil), "code.justin.tv.chat.chatrooms.UpdateRoomModesResponse")
	proto.RegisterType((*ListRoomsRequest)(nil), "code.justin.tv.chat.chatrooms.ListRoomsRequest")
	proto.RegisterType((*ListRoomsResponse)(nil), "code.justin.tv.chat.chatrooms.ListRoomsResponse")
	proto.RegisterType((*BulkGetRoomViewsRequest)(nil), "code.justin.tv.chat.chatrooms.BulkGetRoomViewsRequest")
	proto.RegisterType((*BulkGetRoomViewsResponse)(nil), "code.justin.tv.chat.chatrooms.BulkGetRoomViewsResponse")
	proto.RegisterType((*SendMessageRequest)(nil), "code.justin.tv.chat.chatrooms.SendMessageRequest")
	proto.RegisterType((*SendMessageResponse)(nil), "code.justin.tv.chat.chatrooms.SendMessageResponse")
	proto.RegisterType((*EditMessageRequest)(nil), "code.justin.tv.chat.chatrooms.EditMessageRequest")
	proto.RegisterType((*EditMessageResponse)(nil), "code.justin.tv.chat.chatrooms.EditMessageResponse")
	proto.RegisterType((*DeleteMessageRequest)(nil), "code.justin.tv.chat.chatrooms.DeleteMessageRequest")
	proto.RegisterType((*DeleteMessageResponse)(nil), "code.justin.tv.chat.chatrooms.DeleteMessageResponse")
	proto.RegisterType((*ListMessagesRequest)(nil), "code.justin.tv.chat.chatrooms.ListMessagesRequest")
	proto.RegisterType((*ListMessagesResponse)(nil), "code.justin.tv.chat.chatrooms.ListMessagesResponse")
	proto.RegisterType((*GetChannelPropertiesRequest)(nil), "code.justin.tv.chat.chatrooms.GetChannelPropertiesRequest")
	proto.RegisterType((*GetChannelPropertiesResponse)(nil), "code.justin.tv.chat.chatrooms.GetChannelPropertiesResponse")
	proto.RegisterType((*RoleTypeValue)(nil), "code.justin.tv.chat.chatrooms.RoleTypeValue")
	proto.RegisterType((*Room)(nil), "code.justin.tv.chat.chatrooms.Room")
	proto.RegisterType((*Modes)(nil), "code.justin.tv.chat.chatrooms.Modes")
	proto.RegisterType((*RoomView)(nil), "code.justin.tv.chat.chatrooms.RoomView")
	proto.RegisterType((*Permissions)(nil), "code.justin.tv.chat.chatrooms.Permissions")
	proto.RegisterType((*MemberResult)(nil), "code.justin.tv.chat.chatrooms.MemberResult")
	proto.RegisterType((*Member)(nil), "code.justin.tv.chat.chatrooms.Member")
	proto.RegisterType((*MessageResult)(nil), "code.justin.tv.chat.chatrooms.MessageResult")
	proto.RegisterType((*Message)(nil), "code.justin.tv.chat.chatrooms.Message")
	proto.RegisterType((*MessageChange)(nil), "code.justin.tv.chat.chatrooms.MessageChange")
	proto.RegisterType((*MessageContent)(nil), "code.justin.tv.chat.chatrooms.MessageContent")
	proto.RegisterType((*MessageContentFragment)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragment")
	proto.RegisterType((*MessageContentFragmentEmoticon)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentEmoticon")
	proto.RegisterType((*MessageContentFragmentCheermote)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentCheermote")
	proto.RegisterType((*MessageContentFragmentGroupMention)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentGroupMention")
	proto.RegisterType((*MessageContentFragmentLink)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentLink")
	proto.RegisterType((*MessageContentFragmentLinkEmbed)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentLinkEmbed")
	proto.RegisterType((*MessageContentFragmentAutoMod)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentAutoMod")
	proto.RegisterType((*TwitchEmbedMetadata)(nil), "code.justin.tv.chat.chatrooms.TwitchEmbedMetadata")
	proto.RegisterType((*TwitchClipMetadata)(nil), "code.justin.tv.chat.chatrooms.TwitchClipMetadata")
	proto.RegisterType((*TwitchVODMetadata)(nil), "code.justin.tv.chat.chatrooms.TwitchVODMetadata")
	proto.RegisterType((*TwitchStreamMetadata)(nil), "code.justin.tv.chat.chatrooms.TwitchStreamMetadata")
	proto.RegisterType((*TwitchEventMetadata)(nil), "code.justin.tv.chat.chatrooms.TwitchEventMetadata")
	proto.RegisterType((*MessageContentFragmentMention)(nil), "code.justin.tv.chat.chatrooms.MessageContentFragmentMention")
	proto.RegisterType((*MessageSender)(nil), "code.justin.tv.chat.chatrooms.MessageSender")
	proto.RegisterType((*UserBadge)(nil), "code.justin.tv.chat.chatrooms.UserBadge")
	proto.RegisterEnum("code.justin.tv.chat.chatrooms.SortOrder", SortOrder_name, SortOrder_value)
	proto.RegisterEnum("code.justin.tv.chat.chatrooms.RoleType", RoleType_name, RoleType_value)
	proto.RegisterEnum("code.justin.tv.chat.chatrooms.MemberType", MemberType_name, MemberType_value)
	proto.RegisterEnum("code.justin.tv.chat.chatrooms.MentionType", MentionType_name, MentionType_value)
	proto.RegisterEnum("code.justin.tv.chat.chatrooms.TwitchType", TwitchType_name, TwitchType_value)
}

func init() { proto.RegisterFile("rpc/chatrooms/chatrooms.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 3615 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x3a, 0x4b, 0x70, 0x1b, 0xd7,
	0x91, 0x1a, 0x7c, 0x08, 0xa0, 0x87, 0x04, 0xc1, 0x27, 0x4a, 0x82, 0x20, 0xd3, 0xd2, 0x8e, 0xed,
	0xb5, 0x4c, 0xdb, 0x94, 0x4c, 0x59, 0xd6, 0xd2, 0xb2, 0xbc, 0x02, 0x09, 0x88, 0xa2, 0x96, 0x20,
	0xe9, 0x01, 0x49, 0x97, 0x76, 0xb7, 0x3c, 0x1e, 0x62, 0x9e, 0xc0, 0x59, 0x0d, 0x66, 0xe0, 0x79,
	0x0f, 0xa4, 0xe8, 0xaa, 0xad, 0x4a, 0x95, 0x0f, 0xc9, 0x21, 0x29, 0x5f, 0x52, 0x95, 0x4b, 0x72,
	0x48, 0x25, 0xc7, 0x24, 0x87, 0xe4, 0x92, 0x43, 0x72, 0xf1, 0x35, 0x67, 0x9f, 0x72, 0x4a, 0xe5,
	0x92, 0x63, 0x2e, 0x39, 0xe4, 0x96, 0x7a, 0x9f, 0x19, 0x0c, 0x7e, 0x1c, 0x80, 0x74, 0xaa, 0x92,
	0xca, 0x6d, 0xa6, 0xa7, 0xbb, 0x5f, 0xbf, 0xd7, 0x9f, 0xd7, 0xdd, 0xd3, 0xb0, 0xe0, 0xb7, 0x1b,
	0xb7, 0x1a, 0x87, 0x26, 0xf5, 0x3d, 0xaf, 0x45, 0xba, 0x4f, 0x4b, 0x6d, 0xdf, 0xa3, 0x1e, 0x5a,
	0x68, 0x78, 0x16, 0x5e, 0xfa, 0xbf, 0x0e, 0xa1, 0xb6, 0xbb, 0x44, 0x8f, 0x96, 0xd8, 0xf7, 0xa5,
	0x10, 0xa9, 0xf4, 0x72, 0xd3, 0xf3, 0x9a, 0x0e, 0xbe, 0xc5, 0x91, 0x0f, 0x3a, 0xcf, 0x6e, 0x59,
	0x1d, 0xdf, 0xa4, 0xb6, 0xe7, 0x0a, 0xf2, 0xd2, 0xf5, 0xfe, 0xef, 0xd4, 0x6e, 0x61, 0x42, 0xcd,
	0x56, 0x5b, 0x22, 0x0c, 0x30, 0x38, 0xf6, 0xcd, 0x76, 0x1b, 0xfb, 0x72, 0x7d, 0x6d, 0x13, 0xd0,
	0x13, 0xcf, 0x76, 0xd7, 0x0e, 0x4d, 0xd7, 0xc5, 0x8e, 0x8e, 0x3f, 0xeb, 0x60, 0x42, 0xd1, 0x15,
	0xc8, 0x74, 0x08, 0xf6, 0x0d, 0xdb, 0x2a, 0x2a, 0x37, 0x94, 0x9b, 0x39, 0x7d, 0x8a, 0xbd, 0x6e,
	0x58, 0x68, 0x01, 0xa0, 0x21, 0x50, 0xd9, 0xb7, 0x04, 0xff, 0x96, 0x93, 0x90, 0x0d, 0x4b, 0xab,
	0xc1, 0xc5, 0x1e, 0x6e, 0xa4, 0xed, 0xb9, 0x04, 0x9f, 0x87, 0xdd, 0x26, 0x36, 0x8f, 0xf0, 0x37,
	0x24, 0xdd, 0x65, 0x98, 0xef, 0x65, 0x27, 0xc4, 0xd3, 0x7e, 0xa2, 0x00, 0xda, 0xb4, 0x09, 0xad,
	0xe1, 0xd6, 0x01, 0xf6, 0x49, 0x64, 0x19, 0xa6, 0x84, 0xc8, 0x32, 0xec, 0x75, 0xc3, 0x8a, 0xae,
	0x9f, 0xe8, 0x59, 0x7f, 0x1e, 0xd2, 0x8e, 0xdd, 0xb2, 0x69, 0x31, 0x79, 0x43, 0xb9, 0x99, 0xd4,
	0xc5, 0x0b, 0xba, 0x0c, 0x53, 0x8d, 0x8e, 0x4f, 0x3c, 0xbf, 0x98, 0x12, 0xd8, 0xe2, 0x0d, 0xbd,
	0x0d, 0xc8, 0x6e, 0xba, 0x9e, 0x8f, 0x8d, 0x36, 0xf6, 0x5b, 0x36, 0x21, 0xb6, 0xe7, 0x92, 0x62,
	0xfa, 0x86, 0x72, 0x33, 0xab, 0xcf, 0x89, 0x2f, 0x3b, 0xdd, 0x0f, 0xda, 0xcf, 0x14, 0xb8, 0xd8,
	0x23, 0xa5, 0x3c, 0xdc, 0x2a, 0x64, 0x7c, 0x4c, 0x3a, 0x0e, 0x25, 0x45, 0xe5, 0x46, 0xf2, 0xa6,
	0xba, 0xfc, 0xe6, 0xd2, 0xa9, 0x36, 0xb5, 0x24, 0x18, 0xe8, 0x9c, 0x46, 0x0f, 0x68, 0xd1, 0x22,
	0xcc, 0x1d, 0x9a, 0xc4, 0x68, 0xfb, 0xf8, 0xc8, 0xf6, 0x3a, 0xc4, 0x68, 0x9b, 0x4d, 0xcc, 0xb7,
	0x97, 0xd5, 0x67, 0x0f, 0x4d, 0xb2, 0x23, 0xe1, 0x3b, 0x66, 0x13, 0x23, 0x0d, 0x66, 0x18, 0xae,
	0x8b, 0x5f, 0x50, 0x81, 0x97, 0xe4, 0x78, 0xea, 0xa1, 0x49, 0xb6, 0xf0, 0x0b, 0xca, 0x70, 0xb4,
	0x1d, 0xb8, 0xbc, 0x41, 0xe4, 0x49, 0x07, 0x2b, 0x9e, 0x4f, 0x7d, 0x55, 0xb8, 0x32, 0xc0, 0x51,
	0x9e, 0xc1, 0x22, 0xcc, 0xd9, 0xc4, 0x08, 0x88, 0x5b, 0xfc, 0x23, 0x67, 0x9e, 0xd5, 0x67, 0xed,
	0x5e, 0x1a, 0xed, 0x4b, 0x05, 0xf2, 0xeb, 0x98, 0xea, 0x9e, 0xd7, 0x8a, 0xd5, 0xf4, 0xdd, 0x5e,
	0x4d, 0xab, 0xcb, 0x2f, 0x2d, 0x09, 0x7f, 0x5a, 0x0a, 0xfc, 0x69, 0xa9, 0x4e, 0x7d, 0xdb, 0x6d,
	0xee, 0x9b, 0x4e, 0x07, 0x87, 0x1b, 0x19, 0xae, 0xd9, 0xe4, 0x28, 0xcd, 0x3e, 0x81, 0xd9, 0x50,
	0x20, 0xb9, 0xa1, 0x7b, 0x90, 0x62, 0x22, 0x70, 0x71, 0xd4, 0xe5, 0x57, 0x62, 0x34, 0xca, 0x49,
	0x39, 0x81, 0xf6, 0xbb, 0x04, 0xcc, 0xad, 0xf9, 0xd8, 0xa4, 0x38, 0xba, 0xc1, 0x05, 0x00, 0xef,
	0xd8, 0xc5, 0xbe, 0x41, 0x4f, 0xda, 0x58, 0xee, 0x31, 0xc7, 0x21, 0xbb, 0x27, 0x6d, 0x8c, 0xae,
	0x42, 0x56, 0x7c, 0x0e, 0x8f, 0x3d, 0xc3, 0xdf, 0x37, 0x2c, 0x84, 0x20, 0xe5, 0x9a, 0x2d, 0xa1,
	0xe1, 0x9c, 0xce, 0x9f, 0x99, 0x99, 0x53, 0xaf, 0x6d, 0x37, 0xa4, 0x3d, 0x8b, 0x17, 0xf4, 0x1a,
	0xe4, 0x6d, 0x69, 0x3f, 0xf8, 0xd8, 0x3c, 0x70, 0x70, 0x11, 0xf8, 0x86, 0x67, 0x6c, 0x61, 0x3c,
	0x02, 0x88, 0x9e, 0xc2, 0x7c, 0xcb, 0x76, 0xed, 0x56, 0xa7, 0x65, 0x98, 0x8e, 0xe3, 0x1d, 0x63,
	0xcb, 0xf0, 0x3d, 0x07, 0x17, 0xd5, 0x1b, 0xca, 0xcd, 0xfc, 0xf2, 0xeb, 0xb1, 0x3b, 0x75, 0x30,
	0x13, 0x59, 0x47, 0x92, 0x49, 0x59, 0xf0, 0x60, 0x70, 0xb4, 0x03, 0x6a, 0xf4, 0xbc, 0xa7, 0xf9,
	0xd9, 0x2d, 0x8d, 0x71, 0x76, 0x11, 0x65, 0xe8, 0x51, 0x16, 0xda, 0xf7, 0x14, 0x98, 0xed, 0x43,
	0x40, 0xf7, 0x21, 0xe5, 0x63, 0x53, 0x58, 0xca, 0x04, 0x02, 0x73, 0x22, 0xf4, 0x00, 0xd2, 0xc7,
	0xbe, 0x4d, 0x85, 0x67, 0x4d, 0x40, 0x2d, 0xa8, 0xb4, 0x1f, 0x29, 0x70, 0xa9, 0x4f, 0x9e, 0xbd,
	0xb6, 0x65, 0x52, 0x8c, 0x1e, 0x46, 0xa4, 0x52, 0x97, 0xdf, 0x1a, 0x93, 0xaf, 0x30, 0x5b, 0x21,
	0xda, 0x6a, 0x54, 0xb4, 0x49, 0x59, 0x48, 0xf9, 0x6a, 0x80, 0xa2, 0xc6, 0x77, 0x5e, 0x63, 0xfe,
	0x1c, 0xe6, 0x2a, 0xd8, 0xc1, 0xbd, 0xb6, 0x3c, 0xd2, 0x59, 0x17, 0x00, 0x2c, 0x8e, 0x1d, 0xb1,
	0xe3, 0x9c, 0x84, 0x4c, 0xee, 0x94, 0x35, 0x40, 0xd1, 0xb5, 0xcf, 0xbb, 0x95, 0xaf, 0x93, 0x30,
	0x27, 0x54, 0x35, 0xd6, 0x5e, 0x46, 0x5e, 0x31, 0xb7, 0xa5, 0x3f, 0xa6, 0xc7, 0x08, 0x47, 0xc2,
	0x5b, 0x97, 0x03, 0x6f, 0x9d, 0x1a, 0x83, 0x44, 0xfa, 0xf2, 0xf0, 0xb3, 0xca, 0x8c, 0x38, 0x2b,
	0x54, 0x1e, 0xea, 0xfa, 0xea, 0x72, 0x69, 0x60, 0xad, 0x55, 0xcf, 0x73, 0xc4, 0x4a, 0x7d, 0x61,
	0xe1, 0x93, 0x53, 0xc2, 0xc2, 0xa4, 0xc6, 0x38, 0x2c, 0x36, 0xec, 0x0f, 0x8b, 0x0d, 0xef, 0x4e,
	0x16, 0x1b, 0xa4, 0xfe, 0x7a, 0x22, 0x44, 0x0d, 0x50, 0x54, 0xad, 0xe7, 0x35, 0x93, 0x5f, 0x27,
	0xe0, 0x52, 0x97, 0xdf, 0xbe, 0x8d, 0x8f, 0xcf, 0x6e, 0x2a, 0x1f, 0xc0, 0xb4, 0x63, 0x12, 0x6a,
	0x30, 0xef, 0x36, 0x4c, 0x91, 0x94, 0x0c, 0xd3, 0xc9, 0x6e, 0x90, 0x32, 0xea, 0xc0, 0xf0, 0x75,
	0x6c, 0x5a, 0x65, 0x8a, 0xee, 0x42, 0xd6, 0x26, 0x46, 0xab, 0x43, 0xb1, 0xc5, 0xe3, 0xfc, 0xe9,
	0xda, 0xcc, 0xd8, 0xa4, 0xc6, 0x50, 0xd1, 0x7d, 0x50, 0x6d, 0x62, 0x98, 0x7e, 0xe3, 0xd0, 0x3e,
	0xc2, 0x96, 0x34, 0xd3, 0xd3, 0x28, 0xc1, 0x26, 0x65, 0x89, 0x8d, 0xee, 0x43, 0xc9, 0xc7, 0x04,
	0x53, 0xa3, 0xe3, 0x72, 0xa1, 0x5b, 0xd8, 0x65, 0xb9, 0xae, 0xd1, 0xf0, 0x3a, 0x2e, 0xe5, 0xa6,
	0x90, 0xd5, 0xaf, 0x70, 0x8c, 0x3d, 0x8e, 0x50, 0x13, 0xdf, 0xd7, 0xd8, 0x67, 0xed, 0x13, 0xb8,
	0xdc, 0x7f, 0x72, 0x52, 0x1b, 0x15, 0xc8, 0xf1, 0xa3, 0x63, 0xc6, 0x26, 0x55, 0xf2, 0xfa, 0x18,
	0x2a, 0xe1, 0x3c, 0xb2, 0xbe, 0x7c, 0xd2, 0xfe, 0x9c, 0x88, 0x2e, 0x50, 0xf3, 0x2c, 0x7c, 0x8e,
	0x4c, 0xf1, 0x23, 0xb8, 0x82, 0x5d, 0x66, 0xf8, 0x06, 0x6e, 0x79, 0x14, 0x13, 0xc3, 0x73, 0x9d,
	0x13, 0xa3, 0xe5, 0x59, 0x78, 0xa4, 0x9a, 0xba, 0x47, 0x36, 0x2f, 0x48, 0xab, 0x9c, 0x72, 0xdb,
	0x75, 0x4e, 0x98, 0x30, 0x68, 0x15, 0x66, 0x25, 0x4b, 0x7f, 0xe5, 0xb9, 0x60, 0x15, 0xaf, 0xb7,
	0x19, 0x41, 0xa2, 0xaf, 0x3c, 0xe7, 0x3c, 0x2a, 0x50, 0x90, 0x3c, 0x88, 0xe3, 0x1d, 0x0b, 0x26,
	0xf1, 0x2a, 0xcc, 0x0b, 0x9a, 0xba, 0xe3, 0x1d, 0x73, 0x2e, 0xeb, 0x80, 0x42, 0x72, 0x23, 0x28,
	0x58, 0x64, 0xf8, 0xb9, 0x3a, 0xc0, 0xa7, 0x22, 0x11, 0xf4, 0x02, 0x91, 0x0c, 0x02, 0x88, 0xa6,
	0xc3, 0x95, 0x81, 0x13, 0x3f, 0xaf, 0x87, 0xfd, 0x52, 0x81, 0x02, 0x4b, 0xa3, 0x19, 0x88, 0x9c,
	0x3f, 0x3f, 0x8a, 0x64, 0x88, 0xc9, 0x73, 0x67, 0x88, 0xa9, 0x51, 0x97, 0xd1, 0x16, 0xcc, 0x45,
	0x64, 0x96, 0x47, 0xb0, 0x02, 0x69, 0xbe, 0x3b, 0x99, 0xf6, 0x8f, 0x75, 0x06, 0x82, 0x42, 0x7b,
	0x0e, 0x57, 0x56, 0x3b, 0xce, 0x73, 0x99, 0x75, 0x32, 0xf3, 0x0e, 0x8f, 0xe2, 0x6e, 0x6f, 0x76,
	0x3e, 0xee, 0x86, 0xae, 0x42, 0x56, 0xba, 0x00, 0x29, 0x26, 0x6e, 0x24, 0xd9, 0x11, 0x09, 0x1f,
	0x20, 0xda, 0x9f, 0x14, 0x28, 0x0e, 0xae, 0x26, 0x37, 0x81, 0x01, 0x42, 0xdf, 0x0c, 0x76, 0xf2,
	0x28, 0x66, 0x27, 0xa3, 0x98, 0x85, 0x5e, 0x4b, 0xaa, 0x2e, 0xf5, 0x4f, 0xf4, 0x5c, 0xe0, 0xbb,
	0xa4, 0x84, 0x21, 0xdf, 0xfb, 0x11, 0x15, 0x20, 0xf9, 0x1c, 0x9f, 0x48, 0x5d, 0xb3, 0x47, 0x96,
	0x9b, 0x1d, 0xb1, 0x3d, 0xc9, 0x04, 0x68, 0xec, 0x10, 0x21, 0xa8, 0xde, 0x4f, 0xfc, 0x87, 0xa2,
	0xfd, 0x54, 0x01, 0x54, 0xc7, 0xae, 0x55, 0xc3, 0x84, 0x98, 0x4d, 0x1c, 0x9c, 0xe9, 0x35, 0xc8,
	0x11, 0xec, 0x5a, 0xd1, 0x9a, 0x27, 0x2b, 0x00, 0x22, 0x46, 0x04, 0xc1, 0x23, 0xd1, 0x13, 0x3c,
	0xfe, 0x0d, 0xa6, 0x5b, 0x82, 0x8f, 0x41, 0xf1, 0x0b, 0x2a, 0x53, 0x70, 0x55, 0xc2, 0x76, 0xf1,
	0x0b, 0x8a, 0xae, 0x83, 0x7a, 0x60, 0x53, 0x62, 0x98, 0x2d, 0x1e, 0x21, 0x81, 0x97, 0x9d, 0xc0,
	0x40, 0x65, 0x0e, 0x61, 0xa9, 0xba, 0xeb, 0xb9, 0x0d, 0x5c, 0x9c, 0x15, 0xa9, 0x3a, 0x7f, 0xd1,
	0xbe, 0x4a, 0xc0, 0xc5, 0x1e, 0x31, 0xa5, 0x32, 0x8a, 0x90, 0x21, 0x9d, 0x46, 0x03, 0x13, 0x22,
	0x8b, 0xa7, 0xe0, 0x15, 0x3d, 0x84, 0x8c, 0x5c, 0x57, 0x9e, 0xce, 0xbf, 0xc7, 0x16, 0x99, 0x82,
	0x75, 0x40, 0x86, 0x5e, 0x81, 0x19, 0x5f, 0xae, 0x63, 0x30, 0x52, 0x2e, 0x6c, 0x4e, 0x9f, 0x0e,
	0x80, 0x6b, 0x2c, 0x72, 0xd8, 0x11, 0x24, 0xd3, 0x6f, 0x92, 0xa2, 0xca, 0x0d, 0xa2, 0x12, 0xb3,
	0xd8, 0x90, 0xbd, 0x2c, 0x05, 0x0f, 0x65, 0xbf, 0x29, 0xcd, 0x21, 0x5c, 0x8a, 0x81, 0x4a, 0xff,
	0x09, 0x73, 0x03, 0x28, 0x43, 0x8c, 0x62, 0x3e, 0x6a, 0x14, 0xb9, 0xa8, 0xae, 0xbf, 0xab, 0x00,
	0xaa, 0x5a, 0x36, 0xed, 0xd3, 0xf5, 0x02, 0x40, 0xa0, 0xb5, 0x50, 0xd9, 0x39, 0x09, 0xd9, 0xb0,
	0x98, 0x29, 0x60, 0xcb, 0xa6, 0x5e, 0x24, 0x96, 0x64, 0x05, 0xa0, 0xd7, 0x14, 0x92, 0xa7, 0x9a,
	0x42, 0x6a, 0xc0, 0x14, 0xb4, 0x8f, 0xe1, 0x62, 0x8f, 0x34, 0x52, 0xa5, 0x11, 0xc5, 0x29, 0x67,
	0x52, 0x9c, 0xf6, 0x43, 0x05, 0xe6, 0x45, 0x26, 0x3c, 0xd9, 0x4e, 0x63, 0xd2, 0xf1, 0x91, 0x7b,
	0x9d, 0x30, 0x34, 0x3e, 0x85, 0x4b, 0x7d, 0xd2, 0x7d, 0x63, 0x3b, 0xff, 0x43, 0x22, 0xe8, 0xb8,
	0xf0, 0xf7, 0x73, 0x5c, 0xf7, 0x93, 0xd5, 0x1e, 0xdd, 0x3e, 0x12, 0x44, 0xfb, 0x48, 0xc5, 0xb0,
	0x8f, 0xc4, 0x32, 0xa1, 0xdc, 0xe3, 0x0b, 0x61, 0x27, 0x69, 0x05, 0x72, 0xcf, 0x7c, 0xaf, 0x65,
	0x50, 0xbb, 0x85, 0x8b, 0x33, 0x71, 0x69, 0xde, 0xe3, 0x0b, 0x7a, 0x96, 0xa1, 0x33, 0x00, 0x5a,
	0x07, 0x20, 0x9e, 0x4f, 0x0d, 0xcf, 0xb7, 0xb0, 0xcf, 0xd3, 0xe2, 0xfc, 0xf2, 0xcd, 0x38, 0x77,
	0xf3, 0x7c, 0xba, 0xcd, 0xf0, 0xf5, 0x1c, 0x09, 0x1e, 0xd1, 0xeb, 0x30, 0x6b, 0xbb, 0x0d, 0xa7,
	0x63, 0x61, 0xe3, 0xd0, 0x26, 0xd4, 0xf3, 0x4f, 0x8a, 0x79, 0xbe, 0xbf, 0xbc, 0x04, 0x3f, 0x16,
	0xd0, 0xd5, 0x69, 0x00, 0xc7, 0x26, 0xd4, 0x20, 0xd4, 0xf4, 0xa9, 0xf6, 0x0b, 0x05, 0xe6, 0x7b,
	0xcf, 0x58, 0xaa, 0xef, 0x51, 0x7f, 0x5b, 0xeb, 0xad, 0x31, 0xd5, 0xf7, 0x77, 0xee, 0x6b, 0x7d,
	0x0c, 0xd7, 0xd6, 0x31, 0x95, 0x2d, 0xa5, 0x1d, 0xdf, 0x6b, 0x63, 0x9f, 0xda, 0xf8, 0xfc, 0x99,
	0x84, 0xf6, 0x04, 0x5e, 0x1a, 0xce, 0xb8, 0xdb, 0xe3, 0x6a, 0x99, 0x2f, 0x22, 0xd5, 0x91, 0xb8,
	0xfa, 0x99, 0x81, 0xcc, 0xb6, 0xcc, 0x17, 0x61, 0xb1, 0xc3, 0xee, 0xf7, 0x2d, 0x98, 0xe9, 0x29,
	0x89, 0xba, 0x77, 0xdb, 0x84, 0x5d, 0x0b, 0x41, 0xa5, 0xfd, 0x3c, 0x09, 0x29, 0xc6, 0x19, 0xe5,
	0x21, 0x11, 0x5a, 0x7d, 0xc2, 0xb6, 0xfa, 0xb6, 0x9b, 0x38, 0x6d, 0xbb, 0xc9, 0xe1, 0x8d, 0xa5,
	0xd4, 0xb0, 0xc6, 0x52, 0xfa, 0x1f, 0xba, 0xb1, 0x34, 0x73, 0xee, 0xc6, 0x12, 0x7a, 0x1f, 0xd2,
	0x2c, 0x3b, 0x0e, 0x0a, 0xd1, 0x57, 0xe3, 0x6c, 0x9b, 0xe7, 0xbe, 0x82, 0x44, 0x5c, 0x06, 0xad,
	0x03, 0xec, 0xcb, 0xba, 0x68, 0x96, 0xdb, 0x80, 0x2a, 0x60, 0xa2, 0x16, 0xfa, 0x95, 0x02, 0x69,
	0x4e, 0x33, 0x22, 0x17, 0x57, 0x26, 0xce, 0xc5, 0xd1, 0x4d, 0x28, 0x04, 0x75, 0x85, 0x21, 0xf2,
	0x7d, 0x4b, 0xba, 0x51, 0xde, 0x17, 0xd5, 0x43, 0x55, 0x40, 0xd1, 0x3d, 0x28, 0xf6, 0x17, 0x35,
	0x21, 0x85, 0x70, 0xa8, 0x4b, 0xb8, 0xa7, 0x74, 0x91, 0x84, 0xda, 0x1f, 0x13, 0x90, 0x0d, 0xb2,
	0xaa, 0x01, 0x4b, 0x1b, 0x99, 0x26, 0x5d, 0xe9, 0xcd, 0xc0, 0x47, 0xd7, 0xbf, 0xa9, 0x89, 0xea,
	0xdf, 0xab, 0x91, 0xfa, 0x57, 0xf4, 0xe4, 0xc3, 0x1a, 0xf7, 0x7a, 0x6f, 0x8d, 0x3b, 0xc5, 0xbf,
	0x46, 0xeb, 0xd8, 0x6b, 0x90, 0xb3, 0x89, 0x2c, 0x62, 0xa5, 0xb1, 0x66, 0x6d, 0x22, 0x6a, 0x56,
	0x74, 0x1b, 0xe6, 0x47, 0x96, 0xb7, 0x49, 0x1d, 0x75, 0x06, 0x2a, 0x5b, 0xb4, 0x39, 0xac, 0x77,
	0xb1, 0x18, 0x63, 0x32, 0x23, 0x7b, 0x9a, 0x04, 0xd4, 0xe8, 0x5d, 0xc3, 0xf3, 0x32, 0x2e, 0x8c,
	0x08, 0xc0, 0x32, 0xf3, 0x9b, 0x16, 0x52, 0x08, 0x18, 0x43, 0x62, 0xf9, 0x6a, 0x17, 0x49, 0x68,
	0x7e, 0x9a, 0x74, 0x13, 0x2f, 0x82, 0x4a, 0x90, 0x65, 0xba, 0xf6, 0x4d, 0x1a, 0x04, 0xce, 0xf0,
	0x5d, 0xc3, 0x30, 0x1d, 0xfd, 0xed, 0x80, 0x1e, 0xc0, 0x54, 0xa4, 0x4b, 0xaf, 0x2e, 0xbf, 0x36,
	0xde, 0x3f, 0x0b, 0x49, 0x14, 0xf9, 0xa5, 0x92, 0x88, 0xfe, 0x52, 0xd1, 0x3e, 0x85, 0x29, 0x81,
	0x39, 0xfa, 0x27, 0xc3, 0x03, 0x48, 0xf1, 0x58, 0x95, 0xe4, 0x61, 0xe1, 0x8d, 0xb1, 0xd6, 0x15,
	0x0d, 0x5c, 0x46, 0xa6, 0xd9, 0x30, 0xd3, 0x73, 0xd1, 0x9c, 0x3f, 0xcd, 0x18, 0xb9, 0x99, 0xdf,
	0x26, 0x21, 0x23, 0x91, 0xc7, 0xf7, 0x86, 0x3b, 0x90, 0x21, 0xd8, 0xa5, 0xe3, 0xf5, 0x7b, 0xa6,
	0x18, 0x6a, 0x99, 0xb2, 0x88, 0xc2, 0x22, 0x6c, 0xe7, 0xc0, 0xb1, 0xc9, 0xa1, 0xec, 0xf7, 0x64,
	0x75, 0xd5, 0x26, 0x3b, 0x01, 0x08, 0xad, 0x04, 0xd9, 0x1c, 0x77, 0xa5, 0x74, 0x2c, 0x6b, 0x99,
	0xe9, 0x31, 0x4f, 0x5a, 0x87, 0x4c, 0xc3, 0x73, 0x29, 0x96, 0x05, 0x8a, 0xba, 0xfc, 0xf6, 0x78,
	0x27, 0xb4, 0x26, 0x88, 0xf4, 0x80, 0x1a, 0x55, 0x60, 0x4a, 0x54, 0x4d, 0x63, 0x76, 0x05, 0x25,
	0x9f, 0x3a, 0xa7, 0xd1, 0x25, 0x2d, 0x4b, 0x2c, 0x82, 0x04, 0x65, 0x7a, 0x92, 0xc4, 0x82, 0xdd,
	0xcc, 0x4c, 0x6d, 0x92, 0xb8, 0xbf, 0xf6, 0x9a, 0xe9, 0xaf, 0xbd, 0xb4, 0xbf, 0x28, 0xa1, 0xad,
	0x08, 0xda, 0xb3, 0xd6, 0xd6, 0xd7, 0x41, 0x35, 0x1b, 0x3c, 0x52, 0x44, 0x6e, 0x59, 0x10, 0x20,
	0x7e, 0xcd, 0xae, 0x00, 0x74, 0x78, 0x9f, 0x64, 0xcc, 0x3e, 0x5f, 0x4e, 0x62, 0x97, 0x29, 0xfa,
	0x08, 0x0a, 0x9e, 0x6f, 0x37, 0x6d, 0xd7, 0x74, 0x02, 0xef, 0x96, 0x81, 0x72, 0x5c, 0x3b, 0x9e,
	0x0d, 0xe8, 0x25, 0x40, 0x3b, 0x81, 0x7c, 0xaf, 0x06, 0xd9, 0x5d, 0xcf, 0xcb, 0x16, 0x61, 0xbf,
	0xfc, 0x19, 0xd5, 0x59, 0xce, 0x6a, 0x36, 0x59, 0x0c, 0x14, 0x1d, 0x03, 0x75, 0xf9, 0xee, 0x44,
	0x76, 0xf1, 0x48, 0x52, 0xeb, 0x5d, 0x3e, 0xda, 0xd7, 0x29, 0xb8, 0x3c, 0x1c, 0x6b, 0xa8, 0x0c,
	0x4f, 0x21, 0xcb, 0x6e, 0x22, 0xbb, 0xe1, 0xb9, 0xd2, 0xa4, 0x1f, 0x9c, 0x49, 0x84, 0xaa, 0x64,
	0xa2, 0x87, 0xec, 0x90, 0x01, 0xd3, 0x5c, 0xd5, 0x32, 0xc6, 0xcb, 0xee, 0xd7, 0x07, 0x67, 0x62,
	0x2f, 0x2f, 0x03, 0x5d, 0x65, 0x1c, 0xe5, 0x0b, 0xaa, 0x41, 0xca, 0xb1, 0xdd, 0xe7, 0xbc, 0x29,
	0xaf, 0x2e, 0xaf, 0x9c, 0x89, 0xf1, 0xa6, 0xed, 0x3e, 0xd7, 0x39, 0x1b, 0xf4, 0x0c, 0x66, 0x9a,
	0xbe, 0xd7, 0x69, 0x87, 0x02, 0x67, 0x39, 0xdf, 0xf2, 0x99, 0xf8, 0xae, 0x33, 0x4e, 0x81, 0xd4,
	0xd3, 0xcd, 0xc8, 0x1b, 0xfa, 0x5f, 0xc8, 0x35, 0x0e, 0x31, 0xf6, 0x59, 0x02, 0x50, 0xcc, 0xf1,
	0x35, 0x3e, 0x3c, 0xd3, 0x1a, 0x6b, 0x01, 0x17, 0xbd, 0xcb, 0x10, 0xed, 0x43, 0xc6, 0xec, 0x50,
	0xaf, 0xe5, 0x59, 0x32, 0xd4, 0x9c, 0xed, 0xc0, 0xcb, 0x1d, 0xea, 0xd5, 0x3c, 0x4b, 0x0f, 0x98,
	0x69, 0xcf, 0xe0, 0xe5, 0xd3, 0x35, 0x8f, 0x5e, 0x06, 0x08, 0x74, 0xbf, 0x51, 0x91, 0x46, 0x16,
	0x81, 0xa0, 0x57, 0x61, 0x26, 0x78, 0xab, 0x63, 0xba, 0x51, 0x91, 0x5e, 0xdc, 0x0b, 0xd4, 0x5c,
	0xb8, 0x1e, 0xb3, 0x5b, 0x76, 0x5b, 0xb4, 0x7d, 0xfc, 0xcc, 0x7e, 0x11, 0xdc, 0x6b, 0xe2, 0xad,
	0x3f, 0x1c, 0x25, 0x06, 0x5a, 0x41, 0xcc, 0x01, 0x6c, 0xec, 0xcb, 0xd9, 0x04, 0xfe, 0xac, 0x59,
	0xa0, 0xc5, 0x6b, 0x10, 0x7d, 0x28, 0xaf, 0x4c, 0x51, 0x3b, 0x2c, 0xc6, 0x1e, 0xa9, 0x1b, 0x04,
	0x26, 0x79, 0x67, 0xfe, 0x40, 0x81, 0xd2, 0x68, 0x03, 0x64, 0x82, 0x1d, 0x7a, 0x24, 0xf4, 0x4c,
	0xf6, 0x8c, 0x30, 0xe4, 0xd9, 0xcd, 0xcb, 0x32, 0x0e, 0x6a, 0x5a, 0x26, 0x35, 0x65, 0xdb, 0xe9,
	0xc3, 0x33, 0xdb, 0x79, 0x95, 0xb1, 0x63, 0xe7, 0x7d, 0x80, 0xad, 0x9a, 0x64, 0xaa, 0x7d, 0x3f,
	0x39, 0xea, 0xc0, 0x43, 0x12, 0x56, 0xe2, 0x60, 0xdf, 0xf7, 0x7c, 0xd1, 0xb5, 0x92, 0x15, 0x1d,
	0x87, 0xf0, 0x96, 0xd5, 0x75, 0x50, 0x7d, 0x51, 0xfb, 0x19, 0x1d, 0xdf, 0x09, 0x82, 0xb3, 0x04,
	0xed, 0xf9, 0x0e, 0x3f, 0xf7, 0x20, 0xe1, 0xc8, 0x89, 0x13, 0xe1, 0x85, 0x8e, 0x4d, 0x1d, 0x1c,
	0xfe, 0x41, 0x67, 0x2f, 0xe8, 0x06, 0xa8, 0x16, 0x26, 0x0d, 0xdf, 0x6e, 0x73, 0x0f, 0x14, 0x45,
	0x50, 0x14, 0xc4, 0x6f, 0x82, 0x0e, 0x3d, 0xf4, 0x7c, 0x83, 0xd7, 0x4e, 0x53, 0xf2, 0x26, 0xe0,
	0xa0, 0x2d, 0x56, 0x41, 0x2d, 0x80, 0x7c, 0xe3, 0xc2, 0x64, 0x84, 0xb0, 0x02, 0xc2, 0x64, 0x79,
	0x05, 0x66, 0xe8, 0x61, 0xa7, 0x75, 0xe0, 0x9a, 0xb6, 0xc3, 0x31, 0xb2, 0xa2, 0x09, 0x17, 0x02,
	0x25, 0x52, 0xdb, 0xf7, 0x8e, 0x6c, 0x0b, 0xcb, 0x65, 0x72, 0x02, 0x29, 0x00, 0xf2, 0x85, 0xfe,
	0x07, 0x66, 0xe9, 0xb1, 0x4d, 0x1b, 0x87, 0x5d, 0x0d, 0x09, 0x8f, 0x5b, 0x8e, 0xd1, 0xd0, 0x2e,
	0xa7, 0xaa, 0x46, 0xd5, 0xa0, 0xe7, 0x05, 0xab, 0x50, 0x2d, 0xbf, 0x51, 0x60, 0xe1, 0x54, 0xcf,
	0x44, 0x9f, 0xc2, 0x14, 0x2f, 0x0e, 0x83, 0xe6, 0xc0, 0xe3, 0xf3, 0xf8, 0xf9, 0xd2, 0x2e, 0x67,
	0x25, 0xba, 0x84, 0x92, 0x6f, 0x69, 0x05, 0xd4, 0x08, 0x38, 0xae, 0x33, 0x98, 0x8c, 0x76, 0x06,
	0xbf, 0x48, 0xc2, 0xc5, 0x21, 0xdb, 0x44, 0x4f, 0x40, 0x95, 0x67, 0x16, 0x71, 0xa7, 0x37, 0xc6,
	0x3a, 0x2f, 0xee, 0x4d, 0x40, 0xc3, 0x67, 0x54, 0x85, 0x54, 0xc3, 0xb1, 0xdb, 0xd2, 0x2d, 0xde,
	0x19, 0x8b, 0xc9, 0x9a, 0x63, 0xb7, 0xc3, 0x33, 0xe7, 0xe4, 0x68, 0x15, 0x92, 0x47, 0x5e, 0xf0,
	0xeb, 0xe2, 0xf6, 0x58, 0x5c, 0xf6, 0xb7, 0x2b, 0x21, 0x13, 0x46, 0x8c, 0xfe, 0x0b, 0xa6, 0x08,
	0xf5, 0xb1, 0xd9, 0x92, 0x89, 0xc3, 0x9d, 0xb1, 0xd8, 0xd4, 0x39, 0x49, 0xc8, 0x49, 0xb2, 0x40,
	0x8f, 0x21, 0x8d, 0x8f, 0x58, 0xaa, 0x98, 0x9e, 0xc4, 0x9a, 0x8e, 0xf8, 0x2d, 0x29, 0x59, 0x09,
	0x06, 0xda, 0x77, 0x12, 0x80, 0x06, 0xf7, 0x8d, 0x5e, 0x83, 0xfc, 0x81, 0xef, 0x99, 0x56, 0xc3,
	0x24, 0x34, 0x5a, 0x1f, 0xcc, 0x44, 0xa0, 0x1b, 0x16, 0x7a, 0x13, 0xe6, 0xa2, 0x68, 0x8e, 0xd7,
	0xb4, 0x5d, 0xe9, 0xdc, 0x85, 0xc8, 0x87, 0x4d, 0x06, 0x67, 0xf9, 0x57, 0x83, 0x8f, 0x3d, 0x8c,
	0x9b, 0x7f, 0x49, 0xec, 0x32, 0x8f, 0xca, 0xcd, 0x48, 0x1b, 0x84, 0x3d, 0xb3, 0x0a, 0x91, 0x39,
	0x9a, 0x67, 0x38, 0xd8, 0x6d, 0xd2, 0x43, 0x83, 0xe0, 0x86, 0xe7, 0x5a, 0x62, 0x34, 0x2c, 0xad,
	0x23, 0xfe, 0x6d, 0x93, 0x7f, 0xaa, 0x8b, 0x2f, 0xcc, 0xed, 0x8f, 0x6c, 0x7c, 0x2c, 0x2b, 0xc9,
	0x29, 0x8e, 0x97, 0x63, 0x10, 0xd1, 0x0e, 0xf8, 0x76, 0x02, 0xe6, 0x06, 0x94, 0xf7, 0x2f, 0x79,
	0x12, 0x7f, 0x55, 0x60, 0x7e, 0x98, 0xfd, 0xfd, 0x33, 0x1c, 0xc6, 0x75, 0x50, 0x85, 0x93, 0x88,
	0xf0, 0x21, 0xae, 0x07, 0x10, 0x20, 0x1e, 0x13, 0x62, 0xf6, 0xfe, 0x7b, 0x25, 0x0c, 0x4b, 0x51,
	0x7f, 0x41, 0xd7, 0x40, 0xde, 0x10, 0x91, 0xbf, 0x53, 0x02, 0x20, 0xfe, 0x3c, 0xc8, 0x8f, 0xd1,
	0xbd, 0xca, 0x5b, 0x48, 0x6c, 0x33, 0x90, 0x35, 0x19, 0x91, 0x75, 0x05, 0x80, 0xf7, 0x77, 0x45,
	0x4b, 0x3a, 0xbe, 0xf3, 0x92, 0xe3, 0xd8, 0xbc, 0x23, 0x7d, 0x17, 0xb2, 0xd8, 0xb5, 0x04, 0x61,
	0x7c, 0x9d, 0x99, 0xc1, 0xae, 0xc5, 0xde, 0xb4, 0xf6, 0xa8, 0x2b, 0x23, 0xc8, 0x62, 0x2e, 0x83,
	0xa8, 0xa7, 0x2a, 0x3d, 0x0d, 0x81, 0x0a, 0x6f, 0xb6, 0x47, 0xb6, 0x26, 0x5e, 0xd8, 0xbe, 0x2d,
	0x9b, 0xb4, 0x1d, 0xf3, 0xc4, 0x88, 0xcc, 0xbf, 0xa9, 0x12, 0xc6, 0xae, 0x40, 0xed, 0xab, 0x6e,
	0x7d, 0x27, 0x4a, 0xcc, 0xd1, 0x4d, 0x87, 0xb3, 0xae, 0x21, 0x47, 0x22, 0xa9, 0xd1, 0xf0, 0x9c,
	0x70, 0x7e, 0x34, 0xc7, 0x20, 0x6b, 0x0c, 0x80, 0x1e, 0xc2, 0xd4, 0x81, 0x69, 0x35, 0x31, 0xf3,
	0x08, 0x76, 0x0d, 0xc6, 0x75, 0xee, 0xf7, 0x08, 0xf6, 0x57, 0x19, 0x81, 0x2e, 0xe9, 0xb4, 0xbb,
	0x90, 0x0b, 0x81, 0x03, 0x5d, 0x86, 0x22, 0x64, 0x8e, 0xb0, 0x4f, 0x58, 0x32, 0x22, 0x9b, 0xd5,
	0xf2, 0x75, 0xf1, 0x1e, 0xe4, 0xc2, 0xbf, 0x00, 0x48, 0x85, 0x4c, 0xa5, 0xfa, 0xa8, 0xbc, 0xb7,
	0xb9, 0x5b, 0xb8, 0x80, 0xf2, 0x00, 0x95, 0x6a, 0x7d, 0xad, 0xba, 0x55, 0xd9, 0xd8, 0x5a, 0x2f,
	0x28, 0x68, 0x06, 0x72, 0xe5, 0xf0, 0x35, 0xb1, 0xb8, 0x07, 0xd9, 0xa0, 0xd5, 0x8a, 0xa6, 0x21,
	0x5b, 0xdd, 0xaf, 0xea, 0x4f, 0xb7, 0xb7, 0xaa, 0x85, 0x0b, 0x0c, 0xb1, 0xb6, 0x5d, 0xa9, 0xea,
	0xe5, 0xdd, 0x6d, 0xbd, 0xa0, 0x30, 0xa6, 0x3b, 0xfa, 0xc6, 0x7e, 0x79, 0xb7, 0x5a, 0x48, 0xa0,
	0x59, 0x50, 0x57, 0xf5, 0xed, 0x72, 0x65, 0xad, 0x5c, 0xdf, 0xad, 0xea, 0x85, 0x24, 0x5b, 0xa5,
	0xbe, 0xb7, 0x5a, 0x5f, 0xd3, 0x37, 0x56, 0xab, 0x7a, 0x21, 0xbd, 0xf8, 0x09, 0x40, 0xb7, 0x55,
	0x83, 0x00, 0xa6, 0xf6, 0xb6, 0xf6, 0xea, 0xd5, 0x4a, 0xe1, 0x02, 0xca, 0x41, 0x7a, 0xfb, 0xe3,
	0xad, 0x2a, 0x63, 0x99, 0x83, 0x74, 0x7d, 0xb7, 0xfc, 0xe8, 0x51, 0x21, 0xc1, 0x1e, 0xcb, 0x95,
	0xda, 0xc6, 0x56, 0x21, 0xc9, 0xd6, 0x5d, 0xdf, 0xdc, 0x5e, 0x2d, 0x6f, 0xd6, 0xb6, 0x2b, 0x85,
	0x14, 0xca, 0x40, 0x92, 0x3d, 0xa4, 0x99, 0x00, 0x7a, 0x75, 0x7d, 0x6f, 0xb3, 0xac, 0x17, 0x66,
	0x17, 0xdf, 0x01, 0x35, 0x92, 0xd7, 0xa2, 0x02, 0x4c, 0xef, 0xd5, 0xab, 0xba, 0x51, 0xab, 0x6e,
	0xed, 0x6e, 0x6c, 0x6f, 0x15, 0x2e, 0x30, 0xc8, 0xe3, 0xaa, 0x5e, 0x0d, 0x21, 0xca, 0xe2, 0x43,
	0x80, 0xee, 0xdd, 0x8d, 0xb2, 0x90, 0xda, 0x12, 0xfb, 0xcc, 0x42, 0x6a, 0x6d, 0x73, 0x63, 0xa7,
	0xa0, 0xb0, 0xa5, 0xf6, 0xb7, 0x2b, 0x85, 0x04, 0x93, 0xb7, 0xbe, 0xab, 0x57, 0xcb, 0xb5, 0x42,
	0x92, 0x49, 0x56, 0xdd, 0xaf, 0x6e, 0xed, 0x16, 0x52, 0xcb, 0x3f, 0x2e, 0x40, 0x6e, 0x2d, 0xd0,
	0x1d, 0xa2, 0xa0, 0x46, 0x66, 0xab, 0x51, 0xdc, 0x95, 0x3f, 0x38, 0xd5, 0x5d, 0x5a, 0x9e, 0x84,
	0x44, 0xfe, 0x75, 0x38, 0x86, 0xe9, 0xe8, 0xcc, 0x34, 0x8a, 0xe3, 0x31, 0x64, 0x5e, 0xbb, 0x74,
	0x67, 0x22, 0x1a, 0xb9, 0xf0, 0xb7, 0x14, 0x98, 0xed, 0x1b, 0xf7, 0x45, 0x71, 0x0d, 0x82, 0xe1,
	0x03, 0xc7, 0xa5, 0xf7, 0x26, 0x25, 0x93, 0x22, 0x50, 0x50, 0x23, 0x03, 0xd7, 0xb1, 0x27, 0x3e,
	0x38, 0x42, 0x1e, 0x7b, 0xe2, 0xc3, 0xe6, 0xb9, 0x0f, 0x21, 0x23, 0x87, 0x1b, 0x50, 0x5c, 0xa3,
	0xac, 0x77, 0x8c, 0xb9, 0xb4, 0x34, 0x2e, 0xba, 0x5c, 0xe9, 0x33, 0x80, 0xee, 0xb4, 0x26, 0x8a,
	0xcb, 0xfe, 0x06, 0xa6, 0x8a, 0x4b, 0xef, 0x4c, 0x40, 0xd1, 0x5d, 0xb2, 0x3b, 0x55, 0x19, 0xbb,
	0xe4, 0xc0, 0xf0, 0x67, 0xec, 0x92, 0x43, 0x46, 0x36, 0x3f, 0x03, 0xe8, 0x0e, 0x11, 0xc5, 0x2e,
	0x39, 0x30, 0xa3, 0x19, 0xbb, 0xe4, 0x90, 0xf1, 0xbf, 0xff, 0x87, 0x7c, 0xef, 0x28, 0x1a, 0x7a,
	0x77, 0x6c, 0x26, 0x91, 0x99, 0xbf, 0xd2, 0xdd, 0x09, 0xa9, 0x22, 0xae, 0xd3, 0x37, 0x37, 0x85,
	0xc6, 0x67, 0x15, 0x9d, 0x6c, 0x8b, 0x75, 0x9d, 0x51, 0xe3, 0x59, 0x2e, 0xe4, 0xc2, 0x81, 0x25,
	0x74, 0x6b, 0x0c, 0x2f, 0x88, 0x8e, 0x63, 0x95, 0x6e, 0x8f, 0x4f, 0x20, 0xd7, 0xfb, 0x42, 0x81,
	0x42, 0xff, 0x58, 0x10, 0x7a, 0x6f, 0xe2, 0x39, 0x22, 0xb1, 0xfc, 0xbd, 0x33, 0xce, 0x1f, 0xb1,
	0x80, 0x11, 0x19, 0x45, 0x89, 0x0d, 0x18, 0x83, 0x93, 0x42, 0xb1, 0x01, 0x63, 0xd8, 0xd4, 0x0e,
	0x05, 0x35, 0x32, 0xf9, 0x11, 0xbb, 0xea, 0xe0, 0xcc, 0x4a, 0xec, 0xaa, 0xc3, 0x06, 0x4b, 0x3e,
	0x87, 0x99, 0x9e, 0xb9, 0x0b, 0x74, 0x67, 0x2c, 0xd7, 0xec, 0x5b, 0xf9, 0xdd, 0xc9, 0x88, 0x22,
	0x97, 0x52, 0x64, 0x66, 0x00, 0x8d, 0x17, 0x66, 0x7b, 0x86, 0x38, 0xe2, 0x2f, 0xa5, 0x61, 0x43,
	0x09, 0x5f, 0x2a, 0x30, 0x3f, 0xec, 0x27, 0x3d, 0x7a, 0x3f, 0x3e, 0xf4, 0x8e, 0x1a, 0x19, 0x28,
	0xdd, 0x3f, 0x13, 0xad, 0x90, 0x68, 0x55, 0xfd, 0xef, 0x5c, 0x88, 0x79, 0x30, 0xc5, 0x13, 0xe4,
	0x3b, 0x7f, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xb8, 0x24, 0x3b, 0xa2, 0x74, 0x36, 0x00, 0x00,
}
