// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: rpc/chatrooms/chatrooms.proto

/*
Package chatrooms is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	rpc/chatrooms/chatrooms.proto
*/
package chatrooms

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ===================
// Chatrooms Interface
// ===================

// Chatrooms service supports public and private chatrooms on Twitch.
type Chatrooms interface {
	// JoinChannel adds a user to a chatroom.
	JoinChannel(context.Context, *JoinChannelRequest) (*JoinChannelResponse, error)

	// LeaveChannel removes a user from a chatroom.
	LeaveChannel(context.Context, *LeaveChannelRequest) (*LeaveChannelResponse, error)

	// IsChannelMember returns whether the user has joined the channel
	IsChannelMember(context.Context, *IsChannelMemberRequest) (*IsChannelMemberResponse, error)

	// ListMembers returns a list of members in a room
	ListMembers(context.Context, *ListMembersRequest) (*ListMembersResponse, error)

	// GetRoom looks up a room by ID
	GetRoom(context.Context, *GetRoomRequest) (*GetRoomResponse, error)

	// CreateRoom creates a new chatroom.
	CreateRoom(context.Context, *CreateRoomRequest) (*CreateRoomResponse, error)

	// DeleteRoom creates a new chatroom.
	DeleteRoom(context.Context, *DeleteRoomRequest) (*DeleteRoomResponse, error)

	// UpdateRoom updates an existing chatroom's properties.
	UpdateRoom(context.Context, *UpdateRoomRequest) (*UpdateRoomResponse, error)

	// UpdateRoomView updates a user's view of a room.
	UpdateRoomView(context.Context, *UpdateRoomViewRequest) (*UpdateRoomViewResponse, error)

	// UpdateRoomModes updates an existing chatroom's properties.
	UpdateRoomModes(context.Context, *UpdateRoomModesRequest) (*UpdateRoomModesResponse, error)

	// ListRooms returns all rooms belonging to an owner visible to a user.
	ListRooms(context.Context, *ListRoomsRequest) (*ListRoomsResponse, error)

	// BulkGetRoomViews returns the room views associated with a list of room ids and a user.
	BulkGetRoomViews(context.Context, *BulkGetRoomViewsRequest) (*BulkGetRoomViewsResponse, error)

	// SendMessage sends a chat message to a room.
	SendMessage(context.Context, *SendMessageRequest) (*SendMessageResponse, error)

	// EditMessage edits an existing chat message.
	EditMessage(context.Context, *EditMessageRequest) (*EditMessageResponse, error)

	// DeleteMessage deletes an existing chat message.
	DeleteMessage(context.Context, *DeleteMessageRequest) (*DeleteMessageResponse, error)

	// ListMessages returns the most recent messages for a room.
	ListMessages(context.Context, *ListMessagesRequest) (*ListMessagesResponse, error)

	// GetChannelProperties returns chatroom-related channel properties.
	GetChannelProperties(context.Context, *GetChannelPropertiesRequest) (*GetChannelPropertiesResponse, error)
}

// =========================
// Chatrooms Protobuf Client
// =========================

type chatroomsProtobufClient struct {
	client HTTPClient
	urls   [17]string
}

// NewChatroomsProtobufClient creates a Protobuf client that implements the Chatrooms interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewChatroomsProtobufClient(addr string, client HTTPClient) Chatrooms {
	prefix := urlBase(addr) + ChatroomsPathPrefix
	urls := [17]string{
		prefix + "JoinChannel",
		prefix + "LeaveChannel",
		prefix + "IsChannelMember",
		prefix + "ListMembers",
		prefix + "GetRoom",
		prefix + "CreateRoom",
		prefix + "DeleteRoom",
		prefix + "UpdateRoom",
		prefix + "UpdateRoomView",
		prefix + "UpdateRoomModes",
		prefix + "ListRooms",
		prefix + "BulkGetRoomViews",
		prefix + "SendMessage",
		prefix + "EditMessage",
		prefix + "DeleteMessage",
		prefix + "ListMessages",
		prefix + "GetChannelProperties",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &chatroomsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &chatroomsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *chatroomsProtobufClient) JoinChannel(ctx context.Context, in *JoinChannelRequest) (*JoinChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "JoinChannel")
	out := new(JoinChannelResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) LeaveChannel(ctx context.Context, in *LeaveChannelRequest) (*LeaveChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveChannel")
	out := new(LeaveChannelResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) IsChannelMember(ctx context.Context, in *IsChannelMemberRequest) (*IsChannelMemberResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "IsChannelMember")
	out := new(IsChannelMemberResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) ListMembers(ctx context.Context, in *ListMembersRequest) (*ListMembersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "ListMembers")
	out := new(ListMembersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) GetRoom(ctx context.Context, in *GetRoomRequest) (*GetRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoom")
	out := new(GetRoomResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) CreateRoom(ctx context.Context, in *CreateRoomRequest) (*CreateRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRoom")
	out := new(CreateRoomResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) DeleteRoom(ctx context.Context, in *DeleteRoomRequest) (*DeleteRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRoom")
	out := new(DeleteRoomResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) UpdateRoom(ctx context.Context, in *UpdateRoomRequest) (*UpdateRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoom")
	out := new(UpdateRoomResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) UpdateRoomView(ctx context.Context, in *UpdateRoomViewRequest) (*UpdateRoomViewResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomView")
	out := new(UpdateRoomViewResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) UpdateRoomModes(ctx context.Context, in *UpdateRoomModesRequest) (*UpdateRoomModesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomModes")
	out := new(UpdateRoomModesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) ListRooms(ctx context.Context, in *ListRoomsRequest) (*ListRoomsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "ListRooms")
	out := new(ListRoomsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) BulkGetRoomViews(ctx context.Context, in *BulkGetRoomViewsRequest) (*BulkGetRoomViewsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetRoomViews")
	out := new(BulkGetRoomViewsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) SendMessage(ctx context.Context, in *SendMessageRequest) (*SendMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "SendMessage")
	out := new(SendMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) EditMessage(ctx context.Context, in *EditMessageRequest) (*EditMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "EditMessage")
	out := new(EditMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) DeleteMessage(ctx context.Context, in *DeleteMessageRequest) (*DeleteMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteMessage")
	out := new(DeleteMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) ListMessages(ctx context.Context, in *ListMessagesRequest) (*ListMessagesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "ListMessages")
	out := new(ListMessagesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *chatroomsProtobufClient) GetChannelProperties(ctx context.Context, in *GetChannelPropertiesRequest) (*GetChannelPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelProperties")
	out := new(GetChannelPropertiesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

// =====================
// Chatrooms JSON Client
// =====================

type chatroomsJSONClient struct {
	client HTTPClient
	urls   [17]string
}

// NewChatroomsJSONClient creates a JSON client that implements the Chatrooms interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewChatroomsJSONClient(addr string, client HTTPClient) Chatrooms {
	prefix := urlBase(addr) + ChatroomsPathPrefix
	urls := [17]string{
		prefix + "JoinChannel",
		prefix + "LeaveChannel",
		prefix + "IsChannelMember",
		prefix + "ListMembers",
		prefix + "GetRoom",
		prefix + "CreateRoom",
		prefix + "DeleteRoom",
		prefix + "UpdateRoom",
		prefix + "UpdateRoomView",
		prefix + "UpdateRoomModes",
		prefix + "ListRooms",
		prefix + "BulkGetRoomViews",
		prefix + "SendMessage",
		prefix + "EditMessage",
		prefix + "DeleteMessage",
		prefix + "ListMessages",
		prefix + "GetChannelProperties",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &chatroomsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &chatroomsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *chatroomsJSONClient) JoinChannel(ctx context.Context, in *JoinChannelRequest) (*JoinChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "JoinChannel")
	out := new(JoinChannelResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *chatroomsJSONClient) LeaveChannel(ctx context.Context, in *LeaveChannelRequest) (*LeaveChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveChannel")
	out := new(LeaveChannelResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *chatroomsJSONClient) IsChannelMember(ctx context.Context, in *IsChannelMemberRequest) (*IsChannelMemberResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "IsChannelMember")
	out := new(IsChannelMemberResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *chatroomsJSONClient) ListMembers(ctx context.Context, in *ListMembersRequest) (*ListMembersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "ListMembers")
	out := new(ListMembersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *chatroomsJSONClient) GetRoom(ctx context.Context, in *GetRoomRequest) (*GetRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoom")
	out := new(GetRoomResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *chatroomsJSONClient) CreateRoom(ctx context.Context, in *CreateRoomRequest) (*CreateRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRoom")
	out := new(CreateRoomResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *chatroomsJSONClient) DeleteRoom(ctx context.Context, in *DeleteRoomRequest) (*DeleteRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRoom")
	out := new(DeleteRoomResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *chatroomsJSONClient) UpdateRoom(ctx context.Context, in *UpdateRoomRequest) (*UpdateRoomResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoom")
	out := new(UpdateRoomResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *chatroomsJSONClient) UpdateRoomView(ctx context.Context, in *UpdateRoomViewRequest) (*UpdateRoomViewResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomView")
	out := new(UpdateRoomViewResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *chatroomsJSONClient) UpdateRoomModes(ctx context.Context, in *UpdateRoomModesRequest) (*UpdateRoomModesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomModes")
	out := new(UpdateRoomModesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *chatroomsJSONClient) ListRooms(ctx context.Context, in *ListRoomsRequest) (*ListRoomsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "ListRooms")
	out := new(ListRoomsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *chatroomsJSONClient) BulkGetRoomViews(ctx context.Context, in *BulkGetRoomViewsRequest) (*BulkGetRoomViewsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetRoomViews")
	out := new(BulkGetRoomViewsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *chatroomsJSONClient) SendMessage(ctx context.Context, in *SendMessageRequest) (*SendMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "SendMessage")
	out := new(SendMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *chatroomsJSONClient) EditMessage(ctx context.Context, in *EditMessageRequest) (*EditMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "EditMessage")
	out := new(EditMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *chatroomsJSONClient) DeleteMessage(ctx context.Context, in *DeleteMessageRequest) (*DeleteMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteMessage")
	out := new(DeleteMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *chatroomsJSONClient) ListMessages(ctx context.Context, in *ListMessagesRequest) (*ListMessagesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "ListMessages")
	out := new(ListMessagesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

func (c *chatroomsJSONClient) GetChannelProperties(ctx context.Context, in *GetChannelPropertiesRequest) (*GetChannelPropertiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelProperties")
	out := new(GetChannelPropertiesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	return out, err
}

// ========================
// Chatrooms Server Handler
// ========================

type chatroomsServer struct {
	Chatrooms
	hooks *twirp.ServerHooks
}

func NewChatroomsServer(svc Chatrooms, hooks *twirp.ServerHooks) TwirpServer {
	return &chatroomsServer{
		Chatrooms: svc,
		hooks:     hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *chatroomsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ChatroomsPathPrefix is used for all URL paths on a twirp Chatrooms server.
// Requests are always: POST ChatroomsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ChatroomsPathPrefix = "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/"

func (s *chatroomsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.chatrooms")
	ctx = ctxsetters.WithServiceName(ctx, "Chatrooms")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/JoinChannel":
		s.serveJoinChannel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/LeaveChannel":
		s.serveLeaveChannel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/IsChannelMember":
		s.serveIsChannelMember(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/ListMembers":
		s.serveListMembers(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/GetRoom":
		s.serveGetRoom(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/CreateRoom":
		s.serveCreateRoom(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/DeleteRoom":
		s.serveDeleteRoom(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/UpdateRoom":
		s.serveUpdateRoom(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/UpdateRoomView":
		s.serveUpdateRoomView(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/UpdateRoomModes":
		s.serveUpdateRoomModes(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/ListRooms":
		s.serveListRooms(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/BulkGetRoomViews":
		s.serveBulkGetRoomViews(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/SendMessage":
		s.serveSendMessage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/EditMessage":
		s.serveEditMessage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/DeleteMessage":
		s.serveDeleteMessage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/ListMessages":
		s.serveListMessages(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.chatrooms.Chatrooms/GetChannelProperties":
		s.serveGetChannelProperties(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *chatroomsServer) serveJoinChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveJoinChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveJoinChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveJoinChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "JoinChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(JoinChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *JoinChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.JoinChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JoinChannelResponse and nil error while calling JoinChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveJoinChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "JoinChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(JoinChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *JoinChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.JoinChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *JoinChannelResponse and nil error while calling JoinChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveLeaveChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLeaveChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLeaveChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveLeaveChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LeaveChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LeaveChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LeaveChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveChannelResponse and nil error while calling LeaveChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveLeaveChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(LeaveChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LeaveChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.LeaveChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveChannelResponse and nil error while calling LeaveChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveIsChannelMember(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsChannelMemberJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsChannelMemberProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveIsChannelMemberJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsChannelMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsChannelMemberRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *IsChannelMemberResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsChannelMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsChannelMemberResponse and nil error while calling IsChannelMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveIsChannelMemberProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsChannelMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(IsChannelMemberRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *IsChannelMemberResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsChannelMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsChannelMemberResponse and nil error while calling IsChannelMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveListMembers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListMembersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListMembersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveListMembersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListMembers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListMembersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListMembersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListMembers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListMembersResponse and nil error while calling ListMembers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveListMembersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListMembers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListMembersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListMembersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListMembers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListMembersResponse and nil error while calling ListMembers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveGetRoom(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRoomJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRoomProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveGetRoomJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRoomRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRoomResponse and nil error while calling GetRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveGetRoomProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRoomRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRoomResponse and nil error while calling GetRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveCreateRoom(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRoomJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRoomProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveCreateRoomJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRoomRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoomResponse and nil error while calling CreateRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveCreateRoomProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateRoomRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoomResponse and nil error while calling CreateRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveDeleteRoom(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteRoomJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteRoomProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveDeleteRoomJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteRoomRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoomResponse and nil error while calling DeleteRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveDeleteRoomProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteRoomRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoomResponse and nil error while calling DeleteRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveUpdateRoom(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRoomJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRoomProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveUpdateRoomJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRoomRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoomResponse and nil error while calling UpdateRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveUpdateRoomProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoom")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRoomRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoomResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRoom(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoomResponse and nil error while calling UpdateRoom. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveUpdateRoomView(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRoomViewJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRoomViewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveUpdateRoomViewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRoomViewRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoomViewResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRoomView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoomViewResponse and nil error while calling UpdateRoomView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveUpdateRoomViewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomView")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRoomViewRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoomViewResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRoomView(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoomViewResponse and nil error while calling UpdateRoomView. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveUpdateRoomModes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRoomModesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRoomModesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveUpdateRoomModesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomModes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRoomModesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoomModesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRoomModes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoomModesResponse and nil error while calling UpdateRoomModes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveUpdateRoomModesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRoomModes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateRoomModesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateRoomModesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateRoomModes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoomModesResponse and nil error while calling UpdateRoomModes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveListRooms(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListRoomsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListRoomsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveListRoomsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRooms")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListRoomsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListRoomsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListRooms(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRoomsResponse and nil error while calling ListRooms. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveListRoomsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRooms")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListRoomsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListRoomsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListRooms(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRoomsResponse and nil error while calling ListRooms. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveBulkGetRoomViews(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkGetRoomViewsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkGetRoomViewsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveBulkGetRoomViewsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetRoomViews")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkGetRoomViewsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkGetRoomViewsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.BulkGetRoomViews(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetRoomViewsResponse and nil error while calling BulkGetRoomViews. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveBulkGetRoomViewsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetRoomViews")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkGetRoomViewsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkGetRoomViewsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.BulkGetRoomViews(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetRoomViewsResponse and nil error while calling BulkGetRoomViews. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveSendMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveSendMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SendMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMessageResponse and nil error while calling SendMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveSendMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMessageResponse and nil error while calling SendMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveEditMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEditMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEditMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveEditMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EditMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EditMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EditMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EditMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EditMessageResponse and nil error while calling EditMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveEditMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EditMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EditMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EditMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EditMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EditMessageResponse and nil error while calling EditMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveDeleteMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveDeleteMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteMessageResponse and nil error while calling DeleteMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveDeleteMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteMessageResponse and nil error while calling DeleteMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveListMessages(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListMessagesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListMessagesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveListMessagesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListMessages")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListMessagesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListMessagesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListMessages(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListMessagesResponse and nil error while calling ListMessages. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveListMessagesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListMessages")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListMessagesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListMessagesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListMessages(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListMessagesResponse and nil error while calling ListMessages. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveGetChannelProperties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelPropertiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelPropertiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *chatroomsServer) serveGetChannelPropertiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelPropertiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelPropertiesResponse and nil error while calling GetChannelProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) serveGetChannelPropertiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelPropertiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelPropertiesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelPropertiesResponse and nil error while calling GetChannelProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *chatroomsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *chatroomsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3615 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x3a, 0x4b, 0x70, 0x1b, 0xd7,
	0x91, 0x1a, 0x7c, 0x08, 0xa0, 0x87, 0x04, 0xc1, 0x27, 0x4a, 0x82, 0x20, 0xd3, 0xd2, 0x8e, 0xed,
	0xb5, 0x4c, 0xdb, 0x94, 0x4c, 0x59, 0xd6, 0xd2, 0xb2, 0xbc, 0x02, 0x09, 0x88, 0xa2, 0x96, 0x20,
	0xe9, 0x01, 0x49, 0x97, 0x76, 0xb7, 0x3c, 0x1e, 0x62, 0x9e, 0xc0, 0x59, 0x0d, 0x66, 0xe0, 0x79,
	0x0f, 0xa4, 0xe8, 0xaa, 0xad, 0x4a, 0x95, 0x0f, 0xc9, 0x21, 0x29, 0x5f, 0x52, 0x95, 0x4b, 0x72,
	0x48, 0x25, 0xc7, 0x24, 0x87, 0xe4, 0x92, 0x43, 0x72, 0xf1, 0x35, 0x67, 0x9f, 0x72, 0x4a, 0xe5,
	0x92, 0x63, 0x2e, 0x39, 0xe4, 0x96, 0x7a, 0x9f, 0x19, 0x0c, 0x7e, 0x1c, 0x80, 0x74, 0xaa, 0x92,
	0xca, 0x6d, 0xa6, 0xa7, 0xbb, 0x5f, 0xbf, 0xd7, 0x9f, 0xd7, 0xdd, 0xd3, 0xb0, 0xe0, 0xb7, 0x1b,
	0xb7, 0x1a, 0x87, 0x26, 0xf5, 0x3d, 0xaf, 0x45, 0xba, 0x4f, 0x4b, 0x6d, 0xdf, 0xa3, 0x1e, 0x5a,
	0x68, 0x78, 0x16, 0x5e, 0xfa, 0xbf, 0x0e, 0xa1, 0xb6, 0xbb, 0x44, 0x8f, 0x96, 0xd8, 0xf7, 0xa5,
	0x10, 0xa9, 0xf4, 0x72, 0xd3, 0xf3, 0x9a, 0x0e, 0xbe, 0xc5, 0x91, 0x0f, 0x3a, 0xcf, 0x6e, 0x59,
	0x1d, 0xdf, 0xa4, 0xb6, 0xe7, 0x0a, 0xf2, 0xd2, 0xf5, 0xfe, 0xef, 0xd4, 0x6e, 0x61, 0x42, 0xcd,
	0x56, 0x5b, 0x22, 0x0c, 0x30, 0x38, 0xf6, 0xcd, 0x76, 0x1b, 0xfb, 0x72, 0x7d, 0x6d, 0x13, 0xd0,
	0x13, 0xcf, 0x76, 0xd7, 0x0e, 0x4d, 0xd7, 0xc5, 0x8e, 0x8e, 0x3f, 0xeb, 0x60, 0x42, 0xd1, 0x15,
	0xc8, 0x74, 0x08, 0xf6, 0x0d, 0xdb, 0x2a, 0x2a, 0x37, 0x94, 0x9b, 0x39, 0x7d, 0x8a, 0xbd, 0x6e,
	0x58, 0x68, 0x01, 0xa0, 0x21, 0x50, 0xd9, 0xb7, 0x04, 0xff, 0x96, 0x93, 0x90, 0x0d, 0x4b, 0xab,
	0xc1, 0xc5, 0x1e, 0x6e, 0xa4, 0xed, 0xb9, 0x04, 0x9f, 0x87, 0xdd, 0x26, 0x36, 0x8f, 0xf0, 0x37,
	0x24, 0xdd, 0x65, 0x98, 0xef, 0x65, 0x27, 0xc4, 0xd3, 0x7e, 0xa2, 0x00, 0xda, 0xb4, 0x09, 0xad,
	0xe1, 0xd6, 0x01, 0xf6, 0x49, 0x64, 0x19, 0xa6, 0x84, 0xc8, 0x32, 0xec, 0x75, 0xc3, 0x8a, 0xae,
	0x9f, 0xe8, 0x59, 0x7f, 0x1e, 0xd2, 0x8e, 0xdd, 0xb2, 0x69, 0x31, 0x79, 0x43, 0xb9, 0x99, 0xd4,
	0xc5, 0x0b, 0xba, 0x0c, 0x53, 0x8d, 0x8e, 0x4f, 0x3c, 0xbf, 0x98, 0x12, 0xd8, 0xe2, 0x0d, 0xbd,
	0x0d, 0xc8, 0x6e, 0xba, 0x9e, 0x8f, 0x8d, 0x36, 0xf6, 0x5b, 0x36, 0x21, 0xb6, 0xe7, 0x92, 0x62,
	0xfa, 0x86, 0x72, 0x33, 0xab, 0xcf, 0x89, 0x2f, 0x3b, 0xdd, 0x0f, 0xda, 0xcf, 0x14, 0xb8, 0xd8,
	0x23, 0xa5, 0x3c, 0xdc, 0x2a, 0x64, 0x7c, 0x4c, 0x3a, 0x0e, 0x25, 0x45, 0xe5, 0x46, 0xf2, 0xa6,
	0xba, 0xfc, 0xe6, 0xd2, 0xa9, 0x36, 0xb5, 0x24, 0x18, 0xe8, 0x9c, 0x46, 0x0f, 0x68, 0xd1, 0x22,
	0xcc, 0x1d, 0x9a, 0xc4, 0x68, 0xfb, 0xf8, 0xc8, 0xf6, 0x3a, 0xc4, 0x68, 0x9b, 0x4d, 0xcc, 0xb7,
	0x97, 0xd5, 0x67, 0x0f, 0x4d, 0xb2, 0x23, 0xe1, 0x3b, 0x66, 0x13, 0x23, 0x0d, 0x66, 0x18, 0xae,
	0x8b, 0x5f, 0x50, 0x81, 0x97, 0xe4, 0x78, 0xea, 0xa1, 0x49, 0xb6, 0xf0, 0x0b, 0xca, 0x70, 0xb4,
	0x1d, 0xb8, 0xbc, 0x41, 0xe4, 0x49, 0x07, 0x2b, 0x9e, 0x4f, 0x7d, 0x55, 0xb8, 0x32, 0xc0, 0x51,
	0x9e, 0xc1, 0x22, 0xcc, 0xd9, 0xc4, 0x08, 0x88, 0x5b, 0xfc, 0x23, 0x67, 0x9e, 0xd5, 0x67, 0xed,
	0x5e, 0x1a, 0xed, 0x4b, 0x05, 0xf2, 0xeb, 0x98, 0xea, 0x9e, 0xd7, 0x8a, 0xd5, 0xf4, 0xdd, 0x5e,
	0x4d, 0xab, 0xcb, 0x2f, 0x2d, 0x09, 0x7f, 0x5a, 0x0a, 0xfc, 0x69, 0xa9, 0x4e, 0x7d, 0xdb, 0x6d,
	0xee, 0x9b, 0x4e, 0x07, 0x87, 0x1b, 0x19, 0xae, 0xd9, 0xe4, 0x28, 0xcd, 0x3e, 0x81, 0xd9, 0x50,
	0x20, 0xb9, 0xa1, 0x7b, 0x90, 0x62, 0x22, 0x70, 0x71, 0xd4, 0xe5, 0x57, 0x62, 0x34, 0xca, 0x49,
	0x39, 0x81, 0xf6, 0xbb, 0x04, 0xcc, 0xad, 0xf9, 0xd8, 0xa4, 0x38, 0xba, 0xc1, 0x05, 0x00, 0xef,
	0xd8, 0xc5, 0xbe, 0x41, 0x4f, 0xda, 0x58, 0xee, 0x31, 0xc7, 0x21, 0xbb, 0x27, 0x6d, 0x8c, 0xae,
	0x42, 0x56, 0x7c, 0x0e, 0x8f, 0x3d, 0xc3, 0xdf, 0x37, 0x2c, 0x84, 0x20, 0xe5, 0x9a, 0x2d, 0xa1,
	0xe1, 0x9c, 0xce, 0x9f, 0x99, 0x99, 0x53, 0xaf, 0x6d, 0x37, 0xa4, 0x3d, 0x8b, 0x17, 0xf4, 0x1a,
	0xe4, 0x6d, 0x69, 0x3f, 0xf8, 0xd8, 0x3c, 0x70, 0x70, 0x11, 0xf8, 0x86, 0x67, 0x6c, 0x61, 0x3c,
	0x02, 0x88, 0x9e, 0xc2, 0x7c, 0xcb, 0x76, 0xed, 0x56, 0xa7, 0x65, 0x98, 0x8e, 0xe3, 0x1d, 0x63,
	0xcb, 0xf0, 0x3d, 0x07, 0x17, 0xd5, 0x1b, 0xca, 0xcd, 0xfc, 0xf2, 0xeb, 0xb1, 0x3b, 0x75, 0x30,
	0x13, 0x59, 0x47, 0x92, 0x49, 0x59, 0xf0, 0x60, 0x70, 0xb4, 0x03, 0x6a, 0xf4, 0xbc, 0xa7, 0xf9,
	0xd9, 0x2d, 0x8d, 0x71, 0x76, 0x11, 0x65, 0xe8, 0x51, 0x16, 0xda, 0xf7, 0x14, 0x98, 0xed, 0x43,
	0x40, 0xf7, 0x21, 0xe5, 0x63, 0x53, 0x58, 0xca, 0x04, 0x02, 0x73, 0x22, 0xf4, 0x00, 0xd2, 0xc7,
	0xbe, 0x4d, 0x85, 0x67, 0x4d, 0x40, 0x2d, 0xa8, 0xb4, 0x1f, 0x29, 0x70, 0xa9, 0x4f, 0x9e, 0xbd,
	0xb6, 0x65, 0x52, 0x8c, 0x1e, 0x46, 0xa4, 0x52, 0x97, 0xdf, 0x1a, 0x93, 0xaf, 0x30, 0x5b, 0x21,
	0xda, 0x6a, 0x54, 0xb4, 0x49, 0x59, 0x48, 0xf9, 0x6a, 0x80, 0xa2, 0xc6, 0x77, 0x5e, 0x63, 0xfe,
	0x1c, 0xe6, 0x2a, 0xd8, 0xc1, 0xbd, 0xb6, 0x3c, 0xd2, 0x59, 0x17, 0x00, 0x2c, 0x8e, 0x1d, 0xb1,
	0xe3, 0x9c, 0x84, 0x4c, 0xee, 0x94, 0x35, 0x40, 0xd1, 0xb5, 0xcf, 0xbb, 0x95, 0xaf, 0x93, 0x30,
	0x27, 0x54, 0x35, 0xd6, 0x5e, 0x46, 0x5e, 0x31, 0xb7, 0xa5, 0x3f, 0xa6, 0xc7, 0x08, 0x47, 0xc2,
	0x5b, 0x97, 0x03, 0x6f, 0x9d, 0x1a, 0x83, 0x44, 0xfa, 0xf2, 0xf0, 0xb3, 0xca, 0x8c, 0x38, 0x2b,
	0x54, 0x1e, 0xea, 0xfa, 0xea, 0x72, 0x69, 0x60, 0xad, 0x55, 0xcf, 0x73, 0xc4, 0x4a, 0x7d, 0x61,
	0xe1, 0x93, 0x53, 0xc2, 0xc2, 0xa4, 0xc6, 0x38, 0x2c, 0x36, 0xec, 0x0f, 0x8b, 0x0d, 0xef, 0x4e,
	0x16, 0x1b, 0xa4, 0xfe, 0x7a, 0x22, 0x44, 0x0d, 0x50, 0x54, 0xad, 0xe7, 0x35, 0x93, 0x5f, 0x27,
	0xe0, 0x52, 0x97, 0xdf, 0xbe, 0x8d, 0x8f, 0xcf, 0x6e, 0x2a, 0x1f, 0xc0, 0xb4, 0x63, 0x12, 0x6a,
	0x30, 0xef, 0x36, 0x4c, 0x91, 0x94, 0x0c, 0xd3, 0xc9, 0x6e, 0x90, 0x32, 0xea, 0xc0, 0xf0, 0x75,
	0x6c, 0x5a, 0x65, 0x8a, 0xee, 0x42, 0xd6, 0x26, 0x46, 0xab, 0x43, 0xb1, 0xc5, 0xe3, 0xfc, 0xe9,
	0xda, 0xcc, 0xd8, 0xa4, 0xc6, 0x50, 0xd1, 0x7d, 0x50, 0x6d, 0x62, 0x98, 0x7e, 0xe3, 0xd0, 0x3e,
	0xc2, 0x96, 0x34, 0xd3, 0xd3, 0x28, 0xc1, 0x26, 0x65, 0x89, 0x8d, 0xee, 0x43, 0xc9, 0xc7, 0x04,
	0x53, 0xa3, 0xe3, 0x72, 0xa1, 0x5b, 0xd8, 0x65, 0xb9, 0xae, 0xd1, 0xf0, 0x3a, 0x2e, 0xe5, 0xa6,
	0x90, 0xd5, 0xaf, 0x70, 0x8c, 0x3d, 0x8e, 0x50, 0x13, 0xdf, 0xd7, 0xd8, 0x67, 0xed, 0x13, 0xb8,
	0xdc, 0x7f, 0x72, 0x52, 0x1b, 0x15, 0xc8, 0xf1, 0xa3, 0x63, 0xc6, 0x26, 0x55, 0xf2, 0xfa, 0x18,
	0x2a, 0xe1, 0x3c, 0xb2, 0xbe, 0x7c, 0xd2, 0xfe, 0x9c, 0x88, 0x2e, 0x50, 0xf3, 0x2c, 0x7c, 0x8e,
	0x4c, 0xf1, 0x23, 0xb8, 0x82, 0x5d, 0x66, 0xf8, 0x06, 0x6e, 0x79, 0x14, 0x13, 0xc3, 0x73, 0x9d,
	0x13, 0xa3, 0xe5, 0x59, 0x78, 0xa4, 0x9a, 0xba, 0x47, 0x36, 0x2f, 0x48, 0xab, 0x9c, 0x72, 0xdb,
	0x75, 0x4e, 0x98, 0x30, 0x68, 0x15, 0x66, 0x25, 0x4b, 0x7f, 0xe5, 0xb9, 0x60, 0x15, 0xaf, 0xb7,
	0x19, 0x41, 0xa2, 0xaf, 0x3c, 0xe7, 0x3c, 0x2a, 0x50, 0x90, 0x3c, 0x88, 0xe3, 0x1d, 0x0b, 0x26,
	0xf1, 0x2a, 0xcc, 0x0b, 0x9a, 0xba, 0xe3, 0x1d, 0x73, 0x2e, 0xeb, 0x80, 0x42, 0x72, 0x23, 0x28,
	0x58, 0x64, 0xf8, 0xb9, 0x3a, 0xc0, 0xa7, 0x22, 0x11, 0xf4, 0x02, 0x91, 0x0c, 0x02, 0x88, 0xa6,
	0xc3, 0x95, 0x81, 0x13, 0x3f, 0xaf, 0x87, 0xfd, 0x52, 0x81, 0x02, 0x4b, 0xa3, 0x19, 0x88, 0x9c,
	0x3f, 0x3f, 0x8a, 0x64, 0x88, 0xc9, 0x73, 0x67, 0x88, 0xa9, 0x51, 0x97, 0xd1, 0x16, 0xcc, 0x45,
	0x64, 0x96, 0x47, 0xb0, 0x02, 0x69, 0xbe, 0x3b, 0x99, 0xf6, 0x8f, 0x75, 0x06, 0x82, 0x42, 0x7b,
	0x0e, 0x57, 0x56, 0x3b, 0xce, 0x73, 0x99, 0x75, 0x32, 0xf3, 0x0e, 0x8f, 0xe2, 0x6e, 0x6f, 0x76,
	0x3e, 0xee, 0x86, 0xae, 0x42, 0x56, 0xba, 0x00, 0x29, 0x26, 0x6e, 0x24, 0xd9, 0x11, 0x09, 0x1f,
	0x20, 0xda, 0x9f, 0x14, 0x28, 0x0e, 0xae, 0x26, 0x37, 0x81, 0x01, 0x42, 0xdf, 0x0c, 0x76, 0xf2,
	0x28, 0x66, 0x27, 0xa3, 0x98, 0x85, 0x5e, 0x4b, 0xaa, 0x2e, 0xf5, 0x4f, 0xf4, 0x5c, 0xe0, 0xbb,
	0xa4, 0x84, 0x21, 0xdf, 0xfb, 0x11, 0x15, 0x20, 0xf9, 0x1c, 0x9f, 0x48, 0x5d, 0xb3, 0x47, 0x96,
	0x9b, 0x1d, 0xb1, 0x3d, 0xc9, 0x04, 0x68, 0xec, 0x10, 0x21, 0xa8, 0xde, 0x4f, 0xfc, 0x87, 0xa2,
	0xfd, 0x54, 0x01, 0x54, 0xc7, 0xae, 0x55, 0xc3, 0x84, 0x98, 0x4d, 0x1c, 0x9c, 0xe9, 0x35, 0xc8,
	0x11, 0xec, 0x5a, 0xd1, 0x9a, 0x27, 0x2b, 0x00, 0x22, 0x46, 0x04, 0xc1, 0x23, 0xd1, 0x13, 0x3c,
	0xfe, 0x0d, 0xa6, 0x5b, 0x82, 0x8f, 0x41, 0xf1, 0x0b, 0x2a, 0x53, 0x70, 0x55, 0xc2, 0x76, 0xf1,
	0x0b, 0x8a, 0xae, 0x83, 0x7a, 0x60, 0x53, 0x62, 0x98, 0x2d, 0x1e, 0x21, 0x81, 0x97, 0x9d, 0xc0,
	0x40, 0x65, 0x0e, 0x61, 0xa9, 0xba, 0xeb, 0xb9, 0x0d, 0x5c, 0x9c, 0x15, 0xa9, 0x3a, 0x7f, 0xd1,
	0xbe, 0x4a, 0xc0, 0xc5, 0x1e, 0x31, 0xa5, 0x32, 0x8a, 0x90, 0x21, 0x9d, 0x46, 0x03, 0x13, 0x22,
	0x8b, 0xa7, 0xe0, 0x15, 0x3d, 0x84, 0x8c, 0x5c, 0x57, 0x9e, 0xce, 0xbf, 0xc7, 0x16, 0x99, 0x82,
	0x75, 0x40, 0x86, 0x5e, 0x81, 0x19, 0x5f, 0xae, 0x63, 0x30, 0x52, 0x2e, 0x6c, 0x4e, 0x9f, 0x0e,
	0x80, 0x6b, 0x2c, 0x72, 0xd8, 0x11, 0x24, 0xd3, 0x6f, 0x92, 0xa2, 0xca, 0x0d, 0xa2, 0x12, 0xb3,
	0xd8, 0x90, 0xbd, 0x2c, 0x05, 0x0f, 0x65, 0xbf, 0x29, 0xcd, 0x21, 0x5c, 0x8a, 0x81, 0x4a, 0xff,
	0x09, 0x73, 0x03, 0x28, 0x43, 0x8c, 0x62, 0x3e, 0x6a, 0x14, 0xb9, 0xa8, 0xae, 0xbf, 0xab, 0x00,
	0xaa, 0x5a, 0x36, 0xed, 0xd3, 0xf5, 0x02, 0x40, 0xa0, 0xb5, 0x50, 0xd9, 0x39, 0x09, 0xd9, 0xb0,
	0x98, 0x29, 0x60, 0xcb, 0xa6, 0x5e, 0x24, 0x96, 0x64, 0x05, 0xa0, 0xd7, 0x14, 0x92, 0xa7, 0x9a,
	0x42, 0x6a, 0xc0, 0x14, 0xb4, 0x8f, 0xe1, 0x62, 0x8f, 0x34, 0x52, 0xa5, 0x11, 0xc5, 0x29, 0x67,
	0x52, 0x9c, 0xf6, 0x43, 0x05, 0xe6, 0x45, 0x26, 0x3c, 0xd9, 0x4e, 0x63, 0xd2, 0xf1, 0x91, 0x7b,
	0x9d, 0x30, 0x34, 0x3e, 0x85, 0x4b, 0x7d, 0xd2, 0x7d, 0x63, 0x3b, 0xff, 0x43, 0x22, 0xe8, 0xb8,
	0xf0, 0xf7, 0x73, 0x5c, 0xf7, 0x93, 0xd5, 0x1e, 0xdd, 0x3e, 0x12, 0x44, 0xfb, 0x48, 0xc5, 0xb0,
	0x8f, 0xc4, 0x32, 0xa1, 0xdc, 0xe3, 0x0b, 0x61, 0x27, 0x69, 0x05, 0x72, 0xcf, 0x7c, 0xaf, 0x65,
	0x50, 0xbb, 0x85, 0x8b, 0x33, 0x71, 0x69, 0xde, 0xe3, 0x0b, 0x7a, 0x96, 0xa1, 0x33, 0x00, 0x5a,
	0x07, 0x20, 0x9e, 0x4f, 0x0d, 0xcf, 0xb7, 0xb0, 0xcf, 0xd3, 0xe2, 0xfc, 0xf2, 0xcd, 0x38, 0x77,
	0xf3, 0x7c, 0xba, 0xcd, 0xf0, 0xf5, 0x1c, 0x09, 0x1e, 0xd1, 0xeb, 0x30, 0x6b, 0xbb, 0x0d, 0xa7,
	0x63, 0x61, 0xe3, 0xd0, 0x26, 0xd4, 0xf3, 0x4f, 0x8a, 0x79, 0xbe, 0xbf, 0xbc, 0x04, 0x3f, 0x16,
	0xd0, 0xd5, 0x69, 0x00, 0xc7, 0x26, 0xd4, 0x20, 0xd4, 0xf4, 0xa9, 0xf6, 0x0b, 0x05, 0xe6, 0x7b,
	0xcf, 0x58, 0xaa, 0xef, 0x51, 0x7f, 0x5b, 0xeb, 0xad, 0x31, 0xd5, 0xf7, 0x77, 0xee, 0x6b, 0x7d,
	0x0c, 0xd7, 0xd6, 0x31, 0x95, 0x2d, 0xa5, 0x1d, 0xdf, 0x6b, 0x63, 0x9f, 0xda, 0xf8, 0xfc, 0x99,
	0x84, 0xf6, 0x04, 0x5e, 0x1a, 0xce, 0xb8, 0xdb, 0xe3, 0x6a, 0x99, 0x2f, 0x22, 0xd5, 0x91, 0xb8,
	0xfa, 0x99, 0x81, 0xcc, 0xb6, 0xcc, 0x17, 0x61, 0xb1, 0xc3, 0xee, 0xf7, 0x2d, 0x98, 0xe9, 0x29,
	0x89, 0xba, 0x77, 0xdb, 0x84, 0x5d, 0x0b, 0x41, 0xa5, 0xfd, 0x3c, 0x09, 0x29, 0xc6, 0x19, 0xe5,
	0x21, 0x11, 0x5a, 0x7d, 0xc2, 0xb6, 0xfa, 0xb6, 0x9b, 0x38, 0x6d, 0xbb, 0xc9, 0xe1, 0x8d, 0xa5,
	0xd4, 0xb0, 0xc6, 0x52, 0xfa, 0x1f, 0xba, 0xb1, 0x34, 0x73, 0xee, 0xc6, 0x12, 0x7a, 0x1f, 0xd2,
	0x2c, 0x3b, 0x0e, 0x0a, 0xd1, 0x57, 0xe3, 0x6c, 0x9b, 0xe7, 0xbe, 0x82, 0x44, 0x5c, 0x06, 0xad,
	0x03, 0xec, 0xcb, 0xba, 0x68, 0x96, 0xdb, 0x80, 0x2a, 0x60, 0xa2, 0x16, 0xfa, 0x95, 0x02, 0x69,
	0x4e, 0x33, 0x22, 0x17, 0x57, 0x26, 0xce, 0xc5, 0xd1, 0x4d, 0x28, 0x04, 0x75, 0x85, 0x21, 0xf2,
	0x7d, 0x4b, 0xba, 0x51, 0xde, 0x17, 0xd5, 0x43, 0x55, 0x40, 0xd1, 0x3d, 0x28, 0xf6, 0x17, 0x35,
	0x21, 0x85, 0x70, 0xa8, 0x4b, 0xb8, 0xa7, 0x74, 0x91, 0x84, 0xda, 0x1f, 0x13, 0x90, 0x0d, 0xb2,
	0xaa, 0x01, 0x4b, 0x1b, 0x99, 0x26, 0x5d, 0xe9, 0xcd, 0xc0, 0x47, 0xd7, 0xbf, 0xa9, 0x89, 0xea,
	0xdf, 0xab, 0x91, 0xfa, 0x57, 0xf4, 0xe4, 0xc3, 0x1a, 0xf7, 0x7a, 0x6f, 0x8d, 0x3b, 0xc5, 0xbf,
	0x46, 0xeb, 0xd8, 0x6b, 0x90, 0xb3, 0x89, 0x2c, 0x62, 0xa5, 0xb1, 0x66, 0x6d, 0x22, 0x6a, 0x56,
	0x74, 0x1b, 0xe6, 0x47, 0x96, 0xb7, 0x49, 0x1d, 0x75, 0x06, 0x2a, 0x5b, 0xb4, 0x39, 0xac, 0x77,
	0xb1, 0x18, 0x63, 0x32, 0x23, 0x7b, 0x9a, 0x04, 0xd4, 0xe8, 0x5d, 0xc3, 0xf3, 0x32, 0x2e, 0x8c,
	0x08, 0xc0, 0x32, 0xf3, 0x9b, 0x16, 0x52, 0x08, 0x18, 0x43, 0x62, 0xf9, 0x6a, 0x17, 0x49, 0x68,
	0x7e, 0x9a, 0x74, 0x13, 0x2f, 0x82, 0x4a, 0x90, 0x65, 0xba, 0xf6, 0x4d, 0x1a, 0x04, 0xce, 0xf0,
	0x5d, 0xc3, 0x30, 0x1d, 0xfd, 0xed, 0x80, 0x1e, 0xc0, 0x54, 0xa4, 0x4b, 0xaf, 0x2e, 0xbf, 0x36,
	0xde, 0x3f, 0x0b, 0x49, 0x14, 0xf9, 0xa5, 0x92, 0x88, 0xfe, 0x52, 0xd1, 0x3e, 0x85, 0x29, 0x81,
	0x39, 0xfa, 0x27, 0xc3, 0x03, 0x48, 0xf1, 0x58, 0x95, 0xe4, 0x61, 0xe1, 0x8d, 0xb1, 0xd6, 0x15,
	0x0d, 0x5c, 0x46, 0xa6, 0xd9, 0x30, 0xd3, 0x73, 0xd1, 0x9c, 0x3f, 0xcd, 0x18, 0xb9, 0x99, 0xdf,
	0x26, 0x21, 0x23, 0x91, 0xc7, 0xf7, 0x86, 0x3b, 0x90, 0x21, 0xd8, 0xa5, 0xe3, 0xf5, 0x7b, 0xa6,
	0x18, 0x6a, 0x99, 0xb2, 0x88, 0xc2, 0x22, 0x6c, 0xe7, 0xc0, 0xb1, 0xc9, 0xa1, 0xec, 0xf7, 0x64,
	0x75, 0xd5, 0x26, 0x3b, 0x01, 0x08, 0xad, 0x04, 0xd9, 0x1c, 0x77, 0xa5, 0x74, 0x2c, 0x6b, 0x99,
	0xe9, 0x31, 0x4f, 0x5a, 0x87, 0x4c, 0xc3, 0x73, 0x29, 0x96, 0x05, 0x8a, 0xba, 0xfc, 0xf6, 0x78,
	0x27, 0xb4, 0x26, 0x88, 0xf4, 0x80, 0x1a, 0x55, 0x60, 0x4a, 0x54, 0x4d, 0x63, 0x76, 0x05, 0x25,
	0x9f, 0x3a, 0xa7, 0xd1, 0x25, 0x2d, 0x4b, 0x2c, 0x82, 0x04, 0x65, 0x7a, 0x92, 0xc4, 0x82, 0xdd,
	0xcc, 0x4c, 0x6d, 0x92, 0xb8, 0xbf, 0xf6, 0x9a, 0xe9, 0xaf, 0xbd, 0xb4, 0xbf, 0x28, 0xa1, 0xad,
	0x08, 0xda, 0xb3, 0xd6, 0xd6, 0xd7, 0x41, 0x35, 0x1b, 0x3c, 0x52, 0x44, 0x6e, 0x59, 0x10, 0x20,
	0x7e, 0xcd, 0xae, 0x00, 0x74, 0x78, 0x9f, 0x64, 0xcc, 0x3e, 0x5f, 0x4e, 0x62, 0x97, 0x29, 0xfa,
	0x08, 0x0a, 0x9e, 0x6f, 0x37, 0x6d, 0xd7, 0x74, 0x02, 0xef, 0x96, 0x81, 0x72, 0x5c, 0x3b, 0x9e,
	0x0d, 0xe8, 0x25, 0x40, 0x3b, 0x81, 0x7c, 0xaf, 0x06, 0xd9, 0x5d, 0xcf, 0xcb, 0x16, 0x61, 0xbf,
	0xfc, 0x19, 0xd5, 0x59, 0xce, 0x6a, 0x36, 0x59, 0x0c, 0x14, 0x1d, 0x03, 0x75, 0xf9, 0xee, 0x44,
	0x76, 0xf1, 0x48, 0x52, 0xeb, 0x5d, 0x3e, 0xda, 0xd7, 0x29, 0xb8, 0x3c, 0x1c, 0x6b, 0xa8, 0x0c,
	0x4f, 0x21, 0xcb, 0x6e, 0x22, 0xbb, 0xe1, 0xb9, 0xd2, 0xa4, 0x1f, 0x9c, 0x49, 0x84, 0xaa, 0x64,
	0xa2, 0x87, 0xec, 0x90, 0x01, 0xd3, 0x5c, 0xd5, 0x32, 0xc6, 0xcb, 0xee, 0xd7, 0x07, 0x67, 0x62,
	0x2f, 0x2f, 0x03, 0x5d, 0x65, 0x1c, 0xe5, 0x0b, 0xaa, 0x41, 0xca, 0xb1, 0xdd, 0xe7, 0xbc, 0x29,
	0xaf, 0x2e, 0xaf, 0x9c, 0x89, 0xf1, 0xa6, 0xed, 0x3e, 0xd7, 0x39, 0x1b, 0xf4, 0x0c, 0x66, 0x9a,
	0xbe, 0xd7, 0x69, 0x87, 0x02, 0x67, 0x39, 0xdf, 0xf2, 0x99, 0xf8, 0xae, 0x33, 0x4e, 0x81, 0xd4,
	0xd3, 0xcd, 0xc8, 0x1b, 0xfa, 0x5f, 0xc8, 0x35, 0x0e, 0x31, 0xf6, 0x59, 0x02, 0x50, 0xcc, 0xf1,
	0x35, 0x3e, 0x3c, 0xd3, 0x1a, 0x6b, 0x01, 0x17, 0xbd, 0xcb, 0x10, 0xed, 0x43, 0xc6, 0xec, 0x50,
	0xaf, 0xe5, 0x59, 0x32, 0xd4, 0x9c, 0xed, 0xc0, 0xcb, 0x1d, 0xea, 0xd5, 0x3c, 0x4b, 0x0f, 0x98,
	0x69, 0xcf, 0xe0, 0xe5, 0xd3, 0x35, 0x8f, 0x5e, 0x06, 0x08, 0x74, 0xbf, 0x51, 0x91, 0x46, 0x16,
	0x81, 0xa0, 0x57, 0x61, 0x26, 0x78, 0xab, 0x63, 0xba, 0x51, 0x91, 0x5e, 0xdc, 0x0b, 0xd4, 0x5c,
	0xb8, 0x1e, 0xb3, 0x5b, 0x76, 0x5b, 0xb4, 0x7d, 0xfc, 0xcc, 0x7e, 0x11, 0xdc, 0x6b, 0xe2, 0xad,
	0x3f, 0x1c, 0x25, 0x06, 0x5a, 0x41, 0xcc, 0x01, 0x6c, 0xec, 0xcb, 0xd9, 0x04, 0xfe, 0xac, 0x59,
	0xa0, 0xc5, 0x6b, 0x10, 0x7d, 0x28, 0xaf, 0x4c, 0x51, 0x3b, 0x2c, 0xc6, 0x1e, 0xa9, 0x1b, 0x04,
	0x26, 0x79, 0x67, 0xfe, 0x40, 0x81, 0xd2, 0x68, 0x03, 0x64, 0x82, 0x1d, 0x7a, 0x24, 0xf4, 0x4c,
	0xf6, 0x8c, 0x30, 0xe4, 0xd9, 0xcd, 0xcb, 0x32, 0x0e, 0x6a, 0x5a, 0x26, 0x35, 0x65, 0xdb, 0xe9,
	0xc3, 0x33, 0xdb, 0x79, 0x95, 0xb1, 0x63, 0xe7, 0x7d, 0x80, 0xad, 0x9a, 0x64, 0xaa, 0x7d, 0x3f,
	0x39, 0xea, 0xc0, 0x43, 0x12, 0x56, 0xe2, 0x60, 0xdf, 0xf7, 0x7c, 0xd1, 0xb5, 0x92, 0x15, 0x1d,
	0x87, 0xf0, 0x96, 0xd5, 0x75, 0x50, 0x7d, 0x51, 0xfb, 0x19, 0x1d, 0xdf, 0x09, 0x82, 0xb3, 0x04,
	0xed, 0xf9, 0x0e, 0x3f, 0xf7, 0x20, 0xe1, 0xc8, 0x89, 0x13, 0xe1, 0x85, 0x8e, 0x4d, 0x1d, 0x1c,
	0xfe, 0x41, 0x67, 0x2f, 0xe8, 0x06, 0xa8, 0x16, 0x26, 0x0d, 0xdf, 0x6e, 0x73, 0x0f, 0x14, 0x45,
	0x50, 0x14, 0xc4, 0x6f, 0x82, 0x0e, 0x3d, 0xf4, 0x7c, 0x83, 0xd7, 0x4e, 0x53, 0xf2, 0x26, 0xe0,
	0xa0, 0x2d, 0x56, 0x41, 0x2d, 0x80, 0x7c, 0xe3, 0xc2, 0x64, 0x84, 0xb0, 0x02, 0xc2, 0x64, 0x79,
	0x05, 0x66, 0xe8, 0x61, 0xa7, 0x75, 0xe0, 0x9a, 0xb6, 0xc3, 0x31, 0xb2, 0xa2, 0x09, 0x17, 0x02,
	0x25, 0x52, 0xdb, 0xf7, 0x8e, 0x6c, 0x0b, 0xcb, 0x65, 0x72, 0x02, 0x29, 0x00, 0xf2, 0x85, 0xfe,
	0x07, 0x66, 0xe9, 0xb1, 0x4d, 0x1b, 0x87, 0x5d, 0x0d, 0x09, 0x8f, 0x5b, 0x8e, 0xd1, 0xd0, 0x2e,
	0xa7, 0xaa, 0x46, 0xd5, 0xa0, 0xe7, 0x05, 0xab, 0x50, 0x2d, 0xbf, 0x51, 0x60, 0xe1, 0x54, 0xcf,
	0x44, 0x9f, 0xc2, 0x14, 0x2f, 0x0e, 0x83, 0xe6, 0xc0, 0xe3, 0xf3, 0xf8, 0xf9, 0xd2, 0x2e, 0x67,
	0x25, 0xba, 0x84, 0x92, 0x6f, 0x69, 0x05, 0xd4, 0x08, 0x38, 0xae, 0x33, 0x98, 0x8c, 0x76, 0x06,
	0xbf, 0x48, 0xc2, 0xc5, 0x21, 0xdb, 0x44, 0x4f, 0x40, 0x95, 0x67, 0x16, 0x71, 0xa7, 0x37, 0xc6,
	0x3a, 0x2f, 0xee, 0x4d, 0x40, 0xc3, 0x67, 0x54, 0x85, 0x54, 0xc3, 0xb1, 0xdb, 0xd2, 0x2d, 0xde,
	0x19, 0x8b, 0xc9, 0x9a, 0x63, 0xb7, 0xc3, 0x33, 0xe7, 0xe4, 0x68, 0x15, 0x92, 0x47, 0x5e, 0xf0,
	0xeb, 0xe2, 0xf6, 0x58, 0x5c, 0xf6, 0xb7, 0x2b, 0x21, 0x13, 0x46, 0x8c, 0xfe, 0x0b, 0xa6, 0x08,
	0xf5, 0xb1, 0xd9, 0x92, 0x89, 0xc3, 0x9d, 0xb1, 0xd8, 0xd4, 0x39, 0x49, 0xc8, 0x49, 0xb2, 0x40,
	0x8f, 0x21, 0x8d, 0x8f, 0x58, 0xaa, 0x98, 0x9e, 0xc4, 0x9a, 0x8e, 0xf8, 0x2d, 0x29, 0x59, 0x09,
	0x06, 0xda, 0x77, 0x12, 0x80, 0x06, 0xf7, 0x8d, 0x5e, 0x83, 0xfc, 0x81, 0xef, 0x99, 0x56, 0xc3,
	0x24, 0x34, 0x5a, 0x1f, 0xcc, 0x44, 0xa0, 0x1b, 0x16, 0x7a, 0x13, 0xe6, 0xa2, 0x68, 0x8e, 0xd7,
	0xb4, 0x5d, 0xe9, 0xdc, 0x85, 0xc8, 0x87, 0x4d, 0x06, 0x67, 0xf9, 0x57, 0x83, 0x8f, 0x3d, 0x8c,
	0x9b, 0x7f, 0x49, 0xec, 0x32, 0x8f, 0xca, 0xcd, 0x48, 0x1b, 0x84, 0x3d, 0xb3, 0x0a, 0x91, 0x39,
	0x9a, 0x67, 0x38, 0xd8, 0x6d, 0xd2, 0x43, 0x83, 0xe0, 0x86, 0xe7, 0x5a, 0x62, 0x34, 0x2c, 0xad,
	0x23, 0xfe, 0x6d, 0x93, 0x7f, 0xaa, 0x8b, 0x2f, 0xcc, 0xed, 0x8f, 0x6c, 0x7c, 0x2c, 0x2b, 0xc9,
	0x29, 0x8e, 0x97, 0x63, 0x10, 0xd1, 0x0e, 0xf8, 0x76, 0x02, 0xe6, 0x06, 0x94, 0xf7, 0x2f, 0x79,
	0x12, 0x7f, 0x55, 0x60, 0x7e, 0x98, 0xfd, 0xfd, 0x33, 0x1c, 0xc6, 0x75, 0x50, 0x85, 0x93, 0x88,
	0xf0, 0x21, 0xae, 0x07, 0x10, 0x20, 0x1e, 0x13, 0x62, 0xf6, 0xfe, 0x7b, 0x25, 0x0c, 0x4b, 0x51,
	0x7f, 0x41, 0xd7, 0x40, 0xde, 0x10, 0x91, 0xbf, 0x53, 0x02, 0x20, 0xfe, 0x3c, 0xc8, 0x8f, 0xd1,
	0xbd, 0xca, 0x5b, 0x48, 0x6c, 0x33, 0x90, 0x35, 0x19, 0x91, 0x75, 0x05, 0x80, 0xf7, 0x77, 0x45,
	0x4b, 0x3a, 0xbe, 0xf3, 0x92, 0xe3, 0xd8, 0xbc, 0x23, 0x7d, 0x17, 0xb2, 0xd8, 0xb5, 0x04, 0x61,
	0x7c, 0x9d, 0x99, 0xc1, 0xae, 0xc5, 0xde, 0xb4, 0xf6, 0xa8, 0x2b, 0x23, 0xc8, 0x62, 0x2e, 0x83,
	0xa8, 0xa7, 0x2a, 0x3d, 0x0d, 0x81, 0x0a, 0x6f, 0xb6, 0x47, 0xb6, 0x26, 0x5e, 0xd8, 0xbe, 0x2d,
	0x9b, 0xb4, 0x1d, 0xf3, 0xc4, 0x88, 0xcc, 0xbf, 0xa9, 0x12, 0xc6, 0xae, 0x40, 0xed, 0xab, 0x6e,
	0x7d, 0x27, 0x4a, 0xcc, 0xd1, 0x4d, 0x87, 0xb3, 0xae, 0x21, 0x47, 0x22, 0xa9, 0xd1, 0xf0, 0x9c,
	0x70, 0x7e, 0x34, 0xc7, 0x20, 0x6b, 0x0c, 0x80, 0x1e, 0xc2, 0xd4, 0x81, 0x69, 0x35, 0x31, 0xf3,
	0x08, 0x76, 0x0d, 0xc6, 0x75, 0xee, 0xf7, 0x08, 0xf6, 0x57, 0x19, 0x81, 0x2e, 0xe9, 0xb4, 0xbb,
	0x90, 0x0b, 0x81, 0x03, 0x5d, 0x86, 0x22, 0x64, 0x8e, 0xb0, 0x4f, 0x58, 0x32, 0x22, 0x9b, 0xd5,
	0xf2, 0x75, 0xf1, 0x1e, 0xe4, 0xc2, 0xbf, 0x00, 0x48, 0x85, 0x4c, 0xa5, 0xfa, 0xa8, 0xbc, 0xb7,
	0xb9, 0x5b, 0xb8, 0x80, 0xf2, 0x00, 0x95, 0x6a, 0x7d, 0xad, 0xba, 0x55, 0xd9, 0xd8, 0x5a, 0x2f,
	0x28, 0x68, 0x06, 0x72, 0xe5, 0xf0, 0x35, 0xb1, 0xb8, 0x07, 0xd9, 0xa0, 0xd5, 0x8a, 0xa6, 0x21,
	0x5b, 0xdd, 0xaf, 0xea, 0x4f, 0xb7, 0xb7, 0xaa, 0x85, 0x0b, 0x0c, 0xb1, 0xb6, 0x5d, 0xa9, 0xea,
	0xe5, 0xdd, 0x6d, 0xbd, 0xa0, 0x30, 0xa6, 0x3b, 0xfa, 0xc6, 0x7e, 0x79, 0xb7, 0x5a, 0x48, 0xa0,
	0x59, 0x50, 0x57, 0xf5, 0xed, 0x72, 0x65, 0xad, 0x5c, 0xdf, 0xad, 0xea, 0x85, 0x24, 0x5b, 0xa5,
	0xbe, 0xb7, 0x5a, 0x5f, 0xd3, 0x37, 0x56, 0xab, 0x7a, 0x21, 0xbd, 0xf8, 0x09, 0x40, 0xb7, 0x55,
	0x83, 0x00, 0xa6, 0xf6, 0xb6, 0xf6, 0xea, 0xd5, 0x4a, 0xe1, 0x02, 0xca, 0x41, 0x7a, 0xfb, 0xe3,
	0xad, 0x2a, 0x63, 0x99, 0x83, 0x74, 0x7d, 0xb7, 0xfc, 0xe8, 0x51, 0x21, 0xc1, 0x1e, 0xcb, 0x95,
	0xda, 0xc6, 0x56, 0x21, 0xc9, 0xd6, 0x5d, 0xdf, 0xdc, 0x5e, 0x2d, 0x6f, 0xd6, 0xb6, 0x2b, 0x85,
	0x14, 0xca, 0x40, 0x92, 0x3d, 0xa4, 0x99, 0x00, 0x7a, 0x75, 0x7d, 0x6f, 0xb3, 0xac, 0x17, 0x66,
	0x17, 0xdf, 0x01, 0x35, 0x92, 0xd7, 0xa2, 0x02, 0x4c, 0xef, 0xd5, 0xab, 0xba, 0x51, 0xab, 0x6e,
	0xed, 0x6e, 0x6c, 0x6f, 0x15, 0x2e, 0x30, 0xc8, 0xe3, 0xaa, 0x5e, 0x0d, 0x21, 0xca, 0xe2, 0x43,
	0x80, 0xee, 0xdd, 0x8d, 0xb2, 0x90, 0xda, 0x12, 0xfb, 0xcc, 0x42, 0x6a, 0x6d, 0x73, 0x63, 0xa7,
	0xa0, 0xb0, 0xa5, 0xf6, 0xb7, 0x2b, 0x85, 0x04, 0x93, 0xb7, 0xbe, 0xab, 0x57, 0xcb, 0xb5, 0x42,
	0x92, 0x49, 0x56, 0xdd, 0xaf, 0x6e, 0xed, 0x16, 0x52, 0xcb, 0x3f, 0x2e, 0x40, 0x6e, 0x2d, 0xd0,
	0x1d, 0xa2, 0xa0, 0x46, 0x66, 0xab, 0x51, 0xdc, 0x95, 0x3f, 0x38, 0xd5, 0x5d, 0x5a, 0x9e, 0x84,
	0x44, 0xfe, 0x75, 0x38, 0x86, 0xe9, 0xe8, 0xcc, 0x34, 0x8a, 0xe3, 0x31, 0x64, 0x5e, 0xbb, 0x74,
	0x67, 0x22, 0x1a, 0xb9, 0xf0, 0xb7, 0x14, 0x98, 0xed, 0x1b, 0xf7, 0x45, 0x71, 0x0d, 0x82, 0xe1,
	0x03, 0xc7, 0xa5, 0xf7, 0x26, 0x25, 0x93, 0x22, 0x50, 0x50, 0x23, 0x03, 0xd7, 0xb1, 0x27, 0x3e,
	0x38, 0x42, 0x1e, 0x7b, 0xe2, 0xc3, 0xe6, 0xb9, 0x0f, 0x21, 0x23, 0x87, 0x1b, 0x50, 0x5c, 0xa3,
	0xac, 0x77, 0x8c, 0xb9, 0xb4, 0x34, 0x2e, 0xba, 0x5c, 0xe9, 0x33, 0x80, 0xee, 0xb4, 0x26, 0x8a,
	0xcb, 0xfe, 0x06, 0xa6, 0x8a, 0x4b, 0xef, 0x4c, 0x40, 0xd1, 0x5d, 0xb2, 0x3b, 0x55, 0x19, 0xbb,
	0xe4, 0xc0, 0xf0, 0x67, 0xec, 0x92, 0x43, 0x46, 0x36, 0x3f, 0x03, 0xe8, 0x0e, 0x11, 0xc5, 0x2e,
	0x39, 0x30, 0xa3, 0x19, 0xbb, 0xe4, 0x90, 0xf1, 0xbf, 0xff, 0x87, 0x7c, 0xef, 0x28, 0x1a, 0x7a,
	0x77, 0x6c, 0x26, 0x91, 0x99, 0xbf, 0xd2, 0xdd, 0x09, 0xa9, 0x22, 0xae, 0xd3, 0x37, 0x37, 0x85,
	0xc6, 0x67, 0x15, 0x9d, 0x6c, 0x8b, 0x75, 0x9d, 0x51, 0xe3, 0x59, 0x2e, 0xe4, 0xc2, 0x81, 0x25,
	0x74, 0x6b, 0x0c, 0x2f, 0x88, 0x8e, 0x63, 0x95, 0x6e, 0x8f, 0x4f, 0x20, 0xd7, 0xfb, 0x42, 0x81,
	0x42, 0xff, 0x58, 0x10, 0x7a, 0x6f, 0xe2, 0x39, 0x22, 0xb1, 0xfc, 0xbd, 0x33, 0xce, 0x1f, 0xb1,
	0x80, 0x11, 0x19, 0x45, 0x89, 0x0d, 0x18, 0x83, 0x93, 0x42, 0xb1, 0x01, 0x63, 0xd8, 0xd4, 0x0e,
	0x05, 0x35, 0x32, 0xf9, 0x11, 0xbb, 0xea, 0xe0, 0xcc, 0x4a, 0xec, 0xaa, 0xc3, 0x06, 0x4b, 0x3e,
	0x87, 0x99, 0x9e, 0xb9, 0x0b, 0x74, 0x67, 0x2c, 0xd7, 0xec, 0x5b, 0xf9, 0xdd, 0xc9, 0x88, 0x22,
	0x97, 0x52, 0x64, 0x66, 0x00, 0x8d, 0x17, 0x66, 0x7b, 0x86, 0x38, 0xe2, 0x2f, 0xa5, 0x61, 0x43,
	0x09, 0x5f, 0x2a, 0x30, 0x3f, 0xec, 0x27, 0x3d, 0x7a, 0x3f, 0x3e, 0xf4, 0x8e, 0x1a, 0x19, 0x28,
	0xdd, 0x3f, 0x13, 0xad, 0x90, 0x68, 0x55, 0xfd, 0xef, 0x5c, 0x88, 0x79, 0x30, 0xc5, 0x13, 0xe4,
	0x3b, 0x7f, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xb8, 0x24, 0x3b, 0xa2, 0x74, 0x36, 0x00, 0x00,
}
