// Code generated by protoc-gen-twirp v5.4.1, DO NOT EDIT.
// source: twirp/mako-service.proto

/*
Package mako_client is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.4.1.

It is generated from these files:
	twirp/mako-service.proto
*/
package mako_client

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==============
// Mako Interface
// ==============

type Mako interface {
	// Get Entitlements for a user. Results can be filtered with an EntitlementScopedKey
	GetEntitlements(context.Context, *GetEntitlementsRequest) (*GetEntitlementsResponse, error)

	// Set Entitlement for a user.
	SetEntitlement(context.Context, *SetEntitlementRequest) (*SetEntitlementResponse, error)

	// Delete Entitlements for a user.
	DeleteEntitlements(context.Context, *DeleteEntitlementsRequest) (*DeleteEntitlementsResponse, error)

	// Get Triggers for an event. Results can be filtered with an EntitlementScopedKey.
	GetTriggers(context.Context, *GetTriggersRequest) (*GetTriggersResponse, error)

	// Set Trigger for an event.
	SetTrigger(context.Context, *SetTriggerRequest) (*SetTriggerResponse, error)

	// Get the emote set details for a given user.
	GetEmoteSetDetails(context.Context, *GetEmoteSetDetailsRequest) (*GetEmoteSetDetailsResponse, error)

	// Get the emoticon group details for the given emoticon groups
	GetEmoticonsByGroups(context.Context, *GetEmoticonsByGroupsRequest) (*GetEmoticonsByGroupsResponse, error)

	// Get the emoticon details for the given emoticon ids
	GetEmoticonsByEmoticonIds(context.Context, *GetEmoticonsByEmoticonIdsRequest) (*GetEmoticonsByEmoticonIdsResponse, error)

	// Get all emotes.
	GetAllEmotes(context.Context, *GetAllEmotesRequest) (*GetAllEmotesResponse, error)

	// Get all emotes for the given channel id
	GetAllEmotesByOwnerId(context.Context, *GetAllEmotesByOwnerIdRequest) (*GetAllEmotesByOwnerIdResponse, error)

	// Get active emote codes for a given user.
	GetActiveEmoteCodes(context.Context, *GetActiveEmoteCodesRequest) (*GetActiveEmoteCodesResponse, error)

	// Get emoticon image/upload id and url.
	GetEmoticonUploadConfiguration(context.Context, *GetEmoticonUploadConfigurationRequest) (*GetEmoticonUploadConfigurationResponse, error)

	// Create emoticon given 3 upload URLs and emoticon info.
	CreateEmoticon(context.Context, *CreateEmoticonRequest) (*CreateEmoticonReponse, error)

	// Delete emoticon given id, code, and option to delete assets images from S3. Images are used for VOD Chat. Set true if ABSOLUTELY want to nuke emoticon.
	DeleteEmoticon(context.Context, *DeleteEmoticonRequest) (*DeleteEmoticonResponse, error)

	// Deactivate emoticon given id
	DeactivateEmoticon(context.Context, *DeactivateEmoticonRequest) (*DeactivateEmoticonResponse, error)

	// Update an emoticon's code given new code, code suffix, and emoticon id.
	UpdateEmoticonCode(context.Context, *UpdateEmoticonCodeRequest) (*UpdateEmoticonCodeResponse, error)

	// Get the selected smilies set and emoticon info.
	GetSelectedSmilies(context.Context, *GetSelectedSmiliesRequest) (*GetSelectedSmiliesResponse, error)

	// Get all of the smilies sets and emoticon info.
	GetAllSmilies(context.Context, *GetAllSmiliesRequest) (*GetAllSmiliesResponse, error)

	// Set the selected smilies set and emoticon info.
	SetSmilies(context.Context, *SetSmiliesRequest) (*SetSmiliesResponse, error)

	// Returns S3 URLs to the emoticon all payloads for the legacy kraken endpoints.
	GetLegacyEmoticonAllURLs(context.Context, *GetLegacyEmoticonAllURLsRequest) (*GetLegacyEmoticonAllURLsResponse, error)

	// Represents the kraken/chat/:channel_name/emoticons API which return channel and global emoticons
	// based upon channel_name.
	GetLegacyChannelEmoticons(context.Context, *GetLegacyChannelEmoticonsRequest) (*GetLegacyChannelEmoticonsResponse, error)
}

// ====================
// Mako Protobuf Client
// ====================

type makoProtobufClient struct {
	client HTTPClient
	urls   [21]string
}

// NewMakoProtobufClient creates a Protobuf client that implements the Mako interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMakoProtobufClient(addr string, client HTTPClient) Mako {
	prefix := urlBase(addr) + MakoPathPrefix
	urls := [21]string{
		prefix + "GetEntitlements",
		prefix + "SetEntitlement",
		prefix + "DeleteEntitlements",
		prefix + "GetTriggers",
		prefix + "SetTrigger",
		prefix + "GetEmoteSetDetails",
		prefix + "GetEmoticonsByGroups",
		prefix + "GetEmoticonsByEmoticonIds",
		prefix + "GetAllEmotes",
		prefix + "GetAllEmotesByOwnerId",
		prefix + "GetActiveEmoteCodes",
		prefix + "GetEmoticonUploadConfiguration",
		prefix + "CreateEmoticon",
		prefix + "DeleteEmoticon",
		prefix + "DeactivateEmoticon",
		prefix + "UpdateEmoticonCode",
		prefix + "GetSelectedSmilies",
		prefix + "GetAllSmilies",
		prefix + "SetSmilies",
		prefix + "GetLegacyEmoticonAllURLs",
		prefix + "GetLegacyChannelEmoticons",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &makoProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &makoProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *makoProtobufClient) GetEntitlements(ctx context.Context, in *GetEntitlementsRequest) (*GetEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	out := new(GetEntitlementsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) SetEntitlement(ctx context.Context, in *SetEntitlementRequest) (*SetEntitlementResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "SetEntitlement")
	out := new(SetEntitlementResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) DeleteEntitlements(ctx context.Context, in *DeleteEntitlementsRequest) (*DeleteEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	out := new(DeleteEntitlementsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetTriggers(ctx context.Context, in *GetTriggersRequest) (*GetTriggersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetTriggers")
	out := new(GetTriggersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) SetTrigger(ctx context.Context, in *SetTriggerRequest) (*SetTriggerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "SetTrigger")
	out := new(SetTriggerResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetEmoteSetDetails(ctx context.Context, in *GetEmoteSetDetailsRequest) (*GetEmoteSetDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteSetDetails")
	out := new(GetEmoteSetDetailsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetEmoticonsByGroups(ctx context.Context, in *GetEmoticonsByGroupsRequest) (*GetEmoticonsByGroupsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByGroups")
	out := new(GetEmoticonsByGroupsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetEmoticonsByEmoticonIds(ctx context.Context, in *GetEmoticonsByEmoticonIdsRequest) (*GetEmoticonsByEmoticonIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByEmoticonIds")
	out := new(GetEmoticonsByEmoticonIdsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetAllEmotes(ctx context.Context, in *GetAllEmotesRequest) (*GetAllEmotesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotes")
	out := new(GetAllEmotesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetAllEmotesByOwnerId(ctx context.Context, in *GetAllEmotesByOwnerIdRequest) (*GetAllEmotesByOwnerIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotesByOwnerId")
	out := new(GetAllEmotesByOwnerIdResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetActiveEmoteCodes(ctx context.Context, in *GetActiveEmoteCodesRequest) (*GetActiveEmoteCodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEmoteCodes")
	out := new(GetActiveEmoteCodesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetEmoticonUploadConfiguration(ctx context.Context, in *GetEmoticonUploadConfigurationRequest) (*GetEmoticonUploadConfigurationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonUploadConfiguration")
	out := new(GetEmoticonUploadConfigurationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEmoticon")
	out := new(CreateEmoticonReponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) DeleteEmoticon(ctx context.Context, in *DeleteEmoticonRequest) (*DeleteEmoticonResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEmoticon")
	out := new(DeleteEmoticonResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) DeactivateEmoticon(ctx context.Context, in *DeactivateEmoticonRequest) (*DeactivateEmoticonResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateEmoticon")
	out := new(DeactivateEmoticonResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) UpdateEmoticonCode(ctx context.Context, in *UpdateEmoticonCodeRequest) (*UpdateEmoticonCodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEmoticonCode")
	out := new(UpdateEmoticonCodeResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetSelectedSmilies(ctx context.Context, in *GetSelectedSmiliesRequest) (*GetSelectedSmiliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetSelectedSmilies")
	out := new(GetSelectedSmiliesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetAllSmilies(ctx context.Context, in *GetAllSmiliesRequest) (*GetAllSmiliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllSmilies")
	out := new(GetAllSmiliesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) SetSmilies(ctx context.Context, in *SetSmiliesRequest) (*SetSmiliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "SetSmilies")
	out := new(SetSmiliesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetLegacyEmoticonAllURLs(ctx context.Context, in *GetLegacyEmoticonAllURLsRequest) (*GetLegacyEmoticonAllURLsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyEmoticonAllURLs")
	out := new(GetLegacyEmoticonAllURLsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoProtobufClient) GetLegacyChannelEmoticons(ctx context.Context, in *GetLegacyChannelEmoticonsRequest) (*GetLegacyChannelEmoticonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyChannelEmoticons")
	out := new(GetLegacyChannelEmoticonsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ================
// Mako JSON Client
// ================

type makoJSONClient struct {
	client HTTPClient
	urls   [21]string
}

// NewMakoJSONClient creates a JSON client that implements the Mako interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMakoJSONClient(addr string, client HTTPClient) Mako {
	prefix := urlBase(addr) + MakoPathPrefix
	urls := [21]string{
		prefix + "GetEntitlements",
		prefix + "SetEntitlement",
		prefix + "DeleteEntitlements",
		prefix + "GetTriggers",
		prefix + "SetTrigger",
		prefix + "GetEmoteSetDetails",
		prefix + "GetEmoticonsByGroups",
		prefix + "GetEmoticonsByEmoticonIds",
		prefix + "GetAllEmotes",
		prefix + "GetAllEmotesByOwnerId",
		prefix + "GetActiveEmoteCodes",
		prefix + "GetEmoticonUploadConfiguration",
		prefix + "CreateEmoticon",
		prefix + "DeleteEmoticon",
		prefix + "DeactivateEmoticon",
		prefix + "UpdateEmoticonCode",
		prefix + "GetSelectedSmilies",
		prefix + "GetAllSmilies",
		prefix + "SetSmilies",
		prefix + "GetLegacyEmoticonAllURLs",
		prefix + "GetLegacyChannelEmoticons",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &makoJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &makoJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *makoJSONClient) GetEntitlements(ctx context.Context, in *GetEntitlementsRequest) (*GetEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	out := new(GetEntitlementsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) SetEntitlement(ctx context.Context, in *SetEntitlementRequest) (*SetEntitlementResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "SetEntitlement")
	out := new(SetEntitlementResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) DeleteEntitlements(ctx context.Context, in *DeleteEntitlementsRequest) (*DeleteEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	out := new(DeleteEntitlementsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetTriggers(ctx context.Context, in *GetTriggersRequest) (*GetTriggersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetTriggers")
	out := new(GetTriggersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) SetTrigger(ctx context.Context, in *SetTriggerRequest) (*SetTriggerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "SetTrigger")
	out := new(SetTriggerResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetEmoteSetDetails(ctx context.Context, in *GetEmoteSetDetailsRequest) (*GetEmoteSetDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteSetDetails")
	out := new(GetEmoteSetDetailsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetEmoticonsByGroups(ctx context.Context, in *GetEmoticonsByGroupsRequest) (*GetEmoticonsByGroupsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByGroups")
	out := new(GetEmoticonsByGroupsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetEmoticonsByEmoticonIds(ctx context.Context, in *GetEmoticonsByEmoticonIdsRequest) (*GetEmoticonsByEmoticonIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByEmoticonIds")
	out := new(GetEmoticonsByEmoticonIdsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetAllEmotes(ctx context.Context, in *GetAllEmotesRequest) (*GetAllEmotesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotes")
	out := new(GetAllEmotesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetAllEmotesByOwnerId(ctx context.Context, in *GetAllEmotesByOwnerIdRequest) (*GetAllEmotesByOwnerIdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotesByOwnerId")
	out := new(GetAllEmotesByOwnerIdResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetActiveEmoteCodes(ctx context.Context, in *GetActiveEmoteCodesRequest) (*GetActiveEmoteCodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEmoteCodes")
	out := new(GetActiveEmoteCodesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetEmoticonUploadConfiguration(ctx context.Context, in *GetEmoticonUploadConfigurationRequest) (*GetEmoticonUploadConfigurationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonUploadConfiguration")
	out := new(GetEmoticonUploadConfigurationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEmoticon")
	out := new(CreateEmoticonReponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) DeleteEmoticon(ctx context.Context, in *DeleteEmoticonRequest) (*DeleteEmoticonResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEmoticon")
	out := new(DeleteEmoticonResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) DeactivateEmoticon(ctx context.Context, in *DeactivateEmoticonRequest) (*DeactivateEmoticonResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateEmoticon")
	out := new(DeactivateEmoticonResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) UpdateEmoticonCode(ctx context.Context, in *UpdateEmoticonCodeRequest) (*UpdateEmoticonCodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEmoticonCode")
	out := new(UpdateEmoticonCodeResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetSelectedSmilies(ctx context.Context, in *GetSelectedSmiliesRequest) (*GetSelectedSmiliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetSelectedSmilies")
	out := new(GetSelectedSmiliesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetAllSmilies(ctx context.Context, in *GetAllSmiliesRequest) (*GetAllSmiliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllSmilies")
	out := new(GetAllSmiliesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) SetSmilies(ctx context.Context, in *SetSmiliesRequest) (*SetSmiliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "SetSmilies")
	out := new(SetSmiliesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetLegacyEmoticonAllURLs(ctx context.Context, in *GetLegacyEmoticonAllURLsRequest) (*GetLegacyEmoticonAllURLsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyEmoticonAllURLs")
	out := new(GetLegacyEmoticonAllURLsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *makoJSONClient) GetLegacyChannelEmoticons(ctx context.Context, in *GetLegacyChannelEmoticonsRequest) (*GetLegacyChannelEmoticonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyChannelEmoticons")
	out := new(GetLegacyChannelEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===================
// Mako Server Handler
// ===================

type makoServer struct {
	Mako
	hooks *twirp.ServerHooks
}

func NewMakoServer(svc Mako, hooks *twirp.ServerHooks) TwirpServer {
	return &makoServer{
		Mako:  svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *makoServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// MakoPathPrefix is used for all URL paths on a twirp Mako server.
// Requests are always: POST MakoPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MakoPathPrefix = "/twirp/code.justin.tv.commerce.mako.Mako/"

func (s *makoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.commerce.mako")
	ctx = ctxsetters.WithServiceName(ctx, "Mako")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetEntitlements":
		s.serveGetEntitlements(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/SetEntitlement":
		s.serveSetEntitlement(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/DeleteEntitlements":
		s.serveDeleteEntitlements(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetTriggers":
		s.serveGetTriggers(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/SetTrigger":
		s.serveSetTrigger(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetEmoteSetDetails":
		s.serveGetEmoteSetDetails(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetEmoticonsByGroups":
		s.serveGetEmoticonsByGroups(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetEmoticonsByEmoticonIds":
		s.serveGetEmoticonsByEmoticonIds(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetAllEmotes":
		s.serveGetAllEmotes(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetAllEmotesByOwnerId":
		s.serveGetAllEmotesByOwnerId(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetActiveEmoteCodes":
		s.serveGetActiveEmoteCodes(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetEmoticonUploadConfiguration":
		s.serveGetEmoticonUploadConfiguration(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/CreateEmoticon":
		s.serveCreateEmoticon(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/DeleteEmoticon":
		s.serveDeleteEmoticon(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/DeactivateEmoticon":
		s.serveDeactivateEmoticon(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/UpdateEmoticonCode":
		s.serveUpdateEmoticonCode(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetSelectedSmilies":
		s.serveGetSelectedSmilies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetAllSmilies":
		s.serveGetAllSmilies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/SetSmilies":
		s.serveSetSmilies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetLegacyEmoticonAllURLs":
		s.serveGetLegacyEmoticonAllURLs(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.commerce.mako.Mako/GetLegacyChannelEmoticons":
		s.serveGetLegacyChannelEmoticons(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *makoServer) serveGetEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEntitlementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEntitlementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEntitlementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsResponse and nil error while calling GetEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEntitlementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEntitlementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsResponse and nil error while calling GetEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveSetEntitlement(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetEntitlementJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetEntitlementProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveSetEntitlementJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetEntitlement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetEntitlementRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetEntitlementResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetEntitlementResponse and nil error while calling SetEntitlement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveSetEntitlementProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetEntitlement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetEntitlementRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetEntitlementResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetEntitlementResponse and nil error while calling SetEntitlement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveDeleteEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEntitlementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveDeleteEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEntitlementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEntitlementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEntitlementsResponse and nil error while calling DeleteEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveDeleteEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteEntitlementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEntitlementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEntitlementsResponse and nil error while calling DeleteEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetTriggers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTriggersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTriggersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetTriggersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTriggers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTriggersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTriggersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTriggers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTriggersResponse and nil error while calling GetTriggers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetTriggersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTriggers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTriggersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTriggersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTriggers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTriggersResponse and nil error while calling GetTriggers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveSetTrigger(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetTriggerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetTriggerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveSetTriggerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetTrigger")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetTriggerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetTriggerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetTrigger(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetTriggerResponse and nil error while calling SetTrigger. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveSetTriggerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetTrigger")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetTriggerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetTriggerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetTrigger(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetTriggerResponse and nil error while calling SetTrigger. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoteSetDetails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEmoteSetDetailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoteSetDetailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetEmoteSetDetailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteSetDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEmoteSetDetailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoteSetDetailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoteSetDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoteSetDetailsResponse and nil error while calling GetEmoteSetDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoteSetDetailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteSetDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoteSetDetailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoteSetDetailsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoteSetDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoteSetDetailsResponse and nil error while calling GetEmoteSetDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoticonsByGroups(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEmoticonsByGroupsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonsByGroupsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetEmoticonsByGroupsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByGroups")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEmoticonsByGroupsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByGroups(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonsByGroupsResponse and nil error while calling GetEmoticonsByGroups. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoticonsByGroupsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByGroups")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonsByGroupsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByGroupsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByGroups(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonsByGroupsResponse and nil error while calling GetEmoticonsByGroups. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoticonsByEmoticonIds(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEmoticonsByEmoticonIdsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonsByEmoticonIdsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetEmoticonsByEmoticonIdsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByEmoticonIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEmoticonsByEmoticonIdsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByEmoticonIdsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByEmoticonIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonsByEmoticonIdsResponse and nil error while calling GetEmoticonsByEmoticonIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoticonsByEmoticonIdsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonsByEmoticonIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonsByEmoticonIdsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonsByEmoticonIdsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonsByEmoticonIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonsByEmoticonIdsResponse and nil error while calling GetEmoticonsByEmoticonIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetAllEmotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllEmotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmotesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetAllEmotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllEmotesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmotesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmotesResponse and nil error while calling GetAllEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetAllEmotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllEmotesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmotesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmotesResponse and nil error while calling GetAllEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetAllEmotesByOwnerId(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllEmotesByOwnerIdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmotesByOwnerIdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetAllEmotesByOwnerIdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotesByOwnerId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllEmotesByOwnerIdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmotesByOwnerIdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmotesByOwnerId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmotesByOwnerIdResponse and nil error while calling GetAllEmotesByOwnerId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetAllEmotesByOwnerIdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllEmotesByOwnerId")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllEmotesByOwnerIdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmotesByOwnerIdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmotesByOwnerId(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmotesByOwnerIdResponse and nil error while calling GetAllEmotesByOwnerId. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetActiveEmoteCodes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActiveEmoteCodesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActiveEmoteCodesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetActiveEmoteCodesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEmoteCodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActiveEmoteCodesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetActiveEmoteCodesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetActiveEmoteCodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActiveEmoteCodesResponse and nil error while calling GetActiveEmoteCodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetActiveEmoteCodesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveEmoteCodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetActiveEmoteCodesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetActiveEmoteCodesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetActiveEmoteCodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActiveEmoteCodesResponse and nil error while calling GetActiveEmoteCodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoticonUploadConfiguration(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEmoticonUploadConfigurationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonUploadConfigurationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetEmoticonUploadConfigurationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonUploadConfiguration")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEmoticonUploadConfigurationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonUploadConfigurationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonUploadConfiguration(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonUploadConfigurationResponse and nil error while calling GetEmoticonUploadConfiguration. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetEmoticonUploadConfigurationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoticonUploadConfiguration")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonUploadConfigurationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonUploadConfigurationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonUploadConfiguration(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonUploadConfigurationResponse and nil error while calling GetEmoticonUploadConfiguration. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveCreateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveCreateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEmoticon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveCreateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEmoticon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateEmoticonRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveDeleteEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveDeleteEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEmoticon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEmoticonResponse and nil error while calling DeleteEmoticon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveDeleteEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEmoticon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteEmoticonRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEmoticonResponse and nil error while calling DeleteEmoticon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveDeactivateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeactivateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeactivateEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveDeactivateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateEmoticon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeactivateEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeactivateEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeactivateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeactivateEmoticonResponse and nil error while calling DeactivateEmoticon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveDeactivateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateEmoticon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeactivateEmoticonRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeactivateEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeactivateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeactivateEmoticonResponse and nil error while calling DeactivateEmoticon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveUpdateEmoticonCode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateEmoticonCodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateEmoticonCodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveUpdateEmoticonCodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEmoticonCode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateEmoticonCodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateEmoticonCodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateEmoticonCode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEmoticonCodeResponse and nil error while calling UpdateEmoticonCode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveUpdateEmoticonCodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEmoticonCode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateEmoticonCodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateEmoticonCodeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateEmoticonCode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEmoticonCodeResponse and nil error while calling UpdateEmoticonCode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetSelectedSmilies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSelectedSmiliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSelectedSmiliesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetSelectedSmiliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSelectedSmilies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSelectedSmiliesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSelectedSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSelectedSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSelectedSmiliesResponse and nil error while calling GetSelectedSmilies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetSelectedSmiliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSelectedSmilies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSelectedSmiliesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSelectedSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSelectedSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSelectedSmiliesResponse and nil error while calling GetSelectedSmilies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetAllSmilies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllSmiliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllSmiliesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetAllSmiliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllSmilies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllSmiliesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllSmiliesResponse and nil error while calling GetAllSmilies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetAllSmiliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllSmilies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllSmiliesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllSmiliesResponse and nil error while calling GetAllSmilies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveSetSmilies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetSmiliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetSmiliesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveSetSmiliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetSmilies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetSmiliesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetSmiliesResponse and nil error while calling SetSmilies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveSetSmiliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetSmilies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetSmiliesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetSmiliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetSmilies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetSmiliesResponse and nil error while calling SetSmilies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetLegacyEmoticonAllURLs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyEmoticonAllURLsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyEmoticonAllURLsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetLegacyEmoticonAllURLsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyEmoticonAllURLs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyEmoticonAllURLsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyEmoticonAllURLsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyEmoticonAllURLs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyEmoticonAllURLsResponse and nil error while calling GetLegacyEmoticonAllURLs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetLegacyEmoticonAllURLsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyEmoticonAllURLs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLegacyEmoticonAllURLsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyEmoticonAllURLsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyEmoticonAllURLs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyEmoticonAllURLsResponse and nil error while calling GetLegacyEmoticonAllURLs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetLegacyChannelEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyChannelEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyChannelEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *makoServer) serveGetLegacyChannelEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyChannelEmoticons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyChannelEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyChannelEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyChannelEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyChannelEmoticonsResponse and nil error while calling GetLegacyChannelEmoticons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) serveGetLegacyChannelEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyChannelEmoticons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLegacyChannelEmoticonsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLegacyChannelEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetLegacyChannelEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyChannelEmoticonsResponse and nil error while calling GetLegacyChannelEmoticons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *makoServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *makoServer) ProtocGenTwirpVersion() string {
	return "v5.4.1"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.4.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2078 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0x4b, 0x6f, 0x1c, 0xc7,
	0x11, 0xf6, 0x2c, 0xb9, 0xaf, 0x5a, 0x8a, 0xa2, 0xdb, 0x24, 0xb5, 0x5c, 0x49, 0x36, 0xd5, 0x8e,
	0x65, 0x46, 0x46, 0xd6, 0x12, 0x25, 0x3a, 0x7a, 0xf8, 0x11, 0x8a, 0xa4, 0x99, 0x8d, 0x1e, 0x54,
	0x66, 0x45, 0x24, 0x11, 0x10, 0x6c, 0x46, 0x33, 0xcd, 0xe5, 0x98, 0xb3, 0x33, 0x9b, 0x99, 0x5e,
	0x4a, 0x4c, 0x10, 0x5f, 0x12, 0x24, 0x40, 0x00, 0x03, 0xb9, 0x06, 0x30, 0x90, 0x4b, 0x6e, 0x46,
	0x72, 0xcb, 0x29, 0xf7, 0xfc, 0x8d, 0xfc, 0x95, 0xa0, 0x1f, 0xf3, 0x9e, 0xdd, 0x99, 0x25, 0xa9,
	0x43, 0x4e, 0x9c, 0xae, 0xee, 0xaa, 0xfa, 0xba, 0xba, 0xba, 0xaa, 0xba, 0x96, 0xd0, 0xa4, 0xaf,
	0x4c, 0x77, 0xf8, 0xf1, 0x40, 0x3b, 0x72, 0x7e, 0xe0, 0x11, 0xf7, 0xd8, 0xd4, 0x49, 0x7b, 0xe8,
	0x3a, 0xd4, 0x41, 0x57, 0x74, 0xc7, 0x20, 0xed, 0xaf, 0x46, 0x1e, 0x35, 0xed, 0x36, 0x3d, 0x6e,
	0xeb, 0xce, 0x60, 0x40, 0x5c, 0x9d, 0xb4, 0xd9, 0x5a, 0xfc, 0x9d, 0x02, 0xcb, 0xbb, 0x84, 0xee,
	0xd8, 0xd4, 0xa4, 0x16, 0x19, 0x10, 0x9b, 0x7a, 0x2a, 0xf9, 0xf5, 0x88, 0x78, 0x14, 0x5d, 0x82,
	0xea, 0xc8, 0x23, 0x6e, 0xcf, 0x34, 0x9a, 0xca, 0xaa, 0xb2, 0x56, 0x57, 0x2b, 0x6c, 0xd8, 0x31,
	0xd0, 0x2f, 0x61, 0x99, 0x84, 0xeb, 0x7b, 0x9e, 0xee, 0x0c, 0x89, 0xd1, 0x3b, 0x22, 0x27, 0xcd,
	0xd2, 0xaa, 0xb2, 0xd6, 0x58, 0xff, 0xb0, 0x3d, 0x49, 0x65, 0xbb, 0xcb, 0xd7, 0x3f, 0x22, 0x27,
	0xea, 0x62, 0x44, 0x4c, 0x40, 0x45, 0x2b, 0x50, 0x33, 0xbd, 0x9e, 0x47, 0xb5, 0x83, 0x83, 0xe6,
	0xcc, 0xaa, 0xb2, 0x56, 0x53, 0xab, 0xa6, 0xd7, 0x65, 0x43, 0x7c, 0x07, 0x56, 0x76, 0x09, 0xed,
	0x12, 0x8b, 0xe8, 0x94, 0x18, 0xdd, 0x81, 0x69, 0x99, 0x24, 0x17, 0x2f, 0xb6, 0xa1, 0x95, 0xc5,
	0xe5, 0x0d, 0x1d, 0xdb, 0x23, 0xe8, 0x19, 0xcc, 0x7b, 0x82, 0xd4, 0xf3, 0x08, 0xf5, 0xb9, 0xe7,
	0xd7, 0x6f, 0xe4, 0xec, 0x42, 0xf0, 0x74, 0x09, 0xed, 0x18, 0xea, 0x9c, 0x17, 0x19, 0xe1, 0x65,
	0x58, 0xdc, 0x25, 0x74, 0xd3, 0xb2, 0xe2, 0x00, 0xb1, 0x0e, 0x4b, 0x09, 0xba, 0x84, 0xf0, 0x13,
	0x68, 0x84, 0x02, 0xbc, 0xa6, 0xb2, 0x3a, 0xb3, 0xd6, 0x58, 0x5f, 0x2b, 0xaa, 0x5f, 0x8d, 0x32,
	0xe3, 0xaf, 0xe1, 0xed, 0x2e, 0xa1, 0x05, 0x4d, 0x93, 0xb1, 0xf9, 0xd2, 0x19, 0x37, 0x7f, 0x00,
	0x28, 0xaa, 0xff, 0x8d, 0x19, 0xf9, 0x10, 0x2e, 0xa5, 0xfc, 0x56, 0x2a, 0x7b, 0x02, 0x73, 0x11,
	0xc7, 0xf2, 0xed, 0xf9, 0xfd, 0xc9, 0xaa, 0x22, 0x92, 0xd4, 0x18, 0x3b, 0x36, 0x60, 0xa9, 0x1b,
	0xd3, 0xe4, 0x5b, 0xf5, 0x11, 0x34, 0x22, 0x0b, 0xf9, 0x8e, 0xa6, 0x52, 0x13, 0xe5, 0xc6, 0x04,
	0x96, 0x93, 0x5a, 0xe4, 0x76, 0xce, 0x55, 0xcd, 0x57, 0xb0, 0xb2, 0x4d, 0x2c, 0x42, 0x49, 0xd6,
	0x8d, 0x3f, 0x67, 0xc3, 0x1d, 0x41, 0x2b, 0x4b, 0xd7, 0x9b, 0x39, 0xa5, 0xff, 0x28, 0x80, 0x76,
	0x09, 0x7d, 0xee, 0x9a, 0xfd, 0x3e, 0x71, 0x83, 0x2d, 0xfd, 0x14, 0x16, 0xc8, 0x71, 0x22, 0x4a,
	0x29, 0xd3, 0x45, 0xa9, 0x79, 0x2e, 0x20, 0x8c, 0x4f, 0x6f, 0x36, 0xfc, 0xe1, 0x9f, 0xc3, 0x3b,
	0xb1, 0x7d, 0x48, 0x73, 0x6d, 0x42, 0x8d, 0x4a, 0x9a, 0x34, 0xd5, 0x07, 0x93, 0xf5, 0x48, 0x09,
	0x6a, 0xc0, 0x86, 0x9f, 0xf3, 0xd0, 0xe0, 0xd3, 0xa5, 0x81, 0xbe, 0x80, 0xaa, 0x5c, 0x20, 0xed,
	0x52, 0x50, 0xac, 0xcf, 0x85, 0xf7, 0xf9, 0x85, 0x0f, 0xa4, 0x4a, 0xb8, 0x67, 0x16, 0x2b, 0x42,
	0xfd, 0xce, 0xc0, 0xa1, 0xa4, 0x4b, 0xe8, 0x36, 0xa1, 0x9a, 0x69, 0xe5, 0x87, 0x7a, 0x9d, 0x87,
	0xfa, 0x14, 0x97, 0x04, 0xb5, 0x03, 0x40, 0xd8, 0x14, 0x8b, 0x41, 0xbe, 0x15, 0xaf, 0xe7, 0x38,
	0x9c, 0x14, 0xa5, 0xd6, 0x89, 0xfc, 0xf2, 0xf0, 0x13, 0xb8, 0x2c, 0x95, 0x98, 0xba, 0x63, 0x7b,
	0x0f, 0x4f, 0x76, 0x5d, 0x67, 0x34, 0x0c, 0xc0, 0xb5, 0xe1, 0x1d, 0x22, 0xe7, 0x7a, 0x7d, 0x36,
	0xc3, 0x7c, 0x43, 0xa8, 0xab, 0xab, 0x6f, 0xfb, 0x53, 0x9c, 0xe7, 0x11, 0x39, 0xf1, 0xb0, 0x0e,
	0x57, 0xb2, 0xc5, 0x49, 0xd4, 0x5b, 0x50, 0xe1, 0x62, 0x7c, 0xc4, 0x1f, 0xe5, 0x23, 0x0e, 0x14,
	0xa8, 0x92, 0x15, 0xef, 0xc0, 0x6a, 0x5c, 0x89, 0xff, 0xd9, 0x31, 0x02, 0xe0, 0xd7, 0x60, 0x2e,
	0x00, 0x6e, 0x1a, 0x3e, 0xe2, 0x06, 0x09, 0x57, 0x62, 0x13, 0xae, 0x4d, 0x10, 0x23, 0x01, 0x6f,
	0x43, 0xdd, 0xe7, 0x99, 0xc2, 0xca, 0x6c, 0xb9, 0x1a, 0x32, 0xe2, 0x25, 0x7e, 0x0f, 0x36, 0x2d,
	0x8b, 0x1f, 0x41, 0x90, 0x44, 0x0f, 0xfd, 0xe4, 0xea, 0x93, 0x83, 0x0c, 0x93, 0x52, 0xba, 0x5e,
	0xe0, 0x68, 0xbf, 0x74, 0xdc, 0x98, 0xb8, 0x08, 0x80, 0x57, 0xfc, 0x5c, 0x82, 0xa9, 0x87, 0x27,
	0x7b, 0xaf, 0x6c, 0xe6, 0x64, 0xbe, 0xb9, 0x56, 0xa0, 0xe6, 0x30, 0x4a, 0xe8, 0x85, 0x55, 0x47,
	0xac, 0x40, 0x9f, 0x42, 0xc5, 0x70, 0x06, 0x9a, 0x69, 0xcb, 0x74, 0xfa, 0xbd, 0xc9, 0x48, 0xb6,
	0xf9, 0x5a, 0x55, 0xf2, 0xe0, 0xdf, 0xc1, 0xd5, 0x31, 0x8a, 0xe5, 0x5e, 0x97, 0x03, 0xf1, 0xd2,
	0xfb, 0xc5, 0x28, 0x6e, 0xf8, 0xd2, 0x69, 0x0d, 0xbf, 0xc1, 0xef, 0xd0, 0xa6, 0x4e, 0xcd, 0x63,
	0xc2, 0x11, 0x6c, 0x39, 0x46, 0x81, 0x2a, 0xeb, 0xbf, 0x0a, 0xbf, 0x16, 0x69, 0x3e, 0x09, 0xfa,
	0x05, 0x94, 0x19, 0x14, 0xff, 0x70, 0xb6, 0x27, 0x03, 0x9b, 0x20, 0xa9, 0xcd, 0x47, 0x3b, 0x36,
	0x75, 0x4f, 0x54, 0x21, 0xb2, 0x65, 0x00, 0x84, 0x44, 0xb4, 0x00, 0x33, 0x7e, 0x98, 0xaf, 0xab,
	0xec, 0x13, 0xfd, 0x08, 0xca, 0xc7, 0x9a, 0x35, 0x22, 0x32, 0x42, 0xdf, 0x28, 0xe0, 0x18, 0x7e,
	0xec, 0x10, 0x8c, 0xf7, 0x4b, 0x77, 0x15, 0xfc, 0x07, 0x05, 0x3e, 0x88, 0x78, 0xff, 0xfe, 0xd0,
	0x72, 0x34, 0x63, 0xcb, 0xb1, 0x0f, 0xcc, 0xfe, 0xc8, 0xd5, 0xa8, 0xe9, 0xd8, 0xb9, 0xf5, 0xd6,
	0x7b, 0xd0, 0x30, 0x07, 0x5a, 0x9f, 0xf4, 0x5e, 0x99, 0x06, 0x3d, 0xe4, 0x70, 0xca, 0x2a, 0x70,
	0xd2, 0xcf, 0x18, 0x85, 0xdd, 0x41, 0xb1, 0xe0, 0x90, 0x98, 0xfd, 0x43, 0xca, 0x0b, 0xe0, 0xb2,
	0x2a, 0x98, 0x7e, 0xcc, 0x49, 0xf8, 0x5b, 0x05, 0xae, 0xe7, 0xc1, 0x90, 0x36, 0xbf, 0x0c, 0xf5,
	0x11, 0x9f, 0x0e, 0x91, 0xd4, 0x04, 0xa1, 0x63, 0xa0, 0xab, 0x00, 0x72, 0x72, 0xe4, 0x5a, 0x1c,
	0x4a, 0x5d, 0x95, 0xcb, 0xf7, 0x5d, 0x8b, 0x97, 0xe1, 0x1c, 0x89, 0x69, 0x70, 0x14, 0x75, 0xb5,
	0xca, 0xc7, 0x1d, 0x83, 0x89, 0x15, 0x53, 0x8c, 0x71, 0x56, 0x88, 0xe5, 0x84, 0x7d, 0xd7, 0xc2,
	0xdf, 0x94, 0x60, 0x69, 0xcb, 0x25, 0x1a, 0x25, 0x81, 0x73, 0xe5, 0x59, 0x05, 0xc1, 0x2c, 0x3b,
	0x10, 0x89, 0x81, 0x7f, 0x33, 0x4b, 0xb1, 0xbf, 0x3d, 0x6f, 0x74, 0x70, 0x60, 0xbe, 0x96, 0x08,
	0x80, 0x91, 0xba, 0x9c, 0x82, 0x16, 0xa1, 0xec, 0x51, 0x8d, 0x12, 0x09, 0x40, 0x0c, 0x18, 0x6a,
	0x11, 0x73, 0x4d, 0xa3, 0x59, 0x16, 0xa8, 0xf9, 0x58, 0xec, 0x97, 0x83, 0x5c, 0xbf, 0xcb, 0x26,
	0x2b, 0x62, 0xbf, 0x92, 0x12, 0x99, 0xde, 0xf8, 0x84, 0x4d, 0x57, 0x23, 0xd3, 0x1b, 0x9f, 0x44,
	0x4e, 0xee, 0xd6, 0xad, 0x75, 0x36, 0x5f, 0x13, 0x78, 0x7c, 0x52, 0xc7, 0x88, 0x5c, 0xca, 0x7a,
	0xf4, 0x52, 0x62, 0x2b, 0x6d, 0x0e, 0x71, 0x38, 0xf3, 0x50, 0x0a, 0x2c, 0x51, 0x32, 0xb3, 0xad,
	0x10, 0xdd, 0xce, 0x4c, 0x7c, 0x3b, 0x99, 0xfb, 0xc7, 0x3d, 0x58, 0x92, 0x35, 0x57, 0xc2, 0xf8,
	0x45, 0xb4, 0x61, 0x98, 0x33, 0x38, 0x73, 0x87, 0x6d, 0xcb, 0x93, 0xaf, 0xaf, 0x18, 0x0d, 0x37,
	0x61, 0x39, 0xa9, 0x40, 0x38, 0x1b, 0xfe, 0x88, 0x95, 0x96, 0x1a, 0xbb, 0xb4, 0x5a, 0xae, 0x7a,
	0x7c, 0x85, 0xd5, 0x86, 0xe9, 0xc5, 0x52, 0xd4, 0xaf, 0x60, 0x65, 0x7f, 0x68, 0x44, 0x66, 0xd8,
	0xed, 0x9e, 0x66, 0x27, 0x79, 0xde, 0xc3, 0xf4, 0x67, 0x69, 0x90, 0xfa, 0x6f, 0x43, 0x3d, 0xac,
	0xf7, 0x98, 0xa1, 0xd9, 0x40, 0xaa, 0x14, 0x03, 0x3f, 0xc8, 0x94, 0x82, 0x20, 0x83, 0xff, 0xa8,
	0x40, 0x23, 0x52, 0x9f, 0x8e, 0x77, 0xf7, 0x2f, 0x01, 0x4e, 0x5f, 0x34, 0xd6, 0xbd, 0x00, 0xd8,
	0x32, 0x54, 0x1c, 0xd7, 0xec, 0x9b, 0xb6, 0xdc, 0x9f, 0x1c, 0xe1, 0x7f, 0x2b, 0x50, 0x95, 0xf5,
	0xd4, 0xff, 0x61, 0xfd, 0x7b, 0x0c, 0x35, 0xbf, 0xe8, 0x4a, 0x1d, 0xf5, 0x03, 0xa8, 0xf0, 0x32,
	0xcc, 0xcf, 0x6e, 0xef, 0x17, 0x08, 0xe4, 0xaa, 0x64, 0x61, 0x17, 0x5c, 0x3f, 0xd4, 0x6c, 0x9b,
	0x58, 0xe1, 0x6d, 0xaa, 0x4b, 0x4a, 0xc7, 0xc0, 0x04, 0x2e, 0xc4, 0x4a, 0xa7, 0x94, 0xf2, 0xf3,
	0xc9, 0xae, 0x7f, 0x57, 0x00, 0xc2, 0x67, 0xed, 0xf9, 0x3f, 0x8c, 0xcf, 0x09, 0xe6, 0x2d, 0x28,
	0x73, 0xeb, 0xa5, 0xac, 0xd0, 0x84, 0xea, 0x50, 0xa3, 0x94, 0xb8, 0xb6, 0xf4, 0x7d, 0x7f, 0x88,
	0x7f, 0xaf, 0x88, 0x93, 0x63, 0x02, 0xce, 0x1a, 0xdc, 0xa2, 0xb5, 0xd5, 0x6c, 0xbc, 0xb6, 0xba,
	0x0a, 0x30, 0x74, 0x1d, 0x63, 0xa4, 0xd3, 0x30, 0xc6, 0xd7, 0x25, 0xa5, 0x63, 0xe0, 0xbf, 0x29,
	0xb0, 0x98, 0x55, 0xd9, 0xa5, 0x10, 0x5d, 0x87, 0x8b, 0x41, 0xb5, 0x1b, 0xe9, 0x7d, 0xd4, 0xd5,
	0x0b, 0x3e, 0x59, 0xd8, 0xf3, 0x01, 0x54, 0x4c, 0x3f, 0x1c, 0x16, 0xf0, 0x39, 0x1e, 0x26, 0x55,
	0xc9, 0x12, 0x6c, 0x7b, 0x36, 0xdc, 0x36, 0xde, 0x85, 0x32, 0x5f, 0xc4, 0x42, 0x08, 0x4b, 0xa0,
	0xb2, 0x4e, 0x19, 0xb9, 0x16, 0x0b, 0x35, 0x61, 0x61, 0x30, 0xa3, 0x8a, 0x01, 0xbb, 0xe7, 0x91,
	0x6a, 0x60, 0x46, 0x95, 0x23, 0x7c, 0x0f, 0xe6, 0xa2, 0xa5, 0x4a, 0x6a, 0x87, 0x51, 0xfb, 0x96,
	0x62, 0xf6, 0xc5, 0xd7, 0xe0, 0xbd, 0x5d, 0x42, 0x1f, 0x93, 0xbe, 0xa6, 0x07, 0x25, 0xfc, 0xa6,
	0x65, 0xed, 0xab, 0x8f, 0x83, 0x42, 0xfb, 0x9f, 0x0a, 0x7f, 0x32, 0x8c, 0x59, 0x23, 0x0b, 0x8c,
	0xf7, 0x21, 0xb0, 0x96, 0xd7, 0x0b, 0x37, 0x13, 0xbc, 0x23, 0x3c, 0x56, 0x49, 0x44, 0x1f, 0x44,
	0xc2, 0x2e, 0x91, 0x8a, 0x23, 0x78, 0x10, 0x89, 0xfc, 0xc2, 0xd6, 0x6f, 0xc0, 0xa5, 0xe4, 0x7a,
	0xcd, 0xb2, 0x38, 0x8f, 0x70, 0x93, 0xc5, 0x38, 0x0f, 0x03, 0xe5, 0x5a, 0xd8, 0x88, 0xe0, 0xdd,
	0x12, 0xd7, 0x3a, 0x78, 0xa8, 0xf8, 0xb9, 0x23, 0x1e, 0x03, 0x94, 0x44, 0x0c, 0x60, 0xd5, 0x97,
	0x3f, 0x6d, 0x6b, 0x03, 0xdf, 0x5b, 0x1b, 0x92, 0xf6, 0x54, 0x1b, 0x10, 0x16, 0x5c, 0xaf, 0x4d,
	0x50, 0x23, 0xed, 0x72, 0x1f, 0x2a, 0x3d, 0xcb, 0xb4, 0x8f, 0x3c, 0x19, 0x6c, 0x73, 0x9c, 0xe6,
	0x31, 0x5b, 0xaa, 0x96, 0xf9, 0x1f, 0xf4, 0x22, 0x7d, 0x81, 0x3f, 0xcd, 0x61, 0xcf, 0x04, 0x93,
	0x75, 0xad, 0xff, 0xa5, 0xc0, 0xbb, 0x93, 0x57, 0x33, 0x1f, 0x74, 0x49, 0x9f, 0xbc, 0xf6, 0xd3,
	0x1d, 0x1f, 0x84, 0xd5, 0x46, 0x29, 0x5a, 0x6d, 0x7d, 0x08, 0x17, 0xbd, 0xd1, 0x4b, 0x4f, 0x77,
	0xcd, 0x97, 0xc4, 0xed, 0x39, 0xb6, 0x75, 0x22, 0x6b, 0x86, 0xf9, 0x90, 0xbc, 0x67, 0x5b, 0x27,
	0xbe, 0xab, 0xcf, 0x86, 0xae, 0x1e, 0x3a, 0x75, 0x99, 0x97, 0xb8, 0x72, 0x14, 0x5e, 0x81, 0x0a,
	0x27, 0x8b, 0x01, 0xbe, 0x0c, 0xd2, 0x38, 0x08, 0x66, 0x3d, 0x62, 0x1d, 0x48, 0x70, 0xfc, 0xfb,
	0xc6, 0x67, 0x30, 0x17, 0x8d, 0x87, 0xa8, 0x06, 0xb3, 0x4f, 0xf7, 0x9e, 0xee, 0x2c, 0xbc, 0x85,
	0x00, 0x2a, 0xea, 0xde, 0xc3, 0xbd, 0xe7, 0xdd, 0x05, 0x85, 0x7d, 0x3f, 0xdb, 0x57, 0x9f, 0x3d,
	0xde, 0x59, 0x28, 0xa1, 0x06, 0x54, 0x9f, 0xec, 0x3d, 0x7d, 0xb4, 0xf3, 0x8b, 0xee, 0xc2, 0xcc,
	0x0d, 0x0c, 0x15, 0xf1, 0x00, 0x63, 0x4b, 0x44, 0xae, 0x58, 0x78, 0x0b, 0xcd, 0x41, 0xcd, 0xa3,
	0xa6, 0x7e, 0x44, 0x5c, 0x6f, 0x41, 0x59, 0xff, 0xc7, 0x32, 0xcc, 0x3e, 0xd1, 0x8e, 0x1c, 0xf4,
	0x35, 0x5c, 0x4c, 0xb4, 0x1d, 0xd1, 0x9d, 0xdc, 0x97, 0x4c, 0x46, 0xaf, 0xad, 0xb5, 0x31, 0x25,
	0x97, 0x74, 0xac, 0xdf, 0xc2, 0x7c, 0xbc, 0x4d, 0x88, 0x6e, 0xe7, 0x64, 0x8a, 0xac, 0xd6, 0x65,
	0xeb, 0xce, 0x74, 0x4c, 0x52, 0xf9, 0x9f, 0x14, 0x40, 0xe9, 0x8e, 0x1e, 0xfa, 0x61, 0xce, 0xeb,
	0x76, 0x5c, 0xbf, 0xb1, 0x75, 0x77, 0x7a, 0x46, 0x89, 0xc4, 0x85, 0x46, 0xa4, 0x49, 0x86, 0x6e,
	0xe6, 0x1a, 0x33, 0xd1, 0x17, 0x6c, 0xdd, 0x9a, 0x82, 0x43, 0xea, 0x74, 0x00, 0xc2, 0x46, 0x17,
	0xfa, 0x38, 0xd7, 0x82, 0xf1, 0x46, 0x5b, 0xeb, 0x66, 0x71, 0x86, 0x88, 0xb9, 0xd3, 0xdd, 0xac,
	0x3c, 0x73, 0x8f, 0xed, 0x9a, 0xe5, 0x99, 0x7b, 0x42, 0xe3, 0xec, 0x1b, 0x85, 0x77, 0x5d, 0x52,
	0x3d, 0x2a, 0x74, 0xaf, 0x90, 0xc8, 0xac, 0x36, 0x59, 0xeb, 0xfe, 0x69, 0x58, 0x25, 0x9e, 0x6f,
	0x95, 0xa0, 0x3b, 0x98, 0xee, 0x43, 0xa1, 0xcf, 0xa7, 0x91, 0x9c, 0xee, 0x83, 0xb5, 0xbe, 0x38,
	0x35, 0xbf, 0x84, 0x37, 0x82, 0xb9, 0x58, 0xe9, 0x91, 0xef, 0x6c, 0xc9, 0x36, 0x57, 0x6b, 0x7d,
	0x1a, 0x16, 0xa9, 0xf6, 0x2f, 0x8a, 0xff, 0x03, 0x53, 0xa2, 0x71, 0x84, 0xee, 0x17, 0x97, 0x96,
	0x6c, 0x73, 0xb5, 0x1e, 0x9c, 0x8a, 0x57, 0x42, 0xfa, 0xb3, 0x22, 0xba, 0x78, 0x89, 0x56, 0x0e,
	0xba, 0x7b, 0x8a, 0xee, 0x8f, 0x80, 0x73, 0xef, 0xd4, 0x7d, 0x23, 0xf4, 0x9d, 0x02, 0xef, 0x4e,
	0x6e, 0x9c, 0xa0, 0xad, 0xc2, 0x47, 0x3f, 0xbe, 0xfb, 0xd3, 0xda, 0x3e, 0x9b, 0x10, 0x89, 0xf6,
	0x37, 0x30, 0x1f, 0xef, 0x1b, 0xe4, 0x45, 0xfa, 0xcc, 0xa6, 0x4b, 0x6b, 0x4a, 0xa6, 0x20, 0xcb,
	0xc4, 0x1f, 0xf9, 0x79, 0xba, 0x33, 0x7b, 0x0e, 0x79, 0x59, 0x26, 0xbb, 0x8f, 0x20, 0xb3, 0x4c,
	0xb2, 0x37, 0x90, 0x9f, 0x65, 0xc6, 0xb4, 0x1e, 0xf2, 0xb3, 0xcc, 0xb8, 0x36, 0x04, 0x47, 0x92,
	0xee, 0x12, 0xe4, 0x21, 0x19, 0xdb, 0xb9, 0xc8, 0x43, 0x32, 0xbe, 0x21, 0xe1, 0xa7, 0x82, 0xc4,
	0x6f, 0xd8, 0x05, 0x52, 0x41, 0xf6, 0x6f, 0xe5, 0x05, 0x52, 0xc1, 0xb8, 0x9f, 0xcb, 0x5f, 0xc3,
	0x85, 0xd8, 0x8f, 0xd8, 0xa8, 0x50, 0xa4, 0x4a, 0xa8, 0xbf, 0x3d, 0x15, 0x4f, 0x2c, 0xff, 0xfa,
	0x6a, 0xf3, 0xf3, 0x6f, 0x42, 0xe7, 0xcd, 0xe2, 0x0c, 0x52, 0xe1, 0x5f, 0x15, 0x68, 0x8e, 0x7b,
	0x01, 0xa1, 0xcf, 0x72, 0xb7, 0x30, 0xe9, 0x75, 0xd5, 0xfa, 0xfc, 0xb4, 0xec, 0xf1, 0x0c, 0x98,
	0x5d, 0xcb, 0xa3, 0xa2, 0xd2, 0xc7, 0x3c, 0x93, 0x0a, 0x64, 0xc0, 0xc9, 0xef, 0x9f, 0x87, 0x17,
	0x5e, 0x34, 0xf8, 0xbf, 0xa2, 0xe8, 0x96, 0x49, 0x6c, 0xfa, 0xb2, 0xc2, 0xff, 0x15, 0xe5, 0xf6,
	0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x2e, 0x30, 0x1a, 0xcf, 0xa6, 0x22, 0x00, 0x00,
}
