// Code generated by protoc-gen-go. DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated protocol buffer package.

It is generated from these files:
	twirp/subscriptions.proto

It has these top-level messages:
	EmailPendingPrefixApprovalRequest
	EmailPendingPrefixApprovalResponse
	EmailGlobalEmoteRequest
	EmailGlobalEmoteResponse
	EmailSubscribersRequest
	EmailSubscribersResponse
	EmoticonLevel
	SetScoreRequest
	SetScoreResponse
	SubscriptionCount
	CalculateSubscriberCountRequest
	CalculateSubscriberCountResponse
	GetUserSettingsRequest
	GetUserSettingsResponse
	SetUserSettingsRequest
	SetUserSettingsResponse
	OptionalBool
	Subscription
	FormerSubscriber
	FulfillSubscriptionRequest
	FulfillSubscriptionResponse
	CreateSubscriptionRequest
	CreateSubscriptionResponse
	CancelSubscriptionRequest
	CancelSubscriptionResponse
	UpdateSubscriptionRequest
	UpdateSubscriptionResponse
	CanSubscribeRequest
	CanSubscribeResponse
	UpdateTicketOriginIDRequest
	UpdateTicketOriginIDResponse
	ListUserSubscriptionsRequest
	ListUserExpiredSubscriptionsRequest
	GetUserChannelSubscriptionWithPaymentsDataRequest
	GetUserChannelSubscriptionRequest
	UserSubscription
	UserSubscriptionResult
	SubscriptionResult
	ListUserExpiredSubscriptionsResponse
	ListUserSubscriptionsResponse
	GetUserChannelSubscriptionWithPaymentsDataResponse
	GetUserChannelSubscriptionResponse
	GetUserProductSubscriptionsRequest
	GetUserProductSubscriptionsResponse
	GetUserProductSubscriptionsWithPaymentsDataRequest
	GetUserProductSubscriptionsWithPaymentsDataResponse
	GetUserSubscriptionsRequest
	GetUserSubscriptionsResponse
	GetChannelSubscriptionsRequest
	GetChannelSubscriptionsResponse
	GetFormerSubscribersRequest
	GetFormerSubscribersResponse
	GetSubscriptionByIDRequest
	GetSubscriptionByIDResponse
	GetTicketsByIDsRequest
	GetTicketsByIDsResponse
	GetHistoricalUserTicketsRequest
	GetHistoricalUserTicketsResponse
	TakedownBadgesRequest
	TakedownBadgesResponse
	TakedownAllBadgesRequest
	TakedownAllBadgesResponse
	GetSubscriberBadgeRequest
	GetSubscriberBadgeResponse
	GetChannelBadgeRequest
	GetChannelBadgeResponse
	DeleteChannelBadgeRequest
	DeleteChannelBadgeResponse
	CreateChannelBadgeUploadConfigRequest
	CreateChannelBadgeUploadConfigResponse
	CreateChannelBadgeRequest
	CreateChannelBadgeResponse
	GetTimeoutStatusesRequest
	GetTimeoutStatusesResponse
	ChannelBadge
	GetExternalProductTemplateSKURequest
	GetExternalProductTemplateSKUResponse
	GetExternalProductPurchasableSKURequest
	GetExternalProductPurchasableSKUResponse
	SubKey
	PaidUpgrade
	GetPaidUpgradesRequest
	GetPaidUpgradesResponse
	CreatePaidUpgradeRequest
	CreatePaidUpgradeResponse
	CancelPaidUpgradeRequest
	CancelPaidUpgradeResponse
	FulfillPaidUpgradeRequest
	FulfillPaidUpgradeResponse
	CreateChatNotificationTokenRequest
	CreateChatNotificationTokenResponse
	NewTicketInterval
	UseChatNotificationTokenRequest
	UseChatNotificationTokenResponse
	CancelChatNotificationTokenRequest
	CancelChatNotificationTokenResponse
	GetUserChannelChatNotificationTokenRequest
	GetUserChannelChatNotificationTokenResponse
	GetAllUsedChatNotificationTokensRequest
	GetAllUsedChatNotificationTokensResponse
	AllowReplayForLastUsedChatNotificationTokenRequest
	AllowReplayForLastUsedChatNotificationTokenResponse
	ChatNotificationToken
	UsedChatNotificationTokenItem
	Gift
	GiftKey
	InsertGiftRequest
	InsertGiftResponse
	CancelGiftRequest
	CancelGiftResponse
	GetGiftsRequest
	GetGiftsResponse
	CanGiftRequest
	CanGiftResponse
	CanSenderGiftRequest
	CanSenderGiftResponse
	CanGiftRecipientRequest
	CanGiftRecipientResponse
	GiftOfferId
	GiftPromotion
	Promotion
	GetGiftPromotionRequest
	GetGiftPromotionResponse
	GetPaidUpgradePromotionRequest
	GetPaidUpgradePromotionResponse
	FulfillGiftsRequest
	FulfillGiftsResponse
	SendGiftChatNotificationRequest
	SendGiftChatNotificationResponse
	SendMMGChatNotificationRequest
	SendMMGChatNotificationResponse
	SendMMGStartChatNotificationRequest
	SendMMGStartChatNotificationResponse
	GiftOffer
	GetGiftOffersRequest
	GetGiftOffersResponse
	GetRelatedChannelsRequest
	GetRelatedChannelsResponse
	GetEmotePrefixRequest
	GetEmotePrefixResponse
	GetEmoticonPrefixRequest
	GetEmoticonPrefixResponse
	CreateEmoticonRequest
	CreateEmoticonReponse
	DeleteEmoticonRequest
	DeleteEmoticonResponse
	GetAllEmoticonsByProductIDsRequest
	GetAllEmoticonsByProductIDsResponse
	EmoticonGroup
	Emoticon
	GetPartnerStandingRequest
	GetPartnerStandingResponse
	SubmitEmoticonPrefixRequest
	SubmitEmoticonPrefixResponse
	GetPendingEmoticonsByIDsRequest
	GetPendingEmoticonsByIDsResponse
	GetPendingEmoticonsRequest
	GetPendingEmoticonsResponse
	ReviewPendingEmoticonsRequest
	ReviewPendingEmoticonRequest
	ReviewPendingEmoticonsResponse
	ReviewPendingEmoticonResponse
	EmoticonBucket
	PendingEmoticon
	Product
	ProductInterval
	GetProductsByIDsRequest
	GetProductsByIDsResponse
	GetProductsByNamesRequest
	GetProductsByNamesResponse
	GetChannelProductsRequest
	GetChannelProductsResponse
	UpdateProductRequest
	UpdateProductResponse
	UpdateChannelProductsRequest
	UpdateChannelProductsResponse
	GetTicketsForUserChannelRequest
	GetTicketsForUserChannelResponse
	TicketGrantData
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Subscriptions
// =============
type Platform int32

const (
	Platform_PLATFORM_NONE    Platform = 0
	Platform_PLATFORM_WEB     Platform = 1
	Platform_PLATFORM_IOS     Platform = 2
	Platform_PLATFORM_ANDROID Platform = 3
	Platform_PLATFORM_AMAZON  Platform = 4
)

var Platform_name = map[int32]string{
	0: "PLATFORM_NONE",
	1: "PLATFORM_WEB",
	2: "PLATFORM_IOS",
	3: "PLATFORM_ANDROID",
	4: "PLATFORM_AMAZON",
}
var Platform_value = map[string]int32{
	"PLATFORM_NONE":    0,
	"PLATFORM_WEB":     1,
	"PLATFORM_IOS":     2,
	"PLATFORM_ANDROID": 3,
	"PLATFORM_AMAZON":  4,
}

func (x Platform) String() string {
	return proto.EnumName(Platform_name, int32(x))
}
func (Platform) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type SubscriptionType int32

const (
	// Subscription paid by the user.
	SubscriptionType_SUBSCRIPTION_PAID SubscriptionType = 0
	// Subscription created by spending a prime token.
	SubscriptionType_SUBSCRIPTION_PRIME SubscriptionType = 1
	// Free subscription created by admin tools.
	SubscriptionType_SUBSCRIPTION_ADMIN SubscriptionType = 2
	// When upgrading a non-recurring gift subscription to a recurring paid subscription.
	SubscriptionType_SUBSCRIPTION_GIFT_PAID_UPGRADE SubscriptionType = 3
	// When upgrading a non-recurring prime subscription to a recurring paid subscription.
	SubscriptionType_SUBSCRIPTION_PRIME_PAID_UPGRADE SubscriptionType = 4
	// Subscription for gift recipient.
	SubscriptionType_SUBSCRIPTION_GIFT SubscriptionType = 5
	// When resubscribing from a DNRd sub with a recurring payment plan
	SubscriptionType_SUBSCRIPTION_DNRD_RESUB_RECURRING SubscriptionType = 6
	// When resubscribing from a DNRd sub with a one-time purchase
	SubscriptionType_SUBSCRIPTION_DNRD_RESUB_NONRECURRING SubscriptionType = 7
	// Subscription based on a redeemed code.
	SubscriptionType_SUBSCRIPTION_CODE_REDEMPTION SubscriptionType = 8
	// When continuing a sub that was granted by a redeemed code.
	SubscriptionType_SUBSCRIPTION_CODE_REDEMPTION_PAID_UPGRADE SubscriptionType = 9
)

var SubscriptionType_name = map[int32]string{
	0: "SUBSCRIPTION_PAID",
	1: "SUBSCRIPTION_PRIME",
	2: "SUBSCRIPTION_ADMIN",
	3: "SUBSCRIPTION_GIFT_PAID_UPGRADE",
	4: "SUBSCRIPTION_PRIME_PAID_UPGRADE",
	5: "SUBSCRIPTION_GIFT",
	6: "SUBSCRIPTION_DNRD_RESUB_RECURRING",
	7: "SUBSCRIPTION_DNRD_RESUB_NONRECURRING",
	8: "SUBSCRIPTION_CODE_REDEMPTION",
	9: "SUBSCRIPTION_CODE_REDEMPTION_PAID_UPGRADE",
}
var SubscriptionType_value = map[string]int32{
	"SUBSCRIPTION_PAID":                         0,
	"SUBSCRIPTION_PRIME":                        1,
	"SUBSCRIPTION_ADMIN":                        2,
	"SUBSCRIPTION_GIFT_PAID_UPGRADE":            3,
	"SUBSCRIPTION_PRIME_PAID_UPGRADE":           4,
	"SUBSCRIPTION_GIFT":                         5,
	"SUBSCRIPTION_DNRD_RESUB_RECURRING":         6,
	"SUBSCRIPTION_DNRD_RESUB_NONRECURRING":      7,
	"SUBSCRIPTION_CODE_REDEMPTION":              8,
	"SUBSCRIPTION_CODE_REDEMPTION_PAID_UPGRADE": 9,
}

func (x SubscriptionType) String() string {
	return proto.EnumName(SubscriptionType_name, int32(x))
}
func (SubscriptionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type BadgeType int32

const (
	BadgeType_NO_BADGE         BadgeType = 0
	BadgeType_DEFAULT_BADGE    BadgeType = 1
	BadgeType_SUBSCRIBER_BADGE BadgeType = 2
)

var BadgeType_name = map[int32]string{
	0: "NO_BADGE",
	1: "DEFAULT_BADGE",
	2: "SUBSCRIBER_BADGE",
}
var BadgeType_value = map[string]int32{
	"NO_BADGE":         0,
	"DEFAULT_BADGE":    1,
	"SUBSCRIBER_BADGE": 2,
}

func (x BadgeType) String() string {
	return proto.EnumName(BadgeType_name, int32(x))
}
func (BadgeType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type GiftState int32

const (
	GiftState_GIFT_NONE     GiftState = 0
	GiftState_GIFT_ACCEPTED GiftState = 1
	GiftState_GIFT_CANCELED GiftState = 2
)

var GiftState_name = map[int32]string{
	0: "GIFT_NONE",
	1: "GIFT_ACCEPTED",
	2: "GIFT_CANCELED",
}
var GiftState_value = map[string]int32{
	"GIFT_NONE":     0,
	"GIFT_ACCEPTED": 1,
	"GIFT_CANCELED": 2,
}

func (x GiftState) String() string {
	return proto.EnumName(GiftState_name, int32(x))
}
func (GiftState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// DiscountType is the type of the discount.
type DiscountType int32

const (
	DiscountType_DISCOUNT_NONE          DiscountType = 0
	DiscountType_DISCOUNT_PERCENTOFF    DiscountType = 1
	DiscountType_DISCOUNT_FIXEDVALUEOFF DiscountType = 2
)

var DiscountType_name = map[int32]string{
	0: "DISCOUNT_NONE",
	1: "DISCOUNT_PERCENTOFF",
	2: "DISCOUNT_FIXEDVALUEOFF",
}
var DiscountType_value = map[string]int32{
	"DISCOUNT_NONE":          0,
	"DISCOUNT_PERCENTOFF":    1,
	"DISCOUNT_FIXEDVALUEOFF": 2,
}

func (x DiscountType) String() string {
	return proto.EnumName(DiscountType_name, int32(x))
}
func (DiscountType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type GiftType int32

const (
	GiftType_GIFT_TYPE_NONE      GiftType = 0
	GiftType_GIFT_TYPE_MYSTERY   GiftType = 1
	GiftType_GIFT_TYPE_STANDARD  GiftType = 2
	GiftType_GIFT_TYPE_COMMUNITY GiftType = 3
)

var GiftType_name = map[int32]string{
	0: "GIFT_TYPE_NONE",
	1: "GIFT_TYPE_MYSTERY",
	2: "GIFT_TYPE_STANDARD",
	3: "GIFT_TYPE_COMMUNITY",
}
var GiftType_value = map[string]int32{
	"GIFT_TYPE_NONE":      0,
	"GIFT_TYPE_MYSTERY":   1,
	"GIFT_TYPE_STANDARD":  2,
	"GIFT_TYPE_COMMUNITY": 3,
}

func (x GiftType) String() string {
	return proto.EnumName(GiftType_name, int32(x))
}
func (GiftType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// State of the emote.
type EmoticonState int32

const (
	EmoticonState_EmoticonState_NONE     EmoticonState = 0
	EmoticonState_EmoticonState_ACTIVE   EmoticonState = 1
	EmoticonState_EmoticonState_PENDING  EmoticonState = 2
	EmoticonState_EmoticonState_INACTIVE EmoticonState = 3
)

var EmoticonState_name = map[int32]string{
	0: "EmoticonState_NONE",
	1: "EmoticonState_ACTIVE",
	2: "EmoticonState_PENDING",
	3: "EmoticonState_INACTIVE",
}
var EmoticonState_value = map[string]int32{
	"EmoticonState_NONE":     0,
	"EmoticonState_ACTIVE":   1,
	"EmoticonState_PENDING":  2,
	"EmoticonState_INACTIVE": 3,
}

func (x EmoticonState) String() string {
	return proto.EnumName(EmoticonState_name, int32(x))
}
func (EmoticonState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// State of the emote prefix.
type EmoticonPrefixState int32

const (
	EmoticonPrefixState_PREFIX_UNKNOWN  EmoticonPrefixState = 0
	EmoticonPrefixState_PREFIX_UNSET    EmoticonPrefixState = 1
	EmoticonPrefixState_PREFIX_ACTIVE   EmoticonPrefixState = 2
	EmoticonPrefixState_PREFIX_REJECTED EmoticonPrefixState = 3
	EmoticonPrefixState_PREFIX_PENDING  EmoticonPrefixState = 4
)

var EmoticonPrefixState_name = map[int32]string{
	0: "PREFIX_UNKNOWN",
	1: "PREFIX_UNSET",
	2: "PREFIX_ACTIVE",
	3: "PREFIX_REJECTED",
	4: "PREFIX_PENDING",
}
var EmoticonPrefixState_value = map[string]int32{
	"PREFIX_UNKNOWN":  0,
	"PREFIX_UNSET":    1,
	"PREFIX_ACTIVE":   2,
	"PREFIX_REJECTED": 3,
	"PREFIX_PENDING":  4,
}

func (x EmoticonPrefixState) String() string {
	return proto.EnumName(EmoticonPrefixState_name, int32(x))
}
func (EmoticonPrefixState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type EmoticonFilter int32

const (
	EmoticonFilter_EmoticonFilter_All       EmoticonFilter = 0
	EmoticonFilter_EmoticonFilter_Partner   EmoticonFilter = 1
	EmoticonFilter_EmoticonFilter_Affiliate EmoticonFilter = 2
)

var EmoticonFilter_name = map[int32]string{
	0: "EmoticonFilter_All",
	1: "EmoticonFilter_Partner",
	2: "EmoticonFilter_Affiliate",
}
var EmoticonFilter_value = map[string]int32{
	"EmoticonFilter_All":       0,
	"EmoticonFilter_Partner":   1,
	"EmoticonFilter_Affiliate": 2,
}

func (x EmoticonFilter) String() string {
	return proto.EnumName(EmoticonFilter_name, int32(x))
}
func (EmoticonFilter) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type ProductIntervalUnit int32

const (
	ProductIntervalUnit_ProductIntervalUnit_NONE    ProductIntervalUnit = 0
	ProductIntervalUnit_ProductIntervalUnit_WEEK    ProductIntervalUnit = 1
	ProductIntervalUnit_ProductIntervalUnit_MONTH   ProductIntervalUnit = 2
	ProductIntervalUnit_ProductIntervalUnit_YEAR    ProductIntervalUnit = 3
	ProductIntervalUnit_ProductIntervalUnit_ONETIME ProductIntervalUnit = 4
)

var ProductIntervalUnit_name = map[int32]string{
	0: "ProductIntervalUnit_NONE",
	1: "ProductIntervalUnit_WEEK",
	2: "ProductIntervalUnit_MONTH",
	3: "ProductIntervalUnit_YEAR",
	4: "ProductIntervalUnit_ONETIME",
}
var ProductIntervalUnit_value = map[string]int32{
	"ProductIntervalUnit_NONE":    0,
	"ProductIntervalUnit_WEEK":    1,
	"ProductIntervalUnit_MONTH":   2,
	"ProductIntervalUnit_YEAR":    3,
	"ProductIntervalUnit_ONETIME": 4,
}

func (x ProductIntervalUnit) String() string {
	return proto.EnumName(ProductIntervalUnit_name, int32(x))
}
func (ProductIntervalUnit) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type ProductState int32

const (
	ProductState_ProductState_UNKNOWN  ProductState = 0
	ProductState_ProductState_ACTIVE   ProductState = 1
	ProductState_ProductState_INACTIVE ProductState = 2
)

var ProductState_name = map[int32]string{
	0: "ProductState_UNKNOWN",
	1: "ProductState_ACTIVE",
	2: "ProductState_INACTIVE",
}
var ProductState_value = map[string]int32{
	"ProductState_UNKNOWN":  0,
	"ProductState_ACTIVE":   1,
	"ProductState_INACTIVE": 2,
}

func (x ProductState) String() string {
	return proto.EnumName(ProductState_name, int32(x))
}
func (ProductState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type ListUserSubscriptionsRequest_Filter int32

const (
	ListUserSubscriptionsRequest_ALL      ListUserSubscriptionsRequest_Filter = 0
	ListUserSubscriptionsRequest_PLATFORM ListUserSubscriptionsRequest_Filter = 1
	ListUserSubscriptionsRequest_GIFT     ListUserSubscriptionsRequest_Filter = 2
	ListUserSubscriptionsRequest_NOTPRIME ListUserSubscriptionsRequest_Filter = 3
)

var ListUserSubscriptionsRequest_Filter_name = map[int32]string{
	0: "ALL",
	1: "PLATFORM",
	2: "GIFT",
	3: "NOTPRIME",
}
var ListUserSubscriptionsRequest_Filter_value = map[string]int32{
	"ALL":      0,
	"PLATFORM": 1,
	"GIFT":     2,
	"NOTPRIME": 3,
}

func (x ListUserSubscriptionsRequest_Filter) String() string {
	return proto.EnumName(ListUserSubscriptionsRequest_Filter_name, int32(x))
}
func (ListUserSubscriptionsRequest_Filter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{31, 0}
}

type GetChannelSubscriptionsRequest_OrderBy int32

const (
	GetChannelSubscriptionsRequest_NONE       GetChannelSubscriptionsRequest_OrderBy = 0
	GetChannelSubscriptionsRequest_UPDATED_AT GetChannelSubscriptionsRequest_OrderBy = 1
)

var GetChannelSubscriptionsRequest_OrderBy_name = map[int32]string{
	0: "NONE",
	1: "UPDATED_AT",
}
var GetChannelSubscriptionsRequest_OrderBy_value = map[string]int32{
	"NONE":       0,
	"UPDATED_AT": 1,
}

func (x GetChannelSubscriptionsRequest_OrderBy) String() string {
	return proto.EnumName(GetChannelSubscriptionsRequest_OrderBy_name, int32(x))
}
func (GetChannelSubscriptionsRequest_OrderBy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{48, 0}
}

type EmailPendingPrefixApprovalRequest struct {
	UserId        string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Prefix        string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	State         string `protobuf:"bytes,3,opt,name=state" json:"state,omitempty"`
	EmoticonSetId string `protobuf:"bytes,4,opt,name=emoticon_set_id,json=emoticonSetId" json:"emoticon_set_id,omitempty"`
}

func (m *EmailPendingPrefixApprovalRequest) Reset()         { *m = EmailPendingPrefixApprovalRequest{} }
func (m *EmailPendingPrefixApprovalRequest) String() string { return proto.CompactTextString(m) }
func (*EmailPendingPrefixApprovalRequest) ProtoMessage()    {}
func (*EmailPendingPrefixApprovalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0}
}

func (m *EmailPendingPrefixApprovalRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *EmailPendingPrefixApprovalRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *EmailPendingPrefixApprovalRequest) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *EmailPendingPrefixApprovalRequest) GetEmoticonSetId() string {
	if m != nil {
		return m.EmoticonSetId
	}
	return ""
}

type EmailPendingPrefixApprovalResponse struct {
}

func (m *EmailPendingPrefixApprovalResponse) Reset()         { *m = EmailPendingPrefixApprovalResponse{} }
func (m *EmailPendingPrefixApprovalResponse) String() string { return proto.CompactTextString(m) }
func (*EmailPendingPrefixApprovalResponse) ProtoMessage()    {}
func (*EmailPendingPrefixApprovalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1}
}

type EmailGlobalEmoteRequest struct {
	OwnerName  string `protobuf:"bytes,1,opt,name=owner_name,json=ownerName" json:"owner_name,omitempty"`
	OwnerEmail string `protobuf:"bytes,2,opt,name=owner_email,json=ownerEmail" json:"owner_email,omitempty"`
	EmoteId    string `protobuf:"bytes,3,opt,name=emote_id,json=emoteId" json:"emote_id,omitempty"`
}

func (m *EmailGlobalEmoteRequest) Reset()                    { *m = EmailGlobalEmoteRequest{} }
func (m *EmailGlobalEmoteRequest) String() string            { return proto.CompactTextString(m) }
func (*EmailGlobalEmoteRequest) ProtoMessage()               {}
func (*EmailGlobalEmoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *EmailGlobalEmoteRequest) GetOwnerName() string {
	if m != nil {
		return m.OwnerName
	}
	return ""
}

func (m *EmailGlobalEmoteRequest) GetOwnerEmail() string {
	if m != nil {
		return m.OwnerEmail
	}
	return ""
}

func (m *EmailGlobalEmoteRequest) GetEmoteId() string {
	if m != nil {
		return m.EmoteId
	}
	return ""
}

type EmailGlobalEmoteResponse struct {
}

func (m *EmailGlobalEmoteResponse) Reset()                    { *m = EmailGlobalEmoteResponse{} }
func (m *EmailGlobalEmoteResponse) String() string            { return proto.CompactTextString(m) }
func (*EmailGlobalEmoteResponse) ProtoMessage()               {}
func (*EmailGlobalEmoteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type EmailSubscribersRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Title     string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	Text      string `protobuf:"bytes,3,opt,name=text" json:"text,omitempty"`
}

func (m *EmailSubscribersRequest) Reset()                    { *m = EmailSubscribersRequest{} }
func (m *EmailSubscribersRequest) String() string            { return proto.CompactTextString(m) }
func (*EmailSubscribersRequest) ProtoMessage()               {}
func (*EmailSubscribersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *EmailSubscribersRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *EmailSubscribersRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *EmailSubscribersRequest) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

type EmailSubscribersResponse struct {
}

func (m *EmailSubscribersResponse) Reset()                    { *m = EmailSubscribersResponse{} }
func (m *EmailSubscribersResponse) String() string            { return proto.CompactTextString(m) }
func (*EmailSubscribersResponse) ProtoMessage()               {}
func (*EmailSubscribersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Score
// =====
type EmoticonLevel struct {
	MinimumScore  int64 `protobuf:"varint,1,opt,name=minimum_score,json=minimumScore" json:"minimum_score,omitempty"`
	EmoticonLimit int64 `protobuf:"varint,2,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
}

func (m *EmoticonLevel) Reset()                    { *m = EmoticonLevel{} }
func (m *EmoticonLevel) String() string            { return proto.CompactTextString(m) }
func (*EmoticonLevel) ProtoMessage()               {}
func (*EmoticonLevel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *EmoticonLevel) GetMinimumScore() int64 {
	if m != nil {
		return m.MinimumScore
	}
	return 0
}

func (m *EmoticonLevel) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

type SetScoreRequest struct {
	ChannelId       string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	SubscriberScore int64  `protobuf:"varint,2,opt,name=subscriber_score,json=subscriberScore" json:"subscriber_score,omitempty"`
}

func (m *SetScoreRequest) Reset()                    { *m = SetScoreRequest{} }
func (m *SetScoreRequest) String() string            { return proto.CompactTextString(m) }
func (*SetScoreRequest) ProtoMessage()               {}
func (*SetScoreRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *SetScoreRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SetScoreRequest) GetSubscriberScore() int64 {
	if m != nil {
		return m.SubscriberScore
	}
	return 0
}

type SetScoreResponse struct {
	SubscriberScore int64          `protobuf:"varint,1,opt,name=subscriber_score,json=subscriberScore" json:"subscriber_score,omitempty"`
	EmoticonLimit   int64          `protobuf:"varint,2,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
	NextLevel       *EmoticonLevel `protobuf:"bytes,3,opt,name=next_level,json=nextLevel" json:"next_level,omitempty"`
}

func (m *SetScoreResponse) Reset()                    { *m = SetScoreResponse{} }
func (m *SetScoreResponse) String() string            { return proto.CompactTextString(m) }
func (*SetScoreResponse) ProtoMessage()               {}
func (*SetScoreResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SetScoreResponse) GetSubscriberScore() int64 {
	if m != nil {
		return m.SubscriberScore
	}
	return 0
}

func (m *SetScoreResponse) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

func (m *SetScoreResponse) GetNextLevel() *EmoticonLevel {
	if m != nil {
		return m.NextLevel
	}
	return nil
}

type SubscriptionCount struct {
	Score          int64            `protobuf:"varint,1,opt,name=score" json:"score,omitempty"`
	NextLevel      *EmoticonLevel   `protobuf:"bytes,2,opt,name=next_level,json=nextLevel" json:"next_level,omitempty"`
	CountBreakdown map[string]int64 `protobuf:"bytes,3,rep,name=count_breakdown,json=countBreakdown" json:"count_breakdown,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	ScoreBreakdown map[string]int64 `protobuf:"bytes,4,rep,name=score_breakdown,json=scoreBreakdown" json:"score_breakdown,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	TicketCount    int64            `protobuf:"varint,5,opt,name=ticket_count,json=ticketCount" json:"ticket_count,omitempty"`
	EmoticonLimit  int64            `protobuf:"varint,6,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
}

func (m *SubscriptionCount) Reset()                    { *m = SubscriptionCount{} }
func (m *SubscriptionCount) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionCount) ProtoMessage()               {}
func (*SubscriptionCount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SubscriptionCount) GetScore() int64 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *SubscriptionCount) GetNextLevel() *EmoticonLevel {
	if m != nil {
		return m.NextLevel
	}
	return nil
}

func (m *SubscriptionCount) GetCountBreakdown() map[string]int64 {
	if m != nil {
		return m.CountBreakdown
	}
	return nil
}

func (m *SubscriptionCount) GetScoreBreakdown() map[string]int64 {
	if m != nil {
		return m.ScoreBreakdown
	}
	return nil
}

func (m *SubscriptionCount) GetTicketCount() int64 {
	if m != nil {
		return m.TicketCount
	}
	return 0
}

func (m *SubscriptionCount) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

type CalculateSubscriberCountRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *CalculateSubscriberCountRequest) Reset()         { *m = CalculateSubscriberCountRequest{} }
func (m *CalculateSubscriberCountRequest) String() string { return proto.CompactTextString(m) }
func (*CalculateSubscriberCountRequest) ProtoMessage()    {}
func (*CalculateSubscriberCountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10}
}

func (m *CalculateSubscriberCountRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type CalculateSubscriberCountResponse struct {
	SubsCount *SubscriptionCount `protobuf:"bytes,1,opt,name=subs_count,json=subsCount" json:"subs_count,omitempty"`
}

func (m *CalculateSubscriberCountResponse) Reset()         { *m = CalculateSubscriberCountResponse{} }
func (m *CalculateSubscriberCountResponse) String() string { return proto.CompactTextString(m) }
func (*CalculateSubscriberCountResponse) ProtoMessage()    {}
func (*CalculateSubscriberCountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11}
}

func (m *CalculateSubscriberCountResponse) GetSubsCount() *SubscriptionCount {
	if m != nil {
		return m.SubsCount
	}
	return nil
}

// UserSettings
// ============
type GetUserSettingsRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *GetUserSettingsRequest) Reset()                    { *m = GetUserSettingsRequest{} }
func (m *GetUserSettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserSettingsRequest) ProtoMessage()               {}
func (*GetUserSettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetUserSettingsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetUserSettingsResponse struct {
	GiftsInFollowedChannelsOnly bool `protobuf:"varint,1,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	HideGiftCount               bool `protobuf:"varint,2,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
	HideSubscriptionStatus      bool `protobuf:"varint,3,opt,name=hide_subscription_status,json=hideSubscriptionStatus" json:"hide_subscription_status,omitempty"`
}

func (m *GetUserSettingsResponse) Reset()                    { *m = GetUserSettingsResponse{} }
func (m *GetUserSettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserSettingsResponse) ProtoMessage()               {}
func (*GetUserSettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetUserSettingsResponse) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *GetUserSettingsResponse) GetHideGiftCount() bool {
	if m != nil {
		return m.HideGiftCount
	}
	return false
}

func (m *GetUserSettingsResponse) GetHideSubscriptionStatus() bool {
	if m != nil {
		return m.HideSubscriptionStatus
	}
	return false
}

type SetUserSettingsRequest struct {
	UserId                             string        `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	GiftsInFollowedChannelsOnly        bool          `protobuf:"varint,2,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	ReceiveGiftsInFollowedChannelsOnly *OptionalBool `protobuf:"bytes,3,opt,name=receive_gifts_in_followed_channels_only,json=receiveGiftsInFollowedChannelsOnly" json:"receive_gifts_in_followed_channels_only,omitempty"`
	HideGiftCount                      *OptionalBool `protobuf:"bytes,4,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
	HideSubscriptionStatus             *OptionalBool `protobuf:"bytes,5,opt,name=hide_subscription_status,json=hideSubscriptionStatus" json:"hide_subscription_status,omitempty"`
}

func (m *SetUserSettingsRequest) Reset()                    { *m = SetUserSettingsRequest{} }
func (m *SetUserSettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetUserSettingsRequest) ProtoMessage()               {}
func (*SetUserSettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *SetUserSettingsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *SetUserSettingsRequest) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *SetUserSettingsRequest) GetReceiveGiftsInFollowedChannelsOnly() *OptionalBool {
	if m != nil {
		return m.ReceiveGiftsInFollowedChannelsOnly
	}
	return nil
}

func (m *SetUserSettingsRequest) GetHideGiftCount() *OptionalBool {
	if m != nil {
		return m.HideGiftCount
	}
	return nil
}

func (m *SetUserSettingsRequest) GetHideSubscriptionStatus() *OptionalBool {
	if m != nil {
		return m.HideSubscriptionStatus
	}
	return nil
}

type SetUserSettingsResponse struct {
	GiftsInFollowedChannelsOnly bool `protobuf:"varint,1,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	HideGiftCount               bool `protobuf:"varint,2,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
	HideSubscriptionStatus      bool `protobuf:"varint,3,opt,name=hide_subscription_status,json=hideSubscriptionStatus" json:"hide_subscription_status,omitempty"`
}

func (m *SetUserSettingsResponse) Reset()                    { *m = SetUserSettingsResponse{} }
func (m *SetUserSettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*SetUserSettingsResponse) ProtoMessage()               {}
func (*SetUserSettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *SetUserSettingsResponse) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *SetUserSettingsResponse) GetHideGiftCount() bool {
	if m != nil {
		return m.HideGiftCount
	}
	return false
}

func (m *SetUserSettingsResponse) GetHideSubscriptionStatus() bool {
	if m != nil {
		return m.HideSubscriptionStatus
	}
	return false
}

type OptionalBool struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *OptionalBool) Reset()                    { *m = OptionalBool{} }
func (m *OptionalBool) String() string            { return proto.CompactTextString(m) }
func (*OptionalBool) ProtoMessage()               {}
func (*OptionalBool) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *OptionalBool) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

// Subscription defines a user's entitlement to product for a time period.
type Subscription struct {
	Id           string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ChannelId    string                     `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	OwnerId      string                     `protobuf:"bytes,3,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,4,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,5,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,7,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	AccessGuid   string                     `protobuf:"bytes,8,opt,name=access_guid,json=accessGuid" json:"access_guid,omitempty"`
	UpdatedOn    *google_protobuf.Timestamp `protobuf:"bytes,9,opt,name=updated_on,json=updatedOn" json:"updated_on,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *Subscription) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Subscription) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *Subscription) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Subscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *Subscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *Subscription) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *Subscription) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *Subscription) GetAccessGuid() string {
	if m != nil {
		return m.AccessGuid
	}
	return ""
}

func (m *Subscription) GetUpdatedOn() *google_protobuf.Timestamp {
	if m != nil {
		return m.UpdatedOn
	}
	return nil
}

type FormerSubscriber struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *FormerSubscriber) Reset()                    { *m = FormerSubscriber{} }
func (m *FormerSubscriber) String() string            { return proto.CompactTextString(m) }
func (*FormerSubscriber) ProtoMessage()               {}
func (*FormerSubscriber) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *FormerSubscriber) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FormerSubscriber) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type FulfillSubscriptionRequest struct {
	OwnerId          string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId        string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId         string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd       *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Platform         Platform                   `protobuf:"varint,6,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	SubscriptionType SubscriptionType           `protobuf:"varint,7,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *FulfillSubscriptionRequest) Reset()                    { *m = FulfillSubscriptionRequest{} }
func (m *FulfillSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*FulfillSubscriptionRequest) ProtoMessage()               {}
func (*FulfillSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *FulfillSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *FulfillSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *FulfillSubscriptionRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *FulfillSubscriptionRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type FulfillSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *FulfillSubscriptionResponse) Reset()                    { *m = FulfillSubscriptionResponse{} }
func (m *FulfillSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*FulfillSubscriptionResponse) ProtoMessage()               {}
func (*FulfillSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *FulfillSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

// CreateSubscription
// ===================
type CreateSubscriptionRequest struct {
	OwnerId          string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId        string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId         string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd       *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	SubscriptionType SubscriptionType           `protobuf:"varint,6,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *CreateSubscriptionRequest) Reset()                    { *m = CreateSubscriptionRequest{} }
func (m *CreateSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSubscriptionRequest) ProtoMessage()               {}
func (*CreateSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *CreateSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *CreateSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *CreateSubscriptionRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type CreateSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *CreateSubscriptionResponse) Reset()                    { *m = CreateSubscriptionResponse{} }
func (m *CreateSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateSubscriptionResponse) ProtoMessage()               {}
func (*CreateSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *CreateSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

// CancelSubscription
// ==================
type CancelSubscriptionRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId  string `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
}

func (m *CancelSubscriptionRequest) Reset()                    { *m = CancelSubscriptionRequest{} }
func (m *CancelSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionRequest) ProtoMessage()               {}
func (*CancelSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *CancelSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CancelSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CancelSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

type CancelSubscriptionResponse struct {
}

func (m *CancelSubscriptionResponse) Reset()                    { *m = CancelSubscriptionResponse{} }
func (m *CancelSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionResponse) ProtoMessage()               {}
func (*CancelSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

// UpdateSubscription
// ==================
type UpdateSubscriptionRequest struct {
	// Types that are valid to be assigned to Subscription:
	//	*UpdateSubscriptionRequest_Id
	//	*UpdateSubscriptionRequest_Key
	Subscription isUpdateSubscriptionRequest_Subscription `protobuf_oneof:"subscription"`
	BenefitEnd   *google_protobuf.Timestamp               `protobuf:"bytes,3,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
}

func (m *UpdateSubscriptionRequest) Reset()                    { *m = UpdateSubscriptionRequest{} }
func (m *UpdateSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSubscriptionRequest) ProtoMessage()               {}
func (*UpdateSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

type isUpdateSubscriptionRequest_Subscription interface{ isUpdateSubscriptionRequest_Subscription() }

type UpdateSubscriptionRequest_Id struct {
	Id string `protobuf:"bytes,1,opt,name=id,oneof"`
}
type UpdateSubscriptionRequest_Key struct {
	Key *SubKey `protobuf:"bytes,2,opt,name=key,oneof"`
}

func (*UpdateSubscriptionRequest_Id) isUpdateSubscriptionRequest_Subscription()  {}
func (*UpdateSubscriptionRequest_Key) isUpdateSubscriptionRequest_Subscription() {}

func (m *UpdateSubscriptionRequest) GetSubscription() isUpdateSubscriptionRequest_Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UpdateSubscriptionRequest) GetId() string {
	if x, ok := m.GetSubscription().(*UpdateSubscriptionRequest_Id); ok {
		return x.Id
	}
	return ""
}

func (m *UpdateSubscriptionRequest) GetKey() *SubKey {
	if x, ok := m.GetSubscription().(*UpdateSubscriptionRequest_Key); ok {
		return x.Key
	}
	return nil
}

func (m *UpdateSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UpdateSubscriptionRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UpdateSubscriptionRequest_OneofMarshaler, _UpdateSubscriptionRequest_OneofUnmarshaler, _UpdateSubscriptionRequest_OneofSizer, []interface{}{
		(*UpdateSubscriptionRequest_Id)(nil),
		(*UpdateSubscriptionRequest_Key)(nil),
	}
}

func _UpdateSubscriptionRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UpdateSubscriptionRequest)
	// subscription
	switch x := m.Subscription.(type) {
	case *UpdateSubscriptionRequest_Id:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Id)
	case *UpdateSubscriptionRequest_Key:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Key); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UpdateSubscriptionRequest.Subscription has unexpected type %T", x)
	}
	return nil
}

func _UpdateSubscriptionRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UpdateSubscriptionRequest)
	switch tag {
	case 1: // subscription.id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Subscription = &UpdateSubscriptionRequest_Id{x}
		return true, err
	case 2: // subscription.key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubKey)
		err := b.DecodeMessage(msg)
		m.Subscription = &UpdateSubscriptionRequest_Key{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UpdateSubscriptionRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UpdateSubscriptionRequest)
	// subscription
	switch x := m.Subscription.(type) {
	case *UpdateSubscriptionRequest_Id:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Id)))
		n += len(x.Id)
	case *UpdateSubscriptionRequest_Key:
		s := proto.Size(x.Key)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type UpdateSubscriptionResponse struct {
}

func (m *UpdateSubscriptionResponse) Reset()                    { *m = UpdateSubscriptionResponse{} }
func (m *UpdateSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateSubscriptionResponse) ProtoMessage()               {}
func (*UpdateSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type CanSubscribeRequest struct {
	OwnerId          string           `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId        string           `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform         Platform         `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	SubscriptionType SubscriptionType `protobuf:"varint,4,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *CanSubscribeRequest) Reset()                    { *m = CanSubscribeRequest{} }
func (m *CanSubscribeRequest) String() string            { return proto.CompactTextString(m) }
func (*CanSubscribeRequest) ProtoMessage()               {}
func (*CanSubscribeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *CanSubscribeRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CanSubscribeRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CanSubscribeRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *CanSubscribeRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type CanSubscribeResponse struct {
	CanSubscribe bool `protobuf:"varint,1,opt,name=can_subscribe,json=canSubscribe" json:"can_subscribe,omitempty"`
}

func (m *CanSubscribeResponse) Reset()                    { *m = CanSubscribeResponse{} }
func (m *CanSubscribeResponse) String() string            { return proto.CompactTextString(m) }
func (*CanSubscribeResponse) ProtoMessage()               {}
func (*CanSubscribeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *CanSubscribeResponse) GetCanSubscribe() bool {
	if m != nil {
		return m.CanSubscribe
	}
	return false
}

// UpdateTicketOwnerID
// ===================
type UpdateTicketOriginIDRequest struct {
	TicketId             string `protobuf:"bytes,1,opt,name=ticket_id,json=ticketId" json:"ticket_id,omitempty"`
	NewOriginId          string `protobuf:"bytes,2,opt,name=new_origin_id,json=newOriginId" json:"new_origin_id,omitempty"`
	NewPurchaseProfileId int64  `protobuf:"varint,3,opt,name=new_purchase_profile_id,json=newPurchaseProfileId" json:"new_purchase_profile_id,omitempty"`
}

func (m *UpdateTicketOriginIDRequest) Reset()                    { *m = UpdateTicketOriginIDRequest{} }
func (m *UpdateTicketOriginIDRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateTicketOriginIDRequest) ProtoMessage()               {}
func (*UpdateTicketOriginIDRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *UpdateTicketOriginIDRequest) GetTicketId() string {
	if m != nil {
		return m.TicketId
	}
	return ""
}

func (m *UpdateTicketOriginIDRequest) GetNewOriginId() string {
	if m != nil {
		return m.NewOriginId
	}
	return ""
}

func (m *UpdateTicketOriginIDRequest) GetNewPurchaseProfileId() int64 {
	if m != nil {
		return m.NewPurchaseProfileId
	}
	return 0
}

type UpdateTicketOriginIDResponse struct {
}

func (m *UpdateTicketOriginIDResponse) Reset()                    { *m = UpdateTicketOriginIDResponse{} }
func (m *UpdateTicketOriginIDResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateTicketOriginIDResponse) ProtoMessage()               {}
func (*UpdateTicketOriginIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

// ListUserSubscriptionsRequest is the body of ListUserSubscriptions request.
type ListUserSubscriptionsRequest struct {
	OwnerId  string                              `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Limit    int64                               `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Cursor   string                              `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
	Platform Platform                            `protobuf:"varint,4,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	Filter   ListUserSubscriptionsRequest_Filter `protobuf:"varint,5,opt,name=filter,enum=code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest_Filter" json:"filter,omitempty"`
}

func (m *ListUserSubscriptionsRequest) Reset()                    { *m = ListUserSubscriptionsRequest{} }
func (m *ListUserSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListUserSubscriptionsRequest) ProtoMessage()               {}
func (*ListUserSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *ListUserSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *ListUserSubscriptionsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListUserSubscriptionsRequest) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

func (m *ListUserSubscriptionsRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *ListUserSubscriptionsRequest) GetFilter() ListUserSubscriptionsRequest_Filter {
	if m != nil {
		return m.Filter
	}
	return ListUserSubscriptionsRequest_ALL
}

type ListUserExpiredSubscriptionsRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Limit   int64  `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Offset  int64  `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
}

func (m *ListUserExpiredSubscriptionsRequest) Reset()         { *m = ListUserExpiredSubscriptionsRequest{} }
func (m *ListUserExpiredSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListUserExpiredSubscriptionsRequest) ProtoMessage()    {}
func (*ListUserExpiredSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{32}
}

func (m *ListUserExpiredSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *ListUserExpiredSubscriptionsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListUserExpiredSubscriptionsRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GetUserChannelSubscriptionWithPaymentsDataRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) Reset() {
	*m = GetUserChannelSubscriptionWithPaymentsDataRequest{}
}
func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelSubscriptionWithPaymentsDataRequest) ProtoMessage() {}
func (*GetUserChannelSubscriptionWithPaymentsDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{33}
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetUserChannelSubscriptionRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelSubscriptionRequest) Reset()         { *m = GetUserChannelSubscriptionRequest{} }
func (m *GetUserChannelSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserChannelSubscriptionRequest) ProtoMessage()    {}
func (*GetUserChannelSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{34}
}

func (m *GetUserChannelSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserChannelSubscriptionRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// UserSubscription defines active subscription for a twitch user.
type UserSubscription struct {
	SubscriptionId string                     `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
	OwnerId        string                     `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId      string                     `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId       string                     `protobuf:"bytes,4,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart   *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd     *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Platform       Platform                   `protobuf:"varint,7,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	RenewsAt       *google_protobuf.Timestamp `protobuf:"bytes,8,opt,name=renews_at,json=renewsAt" json:"renews_at,omitempty"`
	ExtPurchaseSku string                     `protobuf:"bytes,9,opt,name=ext_purchase_sku,json=extPurchaseSku" json:"ext_purchase_sku,omitempty"`
	IsPrime        bool                       `protobuf:"varint,10,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
	IsGift         bool                       `protobuf:"varint,11,opt,name=is_gift,json=isGift" json:"is_gift,omitempty"`
	IsRefundable   bool                       `protobuf:"varint,12,opt,name=is_refundable,json=isRefundable" json:"is_refundable,omitempty"`
	IsDnrd         bool                       `protobuf:"varint,13,opt,name=is_dnrd,json=isDnrd" json:"is_dnrd,omitempty"`
	UpdatedOn      *google_protobuf.Timestamp `protobuf:"bytes,14,opt,name=updated_on,json=updatedOn" json:"updated_on,omitempty"`
}

func (m *UserSubscription) Reset()                    { *m = UserSubscription{} }
func (m *UserSubscription) String() string            { return proto.CompactTextString(m) }
func (*UserSubscription) ProtoMessage()               {}
func (*UserSubscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *UserSubscription) GetSubscriptionId() string {
	if m != nil {
		return m.SubscriptionId
	}
	return ""
}

func (m *UserSubscription) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *UserSubscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *UserSubscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *UserSubscription) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *UserSubscription) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *UserSubscription) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *UserSubscription) GetRenewsAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.RenewsAt
	}
	return nil
}

func (m *UserSubscription) GetExtPurchaseSku() string {
	if m != nil {
		return m.ExtPurchaseSku
	}
	return ""
}

func (m *UserSubscription) GetIsPrime() bool {
	if m != nil {
		return m.IsPrime
	}
	return false
}

func (m *UserSubscription) GetIsGift() bool {
	if m != nil {
		return m.IsGift
	}
	return false
}

func (m *UserSubscription) GetIsRefundable() bool {
	if m != nil {
		return m.IsRefundable
	}
	return false
}

func (m *UserSubscription) GetIsDnrd() bool {
	if m != nil {
		return m.IsDnrd
	}
	return false
}

func (m *UserSubscription) GetUpdatedOn() *google_protobuf.Timestamp {
	if m != nil {
		return m.UpdatedOn
	}
	return nil
}

// Element of a list of UserSubscriptions
type UserSubscriptionResult struct {
	Subscription *UserSubscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	Cursor       string            `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
}

func (m *UserSubscriptionResult) Reset()                    { *m = UserSubscriptionResult{} }
func (m *UserSubscriptionResult) String() string            { return proto.CompactTextString(m) }
func (*UserSubscriptionResult) ProtoMessage()               {}
func (*UserSubscriptionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *UserSubscriptionResult) GetSubscription() *UserSubscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UserSubscriptionResult) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

type SubscriptionResult struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	Cursor       string        `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
}

func (m *SubscriptionResult) Reset()                    { *m = SubscriptionResult{} }
func (m *SubscriptionResult) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionResult) ProtoMessage()               {}
func (*SubscriptionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *SubscriptionResult) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *SubscriptionResult) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

type ListUserExpiredSubscriptionsResponse struct {
	Subscriptions   []*SubscriptionResult `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	HasPreviousPage bool                  `protobuf:"varint,2,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool                  `protobuf:"varint,3,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *ListUserExpiredSubscriptionsResponse) Reset()         { *m = ListUserExpiredSubscriptionsResponse{} }
func (m *ListUserExpiredSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListUserExpiredSubscriptionsResponse) ProtoMessage()    {}
func (*ListUserExpiredSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{38}
}

func (m *ListUserExpiredSubscriptionsResponse) GetSubscriptions() []*SubscriptionResult {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListUserExpiredSubscriptionsResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *ListUserExpiredSubscriptionsResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

// ListUserSubscriptionsResponse is the response to a ListUserSubscriptions request.
type ListUserSubscriptionsResponse struct {
	Results         []*UserSubscriptionResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
	HasPreviousPage bool                      `protobuf:"varint,2,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool                      `protobuf:"varint,3,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *ListUserSubscriptionsResponse) Reset()                    { *m = ListUserSubscriptionsResponse{} }
func (m *ListUserSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListUserSubscriptionsResponse) ProtoMessage()               {}
func (*ListUserSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *ListUserSubscriptionsResponse) GetResults() []*UserSubscriptionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListUserSubscriptionsResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *ListUserSubscriptionsResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

type GetUserChannelSubscriptionWithPaymentsDataResponse struct {
	Subscription *UserSubscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) Reset() {
	*m = GetUserChannelSubscriptionWithPaymentsDataResponse{}
}
func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelSubscriptionWithPaymentsDataResponse) ProtoMessage() {}
func (*GetUserChannelSubscriptionWithPaymentsDataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{40}
}

func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) GetSubscription() *UserSubscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type GetUserChannelSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetUserChannelSubscriptionResponse) Reset()         { *m = GetUserChannelSubscriptionResponse{} }
func (m *GetUserChannelSubscriptionResponse) String() string { return proto.CompactTextString(m) }
func (*GetUserChannelSubscriptionResponse) ProtoMessage()    {}
func (*GetUserChannelSubscriptionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{41}
}

func (m *GetUserChannelSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type GetUserProductSubscriptionsRequest struct {
	OwnerId    string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductIds []string `protobuf:"bytes,2,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetUserProductSubscriptionsRequest) Reset()         { *m = GetUserProductSubscriptionsRequest{} }
func (m *GetUserProductSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserProductSubscriptionsRequest) ProtoMessage()    {}
func (*GetUserProductSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{42}
}

func (m *GetUserProductSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserProductSubscriptionsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetUserProductSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserProductSubscriptionsResponse) Reset()         { *m = GetUserProductSubscriptionsResponse{} }
func (m *GetUserProductSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*GetUserProductSubscriptionsResponse) ProtoMessage()    {}
func (*GetUserProductSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{43}
}

func (m *GetUserProductSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

type GetUserProductSubscriptionsWithPaymentsDataRequest struct {
	OwnerId    string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductIds []string `protobuf:"bytes,2,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetUserProductSubscriptionsWithPaymentsDataRequest) Reset() {
	*m = GetUserProductSubscriptionsWithPaymentsDataRequest{}
}
func (m *GetUserProductSubscriptionsWithPaymentsDataRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserProductSubscriptionsWithPaymentsDataRequest) ProtoMessage() {}
func (*GetUserProductSubscriptionsWithPaymentsDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{44}
}

func (m *GetUserProductSubscriptionsWithPaymentsDataRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserProductSubscriptionsWithPaymentsDataRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetUserProductSubscriptionsWithPaymentsDataResponse struct {
	Subscriptions []*UserSubscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserProductSubscriptionsWithPaymentsDataResponse) Reset() {
	*m = GetUserProductSubscriptionsWithPaymentsDataResponse{}
}
func (m *GetUserProductSubscriptionsWithPaymentsDataResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserProductSubscriptionsWithPaymentsDataResponse) ProtoMessage() {}
func (*GetUserProductSubscriptionsWithPaymentsDataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{45}
}

func (m *GetUserProductSubscriptionsWithPaymentsDataResponse) GetSubscriptions() []*UserSubscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

type GetUserSubscriptionsRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetUserSubscriptionsRequest) Reset()                    { *m = GetUserSubscriptionsRequest{} }
func (m *GetUserSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserSubscriptionsRequest) ProtoMessage()               {}
func (*GetUserSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *GetUserSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetUserSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserSubscriptionsResponse) Reset()                    { *m = GetUserSubscriptionsResponse{} }
func (m *GetUserSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserSubscriptionsResponse) ProtoMessage()               {}
func (*GetUserSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *GetUserSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// GetChannelSubscriptions
type GetChannelSubscriptionsRequest struct {
	ChannelId string                                 `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Limit     int32                                  `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Offset    int32                                  `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
	OrderBy   GetChannelSubscriptionsRequest_OrderBy `protobuf:"varint,4,opt,name=order_by,json=orderBy,enum=code.justin.tv.revenue.subscriptions.GetChannelSubscriptionsRequest_OrderBy" json:"order_by,omitempty"`
}

func (m *GetChannelSubscriptionsRequest) Reset()                    { *m = GetChannelSubscriptionsRequest{} }
func (m *GetChannelSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelSubscriptionsRequest) ProtoMessage()               {}
func (*GetChannelSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *GetChannelSubscriptionsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetChannelSubscriptionsRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetChannelSubscriptionsRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *GetChannelSubscriptionsRequest) GetOrderBy() GetChannelSubscriptionsRequest_OrderBy {
	if m != nil {
		return m.OrderBy
	}
	return GetChannelSubscriptionsRequest_NONE
}

type GetChannelSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetChannelSubscriptionsResponse) Reset()         { *m = GetChannelSubscriptionsResponse{} }
func (m *GetChannelSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*GetChannelSubscriptionsResponse) ProtoMessage()    {}
func (*GetChannelSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{49}
}

func (m *GetChannelSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// GetFormerSubscribers
type GetFormerSubscribersRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Limit     int32  `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Offset    int32  `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
}

func (m *GetFormerSubscribersRequest) Reset()                    { *m = GetFormerSubscribersRequest{} }
func (m *GetFormerSubscribersRequest) String() string            { return proto.CompactTextString(m) }
func (*GetFormerSubscribersRequest) ProtoMessage()               {}
func (*GetFormerSubscribersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *GetFormerSubscribersRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetFormerSubscribersRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetFormerSubscribersRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GetFormerSubscribersResponse struct {
	TotalCount      int32               `protobuf:"varint,1,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
	Subscribers     []*FormerSubscriber `protobuf:"bytes,2,rep,name=subscribers" json:"subscribers,omitempty"`
	HasPreviousPage bool                `protobuf:"varint,3,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool                `protobuf:"varint,4,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *GetFormerSubscribersResponse) Reset()                    { *m = GetFormerSubscribersResponse{} }
func (m *GetFormerSubscribersResponse) String() string            { return proto.CompactTextString(m) }
func (*GetFormerSubscribersResponse) ProtoMessage()               {}
func (*GetFormerSubscribersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *GetFormerSubscribersResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *GetFormerSubscribersResponse) GetSubscribers() []*FormerSubscriber {
	if m != nil {
		return m.Subscribers
	}
	return nil
}

func (m *GetFormerSubscribersResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *GetFormerSubscribersResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

// GetSubscriptionByID
type GetSubscriptionByIDRequest struct {
	// Types that are valid to be assigned to Subscription:
	//	*GetSubscriptionByIDRequest_SubKey
	//	*GetSubscriptionByIDRequest_Id
	Subscription isGetSubscriptionByIDRequest_Subscription `protobuf_oneof:"subscription"`
}

func (m *GetSubscriptionByIDRequest) Reset()                    { *m = GetSubscriptionByIDRequest{} }
func (m *GetSubscriptionByIDRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionByIDRequest) ProtoMessage()               {}
func (*GetSubscriptionByIDRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

type isGetSubscriptionByIDRequest_Subscription interface{ isGetSubscriptionByIDRequest_Subscription() }

type GetSubscriptionByIDRequest_SubKey struct {
	SubKey *SubKey `protobuf:"bytes,1,opt,name=sub_key,json=subKey,oneof"`
}
type GetSubscriptionByIDRequest_Id struct {
	Id string `protobuf:"bytes,2,opt,name=id,oneof"`
}

func (*GetSubscriptionByIDRequest_SubKey) isGetSubscriptionByIDRequest_Subscription() {}
func (*GetSubscriptionByIDRequest_Id) isGetSubscriptionByIDRequest_Subscription()     {}

func (m *GetSubscriptionByIDRequest) GetSubscription() isGetSubscriptionByIDRequest_Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *GetSubscriptionByIDRequest) GetSubKey() *SubKey {
	if x, ok := m.GetSubscription().(*GetSubscriptionByIDRequest_SubKey); ok {
		return x.SubKey
	}
	return nil
}

func (m *GetSubscriptionByIDRequest) GetId() string {
	if x, ok := m.GetSubscription().(*GetSubscriptionByIDRequest_Id); ok {
		return x.Id
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GetSubscriptionByIDRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GetSubscriptionByIDRequest_OneofMarshaler, _GetSubscriptionByIDRequest_OneofUnmarshaler, _GetSubscriptionByIDRequest_OneofSizer, []interface{}{
		(*GetSubscriptionByIDRequest_SubKey)(nil),
		(*GetSubscriptionByIDRequest_Id)(nil),
	}
}

func _GetSubscriptionByIDRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GetSubscriptionByIDRequest)
	// subscription
	switch x := m.Subscription.(type) {
	case *GetSubscriptionByIDRequest_SubKey:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SubKey); err != nil {
			return err
		}
	case *GetSubscriptionByIDRequest_Id:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Id)
	case nil:
	default:
		return fmt.Errorf("GetSubscriptionByIDRequest.Subscription has unexpected type %T", x)
	}
	return nil
}

func _GetSubscriptionByIDRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GetSubscriptionByIDRequest)
	switch tag {
	case 1: // subscription.sub_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubKey)
		err := b.DecodeMessage(msg)
		m.Subscription = &GetSubscriptionByIDRequest_SubKey{msg}
		return true, err
	case 2: // subscription.id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Subscription = &GetSubscriptionByIDRequest_Id{x}
		return true, err
	default:
		return false, nil
	}
}

func _GetSubscriptionByIDRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GetSubscriptionByIDRequest)
	// subscription
	switch x := m.Subscription.(type) {
	case *GetSubscriptionByIDRequest_SubKey:
		s := proto.Size(x.SubKey)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GetSubscriptionByIDRequest_Id:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Id)))
		n += len(x.Id)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type GetSubscriptionByIDResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetSubscriptionByIDResponse) Reset()                    { *m = GetSubscriptionByIDResponse{} }
func (m *GetSubscriptionByIDResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionByIDResponse) ProtoMessage()               {}
func (*GetSubscriptionByIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *GetSubscriptionByIDResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

// GetTicketsByIDs
type GetTicketsByIDsRequest struct {
	Ids []string `protobuf:"bytes,1,rep,name=ids" json:"ids,omitempty"`
}

func (m *GetTicketsByIDsRequest) Reset()                    { *m = GetTicketsByIDsRequest{} }
func (m *GetTicketsByIDsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTicketsByIDsRequest) ProtoMessage()               {}
func (*GetTicketsByIDsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *GetTicketsByIDsRequest) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

type GetTicketsByIDsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetTicketsByIDsResponse) Reset()                    { *m = GetTicketsByIDsResponse{} }
func (m *GetTicketsByIDsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTicketsByIDsResponse) ProtoMessage()               {}
func (*GetTicketsByIDsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *GetTicketsByIDsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// GetHistoricalUserTickets
type GetHistoricalUserTicketsRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetHistoricalUserTicketsRequest) Reset()         { *m = GetHistoricalUserTicketsRequest{} }
func (m *GetHistoricalUserTicketsRequest) String() string { return proto.CompactTextString(m) }
func (*GetHistoricalUserTicketsRequest) ProtoMessage()    {}
func (*GetHistoricalUserTicketsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{56}
}

func (m *GetHistoricalUserTicketsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetHistoricalUserTicketsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetHistoricalUserTicketsResponse) Reset()         { *m = GetHistoricalUserTicketsResponse{} }
func (m *GetHistoricalUserTicketsResponse) String() string { return proto.CompactTextString(m) }
func (*GetHistoricalUserTicketsResponse) ProtoMessage()    {}
func (*GetHistoricalUserTicketsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{57}
}

func (m *GetHistoricalUserTicketsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// Subscriber Badges
// ================
type TakedownBadgesRequest struct {
	ChannelId string   `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	BadgeIds  []string `protobuf:"bytes,2,rep,name=badge_ids,json=badgeIds" json:"badge_ids,omitempty"`
	Reason    string   `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
}

func (m *TakedownBadgesRequest) Reset()                    { *m = TakedownBadgesRequest{} }
func (m *TakedownBadgesRequest) String() string            { return proto.CompactTextString(m) }
func (*TakedownBadgesRequest) ProtoMessage()               {}
func (*TakedownBadgesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *TakedownBadgesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *TakedownBadgesRequest) GetBadgeIds() []string {
	if m != nil {
		return m.BadgeIds
	}
	return nil
}

func (m *TakedownBadgesRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type TakedownBadgesResponse struct {
	BadgesRemoved []string `protobuf:"bytes,1,rep,name=badges_removed,json=badgesRemoved" json:"badges_removed,omitempty"`
}

func (m *TakedownBadgesResponse) Reset()                    { *m = TakedownBadgesResponse{} }
func (m *TakedownBadgesResponse) String() string            { return proto.CompactTextString(m) }
func (*TakedownBadgesResponse) ProtoMessage()               {}
func (*TakedownBadgesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

func (m *TakedownBadgesResponse) GetBadgesRemoved() []string {
	if m != nil {
		return m.BadgesRemoved
	}
	return nil
}

type TakedownAllBadgesRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Reason    string `protobuf:"bytes,2,opt,name=reason" json:"reason,omitempty"`
}

func (m *TakedownAllBadgesRequest) Reset()                    { *m = TakedownAllBadgesRequest{} }
func (m *TakedownAllBadgesRequest) String() string            { return proto.CompactTextString(m) }
func (*TakedownAllBadgesRequest) ProtoMessage()               {}
func (*TakedownAllBadgesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

func (m *TakedownAllBadgesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *TakedownAllBadgesRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type TakedownAllBadgesResponse struct {
	BadgesRemoved []string `protobuf:"bytes,1,rep,name=badges_removed,json=badgesRemoved" json:"badges_removed,omitempty"`
}

func (m *TakedownAllBadgesResponse) Reset()                    { *m = TakedownAllBadgesResponse{} }
func (m *TakedownAllBadgesResponse) String() string            { return proto.CompactTextString(m) }
func (*TakedownAllBadgesResponse) ProtoMessage()               {}
func (*TakedownAllBadgesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61} }

func (m *TakedownAllBadgesResponse) GetBadgesRemoved() []string {
	if m != nil {
		return m.BadgesRemoved
	}
	return nil
}

type GetSubscriberBadgeRequest struct {
	ChannelId                  string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	UserId                     string `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	IsCumulativeTenureLoadTest bool   `protobuf:"varint,3,opt,name=is_cumulative_tenure_load_test,json=isCumulativeTenureLoadTest" json:"is_cumulative_tenure_load_test,omitempty"`
}

func (m *GetSubscriberBadgeRequest) Reset()                    { *m = GetSubscriberBadgeRequest{} }
func (m *GetSubscriberBadgeRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriberBadgeRequest) ProtoMessage()               {}
func (*GetSubscriberBadgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{62} }

func (m *GetSubscriberBadgeRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetSubscriberBadgeRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetSubscriberBadgeRequest) GetIsCumulativeTenureLoadTest() bool {
	if m != nil {
		return m.IsCumulativeTenureLoadTest
	}
	return false
}

type GetSubscriberBadgeResponse struct {
	BadgeType    BadgeType `protobuf:"varint,1,opt,name=badge_type,json=badgeType,enum=code.justin.tv.revenue.subscriptions.BadgeType" json:"badge_type,omitempty"`
	BadgeVersion string    `protobuf:"bytes,2,opt,name=badge_version,json=badgeVersion" json:"badge_version,omitempty"`
	DynamicData  string    `protobuf:"bytes,3,opt,name=dynamic_data,json=dynamicData" json:"dynamic_data,omitempty"`
}

func (m *GetSubscriberBadgeResponse) Reset()                    { *m = GetSubscriberBadgeResponse{} }
func (m *GetSubscriberBadgeResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriberBadgeResponse) ProtoMessage()               {}
func (*GetSubscriberBadgeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{63} }

func (m *GetSubscriberBadgeResponse) GetBadgeType() BadgeType {
	if m != nil {
		return m.BadgeType
	}
	return BadgeType_NO_BADGE
}

func (m *GetSubscriberBadgeResponse) GetBadgeVersion() string {
	if m != nil {
		return m.BadgeVersion
	}
	return ""
}

func (m *GetSubscriberBadgeResponse) GetDynamicData() string {
	if m != nil {
		return m.DynamicData
	}
	return ""
}

type GetChannelBadgeRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetChannelBadgeRequest) Reset()                    { *m = GetChannelBadgeRequest{} }
func (m *GetChannelBadgeRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelBadgeRequest) ProtoMessage()               {}
func (*GetChannelBadgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{64} }

func (m *GetChannelBadgeRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetChannelBadgeResponse struct {
	Badges []*ChannelBadge `protobuf:"bytes,1,rep,name=badges" json:"badges,omitempty"`
}

func (m *GetChannelBadgeResponse) Reset()                    { *m = GetChannelBadgeResponse{} }
func (m *GetChannelBadgeResponse) String() string            { return proto.CompactTextString(m) }
func (*GetChannelBadgeResponse) ProtoMessage()               {}
func (*GetChannelBadgeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{65} }

func (m *GetChannelBadgeResponse) GetBadges() []*ChannelBadge {
	if m != nil {
		return m.Badges
	}
	return nil
}

type DeleteChannelBadgeRequest struct {
	ChannelId             string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	BadgeId               int32  `protobuf:"varint,2,opt,name=badge_id,json=badgeId" json:"badge_id,omitempty"`
	ChannelTenureMethodId string `protobuf:"bytes,3,opt,name=channel_tenure_method_id,json=channelTenureMethodId" json:"channel_tenure_method_id,omitempty"`
}

func (m *DeleteChannelBadgeRequest) Reset()                    { *m = DeleteChannelBadgeRequest{} }
func (m *DeleteChannelBadgeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteChannelBadgeRequest) ProtoMessage()               {}
func (*DeleteChannelBadgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{66} }

func (m *DeleteChannelBadgeRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *DeleteChannelBadgeRequest) GetBadgeId() int32 {
	if m != nil {
		return m.BadgeId
	}
	return 0
}

func (m *DeleteChannelBadgeRequest) GetChannelTenureMethodId() string {
	if m != nil {
		return m.ChannelTenureMethodId
	}
	return ""
}

type DeleteChannelBadgeResponse struct {
	Id                    int32  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	RequiredTenureMonths  int32  `protobuf:"varint,2,opt,name=required_tenure_months,json=requiredTenureMonths" json:"required_tenure_months,omitempty"`
	ChannelTenureMethodId string `protobuf:"bytes,3,opt,name=channel_tenure_method_id,json=channelTenureMethodId" json:"channel_tenure_method_id,omitempty"`
}

func (m *DeleteChannelBadgeResponse) Reset()                    { *m = DeleteChannelBadgeResponse{} }
func (m *DeleteChannelBadgeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteChannelBadgeResponse) ProtoMessage()               {}
func (*DeleteChannelBadgeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{67} }

func (m *DeleteChannelBadgeResponse) GetId() int32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *DeleteChannelBadgeResponse) GetRequiredTenureMonths() int32 {
	if m != nil {
		return m.RequiredTenureMonths
	}
	return 0
}

func (m *DeleteChannelBadgeResponse) GetChannelTenureMethodId() string {
	if m != nil {
		return m.ChannelTenureMethodId
	}
	return ""
}

type CreateChannelBadgeUploadConfigRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Size      int32  `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
}

func (m *CreateChannelBadgeUploadConfigRequest) Reset()         { *m = CreateChannelBadgeUploadConfigRequest{} }
func (m *CreateChannelBadgeUploadConfigRequest) String() string { return proto.CompactTextString(m) }
func (*CreateChannelBadgeUploadConfigRequest) ProtoMessage()    {}
func (*CreateChannelBadgeUploadConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{68}
}

func (m *CreateChannelBadgeUploadConfigRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *CreateChannelBadgeUploadConfigRequest) GetSize() int32 {
	if m != nil {
		return m.Size
	}
	return 0
}

type CreateChannelBadgeUploadConfigResponse struct {
	UploadUrl string `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl" json:"upload_url,omitempty"`
	UploadId  string `protobuf:"bytes,2,opt,name=upload_id,json=uploadId" json:"upload_id,omitempty"`
	ImageUrl  string `protobuf:"bytes,3,opt,name=image_url,json=imageUrl" json:"image_url,omitempty"`
	ImageId   string `protobuf:"bytes,4,opt,name=image_id,json=imageId" json:"image_id,omitempty"`
}

func (m *CreateChannelBadgeUploadConfigResponse) Reset() {
	*m = CreateChannelBadgeUploadConfigResponse{}
}
func (m *CreateChannelBadgeUploadConfigResponse) String() string { return proto.CompactTextString(m) }
func (*CreateChannelBadgeUploadConfigResponse) ProtoMessage()    {}
func (*CreateChannelBadgeUploadConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{69}
}

func (m *CreateChannelBadgeUploadConfigResponse) GetUploadUrl() string {
	if m != nil {
		return m.UploadUrl
	}
	return ""
}

func (m *CreateChannelBadgeUploadConfigResponse) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

func (m *CreateChannelBadgeUploadConfigResponse) GetImageUrl() string {
	if m != nil {
		return m.ImageUrl
	}
	return ""
}

func (m *CreateChannelBadgeUploadConfigResponse) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type CreateChannelBadgeRequest struct {
	ChannelId            string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Image_1XId           string `protobuf:"bytes,2,opt,name=image_1x_id,json=image1xId" json:"image_1x_id,omitempty"`
	Image_2XId           string `protobuf:"bytes,3,opt,name=image_2x_id,json=image2xId" json:"image_2x_id,omitempty"`
	Image_4XId           string `protobuf:"bytes,4,opt,name=image_4x_id,json=image4xId" json:"image_4x_id,omitempty"`
	RequiredTenureMonths int32  `protobuf:"varint,5,opt,name=required_tenure_months,json=requiredTenureMonths" json:"required_tenure_months,omitempty"`
}

func (m *CreateChannelBadgeRequest) Reset()                    { *m = CreateChannelBadgeRequest{} }
func (m *CreateChannelBadgeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateChannelBadgeRequest) ProtoMessage()               {}
func (*CreateChannelBadgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{70} }

func (m *CreateChannelBadgeRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *CreateChannelBadgeRequest) GetImage_1XId() string {
	if m != nil {
		return m.Image_1XId
	}
	return ""
}

func (m *CreateChannelBadgeRequest) GetImage_2XId() string {
	if m != nil {
		return m.Image_2XId
	}
	return ""
}

func (m *CreateChannelBadgeRequest) GetImage_4XId() string {
	if m != nil {
		return m.Image_4XId
	}
	return ""
}

func (m *CreateChannelBadgeRequest) GetRequiredTenureMonths() int32 {
	if m != nil {
		return m.RequiredTenureMonths
	}
	return 0
}

type CreateChannelBadgeResponse struct {
	Id                    int32  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Image_1XUrl           string `protobuf:"bytes,2,opt,name=image_1x_url,json=image1xUrl" json:"image_1x_url,omitempty"`
	Image_2XUrl           string `protobuf:"bytes,3,opt,name=image_2x_url,json=image2xUrl" json:"image_2x_url,omitempty"`
	Image_4XUrl           string `protobuf:"bytes,4,opt,name=image_4x_url,json=image4xUrl" json:"image_4x_url,omitempty"`
	RequiredTenureMonths  int32  `protobuf:"varint,5,opt,name=required_tenure_months,json=requiredTenureMonths" json:"required_tenure_months,omitempty"`
	Title                 string `protobuf:"bytes,6,opt,name=title" json:"title,omitempty"`
	ChannelTenureMethodId string `protobuf:"bytes,7,opt,name=channel_tenure_method_id,json=channelTenureMethodId" json:"channel_tenure_method_id,omitempty"`
}

func (m *CreateChannelBadgeResponse) Reset()                    { *m = CreateChannelBadgeResponse{} }
func (m *CreateChannelBadgeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateChannelBadgeResponse) ProtoMessage()               {}
func (*CreateChannelBadgeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{71} }

func (m *CreateChannelBadgeResponse) GetId() int32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *CreateChannelBadgeResponse) GetImage_1XUrl() string {
	if m != nil {
		return m.Image_1XUrl
	}
	return ""
}

func (m *CreateChannelBadgeResponse) GetImage_2XUrl() string {
	if m != nil {
		return m.Image_2XUrl
	}
	return ""
}

func (m *CreateChannelBadgeResponse) GetImage_4XUrl() string {
	if m != nil {
		return m.Image_4XUrl
	}
	return ""
}

func (m *CreateChannelBadgeResponse) GetRequiredTenureMonths() int32 {
	if m != nil {
		return m.RequiredTenureMonths
	}
	return 0
}

func (m *CreateChannelBadgeResponse) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *CreateChannelBadgeResponse) GetChannelTenureMethodId() string {
	if m != nil {
		return m.ChannelTenureMethodId
	}
	return ""
}

type GetTimeoutStatusesRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetTimeoutStatusesRequest) Reset()                    { *m = GetTimeoutStatusesRequest{} }
func (m *GetTimeoutStatusesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTimeoutStatusesRequest) ProtoMessage()               {}
func (*GetTimeoutStatusesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{72} }

func (m *GetTimeoutStatusesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetTimeoutStatusesResponse struct {
	BadgesTimeout bool `protobuf:"varint,1,opt,name=badges_timeout,json=badgesTimeout" json:"badges_timeout,omitempty"`
}

func (m *GetTimeoutStatusesResponse) Reset()                    { *m = GetTimeoutStatusesResponse{} }
func (m *GetTimeoutStatusesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTimeoutStatusesResponse) ProtoMessage()               {}
func (*GetTimeoutStatusesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{73} }

func (m *GetTimeoutStatusesResponse) GetBadgesTimeout() bool {
	if m != nil {
		return m.BadgesTimeout
	}
	return false
}

type ChannelBadge struct {
	Id                    int32  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Image_1XUrl           string `protobuf:"bytes,2,opt,name=image_1x_url,json=image1xUrl" json:"image_1x_url,omitempty"`
	Image_2XUrl           string `protobuf:"bytes,3,opt,name=image_2x_url,json=image2xUrl" json:"image_2x_url,omitempty"`
	Image_4XUrl           string `protobuf:"bytes,4,opt,name=image_4x_url,json=image4xUrl" json:"image_4x_url,omitempty"`
	RequiredTenureMonths  int32  `protobuf:"varint,5,opt,name=required_tenure_months,json=requiredTenureMonths" json:"required_tenure_months,omitempty"`
	Title                 string `protobuf:"bytes,6,opt,name=title" json:"title,omitempty"`
	ChannelTenureMethodId string `protobuf:"bytes,7,opt,name=channel_tenure_method_id,json=channelTenureMethodId" json:"channel_tenure_method_id,omitempty"`
}

func (m *ChannelBadge) Reset()                    { *m = ChannelBadge{} }
func (m *ChannelBadge) String() string            { return proto.CompactTextString(m) }
func (*ChannelBadge) ProtoMessage()               {}
func (*ChannelBadge) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{74} }

func (m *ChannelBadge) GetId() int32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ChannelBadge) GetImage_1XUrl() string {
	if m != nil {
		return m.Image_1XUrl
	}
	return ""
}

func (m *ChannelBadge) GetImage_2XUrl() string {
	if m != nil {
		return m.Image_2XUrl
	}
	return ""
}

func (m *ChannelBadge) GetImage_4XUrl() string {
	if m != nil {
		return m.Image_4XUrl
	}
	return ""
}

func (m *ChannelBadge) GetRequiredTenureMonths() int32 {
	if m != nil {
		return m.RequiredTenureMonths
	}
	return 0
}

func (m *ChannelBadge) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *ChannelBadge) GetChannelTenureMethodId() string {
	if m != nil {
		return m.ChannelTenureMethodId
	}
	return ""
}

// External Product
// ================
type GetExternalProductTemplateSKURequest struct {
	ProductId   string   `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform    Platform `protobuf:"varint,2,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,3,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
}

func (m *GetExternalProductTemplateSKURequest) Reset()         { *m = GetExternalProductTemplateSKURequest{} }
func (m *GetExternalProductTemplateSKURequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductTemplateSKURequest) ProtoMessage()    {}
func (*GetExternalProductTemplateSKURequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{75}
}

func (m *GetExternalProductTemplateSKURequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GetExternalProductTemplateSKURequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetExternalProductTemplateSKURequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

type GetExternalProductTemplateSKUResponse struct {
	SkuId string `protobuf:"bytes,1,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
}

func (m *GetExternalProductTemplateSKUResponse) Reset()         { *m = GetExternalProductTemplateSKUResponse{} }
func (m *GetExternalProductTemplateSKUResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductTemplateSKUResponse) ProtoMessage()    {}
func (*GetExternalProductTemplateSKUResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{76}
}

func (m *GetExternalProductTemplateSKUResponse) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

type GetExternalProductPurchasableSKURequest struct {
	OwnerId     string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId   string   `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform    Platform `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,4,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
}

func (m *GetExternalProductPurchasableSKURequest) Reset() {
	*m = GetExternalProductPurchasableSKURequest{}
}
func (m *GetExternalProductPurchasableSKURequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductPurchasableSKURequest) ProtoMessage()    {}
func (*GetExternalProductPurchasableSKURequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{77}
}

func (m *GetExternalProductPurchasableSKURequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetExternalProductPurchasableSKURequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GetExternalProductPurchasableSKURequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetExternalProductPurchasableSKURequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

type GetExternalProductPurchasableSKUResponse struct {
	SkuId string `protobuf:"bytes,1,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
}

func (m *GetExternalProductPurchasableSKUResponse) Reset() {
	*m = GetExternalProductPurchasableSKUResponse{}
}
func (m *GetExternalProductPurchasableSKUResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductPurchasableSKUResponse) ProtoMessage()    {}
func (*GetExternalProductPurchasableSKUResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{78}
}

func (m *GetExternalProductPurchasableSKUResponse) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

type SubKey struct {
	Product string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Owner   string `protobuf:"bytes,2,opt,name=owner" json:"owner,omitempty"`
	Origin  string `protobuf:"bytes,3,opt,name=origin" json:"origin,omitempty"`
}

func (m *SubKey) Reset()                    { *m = SubKey{} }
func (m *SubKey) String() string            { return proto.CompactTextString(m) }
func (*SubKey) ProtoMessage()               {}
func (*SubKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{79} }

func (m *SubKey) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *SubKey) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *SubKey) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

type PaidUpgrade struct {
	BaseKey          *SubKey                    `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey       *SubKey                    `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
	EntitlementId    string                     `protobuf:"bytes,3,opt,name=entitlement_id,json=entitlementId" json:"entitlement_id,omitempty"`
	StartDate        *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=start_date,json=startDate" json:"start_date,omitempty"`
	Tier             string                     `protobuf:"bytes,5,opt,name=tier" json:"tier,omitempty"`
	Price            int32                      `protobuf:"varint,6,opt,name=price" json:"price,omitempty"`
	PriceId          string                     `protobuf:"bytes,7,opt,name=price_id,json=priceId" json:"price_id,omitempty"`
	SubscriptionType SubscriptionType           `protobuf:"varint,8,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
	IsCancelable     bool                       `protobuf:"varint,9,opt,name=is_cancelable,json=isCancelable" json:"is_cancelable,omitempty"`
}

func (m *PaidUpgrade) Reset()                    { *m = PaidUpgrade{} }
func (m *PaidUpgrade) String() string            { return proto.CompactTextString(m) }
func (*PaidUpgrade) ProtoMessage()               {}
func (*PaidUpgrade) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{80} }

func (m *PaidUpgrade) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *PaidUpgrade) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

func (m *PaidUpgrade) GetEntitlementId() string {
	if m != nil {
		return m.EntitlementId
	}
	return ""
}

func (m *PaidUpgrade) GetStartDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *PaidUpgrade) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *PaidUpgrade) GetPrice() int32 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *PaidUpgrade) GetPriceId() string {
	if m != nil {
		return m.PriceId
	}
	return ""
}

func (m *PaidUpgrade) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

func (m *PaidUpgrade) GetIsCancelable() bool {
	if m != nil {
		return m.IsCancelable
	}
	return false
}

type GetPaidUpgradesRequest struct {
	Keys []*SubKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetPaidUpgradesRequest) Reset()                    { *m = GetPaidUpgradesRequest{} }
func (m *GetPaidUpgradesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPaidUpgradesRequest) ProtoMessage()               {}
func (*GetPaidUpgradesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{81} }

func (m *GetPaidUpgradesRequest) GetKeys() []*SubKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

type GetPaidUpgradesResponse struct {
	PaidUpgrades []*PaidUpgrade `protobuf:"bytes,1,rep,name=paid_upgrades,json=paidUpgrades" json:"paid_upgrades,omitempty"`
}

func (m *GetPaidUpgradesResponse) Reset()                    { *m = GetPaidUpgradesResponse{} }
func (m *GetPaidUpgradesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPaidUpgradesResponse) ProtoMessage()               {}
func (*GetPaidUpgradesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{82} }

func (m *GetPaidUpgradesResponse) GetPaidUpgrades() []*PaidUpgrade {
	if m != nil {
		return m.PaidUpgrades
	}
	return nil
}

type CreatePaidUpgradeRequest struct {
	BaseKey          *SubKey          `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey       *SubKey          `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
	SubscriptionType SubscriptionType `protobuf:"varint,3,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *CreatePaidUpgradeRequest) Reset()                    { *m = CreatePaidUpgradeRequest{} }
func (m *CreatePaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePaidUpgradeRequest) ProtoMessage()               {}
func (*CreatePaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{83} }

func (m *CreatePaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *CreatePaidUpgradeRequest) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

func (m *CreatePaidUpgradeRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type CreatePaidUpgradeResponse struct {
	PaidUpgrade *PaidUpgrade `protobuf:"bytes,1,opt,name=paid_upgrade,json=paidUpgrade" json:"paid_upgrade,omitempty"`
}

func (m *CreatePaidUpgradeResponse) Reset()                    { *m = CreatePaidUpgradeResponse{} }
func (m *CreatePaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreatePaidUpgradeResponse) ProtoMessage()               {}
func (*CreatePaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{84} }

func (m *CreatePaidUpgradeResponse) GetPaidUpgrade() *PaidUpgrade {
	if m != nil {
		return m.PaidUpgrade
	}
	return nil
}

type CancelPaidUpgradeRequest struct {
	BaseKey    *SubKey `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey *SubKey `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
}

func (m *CancelPaidUpgradeRequest) Reset()                    { *m = CancelPaidUpgradeRequest{} }
func (m *CancelPaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelPaidUpgradeRequest) ProtoMessage()               {}
func (*CancelPaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{85} }

func (m *CancelPaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *CancelPaidUpgradeRequest) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

type CancelPaidUpgradeResponse struct {
}

func (m *CancelPaidUpgradeResponse) Reset()                    { *m = CancelPaidUpgradeResponse{} }
func (m *CancelPaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelPaidUpgradeResponse) ProtoMessage()               {}
func (*CancelPaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{86} }

type FulfillPaidUpgradeRequest struct {
	OwnerId          string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId        string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId         string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd       *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	BaseKey          *SubKey                    `protobuf:"bytes,6,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	SubscriptionType SubscriptionType           `protobuf:"varint,7,opt,name=subscription_type,json=subscriptionType,enum=code.justin.tv.revenue.subscriptions.SubscriptionType" json:"subscription_type,omitempty"`
}

func (m *FulfillPaidUpgradeRequest) Reset()                    { *m = FulfillPaidUpgradeRequest{} }
func (m *FulfillPaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*FulfillPaidUpgradeRequest) ProtoMessage()               {}
func (*FulfillPaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{87} }

func (m *FulfillPaidUpgradeRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *FulfillPaidUpgradeRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *FulfillPaidUpgradeRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *FulfillPaidUpgradeRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *FulfillPaidUpgradeRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *FulfillPaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *FulfillPaidUpgradeRequest) GetSubscriptionType() SubscriptionType {
	if m != nil {
		return m.SubscriptionType
	}
	return SubscriptionType_SUBSCRIPTION_PAID
}

type FulfillPaidUpgradeResponse struct {
	PaidUpgrade *PaidUpgrade `protobuf:"bytes,1,opt,name=paid_upgrade,json=paidUpgrade" json:"paid_upgrade,omitempty"`
}

func (m *FulfillPaidUpgradeResponse) Reset()                    { *m = FulfillPaidUpgradeResponse{} }
func (m *FulfillPaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*FulfillPaidUpgradeResponse) ProtoMessage()               {}
func (*FulfillPaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{88} }

func (m *FulfillPaidUpgradeResponse) GetPaidUpgrade() *PaidUpgrade {
	if m != nil {
		return m.PaidUpgrade
	}
	return nil
}

// Chat Notifications
// ======
// Example Body for CreateChatNotificationTokenRequest:
// {
// 	    "owner_id": "29386024", Who does the token belong to?
//      "product_id": "834",    Which ticket product?
//      "available_at": "2018-01-02T15:04:05Z",    When is the token granted?
//      "is_prime" : {"value": true}, specifies whether or not the token is coming from a prime sub. Defaults to paid/not-prime if unspecified.
// 		"new_ticket_interval" : {"access_start" : "2018-06-18T15:04:05Z",   used for multi-month subscriptions since the ticket does not
// 							    "access_end" : "2018-07-18T15:04:05Z"}      persist before chat notification call is made from payments service
// }
type CreateChatNotificationTokenRequest struct {
	OwnerId           string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId         string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	AvailableAt       *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=available_at,json=availableAt" json:"available_at,omitempty"`
	IsPrime           *OptionalBool              `protobuf:"bytes,4,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
	NewTicketInterval *NewTicketInterval         `protobuf:"bytes,5,opt,name=new_ticket_interval,json=newTicketInterval" json:"new_ticket_interval,omitempty"`
}

func (m *CreateChatNotificationTokenRequest) Reset()         { *m = CreateChatNotificationTokenRequest{} }
func (m *CreateChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*CreateChatNotificationTokenRequest) ProtoMessage()    {}
func (*CreateChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{89}
}

func (m *CreateChatNotificationTokenRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateChatNotificationTokenRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateChatNotificationTokenRequest) GetAvailableAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.AvailableAt
	}
	return nil
}

func (m *CreateChatNotificationTokenRequest) GetIsPrime() *OptionalBool {
	if m != nil {
		return m.IsPrime
	}
	return nil
}

func (m *CreateChatNotificationTokenRequest) GetNewTicketInterval() *NewTicketInterval {
	if m != nil {
		return m.NewTicketInterval
	}
	return nil
}

type CreateChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *CreateChatNotificationTokenResponse) Reset()         { *m = CreateChatNotificationTokenResponse{} }
func (m *CreateChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*CreateChatNotificationTokenResponse) ProtoMessage()    {}
func (*CreateChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{90}
}

func (m *CreateChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type NewTicketInterval struct {
	AccessStart *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=access_start,json=accessStart" json:"access_start,omitempty"`
	AccessEnd   *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=access_end,json=accessEnd" json:"access_end,omitempty"`
}

func (m *NewTicketInterval) Reset()                    { *m = NewTicketInterval{} }
func (m *NewTicketInterval) String() string            { return proto.CompactTextString(m) }
func (*NewTicketInterval) ProtoMessage()               {}
func (*NewTicketInterval) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{91} }

func (m *NewTicketInterval) GetAccessStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.AccessStart
	}
	return nil
}

func (m *NewTicketInterval) GetAccessEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.AccessEnd
	}
	return nil
}

// Example Body for UseChatNotificationTokenRequest:
// {
// 	    "token_id": "29386024", which token do we want to use?
//      "authed_user_id": "834",   the id of the authed user calling this endpoint
//      "custom_message": "im a custom message", do we want to post a custom message?
// }
type UseChatNotificationTokenRequest struct {
	TokenId                    string        `protobuf:"bytes,1,opt,name=token_id,json=tokenId" json:"token_id,omitempty"`
	AuthedUserId               string        `protobuf:"bytes,2,opt,name=authed_user_id,json=authedUserId" json:"authed_user_id,omitempty"`
	CustomMessage              string        `protobuf:"bytes,3,opt,name=custom_message,json=customMessage" json:"custom_message,omitempty"`
	ShareStreak                *OptionalBool `protobuf:"bytes,4,opt,name=share_streak,json=shareStreak" json:"share_streak,omitempty"`
	ChannelId                  string        `protobuf:"bytes,5,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	IsCumulativeTenureLoadTest bool          `protobuf:"varint,6,opt,name=is_cumulative_tenure_load_test,json=isCumulativeTenureLoadTest" json:"is_cumulative_tenure_load_test,omitempty"`
}

func (m *UseChatNotificationTokenRequest) Reset()         { *m = UseChatNotificationTokenRequest{} }
func (m *UseChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*UseChatNotificationTokenRequest) ProtoMessage()    {}
func (*UseChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{92}
}

func (m *UseChatNotificationTokenRequest) GetTokenId() string {
	if m != nil {
		return m.TokenId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetAuthedUserId() string {
	if m != nil {
		return m.AuthedUserId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetCustomMessage() string {
	if m != nil {
		return m.CustomMessage
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetShareStreak() *OptionalBool {
	if m != nil {
		return m.ShareStreak
	}
	return nil
}

func (m *UseChatNotificationTokenRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetIsCumulativeTenureLoadTest() bool {
	if m != nil {
		return m.IsCumulativeTenureLoadTest
	}
	return false
}

type UseChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *UseChatNotificationTokenResponse) Reset()         { *m = UseChatNotificationTokenResponse{} }
func (m *UseChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*UseChatNotificationTokenResponse) ProtoMessage()    {}
func (*UseChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{93}
}

func (m *UseChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type CancelChatNotificationTokenRequest struct {
	SubscriptionId string `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
}

func (m *CancelChatNotificationTokenRequest) Reset()         { *m = CancelChatNotificationTokenRequest{} }
func (m *CancelChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*CancelChatNotificationTokenRequest) ProtoMessage()    {}
func (*CancelChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{94}
}

func (m *CancelChatNotificationTokenRequest) GetSubscriptionId() string {
	if m != nil {
		return m.SubscriptionId
	}
	return ""
}

type CancelChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *CancelChatNotificationTokenResponse) Reset()         { *m = CancelChatNotificationTokenResponse{} }
func (m *CancelChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*CancelChatNotificationTokenResponse) ProtoMessage()    {}
func (*CancelChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{95}
}

func (m *CancelChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type GetUserChannelChatNotificationTokenRequest struct {
	UserId                     string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId                  string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	IsCumulativeTenureLoadTest bool   `protobuf:"varint,3,opt,name=is_cumulative_tenure_load_test,json=isCumulativeTenureLoadTest" json:"is_cumulative_tenure_load_test,omitempty"`
}

func (m *GetUserChannelChatNotificationTokenRequest) Reset() {
	*m = GetUserChannelChatNotificationTokenRequest{}
}
func (m *GetUserChannelChatNotificationTokenRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelChatNotificationTokenRequest) ProtoMessage() {}
func (*GetUserChannelChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{96}
}

func (m *GetUserChannelChatNotificationTokenRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetUserChannelChatNotificationTokenRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetUserChannelChatNotificationTokenRequest) GetIsCumulativeTenureLoadTest() bool {
	if m != nil {
		return m.IsCumulativeTenureLoadTest
	}
	return false
}

type GetUserChannelChatNotificationTokenResponse struct {
	ChatNotificationToken *ChatNotificationToken `protobuf:"bytes,1,opt,name=chat_notification_token,json=chatNotificationToken" json:"chat_notification_token,omitempty"`
}

func (m *GetUserChannelChatNotificationTokenResponse) Reset() {
	*m = GetUserChannelChatNotificationTokenResponse{}
}
func (m *GetUserChannelChatNotificationTokenResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelChatNotificationTokenResponse) ProtoMessage() {}
func (*GetUserChannelChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{97}
}

func (m *GetUserChannelChatNotificationTokenResponse) GetChatNotificationToken() *ChatNotificationToken {
	if m != nil {
		return m.ChatNotificationToken
	}
	return nil
}

type GetAllUsedChatNotificationTokensRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetAllUsedChatNotificationTokensRequest) Reset() {
	*m = GetAllUsedChatNotificationTokensRequest{}
}
func (m *GetAllUsedChatNotificationTokensRequest) String() string { return proto.CompactTextString(m) }
func (*GetAllUsedChatNotificationTokensRequest) ProtoMessage()    {}
func (*GetAllUsedChatNotificationTokensRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{98}
}

func (m *GetAllUsedChatNotificationTokensRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetAllUsedChatNotificationTokensRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetAllUsedChatNotificationTokensResponse struct {
	UsedChatTokens []*UsedChatNotificationTokenItem `protobuf:"bytes,1,rep,name=used_chat_tokens,json=usedChatTokens" json:"used_chat_tokens,omitempty"`
}

func (m *GetAllUsedChatNotificationTokensResponse) Reset() {
	*m = GetAllUsedChatNotificationTokensResponse{}
}
func (m *GetAllUsedChatNotificationTokensResponse) String() string { return proto.CompactTextString(m) }
func (*GetAllUsedChatNotificationTokensResponse) ProtoMessage()    {}
func (*GetAllUsedChatNotificationTokensResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{99}
}

func (m *GetAllUsedChatNotificationTokensResponse) GetUsedChatTokens() []*UsedChatNotificationTokenItem {
	if m != nil {
		return m.UsedChatTokens
	}
	return nil
}

type AllowReplayForLastUsedChatNotificationTokenRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Tenure    string `protobuf:"bytes,3,opt,name=tenure" json:"tenure,omitempty"`
	Method    string `protobuf:"bytes,4,opt,name=method" json:"method,omitempty"`
}

func (m *AllowReplayForLastUsedChatNotificationTokenRequest) Reset() {
	*m = AllowReplayForLastUsedChatNotificationTokenRequest{}
}
func (m *AllowReplayForLastUsedChatNotificationTokenRequest) String() string {
	return proto.CompactTextString(m)
}
func (*AllowReplayForLastUsedChatNotificationTokenRequest) ProtoMessage() {}
func (*AllowReplayForLastUsedChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{100}
}

func (m *AllowReplayForLastUsedChatNotificationTokenRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *AllowReplayForLastUsedChatNotificationTokenRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *AllowReplayForLastUsedChatNotificationTokenRequest) GetTenure() string {
	if m != nil {
		return m.Tenure
	}
	return ""
}

func (m *AllowReplayForLastUsedChatNotificationTokenRequest) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

type AllowReplayForLastUsedChatNotificationTokenResponse struct {
}

func (m *AllowReplayForLastUsedChatNotificationTokenResponse) Reset() {
	*m = AllowReplayForLastUsedChatNotificationTokenResponse{}
}
func (m *AllowReplayForLastUsedChatNotificationTokenResponse) String() string {
	return proto.CompactTextString(m)
}
func (*AllowReplayForLastUsedChatNotificationTokenResponse) ProtoMessage() {}
func (*AllowReplayForLastUsedChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{101}
}

type ChatNotificationToken struct {
	Id                    string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Message               string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	Month                 string `protobuf:"bytes,3,opt,name=month" json:"month,omitempty"`
	Kind                  string `protobuf:"bytes,4,opt,name=kind" json:"kind,omitempty"`
	CumulativeTenureMonth int32  `protobuf:"varint,5,opt,name=cumulative_tenure_month,json=cumulativeTenureMonth" json:"cumulative_tenure_month,omitempty"`
	StreakTenureMonth     int32  `protobuf:"varint,6,opt,name=streak_tenure_month,json=streakTenureMonth" json:"streak_tenure_month,omitempty"`
}

func (m *ChatNotificationToken) Reset()                    { *m = ChatNotificationToken{} }
func (m *ChatNotificationToken) String() string            { return proto.CompactTextString(m) }
func (*ChatNotificationToken) ProtoMessage()               {}
func (*ChatNotificationToken) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{102} }

func (m *ChatNotificationToken) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ChatNotificationToken) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ChatNotificationToken) GetMonth() string {
	if m != nil {
		return m.Month
	}
	return ""
}

func (m *ChatNotificationToken) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *ChatNotificationToken) GetCumulativeTenureMonth() int32 {
	if m != nil {
		return m.CumulativeTenureMonth
	}
	return 0
}

func (m *ChatNotificationToken) GetStreakTenureMonth() int32 {
	if m != nil {
		return m.StreakTenureMonth
	}
	return 0
}

type UsedChatNotificationTokenItem struct {
	Owner               string                     `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Channel             string                     `protobuf:"bytes,2,opt,name=channel" json:"channel,omitempty"`
	Tenure              string                     `protobuf:"bytes,3,opt,name=tenure" json:"tenure,omitempty"`
	Method              string                     `protobuf:"bytes,4,opt,name=method" json:"method,omitempty"`
	StreakShared        bool                       `protobuf:"varint,5,opt,name=streak_shared,json=streakShared" json:"streak_shared,omitempty"`
	StreakValue         int32                      `protobuf:"varint,6,opt,name=streak_value,json=streakValue" json:"streak_value,omitempty"`
	CustomMessageText   string                     `protobuf:"bytes,7,opt,name=custom_message_text,json=customMessageText" json:"custom_message_text,omitempty"`
	CustomMessageShared bool                       `protobuf:"varint,8,opt,name=custom_message_shared,json=customMessageShared" json:"custom_message_shared,omitempty"`
	Product             string                     `protobuf:"bytes,9,opt,name=product" json:"product,omitempty"`
	Tier                string                     `protobuf:"bytes,10,opt,name=tier" json:"tier,omitempty"`
	IsPrime             bool                       `protobuf:"varint,11,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
	AllowReplay         bool                       `protobuf:"varint,12,opt,name=allow_replay,json=allowReplay" json:"allow_replay,omitempty"`
	CreatedAt           *google_protobuf.Timestamp `protobuf:"bytes,13,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	UpdatedAt           *google_protobuf.Timestamp `protobuf:"bytes,14,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
}

func (m *UsedChatNotificationTokenItem) Reset()                    { *m = UsedChatNotificationTokenItem{} }
func (m *UsedChatNotificationTokenItem) String() string            { return proto.CompactTextString(m) }
func (*UsedChatNotificationTokenItem) ProtoMessage()               {}
func (*UsedChatNotificationTokenItem) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{103} }

func (m *UsedChatNotificationTokenItem) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetTenure() string {
	if m != nil {
		return m.Tenure
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetStreakShared() bool {
	if m != nil {
		return m.StreakShared
	}
	return false
}

func (m *UsedChatNotificationTokenItem) GetStreakValue() int32 {
	if m != nil {
		return m.StreakValue
	}
	return 0
}

func (m *UsedChatNotificationTokenItem) GetCustomMessageText() string {
	if m != nil {
		return m.CustomMessageText
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetCustomMessageShared() bool {
	if m != nil {
		return m.CustomMessageShared
	}
	return false
}

func (m *UsedChatNotificationTokenItem) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *UsedChatNotificationTokenItem) GetIsPrime() bool {
	if m != nil {
		return m.IsPrime
	}
	return false
}

func (m *UsedChatNotificationTokenItem) GetAllowReplay() bool {
	if m != nil {
		return m.AllowReplay
	}
	return false
}

func (m *UsedChatNotificationTokenItem) GetCreatedAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *UsedChatNotificationTokenItem) GetUpdatedAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

// Gifts
// ======
type Gift struct {
	Sender    string                     `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string                     `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string                     `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string                     `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
	State     GiftState                  `protobuf:"varint,5,opt,name=state,enum=code.justin.tv.revenue.subscriptions.GiftState" json:"state,omitempty"`
	GiftDate  *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=gift_date,json=giftDate" json:"gift_date,omitempty"`
	GiftType  GiftType                   `protobuf:"varint,7,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	AnonGift  bool                       `protobuf:"varint,8,opt,name=anon_gift,json=anonGift" json:"anon_gift,omitempty"`
}

func (m *Gift) Reset()                    { *m = Gift{} }
func (m *Gift) String() string            { return proto.CompactTextString(m) }
func (*Gift) ProtoMessage()               {}
func (*Gift) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{104} }

func (m *Gift) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *Gift) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *Gift) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *Gift) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *Gift) GetState() GiftState {
	if m != nil {
		return m.State
	}
	return GiftState_GIFT_NONE
}

func (m *Gift) GetGiftDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.GiftDate
	}
	return nil
}

func (m *Gift) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *Gift) GetAnonGift() bool {
	if m != nil {
		return m.AnonGift
	}
	return false
}

// GiftKey is used to identify gifts using product, origin, owner (receiver), domain.
// This is convention from HATS so that consumers don't need to store extra information.
// Product, owner, origin, domain (POOD) is used as a hash key in the gifts dynamo table
// for blazing fast lookups.
type GiftKey struct {
	Product   string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,2,opt,name=origin" json:"origin,omitempty"`
	Recipient string `protobuf:"bytes,3,opt,name=recipient" json:"recipient,omitempty"`
}

func (m *GiftKey) Reset()                    { *m = GiftKey{} }
func (m *GiftKey) String() string            { return proto.CompactTextString(m) }
func (*GiftKey) ProtoMessage()               {}
func (*GiftKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{105} }

func (m *GiftKey) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *GiftKey) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *GiftKey) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

// InsertGiftRequest is the body of a InsertGift rpc request.
type InsertGiftRequest struct {
	Sender    string   `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string   `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string   `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string   `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
	GiftType  GiftType `protobuf:"varint,5,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	AnonGift  bool     `protobuf:"varint,6,opt,name=anon_gift,json=anonGift" json:"anon_gift,omitempty"`
}

func (m *InsertGiftRequest) Reset()                    { *m = InsertGiftRequest{} }
func (m *InsertGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*InsertGiftRequest) ProtoMessage()               {}
func (*InsertGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{106} }

func (m *InsertGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *InsertGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *InsertGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *InsertGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *InsertGiftRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *InsertGiftRequest) GetAnonGift() bool {
	if m != nil {
		return m.AnonGift
	}
	return false
}

// CreateGiftResponse is the response to a CreateGift rpc request.
type InsertGiftResponse struct {
	Gift *Gift `protobuf:"bytes,1,opt,name=gift" json:"gift,omitempty"`
}

func (m *InsertGiftResponse) Reset()                    { *m = InsertGiftResponse{} }
func (m *InsertGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*InsertGiftResponse) ProtoMessage()               {}
func (*InsertGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{107} }

func (m *InsertGiftResponse) GetGift() *Gift {
	if m != nil {
		return m.Gift
	}
	return nil
}

// CancelGiftRequest is the body of a CancelGift rpc request.
type CancelGiftRequest struct {
	Product   string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,2,opt,name=origin" json:"origin,omitempty"`
	Recipient string `protobuf:"bytes,3,opt,name=recipient" json:"recipient,omitempty"`
}

func (m *CancelGiftRequest) Reset()                    { *m = CancelGiftRequest{} }
func (m *CancelGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelGiftRequest) ProtoMessage()               {}
func (*CancelGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{108} }

func (m *CancelGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *CancelGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *CancelGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

// CancelGiftResponse is the response of a CancelGift rpc request.
type CancelGiftResponse struct {
	CanceledGift *Gift `protobuf:"bytes,1,opt,name=canceled_gift,json=canceledGift" json:"canceled_gift,omitempty"`
}

func (m *CancelGiftResponse) Reset()                    { *m = CancelGiftResponse{} }
func (m *CancelGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelGiftResponse) ProtoMessage()               {}
func (*CancelGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{109} }

func (m *CancelGiftResponse) GetCanceledGift() *Gift {
	if m != nil {
		return m.CanceledGift
	}
	return nil
}

// GetGifts
type GetGiftsRequest struct {
	Keys []*GiftKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetGiftsRequest) Reset()                    { *m = GetGiftsRequest{} }
func (m *GetGiftsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftsRequest) ProtoMessage()               {}
func (*GetGiftsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{110} }

func (m *GetGiftsRequest) GetKeys() []*GiftKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

type GetGiftsResponse struct {
	Gifts []*Gift `protobuf:"bytes,1,rep,name=gifts" json:"gifts,omitempty"`
}

func (m *GetGiftsResponse) Reset()                    { *m = GetGiftsResponse{} }
func (m *GetGiftsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftsResponse) ProtoMessage()               {}
func (*GetGiftsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{111} }

func (m *GetGiftsResponse) GetGifts() []*Gift {
	if m != nil {
		return m.Gifts
	}
	return nil
}

// CanGift
type CanGiftRequest struct {
	Sender    string `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
}

func (m *CanGiftRequest) Reset()                    { *m = CanGiftRequest{} }
func (m *CanGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRequest) ProtoMessage()               {}
func (*CanGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{112} }

func (m *CanGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *CanGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *CanGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

type CanGiftResponse struct {
	CanGift bool `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
}

func (m *CanGiftResponse) Reset()                    { *m = CanGiftResponse{} }
func (m *CanGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CanGiftResponse) ProtoMessage()               {}
func (*CanGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{113} }

func (m *CanGiftResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

// CanSenderGift
type CanSenderGiftRequest struct {
	SenderId     string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId    string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	GiftQuantity int32  `protobuf:"varint,3,opt,name=gift_quantity,json=giftQuantity" json:"gift_quantity,omitempty"`
}

func (m *CanSenderGiftRequest) Reset()                    { *m = CanSenderGiftRequest{} }
func (m *CanSenderGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CanSenderGiftRequest) ProtoMessage()               {}
func (*CanSenderGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{114} }

func (m *CanSenderGiftRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *CanSenderGiftRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CanSenderGiftRequest) GetGiftQuantity() int32 {
	if m != nil {
		return m.GiftQuantity
	}
	return 0
}

type CanSenderGiftResponse struct {
	CanGift bool `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
}

func (m *CanSenderGiftResponse) Reset()                    { *m = CanSenderGiftResponse{} }
func (m *CanSenderGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CanSenderGiftResponse) ProtoMessage()               {}
func (*CanSenderGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{115} }

func (m *CanSenderGiftResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

// CanGiftRecipient
type CanGiftRecipientRequest struct {
	SenderId    string   `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId   string   `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	RecipientId string   `protobuf:"bytes,3,opt,name=recipient_id,json=recipientId" json:"recipient_id,omitempty"`
	GiftType    GiftType `protobuf:"varint,4,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
}

func (m *CanGiftRecipientRequest) Reset()                    { *m = CanGiftRecipientRequest{} }
func (m *CanGiftRecipientRequest) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRecipientRequest) ProtoMessage()               {}
func (*CanGiftRecipientRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{116} }

func (m *CanGiftRecipientRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *CanGiftRecipientRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CanGiftRecipientRequest) GetRecipientId() string {
	if m != nil {
		return m.RecipientId
	}
	return ""
}

func (m *CanGiftRecipientRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

type CanGiftRecipientResponse struct {
	CanGift bool   `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
	Reason  string `protobuf:"bytes,2,opt,name=reason" json:"reason,omitempty"`
}

func (m *CanGiftRecipientResponse) Reset()                    { *m = CanGiftRecipientResponse{} }
func (m *CanGiftRecipientResponse) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRecipientResponse) ProtoMessage()               {}
func (*CanGiftRecipientResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{117} }

func (m *CanGiftRecipientResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

func (m *CanGiftRecipientResponse) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

// Uniquely identifies a gift offer by the product, gift type and quantity
type GiftOfferId struct {
	Product  string   `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	GiftType GiftType `protobuf:"varint,2,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	Quantity int32    `protobuf:"varint,3,opt,name=quantity" json:"quantity,omitempty"`
}

func (m *GiftOfferId) Reset()                    { *m = GiftOfferId{} }
func (m *GiftOfferId) String() string            { return proto.CompactTextString(m) }
func (*GiftOfferId) ProtoMessage()               {}
func (*GiftOfferId) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{118} }

func (m *GiftOfferId) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *GiftOfferId) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *GiftOfferId) GetQuantity() int32 {
	if m != nil {
		return m.Quantity
	}
	return 0
}

// GiftPromotion describes the promotion on a subscription product.
type GiftPromotion struct {
	ProductId     string       `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	NewPrice      int64        `protobuf:"varint,2,opt,name=new_price,json=newPrice" json:"new_price,omitempty"`
	OldPrice      int64        `protobuf:"varint,3,opt,name=old_price,json=oldPrice" json:"old_price,omitempty"`
	DiscountType  DiscountType `protobuf:"varint,4,opt,name=discount_type,json=discountType,enum=code.justin.tv.revenue.subscriptions.DiscountType" json:"discount_type,omitempty"`
	DiscountValue int64        `protobuf:"varint,5,opt,name=discount_value,json=discountValue" json:"discount_value,omitempty"`
	Error         string       `protobuf:"bytes,6,opt,name=error" json:"error,omitempty"`
	ThirdPartySku string       `protobuf:"bytes,7,opt,name=third_party_sku,json=thirdPartySku" json:"third_party_sku,omitempty"`
	NewQuantity   int32        `protobuf:"varint,8,opt,name=new_quantity,json=newQuantity" json:"new_quantity,omitempty"`
	OldQuantity   int32        `protobuf:"varint,9,opt,name=old_quantity,json=oldQuantity" json:"old_quantity,omitempty"`
	GiftOfferId   *GiftOfferId `protobuf:"bytes,10,opt,name=gift_offer_id,json=giftOfferId" json:"gift_offer_id,omitempty"`
}

func (m *GiftPromotion) Reset()                    { *m = GiftPromotion{} }
func (m *GiftPromotion) String() string            { return proto.CompactTextString(m) }
func (*GiftPromotion) ProtoMessage()               {}
func (*GiftPromotion) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{119} }

func (m *GiftPromotion) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GiftPromotion) GetNewPrice() int64 {
	if m != nil {
		return m.NewPrice
	}
	return 0
}

func (m *GiftPromotion) GetOldPrice() int64 {
	if m != nil {
		return m.OldPrice
	}
	return 0
}

func (m *GiftPromotion) GetDiscountType() DiscountType {
	if m != nil {
		return m.DiscountType
	}
	return DiscountType_DISCOUNT_NONE
}

func (m *GiftPromotion) GetDiscountValue() int64 {
	if m != nil {
		return m.DiscountValue
	}
	return 0
}

func (m *GiftPromotion) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *GiftPromotion) GetThirdPartySku() string {
	if m != nil {
		return m.ThirdPartySku
	}
	return ""
}

func (m *GiftPromotion) GetNewQuantity() int32 {
	if m != nil {
		return m.NewQuantity
	}
	return 0
}

func (m *GiftPromotion) GetOldQuantity() int32 {
	if m != nil {
		return m.OldQuantity
	}
	return 0
}

func (m *GiftPromotion) GetGiftOfferId() *GiftOfferId {
	if m != nil {
		return m.GiftOfferId
	}
	return nil
}

// Promotion describes the promotion on a subscription product.
// Generic Promotion object to use for promos moving forward
type Promotion struct {
	ProductId     string       `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	NewPrice      int64        `protobuf:"varint,2,opt,name=new_price,json=newPrice" json:"new_price,omitempty"`
	OldPrice      int64        `protobuf:"varint,3,opt,name=old_price,json=oldPrice" json:"old_price,omitempty"`
	DiscountType  DiscountType `protobuf:"varint,4,opt,name=discount_type,json=discountType,enum=code.justin.tv.revenue.subscriptions.DiscountType" json:"discount_type,omitempty"`
	DiscountValue int64        `protobuf:"varint,5,opt,name=discount_value,json=discountValue" json:"discount_value,omitempty"`
	Error         string       `protobuf:"bytes,6,opt,name=error" json:"error,omitempty"`
}

func (m *Promotion) Reset()                    { *m = Promotion{} }
func (m *Promotion) String() string            { return proto.CompactTextString(m) }
func (*Promotion) ProtoMessage()               {}
func (*Promotion) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{120} }

func (m *Promotion) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *Promotion) GetNewPrice() int64 {
	if m != nil {
		return m.NewPrice
	}
	return 0
}

func (m *Promotion) GetOldPrice() int64 {
	if m != nil {
		return m.OldPrice
	}
	return 0
}

func (m *Promotion) GetDiscountType() DiscountType {
	if m != nil {
		return m.DiscountType
	}
	return DiscountType_DISCOUNT_NONE
}

func (m *Promotion) GetDiscountValue() int64 {
	if m != nil {
		return m.DiscountValue
	}
	return 0
}

func (m *Promotion) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// GetGiftPromotionRequest describes the request of GetGiftPromotion.
type GetGiftPromotionRequest struct {
	ProductIds   []string       `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
	UserId       string         `protobuf:"bytes,2,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	Platform     Platform       `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	GiftOfferIds []*GiftOfferId `protobuf:"bytes,4,rep,name=gift_offer_ids,json=giftOfferIds" json:"gift_offer_ids,omitempty"`
}

func (m *GetGiftPromotionRequest) Reset()                    { *m = GetGiftPromotionRequest{} }
func (m *GetGiftPromotionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftPromotionRequest) ProtoMessage()               {}
func (*GetGiftPromotionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{121} }

func (m *GetGiftPromotionRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

func (m *GetGiftPromotionRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetGiftPromotionRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetGiftPromotionRequest) GetGiftOfferIds() []*GiftOfferId {
	if m != nil {
		return m.GiftOfferIds
	}
	return nil
}

// GetGiftPromotionResponse describes the response of GetGiftPromotion.
type GetGiftPromotionResponse struct {
	IsPromotionActive bool             `protobuf:"varint,1,opt,name=is_promotion_active,json=isPromotionActive" json:"is_promotion_active,omitempty"`
	GiftPromotions    []*GiftPromotion `protobuf:"bytes,2,rep,name=gift_promotions,json=giftPromotions" json:"gift_promotions,omitempty"`
}

func (m *GetGiftPromotionResponse) Reset()                    { *m = GetGiftPromotionResponse{} }
func (m *GetGiftPromotionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftPromotionResponse) ProtoMessage()               {}
func (*GetGiftPromotionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{122} }

func (m *GetGiftPromotionResponse) GetIsPromotionActive() bool {
	if m != nil {
		return m.IsPromotionActive
	}
	return false
}

func (m *GetGiftPromotionResponse) GetGiftPromotions() []*GiftPromotion {
	if m != nil {
		return m.GiftPromotions
	}
	return nil
}

// GetPaidUpgradePromotionRequest describes the request of GetPaidUpgradePromotion
type GetPaidUpgradePromotionRequest struct {
	UserId     string   `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ProductIds []string `protobuf:"bytes,2,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetPaidUpgradePromotionRequest) Reset()         { *m = GetPaidUpgradePromotionRequest{} }
func (m *GetPaidUpgradePromotionRequest) String() string { return proto.CompactTextString(m) }
func (*GetPaidUpgradePromotionRequest) ProtoMessage()    {}
func (*GetPaidUpgradePromotionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{123}
}

func (m *GetPaidUpgradePromotionRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetPaidUpgradePromotionRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

// GetPaidUpgradePromotionResponse describes the response of GetPaidUpgradePromotion
type GetPaidUpgradePromotionResponse struct {
	Promotions []*Promotion `protobuf:"bytes,2,rep,name=promotions" json:"promotions,omitempty"`
}

func (m *GetPaidUpgradePromotionResponse) Reset()         { *m = GetPaidUpgradePromotionResponse{} }
func (m *GetPaidUpgradePromotionResponse) String() string { return proto.CompactTextString(m) }
func (*GetPaidUpgradePromotionResponse) ProtoMessage()    {}
func (*GetPaidUpgradePromotionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{124}
}

func (m *GetPaidUpgradePromotionResponse) GetPromotions() []*Promotion {
	if m != nil {
		return m.Promotions
	}
	return nil
}

// FulfillGiftsRequest is the body of FulfillGifts rpc request.
type FulfillGiftsRequest struct {
	SenderId     string                     `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	GiftType     GiftType                   `protobuf:"varint,4,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	GiftQuantity int32                      `protobuf:"varint,5,opt,name=gift_quantity,json=giftQuantity" json:"gift_quantity,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,7,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	RecipientIds []string                   `protobuf:"bytes,8,rep,name=recipient_ids,json=recipientIds" json:"recipient_ids,omitempty"`
	AnonGift     bool                       `protobuf:"varint,9,opt,name=anon_gift,json=anonGift" json:"anon_gift,omitempty"`
	SkuId        string                     `protobuf:"bytes,10,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
	Platform     Platform                   `protobuf:"varint,11,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
}

func (m *FulfillGiftsRequest) Reset()                    { *m = FulfillGiftsRequest{} }
func (m *FulfillGiftsRequest) String() string            { return proto.CompactTextString(m) }
func (*FulfillGiftsRequest) ProtoMessage()               {}
func (*FulfillGiftsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{125} }

func (m *FulfillGiftsRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *FulfillGiftsRequest) GetGiftQuantity() int32 {
	if m != nil {
		return m.GiftQuantity
	}
	return 0
}

func (m *FulfillGiftsRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *FulfillGiftsRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *FulfillGiftsRequest) GetRecipientIds() []string {
	if m != nil {
		return m.RecipientIds
	}
	return nil
}

func (m *FulfillGiftsRequest) GetAnonGift() bool {
	if m != nil {
		return m.AnonGift
	}
	return false
}

func (m *FulfillGiftsRequest) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

func (m *FulfillGiftsRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

// FulFillGiftsResponse is an empty response. If subscriptions service can not fulfill this error, it will return appropriate error.
// Error codes:
// 1. InvalidArgumentError : If request is invalid
// 2. FailedPrecondition: If one of the eligibility pre-condition is not true.
// 3. InternalError: If there was an internal server error fulfilling the gift request.
type FulfillGiftsResponse struct {
}

func (m *FulfillGiftsResponse) Reset()                    { *m = FulfillGiftsResponse{} }
func (m *FulfillGiftsResponse) String() string            { return proto.CompactTextString(m) }
func (*FulfillGiftsResponse) ProtoMessage()               {}
func (*FulfillGiftsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{126} }

// SendGiftChatNotificationRequest is the body of the SendGiftChatNotification rpc request.
type SendGiftChatNotificationRequest struct {
	SenderId    string   `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	RecipientId string   `protobuf:"bytes,2,opt,name=recipient_id,json=recipientId" json:"recipient_id,omitempty"`
	ProductId   string   `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	ChannelId   string   `protobuf:"bytes,4,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	AnonGift    bool     `protobuf:"varint,5,opt,name=anon_gift,json=anonGift" json:"anon_gift,omitempty"`
	GiftType    GiftType `protobuf:"varint,6,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	OriginId    string   `protobuf:"bytes,7,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
}

func (m *SendGiftChatNotificationRequest) Reset()         { *m = SendGiftChatNotificationRequest{} }
func (m *SendGiftChatNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*SendGiftChatNotificationRequest) ProtoMessage()    {}
func (*SendGiftChatNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{127}
}

func (m *SendGiftChatNotificationRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *SendGiftChatNotificationRequest) GetRecipientId() string {
	if m != nil {
		return m.RecipientId
	}
	return ""
}

func (m *SendGiftChatNotificationRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *SendGiftChatNotificationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SendGiftChatNotificationRequest) GetAnonGift() bool {
	if m != nil {
		return m.AnonGift
	}
	return false
}

func (m *SendGiftChatNotificationRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *SendGiftChatNotificationRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

// SendGiftChatNotificationResponse is an empty response
type SendGiftChatNotificationResponse struct {
}

func (m *SendGiftChatNotificationResponse) Reset()         { *m = SendGiftChatNotificationResponse{} }
func (m *SendGiftChatNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*SendGiftChatNotificationResponse) ProtoMessage()    {}
func (*SendGiftChatNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{128}
}

// SendMMGChatNotificationRequest is the body of the SendMMGChatNotification rpc request.
type SendMMGChatNotificationRequest struct {
	SenderId    string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	RecipientId string `protobuf:"bytes,2,opt,name=recipient_id,json=recipientId" json:"recipient_id,omitempty"`
	ProductId   string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	ChannelId   string `protobuf:"bytes,4,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	OriginId    string `protobuf:"bytes,5,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
}

func (m *SendMMGChatNotificationRequest) Reset()         { *m = SendMMGChatNotificationRequest{} }
func (m *SendMMGChatNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*SendMMGChatNotificationRequest) ProtoMessage()    {}
func (*SendMMGChatNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{129}
}

func (m *SendMMGChatNotificationRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetRecipientId() string {
	if m != nil {
		return m.RecipientId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SendMMGChatNotificationRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

// SendMMGChatNotificationResponse is an empty response
type SendMMGChatNotificationResponse struct {
}

func (m *SendMMGChatNotificationResponse) Reset()         { *m = SendMMGChatNotificationResponse{} }
func (m *SendMMGChatNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*SendMMGChatNotificationResponse) ProtoMessage()    {}
func (*SendMMGChatNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{130}
}

// SendMMGStartChatNotificationRequest is the body of the SendMMGStartChatNotification rpc request.
type SendMMGStartChatNotificationRequest struct {
	SenderId     string `protobuf:"bytes,1,opt,name=sender_id,json=senderId" json:"sender_id,omitempty"`
	ProductId    string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	ChannelId    string `protobuf:"bytes,3,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	GiftQuantity int32  `protobuf:"varint,4,opt,name=gift_quantity,json=giftQuantity" json:"gift_quantity,omitempty"`
	AnonGift     bool   `protobuf:"varint,5,opt,name=anon_gift,json=anonGift" json:"anon_gift,omitempty"`
	OriginId     string `protobuf:"bytes,6,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
}

func (m *SendMMGStartChatNotificationRequest) Reset()         { *m = SendMMGStartChatNotificationRequest{} }
func (m *SendMMGStartChatNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*SendMMGStartChatNotificationRequest) ProtoMessage()    {}
func (*SendMMGStartChatNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{131}
}

func (m *SendMMGStartChatNotificationRequest) GetSenderId() string {
	if m != nil {
		return m.SenderId
	}
	return ""
}

func (m *SendMMGStartChatNotificationRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *SendMMGStartChatNotificationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SendMMGStartChatNotificationRequest) GetGiftQuantity() int32 {
	if m != nil {
		return m.GiftQuantity
	}
	return 0
}

func (m *SendMMGStartChatNotificationRequest) GetAnonGift() bool {
	if m != nil {
		return m.AnonGift
	}
	return false
}

func (m *SendMMGStartChatNotificationRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

// SendMMGStartChatNotificationRequest is an empty response
type SendMMGStartChatNotificationResponse struct {
}

func (m *SendMMGStartChatNotificationResponse) Reset()         { *m = SendMMGStartChatNotificationResponse{} }
func (m *SendMMGStartChatNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*SendMMGStartChatNotificationResponse) ProtoMessage()    {}
func (*SendMMGStartChatNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{132}
}

type GiftOffer struct {
	GiftType GiftType `protobuf:"varint,1,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	SkuId    string   `protobuf:"bytes,2,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
	Quantity int32    `protobuf:"varint,3,opt,name=quantity" json:"quantity,omitempty"`
}

func (m *GiftOffer) Reset()                    { *m = GiftOffer{} }
func (m *GiftOffer) String() string            { return proto.CompactTextString(m) }
func (*GiftOffer) ProtoMessage()               {}
func (*GiftOffer) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{133} }

func (m *GiftOffer) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *GiftOffer) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

func (m *GiftOffer) GetQuantity() int32 {
	if m != nil {
		return m.Quantity
	}
	return 0
}

type GetGiftOffersRequest struct {
	GiftType    GiftType `protobuf:"varint,1,opt,name=gift_type,json=giftType,enum=code.justin.tv.revenue.subscriptions.GiftType" json:"gift_type,omitempty"`
	Platform    Platform `protobuf:"varint,2,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,3,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
	ProductId   string   `protobuf:"bytes,4,opt,name=product_id,json=productId" json:"product_id,omitempty"`
}

func (m *GetGiftOffersRequest) Reset()                    { *m = GetGiftOffersRequest{} }
func (m *GetGiftOffersRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftOffersRequest) ProtoMessage()               {}
func (*GetGiftOffersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{134} }

func (m *GetGiftOffersRequest) GetGiftType() GiftType {
	if m != nil {
		return m.GiftType
	}
	return GiftType_GIFT_TYPE_NONE
}

func (m *GetGiftOffersRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetGiftOffersRequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

func (m *GetGiftOffersRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

type GetGiftOffersResponse struct {
	GiftOffers []*GiftOffer `protobuf:"bytes,1,rep,name=gift_offers,json=giftOffers" json:"gift_offers,omitempty"`
}

func (m *GetGiftOffersResponse) Reset()                    { *m = GetGiftOffersResponse{} }
func (m *GetGiftOffersResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftOffersResponse) ProtoMessage()               {}
func (*GetGiftOffersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{135} }

func (m *GetGiftOffersResponse) GetGiftOffers() []*GiftOffer {
	if m != nil {
		return m.GiftOffers
	}
	return nil
}

// GetRelatedChannelsRequest is the body of the GetRelatedChannels rpc request
type GetRelatedChannelsRequest struct {
	ProductId string `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
}

func (m *GetRelatedChannelsRequest) Reset()                    { *m = GetRelatedChannelsRequest{} }
func (m *GetRelatedChannelsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRelatedChannelsRequest) ProtoMessage()               {}
func (*GetRelatedChannelsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{136} }

func (m *GetRelatedChannelsRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

// GetRelatedChannelsResponse is the body of the GetRelatedChannels rpc response
type GetRelatedChannelsResponse struct {
	ChannelIds []string `protobuf:"bytes,1,rep,name=channel_ids,json=channelIds" json:"channel_ids,omitempty"`
}

func (m *GetRelatedChannelsResponse) Reset()                    { *m = GetRelatedChannelsResponse{} }
func (m *GetRelatedChannelsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetRelatedChannelsResponse) ProtoMessage()               {}
func (*GetRelatedChannelsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{137} }

func (m *GetRelatedChannelsResponse) GetChannelIds() []string {
	if m != nil {
		return m.ChannelIds
	}
	return nil
}

// Emoticons
// ======
type GetEmotePrefixRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetEmotePrefixRequest) Reset()                    { *m = GetEmotePrefixRequest{} }
func (m *GetEmotePrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEmotePrefixRequest) ProtoMessage()               {}
func (*GetEmotePrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{138} }

func (m *GetEmotePrefixRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetEmotePrefixResponse struct {
	Prefixes []string `protobuf:"bytes,1,rep,name=prefixes" json:"prefixes,omitempty"`
}

func (m *GetEmotePrefixResponse) Reset()                    { *m = GetEmotePrefixResponse{} }
func (m *GetEmotePrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEmotePrefixResponse) ProtoMessage()               {}
func (*GetEmotePrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{139} }

func (m *GetEmotePrefixResponse) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

type GetEmoticonPrefixRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetEmoticonPrefixRequest) Reset()                    { *m = GetEmoticonPrefixRequest{} }
func (m *GetEmoticonPrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEmoticonPrefixRequest) ProtoMessage()               {}
func (*GetEmoticonPrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{140} }

func (m *GetEmoticonPrefixRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetEmoticonPrefixResponse struct {
	Prefix     string              `protobuf:"bytes,1,opt,name=prefix" json:"prefix,omitempty"`
	State      EmoticonPrefixState `protobuf:"varint,2,opt,name=state,enum=code.justin.tv.revenue.subscriptions.EmoticonPrefixState" json:"state,omitempty"`
	IsEditable bool                `protobuf:"varint,3,opt,name=is_editable,json=isEditable" json:"is_editable,omitempty"`
}

func (m *GetEmoticonPrefixResponse) Reset()                    { *m = GetEmoticonPrefixResponse{} }
func (m *GetEmoticonPrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEmoticonPrefixResponse) ProtoMessage()               {}
func (*GetEmoticonPrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{141} }

func (m *GetEmoticonPrefixResponse) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *GetEmoticonPrefixResponse) GetState() EmoticonPrefixState {
	if m != nil {
		return m.State
	}
	return EmoticonPrefixState_PREFIX_UNKNOWN
}

func (m *GetEmoticonPrefixResponse) GetIsEditable() bool {
	if m != nil {
		return m.IsEditable
	}
	return false
}

type CreateEmoticonRequest struct {
	UserId     string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	CodeSuffix string `protobuf:"bytes,2,opt,name=code_suffix,json=codeSuffix" json:"code_suffix,omitempty"`
	ProductId  string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Image28Id  string `protobuf:"bytes,4,opt,name=image28_id,json=image28Id" json:"image28_id,omitempty"`
	Image56Id  string `protobuf:"bytes,5,opt,name=image56_id,json=image56Id" json:"image56_id,omitempty"`
	Image112Id string `protobuf:"bytes,6,opt,name=image112_id,json=image112Id" json:"image112_id,omitempty"`
}

func (m *CreateEmoticonRequest) Reset()                    { *m = CreateEmoticonRequest{} }
func (m *CreateEmoticonRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateEmoticonRequest) ProtoMessage()               {}
func (*CreateEmoticonRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{142} }

func (m *CreateEmoticonRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CreateEmoticonRequest) GetCodeSuffix() string {
	if m != nil {
		return m.CodeSuffix
	}
	return ""
}

func (m *CreateEmoticonRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage28Id() string {
	if m != nil {
		return m.Image28Id
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage56Id() string {
	if m != nil {
		return m.Image56Id
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage112Id() string {
	if m != nil {
		return m.Image112Id
	}
	return ""
}

type CreateEmoticonReponse struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code      string `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	ProductId string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	GroupId   string `protobuf:"bytes,4,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	State     string `protobuf:"bytes,5,opt,name=state" json:"state,omitempty"`
}

func (m *CreateEmoticonReponse) Reset()                    { *m = CreateEmoticonReponse{} }
func (m *CreateEmoticonReponse) String() string            { return proto.CompactTextString(m) }
func (*CreateEmoticonReponse) ProtoMessage()               {}
func (*CreateEmoticonReponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{143} }

func (m *CreateEmoticonReponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateEmoticonReponse) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *CreateEmoticonReponse) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateEmoticonReponse) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *CreateEmoticonReponse) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

type DeleteEmoticonRequest struct {
	Id           string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code         string `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	DeleteImages bool   `protobuf:"varint,3,opt,name=deleteImages" json:"deleteImages,omitempty"`
}

func (m *DeleteEmoticonRequest) Reset()                    { *m = DeleteEmoticonRequest{} }
func (m *DeleteEmoticonRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteEmoticonRequest) ProtoMessage()               {}
func (*DeleteEmoticonRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{144} }

func (m *DeleteEmoticonRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeleteEmoticonRequest) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *DeleteEmoticonRequest) GetDeleteImages() bool {
	if m != nil {
		return m.DeleteImages
	}
	return false
}

type DeleteEmoticonResponse struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code          string `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	DeletedImages bool   `protobuf:"varint,3,opt,name=deletedImages" json:"deletedImages,omitempty"`
}

func (m *DeleteEmoticonResponse) Reset()                    { *m = DeleteEmoticonResponse{} }
func (m *DeleteEmoticonResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteEmoticonResponse) ProtoMessage()               {}
func (*DeleteEmoticonResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{145} }

func (m *DeleteEmoticonResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeleteEmoticonResponse) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *DeleteEmoticonResponse) GetDeletedImages() bool {
	if m != nil {
		return m.DeletedImages
	}
	return false
}

type GetAllEmoticonsByProductIDsRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetAllEmoticonsByProductIDsRequest) Reset()         { *m = GetAllEmoticonsByProductIDsRequest{} }
func (m *GetAllEmoticonsByProductIDsRequest) String() string { return proto.CompactTextString(m) }
func (*GetAllEmoticonsByProductIDsRequest) ProtoMessage()    {}
func (*GetAllEmoticonsByProductIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{146}
}

func (m *GetAllEmoticonsByProductIDsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetAllEmoticonsByProductIDsResponse struct {
	EmoticonGroups []*EmoticonGroup `protobuf:"bytes,1,rep,name=emoticon_groups,json=emoticonGroups" json:"emoticon_groups,omitempty"`
}

func (m *GetAllEmoticonsByProductIDsResponse) Reset()         { *m = GetAllEmoticonsByProductIDsResponse{} }
func (m *GetAllEmoticonsByProductIDsResponse) String() string { return proto.CompactTextString(m) }
func (*GetAllEmoticonsByProductIDsResponse) ProtoMessage()    {}
func (*GetAllEmoticonsByProductIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{147}
}

func (m *GetAllEmoticonsByProductIDsResponse) GetEmoticonGroups() []*EmoticonGroup {
	if m != nil {
		return m.EmoticonGroups
	}
	return nil
}

type EmoticonGroup struct {
	ProductId string      `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Emoticons []*Emoticon `protobuf:"bytes,2,rep,name=emoticons" json:"emoticons,omitempty"`
}

func (m *EmoticonGroup) Reset()                    { *m = EmoticonGroup{} }
func (m *EmoticonGroup) String() string            { return proto.CompactTextString(m) }
func (*EmoticonGroup) ProtoMessage()               {}
func (*EmoticonGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{148} }

func (m *EmoticonGroup) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *EmoticonGroup) GetEmoticons() []*Emoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

type Emoticon struct {
	Id      string        `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code    string        `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	GroupId string        `protobuf:"bytes,3,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	State   EmoticonState `protobuf:"varint,4,opt,name=state,enum=code.justin.tv.revenue.subscriptions.EmoticonState" json:"state,omitempty"`
}

func (m *Emoticon) Reset()                    { *m = Emoticon{} }
func (m *Emoticon) String() string            { return proto.CompactTextString(m) }
func (*Emoticon) ProtoMessage()               {}
func (*Emoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{149} }

func (m *Emoticon) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Emoticon) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *Emoticon) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *Emoticon) GetState() EmoticonState {
	if m != nil {
		return m.State
	}
	return EmoticonState_EmoticonState_NONE
}

// GetPartnerStandingRequest takes a user_id to find the partner standing status for.
type GetPartnerStandingRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *GetPartnerStandingRequest) Reset()                    { *m = GetPartnerStandingRequest{} }
func (m *GetPartnerStandingRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPartnerStandingRequest) ProtoMessage()               {}
func (*GetPartnerStandingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{150} }

func (m *GetPartnerStandingRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

// GetPartnerStandingStatusResponse returns the partner standing status for a given user.
// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
type GetPartnerStandingResponse struct {
	IsInGoodStanding bool `protobuf:"varint,1,opt,name=is_in_good_standing,json=isInGoodStanding" json:"is_in_good_standing,omitempty"`
}

func (m *GetPartnerStandingResponse) Reset()                    { *m = GetPartnerStandingResponse{} }
func (m *GetPartnerStandingResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPartnerStandingResponse) ProtoMessage()               {}
func (*GetPartnerStandingResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{151} }

func (m *GetPartnerStandingResponse) GetIsInGoodStanding() bool {
	if m != nil {
		return m.IsInGoodStanding
	}
	return false
}

// SubmitEmoticonPrefixRequest takes a prefix and a user id.
// Prefix must be between 3 and 10 characters inclusive.
type SubmitEmoticonPrefixRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Prefix    string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
}

func (m *SubmitEmoticonPrefixRequest) Reset()                    { *m = SubmitEmoticonPrefixRequest{} }
func (m *SubmitEmoticonPrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitEmoticonPrefixRequest) ProtoMessage()               {}
func (*SubmitEmoticonPrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{152} }

func (m *SubmitEmoticonPrefixRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SubmitEmoticonPrefixRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

// SubmitEmoticonPrefixResponse will be empty. Check the status code to determine whether the
// request was succesful.
type SubmitEmoticonPrefixResponse struct {
}

func (m *SubmitEmoticonPrefixResponse) Reset()                    { *m = SubmitEmoticonPrefixResponse{} }
func (m *SubmitEmoticonPrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*SubmitEmoticonPrefixResponse) ProtoMessage()               {}
func (*SubmitEmoticonPrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{153} }

// Pending Emoticons
// =========
type GetPendingEmoticonsByIDsRequest struct {
	EmoticonIds []string `protobuf:"bytes,1,rep,name=emoticon_ids,json=emoticonIds" json:"emoticon_ids,omitempty"`
}

func (m *GetPendingEmoticonsByIDsRequest) Reset()         { *m = GetPendingEmoticonsByIDsRequest{} }
func (m *GetPendingEmoticonsByIDsRequest) String() string { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsByIDsRequest) ProtoMessage()    {}
func (*GetPendingEmoticonsByIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{154}
}

func (m *GetPendingEmoticonsByIDsRequest) GetEmoticonIds() []string {
	if m != nil {
		return m.EmoticonIds
	}
	return nil
}

type GetPendingEmoticonsByIDsResponse struct {
	Emoticons []*PendingEmoticon `protobuf:"bytes,1,rep,name=emoticons" json:"emoticons,omitempty"`
}

func (m *GetPendingEmoticonsByIDsResponse) Reset()         { *m = GetPendingEmoticonsByIDsResponse{} }
func (m *GetPendingEmoticonsByIDsResponse) String() string { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsByIDsResponse) ProtoMessage()    {}
func (*GetPendingEmoticonsByIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{155}
}

func (m *GetPendingEmoticonsByIDsResponse) GetEmoticons() []*PendingEmoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

// GetPendingEmoticonsRequest
type GetPendingEmoticonsRequest struct {
	Filter         EmoticonFilter             `protobuf:"varint,1,opt,name=filter,enum=code.justin.tv.revenue.subscriptions.EmoticonFilter" json:"filter,omitempty"`
	Count          int32                      `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
	Bucket         *EmoticonBucket            `protobuf:"bytes,3,opt,name=bucket" json:"bucket,omitempty"`
	AfterTimestamp *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=after_timestamp,json=afterTimestamp" json:"after_timestamp,omitempty"`
}

func (m *GetPendingEmoticonsRequest) Reset()                    { *m = GetPendingEmoticonsRequest{} }
func (m *GetPendingEmoticonsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsRequest) ProtoMessage()               {}
func (*GetPendingEmoticonsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{156} }

func (m *GetPendingEmoticonsRequest) GetFilter() EmoticonFilter {
	if m != nil {
		return m.Filter
	}
	return EmoticonFilter_EmoticonFilter_All
}

func (m *GetPendingEmoticonsRequest) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *GetPendingEmoticonsRequest) GetBucket() *EmoticonBucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *GetPendingEmoticonsRequest) GetAfterTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.AfterTimestamp
	}
	return nil
}

// GetPendingEmoticonsResponse
type GetPendingEmoticonsResponse struct {
	Emoticons  []*PendingEmoticon `protobuf:"bytes,1,rep,name=emoticons" json:"emoticons,omitempty"`
	TotalCount int32              `protobuf:"varint,2,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
}

func (m *GetPendingEmoticonsResponse) Reset()                    { *m = GetPendingEmoticonsResponse{} }
func (m *GetPendingEmoticonsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsResponse) ProtoMessage()               {}
func (*GetPendingEmoticonsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{157} }

func (m *GetPendingEmoticonsResponse) GetEmoticons() []*PendingEmoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

func (m *GetPendingEmoticonsResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

type ReviewPendingEmoticonsRequest struct {
	Reviews []*ReviewPendingEmoticonRequest `protobuf:"bytes,1,rep,name=reviews" json:"reviews,omitempty"`
	AdminId string                          `protobuf:"bytes,2,opt,name=admin_id,json=adminId" json:"admin_id,omitempty"`
}

func (m *ReviewPendingEmoticonsRequest) Reset()                    { *m = ReviewPendingEmoticonsRequest{} }
func (m *ReviewPendingEmoticonsRequest) String() string            { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonsRequest) ProtoMessage()               {}
func (*ReviewPendingEmoticonsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{158} }

func (m *ReviewPendingEmoticonsRequest) GetReviews() []*ReviewPendingEmoticonRequest {
	if m != nil {
		return m.Reviews
	}
	return nil
}

func (m *ReviewPendingEmoticonsRequest) GetAdminId() string {
	if m != nil {
		return m.AdminId
	}
	return ""
}

type ReviewPendingEmoticonRequest struct {
	Id                 string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Approve            bool   `protobuf:"varint,2,opt,name=approve" json:"approve,omitempty"`
	DeclineReason      string `protobuf:"bytes,3,opt,name=decline_reason,json=declineReason" json:"decline_reason,omitempty"`
	DeclineExplanation string `protobuf:"bytes,4,opt,name=decline_explanation,json=declineExplanation" json:"decline_explanation,omitempty"`
}

func (m *ReviewPendingEmoticonRequest) Reset()                    { *m = ReviewPendingEmoticonRequest{} }
func (m *ReviewPendingEmoticonRequest) String() string            { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonRequest) ProtoMessage()               {}
func (*ReviewPendingEmoticonRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{159} }

func (m *ReviewPendingEmoticonRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ReviewPendingEmoticonRequest) GetApprove() bool {
	if m != nil {
		return m.Approve
	}
	return false
}

func (m *ReviewPendingEmoticonRequest) GetDeclineReason() string {
	if m != nil {
		return m.DeclineReason
	}
	return ""
}

func (m *ReviewPendingEmoticonRequest) GetDeclineExplanation() string {
	if m != nil {
		return m.DeclineExplanation
	}
	return ""
}

type ReviewPendingEmoticonsResponse struct {
	Results []*ReviewPendingEmoticonResponse `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
}

func (m *ReviewPendingEmoticonsResponse) Reset()         { *m = ReviewPendingEmoticonsResponse{} }
func (m *ReviewPendingEmoticonsResponse) String() string { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonsResponse) ProtoMessage()    {}
func (*ReviewPendingEmoticonsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{160}
}

func (m *ReviewPendingEmoticonsResponse) GetResults() []*ReviewPendingEmoticonResponse {
	if m != nil {
		return m.Results
	}
	return nil
}

type ReviewPendingEmoticonResponse struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Succeeded bool   `protobuf:"varint,2,opt,name=succeeded" json:"succeeded,omitempty"`
	NewStatus string `protobuf:"bytes,3,opt,name=new_status,json=newStatus" json:"new_status,omitempty"`
}

func (m *ReviewPendingEmoticonResponse) Reset()                    { *m = ReviewPendingEmoticonResponse{} }
func (m *ReviewPendingEmoticonResponse) String() string            { return proto.CompactTextString(m) }
func (*ReviewPendingEmoticonResponse) ProtoMessage()               {}
func (*ReviewPendingEmoticonResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{161} }

func (m *ReviewPendingEmoticonResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ReviewPendingEmoticonResponse) GetSucceeded() bool {
	if m != nil {
		return m.Succeeded
	}
	return false
}

func (m *ReviewPendingEmoticonResponse) GetNewStatus() string {
	if m != nil {
		return m.NewStatus
	}
	return ""
}

type EmoticonBucket struct {
	Requested   int32 `protobuf:"varint,1,opt,name=requested" json:"requested,omitempty"`
	BucketCount int32 `protobuf:"varint,2,opt,name=bucket_count,json=bucketCount" json:"bucket_count,omitempty"`
}

func (m *EmoticonBucket) Reset()                    { *m = EmoticonBucket{} }
func (m *EmoticonBucket) String() string            { return proto.CompactTextString(m) }
func (*EmoticonBucket) ProtoMessage()               {}
func (*EmoticonBucket) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{162} }

func (m *EmoticonBucket) GetRequested() int32 {
	if m != nil {
		return m.Requested
	}
	return 0
}

func (m *EmoticonBucket) GetBucketCount() int32 {
	if m != nil {
		return m.BucketCount
	}
	return 0
}

// PendingEmoticon contains all the data necessary for Moderation to view and judge an emoticon
type PendingEmoticon struct {
	Id         string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Prefix     string                     `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	Code       string                     `protobuf:"bytes,3,opt,name=code" json:"code,omitempty"`
	OwnerId    string                     `protobuf:"bytes,4,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	UploadTime *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=upload_time,json=uploadTime" json:"upload_time,omitempty"`
}

func (m *PendingEmoticon) Reset()                    { *m = PendingEmoticon{} }
func (m *PendingEmoticon) String() string            { return proto.CompactTextString(m) }
func (*PendingEmoticon) ProtoMessage()               {}
func (*PendingEmoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{163} }

func (m *PendingEmoticon) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PendingEmoticon) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *PendingEmoticon) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *PendingEmoticon) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *PendingEmoticon) GetUploadTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.UploadTime
	}
	return nil
}

// Products
// =========
type Product struct {
	Id              string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ShortName       string                     `protobuf:"bytes,2,opt,name=short_name,json=shortName" json:"short_name,omitempty"`
	DisplayName     string                     `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	EmoticonSetIds  []string                   `protobuf:"bytes,4,rep,name=emoticon_set_ids,json=emoticonSetIds" json:"emoticon_set_ids,omitempty"`
	Price           int32                      `protobuf:"varint,5,opt,name=price" json:"price,omitempty"`
	HideAds         bool                       `protobuf:"varint,6,opt,name=hide_ads,json=hideAds" json:"hide_ads,omitempty"`
	Type            string                     `protobuf:"bytes,7,opt,name=type" json:"type,omitempty"`
	OwnerId         string                     `protobuf:"bytes,8,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Tier            string                     `protobuf:"bytes,9,opt,name=tier" json:"tier,omitempty"`
	Interval        *ProductInterval           `protobuf:"bytes,10,opt,name=interval" json:"interval,omitempty"`
	BitrateAccess   []string                   `protobuf:"bytes,11,rep,name=bitrate_access,json=bitrateAccess" json:"bitrate_access,omitempty"`
	SubonlyArchives bool                       `protobuf:"varint,12,opt,name=subonly_archives,json=subonlyArchives" json:"subonly_archives,omitempty"`
	EmoticonSetId   string                     `protobuf:"bytes,13,opt,name=emoticon_set_id,json=emoticonSetId" json:"emoticon_set_id,omitempty"`
	PriceId         string                     `protobuf:"bytes,14,opt,name=price_id,json=priceId" json:"price_id,omitempty"`
	BenefitStart    *google_protobuf.Timestamp `protobuf:"bytes,15,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd      *google_protobuf.Timestamp `protobuf:"bytes,16,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Refundable      bool                       `protobuf:"varint,17,opt,name=refundable" json:"refundable,omitempty"`
	State           ProductState               `protobuf:"varint,18,opt,name=state,enum=code.justin.tv.revenue.subscriptions.ProductState" json:"state,omitempty"`
	Recurring       bool                       `protobuf:"varint,19,opt,name=recurring" json:"recurring,omitempty"`
}

func (m *Product) Reset()                    { *m = Product{} }
func (m *Product) String() string            { return proto.CompactTextString(m) }
func (*Product) ProtoMessage()               {}
func (*Product) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{164} }

func (m *Product) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Product) GetShortName() string {
	if m != nil {
		return m.ShortName
	}
	return ""
}

func (m *Product) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Product) GetEmoticonSetIds() []string {
	if m != nil {
		return m.EmoticonSetIds
	}
	return nil
}

func (m *Product) GetPrice() int32 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *Product) GetHideAds() bool {
	if m != nil {
		return m.HideAds
	}
	return false
}

func (m *Product) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Product) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Product) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *Product) GetInterval() *ProductInterval {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *Product) GetBitrateAccess() []string {
	if m != nil {
		return m.BitrateAccess
	}
	return nil
}

func (m *Product) GetSubonlyArchives() bool {
	if m != nil {
		return m.SubonlyArchives
	}
	return false
}

func (m *Product) GetEmoticonSetId() string {
	if m != nil {
		return m.EmoticonSetId
	}
	return ""
}

func (m *Product) GetPriceId() string {
	if m != nil {
		return m.PriceId
	}
	return ""
}

func (m *Product) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *Product) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *Product) GetRefundable() bool {
	if m != nil {
		return m.Refundable
	}
	return false
}

func (m *Product) GetState() ProductState {
	if m != nil {
		return m.State
	}
	return ProductState_ProductState_UNKNOWN
}

func (m *Product) GetRecurring() bool {
	if m != nil {
		return m.Recurring
	}
	return false
}

type ProductInterval struct {
	Duration int32               `protobuf:"varint,1,opt,name=duration" json:"duration,omitempty"`
	Unit     ProductIntervalUnit `protobuf:"varint,2,opt,name=unit,enum=code.justin.tv.revenue.subscriptions.ProductIntervalUnit" json:"unit,omitempty"`
}

func (m *ProductInterval) Reset()                    { *m = ProductInterval{} }
func (m *ProductInterval) String() string            { return proto.CompactTextString(m) }
func (*ProductInterval) ProtoMessage()               {}
func (*ProductInterval) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{165} }

func (m *ProductInterval) GetDuration() int32 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *ProductInterval) GetUnit() ProductIntervalUnit {
	if m != nil {
		return m.Unit
	}
	return ProductIntervalUnit_ProductIntervalUnit_NONE
}

// Takes in a list of product_ids. Max 100.
type GetProductsByIDsRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetProductsByIDsRequest) Reset()                    { *m = GetProductsByIDsRequest{} }
func (m *GetProductsByIDsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByIDsRequest) ProtoMessage()               {}
func (*GetProductsByIDsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{166} }

func (m *GetProductsByIDsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

// Returns a list of products.
type GetProductsByIDsResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetProductsByIDsResponse) Reset()                    { *m = GetProductsByIDsResponse{} }
func (m *GetProductsByIDsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByIDsResponse) ProtoMessage()               {}
func (*GetProductsByIDsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{167} }

func (m *GetProductsByIDsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// Takes in a list of product_names. Max 100.
type GetProductsByNamesRequest struct {
	ProductNames []string `protobuf:"bytes,1,rep,name=product_names,json=productNames" json:"product_names,omitempty"`
}

func (m *GetProductsByNamesRequest) Reset()                    { *m = GetProductsByNamesRequest{} }
func (m *GetProductsByNamesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByNamesRequest) ProtoMessage()               {}
func (*GetProductsByNamesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{168} }

func (m *GetProductsByNamesRequest) GetProductNames() []string {
	if m != nil {
		return m.ProductNames
	}
	return nil
}

// Returns a list of products.
type GetProductsByNamesResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetProductsByNamesResponse) Reset()                    { *m = GetProductsByNamesResponse{} }
func (m *GetProductsByNamesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByNamesResponse) ProtoMessage()               {}
func (*GetProductsByNamesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{169} }

func (m *GetProductsByNamesResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// Accepts a single channel ID.
type GetChannelProductsRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	ClientId  string `protobuf:"bytes,2,opt,name=client_id,json=clientId" json:"client_id,omitempty"`
}

func (m *GetChannelProductsRequest) Reset()                    { *m = GetChannelProductsRequest{} }
func (m *GetChannelProductsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelProductsRequest) ProtoMessage()               {}
func (*GetChannelProductsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{170} }

func (m *GetChannelProductsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetChannelProductsRequest) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

// Returns a list of products.
type GetChannelProductsResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetChannelProductsResponse) Reset()                    { *m = GetChannelProductsResponse{} }
func (m *GetChannelProductsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetChannelProductsResponse) ProtoMessage()               {}
func (*GetChannelProductsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{171} }

func (m *GetChannelProductsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// UpdateProductRequest is the request for UpdateProduct rpc method.
type UpdateProductRequest struct {
	ProductId   string `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *UpdateProductRequest) Reset()                    { *m = UpdateProductRequest{} }
func (m *UpdateProductRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProductRequest) ProtoMessage()               {}
func (*UpdateProductRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{172} }

func (m *UpdateProductRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *UpdateProductRequest) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// empty response for UpdateProduct rpc request.
type UpdateProductResponse struct {
}

func (m *UpdateProductResponse) Reset()                    { *m = UpdateProductResponse{} }
func (m *UpdateProductResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProductResponse) ProtoMessage()               {}
func (*UpdateProductResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{173} }

// UpdateChannelProductsRequest is the body of UpdateChannelProducts rpc method.
type UpdateChannelProductsRequest struct {
	ChannelId       string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	HideAds         bool   `protobuf:"varint,2,opt,name=hide_ads,json=hideAds" json:"hide_ads,omitempty"`
	SubonlyArchives bool   `protobuf:"varint,3,opt,name=subonly_archives,json=subonlyArchives" json:"subonly_archives,omitempty"`
}

func (m *UpdateChannelProductsRequest) Reset()                    { *m = UpdateChannelProductsRequest{} }
func (m *UpdateChannelProductsRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateChannelProductsRequest) ProtoMessage()               {}
func (*UpdateChannelProductsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{174} }

func (m *UpdateChannelProductsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UpdateChannelProductsRequest) GetHideAds() bool {
	if m != nil {
		return m.HideAds
	}
	return false
}

func (m *UpdateChannelProductsRequest) GetSubonlyArchives() bool {
	if m != nil {
		return m.SubonlyArchives
	}
	return false
}

// empty response for UpdateChannelProduct rpc request.
type UpdateChannelProductsResponse struct {
}

func (m *UpdateChannelProductsResponse) Reset()                    { *m = UpdateChannelProductsResponse{} }
func (m *UpdateChannelProductsResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateChannelProductsResponse) ProtoMessage()               {}
func (*UpdateChannelProductsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{175} }

// GetTicketsForUserChannelRequest includes the user and channel to query for tickets
type GetTicketsForUserChannelRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetTicketsForUserChannelRequest) Reset()         { *m = GetTicketsForUserChannelRequest{} }
func (m *GetTicketsForUserChannelRequest) String() string { return proto.CompactTextString(m) }
func (*GetTicketsForUserChannelRequest) ProtoMessage()    {}
func (*GetTicketsForUserChannelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{176}
}

func (m *GetTicketsForUserChannelRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetTicketsForUserChannelRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// GetTicketsForUserChannelResponse includes the ticket data returned from siteDB for that user/channel pair
type GetTicketsForUserChannelResponse struct {
	Tickets []*TicketGrantData `protobuf:"bytes,1,rep,name=tickets" json:"tickets,omitempty"`
}

func (m *GetTicketsForUserChannelResponse) Reset()         { *m = GetTicketsForUserChannelResponse{} }
func (m *GetTicketsForUserChannelResponse) String() string { return proto.CompactTextString(m) }
func (*GetTicketsForUserChannelResponse) ProtoMessage()    {}
func (*GetTicketsForUserChannelResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{177}
}

func (m *GetTicketsForUserChannelResponse) GetTickets() []*TicketGrantData {
	if m != nil {
		return m.Tickets
	}
	return nil
}

// TicketData includes only the information from tickets that would be required to create a chronobreak grant
type TicketGrantData struct {
	OriginId     string                     `protobuf:"bytes,1,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	UpdatedOn    *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=updated_on,json=updatedOn" json:"updated_on,omitempty"`
	CreatedOn    *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=created_on,json=createdOn" json:"created_on,omitempty"`
}

func (m *TicketGrantData) Reset()                    { *m = TicketGrantData{} }
func (m *TicketGrantData) String() string            { return proto.CompactTextString(m) }
func (*TicketGrantData) ProtoMessage()               {}
func (*TicketGrantData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{178} }

func (m *TicketGrantData) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *TicketGrantData) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *TicketGrantData) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *TicketGrantData) GetUpdatedOn() *google_protobuf.Timestamp {
	if m != nil {
		return m.UpdatedOn
	}
	return nil
}

func (m *TicketGrantData) GetCreatedOn() *google_protobuf.Timestamp {
	if m != nil {
		return m.CreatedOn
	}
	return nil
}

func init() {
	proto.RegisterType((*EmailPendingPrefixApprovalRequest)(nil), "code.justin.tv.revenue.subscriptions.EmailPendingPrefixApprovalRequest")
	proto.RegisterType((*EmailPendingPrefixApprovalResponse)(nil), "code.justin.tv.revenue.subscriptions.EmailPendingPrefixApprovalResponse")
	proto.RegisterType((*EmailGlobalEmoteRequest)(nil), "code.justin.tv.revenue.subscriptions.EmailGlobalEmoteRequest")
	proto.RegisterType((*EmailGlobalEmoteResponse)(nil), "code.justin.tv.revenue.subscriptions.EmailGlobalEmoteResponse")
	proto.RegisterType((*EmailSubscribersRequest)(nil), "code.justin.tv.revenue.subscriptions.EmailSubscribersRequest")
	proto.RegisterType((*EmailSubscribersResponse)(nil), "code.justin.tv.revenue.subscriptions.EmailSubscribersResponse")
	proto.RegisterType((*EmoticonLevel)(nil), "code.justin.tv.revenue.subscriptions.EmoticonLevel")
	proto.RegisterType((*SetScoreRequest)(nil), "code.justin.tv.revenue.subscriptions.SetScoreRequest")
	proto.RegisterType((*SetScoreResponse)(nil), "code.justin.tv.revenue.subscriptions.SetScoreResponse")
	proto.RegisterType((*SubscriptionCount)(nil), "code.justin.tv.revenue.subscriptions.SubscriptionCount")
	proto.RegisterType((*CalculateSubscriberCountRequest)(nil), "code.justin.tv.revenue.subscriptions.CalculateSubscriberCountRequest")
	proto.RegisterType((*CalculateSubscriberCountResponse)(nil), "code.justin.tv.revenue.subscriptions.CalculateSubscriberCountResponse")
	proto.RegisterType((*GetUserSettingsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserSettingsRequest")
	proto.RegisterType((*GetUserSettingsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserSettingsResponse")
	proto.RegisterType((*SetUserSettingsRequest)(nil), "code.justin.tv.revenue.subscriptions.SetUserSettingsRequest")
	proto.RegisterType((*SetUserSettingsResponse)(nil), "code.justin.tv.revenue.subscriptions.SetUserSettingsResponse")
	proto.RegisterType((*OptionalBool)(nil), "code.justin.tv.revenue.subscriptions.OptionalBool")
	proto.RegisterType((*Subscription)(nil), "code.justin.tv.revenue.subscriptions.Subscription")
	proto.RegisterType((*FormerSubscriber)(nil), "code.justin.tv.revenue.subscriptions.FormerSubscriber")
	proto.RegisterType((*FulfillSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.FulfillSubscriptionRequest")
	proto.RegisterType((*FulfillSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.FulfillSubscriptionResponse")
	proto.RegisterType((*CreateSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateSubscriptionRequest")
	proto.RegisterType((*CreateSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateSubscriptionResponse")
	proto.RegisterType((*CancelSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelSubscriptionRequest")
	proto.RegisterType((*CancelSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelSubscriptionResponse")
	proto.RegisterType((*UpdateSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateSubscriptionRequest")
	proto.RegisterType((*UpdateSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateSubscriptionResponse")
	proto.RegisterType((*CanSubscribeRequest)(nil), "code.justin.tv.revenue.subscriptions.CanSubscribeRequest")
	proto.RegisterType((*CanSubscribeResponse)(nil), "code.justin.tv.revenue.subscriptions.CanSubscribeResponse")
	proto.RegisterType((*UpdateTicketOriginIDRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateTicketOriginIDRequest")
	proto.RegisterType((*UpdateTicketOriginIDResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateTicketOriginIDResponse")
	proto.RegisterType((*ListUserSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest")
	proto.RegisterType((*ListUserExpiredSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.ListUserExpiredSubscriptionsRequest")
	proto.RegisterType((*GetUserChannelSubscriptionWithPaymentsDataRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionWithPaymentsDataRequest")
	proto.RegisterType((*GetUserChannelSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionRequest")
	proto.RegisterType((*UserSubscription)(nil), "code.justin.tv.revenue.subscriptions.UserSubscription")
	proto.RegisterType((*UserSubscriptionResult)(nil), "code.justin.tv.revenue.subscriptions.UserSubscriptionResult")
	proto.RegisterType((*SubscriptionResult)(nil), "code.justin.tv.revenue.subscriptions.SubscriptionResult")
	proto.RegisterType((*ListUserExpiredSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.ListUserExpiredSubscriptionsResponse")
	proto.RegisterType((*ListUserSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.ListUserSubscriptionsResponse")
	proto.RegisterType((*GetUserChannelSubscriptionWithPaymentsDataResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionWithPaymentsDataResponse")
	proto.RegisterType((*GetUserChannelSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionResponse")
	proto.RegisterType((*GetUserProductSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsRequest")
	proto.RegisterType((*GetUserProductSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsResponse")
	proto.RegisterType((*GetUserProductSubscriptionsWithPaymentsDataRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsWithPaymentsDataRequest")
	proto.RegisterType((*GetUserProductSubscriptionsWithPaymentsDataResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsWithPaymentsDataResponse")
	proto.RegisterType((*GetUserSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserSubscriptionsRequest")
	proto.RegisterType((*GetUserSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserSubscriptionsResponse")
	proto.RegisterType((*GetChannelSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetChannelSubscriptionsRequest")
	proto.RegisterType((*GetChannelSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetChannelSubscriptionsResponse")
	proto.RegisterType((*GetFormerSubscribersRequest)(nil), "code.justin.tv.revenue.subscriptions.GetFormerSubscribersRequest")
	proto.RegisterType((*GetFormerSubscribersResponse)(nil), "code.justin.tv.revenue.subscriptions.GetFormerSubscribersResponse")
	proto.RegisterType((*GetSubscriptionByIDRequest)(nil), "code.justin.tv.revenue.subscriptions.GetSubscriptionByIDRequest")
	proto.RegisterType((*GetSubscriptionByIDResponse)(nil), "code.justin.tv.revenue.subscriptions.GetSubscriptionByIDResponse")
	proto.RegisterType((*GetTicketsByIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetTicketsByIDsRequest")
	proto.RegisterType((*GetTicketsByIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetTicketsByIDsResponse")
	proto.RegisterType((*GetHistoricalUserTicketsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetHistoricalUserTicketsRequest")
	proto.RegisterType((*GetHistoricalUserTicketsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetHistoricalUserTicketsResponse")
	proto.RegisterType((*TakedownBadgesRequest)(nil), "code.justin.tv.revenue.subscriptions.TakedownBadgesRequest")
	proto.RegisterType((*TakedownBadgesResponse)(nil), "code.justin.tv.revenue.subscriptions.TakedownBadgesResponse")
	proto.RegisterType((*TakedownAllBadgesRequest)(nil), "code.justin.tv.revenue.subscriptions.TakedownAllBadgesRequest")
	proto.RegisterType((*TakedownAllBadgesResponse)(nil), "code.justin.tv.revenue.subscriptions.TakedownAllBadgesResponse")
	proto.RegisterType((*GetSubscriberBadgeRequest)(nil), "code.justin.tv.revenue.subscriptions.GetSubscriberBadgeRequest")
	proto.RegisterType((*GetSubscriberBadgeResponse)(nil), "code.justin.tv.revenue.subscriptions.GetSubscriberBadgeResponse")
	proto.RegisterType((*GetChannelBadgeRequest)(nil), "code.justin.tv.revenue.subscriptions.GetChannelBadgeRequest")
	proto.RegisterType((*GetChannelBadgeResponse)(nil), "code.justin.tv.revenue.subscriptions.GetChannelBadgeResponse")
	proto.RegisterType((*DeleteChannelBadgeRequest)(nil), "code.justin.tv.revenue.subscriptions.DeleteChannelBadgeRequest")
	proto.RegisterType((*DeleteChannelBadgeResponse)(nil), "code.justin.tv.revenue.subscriptions.DeleteChannelBadgeResponse")
	proto.RegisterType((*CreateChannelBadgeUploadConfigRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateChannelBadgeUploadConfigRequest")
	proto.RegisterType((*CreateChannelBadgeUploadConfigResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateChannelBadgeUploadConfigResponse")
	proto.RegisterType((*CreateChannelBadgeRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateChannelBadgeRequest")
	proto.RegisterType((*CreateChannelBadgeResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateChannelBadgeResponse")
	proto.RegisterType((*GetTimeoutStatusesRequest)(nil), "code.justin.tv.revenue.subscriptions.GetTimeoutStatusesRequest")
	proto.RegisterType((*GetTimeoutStatusesResponse)(nil), "code.justin.tv.revenue.subscriptions.GetTimeoutStatusesResponse")
	proto.RegisterType((*ChannelBadge)(nil), "code.justin.tv.revenue.subscriptions.ChannelBadge")
	proto.RegisterType((*GetExternalProductTemplateSKURequest)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductTemplateSKURequest")
	proto.RegisterType((*GetExternalProductTemplateSKUResponse)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductTemplateSKUResponse")
	proto.RegisterType((*GetExternalProductPurchasableSKURequest)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductPurchasableSKURequest")
	proto.RegisterType((*GetExternalProductPurchasableSKUResponse)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductPurchasableSKUResponse")
	proto.RegisterType((*SubKey)(nil), "code.justin.tv.revenue.subscriptions.SubKey")
	proto.RegisterType((*PaidUpgrade)(nil), "code.justin.tv.revenue.subscriptions.PaidUpgrade")
	proto.RegisterType((*GetPaidUpgradesRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradesRequest")
	proto.RegisterType((*GetPaidUpgradesResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradesResponse")
	proto.RegisterType((*CreatePaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.CreatePaidUpgradeRequest")
	proto.RegisterType((*CreatePaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.CreatePaidUpgradeResponse")
	proto.RegisterType((*CancelPaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelPaidUpgradeRequest")
	proto.RegisterType((*CancelPaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelPaidUpgradeResponse")
	proto.RegisterType((*FulfillPaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.FulfillPaidUpgradeRequest")
	proto.RegisterType((*FulfillPaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.FulfillPaidUpgradeResponse")
	proto.RegisterType((*CreateChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateChatNotificationTokenRequest")
	proto.RegisterType((*CreateChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateChatNotificationTokenResponse")
	proto.RegisterType((*NewTicketInterval)(nil), "code.justin.tv.revenue.subscriptions.NewTicketInterval")
	proto.RegisterType((*UseChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.UseChatNotificationTokenRequest")
	proto.RegisterType((*UseChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.UseChatNotificationTokenResponse")
	proto.RegisterType((*CancelChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelChatNotificationTokenRequest")
	proto.RegisterType((*CancelChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelChatNotificationTokenResponse")
	proto.RegisterType((*GetUserChannelChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelChatNotificationTokenRequest")
	proto.RegisterType((*GetUserChannelChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelChatNotificationTokenResponse")
	proto.RegisterType((*GetAllUsedChatNotificationTokensRequest)(nil), "code.justin.tv.revenue.subscriptions.GetAllUsedChatNotificationTokensRequest")
	proto.RegisterType((*GetAllUsedChatNotificationTokensResponse)(nil), "code.justin.tv.revenue.subscriptions.GetAllUsedChatNotificationTokensResponse")
	proto.RegisterType((*AllowReplayForLastUsedChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.AllowReplayForLastUsedChatNotificationTokenRequest")
	proto.RegisterType((*AllowReplayForLastUsedChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.AllowReplayForLastUsedChatNotificationTokenResponse")
	proto.RegisterType((*ChatNotificationToken)(nil), "code.justin.tv.revenue.subscriptions.ChatNotificationToken")
	proto.RegisterType((*UsedChatNotificationTokenItem)(nil), "code.justin.tv.revenue.subscriptions.UsedChatNotificationTokenItem")
	proto.RegisterType((*Gift)(nil), "code.justin.tv.revenue.subscriptions.Gift")
	proto.RegisterType((*GiftKey)(nil), "code.justin.tv.revenue.subscriptions.GiftKey")
	proto.RegisterType((*InsertGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.InsertGiftRequest")
	proto.RegisterType((*InsertGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.InsertGiftResponse")
	proto.RegisterType((*CancelGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelGiftRequest")
	proto.RegisterType((*CancelGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelGiftResponse")
	proto.RegisterType((*GetGiftsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftsRequest")
	proto.RegisterType((*GetGiftsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftsResponse")
	proto.RegisterType((*CanGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRequest")
	proto.RegisterType((*CanGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CanGiftResponse")
	proto.RegisterType((*CanSenderGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CanSenderGiftRequest")
	proto.RegisterType((*CanSenderGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CanSenderGiftResponse")
	proto.RegisterType((*CanGiftRecipientRequest)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRecipientRequest")
	proto.RegisterType((*CanGiftRecipientResponse)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRecipientResponse")
	proto.RegisterType((*GiftOfferId)(nil), "code.justin.tv.revenue.subscriptions.GiftOfferId")
	proto.RegisterType((*GiftPromotion)(nil), "code.justin.tv.revenue.subscriptions.GiftPromotion")
	proto.RegisterType((*Promotion)(nil), "code.justin.tv.revenue.subscriptions.Promotion")
	proto.RegisterType((*GetGiftPromotionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftPromotionRequest")
	proto.RegisterType((*GetGiftPromotionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftPromotionResponse")
	proto.RegisterType((*GetPaidUpgradePromotionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradePromotionRequest")
	proto.RegisterType((*GetPaidUpgradePromotionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradePromotionResponse")
	proto.RegisterType((*FulfillGiftsRequest)(nil), "code.justin.tv.revenue.subscriptions.FulfillGiftsRequest")
	proto.RegisterType((*FulfillGiftsResponse)(nil), "code.justin.tv.revenue.subscriptions.FulfillGiftsResponse")
	proto.RegisterType((*SendGiftChatNotificationRequest)(nil), "code.justin.tv.revenue.subscriptions.SendGiftChatNotificationRequest")
	proto.RegisterType((*SendGiftChatNotificationResponse)(nil), "code.justin.tv.revenue.subscriptions.SendGiftChatNotificationResponse")
	proto.RegisterType((*SendMMGChatNotificationRequest)(nil), "code.justin.tv.revenue.subscriptions.SendMMGChatNotificationRequest")
	proto.RegisterType((*SendMMGChatNotificationResponse)(nil), "code.justin.tv.revenue.subscriptions.SendMMGChatNotificationResponse")
	proto.RegisterType((*SendMMGStartChatNotificationRequest)(nil), "code.justin.tv.revenue.subscriptions.SendMMGStartChatNotificationRequest")
	proto.RegisterType((*SendMMGStartChatNotificationResponse)(nil), "code.justin.tv.revenue.subscriptions.SendMMGStartChatNotificationResponse")
	proto.RegisterType((*GiftOffer)(nil), "code.justin.tv.revenue.subscriptions.GiftOffer")
	proto.RegisterType((*GetGiftOffersRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftOffersRequest")
	proto.RegisterType((*GetGiftOffersResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftOffersResponse")
	proto.RegisterType((*GetRelatedChannelsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetRelatedChannelsRequest")
	proto.RegisterType((*GetRelatedChannelsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetRelatedChannelsResponse")
	proto.RegisterType((*GetEmotePrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.GetEmotePrefixRequest")
	proto.RegisterType((*GetEmotePrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.GetEmotePrefixResponse")
	proto.RegisterType((*GetEmoticonPrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.GetEmoticonPrefixRequest")
	proto.RegisterType((*GetEmoticonPrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.GetEmoticonPrefixResponse")
	proto.RegisterType((*CreateEmoticonRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateEmoticonRequest")
	proto.RegisterType((*CreateEmoticonReponse)(nil), "code.justin.tv.revenue.subscriptions.CreateEmoticonReponse")
	proto.RegisterType((*DeleteEmoticonRequest)(nil), "code.justin.tv.revenue.subscriptions.DeleteEmoticonRequest")
	proto.RegisterType((*DeleteEmoticonResponse)(nil), "code.justin.tv.revenue.subscriptions.DeleteEmoticonResponse")
	proto.RegisterType((*GetAllEmoticonsByProductIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetAllEmoticonsByProductIDsRequest")
	proto.RegisterType((*GetAllEmoticonsByProductIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetAllEmoticonsByProductIDsResponse")
	proto.RegisterType((*EmoticonGroup)(nil), "code.justin.tv.revenue.subscriptions.EmoticonGroup")
	proto.RegisterType((*Emoticon)(nil), "code.justin.tv.revenue.subscriptions.Emoticon")
	proto.RegisterType((*GetPartnerStandingRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPartnerStandingRequest")
	proto.RegisterType((*GetPartnerStandingResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPartnerStandingResponse")
	proto.RegisterType((*SubmitEmoticonPrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.SubmitEmoticonPrefixRequest")
	proto.RegisterType((*SubmitEmoticonPrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.SubmitEmoticonPrefixResponse")
	proto.RegisterType((*GetPendingEmoticonsByIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsByIDsRequest")
	proto.RegisterType((*GetPendingEmoticonsByIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsByIDsResponse")
	proto.RegisterType((*GetPendingEmoticonsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsRequest")
	proto.RegisterType((*GetPendingEmoticonsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsResponse")
	proto.RegisterType((*ReviewPendingEmoticonsRequest)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonsRequest")
	proto.RegisterType((*ReviewPendingEmoticonRequest)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonRequest")
	proto.RegisterType((*ReviewPendingEmoticonsResponse)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonsResponse")
	proto.RegisterType((*ReviewPendingEmoticonResponse)(nil), "code.justin.tv.revenue.subscriptions.ReviewPendingEmoticonResponse")
	proto.RegisterType((*EmoticonBucket)(nil), "code.justin.tv.revenue.subscriptions.EmoticonBucket")
	proto.RegisterType((*PendingEmoticon)(nil), "code.justin.tv.revenue.subscriptions.PendingEmoticon")
	proto.RegisterType((*Product)(nil), "code.justin.tv.revenue.subscriptions.Product")
	proto.RegisterType((*ProductInterval)(nil), "code.justin.tv.revenue.subscriptions.ProductInterval")
	proto.RegisterType((*GetProductsByIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByIDsRequest")
	proto.RegisterType((*GetProductsByIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByIDsResponse")
	proto.RegisterType((*GetProductsByNamesRequest)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByNamesRequest")
	proto.RegisterType((*GetProductsByNamesResponse)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByNamesResponse")
	proto.RegisterType((*GetChannelProductsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetChannelProductsRequest")
	proto.RegisterType((*GetChannelProductsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetChannelProductsResponse")
	proto.RegisterType((*UpdateProductRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateProductRequest")
	proto.RegisterType((*UpdateProductResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateProductResponse")
	proto.RegisterType((*UpdateChannelProductsRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateChannelProductsRequest")
	proto.RegisterType((*UpdateChannelProductsResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateChannelProductsResponse")
	proto.RegisterType((*GetTicketsForUserChannelRequest)(nil), "code.justin.tv.revenue.subscriptions.GetTicketsForUserChannelRequest")
	proto.RegisterType((*GetTicketsForUserChannelResponse)(nil), "code.justin.tv.revenue.subscriptions.GetTicketsForUserChannelResponse")
	proto.RegisterType((*TicketGrantData)(nil), "code.justin.tv.revenue.subscriptions.TicketGrantData")
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.Platform", Platform_name, Platform_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.SubscriptionType", SubscriptionType_name, SubscriptionType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.BadgeType", BadgeType_name, BadgeType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.GiftState", GiftState_name, GiftState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.DiscountType", DiscountType_name, DiscountType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.GiftType", GiftType_name, GiftType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonState", EmoticonState_name, EmoticonState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonPrefixState", EmoticonPrefixState_name, EmoticonPrefixState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonFilter", EmoticonFilter_name, EmoticonFilter_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ProductIntervalUnit", ProductIntervalUnit_name, ProductIntervalUnit_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ProductState", ProductState_name, ProductState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest_Filter", ListUserSubscriptionsRequest_Filter_name, ListUserSubscriptionsRequest_Filter_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.GetChannelSubscriptionsRequest_OrderBy", GetChannelSubscriptionsRequest_OrderBy_name, GetChannelSubscriptionsRequest_OrderBy_value)
}

func init() { proto.RegisterFile("twirp/subscriptions.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 7947 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x7d, 0x5b, 0x6c, 0x1b, 0xd9,
	0x95, 0x60, 0x17, 0x49, 0x49, 0xe4, 0x21, 0x25, 0x51, 0x65, 0x5b, 0x96, 0xe9, 0x77, 0xd9, 0xdd,
	0xe9, 0x68, 0x13, 0x35, 0x5a, 0xed, 0x7e, 0x3f, 0x6c, 0x4a, 0xa2, 0xd5, 0x6c, 0x5b, 0x8f, 0x2e,
	0x51, 0xed, 0x76, 0xa7, 0x93, 0x4a, 0x89, 0x75, 0x25, 0x57, 0x5c, 0xac, 0x62, 0x57, 0x15, 0x2d,
	0x29, 0xdb, 0x40, 0x16, 0xc8, 0x2e, 0xb2, 0xbb, 0xd9, 0x04, 0x59, 0x24, 0xbb, 0xd9, 0x47, 0x36,
	0x08, 0xb2, 0x48, 0x90, 0xfd, 0x0a, 0x10, 0x64, 0x81, 0x2c, 0xb2, 0x3f, 0x41, 0x30, 0x18, 0x60,
	0xe6, 0x23, 0x83, 0x19, 0x24, 0x18, 0x60, 0x3e, 0x02, 0x0c, 0x30, 0x18, 0x0c, 0x30, 0x18, 0x60,
	0xfe, 0x06, 0x33, 0x3f, 0x83, 0xfb, 0xa8, 0x27, 0xab, 0xc8, 0x5b, 0xa4, 0xdc, 0x93, 0xc7, 0x8f,
	0xad, 0x7b, 0xea, 0xde, 0x73, 0xcf, 0x3d, 0xe7, 0xdc, 0x73, 0xcf, 0x7d, 0x9c, 0x43, 0x38, 0xe7,
	0x1e, 0xea, 0x76, 0xf7, 0x19, 0xa7, 0xb7, 0xe7, 0xb4, 0x6d, 0xbd, 0xeb, 0xea, 0x96, 0xe9, 0x2c,
	0x75, 0x6d, 0xcb, 0xb5, 0xc4, 0xeb, 0x6d, 0x4b, 0x43, 0x4b, 0x9f, 0xeb, 0x39, 0xae, 0x6e, 0x2e,
	0xb9, 0x8f, 0x96, 0x6c, 0xf4, 0x08, 0x99, 0x3d, 0xb4, 0x14, 0xa9, 0x5b, 0xbb, 0x7c, 0x60, 0x59,
	0x07, 0x06, 0x7a, 0x86, 0xb4, 0xd9, 0xeb, 0xed, 0x3f, 0xe3, 0xea, 0x1d, 0xe4, 0xb8, 0x6a, 0xa7,
	0x4b, 0xd1, 0x48, 0xff, 0x55, 0x80, 0xab, 0x8d, 0x8e, 0xaa, 0x1b, 0xdb, 0xc8, 0xd4, 0x74, 0xf3,
	0x60, 0xdb, 0x46, 0xfb, 0xfa, 0x51, 0xbd, 0xdb, 0xb5, 0xad, 0x47, 0xaa, 0x21, 0xa3, 0x0f, 0x7a,
	0xc8, 0x71, 0xc5, 0xb3, 0x30, 0xd5, 0x73, 0x90, 0xad, 0xe8, 0xda, 0x82, 0x70, 0x45, 0x78, 0xba,
	0x24, 0x4f, 0xe2, 0x62, 0x53, 0x13, 0xe7, 0x61, 0xb2, 0x4b, 0x5a, 0x2c, 0xe4, 0x28, 0x9c, 0x96,
	0xc4, 0xd3, 0x30, 0xe1, 0xb8, 0xaa, 0x8b, 0x16, 0xf2, 0x04, 0x4c, 0x0b, 0xe2, 0x22, 0xcc, 0xa2,
	0x8e, 0xe5, 0xea, 0x6d, 0xcb, 0x54, 0x1c, 0xe4, 0x62, 0x74, 0x05, 0xfc, 0x7d, 0x25, 0xb7, 0x20,
	0xc8, 0xd3, 0xde, 0xa7, 0x1d, 0xe4, 0x36, 0x35, 0xe9, 0x3a, 0x48, 0x83, 0xe8, 0x72, 0xba, 0x96,
	0xe9, 0x20, 0xc9, 0x85, 0xb3, 0xa4, 0xd6, 0xba, 0x61, 0xed, 0xa9, 0x46, 0xa3, 0x63, 0xb9, 0xc8,
	0xa3, 0xf9, 0x22, 0x80, 0x75, 0x68, 0x22, 0x5b, 0x31, 0xd5, 0x0e, 0x62, 0x64, 0x97, 0x08, 0x64,
	0x53, 0xed, 0x20, 0xf1, 0x32, 0x94, 0xe9, 0x67, 0x84, 0xdb, 0x33, 0xf2, 0x69, 0x0b, 0x82, 0x51,
	0x3c, 0x07, 0x45, 0x4c, 0x11, 0xc2, 0x54, 0xd2, 0x51, 0x4c, 0x91, 0x72, 0x53, 0x93, 0x6a, 0xb0,
	0xd0, 0xdf, 0x2b, 0xa3, 0x68, 0x8f, 0x51, 0xb4, 0x43, 0xe5, 0xb0, 0x87, 0x6c, 0x27, 0x44, 0x51,
	0xfb, 0x81, 0x6a, 0x9a, 0xc8, 0x08, 0x18, 0x59, 0x62, 0x90, 0xa6, 0x86, 0x79, 0xe6, 0xea, 0xae,
	0x81, 0x18, 0x2d, 0xb4, 0x20, 0x8a, 0x50, 0x70, 0xd1, 0x91, 0xcb, 0x48, 0x20, 0x7f, 0xfb, 0xfd,
	0x47, 0xfa, 0x60, 0xfd, 0x7f, 0x0a, 0xa6, 0x1b, 0x8c, 0x91, 0x77, 0xd1, 0x23, 0x64, 0x88, 0xd7,
	0x60, 0xba, 0xa3, 0x9b, 0x7a, 0xa7, 0xd7, 0x51, 0x9c, 0xb6, 0x65, 0x53, 0x56, 0xe4, 0xe5, 0x0a,
	0x03, 0xee, 0x60, 0x98, 0xf8, 0x24, 0xcc, 0xf8, 0x92, 0x31, 0xf4, 0x8e, 0xee, 0x12, 0x22, 0xf2,
	0x81, 0x50, 0xee, 0x62, 0xa0, 0xf4, 0x29, 0x98, 0xdd, 0x41, 0x2e, 0x69, 0xc2, 0x39, 0xa8, 0x8f,
	0x43, 0xd5, 0xf1, 0xa9, 0x64, 0x04, 0x50, 0xd4, 0xb3, 0x01, 0x9c, 0x20, 0x94, 0x7e, 0x22, 0x40,
	0x35, 0xc0, 0x4e, 0x87, 0x93, 0xd8, 0x5e, 0x48, 0x6c, 0xcf, 0x39, 0x06, 0x51, 0x06, 0x30, 0xd1,
	0x91, 0xab, 0x18, 0x98, 0x3b, 0x84, 0xad, 0xe5, 0xe5, 0xe7, 0x96, 0x78, 0x66, 0xd3, 0x52, 0x84,
	0xb1, 0x72, 0x09, 0xa3, 0x21, 0x7f, 0x4a, 0xff, 0xaf, 0x00, 0x73, 0x3b, 0xa1, 0xaa, 0xab, 0x56,
	0xcf, 0x74, 0xc9, 0x24, 0x08, 0x11, 0x4c, 0x0b, 0xb1, 0xfe, 0x73, 0x27, 0xd1, 0xbf, 0xe8, 0xc2,
	0x6c, 0x1b, 0x77, 0xa9, 0xec, 0xd9, 0x48, 0x7d, 0xa8, 0x59, 0x87, 0xe6, 0x42, 0xfe, 0x4a, 0xfe,
	0xe9, 0xf2, 0xf2, 0x1d, 0x3e, 0xc4, 0x7d, 0xb4, 0x2f, 0x91, 0x7f, 0x57, 0x3c, 0x6c, 0x0d, 0xd3,
	0xb5, 0x8f, 0xe5, 0x99, 0x76, 0x04, 0x88, 0x7b, 0x25, 0x43, 0x0a, 0xf5, 0x5a, 0x18, 0xaf, 0x57,
	0x22, 0xc8, 0x78, 0xaf, 0x4e, 0x04, 0x28, 0x5e, 0x85, 0x8a, 0xab, 0xb7, 0x1f, 0x22, 0x57, 0x21,
	0xe4, 0x2c, 0x4c, 0x10, 0xe6, 0x96, 0x29, 0x8c, 0x32, 0xbe, 0x5f, 0x13, 0x26, 0x13, 0x34, 0xa1,
	0x56, 0x87, 0x53, 0x09, 0xc3, 0x14, 0xab, 0x90, 0x7f, 0x88, 0x8e, 0x99, 0x2a, 0xe3, 0x3f, 0xb1,
	0x20, 0x1f, 0xa9, 0x46, 0xcf, 0xd3, 0x5c, 0x5a, 0x78, 0x25, 0xf7, 0x92, 0x80, 0x51, 0x24, 0xd0,
	0x9c, 0x05, 0x85, 0x74, 0x0b, 0x2e, 0xaf, 0xaa, 0x46, 0xbb, 0x67, 0xa8, 0x2e, 0x0a, 0x26, 0x34,
	0x21, 0x8c, 0x6f, 0x8e, 0x49, 0x9f, 0x87, 0x2b, 0xe9, 0x18, 0xd8, 0x3c, 0x7a, 0x07, 0x00, 0x33,
	0x9f, 0xf1, 0x4c, 0x20, 0x5a, 0xf7, 0xe2, 0x88, 0x62, 0x92, 0x4b, 0xb8, 0x02, 0xf9, 0x53, 0x7a,
	0x16, 0xe6, 0xd7, 0x91, 0xbb, 0xeb, 0x20, 0x7b, 0x07, 0xb9, 0xae, 0x6e, 0x1e, 0x38, 0xc3, 0xd6,
	0x0c, 0xe9, 0x67, 0x02, 0x9c, 0xed, 0x6b, 0xc3, 0xc8, 0x5c, 0x83, 0xcb, 0x07, 0xfa, 0xbe, 0xeb,
	0x28, 0xba, 0xa9, 0xec, 0x5b, 0x86, 0x61, 0x1d, 0x22, 0x4d, 0x61, 0x23, 0x75, 0x14, 0xcb, 0x34,
	0x28, 0x53, 0x8b, 0xf2, 0x79, 0x52, 0xad, 0x69, 0xde, 0x66, 0x95, 0x56, 0x59, 0x9d, 0x2d, 0xd3,
	0x38, 0x16, 0x9f, 0x82, 0xd9, 0x07, 0xba, 0x86, 0x14, 0x5c, 0x87, 0x8d, 0x38, 0x47, 0x5a, 0x4d,
	0x63, 0xf0, 0xba, 0xbe, 0xcf, 0xf4, 0xe4, 0x25, 0x58, 0x20, 0xf5, 0xc2, 0xe3, 0x55, 0xf0, 0x52,
	0xd5, 0x73, 0x88, 0x61, 0x28, 0xca, 0xf3, 0xf8, 0x7b, 0x98, 0x01, 0x3b, 0xe4, 0xab, 0xf4, 0xc7,
	0x79, 0x98, 0xdf, 0xc9, 0x36, 0x6e, 0x9e, 0xb1, 0xe5, 0x86, 0x8f, 0xed, 0x4b, 0x02, 0x7c, 0xcc,
	0x46, 0x6d, 0xa4, 0x3f, 0xa2, 0xe3, 0x1b, 0x84, 0x8e, 0x1a, 0xb7, 0x65, 0x3e, 0x31, 0x6f, 0x91,
	0xff, 0x55, 0x63, 0xc5, 0xb2, 0x0c, 0x59, 0x62, 0x5d, 0xac, 0x0f, 0xa0, 0xe4, 0xbd, 0x7e, 0x2e,
	0x17, 0x46, 0xee, 0x30, 0x26, 0x19, 0x63, 0x80, 0x64, 0x26, 0x46, 0xee, 0x24, 0x4d, 0x9a, 0x58,
	0x23, 0x77, 0x7e, 0xcb, 0x35, 0xf2, 0x3a, 0x54, 0xc2, 0x63, 0x0d, 0x0c, 0x0e, 0xa5, 0x8e, 0x16,
	0xa4, 0xbf, 0xcb, 0x41, 0x25, 0xdc, 0x58, 0x9c, 0x81, 0x9c, 0xaf, 0xa8, 0x39, 0x5d, 0x8b, 0x99,
	0x9a, 0x5c, 0x7c, 0x39, 0x3f, 0x07, 0x45, 0xea, 0x35, 0x05, 0x4e, 0x11, 0x29, 0x37, 0x49, 0xcb,
	0xae, 0x6d, 0x69, 0xbd, 0x76, 0xe0, 0xd7, 0xc9, 0x25, 0x06, 0x69, 0x6a, 0xe2, 0x79, 0x28, 0x59,
	0xb6, 0x7e, 0xa0, 0x9b, 0xf8, 0xeb, 0x04, 0xf9, 0x5a, 0xa4, 0x80, 0xa6, 0x26, 0xde, 0x84, 0xe9,
	0x3d, 0x64, 0xa2, 0x7d, 0xdd, 0xc5, 0x83, 0xb5, 0xa9, 0xbd, 0x2e, 0x2f, 0xd7, 0x96, 0xa8, 0xfb,
	0xba, 0xe4, 0xb9, 0xaf, 0x4b, 0x2d, 0xcf, 0x7d, 0x95, 0x2b, 0xac, 0xc1, 0x0e, 0xae, 0x2f, 0xbe,
	0x0a, 0x65, 0x0f, 0x01, 0x32, 0xb5, 0x85, 0xa9, 0xa1, 0xcd, 0x81, 0x55, 0x6f, 0x98, 0x1a, 0x76,
	0x05, 0xd5, 0x76, 0x1b, 0x39, 0x8e, 0x72, 0xd0, 0xd3, 0xb5, 0x85, 0x22, 0x75, 0x05, 0x29, 0x68,
	0xbd, 0xa7, 0x6b, 0xe2, 0xcb, 0x00, 0xbd, 0xae, 0xa6, 0xba, 0x48, 0x53, 0x2c, 0x73, 0xa1, 0x34,
	0x14, 0x79, 0x89, 0xd5, 0xde, 0x32, 0xa5, 0x3a, 0x54, 0x6f, 0x5b, 0x76, 0x07, 0xd9, 0x81, 0x61,
	0xce, 0xc8, 0x73, 0xe9, 0xbb, 0x79, 0xa8, 0xdd, 0xee, 0x19, 0xfb, 0xba, 0x61, 0x84, 0x45, 0xe7,
	0xd9, 0x9b, 0xb0, 0x48, 0x84, 0x41, 0x22, 0xc9, 0x0d, 0x14, 0x49, 0x7e, 0x98, 0x48, 0x0a, 0xe3,
	0x89, 0x64, 0x22, 0x93, 0x48, 0xde, 0x82, 0x62, 0xd7, 0x50, 0xdd, 0x7d, 0xcb, 0xee, 0x10, 0x5d,
	0x98, 0x59, 0x5e, 0xe2, 0x9b, 0xef, 0xdb, 0xac, 0x95, 0xec, 0xb7, 0x17, 0xdb, 0x30, 0x17, 0x99,
	0x4e, 0xee, 0x71, 0x17, 0x11, 0x0d, 0x99, 0x59, 0x7e, 0x21, 0xfb, 0x0a, 0xd8, 0x3a, 0xee, 0x22,
	0xb9, 0xea, 0xc4, 0x20, 0x52, 0x0f, 0xce, 0x27, 0xca, 0xc8, 0x5f, 0x7e, 0x2b, 0xe1, 0x26, 0x6c,
	0x01, 0x5e, 0xce, 0xde, 0xbd, 0x1c, 0xc1, 0x23, 0xfd, 0x32, 0x07, 0xe7, 0x56, 0x6d, 0x14, 0x2c,
	0xfc, 0xbf, 0xfb, 0xaa, 0x91, 0x28, 0xce, 0xc9, 0x13, 0x16, 0xa7, 0x0b, 0xb5, 0x24, 0xb6, 0x3e,
	0x66, 0x69, 0xda, 0x70, 0x6e, 0x55, 0x35, 0xdb, 0xe8, 0x23, 0x9c, 0xe7, 0xd2, 0x05, 0xa8, 0x25,
	0xf5, 0xc9, 0x76, 0x93, 0xff, 0x5f, 0x80, 0x73, 0xbb, 0xc4, 0x98, 0x25, 0x91, 0x54, 0x0d, 0x0c,
	0xd9, 0x9b, 0x4f, 0x10, 0x53, 0x76, 0x8b, 0x3a, 0xbe, 0x74, 0x57, 0xf3, 0x09, 0x6e, 0x86, 0xdc,
	0x41, 0xc7, 0x6f, 0x3e, 0x41, 0x1d, 0xe5, 0x98, 0x6e, 0xe4, 0xb3, 0xe8, 0xc6, 0xca, 0x4c, 0x54,
	0x30, 0x78, 0x70, 0x49, 0xd4, 0xb3, 0xc1, 0xfd, 0x9b, 0x1c, 0x9c, 0x5a, 0x55, 0x4d, 0xdf, 0x32,
	0x8f, 0xcf, 0xe9, 0xb0, 0xd9, 0xca, 0x3f, 0x0e, 0xb3, 0x55, 0x38, 0x61, 0x3d, 0x7f, 0x15, 0x4e,
	0x47, 0x39, 0xc0, 0x34, 0xfc, 0x1a, 0x4c, 0xb7, 0x55, 0x53, 0xf1, 0xb7, 0xd8, 0xcc, 0x8b, 0xa8,
	0xb4, 0x43, 0x95, 0xa5, 0xff, 0x22, 0xc0, 0x79, 0xca, 0xde, 0x16, 0xd9, 0x7c, 0x6d, 0x51, 0x9d,
	0x5a, 0xf3, 0xf8, 0x78, 0x1e, 0x4a, 0x6c, 0xa7, 0xe6, 0x33, 0xb2, 0x48, 0x01, 0x4d, 0x4d, 0x94,
	0x60, 0xda, 0x44, 0x87, 0x4a, 0xa0, 0x98, 0x94, 0x99, 0x65, 0x13, 0x1d, 0x6e, 0x79, 0x86, 0xe6,
	0x79, 0x38, 0x8b, 0xeb, 0x74, 0x7b, 0x76, 0xfb, 0x81, 0xea, 0x20, 0xa5, 0x6b, 0x5b, 0xfb, 0xba,
	0xe1, 0x9f, 0xc8, 0xe4, 0xe5, 0xd3, 0x26, 0x3a, 0xdc, 0x66, 0x5f, 0xb7, 0xe9, 0xc7, 0xa6, 0x26,
	0x5d, 0x82, 0x0b, 0xc9, 0x64, 0x31, 0xb9, 0xff, 0x22, 0x07, 0x17, 0xee, 0xea, 0x0e, 0xf5, 0xf7,
	0xc2, 0x1c, 0xe3, 0x50, 0x80, 0xd3, 0x30, 0x11, 0x3e, 0x5b, 0xa0, 0x05, 0x71, 0x1e, 0x26, 0xdb,
	0x3d, 0xdb, 0xb1, 0x6c, 0x36, 0xbd, 0x58, 0x29, 0xa2, 0x0f, 0x85, 0x31, 0xf5, 0x41, 0x85, 0xc9,
	0x7d, 0xdd, 0x70, 0x91, 0x4d, 0xec, 0xe5, 0xcc, 0x72, 0x93, 0x0f, 0xd3, 0xa0, 0x81, 0x2e, 0xdd,
	0x26, 0x08, 0x65, 0x86, 0x58, 0x7a, 0x11, 0x26, 0x29, 0x44, 0x9c, 0x82, 0x7c, 0xfd, 0xee, 0xdd,
	0xea, 0x13, 0x62, 0x05, 0x8a, 0xdb, 0x77, 0xeb, 0xad, 0xdb, 0x5b, 0xf2, 0x46, 0x55, 0x10, 0x8b,
	0x50, 0x58, 0x6f, 0xde, 0x6e, 0x55, 0x73, 0x18, 0xbe, 0xb9, 0xd5, 0xda, 0x96, 0x9b, 0x1b, 0x8d,
	0x6a, 0x5e, 0x32, 0xe1, 0x9a, 0xd7, 0x4f, 0xe3, 0xa8, 0xab, 0xdb, 0x48, 0x3b, 0x31, 0xbe, 0x5a,
	0xfb, 0xfb, 0x0e, 0x72, 0x99, 0xbc, 0x59, 0x49, 0xea, 0xc0, 0xb3, 0x6c, 0x07, 0xc9, 0xbc, 0xec,
	0x70, 0x77, 0xf7, 0x74, 0xf7, 0xc1, 0xb6, 0x7a, 0xdc, 0x41, 0xa6, 0xeb, 0xac, 0xa9, 0xae, 0xca,
	0x37, 0xad, 0x07, 0x79, 0x60, 0x9f, 0x86, 0xab, 0xe9, 0xdd, 0x8d, 0x8f, 0xfe, 0x6f, 0x0b, 0x50,
	0x8d, 0x8b, 0x48, 0xfc, 0x18, 0xcc, 0x46, 0xa6, 0xbf, 0x8f, 0x75, 0x26, 0x0c, 0x8e, 0xb9, 0xe4,
	0xb9, 0x41, 0xd6, 0x2a, 0x3f, 0x70, 0x5d, 0x28, 0x0c, 0x5b, 0xe4, 0x27, 0xc6, 0x5b, 0xe4, 0x27,
	0x47, 0xf6, 0xff, 0xa6, 0xc6, 0x9c, 0x38, 0x2f, 0x42, 0xc9, 0x46, 0x26, 0x3a, 0x74, 0x14, 0xd5,
	0x25, 0xce, 0xfd, 0x60, 0x32, 0x8a, 0xb4, 0x72, 0xdd, 0x15, 0x9f, 0x86, 0x2a, 0x3a, 0x72, 0x03,
	0xf3, 0xe3, 0x3c, 0xec, 0x11, 0xe7, 0xbf, 0x24, 0xcf, 0xa0, 0x23, 0xd7, 0xb3, 0x3b, 0x3b, 0x0f,
	0x7b, 0x58, 0x06, 0xba, 0xa3, 0x74, 0x6d, 0xbd, 0x83, 0x16, 0x80, 0x58, 0xca, 0x29, 0xdd, 0xd9,
	0xc6, 0x45, 0xf1, 0x2c, 0x4c, 0xe9, 0x0e, 0xd9, 0xf7, 0x2d, 0x94, 0xc9, 0x97, 0x49, 0xdd, 0xc1,
	0xfb, 0x3d, 0x6c, 0x62, 0x75, 0x47, 0xb1, 0xd1, 0x7e, 0xcf, 0xd4, 0xd4, 0x3d, 0x03, 0x2d, 0x54,
	0xa8, 0x89, 0xd5, 0x1d, 0xd9, 0x87, 0xb1, 0xd6, 0x9a, 0x69, 0x6b, 0x0b, 0xd3, 0x5e, 0xeb, 0x35,
	0xd3, 0x8e, 0x6f, 0x49, 0x66, 0xb2, 0x6c, 0x49, 0xfe, 0x93, 0x00, 0xf3, 0x71, 0x75, 0x93, 0x91,
	0xd3, 0x33, 0x5c, 0xf1, 0xbd, 0x44, 0xc7, 0x86, 0x73, 0xb9, 0xe9, 0xc3, 0x19, 0xc1, 0x15, 0xb2,
	0x91, 0xb9, 0xb0, 0x8d, 0x94, 0xfe, 0xad, 0x00, 0x62, 0x02, 0x29, 0x8f, 0xc9, 0xc7, 0x4a, 0x25,
	0xe3, 0x57, 0x02, 0x5c, 0x1f, 0x6c, 0xc3, 0xd8, 0xd2, 0xf8, 0x19, 0x98, 0x8e, 0x74, 0xb6, 0x20,
	0x90, 0x33, 0xcf, 0x97, 0x46, 0xa0, 0x8c, 0x8c, 0x54, 0x8e, 0xa2, 0x13, 0x17, 0x61, 0xee, 0x81,
	0x8a, 0x95, 0x09, 0x3d, 0xd2, 0xad, 0x9e, 0xa3, 0x74, 0xd5, 0x03, 0xc4, 0x0e, 0x0b, 0x66, 0x1f,
	0xa8, 0xce, 0x36, 0x83, 0x6f, 0xab, 0x07, 0x08, 0x2f, 0xa2, 0xb8, 0x2e, 0x39, 0x4f, 0x26, 0xf5,
	0xe8, 0x19, 0x41, 0xf9, 0x81, 0xea, 0x6c, 0x62, 0x15, 0x55, 0x0f, 0x90, 0xf4, 0x87, 0x02, 0x5c,
	0x4c, 0x59, 0x04, 0x7c, 0x77, 0x76, 0xca, 0x26, 0xa4, 0x78, 0x63, 0x79, 0x6d, 0x44, 0x81, 0xd3,
	0xf1, 0x78, 0xc8, 0x4e, 0x7c, 0x24, 0x5f, 0x13, 0x60, 0x39, 0x8b, 0xd9, 0x67, 0xc3, 0x7b, 0x8c,
	0x4a, 0x2d, 0x7d, 0x08, 0xd2, 0xa0, 0x95, 0xe1, 0x31, 0xef, 0x17, 0x3e, 0xeb, 0xf7, 0xbe, 0x4d,
	0x8d, 0x7a, 0xd6, 0x55, 0xf7, 0x32, 0x94, 0x83, 0x05, 0xc2, 0x59, 0xc8, 0x5d, 0xc9, 0x3f, 0x5d,
	0x92, 0xc1, 0x5f, 0x21, 0x1c, 0xe9, 0x0b, 0x70, 0x6d, 0x60, 0x0f, 0x6c, 0x80, 0xef, 0x26, 0xcf,
	0x89, 0x51, 0x46, 0x18, 0x45, 0x24, 0x75, 0x7d, 0x91, 0x27, 0x11, 0x30, 0xc2, 0x52, 0x3f, 0x74,
	0xc8, 0x5f, 0x17, 0xe0, 0xb9, 0x4c, 0x5d, 0x32, 0x1e, 0xbc, 0x9f, 0xcc, 0x83, 0x51, 0xf5, 0x2c,
	0xc6, 0x87, 0x97, 0xe0, 0xbc, 0x77, 0x66, 0x9e, 0x4d, 0xc6, 0xd2, 0x11, 0x5c, 0x48, 0x6e, 0xf9,
	0xd8, 0x65, 0xf7, 0x4f, 0x02, 0x5c, 0x5a, 0x47, 0x6e, 0xc2, 0xcc, 0xc8, 0x70, 0x25, 0x1a, 0x78,
	0x85, 0x13, 0xc9, 0x5e, 0xe1, 0x84, 0xe7, 0x15, 0x8a, 0x07, 0x50, 0xb4, 0x6c, 0x0d, 0xd9, 0xca,
	0xde, 0x31, 0xf3, 0xb6, 0xef, 0xf2, 0x0d, 0x62, 0x30, 0x91, 0x4b, 0x5b, 0x18, 0xe9, 0xca, 0xb1,
	0x3c, 0x65, 0xd1, 0x3f, 0xa4, 0x6b, 0x30, 0xc5, 0x60, 0xd8, 0x23, 0xde, 0xdc, 0xda, 0x6c, 0x54,
	0x9f, 0x10, 0x67, 0x00, 0x76, 0xb7, 0xd7, 0xea, 0xad, 0xc6, 0x9a, 0x52, 0x6f, 0x55, 0x05, 0xe9,
	0x5f, 0xc3, 0xe5, 0x54, 0xbc, 0x8f, 0x9d, 0xf5, 0x9f, 0x23, 0xea, 0x12, 0x3f, 0x79, 0x7c, 0x2c,
	0x6c, 0x97, 0xfe, 0x46, 0x20, 0x1a, 0x96, 0xd0, 0x19, 0x1b, 0xe6, 0x65, 0x28, 0xbb, 0x96, 0xab,
	0x1a, 0xa1, 0xcb, 0xa7, 0x09, 0x19, 0x08, 0x88, 0x9e, 0x7a, 0xbf, 0x0b, 0xe5, 0xe0, 0x32, 0x97,
	0xce, 0x49, 0xee, 0x89, 0x13, 0xef, 0x56, 0x0e, 0xa3, 0x4a, 0x5e, 0x82, 0xf2, 0x9c, 0x4b, 0x50,
	0xa1, 0x7f, 0x09, 0xfa, 0x92, 0x00, 0xb5, 0x75, 0x14, 0xb1, 0x08, 0x2b, 0xc7, 0xc1, 0x8e, 0x77,
	0x1d, 0xa6, 0x9c, 0xde, 0x9e, 0xe2, 0xdd, 0xfd, 0x65, 0x3f, 0x02, 0x99, 0x74, 0xc8, 0x5f, 0xec,
	0x64, 0x25, 0x17, 0x9c, 0xac, 0xf4, 0x1d, 0x6d, 0xf4, 0x88, 0x84, 0xfb, 0x09, 0x79, 0xcc, 0x4b,
	0xce, 0x22, 0xb9, 0xef, 0xa3, 0x1b, 0x6b, 0x07, 0xf7, 0xe8, 0x04, 0x87, 0x41, 0x79, 0x6c, 0x50,
	0x05, 0x62, 0x50, 0xf1, 0x9f, 0x92, 0x43, 0xee, 0xf9, 0xa2, 0x75, 0x1f, 0xbb, 0xe6, 0xbf, 0x46,
	0xa6, 0xdd, 0x9b, 0xba, 0xe3, 0x5a, 0xb6, 0xde, 0x56, 0x0d, 0x6c, 0xf8, 0x18, 0x09, 0x1c, 0xc6,
	0xf2, 0x43, 0xb8, 0x92, 0xde, 0xfa, 0xb1, 0xd3, 0xfe, 0x10, 0xce, 0xb4, 0xd4, 0x87, 0x48, 0xb3,
	0x0e, 0xcd, 0x15, 0x55, 0x3b, 0x40, 0xbc, 0xf3, 0xf5, 0x3c, 0x94, 0xf6, 0x70, 0xfd, 0xd0, 0x8a,
	0x56, 0x24, 0x80, 0xa6, 0xe6, 0xe0, 0x69, 0x6b, 0x23, 0xd5, 0xb1, 0x4c, 0xef, 0x6c, 0x82, 0x96,
	0xa4, 0x9b, 0x30, 0x1f, 0xef, 0x8c, 0x0d, 0xf0, 0x49, 0x98, 0x21, 0xad, 0xf1, 0xee, 0xa4, 0x63,
	0x3d, 0x42, 0x1a, 0x13, 0xea, 0xf4, 0x1e, 0xab, 0x47, 0x80, 0xd2, 0xdb, 0xb0, 0xe0, 0x21, 0xa8,
	0x1b, 0x46, 0x26, 0x82, 0x03, 0x9a, 0x72, 0x11, 0x9a, 0x56, 0xe0, 0x5c, 0x02, 0xca, 0x6c, 0x64,
	0x7d, 0x53, 0x80, 0x73, 0xc1, 0xcc, 0xd8, 0x43, 0x36, 0x41, 0xc3, 0x49, 0x58, 0xe8, 0xf2, 0x36,
	0x17, 0xb9, 0xbc, 0x5d, 0x81, 0x4b, 0xba, 0xa3, 0xb4, 0x7b, 0x9d, 0x9e, 0xa1, 0xba, 0xfa, 0x23,
	0xa4, 0xb8, 0xc8, 0xec, 0xd9, 0x48, 0x31, 0x2c, 0x55, 0x53, 0x5c, 0xe4, 0xb8, 0xcc, 0xaa, 0xd4,
	0x74, 0x67, 0xd5, 0xaf, 0xd4, 0x22, 0x75, 0xee, 0x5a, 0xaa, 0xd6, 0x42, 0x8e, 0x2b, 0xfd, 0x38,
	0x62, 0x3c, 0x02, 0xca, 0xd8, 0xf8, 0x36, 0x01, 0xa8, 0x14, 0xc9, 0x49, 0x9f, 0x40, 0x16, 0xb0,
	0x67, 0xf8, 0x94, 0x8a, 0x20, 0x22, 0x47, 0x7c, 0x54, 0x11, 0xf0, 0x9f, 0x78, 0x83, 0x49, 0xf1,
	0x3d, 0x42, 0xb6, 0xa3, 0xfb, 0xbc, 0xae, 0x10, 0xe0, 0x3b, 0x14, 0x26, 0x5e, 0x85, 0x8a, 0x76,
	0x6c, 0xaa, 0x1d, 0xbd, 0xad, 0x68, 0xaa, 0xab, 0x32, 0x1d, 0x29, 0x33, 0x18, 0x76, 0x70, 0xa4,
	0x17, 0xc9, 0x94, 0x67, 0x0b, 0x59, 0x06, 0x66, 0x4a, 0x88, 0xcc, 0xff, 0x68, 0x43, 0x36, 0xd6,
	0xb7, 0x60, 0x92, 0x4a, 0x2d, 0xdb, 0xe4, 0x89, 0xe0, 0x62, 0x18, 0xa4, 0xaf, 0x0a, 0x70, 0x6e,
	0x0d, 0x19, 0xc8, 0x45, 0xd9, 0x69, 0xc4, 0xb6, 0xc0, 0x9b, 0x3a, 0x6c, 0xb5, 0x9b, 0x62, 0x33,
	0x47, 0x7c, 0x11, 0x16, 0xbc, 0x96, 0x4c, 0xd8, 0x1d, 0xe4, 0x3e, 0xb0, 0xb4, 0xe0, 0x2c, 0xe5,
	0x0c, 0xfb, 0x4e, 0xe5, 0xbc, 0x41, 0xbe, 0x36, 0x35, 0xe9, 0x7f, 0x0a, 0x50, 0x4b, 0x22, 0x88,
	0x8d, 0x3d, 0xb8, 0xfe, 0x9b, 0x20, 0x67, 0xe6, 0x37, 0x60, 0xde, 0x46, 0x1f, 0xf4, 0xf0, 0x8e,
	0xd3, 0xef, 0xc8, 0x32, 0xdd, 0x07, 0x0e, 0x23, 0xe8, 0xb4, 0xf7, 0x95, 0x75, 0x43, 0xbe, 0x8d,
	0x4e, 0xdd, 0x7b, 0xf0, 0x24, 0xbd, 0xda, 0x08, 0x13, 0xb7, 0xdb, 0xc5, 0x8a, 0xbc, 0x6a, 0x99,
	0xfb, 0xfa, 0x01, 0x27, 0xe7, 0x44, 0x28, 0x38, 0xfa, 0xe7, 0x11, 0x23, 0x92, 0xfc, 0x2d, 0x7d,
	0x4b, 0x80, 0xa7, 0x86, 0x21, 0x67, 0x5c, 0xb8, 0x08, 0xd0, 0x23, 0x70, 0xa5, 0x67, 0x1b, 0x1e,
	0x76, 0x0a, 0xd9, 0xb5, 0x0d, 0x6c, 0xd2, 0xd8, 0x67, 0x7f, 0x2a, 0x16, 0x29, 0x80, 0xda, 0x3b,
	0xbd, 0xa3, 0x1e, 0x20, 0xd2, 0x94, 0x5d, 0x68, 0x10, 0x00, 0x6e, 0x79, 0x0e, 0xe8, 0xdf, 0xc1,
	0xa1, 0xd6, 0x14, 0x29, 0x37, 0x35, 0xe9, 0x4f, 0x04, 0xef, 0xb6, 0x6c, 0x04, 0x4d, 0xb9, 0x04,
	0x65, 0x8a, 0xf7, 0xd9, 0xa3, 0xd0, 0x29, 0x1e, 0x01, 0x3d, 0x7b, 0x14, 0xfe, 0xbe, 0x7c, 0x14,
	0x3a, 0x6d, 0x23, 0xa0, 0xe5, 0xc8, 0xf7, 0x1b, 0x47, 0xa1, 0x0b, 0x72, 0x02, 0xba, 0x81, 0xbf,
	0xa7, 0xab, 0xc1, 0x44, 0xba, 0x1a, 0x48, 0xdf, 0xcc, 0x79, 0x37, 0x55, 0x5c, 0xba, 0x76, 0x05,
	0x2a, 0xfe, 0x20, 0x30, 0xf3, 0xd8, 0xb3, 0x47, 0x36, 0x0a, 0xcc, 0x3e, 0xbf, 0xc6, 0xf2, 0x51,
	0x88, 0xbd, 0xc0, 0xc6, 0x11, 0xa9, 0x71, 0x83, 0xd6, 0x28, 0x84, 0x6a, 0xdc, 0x20, 0x35, 0x46,
	0x1a, 0x4a, 0xf0, 0xfe, 0x71, 0x32, 0xfc, 0xfe, 0x71, 0x90, 0x9e, 0x4f, 0x0d, 0xd2, 0xf3, 0x57,
	0xc8, 0x32, 0xd0, 0xd2, 0x3b, 0xc8, 0xea, 0xb9, 0xf4, 0x91, 0x04, 0xef, 0xfa, 0x24, 0xad, 0x12,
	0x43, 0xdd, 0xd7, 0xb6, 0x6f, 0x21, 0x72, 0x69, 0x0d, 0x76, 0x3b, 0xc2, 0x16, 0x22, 0xd6, 0x4c,
	0xfa, 0x0f, 0x39, 0xa8, 0x84, 0x85, 0xf2, 0xfb, 0x2c, 0x8c, 0x1f, 0x0b, 0x70, 0x7d, 0x1d, 0xb9,
	0x8d, 0x23, 0x17, 0xd9, 0xa6, 0x6a, 0xb0, 0x8d, 0x75, 0x0b, 0x75, 0xba, 0xe4, 0xd1, 0xda, 0x9d,
	0xdd, 0x90, 0x60, 0x42, 0x47, 0xd6, 0xc2, 0xa0, 0x0b, 0xb6, 0xdc, 0x98, 0xe7, 0xc2, 0x57, 0xa1,
	0x42, 0x36, 0x24, 0xf6, 0xb1, 0x82, 0x51, 0x78, 0x4b, 0x1f, 0x83, 0xad, 0x5a, 0x1a, 0x92, 0xde,
	0x80, 0x27, 0x87, 0x50, 0xcd, 0x54, 0xe2, 0x0c, 0x4c, 0x3a, 0x0f, 0x7b, 0x01, 0xc9, 0x13, 0xce,
	0xc3, 0x5e, 0x53, 0x93, 0xfe, 0x54, 0x80, 0x8f, 0xf5, 0x23, 0x60, 0x27, 0xc7, 0xea, 0x9e, 0x11,
	0x1e, 0xf9, 0x6f, 0xc6, 0xad, 0x63, 0x9c, 0x29, 0x85, 0x7e, 0xa6, 0xd4, 0xe1, 0xe9, 0xe1, 0x63,
	0x1a, 0xcc, 0x97, 0x6d, 0x98, 0xa4, 0x5b, 0x1e, 0x71, 0x01, 0xa6, 0xd8, 0x40, 0xbc, 0x41, 0xb3,
	0x22, 0xd6, 0x40, 0x32, 0x7e, 0xef, 0x39, 0x34, 0x29, 0x90, 0x4d, 0x28, 0xb9, 0xa2, 0xf0, 0xbc,
	0x59, 0x5a, 0x92, 0x7e, 0x95, 0x87, 0xf2, 0xb6, 0xaa, 0x6b, 0xbb, 0xdd, 0x03, 0x5b, 0xd5, 0x90,
	0xb8, 0x8e, 0xd7, 0x75, 0x07, 0x8d, 0xba, 0x15, 0xc3, 0x5e, 0x80, 0x83, 0x30, 0x81, 0x1b, 0x50,
	0xee, 0x51, 0x9c, 0xca, 0x88, 0x37, 0xdb, 0x32, 0x30, 0x04, 0x18, 0xdd, 0x93, 0x30, 0x83, 0x4c,
	0x32, 0x99, 0x3a, 0xc8, 0x0c, 0x5d, 0xcb, 0x4c, 0x87, 0xa0, 0x4d, 0x72, 0xbc, 0x4f, 0x6e, 0x5d,
	0xb0, 0x53, 0x86, 0x38, 0xde, 0x57, 0x94, 0x48, 0xed, 0x35, 0xd5, 0xa5, 0x0f, 0xc6, 0x75, 0x76,
	0x4b, 0x58, 0x92, 0xc9, 0xdf, 0x98, 0x97, 0x5d, 0x5b, 0x6f, 0xd3, 0xd9, 0x3c, 0x21, 0xd3, 0x02,
	0xd6, 0x38, 0xf2, 0x47, 0x30, 0x7b, 0xa7, 0x48, 0xb9, 0x99, 0xf2, 0xc8, 0xa2, 0x78, 0xb2, 0x97,
	0xcf, 0xec, 0x06, 0xa4, 0x4d, 0x5e, 0x1f, 0x90, 0x1b, 0x90, 0x92, 0x77, 0x03, 0xb2, 0xea, 0xc3,
	0xa4, 0xf7, 0x88, 0xf7, 0x19, 0x12, 0xad, 0x6f, 0xc3, 0x6f, 0x41, 0xe1, 0x21, 0x3a, 0xf6, 0x3c,
	0xc8, 0x6c, 0x22, 0x21, 0x2d, 0xa5, 0x0f, 0x88, 0x83, 0x1a, 0xc5, 0xed, 0xef, 0x9f, 0xa7, 0xbb,
	0xaa, 0xae, 0x29, 0x4c, 0x74, 0x5e, 0x2f, 0xcf, 0x72, 0x4e, 0xac, 0x00, 0xa5, 0x5c, 0xe9, 0x86,
	0xf0, 0xe3, 0xf5, 0x7a, 0x81, 0xae, 0xd7, 0xe1, 0x3a, 0xfe, 0xf1, 0xc1, 0x6f, 0xa6, 0xd2, 0x26,
	0x6a, 0x43, 0xfe, 0x84, 0x9f, 0x22, 0x7c, 0xe0, 0xf9, 0x66, 0x11, 0xc6, 0x30, 0x71, 0xb4, 0xa0,
	0x12, 0x16, 0x07, 0xe3, 0xce, 0x08, 0xd2, 0x28, 0x87, 0xa4, 0x21, 0xfd, 0x48, 0x80, 0x05, 0xaa,
	0x6a, 0xbf, 0x3d, 0xc2, 0x90, 0xce, 0x7b, 0x8f, 0x84, 0x12, 0xf8, 0x24, 0x7d, 0x3b, 0x0f, 0xe7,
	0xd8, 0x3b, 0xb4, 0x84, 0x21, 0xfd, 0x4e, 0xbe, 0x07, 0x0b, 0xcb, 0x69, 0x72, 0x1c, 0x39, 0x7d,
	0x24, 0xef, 0x04, 0x6d, 0xff, 0x2d, 0xe7, 0x47, 0xa7, 0xe6, 0xbf, 0xcc, 0x81, 0xe4, 0xef, 0x11,
	0xdc, 0x4d, 0xcb, 0xd5, 0xf7, 0xf5, 0xb6, 0x4a, 0x48, 0xb2, 0x1e, 0xa2, 0x13, 0x78, 0x60, 0xf6,
	0x3a, 0x54, 0xd4, 0x47, 0xaa, 0x4e, 0x0c, 0xb6, 0xa2, 0xba, 0x1c, 0x8f, 0xb6, 0xca, 0x7e, 0xfd,
	0xba, 0x2b, 0x6e, 0x84, 0x6e, 0xcf, 0x47, 0x7f, 0x41, 0xee, 0xdf, 0xb8, 0x1f, 0xc0, 0x29, 0x13,
	0x1d, 0x2a, 0xde, 0xd3, 0x23, 0xd3, 0x45, 0xf6, 0x23, 0xd5, 0x60, 0x5a, 0xc5, 0x19, 0xf3, 0xb0,
	0x89, 0x0e, 0xe9, 0xb1, 0x5f, 0x93, 0x35, 0x97, 0xe7, 0xcc, 0x38, 0x48, 0xba, 0x09, 0xd7, 0x06,
	0xb2, 0x95, 0x09, 0x75, 0x01, 0xa6, 0x3a, 0xc8, 0x71, 0xd4, 0x03, 0x2f, 0x0a, 0xcd, 0x2b, 0x4a,
	0x5f, 0x11, 0x60, 0xae, 0xaf, 0x27, 0xc2, 0x4d, 0xfa, 0x1c, 0x99, 0xce, 0x26, 0x81, 0x83, 0x9b,
	0xa4, 0x3e, 0x9d, 0x4c, 0x2f, 0x03, 0x7b, 0xba, 0x4c, 0xe6, 0x52, 0x6e, 0xb8, 0xeb, 0x40, 0x6b,
	0x37, 0x4c, 0x4d, 0xfa, 0x79, 0x0e, 0x2e, 0xef, 0x3a, 0x43, 0xb5, 0xc4, 0xc5, 0xe5, 0x90, 0x96,
	0x90, 0x72, 0x53, 0x13, 0xaf, 0xc3, 0x8c, 0xda, 0x73, 0x1f, 0x20, 0x4d, 0x89, 0x9e, 0xa1, 0x55,
	0x28, 0x74, 0x97, 0x9e, 0xa4, 0x3d, 0x09, 0x33, 0xed, 0x9e, 0xe3, 0x5a, 0x1d, 0xc5, 0xe3, 0x0a,
	0xf3, 0x80, 0x28, 0x74, 0x83, 0x02, 0xc5, 0x5d, 0xa8, 0x38, 0x0f, 0x54, 0x1b, 0x29, 0x8e, 0x6b,
	0x23, 0xf5, 0xe1, 0x18, 0x8a, 0x51, 0x26, 0x78, 0x76, 0x08, 0x9a, 0xd8, 0xc6, 0x6f, 0x22, 0xbe,
	0xc9, 0x1f, 0x7e, 0xcc, 0x37, 0x39, 0xf4, 0x98, 0xef, 0x35, 0xb8, 0x92, 0xce, 0xc4, 0xa1, 0x3a,
	0xb1, 0x01, 0x12, 0x35, 0xef, 0x03, 0xa5, 0xc0, 0xfb, 0x3a, 0x88, 0xe8, 0xe8, 0x20, 0x74, 0x43,
	0xe9, 0xf9, 0x81, 0x00, 0x8b, 0xd1, 0x2b, 0xee, 0x81, 0x84, 0xa5, 0x46, 0xbf, 0x0c, 0x09, 0x2c,
	0x38, 0x89, 0xf3, 0xd5, 0xef, 0x0a, 0xf0, 0xaf, 0xb8, 0x48, 0x65, 0x83, 0x76, 0xe0, 0x6c, 0xfb,
	0x81, 0xea, 0x2a, 0x66, 0xa8, 0x86, 0x42, 0x94, 0x99, 0xcd, 0xb9, 0x57, 0xb9, 0x4f, 0x25, 0x13,
	0x7a, 0xc1, 0x3b, 0xe1, 0x7e, 0xb0, 0xa4, 0x92, 0x1d, 0x61, 0xdd, 0x30, 0x76, 0x1d, 0x12, 0x23,
	0xd2, 0x5f, 0xc5, 0x19, 0x93, 0x97, 0xd2, 0x7f, 0x17, 0xc8, 0x0e, 0x6d, 0x48, 0x1f, 0x8c, 0x09,
	0x1d, 0xa8, 0xf6, 0x1c, 0x1a, 0xd2, 0xe2, 0xd2, 0xc1, 0x7b, 0xbe, 0xee, 0x2a, 0xf7, 0xcd, 0x75,
	0x72, 0x1f, 0x4d, 0x17, 0x75, 0xe4, 0x99, 0x1e, 0xfb, 0x4c, 0xbb, 0x95, 0xbe, 0x2d, 0xc0, 0x72,
	0xdd, 0x30, 0xac, 0x43, 0x19, 0x75, 0x0d, 0xf5, 0xf8, 0xb6, 0x65, 0xdf, 0x55, 0xc9, 0xdb, 0x14,
	0x6d, 0x8c, 0xb5, 0x69, 0x90, 0x62, 0xcd, 0xc3, 0x24, 0x55, 0x25, 0x6f, 0xc3, 0x48, 0x4b, 0x18,
	0x4e, 0xcf, 0x2e, 0xd8, 0x16, 0x97, 0x95, 0xa4, 0xe7, 0xe1, 0xb9, 0x4c, 0xf4, 0x31, 0xc7, 0xeb,
	0xcf, 0x04, 0x38, 0x93, 0x58, 0xa3, 0x2f, 0xda, 0x23, 0x34, 0xd5, 0x72, 0x91, 0xa9, 0x86, 0x77,
	0x69, 0xe4, 0x64, 0xc6, 0x0b, 0x9a, 0x26, 0x05, 0xbc, 0x9f, 0x7b, 0xa8, 0x9b, 0x1e, 0x99, 0xe4,
	0x6f, 0xf1, 0x05, 0x38, 0xdb, 0x3f, 0x55, 0x68, 0x5b, 0x7a, 0xa8, 0x73, 0xa6, 0x1d, 0x9b, 0x24,
	0xe4, 0x58, 0x47, 0x5c, 0x82, 0x53, 0xd4, 0x9c, 0x46, 0xdb, 0xd0, 0x5d, 0xe1, 0x1c, 0xfd, 0x14,
	0xaa, 0x2f, 0x7d, 0xa5, 0x00, 0x17, 0x07, 0xca, 0x37, 0xd8, 0xa5, 0x0b, 0xe1, 0x5d, 0xfa, 0x02,
	0x4c, 0x31, 0x09, 0x78, 0x63, 0x64, 0xc5, 0xac, 0xe2, 0xc0, 0x7b, 0x44, 0x46, 0x31, 0xb1, 0xe2,
	0xd4, 0x64, 0x17, 0xe5, 0x0a, 0x05, 0xee, 0x10, 0x98, 0x78, 0x15, 0x58, 0x59, 0xa1, 0x21, 0x4f,
	0x74, 0x3c, 0x65, 0x0a, 0x7b, 0x07, 0x83, 0xf0, 0xc8, 0xa3, 0xab, 0x8e, 0x42, 0xa2, 0xaa, 0xe9,
	0xb6, 0x77, 0x2e, 0xb2, 0xf4, 0xb4, 0xd0, 0x91, 0x2b, 0x2e, 0xc3, 0x99, 0x58, 0x7d, 0xd6, 0x7f,
	0x91, 0xf4, 0x7f, 0x2a, 0xd2, 0x82, 0x91, 0x11, 0x3a, 0xcb, 0x28, 0x45, 0xcf, 0x32, 0xbc, 0x3d,
	0x39, 0x84, 0xf6, 0xe4, 0xe1, 0x37, 0x83, 0xe5, 0xe8, 0x9b, 0xc1, 0xab, 0x50, 0x51, 0xb1, 0x0e,
	0x2a, 0x36, 0x51, 0x42, 0xf6, 0x32, 0xb0, 0xac, 0x06, 0x7a, 0x89, 0x57, 0xf9, 0x36, 0xf1, 0x3d,
	0x34, 0xec, 0x70, 0x4d, 0x0f, 0x5f, 0xe5, 0x59, 0xed, 0xba, 0x1b, 0x7e, 0x3a, 0xa8, 0xba, 0x19,
	0x9e, 0x0e, 0xd6, 0x5d, 0xe9, 0xcf, 0x73, 0x50, 0x20, 0x8f, 0x17, 0xe7, 0x61, 0xd2, 0x41, 0xa6,
	0xe6, 0xcb, 0x9d, 0x95, 0xc4, 0x0b, 0x50, 0xb2, 0x51, 0x5b, 0xef, 0xea, 0x88, 0x45, 0xb8, 0x95,
	0xe4, 0x00, 0x10, 0x66, 0x50, 0x3e, 0xca, 0xa0, 0xe0, 0x58, 0xa7, 0x10, 0x3e, 0xd6, 0x11, 0x1b,
	0x5e, 0x1e, 0x81, 0x89, 0x2c, 0xd7, 0x61, 0x98, 0xc4, 0x1d, 0xdc, 0xcc, 0x4b, 0x3c, 0xf0, 0x22,
	0x94, 0x48, 0xe4, 0x1d, 0x39, 0x4d, 0x19, 0xfe, 0x12, 0xb5, 0x88, 0x2b, 0x93, 0xc3, 0x94, 0x3b,
	0xac, 0x61, 0x68, 0x2f, 0xb0, 0xc4, 0x4f, 0x03, 0xd9, 0x03, 0x10, 0x64, 0xe4, 0xbc, 0xe3, 0x3c,
	0x94, 0x54, 0xd3, 0x32, 0xe9, 0x63, 0x50, 0xaa, 0x47, 0x45, 0x0c, 0xc0, 0x55, 0xa5, 0xfb, 0x30,
	0x85, 0xff, 0x1f, 0x7c, 0x26, 0x16, 0xb0, 0x29, 0x17, 0x61, 0x53, 0x84, 0xed, 0xf9, 0x18, 0xdb,
	0xa5, 0xbf, 0x12, 0x60, 0xae, 0x69, 0x3a, 0xc8, 0x76, 0x71, 0x0f, 0x9e, 0x49, 0xfd, 0xa8, 0x44,
	0x18, 0x61, 0xe1, 0xc4, 0x49, 0xb2, 0x70, 0x32, 0xc6, 0xc2, 0x16, 0x88, 0xe1, 0x61, 0xb2, 0x05,
	0xee, 0x0d, 0x28, 0x90, 0xda, 0x74, 0x49, 0x5f, 0xe4, 0xef, 0x5a, 0x26, 0xed, 0xa4, 0x36, 0xcc,
	0x51, 0x0f, 0x2a, 0xcc, 0xbc, 0x93, 0x16, 0x11, 0x02, 0x31, 0xdc, 0x09, 0x23, 0x7d, 0x8b, 0x44,
	0x61, 0xb4, 0x91, 0x81, 0x34, 0x65, 0xc4, 0x31, 0x54, 0x3c, 0x04, 0x8c, 0x43, 0xb3, 0xeb, 0x88,
	0xb0, 0xc7, 0x77, 0x32, 0xea, 0x91, 0x53, 0xb4, 0x4f, 0xf2, 0xa3, 0x0e, 0x8e, 0xd1, 0x5a, 0x50,
	0x0d, 0xb0, 0x32, 0xd2, 0x6f, 0xc1, 0x04, 0x89, 0x87, 0x65, 0x78, 0xb3, 0x90, 0x4c, 0x1b, 0x4a,
	0x9f, 0x85, 0x99, 0x55, 0xd5, 0x7c, 0x8c, 0x1a, 0x2b, 0x7d, 0x02, 0x66, 0xfd, 0x1e, 0x18, 0xd9,
	0xe7, 0xa0, 0xd8, 0x56, 0xcd, 0x80, 0xd9, 0x45, 0x79, 0xaa, 0x4d, 0xab, 0x48, 0x87, 0x34, 0x54,
	0x86, 0x74, 0x19, 0xa6, 0xea, 0x3c, 0x94, 0x28, 0x1d, 0xa1, 0x28, 0x17, 0x0a, 0x18, 0xbe, 0x71,
	0xbe, 0x06, 0xd3, 0x64, 0x6e, 0x7c, 0xd0, 0x53, 0x4d, 0x57, 0x77, 0x8f, 0xd9, 0xcb, 0xaa, 0x0a,
	0x06, 0xbe, 0xcd, 0x60, 0xd2, 0x32, 0x9c, 0x89, 0x75, 0x3c, 0x9c, 0xd8, 0x3f, 0x10, 0xe0, 0xac,
	0x3f, 0x36, 0xc6, 0x89, 0x93, 0x20, 0xf8, 0x2a, 0x54, 0x7c, 0xce, 0x06, 0x47, 0x41, 0x65, 0x1f,
	0xd6, 0xd4, 0xa2, 0xf3, 0xbd, 0x30, 0xde, 0x7c, 0x97, 0x36, 0xc8, 0x01, 0x5d, 0x6c, 0x18, 0x43,
	0x87, 0x9f, 0xfa, 0xbe, 0xe4, 0x6b, 0x02, 0x94, 0x71, 0x85, 0xad, 0xfd, 0x7d, 0x32, 0xda, 0xf4,
	0x69, 0x1c, 0x19, 0x45, 0x6e, 0x4c, 0xab, 0x55, 0x83, 0x62, 0x4c, 0xc2, 0x7e, 0x59, 0xfa, 0x79,
	0x1e, 0xa6, 0x71, 0x93, 0x6d, 0xdb, 0xea, 0x58, 0xe4, 0x85, 0xfa, 0x90, 0x2b, 0xb0, 0xf3, 0x50,
	0x22, 0x41, 0x51, 0xe4, 0x3c, 0x9f, 0x46, 0xcb, 0x14, 0x4d, 0x74, 0xb8, 0x4d, 0x8e, 0xf4, 0xcf,
	0x43, 0xc9, 0x32, 0x34, 0xf6, 0x91, 0xc6, 0xcc, 0x14, 0x2d, 0x43, 0xa3, 0x1f, 0xef, 0xc1, 0xb4,
	0xa6, 0x3b, 0x34, 0x51, 0x48, 0x48, 0x3a, 0x9c, 0x7b, 0xea, 0x35, 0xd6, 0x94, 0x8c, 0xad, 0xa2,
	0x85, 0x4a, 0x78, 0x4b, 0xef, 0x23, 0xa6, 0x1e, 0x18, 0x4d, 0xca, 0xe1, 0x77, 0x47, 0x7d, 0xb0,
	0xd3, 0x30, 0x81, 0x6c, 0xdb, 0xb2, 0xbd, 0x3b, 0x45, 0x52, 0x10, 0x9f, 0x82, 0x59, 0xf7, 0x81,
	0x6e, 0x6b, 0x4a, 0x57, 0xb5, 0xdd, 0x63, 0x12, 0x64, 0x41, 0xbd, 0xb2, 0x69, 0x02, 0xde, 0xc6,
	0xd0, 0x9d, 0x87, 0x3d, 0xac, 0x7a, 0x78, 0xdc, 0x3e, 0x23, 0x8b, 0xd4, 0xc9, 0x33, 0xd1, 0xa1,
	0x37, 0x53, 0x70, 0x15, 0x3c, 0x7a, 0xbf, 0x4a, 0x89, 0x56, 0xb1, 0x0c, 0xcd, 0xaf, 0xb2, 0xcb,
	0x66, 0x9c, 0x85, 0x35, 0x00, 0xf3, 0x17, 0xb2, 0x1c, 0xb1, 0x85, 0x74, 0x47, 0x2e, 0x1f, 0x04,
	0x05, 0xe9, 0x1f, 0x05, 0x28, 0xfd, 0xbe, 0x4a, 0x50, 0xfa, 0x07, 0x9a, 0xd0, 0x23, 0xa2, 0xc5,
	0x9e, 0xb1, 0x89, 0x3d, 0xb7, 0x16, 0xe2, 0xcf, 0xad, 0xd3, 0x5f, 0x5c, 0x9d, 0xe4, 0xad, 0xe6,
	0x3d, 0x98, 0x89, 0x48, 0xdd, 0x61, 0x89, 0x6a, 0x46, 0x10, 0x7b, 0x25, 0x24, 0x76, 0x47, 0xfa,
	0x81, 0x00, 0x0b, 0xfd, 0x43, 0x67, 0x06, 0x6a, 0x09, 0x4e, 0x11, 0x0f, 0x9f, 0xc1, 0x15, 0xb5,
	0x8d, 0xf7, 0x63, 0xcc, 0x56, 0xcd, 0x61, 0x67, 0x9f, 0x7d, 0xa9, 0x93, 0x0f, 0xe2, 0xfb, 0x30,
	0x4b, 0xa8, 0xf4, 0x5b, 0x78, 0x4f, 0x61, 0x9f, 0xe3, 0x27, 0x33, 0xa0, 0x82, 0x8c, 0xd8, 0x2f,
	0x3a, 0xd2, 0x7b, 0xe4, 0x31, 0x76, 0xe8, 0x90, 0xb8, 0x4f, 0x56, 0xa9, 0xe7, 0x0d, 0x43, 0xdf,
	0xcc, 0xdb, 0xe4, 0xd1, 0x65, 0x32, 0x6e, 0xdf, 0x97, 0x81, 0xbe, 0x71, 0x71, 0xba, 0xf3, 0x01,
	0xb2, 0x10, 0x0a, 0xe9, 0x8b, 0x05, 0x38, 0xc5, 0x8e, 0xd2, 0x23, 0x0e, 0xcd, 0x38, 0xcb, 0xdb,
	0xc0, 0x6b, 0x8e, 0x93, 0x5c, 0xd8, 0xfa, 0x57, 0xfe, 0x89, 0xfe, 0x95, 0xff, 0x5f, 0x38, 0x2d,
	0xc6, 0x35, 0x98, 0x0e, 0xaf, 0xf5, 0xce, 0x42, 0x91, 0xc8, 0xbd, 0x12, 0x5a, 0xec, 0x9d, 0xa8,
	0x43, 0x5e, 0x8a, 0x3a, 0xe4, 0xa1, 0xdb, 0x7f, 0x08, 0xdd, 0xfe, 0x47, 0x66, 0x76, 0x79, 0xbc,
	0x99, 0x2d, 0xcd, 0xc3, 0xe9, 0xa8, 0x12, 0xb0, 0xf3, 0x98, 0xef, 0xe7, 0xe0, 0x32, 0x76, 0x99,
	0x48, 0x6a, 0x95, 0xd8, 0xe9, 0x05, 0x97, 0xa6, 0xc4, 0x3d, 0x9d, 0x5c, 0xbf, 0xa7, 0x33, 0x24,
	0xbc, 0x32, 0x7a, 0x30, 0x55, 0x48, 0x78, 0xb4, 0x1b, 0x70, 0x6e, 0x22, 0xc6, 0xb9, 0x88, 0xae,
	0x4d, 0x8e, 0xbf, 0x69, 0x0a, 0xb4, 0x7a, 0x2a, 0x16, 0xff, 0x2f, 0xc1, 0x95, 0x74, 0x3e, 0x31,
	0x66, 0xfe, 0x54, 0x80, 0x4b, 0xb8, 0xd2, 0xc6, 0xc6, 0xfa, 0x6f, 0x2c, 0x2f, 0x53, 0x93, 0xcb,
	0x48, 0x57, 0xa9, 0x26, 0x24, 0x12, 0xcf, 0x06, 0xf8, 0x6b, 0x01, 0xae, 0xb1, 0x3a, 0x64, 0xe2,
	0x8c, 0x34, 0xca, 0x21, 0xb6, 0x25, 0x3a, 0x84, 0x7c, 0x7c, 0x08, 0x7d, 0x06, 0xa1, 0x90, 0x60,
	0x10, 0x06, 0xea, 0x4c, 0x84, 0x09, 0x93, 0x31, 0x26, 0x3c, 0x05, 0xd7, 0x07, 0x0f, 0x90, 0x71,
	0xe2, 0xcb, 0x02, 0x94, 0xfc, 0xe5, 0x2e, 0xaa, 0x86, 0xc2, 0x98, 0x6a, 0x18, 0x58, 0x83, 0x5c,
	0xd8, 0x1a, 0x0c, 0x72, 0x8e, 0xff, 0x5e, 0x80, 0xd3, 0x6c, 0x79, 0x25, 0x04, 0xf9, 0x46, 0xfe,
	0x44, 0x09, 0xfb, 0x68, 0x1f, 0x95, 0x0d, 0x49, 0x94, 0x24, 0xe9, 0x70, 0x26, 0x36, 0x64, 0xb6,
	0x82, 0x6e, 0x43, 0x39, 0x70, 0x62, 0xbc, 0x8d, 0xf5, 0x33, 0x19, 0x3d, 0x18, 0x19, 0x7c, 0xff,
	0xc5, 0x61, 0x4f, 0x24, 0x65, 0x64, 0xa8, 0x6e, 0x90, 0xaf, 0x8a, 0xef, 0x25, 0x9e, 0xf4, 0x3a,
	0x79, 0x22, 0xd9, 0xd7, 0x36, 0x08, 0xf9, 0x09, 0x94, 0xdd, 0x77, 0xfb, 0x7c, 0x6d, 0x77, 0xf0,
	0xa6, 0x76, 0x1d, 0xb9, 0x24, 0x75, 0x26, 0x4d, 0xed, 0xc9, 0x11, 0x9c, 0x71, 0x83, 0x3c, 0x05,
	0x8a, 0xb4, 0x61, 0xdd, 0xd5, 0xa0, 0x48, 0x13, 0x8f, 0x22, 0xaf, 0x2f, 0xbf, 0x2c, 0xbd, 0x4c,
	0x3c, 0x34, 0x2f, 0x75, 0x62, 0xb4, 0xb3, 0x21, 0xcf, 0x40, 0xbf, 0x47, 0x43, 0x09, 0xe2, 0x6d,
	0x59, 0xa7, 0x41, 0xee, 0x53, 0x21, 0x92, 0xfb, 0x74, 0xcb, 0x3b, 0xb3, 0xa4, 0xba, 0xf4, 0x72,
	0xb6, 0xdc, 0x8e, 0xb4, 0x93, 0xc8, 0xe9, 0xe5, 0x65, 0x28, 0xeb, 0x8e, 0x82, 0x34, 0xdd, 0x25,
	0xaf, 0xa4, 0xe8, 0x45, 0x18, 0xe8, 0x4e, 0x83, 0x41, 0xa4, 0x5f, 0x08, 0x70, 0x86, 0xde, 0x44,
	0x7b, 0x58, 0x78, 0x5c, 0x3a, 0x4c, 0x96, 0xe2, 0xf4, 0xf6, 0x83, 0xec, 0xad, 0x80, 0x41, 0x3b,
	0x04, 0xc2, 0x61, 0x90, 0xe9, 0x2b, 0xd4, 0x97, 0xe2, 0x8f, 0x99, 0x97, 0x5f, 0x0a, 0x7d, 0x7e,
	0xfe, 0x85, 0xd0, 0x35, 0x2b, 0x83, 0xd0, 0xde, 0xe9, 0x2b, 0xd7, 0x67, 0x97, 0x03, 0x63, 0x05,
	0x1e, 0xa8, 0xa9, 0x61, 0x33, 0xd4, 0x37, 0xa2, 0xf8, 0x8b, 0x66, 0x7a, 0x9d, 0x22, 0x42, 0x81,
	0x4c, 0x34, 0x3a, 0x02, 0xf2, 0xf7, 0x30, 0xda, 0xcf, 0x41, 0xf1, 0xc0, 0xb6, 0x7a, 0xdd, 0xd0,
	0x0b, 0x71, 0x52, 0xa6, 0x91, 0x6f, 0xc1, 0x79, 0xb3, 0x97, 0xb7, 0x56, 0x52, 0xe0, 0x0c, 0x7d,
	0xcf, 0x1f, 0x67, 0x2f, 0x0f, 0x31, 0x12, 0x54, 0x34, 0xd2, 0xb8, 0x89, 0x87, 0xe7, 0xa5, 0x71,
	0x8b, 0xc0, 0xa4, 0x3d, 0x98, 0x8f, 0x77, 0xe0, 0xf0, 0x0f, 0xf7, 0x3a, 0x4c, 0x53, 0x6c, 0x5a,
	0xa4, 0x8b, 0x28, 0x50, 0x6a, 0x90, 0x60, 0xe1, 0xba, 0x61, 0x78, 0x7d, 0x38, 0x2b, 0xc7, 0xec,
	0xf1, 0x66, 0x28, 0x8a, 0x6b, 0xd8, 0x7e, 0x4d, 0xfa, 0xa2, 0x40, 0x42, 0x82, 0xd3, 0xf1, 0xf8,
	0xe1, 0xb0, 0x41, 0xae, 0x5f, 0xc2, 0x5d, 0xcf, 0x62, 0x65, 0xcc, 0x75, 0xba, 0x8e, 0xdb, 0xca,
	0x7e, 0x3e, 0x4f, 0x52, 0x74, 0xa4, 0x0f, 0x83, 0x2c, 0xb7, 0x04, 0x32, 0x6c, 0xcb, 0x7d, 0x17,
	0x4a, 0x1e, 0x06, 0x6f, 0xf3, 0xb1, 0x94, 0x8d, 0x0e, 0x39, 0x40, 0x20, 0x7d, 0x43, 0x80, 0xa2,
	0x07, 0xe7, 0x92, 0x50, 0x58, 0xe3, 0xf2, 0x51, 0x8d, 0x6b, 0x7a, 0x1a, 0x47, 0x77, 0x14, 0x19,
	0xb9, 0x13, 0xb6, 0x13, 0xd2, 0x0d, 0x62, 0xad, 0xb6, 0x55, 0xdb, 0x35, 0x91, 0xbd, 0xe3, 0xaa,
	0x24, 0x71, 0xf2, 0xd0, 0x74, 0x9c, 0x77, 0x88, 0x21, 0xef, 0x6b, 0xc5, 0xc4, 0xf8, 0x49, 0xb2,
	0x87, 0xd5, 0x4d, 0xe5, 0xc0, 0xb2, 0x34, 0xbc, 0x0b, 0x21, 0x9f, 0xd9, 0x1e, 0xb6, 0xaa, 0x3b,
	0x4d, 0x73, 0xdd, 0xb2, 0x34, 0xaf, 0x99, 0xd4, 0x82, 0xf3, 0x3b, 0xbd, 0xbd, 0x8e, 0x3e, 0x92,
	0xbd, 0x4d, 0xcb, 0x26, 0x2d, 0x5d, 0x82, 0x0b, 0xc9, 0x58, 0x99, 0xd3, 0xb2, 0x46, 0xb7, 0x9f,
	0x34, 0x53, 0x74, 0x48, 0x2d, 0x43, 0x7a, 0x7d, 0x15, 0x2a, 0xbe, 0x3a, 0x06, 0x8a, 0x5d, 0xf6,
	0x60, 0x58, 0xb3, 0x0f, 0x49, 0xec, 0x5f, 0x0a, 0x16, 0xc6, 0x8e, 0x9d, 0xb0, 0x1e, 0x51, 0x7d,
	0x7e, 0x9e, 0xd3, 0x57, 0x88, 0xe2, 0x0d, 0xab, 0xd3, 0xd7, 0x73, 0x54, 0x04, 0xb1, 0x9e, 0x3d,
	0xd2, 0xef, 0xfa, 0x89, 0x7f, 0xa8, 0xa3, 0x73, 0x23, 0x9b, 0x8a, 0x44, 0x73, 0xfc, 0x60, 0x0b,
	0x17, 0xe4, 0x9f, 0x9c, 0x90, 0x69, 0x01, 0xf7, 0xb1, 0xd7, 0x6b, 0x3f, 0x44, 0xde, 0xdb, 0xad,
	0x8c, 0x7d, 0xac, 0x90, 0xb6, 0x32, 0xc3, 0x21, 0xae, 0xc2, 0xac, 0xba, 0xef, 0x22, 0x5b, 0xf1,
	0xb3, 0x8d, 0x73, 0x3c, 0x09, 0x9c, 0x21, 0x4d, 0xfc, 0xb2, 0xf4, 0x75, 0x81, 0x44, 0xb8, 0xf6,
	0x73, 0xe5, 0x31, 0x8a, 0x22, 0x1e, 0xaa, 0x9c, 0x8b, 0x87, 0x2a, 0x4b, 0xff, 0x4d, 0x80, 0x8b,
	0x32, 0x7a, 0xa4, 0xa3, 0xc3, 0x34, 0x71, 0xbd, 0x0f, 0x53, 0x36, 0xa9, 0xe0, 0x51, 0xb5, 0xc2,
	0x47, 0x55, 0x22, 0x56, 0x86, 0x54, 0xf6, 0x50, 0x62, 0x4b, 0xa2, 0x6a, 0x9d, 0x70, 0xc6, 0xac,
	0x29, 0x52, 0x6e, 0x6a, 0xd2, 0x77, 0x04, 0xb8, 0x30, 0x08, 0x49, 0xd2, 0x4b, 0x04, 0x95, 0x24,
	0x54, 0xf7, 0xb2, 0x72, 0x78, 0x45, 0x72, 0x1c, 0x88, 0xda, 0x86, 0x6e, 0x22, 0x25, 0x12, 0x3b,
	0x3a, 0xcd, 0xa0, 0x32, 0x01, 0x8a, 0xcf, 0xc0, 0x29, 0xaf, 0x1a, 0x3a, 0xea, 0x1a, 0xaa, 0x49,
	0xf6, 0x12, 0x6c, 0x4d, 0x15, 0xd9, 0xa7, 0x46, 0xf0, 0x45, 0xfa, 0x02, 0x5c, 0x4a, 0x63, 0x1e,
	0x93, 0xea, 0xa7, 0xe3, 0xb9, 0x48, 0x56, 0xc7, 0xe2, 0x1e, 0xc5, 0xea, 0xa7, 0x24, 0x91, 0x8c,
	0x14, 0xe9, 0xa5, 0xae, 0xb7, 0x17, 0xa0, 0xe4, 0xf4, 0xda, 0x6d, 0x84, 0x34, 0xa4, 0x31, 0x2e,
	0x05, 0x00, 0x6c, 0xcf, 0x4c, 0x74, 0x18, 0x4e, 0xd0, 0x5a, 0x92, 0x4b, 0x26, 0x3a, 0x64, 0x39,
	0x59, 0xdf, 0x86, 0x99, 0xe8, 0x0c, 0xa1, 0x57, 0x55, 0x44, 0x1a, 0xc8, 0x8b, 0x04, 0x0a, 0x00,
	0xd8, 0x48, 0xd1, 0x19, 0x14, 0x51, 0xbf, 0x32, 0x85, 0x51, 0xfd, 0xfb, 0x9e, 0x00, 0xb3, 0x31,
	0xda, 0xfb, 0x68, 0x4e, 0x4b, 0xca, 0xef, 0xad, 0x4c, 0xf9, 0xe8, 0xca, 0xe4, 0xbb, 0xdb, 0x85,
	0xe8, 0xc3, 0x9a, 0x57, 0xa1, 0xcc, 0x42, 0xf0, 0xf0, 0x34, 0xe6, 0x79, 0x95, 0x4b, 0xab, 0x63,
	0x80, 0xf4, 0xd7, 0x13, 0x30, 0xc5, 0xbc, 0x82, 0xa4, 0x7c, 0xa7, 0xce, 0x03, 0xcb, 0x76, 0x69,
	0x66, 0x7e, 0xb6, 0x51, 0x26, 0x10, 0x92, 0x99, 0xff, 0x2a, 0x54, 0x34, 0xdd, 0xe9, 0x1a, 0xea,
	0x31, 0xad, 0xe0, 0x85, 0xa4, 0x52, 0x18, 0xa9, 0xf2, 0x34, 0x54, 0x63, 0x3f, 0x24, 0x40, 0x4f,
	0x74, 0x4b, 0x81, 0xa3, 0x40, 0x7e, 0x45, 0xc0, 0x09, 0x22, 0x1f, 0x26, 0x62, 0x91, 0x0f, 0x24,
	0xcd, 0xae, 0xaa, 0x39, 0xec, 0x16, 0x79, 0x0a, 0x97, 0xeb, 0x9a, 0x43, 0x9e, 0x6a, 0x78, 0x97,
	0xfd, 0x25, 0x99, 0xfc, 0x1d, 0x61, 0x52, 0x31, 0xca, 0x24, 0xef, 0x65, 0x47, 0x29, 0xf4, 0xb2,
	0xe3, 0x6d, 0x28, 0xfa, 0xaf, 0x4e, 0xe9, 0xf5, 0xc2, 0xf3, 0xdc, 0x07, 0x9d, 0xc4, 0x5f, 0xf1,
	0xde, 0x9c, 0xfa, 0x68, 0x48, 0xc8, 0x99, 0xee, 0xda, 0xaa, 0x8b, 0x14, 0xfa, 0x5c, 0x73, 0xa1,
	0xcc, 0x62, 0x9f, 0x29, 0xb4, 0x4e, 0x80, 0x2c, 0x5b, 0xbe, 0x65, 0x1a, 0xc7, 0x8a, 0x6a, 0xb7,
	0x1f, 0xe8, 0x8f, 0x90, 0xc3, 0x1e, 0x8f, 0xcc, 0x32, 0x78, 0x9d, 0x81, 0xc5, 0xa7, 0xfa, 0x7f,
	0x8b, 0x61, 0x9a, 0x45, 0xa2, 0x84, 0x39, 0x18, 0x09, 0x12, 0x99, 0x89, 0x06, 0x89, 0xf4, 0x1d,
	0x4f, 0xce, 0x8e, 0x77, 0x3c, 0x59, 0xcd, 0x74, 0x3c, 0x79, 0x09, 0x20, 0x94, 0x3c, 0x6b, 0x8e,
	0x6e, 0x8a, 0x02, 0x88, 0xf8, 0xa6, 0xe7, 0x58, 0x89, 0x59, 0xee, 0x48, 0xbc, 0x94, 0x2f, 0xe1,
	0xfd, 0x17, 0xbd, 0x5f, 0xee, 0xd9, 0x36, 0xf6, 0x7c, 0x4e, 0x51, 0x1b, 0xe0, 0x03, 0xa4, 0x0f,
	0x61, 0x36, 0x26, 0x37, 0xbc, 0x1d, 0xd5, 0x7a, 0xb6, 0xea, 0x27, 0x5e, 0x98, 0x90, 0xfd, 0xb2,
	0xb8, 0x01, 0x85, 0x9e, 0xc9, 0x52, 0x6b, 0x70, 0x6f, 0x0e, 0x63, 0x1d, 0xec, 0x9a, 0xba, 0x2b,
	0x13, 0x34, 0xd2, 0x2b, 0x34, 0x84, 0x85, 0x7e, 0x8f, 0xba, 0x3c, 0x43, 0x5d, 0x79, 0x44, 0x76,
	0xc6, 0xb1, 0xb6, 0xcc, 0x0e, 0x36, 0xb1, 0xd8, 0xe9, 0x87, 0x6c, 0x4f, 0x03, 0x18, 0x3a, 0xd9,
	0x6f, 0x2e, 0xdd, 0xa2, 0x6e, 0xa9, 0xdf, 0x0d, 0x9e, 0xc1, 0x3e, 0x91, 0xd7, 0x60, 0xda, 0x23,
	0x12, 0x4f, 0x76, 0x8f, 0xcc, 0x0a, 0x03, 0x92, 0xba, 0xd2, 0x01, 0xf5, 0x8f, 0xe2, 0x18, 0x4e,
	0x9e, 0xd4, 0x7b, 0x84, 0x54, 0x76, 0x9a, 0xe1, 0xf5, 0xc7, 0x9f, 0x84, 0xa1, 0x6d, 0x44, 0x4f,
	0x38, 0x8b, 0x14, 0xd0, 0xd4, 0xd8, 0x08, 0xfa, 0x10, 0x9f, 0xfc, 0x08, 0xde, 0x85, 0xd3, 0x34,
	0xf7, 0xa5, 0xf7, 0x89, 0x2f, 0xae, 0x32, 0x6e, 0x73, 0x73, 0x7d, 0x36, 0x57, 0x3a, 0x0b, 0x67,
	0x62, 0x98, 0x99, 0xf7, 0xfd, 0x45, 0xc1, 0xcb, 0xb7, 0x39, 0x1a, 0xe3, 0xc2, 0xc6, 0x38, 0x17,
	0x35, 0xc6, 0x49, 0xf6, 0x2c, 0x9f, 0x68, 0xcf, 0xa4, 0xcb, 0x70, 0x31, 0x85, 0x08, 0x46, 0xe6,
	0x7d, 0xb2, 0x49, 0x60, 0xc9, 0x3c, 0x6e, 0x5b, 0x76, 0xe8, 0x99, 0xf0, 0xb8, 0x0f, 0x6e, 0x1d,
	0xb2, 0x73, 0x48, 0x41, 0xed, 0xdf, 0x7f, 0x4d, 0xd1, 0x88, 0x84, 0x8c, 0xce, 0x2a, 0xc5, 0xba,
	0x6e, 0xab, 0xa6, 0x4b, 0xd2, 0x4d, 0x79, 0x58, 0xa4, 0xef, 0xe6, 0x60, 0x36, 0xf6, 0x31, 0x7a,
	0x04, 0x2c, 0x0c, 0x0b, 0xd3, 0xc9, 0x8d, 0x67, 0xae, 0x33, 0xa5, 0xe6, 0x8d, 0x25, 0x2c, 0x2c,
	0x64, 0x48, 0x58, 0x18, 0x7e, 0xeb, 0x68, 0x99, 0x1c, 0x7e, 0x88, 0xf7, 0xd6, 0x71, 0xcb, 0x5c,
	0x34, 0xa0, 0xe8, 0x1d, 0xd2, 0x8a, 0x73, 0x30, 0xed, 0xa5, 0x32, 0x55, 0x58, 0xce, 0xa6, 0x2a,
	0x54, 0x7c, 0xd0, 0xbd, 0xc6, 0x4a, 0x55, 0x88, 0x40, 0x9a, 0x5b, 0x3b, 0xd5, 0x9c, 0x78, 0x1a,
	0xaa, 0x3e, 0xa4, 0xbe, 0xb9, 0x26, 0x6f, 0x35, 0xd7, 0xaa, 0x79, 0xf1, 0x14, 0xcc, 0x06, 0xd0,
	0x8d, 0xfa, 0x7b, 0x5b, 0x9b, 0xd5, 0xc2, 0xe2, 0x5f, 0xe4, 0xa0, 0x1a, 0x8f, 0x01, 0x12, 0xcf,
	0xc0, 0xdc, 0xce, 0xee, 0xca, 0xce, 0xaa, 0xdc, 0xdc, 0x6e, 0x35, 0xb7, 0x36, 0x95, 0xed, 0x7a,
	0x73, 0xad, 0xfa, 0x84, 0x38, 0x0f, 0x62, 0x14, 0x4c, 0x52, 0xa9, 0x0a, 0x7d, 0xf0, 0xfa, 0xda,
	0x46, 0x73, 0xb3, 0x9a, 0x13, 0x25, 0xb8, 0x14, 0x81, 0xaf, 0x37, 0x6f, 0xb7, 0x08, 0x2e, 0x65,
	0x77, 0x7b, 0x5d, 0xae, 0xaf, 0x35, 0xaa, 0x79, 0xf1, 0x1a, 0x5c, 0xee, 0xc7, 0x19, 0xad, 0x54,
	0xe8, 0xa3, 0x87, 0x24, 0x74, 0x9d, 0x10, 0x9f, 0x84, 0xab, 0x11, 0xf0, 0xda, 0xa6, 0xbc, 0xa6,
	0xc8, 0x8d, 0x9d, 0xdd, 0x15, 0x45, 0x6e, 0xac, 0xee, 0xca, 0x72, 0x73, 0x73, 0xbd, 0x3a, 0x29,
	0x3e, 0x0d, 0xd7, 0xd3, 0xaa, 0x6d, 0x6e, 0x6d, 0x06, 0x35, 0xa7, 0xc4, 0x2b, 0x70, 0x21, 0x52,
	0x73, 0x75, 0x6b, 0xad, 0xa1, 0xc8, 0x8d, 0xb5, 0xc6, 0x06, 0x29, 0x57, 0x8b, 0xe2, 0x27, 0xe1,
	0xe3, 0x83, 0x6a, 0x44, 0x09, 0x2f, 0x2d, 0xae, 0x40, 0xc9, 0xcf, 0x73, 0x42, 0xf3, 0xcf, 0x2a,
	0x2b, 0xf5, 0xb5, 0x75, 0x2c, 0xc7, 0x39, 0x98, 0x5e, 0x6b, 0xdc, 0xae, 0xef, 0xde, 0x6d, 0x31,
	0x90, 0x80, 0xc5, 0xc6, 0x90, 0xaf, 0x34, 0x64, 0x06, 0xcd, 0x2d, 0xde, 0xa2, 0xb7, 0x1b, 0x64,
	0x79, 0x17, 0xa7, 0xa1, 0x44, 0xb8, 0xc8, 0x94, 0x61, 0x0e, 0xa6, 0x49, 0xb1, 0xbe, 0xba, 0xda,
	0xd8, 0x6e, 0x35, 0xd6, 0xaa, 0x82, 0x0f, 0x5a, 0xad, 0x6f, 0xae, 0x36, 0xee, 0x36, 0xd6, 0xaa,
	0xb9, 0xc5, 0x77, 0xa0, 0x12, 0x7e, 0x47, 0x41, 0xba, 0x6e, 0xee, 0xac, 0x6e, 0xed, 0x6e, 0xfa,
	0x88, 0xce, 0xc2, 0x29, 0x1f, 0xb4, 0xdd, 0x90, 0x57, 0x1b, 0x9b, 0xad, 0xad, 0xdb, 0xb7, 0xab,
	0x82, 0x58, 0x83, 0x79, 0xff, 0xc3, 0xed, 0xe6, 0xbb, 0x8d, 0xb5, 0x77, 0xea, 0x77, 0x77, 0x1b,
	0xf8, 0x5b, 0x6e, 0x71, 0x1f, 0x8a, 0xde, 0xd5, 0x84, 0x28, 0xc2, 0x0c, 0xe9, 0xb6, 0x75, 0x7f,
	0xbb, 0xe1, 0x21, 0x3d, 0x03, 0x73, 0x01, 0x6c, 0xe3, 0xfe, 0x4e, 0xab, 0x21, 0xdf, 0xa7, 0xea,
	0x12, 0x80, 0x77, 0x5a, 0xf5, 0xcd, 0xb5, 0xba, 0xbc, 0x56, 0xcd, 0x61, 0x1a, 0x02, 0xf8, 0xea,
	0xd6, 0xc6, 0xc6, 0xee, 0x66, 0xb3, 0x75, 0xbf, 0x9a, 0x5f, 0x3c, 0x0a, 0x4e, 0xce, 0x28, 0x17,
	0xe6, 0x41, 0x8c, 0x00, 0xbc, 0x0e, 0x17, 0xe0, 0x74, 0x14, 0x5e, 0x5f, 0x6d, 0x35, 0xdf, 0xc1,
	0xac, 0x3d, 0x07, 0x67, 0xa2, 0x5f, 0xb6, 0x1b, 0x9b, 0x6b, 0x58, 0xe8, 0x39, 0x3c, 0xc2, 0xe8,
	0xa7, 0xe6, 0x26, 0x6b, 0x96, 0x5f, 0x3c, 0x84, 0x53, 0x09, 0x87, 0xdc, 0x78, 0xb0, 0xdb, 0x72,
	0xe3, 0x76, 0xf3, 0x5d, 0x65, 0x77, 0xf3, 0xce, 0xe6, 0xd6, 0xbd, 0x4d, 0x36, 0x2f, 0x3d, 0xd8,
	0x4e, 0xa3, 0x45, 0x25, 0xc1, 0x20, 0x0c, 0x5f, 0x8e, 0x4c, 0x41, 0x0a, 0x92, 0x1b, 0x6f, 0x35,
	0x56, 0xb1, 0xc4, 0xf2, 0x21, 0x6c, 0x1e, 0x51, 0x85, 0xc5, 0xbd, 0x60, 0x1b, 0xc6, 0xd2, 0x1b,
	0x87, 0xc6, 0x4c, 0x21, 0x4a, 0xdd, 0x30, 0xaa, 0x4f, 0x84, 0xc9, 0x67, 0x70, 0x76, 0x2e, 0x56,
	0x15, 0xc4, 0x0b, 0xb0, 0x10, 0x6f, 0xb3, 0xbf, 0xaf, 0x1b, 0xba, 0xea, 0xa2, 0x6a, 0x6e, 0xf1,
	0x87, 0x02, 0x9c, 0x4a, 0xf0, 0xd2, 0x70, 0xab, 0x04, 0xb0, 0xc7, 0xe3, 0x94, 0xaf, 0xf7, 0x1a,
	0x8d, 0x3b, 0x55, 0x41, 0xbc, 0x08, 0xe7, 0x92, 0xbe, 0x6e, 0x6c, 0x6d, 0xb6, 0xde, 0xac, 0xe6,
	0xd2, 0x1a, 0xdf, 0x6f, 0xd4, 0xe5, 0x6a, 0x5e, 0xbc, 0x0c, 0xe7, 0x93, 0xbe, 0x6e, 0x6d, 0x36,
	0x5a, 0xd8, 0xd0, 0x14, 0x16, 0xdf, 0x87, 0x4a, 0xd8, 0xd9, 0xc5, 0xf2, 0x0e, 0x97, 0x43, 0xd2,
	0x38, 0xeb, 0x0f, 0xad, 0x5f, 0x11, 0x22, 0x1f, 0x7c, 0x61, 0xe7, 0x96, 0xbf, 0xf5, 0x19, 0x98,
	0x8e, 0x24, 0xbd, 0x13, 0xff, 0x87, 0xe0, 0xbf, 0xd7, 0x88, 0x24, 0x3a, 0xbe, 0xc5, 0x99, 0xe7,
	0x2d, 0xf5, 0x17, 0x30, 0x6a, 0xf5, 0x31, 0x30, 0xb0, 0xd5, 0xf9, 0x9b, 0x02, 0x88, 0xfd, 0x09,
	0xff, 0xc5, 0x9b, 0x9c, 0x01, 0x40, 0x69, 0xbf, 0xc0, 0x50, 0xbb, 0x35, 0x3a, 0x82, 0x30, 0x65,
	0x7d, 0x09, 0xfa, 0xb9, 0x29, 0x4b, 0xfb, 0x39, 0x01, 0x6e, 0xca, 0x52, 0x7f, 0x1b, 0x80, 0x50,
	0xd6, 0x9f, 0x5d, 0x9f, 0x97, 0xb2, 0xd4, 0x5f, 0x15, 0xe0, 0xa5, 0x2c, 0x3d, 0xb1, 0xbf, 0xf8,
	0xbf, 0x04, 0xcf, 0x0b, 0x8e, 0x66, 0x80, 0x17, 0xeb, 0x59, 0x50, 0x27, 0x26, 0xb5, 0xaf, 0xad,
	0x8c, 0x83, 0x82, 0xd1, 0xf7, 0xef, 0x04, 0xa8, 0x84, 0xd3, 0xee, 0x8b, 0x2f, 0x73, 0x0b, 0x23,
	0xfe, 0x63, 0x05, 0xb5, 0x57, 0x46, 0x69, 0xca, 0xe8, 0xf8, 0x8e, 0x00, 0x67, 0x12, 0x53, 0x03,
	0x8b, 0x2b, 0xe3, 0x27, 0x97, 0xaf, 0xad, 0x8e, 0x85, 0x83, 0x91, 0xf8, 0x7f, 0x85, 0x20, 0x57,
	0x7f, 0x52, 0x5a, 0x66, 0x31, 0x63, 0x1a, 0xfc, 0x01, 0xe9, 0xe9, 0x6b, 0x6f, 0x9d, 0x04, 0x2a,
	0x46, 0xf7, 0xaf, 0xfb, 0xc2, 0x26, 0x07, 0xe5, 0x2a, 0x16, 0xef, 0x71, 0x27, 0x2a, 0xcd, 0x96,
	0xf4, 0xbe, 0xf6, 0xee, 0xc9, 0x23, 0x0e, 0x4d, 0xb2, 0xa4, 0xc4, 0xb2, 0xbc, 0x93, 0x6c, 0x40,
	0x3a, 0x5b, 0xde, 0x49, 0x36, 0x30, 0xaf, 0xed, 0x0f, 0x69, 0xb6, 0xbd, 0x94, 0x61, 0x89, 0xeb,
	0xe3, 0x32, 0xc6, 0xa3, 0xf5, 0xcd, 0xf1, 0x11, 0x31, 0x8a, 0x7f, 0x24, 0xf8, 0x49, 0x7e, 0x93,
	0x32, 0x0f, 0x8b, 0xd9, 0x7a, 0x1a, 0x90, 0x12, 0xba, 0xd6, 0x3c, 0x01, 0x4c, 0x8c, 0xe8, 0xbf,
	0x0c, 0x82, 0x6e, 0x79, 0xd2, 0x25, 0x8b, 0xef, 0x8e, 0xdd, 0x75, 0x9a, 0xaa, 0xdf, 0x7f, 0x0c,
	0x98, 0xd9, 0x20, 0xbf, 0x2f, 0x84, 0x53, 0x19, 0x46, 0xa5, 0xb2, 0x76, 0x12, 0x39, 0x86, 0x6b,
	0x8d, 0x31, 0xb1, 0x44, 0x27, 0x65, 0x5f, 0x2e, 0xde, 0x0c, 0x93, 0x32, 0x2d, 0x69, 0x70, 0x86,
	0x49, 0x99, 0x9e, 0x0a, 0x18, 0x3b, 0x81, 0x09, 0x69, 0x6b, 0x79, 0x9d, 0xc0, 0xf4, 0xd4, 0xbb,
	0xb5, 0xfa, 0x18, 0x18, 0x18, 0x71, 0x5f, 0x15, 0x48, 0x78, 0x54, 0x38, 0x61, 0xad, 0xf8, 0x1a,
	0x37, 0xda, 0x84, 0x9c, 0xb8, 0xb5, 0xd7, 0x47, 0x6c, 0xcd, 0x08, 0xfa, 0x3f, 0xf4, 0x75, 0x79,
	0x62, 0x3a, 0x5a, 0x91, 0x5f, 0x63, 0x06, 0x25, 0xc3, 0xad, 0xdd, 0x1e, 0x17, 0x0d, 0xa3, 0xf5,
	0xcb, 0x02, 0xcc, 0x44, 0xf3, 0xc9, 0x8a, 0x9c, 0xe1, 0xf3, 0x89, 0x29, 0x6f, 0x6b, 0xaf, 0x8d,
	0xd6, 0x98, 0x51, 0xf3, 0x0d, 0x01, 0xe6, 0xfa, 0x32, 0xc9, 0x8a, 0x6f, 0x64, 0xc3, 0x19, 0xcf,
	0x6a, 0x5b, 0xbb, 0x39, 0x72, 0xfb, 0x90, 0xcb, 0xdc, 0x9f, 0x01, 0x96, 0xd7, 0x65, 0x4e, 0xcd,
	0x6a, 0x5b, 0xbb, 0x35, 0x3a, 0x82, 0xa8, 0xee, 0x47, 0xf2, 0x15, 0xbe, 0x96, 0xd5, 0x26, 0x45,
	0x68, 0x7a, 0x7d, 0xc4, 0xd6, 0x21, 0x56, 0xf5, 0x27, 0x51, 0xe5, 0x65, 0x55, 0x6a, 0x3e, 0x58,
	0x5e, 0x56, 0x0d, 0xc8, 0xdf, 0xfa, 0x53, 0x01, 0x2e, 0x0d, 0x4e, 0x72, 0x2a, 0xde, 0xc9, 0xb2,
	0xed, 0x1b, 0x92, 0x87, 0xb5, 0x76, 0xf7, 0x64, 0x90, 0xf5, 0xed, 0x74, 0x47, 0xe1, 0x6b, 0x6a,
	0xf6, 0xd4, 0x6c, 0x3b, 0xdd, 0x54, 0x89, 0xf7, 0x67, 0xdd, 0xcc, 0x30, 0x39, 0x92, 0x73, 0x7d,
	0x66, 0x98, 0x1c, 0x69, 0x09, 0x3f, 0x8f, 0xa1, 0xe8, 0xfd, 0x30, 0xb9, 0xc8, 0x79, 0x6c, 0x1f,
	0xfb, 0x99, 0xf4, 0xda, 0x0b, 0x59, 0x9b, 0x85, 0x96, 0x80, 0xb4, 0x1f, 0x77, 0xe6, 0x5d, 0x02,
	0x86, 0xfc, 0xbc, 0x34, 0xef, 0x12, 0x30, 0xf4, 0x37, 0xa6, 0xb1, 0xff, 0x3a, 0x20, 0x21, 0x12,
	0xaf, 0xff, 0x3a, 0x3c, 0x55, 0x15, 0xaf, 0xff, 0xca, 0x93, 0x9d, 0x09, 0x33, 0x38, 0x2d, 0x5d,
	0x0f, 0x2f, 0x83, 0x87, 0xe4, 0x4c, 0xe2, 0x65, 0xf0, 0xd0, 0xac, 0x41, 0x84, 0xc1, 0xe9, 0xd9,
	0x7c, 0xb8, 0x19, 0x3c, 0x34, 0xbf, 0x10, 0x37, 0x83, 0x39, 0x52, 0x0b, 0xfd, 0x91, 0xe0, 0xff,
	0x86, 0xcc, 0xa0, 0xac, 0x3c, 0xe2, 0xf6, 0x28, 0xfb, 0xa8, 0x81, 0x83, 0x78, 0xfb, 0x04, 0x31,
	0xb2, 0xc1, 0xfc, 0x4c, 0x20, 0x57, 0x7d, 0x03, 0x53, 0xeb, 0x88, 0x1b, 0xdc, 0xfd, 0xf2, 0xa4,
	0x01, 0xaa, 0x6d, 0x9e, 0x14, 0xba, 0xd0, 0x8e, 0x2d, 0x43, 0x8a, 0x1b, 0xde, 0x1d, 0x5b, 0xf6,
	0xac, 0x3e, 0xbc, 0x3b, 0xb6, 0x11, 0xf2, 0xf1, 0x78, 0xfe, 0x4c, 0xf8, 0x27, 0xbd, 0x33, 0xf8,
	0x33, 0x09, 0xbf, 0xeb, 0x9e, 0xc1, 0x9f, 0x49, 0xfc, 0x1d, 0x71, 0x4c, 0xd0, 0xce, 0x68, 0x04,
	0xed, 0x8c, 0x45, 0x50, 0xda, 0x0f, 0x9b, 0xff, 0x44, 0x80, 0x8b, 0x03, 0x93, 0x1b, 0x8b, 0x6f,
	0x71, 0x8f, 0x78, 0x68, 0x5e, 0xe7, 0xda, 0x9d, 0x13, 0xc1, 0x15, 0x9d, 0x85, 0x03, 0x53, 0x10,
	0x67, 0x98, 0x85, 0x3c, 0xe9, 0x99, 0x33, 0xcc, 0x42, 0xbe, 0xcc, 0xc8, 0x4c, 0x41, 0xc3, 0xc9,
	0x67, 0x33, 0x28, 0x68, 0x42, 0x3e, 0xdc, 0x0c, 0x0a, 0x9a, 0x98, 0xf1, 0x16, 0xbb, 0x5f, 0xfd,
	0xa9, 0x29, 0x79, 0xdd, 0xaf, 0xd4, 0xa4, 0xa3, 0xb5, 0x5b, 0xa3, 0x23, 0x08, 0x6d, 0xe6, 0xfa,
	0x52, 0xc3, 0xf2, 0x6e, 0xe6, 0xd2, 0x92, 0xed, 0xd6, 0x6e, 0x8e, 0xdc, 0x3e, 0x4c, 0x56, 0x3c,
	0x13, 0x2b, 0x37, 0x59, 0x29, 0x69, 0x67, 0x6b, 0x37, 0x47, 0x6e, 0xcf, 0xc8, 0xfa, 0x02, 0x40,
	0x90, 0x05, 0x47, 0xe4, 0xcc, 0x77, 0xd9, 0x97, 0x1e, 0xa8, 0xf6, 0x52, 0xf6, 0x86, 0x01, 0x01,
	0x41, 0x2e, 0x1b, 0x5e, 0x02, 0xfa, 0x52, 0xec, 0xf0, 0x12, 0x90, 0x90, 0x36, 0xe7, 0x18, 0x8a,
	0x5e, 0x3e, 0x1a, 0x5e, 0x77, 0x3d, 0x96, 0x15, 0x87, 0xd7, 0x5d, 0xef, 0x4b, 0x7b, 0xf3, 0x08,
	0xa6, 0x58, 0xbe, 0x12, 0xf1, 0x06, 0x37, 0xfd, 0xe1, 0x51, 0x3f, 0x9f, 0xb1, 0x15, 0xeb, 0xf7,
	0x3f, 0x0b, 0x7e, 0x0e, 0x9e, 0x20, 0x0d, 0xc5, 0xeb, 0x99, 0x06, 0x11, 0x4f, 0x07, 0x50, 0x7b,
	0x63, 0xd4, 0xe6, 0xd1, 0x43, 0xd3, 0xa4, 0xac, 0x00, 0x19, 0x0e, 0x4d, 0x07, 0x24, 0x2c, 0xc8,
	0x70, 0x68, 0x3a, 0x30, 0x35, 0xc1, 0xbf, 0x17, 0x60, 0x3a, 0x92, 0x61, 0x47, 0xcc, 0x70, 0xa9,
	0x16, 0xcf, 0x07, 0x54, 0x7b, 0x75, 0xa4, 0xb6, 0x21, 0x39, 0xc6, 0x13, 0xde, 0xf0, 0xca, 0x31,
	0x25, 0xdf, 0x4f, 0xed, 0x8d, 0x51, 0x9b, 0x87, 0x6e, 0x2b, 0xc3, 0x31, 0xf6, 0xbc, 0xb7, 0x95,
	0x09, 0xc9, 0x19, 0x78, 0x6f, 0x2b, 0x93, 0x42, 0xfa, 0xc9, 0x4e, 0x2d, 0x2d, 0x54, 0x9d, 0x77,
	0xa7, 0x36, 0x24, 0x25, 0x00, 0xef, 0x4e, 0x6d, 0x58, 0xc4, 0x3c, 0xd1, 0xfd, 0x94, 0xa0, 0x73,
	0x5e, 0xdd, 0x1f, 0x1c, 0x70, 0x5f, 0x6b, 0x8c, 0x89, 0x25, 0x74, 0xbf, 0x3a, 0x28, 0x30, 0x9c,
	0xf7, 0x7e, 0x95, 0x23, 0x7a, 0x9e, 0xf7, 0x7e, 0x95, 0x27, 0x4e, 0xdd, 0x3b, 0x2c, 0x8a, 0xc5,
	0x1f, 0x67, 0x38, 0x2c, 0x4a, 0x8e, 0x7a, 0xce, 0x70, 0x58, 0x94, 0x16, 0xfa, 0x8c, 0xad, 0x49,
	0x24, 0x80, 0x9b, 0xd7, 0x9a, 0x24, 0x05, 0xba, 0xf3, 0x5a, 0x93, 0xe4, 0x88, 0xf1, 0x2f, 0x0b,
	0x30, 0x13, 0x8d, 0x98, 0x16, 0xf9, 0xf1, 0xf5, 0xc7, 0x66, 0xd7, 0x5e, 0x1b, 0xad, 0x31, 0xa3,
	0xe6, 0x3f, 0x0a, 0x30, 0x13, 0x8d, 0xe9, 0xe5, 0xa5, 0x26, 0x31, 0xb6, 0xb9, 0x36, 0x62, 0xe3,
	0x80, 0x35, 0xd1, 0x90, 0x5b, 0x5e, 0x62, 0x12, 0x23, 0x81, 0x79, 0x59, 0x93, 0x12, 0xe5, 0xcb,
	0x6e, 0x7e, 0xd3, 0x82, 0x6a, 0x33, 0xdc, 0xfc, 0x0e, 0x89, 0xef, 0xcd, 0x70, 0xf3, 0x3b, 0x34,
	0xc2, 0x97, 0x4d, 0xc1, 0x58, 0xe4, 0x68, 0x86, 0x29, 0x98, 0x1c, 0xa9, 0x9a, 0x61, 0x0a, 0xa6,
	0x05, 0xad, 0x62, 0xcf, 0xbc, 0x2f, 0x6e, 0x5f, 0x7c, 0x23, 0x93, 0xf6, 0xf6, 0x05, 0xaf, 0xd6,
	0x6e, 0x8e, 0xdc, 0x3e, 0x74, 0x39, 0x9b, 0x14, 0xc7, 0xca, 0x7b, 0x39, 0x3b, 0x20, 0xb2, 0x96,
	0xf7, 0x72, 0x76, 0x50, 0x18, 0xad, 0x77, 0xdd, 0x98, 0x18, 0x01, 0x9b, 0xe1, 0xba, 0x71, 0x50,
	0x1c, 0x6e, 0x86, 0xeb, 0xc6, 0xc1, 0x81, 0xb8, 0xec, 0x22, 0x39, 0x5e, 0x29, 0xc3, 0x45, 0x72,
	0x4a, 0xfc, 0x66, 0x86, 0x8b, 0xe4, 0xd4, 0x20, 0xc6, 0xff, 0x2d, 0xc0, 0x7c, 0x72, 0x9c, 0xa3,
	0x38, 0x4e, 0x38, 0xa3, 0x4f, 0xe2, 0xda, 0x78, 0x48, 0xa2, 0x7b, 0x86, 0x48, 0xfc, 0x4f, 0x86,
	0x3d, 0x43, 0x52, 0xcc, 0x51, 0x86, 0x3d, 0x43, 0x72, 0xd8, 0x91, 0x67, 0x53, 0xa2, 0xa1, 0x3e,
	0x59, 0x6c, 0x4a, 0x62, 0x98, 0x51, 0x16, 0x9b, 0x92, 0x12, 0x65, 0xc4, 0x28, 0x8b, 0x45, 0x97,
	0x64, 0xa0, 0x2c, 0x39, 0x38, 0x26, 0x03, 0x65, 0x69, 0xd1, 0x43, 0xd8, 0xe1, 0x88, 0x44, 0xe6,
	0xf0, 0x3a, 0x1c, 0x49, 0x81, 0x42, 0xbc, 0xab, 0x6a, 0x62, 0x28, 0x10, 0x79, 0x50, 0x98, 0x18,
	0x85, 0x23, 0x66, 0x7a, 0x36, 0x99, 0xc2, 0xaa, 0xd5, 0xb1, 0x70, 0x84, 0xb4, 0xbe, 0xd1, 0x51,
	0x75, 0x23, 0xfc, 0x3a, 0xe6, 0x75, 0xde, 0x70, 0xf7, 0x68, 0xbb, 0x8c, 0x5a, 0xdf, 0xdf, 0x3c,
	0x4e, 0xd3, 0xba, 0x61, 0xed, 0xa9, 0x64, 0xd9, 0x45, 0x99, 0x68, 0x0a, 0xb5, 0x1b, 0x85, 0xa6,
	0x48, 0xf3, 0xd0, 0xf3, 0x39, 0xf2, 0x91, 0xd9, 0x0f, 0xba, 0x56, 0xd4, 0x49, 0x80, 0xb8, 0x6a,
	0xf0, 0x3e, 0x9f, 0x4b, 0xc7, 0x90, 0xf1, 0xf9, 0xdc, 0x20, 0x44, 0xd1, 0xe5, 0x2b, 0x31, 0x0c,
	0x2b, 0xc3, 0xf2, 0x35, 0x28, 0x42, 0x2c, 0xc3, 0xf2, 0x35, 0x30, 0x1a, 0x6c, 0xa5, 0xfc, 0x5e,
	0x09, 0xb7, 0x70, 0x0f, 0x75, 0xbb, 0xbb, 0x37, 0x49, 0x62, 0x98, 0x9e, 0xfb, 0xe7, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xaf, 0xc7, 0x33, 0x94, 0xee, 0x9d, 0x00, 0x00,
}
