// Code generated by protoc-gen-twirp v4.7.0, DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.7.0.

It is generated from these files:
	twirp/subscriptions.proto
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/timestamp"

import bytes "bytes"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// =======================
// Subscriptions Interface
// =======================

type Subscriptions interface {
	// Subscriptions
	// =============
	// FulfillSubscription creates/upgrades subscription for user to product.
	FulfillSubscription(context.Context, *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error)

	// CreateSubscription creates a new subscription without the extra steps that FulfillSubscription
	// does, such as creating chat notification tokens. CreateSubscription is called by
	// FulfillSubscription as one of its steps.
	// The following steps will be executed during CreateSubscription:
	//   Lock using redis
	//   CanSubscribe?
	//   Create subscription entitlement
	//   Send entitlementSNS
	//   Unlock
	CreateSubscription(context.Context, *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error)

	// CancelSubscription cancels user's subscription to product.
	CancelSubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error)

	// UpdateSubscription updates user's subscription to product.
	// The following steps will be executed during UpdateSubscription:
	//   Update subscription entitlement
	//   Send entitlementSNS
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error)

	// UpdateTicketOriginID is used for Payment Team's schema migration
	// This should not be used for anything else
	UpdateTicketOriginID(context.Context, *UpdateTicketOriginIDRequest) (*UpdateTicketOriginIDResponse, error)

	// CanSubscribe returns whether user can subscribe to product for a given platform.
	CanSubscribe(context.Context, *CanSubscribeRequest) (*CanSubscribeResponse, error)

	// ListUserSubscriptions returns a paginated list of user's active subscriptions.
	ListUserSubscriptions(context.Context, *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error)

	// ListUserExpiredSubscriptions returns a list of user's expired subscriptions sorted by most recently expired. An expired sub refers to the most recent ticket - that is not active.
	ListUserExpiredSubscriptions(context.Context, *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error)

	// GetUserChannelSubscriptionWithPaymentsData returns the highest max tier active subscription with payments data for an owner channel pair.
	GetUserChannelSubscriptionWithPaymentsData(context.Context, *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error)

	// GetUserSubscriptions returns the list of all a user's active subscriptions without payment data. Will return highest tier sub per channel.
	GetUserSubscriptions(context.Context, *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error)

	// GetUserChannelSubscription returns the highest max tier active subscription without payments data for a user channel pair.
	// This should be used when you need to know if a user channel pair is subscribed.
	GetUserChannelSubscription(context.Context, *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error)

	// GetUserSubscriptions returns the list of a user's active subscriptions without payments data given a list of product_ids.
	GetUserProductSubscriptions(context.Context, *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error)

	// GetUserProductSubscriptionWithPaymentsData returns the list of a user's active subscriptions with payments data given a list of product_ids
	GetUserProductSubscriptionsWithPaymentsData(context.Context, *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error)

	// GetChannelSubscriptions returns a paginated list of active subscribers to a channel.
	GetChannelSubscriptions(context.Context, *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error)

	// GetFormerSubscribers returns a paginated list of former subscribers to a channel.
	// This API is not sorted, going through paginated results might result in duplicates/missing entries.
	// Limit is capped at 1000
	GetFormerSubscribers(context.Context, *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error)

	// GetSubscriptionByID returns Subscriptions given an Owner, Product, and Origin or a TicketID.
	// Prefer to use Owner, Product, Origin if possible as TicketID will not be supported in the future.
	GetSubscriptionByID(context.Context, *GetSubscriptionByIDRequest) (*GetSubscriptionByIDResponse, error)

	// GetTicketsByIDs returns Subscriptions given a list of TicketIDs. This was created for
	// Payments to move Mulan off of SiteDB. DO NOT USE.
	GetTicketsByIDs(context.Context, *GetTicketsByIDsRequest) (*GetTicketsByIDsResponse, error)

	// GetHistoricalUserTickets returns all Subscriptions (tickets) a user has, active or inactive.
	// Created for Payments to move Mulan off of SiteDB. DO NOT USE.
	GetHistoricalUserTickets(context.Context, *GetHistoricalUserTicketsRequest) (*GetHistoricalUserTicketsResponse, error)

	// Subscriber Badges
	// =====
	// TakedownBadges takes down one or more custom subscriber badges belonging to a broadcaster
	TakedownBadges(context.Context, *TakedownBadgesRequest) (*TakedownBadgesResponse, error)

	// TakedownAllBadges takes down all badges belonging to a broadcaster
	TakedownAllBadges(context.Context, *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error)

	// GetSubscriberBadge returns the correctly subscription tenure based badge for a channel and user pair
	GetSubscriberBadge(context.Context, *GetSubscriberBadgeRequest) (*GetSubscriberBadgeResponse, error)

	// GetChannelBadge returns the badges given their channel id
	GetChannelBadge(context.Context, *GetChannelBadgeRequest) (*GetChannelBadgeResponse, error)

	// DeleteChannelBadge deletes a specific badge given their channel and badge id
	DeleteChannelBadge(context.Context, *DeleteChannelBadgeRequest) (*DeleteChannelBadgeResponse, error)

	// CreateChannelBadgeUploadConfig returns the badge image and upload id and url
	CreateChannelBadgeUploadConfig(context.Context, *CreateChannelBadgeUploadConfigRequest) (*CreateChannelBadgeUploadConfigResponse, error)

	// CreateChannelBadge returns the badge image and upload id and url
	CreateChannelBadge(context.Context, *CreateChannelBadgeRequest) (*CreateChannelBadgeResponse, error)

	GetTimeoutStatuses(context.Context, *GetTimeoutStatusesRequest) (*GetTimeoutStatusesResponse, error)

	// Score
	// =====
	// SetScore sets the subscription high score given a channel and current score.
	SetScore(context.Context, *SetScoreRequest) (*SetScoreResponse, error)

	// CalculateSubscriberScore returns the subscriber score given their channel id.
	CalculateSubscriberCount(context.Context, *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error)

	// ChatNotification
	// =====
	// CreateChatNotificationToken creates a chat notification token
	CreateChatNotificationToken(context.Context, *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error)

	// UseChatNotificationToken posts a chat notification token, marks it as used given a token_id.
	UseChatNotificationToken(context.Context, *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error)

	// CancelChatNotificationToken invalidates a chat notification token, given a subscription_id.
	CancelChatNotificationToken(context.Context, *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error)

	// GetAvailableTokens gets all the tokens that are available that belong to a user and channel.
	GetUserChannelChatNotificationToken(context.Context, *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error)

	// GetAllUsedChatNotificationTokens returns a historical list of a user's used chat notification tokens sorted by createdAt date to a channel.
	GetAllUsedChatNotificationTokens(context.Context, *GetAllUsedChatNotificationTokensRequest) (*GetAllUsedChatNotificationTokensResponse, error)

	AllowReplayForLastUsedChatNotificationToken(context.Context, *AllowReplayForLastUsedChatNotificationTokenRequest) (*AllowReplayForLastUsedChatNotificationTokenResponse, error)

	// UserSettings
	// ============
	// GetUserSettings gets the user subscription settings.
	GetUserSettings(context.Context, *GetUserSettingsRequest) (*GetUserSettingsResponse, error)

	// SetUserSettings sets the user subscription settings.
	SetUserSettings(context.Context, *SetUserSettingsRequest) (*SetUserSettingsResponse, error)

	// External Product
	// ================
	// GetExternalProductTemplateSKU returns a template SKU which can be used to fetch external product's attributes
	// from third party subscription providers like Apple, Google.
	GetExternalProductTemplateSKU(context.Context, *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error)

	// GetExternalProductPurchasableSKU does subscription eligibility checks and returns SKU for purchase from
	// external subscriptions providers (e.g, Apple, Google)
	GetExternalProductPurchasableSKU(context.Context, *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error)

	// Paid Upgrades
	// =======
	// GetPaidUpgrades returns a list of paid upgrades from a list of subKeys.
	GetPaidUpgrades(context.Context, *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error)

	// FulfillPaidUpgrade creates a Subscription and a Paid Upgrade.
	FulfillPaidUpgrade(context.Context, *FulfillPaidUpgradeRequest) (*FulfillPaidUpgradeResponse, error)

	// CreatePaidUpgrades creates a paid upgrade from a subKey.
	CreatePaidUpgrade(context.Context, *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error)

	// CancelPaidUpgrade cancels the paid upgrade from a subKey.
	CancelPaidUpgrade(context.Context, *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error)

	// Gifts
	// ======
	// InsertGift creates a new gift record in the gifts table without checking product, eligibilty or sending notifications.
	InsertGift(context.Context, *InsertGiftRequest) (*InsertGiftResponse, error)

	// CancelGift cancels a subscription gift.
	CancelGift(context.Context, *CancelGiftRequest) (*CancelGiftResponse, error)

	// GetGifts determines if there are gifts associated with supplied POODs.
	GetGifts(context.Context, *GetGiftsRequest) (*GetGiftsResponse, error)

	// CanGift determines if a sender can gift a subscription to a recipient.
	CanGift(context.Context, *CanGiftRequest) (*CanGiftResponse, error)

	// GetGiftPromotion returns the active gift promotion for subscription products.
	GetGiftPromotion(context.Context, *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error)

	// GetPaidUpgradePromotion returns the active gift promotion for a user's subscription products
	GetPaidUpgradePromotion(context.Context, *GetPaidUpgradePromotionRequest) (*GetPaidUpgradePromotionResponse, error)

	// CanSenderGift determines if a sender is allowed to gift to recipients
	CanSenderGift(context.Context, *CanSenderGiftRequest) (*CanSenderGiftResponse, error)

	// CanGiftRecipient determines if a recipient is allowed to receive a gift from a particular sender depending on the type of gift.
	CanGiftRecipient(context.Context, *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error)

	// FulfillGifts asynchronously entitles gift subscription for a given request.
	FulfillGifts(context.Context, *FulfillGiftsRequest) (*FulfillGiftsResponse, error)

	// SendGiftChatNotification sends a chat notification indicating the recipient has been gifted a sub.
	SendGiftChatNotification(context.Context, *SendGiftChatNotificationRequest) (*SendGiftChatNotificationResponse, error)

	// SendMMGChatNotification sends a chat notification indicating the sender has gifted a sub to a recipient.
	SendMMGChatNotification(context.Context, *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error)

	// SendMMGStartChatNotification sends a chat notification that indicates the start of a mass mystery gift.
	SendMMGStartChatNotification(context.Context, *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error)

	// GetRelatedChannels gets related channels to a product.
	GetRelatedChannels(context.Context, *GetRelatedChannelsRequest) (*GetRelatedChannelsResponse, error)

	// GetGiftOffers gets all available gift offers for a particular product depending on the platform and gift type.
	GetGiftOffers(context.Context, *GetGiftOffersRequest) (*GetGiftOffersResponse, error)

	// Emoticons
	// ======
	// GetEmotePrefix gets the emote prefix for a given channel ID.
	GetEmotePrefix(context.Context, *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error)

	// CreateEmoticon creates a subscription emoticon.
	CreateEmoticon(context.Context, *CreateEmoticonRequest) (*CreateEmoticonReponse, error)

	// DeleteEmoticon deletes a subscription emote
	DeleteEmoticon(context.Context, *DeleteEmoticonRequest) (*DeleteEmoticonResponse, error)

	GetAllEmoticonsByProductIDs(context.Context, *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error)

	// Get standing status of a user. Can be "in good standing" or "not in good standing".
	// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
	GetPartnerStanding(context.Context, *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error)

	// GetEmoticonPrefix returns the emote prefix and prefix state for a given channel ID.
	GetEmoticonPrefix(context.Context, *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error)

	// SubmitEmoticonPrefix is used when a new partner has a blank emoticon prefix and wants to submit
	// a prefix for approval. Will return precondition failed if the user does not have a blank prefix.
	SubmitEmoticonPrefix(context.Context, *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error)

	// Pending Emoticons
	// ======
	// GetPendingEmoticonByID returns a particular pending emoticon for use in the aegis GQL loader
	GetPendingEmoticonsByIDs(context.Context, *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error)

	// GetPendingEmoticons returns an array of pending emoticons for the moderation team's approval flow.
	GetPendingEmoticons(context.Context, *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error)

	// ReviewPendingEmoticons accepts an array of approve or reject actions and either approves or rejects each emoticon
	ReviewPendingEmoticons(context.Context, *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error)

	// Products
	// =========
	// GetProductsByIDs returns a list of products given a list of product ids.
	// Max size of 100 ids.
	GetProductsByIDs(context.Context, *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error)

	// GetProductsByNames returns a list of products given a list of product short names with length x, 0 < x <=100.
	GetProductsByNames(context.Context, *GetProductsByNamesRequest) (*GetProductsByNamesResponse, error)

	// GetChannelProducts accepts a channelID and returns a list of active products owned by the channel.
	// If the channel belongs to a teamsub, it will return the teamsub product.
	GetChannelProducts(context.Context, *GetChannelProductsRequest) (*GetChannelProductsResponse, error)

	// UpdateProduct updates the fields of the given product.
	UpdateProduct(context.Context, *UpdateProductRequest) (*UpdateProductResponse, error)

	// Updates all products for a given channel.
	UpdateChannelProducts(context.Context, *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error)

	// EmailSubscribers publishes to a queue to initiate the email process.
	EmailSubscribers(context.Context, *EmailSubscribersRequest) (*EmailSubscribersResponse, error)

	EmailGlobalEmote(context.Context, *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error)

	EmailPendingPrefixApproval(context.Context, *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error)

	// Tickets
	// ========
	// GetTicketsForUserChannel returns the tickets for a particular user/channel.
	// This is not paginated but will return a failure if there are more than 150.
	// (only 6 user/channel pairs have more than 150 as of 12/13/2018 and all are test accounts or banned)
	GetTicketsForUserChannel(context.Context, *GetTicketsForUserChannelRequest) (*GetTicketsForUserChannelResponse, error)
}

// =============================
// Subscriptions Protobuf Client
// =============================

type subscriptionsProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsProtobufClient creates a Protobuf client that implements the Subscriptions interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewSubscriptionsProtobufClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsProtobufClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateSubscription"
	out := new(CreateSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateSubscription"
	out := new(UpdateSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateTicketOriginID(ctx context.Context, in *UpdateTicketOriginIDRequest) (*UpdateTicketOriginIDResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateTicketOriginID"
	out := new(UpdateTicketOriginIDResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserExpiredSubscriptions"
	out := new(ListUserExpiredSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptionsWithPaymentsData"
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelSubscriptions"
	out := new(GetChannelSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetFormerSubscribers(ctx context.Context, in *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetFormerSubscribers"
	out := new(GetFormerSubscribersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetSubscriptionByID(ctx context.Context, in *GetSubscriptionByIDRequest) (*GetSubscriptionByIDResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriptionByID"
	out := new(GetSubscriptionByIDResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetTicketsByIDs(ctx context.Context, in *GetTicketsByIDsRequest) (*GetTicketsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTicketsByIDs"
	out := new(GetTicketsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetHistoricalUserTickets(ctx context.Context, in *GetHistoricalUserTicketsRequest) (*GetHistoricalUserTicketsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetHistoricalUserTickets"
	out := new(GetHistoricalUserTicketsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) TakedownBadges(ctx context.Context, in *TakedownBadgesRequest) (*TakedownBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownBadges"
	out := new(TakedownBadgesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) TakedownAllBadges(ctx context.Context, in *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownAllBadges"
	out := new(TakedownAllBadgesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetSubscriberBadge(ctx context.Context, in *GetSubscriberBadgeRequest) (*GetSubscriberBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriberBadge"
	out := new(GetSubscriberBadgeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelBadge(ctx context.Context, in *GetChannelBadgeRequest) (*GetChannelBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelBadge"
	out := new(GetChannelBadgeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) DeleteChannelBadge(ctx context.Context, in *DeleteChannelBadgeRequest) (*DeleteChannelBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "DeleteChannelBadge"
	out := new(DeleteChannelBadgeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateChannelBadgeUploadConfig(ctx context.Context, in *CreateChannelBadgeUploadConfigRequest) (*CreateChannelBadgeUploadConfigResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChannelBadgeUploadConfig"
	out := new(CreateChannelBadgeUploadConfigResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateChannelBadge(ctx context.Context, in *CreateChannelBadgeRequest) (*CreateChannelBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChannelBadge"
	out := new(CreateChannelBadgeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetTimeoutStatuses(ctx context.Context, in *GetTimeoutStatusesRequest) (*GetTimeoutStatusesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTimeoutStatuses"
	out := new(GetTimeoutStatusesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetAllUsedChatNotificationTokens(ctx context.Context, in *GetAllUsedChatNotificationTokensRequest) (*GetAllUsedChatNotificationTokensResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllUsedChatNotificationTokens"
	out := new(GetAllUsedChatNotificationTokensResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) AllowReplayForLastUsedChatNotificationToken(ctx context.Context, in *AllowReplayForLastUsedChatNotificationTokenRequest) (*AllowReplayForLastUsedChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "AllowReplayForLastUsedChatNotificationToken"
	out := new(AllowReplayForLastUsedChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) FulfillPaidUpgrade(ctx context.Context, in *FulfillPaidUpgradeRequest) (*FulfillPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillPaidUpgrade"
	out := new(FulfillPaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) InsertGift(ctx context.Context, in *InsertGiftRequest) (*InsertGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "InsertGift"
	out := new(InsertGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPaidUpgradePromotion(ctx context.Context, in *GetPaidUpgradePromotionRequest) (*GetPaidUpgradePromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgradePromotion"
	out := new(GetPaidUpgradePromotionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSenderGift(ctx context.Context, in *CanSenderGiftRequest) (*CanSenderGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSenderGift"
	out := new(CanSenderGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGiftRecipient(ctx context.Context, in *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGiftRecipient"
	out := new(CanGiftRecipientResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) FulfillGifts(ctx context.Context, in *FulfillGiftsRequest) (*FulfillGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillGifts"
	out := new(FulfillGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendGiftChatNotification(ctx context.Context, in *SendGiftChatNotificationRequest) (*SendGiftChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendGiftChatNotification"
	out := new(SendGiftChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendMMGChatNotification(ctx context.Context, in *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGChatNotification"
	out := new(SendMMGChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendMMGStartChatNotification(ctx context.Context, in *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGStartChatNotification"
	out := new(SendMMGStartChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetRelatedChannels(ctx context.Context, in *GetRelatedChannelsRequest) (*GetRelatedChannelsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetRelatedChannels"
	out := new(GetRelatedChannelsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGiftOffers(ctx context.Context, in *GetGiftOffersRequest) (*GetGiftOffersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftOffers"
	out := new(GetGiftOffersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) DeleteEmoticon(ctx context.Context, in *DeleteEmoticonRequest) (*DeleteEmoticonResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "DeleteEmoticon"
	out := new(DeleteEmoticonResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticonsByIDs(ctx context.Context, in *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs"
	out := new(GetPendingEmoticonsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ReviewPendingEmoticons(ctx context.Context, in *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ReviewPendingEmoticons"
	out := new(ReviewPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetProductsByNames(ctx context.Context, in *GetProductsByNamesRequest) (*GetProductsByNamesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByNames"
	out := new(GetProductsByNamesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailSubscribers(ctx context.Context, in *EmailSubscribersRequest) (*EmailSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailSubscribers"
	out := new(EmailSubscribersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailGlobalEmote(ctx context.Context, in *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailGlobalEmote"
	out := new(EmailGlobalEmoteResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailPendingPrefixApproval(ctx context.Context, in *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailPendingPrefixApproval"
	out := new(EmailPendingPrefixApprovalResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetTicketsForUserChannel(ctx context.Context, in *GetTicketsForUserChannelRequest) (*GetTicketsForUserChannelResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTicketsForUserChannel"
	out := new(GetTicketsForUserChannelResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// =========================
// Subscriptions JSON Client
// =========================

type subscriptionsJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsJSONClient creates a JSON client that implements the Subscriptions interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewSubscriptionsJSONClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsJSONClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateSubscription"
	out := new(CreateSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateSubscription"
	out := new(UpdateSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateTicketOriginID(ctx context.Context, in *UpdateTicketOriginIDRequest) (*UpdateTicketOriginIDResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateTicketOriginID"
	out := new(UpdateTicketOriginIDResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserExpiredSubscriptions"
	out := new(ListUserExpiredSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptionsWithPaymentsData"
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelSubscriptions"
	out := new(GetChannelSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetFormerSubscribers(ctx context.Context, in *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetFormerSubscribers"
	out := new(GetFormerSubscribersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetSubscriptionByID(ctx context.Context, in *GetSubscriptionByIDRequest) (*GetSubscriptionByIDResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriptionByID"
	out := new(GetSubscriptionByIDResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetTicketsByIDs(ctx context.Context, in *GetTicketsByIDsRequest) (*GetTicketsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTicketsByIDs"
	out := new(GetTicketsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetHistoricalUserTickets(ctx context.Context, in *GetHistoricalUserTicketsRequest) (*GetHistoricalUserTicketsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetHistoricalUserTickets"
	out := new(GetHistoricalUserTicketsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) TakedownBadges(ctx context.Context, in *TakedownBadgesRequest) (*TakedownBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownBadges"
	out := new(TakedownBadgesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) TakedownAllBadges(ctx context.Context, in *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownAllBadges"
	out := new(TakedownAllBadgesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetSubscriberBadge(ctx context.Context, in *GetSubscriberBadgeRequest) (*GetSubscriberBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriberBadge"
	out := new(GetSubscriberBadgeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelBadge(ctx context.Context, in *GetChannelBadgeRequest) (*GetChannelBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelBadge"
	out := new(GetChannelBadgeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) DeleteChannelBadge(ctx context.Context, in *DeleteChannelBadgeRequest) (*DeleteChannelBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "DeleteChannelBadge"
	out := new(DeleteChannelBadgeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateChannelBadgeUploadConfig(ctx context.Context, in *CreateChannelBadgeUploadConfigRequest) (*CreateChannelBadgeUploadConfigResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChannelBadgeUploadConfig"
	out := new(CreateChannelBadgeUploadConfigResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateChannelBadge(ctx context.Context, in *CreateChannelBadgeRequest) (*CreateChannelBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChannelBadge"
	out := new(CreateChannelBadgeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetTimeoutStatuses(ctx context.Context, in *GetTimeoutStatusesRequest) (*GetTimeoutStatusesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTimeoutStatuses"
	out := new(GetTimeoutStatusesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetAllUsedChatNotificationTokens(ctx context.Context, in *GetAllUsedChatNotificationTokensRequest) (*GetAllUsedChatNotificationTokensResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllUsedChatNotificationTokens"
	out := new(GetAllUsedChatNotificationTokensResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) AllowReplayForLastUsedChatNotificationToken(ctx context.Context, in *AllowReplayForLastUsedChatNotificationTokenRequest) (*AllowReplayForLastUsedChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "AllowReplayForLastUsedChatNotificationToken"
	out := new(AllowReplayForLastUsedChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) FulfillPaidUpgrade(ctx context.Context, in *FulfillPaidUpgradeRequest) (*FulfillPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillPaidUpgrade"
	out := new(FulfillPaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) InsertGift(ctx context.Context, in *InsertGiftRequest) (*InsertGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "InsertGift"
	out := new(InsertGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPaidUpgradePromotion(ctx context.Context, in *GetPaidUpgradePromotionRequest) (*GetPaidUpgradePromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgradePromotion"
	out := new(GetPaidUpgradePromotionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSenderGift(ctx context.Context, in *CanSenderGiftRequest) (*CanSenderGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSenderGift"
	out := new(CanSenderGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGiftRecipient(ctx context.Context, in *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGiftRecipient"
	out := new(CanGiftRecipientResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) FulfillGifts(ctx context.Context, in *FulfillGiftsRequest) (*FulfillGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillGifts"
	out := new(FulfillGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendGiftChatNotification(ctx context.Context, in *SendGiftChatNotificationRequest) (*SendGiftChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendGiftChatNotification"
	out := new(SendGiftChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendMMGChatNotification(ctx context.Context, in *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGChatNotification"
	out := new(SendMMGChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendMMGStartChatNotification(ctx context.Context, in *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGStartChatNotification"
	out := new(SendMMGStartChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetRelatedChannels(ctx context.Context, in *GetRelatedChannelsRequest) (*GetRelatedChannelsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetRelatedChannels"
	out := new(GetRelatedChannelsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGiftOffers(ctx context.Context, in *GetGiftOffersRequest) (*GetGiftOffersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftOffers"
	out := new(GetGiftOffersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) DeleteEmoticon(ctx context.Context, in *DeleteEmoticonRequest) (*DeleteEmoticonResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "DeleteEmoticon"
	out := new(DeleteEmoticonResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticonsByIDs(ctx context.Context, in *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs"
	out := new(GetPendingEmoticonsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ReviewPendingEmoticons(ctx context.Context, in *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ReviewPendingEmoticons"
	out := new(ReviewPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetProductsByNames(ctx context.Context, in *GetProductsByNamesRequest) (*GetProductsByNamesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByNames"
	out := new(GetProductsByNamesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailSubscribers(ctx context.Context, in *EmailSubscribersRequest) (*EmailSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailSubscribers"
	out := new(EmailSubscribersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailGlobalEmote(ctx context.Context, in *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailGlobalEmote"
	out := new(EmailGlobalEmoteResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailPendingPrefixApproval(ctx context.Context, in *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailPendingPrefixApproval"
	out := new(EmailPendingPrefixApprovalResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetTicketsForUserChannel(ctx context.Context, in *GetTicketsForUserChannelRequest) (*GetTicketsForUserChannelResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTicketsForUserChannel"
	out := new(GetTicketsForUserChannelResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// ============================
// Subscriptions Server Handler
// ============================

type subscriptionsServer struct {
	Subscriptions
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewSubscriptionsServer(svc Subscriptions, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &subscriptionsServer{
		Subscriptions: svc,
		hooks:         hooks,
		ctxSource:     ctxSrc,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *subscriptionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		writeErrorPreV3(ctx, resp, err, s.hooks)
	} else {
		writeErrorPostV3(ctx, resp, err, s.hooks)
	}
}

// SubscriptionsPathPrefix is used for all URL paths on a twirp Subscriptions server.
// Requests are always: POST SubscriptionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SubscriptionsPathPrefix = "/twirp/code.justin.tv.revenue.subscriptions.Subscriptions/"

// SubscriptionsPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const SubscriptionsPathPrefixOld = "/v2/code.justin.tv.revenue.subscriptions.Subscriptions/"

func (s *subscriptionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Subscriptions")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}

	switch req.URL.Path {
	case SubscriptionsPathPrefix + "FulfillSubscription", SubscriptionsPathPrefixOld + "FulfillSubscription", "/v1/Subscriptions/FulfillSubscription":
		s.serveFulfillSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateSubscription", SubscriptionsPathPrefixOld + "CreateSubscription", "/v1/Subscriptions/CreateSubscription":
		s.serveCreateSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelSubscription", SubscriptionsPathPrefixOld + "CancelSubscription", "/v1/Subscriptions/CancelSubscription":
		s.serveCancelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateSubscription", SubscriptionsPathPrefixOld + "UpdateSubscription", "/v1/Subscriptions/UpdateSubscription":
		s.serveUpdateSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateTicketOriginID", SubscriptionsPathPrefixOld + "UpdateTicketOriginID", "/v1/Subscriptions/UpdateTicketOriginID":
		s.serveUpdateTicketOriginID(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSubscribe", SubscriptionsPathPrefixOld + "CanSubscribe", "/v1/Subscriptions/CanSubscribe":
		s.serveCanSubscribe(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ListUserSubscriptions", SubscriptionsPathPrefixOld + "ListUserSubscriptions", "/v1/Subscriptions/ListUserSubscriptions":
		s.serveListUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ListUserExpiredSubscriptions", SubscriptionsPathPrefixOld + "ListUserExpiredSubscriptions", "/v1/Subscriptions/ListUserExpiredSubscriptions":
		s.serveListUserExpiredSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData", SubscriptionsPathPrefixOld + "GetUserChannelSubscriptionWithPaymentsData", "/v1/Subscriptions/GetUserChannelSubscriptionWithPaymentsData":
		s.serveGetUserChannelSubscriptionWithPaymentsData(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSubscriptions", SubscriptionsPathPrefixOld + "GetUserSubscriptions", "/v1/Subscriptions/GetUserSubscriptions":
		s.serveGetUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscription", SubscriptionsPathPrefixOld + "GetUserChannelSubscription", "/v1/Subscriptions/GetUserChannelSubscription":
		s.serveGetUserChannelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserProductSubscriptions", SubscriptionsPathPrefixOld + "GetUserProductSubscriptions", "/v1/Subscriptions/GetUserProductSubscriptions":
		s.serveGetUserProductSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserProductSubscriptionsWithPaymentsData", SubscriptionsPathPrefixOld + "GetUserProductSubscriptionsWithPaymentsData", "/v1/Subscriptions/GetUserProductSubscriptionsWithPaymentsData":
		s.serveGetUserProductSubscriptionsWithPaymentsData(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelSubscriptions", SubscriptionsPathPrefixOld + "GetChannelSubscriptions", "/v1/Subscriptions/GetChannelSubscriptions":
		s.serveGetChannelSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetFormerSubscribers", SubscriptionsPathPrefixOld + "GetFormerSubscribers", "/v1/Subscriptions/GetFormerSubscribers":
		s.serveGetFormerSubscribers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetSubscriptionByID", SubscriptionsPathPrefixOld + "GetSubscriptionByID", "/v1/Subscriptions/GetSubscriptionByID":
		s.serveGetSubscriptionByID(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetTicketsByIDs", SubscriptionsPathPrefixOld + "GetTicketsByIDs", "/v1/Subscriptions/GetTicketsByIDs":
		s.serveGetTicketsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetHistoricalUserTickets", SubscriptionsPathPrefixOld + "GetHistoricalUserTickets", "/v1/Subscriptions/GetHistoricalUserTickets":
		s.serveGetHistoricalUserTickets(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "TakedownBadges", SubscriptionsPathPrefixOld + "TakedownBadges", "/v1/Subscriptions/TakedownBadges":
		s.serveTakedownBadges(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "TakedownAllBadges", SubscriptionsPathPrefixOld + "TakedownAllBadges", "/v1/Subscriptions/TakedownAllBadges":
		s.serveTakedownAllBadges(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetSubscriberBadge", SubscriptionsPathPrefixOld + "GetSubscriberBadge", "/v1/Subscriptions/GetSubscriberBadge":
		s.serveGetSubscriberBadge(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelBadge", SubscriptionsPathPrefixOld + "GetChannelBadge", "/v1/Subscriptions/GetChannelBadge":
		s.serveGetChannelBadge(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "DeleteChannelBadge", SubscriptionsPathPrefixOld + "DeleteChannelBadge", "/v1/Subscriptions/DeleteChannelBadge":
		s.serveDeleteChannelBadge(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateChannelBadgeUploadConfig", SubscriptionsPathPrefixOld + "CreateChannelBadgeUploadConfig", "/v1/Subscriptions/CreateChannelBadgeUploadConfig":
		s.serveCreateChannelBadgeUploadConfig(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateChannelBadge", SubscriptionsPathPrefixOld + "CreateChannelBadge", "/v1/Subscriptions/CreateChannelBadge":
		s.serveCreateChannelBadge(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetTimeoutStatuses", SubscriptionsPathPrefixOld + "GetTimeoutStatuses", "/v1/Subscriptions/GetTimeoutStatuses":
		s.serveGetTimeoutStatuses(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetScore", SubscriptionsPathPrefixOld + "SetScore", "/v1/Subscriptions/SetScore":
		s.serveSetScore(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CalculateSubscriberCount", SubscriptionsPathPrefixOld + "CalculateSubscriberCount", "/v1/Subscriptions/CalculateSubscriberCount":
		s.serveCalculateSubscriberCount(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateChatNotificationToken", SubscriptionsPathPrefixOld + "CreateChatNotificationToken", "/v1/Subscriptions/CreateChatNotificationToken":
		s.serveCreateChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UseChatNotificationToken", SubscriptionsPathPrefixOld + "UseChatNotificationToken", "/v1/Subscriptions/UseChatNotificationToken":
		s.serveUseChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelChatNotificationToken", SubscriptionsPathPrefixOld + "CancelChatNotificationToken", "/v1/Subscriptions/CancelChatNotificationToken":
		s.serveCancelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken", SubscriptionsPathPrefixOld + "GetUserChannelChatNotificationToken", "/v1/Subscriptions/GetUserChannelChatNotificationToken":
		s.serveGetUserChannelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetAllUsedChatNotificationTokens", SubscriptionsPathPrefixOld + "GetAllUsedChatNotificationTokens", "/v1/Subscriptions/GetAllUsedChatNotificationTokens":
		s.serveGetAllUsedChatNotificationTokens(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "AllowReplayForLastUsedChatNotificationToken", SubscriptionsPathPrefixOld + "AllowReplayForLastUsedChatNotificationToken", "/v1/Subscriptions/AllowReplayForLastUsedChatNotificationToken":
		s.serveAllowReplayForLastUsedChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSettings", SubscriptionsPathPrefixOld + "GetUserSettings", "/v1/Subscriptions/GetUserSettings":
		s.serveGetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetUserSettings", SubscriptionsPathPrefixOld + "SetUserSettings", "/v1/Subscriptions/SetUserSettings":
		s.serveSetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductTemplateSKU", SubscriptionsPathPrefixOld + "GetExternalProductTemplateSKU", "/v1/Subscriptions/GetExternalProductTemplateSKU":
		s.serveGetExternalProductTemplateSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU", SubscriptionsPathPrefixOld + "GetExternalProductPurchasableSKU", "/v1/Subscriptions/GetExternalProductPurchasableSKU":
		s.serveGetExternalProductPurchasableSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPaidUpgrades", SubscriptionsPathPrefixOld + "GetPaidUpgrades", "/v1/Subscriptions/GetPaidUpgrades":
		s.serveGetPaidUpgrades(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "FulfillPaidUpgrade", SubscriptionsPathPrefixOld + "FulfillPaidUpgrade", "/v1/Subscriptions/FulfillPaidUpgrade":
		s.serveFulfillPaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreatePaidUpgrade", SubscriptionsPathPrefixOld + "CreatePaidUpgrade", "/v1/Subscriptions/CreatePaidUpgrade":
		s.serveCreatePaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelPaidUpgrade", SubscriptionsPathPrefixOld + "CancelPaidUpgrade", "/v1/Subscriptions/CancelPaidUpgrade":
		s.serveCancelPaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "InsertGift", SubscriptionsPathPrefixOld + "InsertGift", "/v1/Subscriptions/InsertGift":
		s.serveInsertGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelGift", SubscriptionsPathPrefixOld + "CancelGift", "/v1/Subscriptions/CancelGift":
		s.serveCancelGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGifts", SubscriptionsPathPrefixOld + "GetGifts", "/v1/Subscriptions/GetGifts":
		s.serveGetGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGift", SubscriptionsPathPrefixOld + "CanGift", "/v1/Subscriptions/CanGift":
		s.serveCanGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGiftPromotion", SubscriptionsPathPrefixOld + "GetGiftPromotion", "/v1/Subscriptions/GetGiftPromotion":
		s.serveGetGiftPromotion(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPaidUpgradePromotion", SubscriptionsPathPrefixOld + "GetPaidUpgradePromotion", "/v1/Subscriptions/GetPaidUpgradePromotion":
		s.serveGetPaidUpgradePromotion(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSenderGift", SubscriptionsPathPrefixOld + "CanSenderGift", "/v1/Subscriptions/CanSenderGift":
		s.serveCanSenderGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGiftRecipient", SubscriptionsPathPrefixOld + "CanGiftRecipient", "/v1/Subscriptions/CanGiftRecipient":
		s.serveCanGiftRecipient(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "FulfillGifts", SubscriptionsPathPrefixOld + "FulfillGifts", "/v1/Subscriptions/FulfillGifts":
		s.serveFulfillGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendGiftChatNotification", SubscriptionsPathPrefixOld + "SendGiftChatNotification", "/v1/Subscriptions/SendGiftChatNotification":
		s.serveSendGiftChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendMMGChatNotification", SubscriptionsPathPrefixOld + "SendMMGChatNotification", "/v1/Subscriptions/SendMMGChatNotification":
		s.serveSendMMGChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendMMGStartChatNotification", SubscriptionsPathPrefixOld + "SendMMGStartChatNotification", "/v1/Subscriptions/SendMMGStartChatNotification":
		s.serveSendMMGStartChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetRelatedChannels", SubscriptionsPathPrefixOld + "GetRelatedChannels", "/v1/Subscriptions/GetRelatedChannels":
		s.serveGetRelatedChannels(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGiftOffers", SubscriptionsPathPrefixOld + "GetGiftOffers", "/v1/Subscriptions/GetGiftOffers":
		s.serveGetGiftOffers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmotePrefix", SubscriptionsPathPrefixOld + "GetEmotePrefix", "/v1/Subscriptions/GetEmotePrefix":
		s.serveGetEmotePrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateEmoticon", SubscriptionsPathPrefixOld + "CreateEmoticon", "/v1/Subscriptions/CreateEmoticon":
		s.serveCreateEmoticon(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "DeleteEmoticon", SubscriptionsPathPrefixOld + "DeleteEmoticon", "/v1/Subscriptions/DeleteEmoticon":
		s.serveDeleteEmoticon(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs", SubscriptionsPathPrefixOld + "GetAllEmoticonsByProductIDs", "/v1/Subscriptions/GetAllEmoticonsByProductIDs":
		s.serveGetAllEmoticonsByProductIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPartnerStanding", SubscriptionsPathPrefixOld + "GetPartnerStanding", "/v1/Subscriptions/GetPartnerStanding":
		s.serveGetPartnerStanding(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmoticonPrefix", SubscriptionsPathPrefixOld + "GetEmoticonPrefix", "/v1/Subscriptions/GetEmoticonPrefix":
		s.serveGetEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SubmitEmoticonPrefix", SubscriptionsPathPrefixOld + "SubmitEmoticonPrefix", "/v1/Subscriptions/SubmitEmoticonPrefix":
		s.serveSubmitEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs", SubscriptionsPathPrefixOld + "GetPendingEmoticonsByIDs", "/v1/Subscriptions/GetPendingEmoticonsByIDs":
		s.serveGetPendingEmoticonsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticons", SubscriptionsPathPrefixOld + "GetPendingEmoticons", "/v1/Subscriptions/GetPendingEmoticons":
		s.serveGetPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ReviewPendingEmoticons", SubscriptionsPathPrefixOld + "ReviewPendingEmoticons", "/v1/Subscriptions/ReviewPendingEmoticons":
		s.serveReviewPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetProductsByIDs", SubscriptionsPathPrefixOld + "GetProductsByIDs", "/v1/Subscriptions/GetProductsByIDs":
		s.serveGetProductsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetProductsByNames", SubscriptionsPathPrefixOld + "GetProductsByNames", "/v1/Subscriptions/GetProductsByNames":
		s.serveGetProductsByNames(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelProducts", SubscriptionsPathPrefixOld + "GetChannelProducts", "/v1/Subscriptions/GetChannelProducts":
		s.serveGetChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateProduct", SubscriptionsPathPrefixOld + "UpdateProduct", "/v1/Subscriptions/UpdateProduct":
		s.serveUpdateProduct(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateChannelProducts", SubscriptionsPathPrefixOld + "UpdateChannelProducts", "/v1/Subscriptions/UpdateChannelProducts":
		s.serveUpdateChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailSubscribers", SubscriptionsPathPrefixOld + "EmailSubscribers", "/v1/Subscriptions/EmailSubscribers":
		s.serveEmailSubscribers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailGlobalEmote", SubscriptionsPathPrefixOld + "EmailGlobalEmote", "/v1/Subscriptions/EmailGlobalEmote":
		s.serveEmailGlobalEmote(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailPendingPrefixApproval", SubscriptionsPathPrefixOld + "EmailPendingPrefixApproval", "/v1/Subscriptions/EmailPendingPrefixApproval":
		s.serveEmailPendingPrefixApproval(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetTicketsForUserChannel", SubscriptionsPathPrefixOld + "GetTicketsForUserChannel", "/v1/Subscriptions/GetTicketsForUserChannel":
		s.serveGetTicketsForUserChannel(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}
}

func (s *subscriptionsServer) serveFulfillSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResponse and nil error while calling CreateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResponse and nil error while calling CreateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriptionResponse and nil error while calling UpdateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriptionResponse and nil error while calling UpdateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateTicketOriginID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateTicketOriginIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateTicketOriginIDProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateTicketOriginIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateTicketOriginID")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateTicketOriginIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateTicketOriginIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateTicketOriginID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateTicketOriginIDResponse and nil error while calling UpdateTicketOriginID. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateTicketOriginIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateTicketOriginID")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateTicketOriginIDRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateTicketOriginIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateTicketOriginID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateTicketOriginIDResponse and nil error while calling UpdateTicketOriginID. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribe(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSubscribeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSubscribeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSubscribeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSubscribeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSubscribeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveListUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserExpiredSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUserExpiredSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserExpiredSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveListUserExpiredSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUserExpiredSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserExpiredSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserExpiredSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserProductSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserProductSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserProductSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetFormerSubscribers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetFormerSubscribersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFormerSubscribersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetFormerSubscribersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetFormerSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetFormerSubscribersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFormerSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFormerSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFormerSubscribersResponse and nil error while calling GetFormerSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetFormerSubscribersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetFormerSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFormerSubscribersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFormerSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFormerSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFormerSubscribersResponse and nil error while calling GetFormerSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriptionByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetSubscriptionByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriptionByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetSubscriptionByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriptionByID")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetSubscriptionByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriptionByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriptionByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriptionByIDResponse and nil error while calling GetSubscriptionByID. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriptionByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriptionByID")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSubscriptionByIDRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriptionByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriptionByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriptionByIDResponse and nil error while calling GetSubscriptionByID. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTicketsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetTicketsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTicketsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetTicketsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTicketsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetTicketsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTicketsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTicketsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTicketsByIDsResponse and nil error while calling GetTicketsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTicketsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTicketsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTicketsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTicketsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTicketsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTicketsByIDsResponse and nil error while calling GetTicketsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetHistoricalUserTickets(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetHistoricalUserTicketsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHistoricalUserTicketsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetHistoricalUserTicketsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetHistoricalUserTickets")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetHistoricalUserTicketsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetHistoricalUserTicketsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetHistoricalUserTickets(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetHistoricalUserTicketsResponse and nil error while calling GetHistoricalUserTickets. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetHistoricalUserTicketsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetHistoricalUserTickets")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetHistoricalUserTicketsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetHistoricalUserTicketsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetHistoricalUserTickets(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetHistoricalUserTicketsResponse and nil error while calling GetHistoricalUserTickets. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownBadges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveTakedownBadgesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownBadgesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveTakedownBadgesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(TakedownBadgesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownBadgesResponse and nil error while calling TakedownBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownBadgesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TakedownBadgesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownBadgesResponse and nil error while calling TakedownBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownAllBadges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveTakedownAllBadgesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownAllBadgesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveTakedownAllBadgesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownAllBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(TakedownAllBadgesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownAllBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownAllBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownAllBadgesResponse and nil error while calling TakedownAllBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownAllBadgesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownAllBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TakedownAllBadgesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownAllBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownAllBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownAllBadgesResponse and nil error while calling TakedownAllBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriberBadge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetSubscriberBadgeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriberBadgeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetSubscriberBadgeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriberBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetSubscriberBadgeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriberBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriberBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberBadgeResponse and nil error while calling GetSubscriberBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriberBadgeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriberBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSubscriberBadgeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriberBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriberBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberBadgeResponse and nil error while calling GetSubscriberBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelBadge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelBadgeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelBadgeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelBadgeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelBadgeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelBadgeResponse and nil error while calling GetChannelBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelBadgeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelBadgeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelBadgeResponse and nil error while calling GetChannelBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveDeleteChannelBadge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveDeleteChannelBadgeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteChannelBadgeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveDeleteChannelBadgeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeleteChannelBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(DeleteChannelBadgeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteChannelBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteChannelBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteChannelBadgeResponse and nil error while calling DeleteChannelBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveDeleteChannelBadgeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeleteChannelBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteChannelBadgeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteChannelBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteChannelBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteChannelBadgeResponse and nil error while calling DeleteChannelBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChannelBadgeUploadConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateChannelBadgeUploadConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChannelBadgeUploadConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateChannelBadgeUploadConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChannelBadgeUploadConfig")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateChannelBadgeUploadConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChannelBadgeUploadConfigResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChannelBadgeUploadConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChannelBadgeUploadConfigResponse and nil error while calling CreateChannelBadgeUploadConfig. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChannelBadgeUploadConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChannelBadgeUploadConfig")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateChannelBadgeUploadConfigRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChannelBadgeUploadConfigResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChannelBadgeUploadConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChannelBadgeUploadConfigResponse and nil error while calling CreateChannelBadgeUploadConfig. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChannelBadge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateChannelBadgeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChannelBadgeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateChannelBadgeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChannelBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateChannelBadgeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChannelBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChannelBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChannelBadgeResponse and nil error while calling CreateChannelBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChannelBadgeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChannelBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateChannelBadgeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChannelBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChannelBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChannelBadgeResponse and nil error while calling CreateChannelBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTimeoutStatuses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetTimeoutStatusesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTimeoutStatusesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetTimeoutStatusesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTimeoutStatuses")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetTimeoutStatusesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTimeoutStatusesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTimeoutStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTimeoutStatusesResponse and nil error while calling GetTimeoutStatuses. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTimeoutStatusesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTimeoutStatuses")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTimeoutStatusesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTimeoutStatusesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTimeoutStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTimeoutStatusesResponse and nil error while calling GetTimeoutStatuses. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScore(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetScoreJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetScoreProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetScoreJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetScoreRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScoreProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetScoreRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCalculateSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCalculateSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCalculateSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CalculateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CalculateSubscriberCountRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUseChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUseChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUseChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UseChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UseChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllUsedChatNotificationTokens(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllUsedChatNotificationTokensJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllUsedChatNotificationTokensProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetAllUsedChatNotificationTokensJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllUsedChatNotificationTokens")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllUsedChatNotificationTokensRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllUsedChatNotificationTokensResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllUsedChatNotificationTokens(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllUsedChatNotificationTokensResponse and nil error while calling GetAllUsedChatNotificationTokens. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllUsedChatNotificationTokensProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllUsedChatNotificationTokens")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllUsedChatNotificationTokensRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllUsedChatNotificationTokensResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllUsedChatNotificationTokens(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllUsedChatNotificationTokensResponse and nil error while calling GetAllUsedChatNotificationTokens. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveAllowReplayForLastUsedChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveAllowReplayForLastUsedChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllowReplayForLastUsedChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveAllowReplayForLastUsedChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "AllowReplayForLastUsedChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(AllowReplayForLastUsedChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowReplayForLastUsedChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowReplayForLastUsedChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowReplayForLastUsedChatNotificationTokenResponse and nil error while calling AllowReplayForLastUsedChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveAllowReplayForLastUsedChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "AllowReplayForLastUsedChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AllowReplayForLastUsedChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowReplayForLastUsedChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowReplayForLastUsedChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowReplayForLastUsedChatNotificationTokenResponse and nil error while calling AllowReplayForLastUsedChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductTemplateSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductTemplateSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductTemplateSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductTemplateSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductPurchasableSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductPurchasableSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductPurchasableSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductPurchasableSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgrades(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPaidUpgradesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPaidUpgradesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPaidUpgradesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPaidUpgradesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPaidUpgradesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillPaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillPaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillPaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillPaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillPaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillPaidUpgradeResponse and nil error while calling FulfillPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillPaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillPaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillPaidUpgradeResponse and nil error while calling FulfillPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreatePaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreatePaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreatePaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreatePaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelPaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelPaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelPaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelPaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelPaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveInsertGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveInsertGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInsertGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveInsertGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "InsertGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(InsertGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InsertGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InsertGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InsertGiftResponse and nil error while calling InsertGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveInsertGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "InsertGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InsertGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InsertGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InsertGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InsertGiftResponse and nil error while calling InsertGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftPromotionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftPromotionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftPromotionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftPromotionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftPromotionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradePromotion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPaidUpgradePromotionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPaidUpgradePromotionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPaidUpgradePromotionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgradePromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPaidUpgradePromotionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradePromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgradePromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradePromotionResponse and nil error while calling GetPaidUpgradePromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradePromotionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgradePromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPaidUpgradePromotionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradePromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgradePromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradePromotionResponse and nil error while calling GetPaidUpgradePromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSenderGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSenderGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSenderGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSenderGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSenderGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSenderGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSenderGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSenderGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSenderGiftResponse and nil error while calling CanSenderGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSenderGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSenderGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSenderGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSenderGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSenderGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSenderGiftResponse and nil error while calling CanSenderGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftRecipient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftRecipientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftRecipientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftRecipientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGiftRecipient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRecipientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftRecipientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGiftRecipient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftRecipientResponse and nil error while calling CanGiftRecipient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftRecipientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGiftRecipient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRecipientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftRecipientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGiftRecipient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftRecipientResponse and nil error while calling CanGiftRecipient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillGiftsResponse and nil error while calling FulfillGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillGiftsResponse and nil error while calling FulfillGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendGiftChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendGiftChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendGiftChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendGiftChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendGiftChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendGiftChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendGiftChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendGiftChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendGiftChatNotificationResponse and nil error while calling SendGiftChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendGiftChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendGiftChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendGiftChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendGiftChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendGiftChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendGiftChatNotificationResponse and nil error while calling SendGiftChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendMMGChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMMGChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendMMGChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendMMGChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGChatNotificationResponse and nil error while calling SendMMGChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMMGChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGChatNotificationResponse and nil error while calling SendMMGChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGStartChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendMMGStartChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMMGStartChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendMMGStartChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGStartChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendMMGStartChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGStartChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGStartChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGStartChatNotificationResponse and nil error while calling SendMMGStartChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGStartChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGStartChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMMGStartChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGStartChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGStartChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGStartChatNotificationResponse and nil error while calling SendMMGStartChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetRelatedChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetRelatedChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRelatedChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetRelatedChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetRelatedChannels")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetRelatedChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRelatedChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRelatedChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRelatedChannelsResponse and nil error while calling GetRelatedChannels. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetRelatedChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetRelatedChannels")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRelatedChannelsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRelatedChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRelatedChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRelatedChannelsResponse and nil error while calling GetRelatedChannels. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftOffers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftOffersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftOffersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftOffersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftOffers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftOffersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftOffersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftOffers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftOffersResponse and nil error while calling GetGiftOffers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftOffersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftOffers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftOffersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftOffersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftOffers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftOffersResponse and nil error while calling GetGiftOffers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmotePrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmotePrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmotePrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmotePrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmotePrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveDeleteEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveDeleteEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveDeleteEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeleteEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(DeleteEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEmoticonResponse and nil error while calling DeleteEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveDeleteEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DeleteEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteEmoticonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEmoticonResponse and nil error while calling DeleteEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllEmoticonsByProductIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmoticonsByProductIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStanding(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPartnerStandingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPartnerStandingProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPartnerStandingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPartnerStandingRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStandingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPartnerStandingRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSubmitEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SubmitEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SubmitEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticonsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticonsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsByIDsResponse and nil error while calling GetPendingEmoticonsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticonsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticonsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsByIDsResponse and nil error while calling GetPendingEmoticonsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveReviewPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveReviewPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveReviewPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveReviewPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ReviewPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ReviewPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReviewPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ReviewPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReviewPendingEmoticonsResponse and nil error while calling ReviewPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveReviewPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ReviewPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ReviewPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReviewPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ReviewPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReviewPendingEmoticonsResponse and nil error while calling ReviewPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetProductsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetProductsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetProductsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProductsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByNames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetProductsByNamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByNamesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetProductsByNamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByNames")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetProductsByNamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByNamesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByNamesResponse and nil error while calling GetProductsByNames. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByNamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByNames")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProductsByNamesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByNamesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByNamesResponse and nil error while calling GetProductsByNames. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProduct(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateProductJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProductProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateProductJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateProductRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProductProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateProductRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailSubscribers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailSubscribersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailSubscribersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailSubscribersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailSubscribersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailSubscribersResponse and nil error while calling EmailSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailSubscribersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailSubscribersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailSubscribersResponse and nil error while calling EmailSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailGlobalEmote(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailGlobalEmoteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailGlobalEmoteProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailGlobalEmoteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailGlobalEmote")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailGlobalEmoteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailGlobalEmoteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailGlobalEmote(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailGlobalEmoteResponse and nil error while calling EmailGlobalEmote. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailGlobalEmoteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailGlobalEmote")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailGlobalEmoteRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailGlobalEmoteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailGlobalEmote(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailGlobalEmoteResponse and nil error while calling EmailGlobalEmote. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailPendingPrefixApproval(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailPendingPrefixApprovalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailPendingPrefixApprovalProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailPendingPrefixApprovalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailPendingPrefixApproval")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailPendingPrefixApprovalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailPendingPrefixApprovalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailPendingPrefixApproval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailPendingPrefixApprovalResponse and nil error while calling EmailPendingPrefixApproval. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailPendingPrefixApprovalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailPendingPrefixApproval")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailPendingPrefixApprovalRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailPendingPrefixApprovalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailPendingPrefixApproval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailPendingPrefixApprovalResponse and nil error while calling EmailPendingPrefixApproval. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTicketsForUserChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetTicketsForUserChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTicketsForUserChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetTicketsForUserChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTicketsForUserChannel")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetTicketsForUserChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTicketsForUserChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTicketsForUserChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTicketsForUserChannelResponse and nil error while calling GetTicketsForUserChannel. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTicketsForUserChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTicketsForUserChannel")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTicketsForUserChannelRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTicketsForUserChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTicketsForUserChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTicketsForUserChannelResponse and nil error while calling GetTicketsForUserChannel. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *subscriptionsServer) ProtocGenTwirpVersion() string {
	return "v4.7.0"
}

// =====
// Utils
// =====

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshaled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
// NOTE: not compatible with old v1/v2 clients (only returns v3+ errors)
func WriteError(resp http.ResponseWriter, err error) {
	writeErrorPostV3(nil, resp, err, nil) // does not trigger server hooks
}

// writeErrorPostV3 writes Twirp v3+ errors in the response.
func writeErrorPostV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// writeErrorPreV3 writes Twirp v1/v2 backwards-compatible errors in the response.
// This is to make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func writeErrorPreV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt1.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt1.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto1.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

var twirpFileDescriptor0 = []byte{
	// 7947 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x7d, 0x5b, 0x6c, 0x1b, 0xd9,
	0x95, 0x60, 0x17, 0x49, 0x49, 0xe4, 0x21, 0x25, 0x51, 0x65, 0x5b, 0x96, 0xe9, 0x77, 0xd9, 0xdd,
	0xe9, 0x68, 0x13, 0x35, 0x5a, 0xed, 0x7e, 0x3f, 0x6c, 0x4a, 0xa2, 0xd5, 0x6c, 0x5b, 0x8f, 0x2e,
	0x51, 0xed, 0x76, 0xa7, 0x93, 0x4a, 0x89, 0x75, 0x25, 0x57, 0x5c, 0xac, 0x62, 0x57, 0x15, 0x2d,
	0x29, 0xdb, 0x40, 0x16, 0xc8, 0x2e, 0xb2, 0xbb, 0xd9, 0x04, 0x59, 0x24, 0xbb, 0xd9, 0x47, 0x36,
	0x08, 0xb2, 0x48, 0x90, 0xfd, 0x0a, 0x10, 0x64, 0x81, 0x2c, 0xb2, 0x3f, 0x41, 0x30, 0x18, 0x60,
	0xe6, 0x23, 0x83, 0x19, 0x24, 0x18, 0x60, 0x3e, 0x02, 0x0c, 0x30, 0x18, 0x0c, 0x30, 0x18, 0x60,
	0xfe, 0x06, 0x33, 0x3f, 0x83, 0xfb, 0xa8, 0x27, 0xab, 0xc8, 0x5b, 0xa4, 0xdc, 0x93, 0xc7, 0x8f,
	0xad, 0x7b, 0xea, 0xde, 0x73, 0xcf, 0x3d, 0xe7, 0xdc, 0x73, 0xcf, 0x7d, 0x9c, 0x43, 0x38, 0xe7,
	0x1e, 0xea, 0x76, 0xf7, 0x19, 0xa7, 0xb7, 0xe7, 0xb4, 0x6d, 0xbd, 0xeb, 0xea, 0x96, 0xe9, 0x2c,
	0x75, 0x6d, 0xcb, 0xb5, 0xc4, 0xeb, 0x6d, 0x4b, 0x43, 0x4b, 0x9f, 0xeb, 0x39, 0xae, 0x6e, 0x2e,
	0xb9, 0x8f, 0x96, 0x6c, 0xf4, 0x08, 0x99, 0x3d, 0xb4, 0x14, 0xa9, 0x5b, 0xbb, 0x7c, 0x60, 0x59,
	0x07, 0x06, 0x7a, 0x86, 0xb4, 0xd9, 0xeb, 0xed, 0x3f, 0xe3, 0xea, 0x1d, 0xe4, 0xb8, 0x6a, 0xa7,
	0x4b, 0xd1, 0x48, 0xff, 0x55, 0x80, 0xab, 0x8d, 0x8e, 0xaa, 0x1b, 0xdb, 0xc8, 0xd4, 0x74, 0xf3,
	0x60, 0xdb, 0x46, 0xfb, 0xfa, 0x51, 0xbd, 0xdb, 0xb5, 0xad, 0x47, 0xaa, 0x21, 0xa3, 0x0f, 0x7a,
	0xc8, 0x71, 0xc5, 0xb3, 0x30, 0xd5, 0x73, 0x90, 0xad, 0xe8, 0xda, 0x82, 0x70, 0x45, 0x78, 0xba,
	0x24, 0x4f, 0xe2, 0x62, 0x53, 0x13, 0xe7, 0x61, 0xb2, 0x4b, 0x5a, 0x2c, 0xe4, 0x28, 0x9c, 0x96,
	0xc4, 0xd3, 0x30, 0xe1, 0xb8, 0xaa, 0x8b, 0x16, 0xf2, 0x04, 0x4c, 0x0b, 0xe2, 0x22, 0xcc, 0xa2,
	0x8e, 0xe5, 0xea, 0x6d, 0xcb, 0x54, 0x1c, 0xe4, 0x62, 0x74, 0x05, 0xfc, 0x7d, 0x25, 0xb7, 0x20,
	0xc8, 0xd3, 0xde, 0xa7, 0x1d, 0xe4, 0x36, 0x35, 0xe9, 0x3a, 0x48, 0x83, 0xe8, 0x72, 0xba, 0x96,
	0xe9, 0x20, 0xc9, 0x85, 0xb3, 0xa4, 0xd6, 0xba, 0x61, 0xed, 0xa9, 0x46, 0xa3, 0x63, 0xb9, 0xc8,
	0xa3, 0xf9, 0x22, 0x80, 0x75, 0x68, 0x22, 0x5b, 0x31, 0xd5, 0x0e, 0x62, 0x64, 0x97, 0x08, 0x64,
	0x53, 0xed, 0x20, 0xf1, 0x32, 0x94, 0xe9, 0x67, 0x84, 0xdb, 0x33, 0xf2, 0x69, 0x0b, 0x82, 0x51,
	0x3c, 0x07, 0x45, 0x4c, 0x11, 0xc2, 0x54, 0xd2, 0x51, 0x4c, 0x91, 0x72, 0x53, 0x93, 0x6a, 0xb0,
	0xd0, 0xdf, 0x2b, 0xa3, 0x68, 0x8f, 0x51, 0xb4, 0x43, 0xe5, 0xb0, 0x87, 0x6c, 0x27, 0x44, 0x51,
	0xfb, 0x81, 0x6a, 0x9a, 0xc8, 0x08, 0x18, 0x59, 0x62, 0x90, 0xa6, 0x86, 0x79, 0xe6, 0xea, 0xae,
	0x81, 0x18, 0x2d, 0xb4, 0x20, 0x8a, 0x50, 0x70, 0xd1, 0x91, 0xcb, 0x48, 0x20, 0x7f, 0xfb, 0xfd,
	0x47, 0xfa, 0x60, 0xfd, 0x7f, 0x0a, 0xa6, 0x1b, 0x8c, 0x91, 0x77, 0xd1, 0x23, 0x64, 0x88, 0xd7,
	0x60, 0xba, 0xa3, 0x9b, 0x7a, 0xa7, 0xd7, 0x51, 0x9c, 0xb6, 0x65, 0x53, 0x56, 0xe4, 0xe5, 0x0a,
	0x03, 0xee, 0x60, 0x98, 0xf8, 0x24, 0xcc, 0xf8, 0x92, 0x31, 0xf4, 0x8e, 0xee, 0x12, 0x22, 0xf2,
	0x81, 0x50, 0xee, 0x62, 0xa0, 0xf4, 0x29, 0x98, 0xdd, 0x41, 0x2e, 0x69, 0xc2, 0x39, 0xa8, 0x8f,
	0x43, 0xd5, 0xf1, 0xa9, 0x64, 0x04, 0x50, 0xd4, 0xb3, 0x01, 0x9c, 0x20, 0x94, 0x7e, 0x22, 0x40,
	0x35, 0xc0, 0x4e, 0x87, 0x93, 0xd8, 0x5e, 0x48, 0x6c, 0xcf, 0x39, 0x06, 0x51, 0x06, 0x30, 0xd1,
	0x91, 0xab, 0x18, 0x98, 0x3b, 0x84, 0xad, 0xe5, 0xe5, 0xe7, 0x96, 0x78, 0x66, 0xd3, 0x52, 0x84,
	0xb1, 0x72, 0x09, 0xa3, 0x21, 0x7f, 0x4a, 0xff, 0xaf, 0x00, 0x73, 0x3b, 0xa1, 0xaa, 0xab, 0x56,
	0xcf, 0x74, 0xc9, 0x24, 0x08, 0x11, 0x4c, 0x0b, 0xb1, 0xfe, 0x73, 0x27, 0xd1, 0xbf, 0xe8, 0xc2,
	0x6c, 0x1b, 0x77, 0xa9, 0xec, 0xd9, 0x48, 0x7d, 0xa8, 0x59, 0x87, 0xe6, 0x42, 0xfe, 0x4a, 0xfe,
	0xe9, 0xf2, 0xf2, 0x1d, 0x3e, 0xc4, 0x7d, 0xb4, 0x2f, 0x91, 0x7f, 0x57, 0x3c, 0x6c, 0x0d, 0xd3,
	0xb5, 0x8f, 0xe5, 0x99, 0x76, 0x04, 0x88, 0x7b, 0x25, 0x43, 0x0a, 0xf5, 0x5a, 0x18, 0xaf, 0x57,
	0x22, 0xc8, 0x78, 0xaf, 0x4e, 0x04, 0x28, 0x5e, 0x85, 0x8a, 0xab, 0xb7, 0x1f, 0x22, 0x57, 0x21,
	0xe4, 0x2c, 0x4c, 0x10, 0xe6, 0x96, 0x29, 0x8c, 0x32, 0xbe, 0x5f, 0x13, 0x26, 0x13, 0x34, 0xa1,
	0x56, 0x87, 0x53, 0x09, 0xc3, 0x14, 0xab, 0x90, 0x7f, 0x88, 0x8e, 0x99, 0x2a, 0xe3, 0x3f, 0xb1,
	0x20, 0x1f, 0xa9, 0x46, 0xcf, 0xd3, 0x5c, 0x5a, 0x78, 0x25, 0xf7, 0x92, 0x80, 0x51, 0x24, 0xd0,
	0x9c, 0x05, 0x85, 0x74, 0x0b, 0x2e, 0xaf, 0xaa, 0x46, 0xbb, 0x67, 0xa8, 0x2e, 0x0a, 0x26, 0x34,
	0x21, 0x8c, 0x6f, 0x8e, 0x49, 0x9f, 0x87, 0x2b, 0xe9, 0x18, 0xd8, 0x3c, 0x7a, 0x07, 0x00, 0x33,
	0x9f, 0xf1, 0x4c, 0x20, 0x5a, 0xf7, 0xe2, 0x88, 0x62, 0x92, 0x4b, 0xb8, 0x02, 0xf9, 0x53, 0x7a,
	0x16, 0xe6, 0xd7, 0x91, 0xbb, 0xeb, 0x20, 0x7b, 0x07, 0xb9, 0xae, 0x6e, 0x1e, 0x38, 0xc3, 0xd6,
	0x0c, 0xe9, 0x67, 0x02, 0x9c, 0xed, 0x6b, 0xc3, 0xc8, 0x5c, 0x83, 0xcb, 0x07, 0xfa, 0xbe, 0xeb,
	0x28, 0xba, 0xa9, 0xec, 0x5b, 0x86, 0x61, 0x1d, 0x22, 0x4d, 0x61, 0x23, 0x75, 0x14, 0xcb, 0x34,
	0x28, 0x53, 0x8b, 0xf2, 0x79, 0x52, 0xad, 0x69, 0xde, 0x66, 0x95, 0x56, 0x59, 0x9d, 0x2d, 0xd3,
	0x38, 0x16, 0x9f, 0x82, 0xd9, 0x07, 0xba, 0x86, 0x14, 0x5c, 0x87, 0x8d, 0x38, 0x47, 0x5a, 0x4d,
	0x63, 0xf0, 0xba, 0xbe, 0xcf, 0xf4, 0xe4, 0x25, 0x58, 0x20, 0xf5, 0xc2, 0xe3, 0x55, 0xf0, 0x52,
	0xd5, 0x73, 0x88, 0x61, 0x28, 0xca, 0xf3, 0xf8, 0x7b, 0x98, 0x01, 0x3b, 0xe4, 0xab, 0xf4, 0xc7,
	0x79, 0x98, 0xdf, 0xc9, 0x36, 0x6e, 0x9e, 0xb1, 0xe5, 0x86, 0x8f, 0xed, 0x4b, 0x02, 0x7c, 0xcc,
	0x46, 0x6d, 0xa4, 0x3f, 0xa2, 0xe3, 0x1b, 0x84, 0x8e, 0x1a, 0xb7, 0x65, 0x3e, 0x31, 0x6f, 0x91,
	0xff, 0x55, 0x63, 0xc5, 0xb2, 0x0c, 0x59, 0x62, 0x5d, 0xac, 0x0f, 0xa0, 0xe4, 0xbd, 0x7e, 0x2e,
	0x17, 0x46, 0xee, 0x30, 0x26, 0x19, 0x63, 0x80, 0x64, 0x26, 0x46, 0xee, 0x24, 0x4d, 0x9a, 0x58,
	0x23, 0x77, 0x7e, 0xcb, 0x35, 0xf2, 0x3a, 0x54, 0xc2, 0x63, 0x0d, 0x0c, 0x0e, 0xa5, 0x8e, 0x16,
	0xa4, 0xbf, 0xcb, 0x41, 0x25, 0xdc, 0x58, 0x9c, 0x81, 0x9c, 0xaf, 0xa8, 0x39, 0x5d, 0x8b, 0x99,
	0x9a, 0x5c, 0x7c, 0x39, 0x3f, 0x07, 0x45, 0xea, 0x35, 0x05, 0x4e, 0x11, 0x29, 0x37, 0x49, 0xcb,
	0xae, 0x6d, 0x69, 0xbd, 0x76, 0xe0, 0xd7, 0xc9, 0x25, 0x06, 0x69, 0x6a, 0xe2, 0x79, 0x28, 0x59,
	0xb6, 0x7e, 0xa0, 0x9b, 0xf8, 0xeb, 0x04, 0xf9, 0x5a, 0xa4, 0x80, 0xa6, 0x26, 0xde, 0x84, 0xe9,
	0x3d, 0x64, 0xa2, 0x7d, 0xdd, 0xc5, 0x83, 0xb5, 0xa9, 0xbd, 0x2e, 0x2f, 0xd7, 0x96, 0xa8, 0xfb,
	0xba, 0xe4, 0xb9, 0xaf, 0x4b, 0x2d, 0xcf, 0x7d, 0x95, 0x2b, 0xac, 0xc1, 0x0e, 0xae, 0x2f, 0xbe,
	0x0a, 0x65, 0x0f, 0x01, 0x32, 0xb5, 0x85, 0xa9, 0xa1, 0xcd, 0x81, 0x55, 0x6f, 0x98, 0x1a, 0x76,
	0x05, 0xd5, 0x76, 0x1b, 0x39, 0x8e, 0x72, 0xd0, 0xd3, 0xb5, 0x85, 0x22, 0x75, 0x05, 0x29, 0x68,
	0xbd, 0xa7, 0x6b, 0xe2, 0xcb, 0x00, 0xbd, 0xae, 0xa6, 0xba, 0x48, 0x53, 0x2c, 0x73, 0xa1, 0x34,
	0x14, 0x79, 0x89, 0xd5, 0xde, 0x32, 0xa5, 0x3a, 0x54, 0x6f, 0x5b, 0x76, 0x07, 0xd9, 0x81, 0x61,
	0xce, 0xc8, 0x73, 0xe9, 0xbb, 0x79, 0xa8, 0xdd, 0xee, 0x19, 0xfb, 0xba, 0x61, 0x84, 0x45, 0xe7,
	0xd9, 0x9b, 0xb0, 0x48, 0x84, 0x41, 0x22, 0xc9, 0x0d, 0x14, 0x49, 0x7e, 0x98, 0x48, 0x0a, 0xe3,
	0x89, 0x64, 0x22, 0x93, 0x48, 0xde, 0x82, 0x62, 0xd7, 0x50, 0xdd, 0x7d, 0xcb, 0xee, 0x10, 0x5d,
	0x98, 0x59, 0x5e, 0xe2, 0x9b, 0xef, 0xdb, 0xac, 0x95, 0xec, 0xb7, 0x17, 0xdb, 0x30, 0x17, 0x99,
	0x4e, 0xee, 0x71, 0x17, 0x11, 0x0d, 0x99, 0x59, 0x7e, 0x21, 0xfb, 0x0a, 0xd8, 0x3a, 0xee, 0x22,
	0xb9, 0xea, 0xc4, 0x20, 0x52, 0x0f, 0xce, 0x27, 0xca, 0xc8, 0x5f, 0x7e, 0x2b, 0xe1, 0x26, 0x6c,
	0x01, 0x5e, 0xce, 0xde, 0xbd, 0x1c, 0xc1, 0x23, 0xfd, 0x32, 0x07, 0xe7, 0x56, 0x6d, 0x14, 0x2c,
	0xfc, 0xbf, 0xfb, 0xaa, 0x91, 0x28, 0xce, 0xc9, 0x13, 0x16, 0xa7, 0x0b, 0xb5, 0x24, 0xb6, 0x3e,
	0x66, 0x69, 0xda, 0x70, 0x6e, 0x55, 0x35, 0xdb, 0xe8, 0x23, 0x9c, 0xe7, 0xd2, 0x05, 0xa8, 0x25,
	0xf5, 0xc9, 0x76, 0x93, 0xff, 0x5f, 0x80, 0x73, 0xbb, 0xc4, 0x98, 0x25, 0x91, 0x54, 0x0d, 0x0c,
	0xd9, 0x9b, 0x4f, 0x10, 0x53, 0x76, 0x8b, 0x3a, 0xbe, 0x74, 0x57, 0xf3, 0x09, 0x6e, 0x86, 0xdc,
	0x41, 0xc7, 0x6f, 0x3e, 0x41, 0x1d, 0xe5, 0x98, 0x6e, 0xe4, 0xb3, 0xe8, 0xc6, 0xca, 0x4c, 0x54,
	0x30, 0x78, 0x70, 0x49, 0xd4, 0xb3, 0xc1, 0xfd, 0x9b, 0x1c, 0x9c, 0x5a, 0x55, 0x4d, 0xdf, 0x32,
	0x8f, 0xcf, 0xe9, 0xb0, 0xd9, 0xca, 0x3f, 0x0e, 0xb3, 0x55, 0x38, 0x61, 0x3d, 0x7f, 0x15, 0x4e,
	0x47, 0x39, 0xc0, 0x34, 0xfc, 0x1a, 0x4c, 0xb7, 0x55, 0x53, 0xf1, 0xb7, 0xd8, 0xcc, 0x8b, 0xa8,
	0xb4, 0x43, 0x95, 0xa5, 0xff, 0x22, 0xc0, 0x79, 0xca, 0xde, 0x16, 0xd9, 0x7c, 0x6d, 0x51, 0x9d,
	0x5a, 0xf3, 0xf8, 0x78, 0x1e, 0x4a, 0x6c, 0xa7, 0xe6, 0x33, 0xb2, 0x48, 0x01, 0x4d, 0x4d, 0x94,
	0x60, 0xda, 0x44, 0x87, 0x4a, 0xa0, 0x98, 0x94, 0x99, 0x65, 0x13, 0x1d, 0x6e, 0x79, 0x86, 0xe6,
	0x79, 0x38, 0x8b, 0xeb, 0x74, 0x7b, 0x76, 0xfb, 0x81, 0xea, 0x20, 0xa5, 0x6b, 0x5b, 0xfb, 0xba,
	0xe1, 0x9f, 0xc8, 0xe4, 0xe5, 0xd3, 0x26, 0x3a, 0xdc, 0x66, 0x5f, 0xb7, 0xe9, 0xc7, 0xa6, 0x26,
	0x5d, 0x82, 0x0b, 0xc9, 0x64, 0x31, 0xb9, 0xff, 0x22, 0x07, 0x17, 0xee, 0xea, 0x0e, 0xf5, 0xf7,
	0xc2, 0x1c, 0xe3, 0x50, 0x80, 0xd3, 0x30, 0x11, 0x3e, 0x5b, 0xa0, 0x05, 0x71, 0x1e, 0x26, 0xdb,
	0x3d, 0xdb, 0xb1, 0x6c, 0x36, 0xbd, 0x58, 0x29, 0xa2, 0x0f, 0x85, 0x31, 0xf5, 0x41, 0x85, 0xc9,
	0x7d, 0xdd, 0x70, 0x91, 0x4d, 0xec, 0xe5, 0xcc, 0x72, 0x93, 0x0f, 0xd3, 0xa0, 0x81, 0x2e, 0xdd,
	0x26, 0x08, 0x65, 0x86, 0x58, 0x7a, 0x11, 0x26, 0x29, 0x44, 0x9c, 0x82, 0x7c, 0xfd, 0xee, 0xdd,
	0xea, 0x13, 0x62, 0x05, 0x8a, 0xdb, 0x77, 0xeb, 0xad, 0xdb, 0x5b, 0xf2, 0x46, 0x55, 0x10, 0x8b,
	0x50, 0x58, 0x6f, 0xde, 0x6e, 0x55, 0x73, 0x18, 0xbe, 0xb9, 0xd5, 0xda, 0x96, 0x9b, 0x1b, 0x8d,
	0x6a, 0x5e, 0x32, 0xe1, 0x9a, 0xd7, 0x4f, 0xe3, 0xa8, 0xab, 0xdb, 0x48, 0x3b, 0x31, 0xbe, 0x5a,
	0xfb, 0xfb, 0x0e, 0x72, 0x99, 0xbc, 0x59, 0x49, 0xea, 0xc0, 0xb3, 0x6c, 0x07, 0xc9, 0xbc, 0xec,
	0x70, 0x77, 0xf7, 0x74, 0xf7, 0xc1, 0xb6, 0x7a, 0xdc, 0x41, 0xa6, 0xeb, 0xac, 0xa9, 0xae, 0xca,
	0x37, 0xad, 0x07, 0x79, 0x60, 0x9f, 0x86, 0xab, 0xe9, 0xdd, 0x8d, 0x8f, 0xfe, 0x6f, 0x0b, 0x50,
	0x8d, 0x8b, 0x48, 0xfc, 0x18, 0xcc, 0x46, 0xa6, 0xbf, 0x8f, 0x75, 0x26, 0x0c, 0x8e, 0xb9, 0xe4,
	0xb9, 0x41, 0xd6, 0x2a, 0x3f, 0x70, 0x5d, 0x28, 0x0c, 0x5b, 0xe4, 0x27, 0xc6, 0x5b, 0xe4, 0x27,
	0x47, 0xf6, 0xff, 0xa6, 0xc6, 0x9c, 0x38, 0x2f, 0x42, 0xc9, 0x46, 0x26, 0x3a, 0x74, 0x14, 0xd5,
	0x25, 0xce, 0xfd, 0x60, 0x32, 0x8a, 0xb4, 0x72, 0xdd, 0x15, 0x9f, 0x86, 0x2a, 0x3a, 0x72, 0x03,
	0xf3, 0xe3, 0x3c, 0xec, 0x11, 0xe7, 0xbf, 0x24, 0xcf, 0xa0, 0x23, 0xd7, 0xb3, 0x3b, 0x3b, 0x0f,
	0x7b, 0x58, 0x06, 0xba, 0xa3, 0x74, 0x6d, 0xbd, 0x83, 0x16, 0x80, 0x58, 0xca, 0x29, 0xdd, 0xd9,
	0xc6, 0x45, 0xf1, 0x2c, 0x4c, 0xe9, 0x0e, 0xd9, 0xf7, 0x2d, 0x94, 0xc9, 0x97, 0x49, 0xdd, 0xc1,
	0xfb, 0x3d, 0x6c, 0x62, 0x75, 0x47, 0xb1, 0xd1, 0x7e, 0xcf, 0xd4, 0xd4, 0x3d, 0x03, 0x2d, 0x54,
	0xa8, 0x89, 0xd5, 0x1d, 0xd9, 0x87, 0xb1, 0xd6, 0x9a, 0x69, 0x6b, 0x0b, 0xd3, 0x5e, 0xeb, 0x35,
	0xd3, 0x8e, 0x6f, 0x49, 0x66, 0xb2, 0x6c, 0x49, 0xfe, 0x93, 0x00, 0xf3, 0x71, 0x75, 0x93, 0x91,
	0xd3, 0x33, 0x5c, 0xf1, 0xbd, 0x44, 0xc7, 0x86, 0x73, 0xb9, 0xe9, 0xc3, 0x19, 0xc1, 0x15, 0xb2,
	0x91, 0xb9, 0xb0, 0x8d, 0x94, 0xfe, 0xad, 0x00, 0x62, 0x02, 0x29, 0x8f, 0xc9, 0xc7, 0x4a, 0x25,
	0xe3, 0x57, 0x02, 0x5c, 0x1f, 0x6c, 0xc3, 0xd8, 0xd2, 0xf8, 0x19, 0x98, 0x8e, 0x74, 0xb6, 0x20,
	0x90, 0x33, 0xcf, 0x97, 0x46, 0xa0, 0x8c, 0x8c, 0x54, 0x8e, 0xa2, 0x13, 0x17, 0x61, 0xee, 0x81,
	0x8a, 0x95, 0x09, 0x3d, 0xd2, 0xad, 0x9e, 0xa3, 0x74, 0xd5, 0x03, 0xc4, 0x0e, 0x0b, 0x66, 0x1f,
	0xa8, 0xce, 0x36, 0x83, 0x6f, 0xab, 0x07, 0x08, 0x2f, 0xa2, 0xb8, 0x2e, 0x39, 0x4f, 0x26, 0xf5,
	0xe8, 0x19, 0x41, 0xf9, 0x81, 0xea, 0x6c, 0x62, 0x15, 0x55, 0x0f, 0x90, 0xf4, 0x87, 0x02, 0x5c,
	0x4c, 0x59, 0x04, 0x7c, 0x77, 0x76, 0xca, 0x26, 0xa4, 0x78, 0x63, 0x79, 0x6d, 0x44, 0x81, 0xd3,
	0xf1, 0x78, 0xc8, 0x4e, 0x7c, 0x24, 0x5f, 0x13, 0x60, 0x39, 0x8b, 0xd9, 0x67, 0xc3, 0x7b, 0x8c,
	0x4a, 0x2d, 0x7d, 0x08, 0xd2, 0xa0, 0x95, 0xe1, 0x31, 0xef, 0x17, 0x3e, 0xeb, 0xf7, 0xbe, 0x4d,
	0x8d, 0x7a, 0xd6, 0x55, 0xf7, 0x32, 0x94, 0x83, 0x05, 0xc2, 0x59, 0xc8, 0x5d, 0xc9, 0x3f, 0x5d,
	0x92, 0xc1, 0x5f, 0x21, 0x1c, 0xe9, 0x0b, 0x70, 0x6d, 0x60, 0x0f, 0x6c, 0x80, 0xef, 0x26, 0xcf,
	0x89, 0x51, 0x46, 0x18, 0x45, 0x24, 0x75, 0x7d, 0x91, 0x27, 0x11, 0x30, 0xc2, 0x52, 0x3f, 0x74,
	0xc8, 0x5f, 0x17, 0xe0, 0xb9, 0x4c, 0x5d, 0x32, 0x1e, 0xbc, 0x9f, 0xcc, 0x83, 0x51, 0xf5, 0x2c,
	0xc6, 0x87, 0x97, 0xe0, 0xbc, 0x77, 0x66, 0x9e, 0x4d, 0xc6, 0xd2, 0x11, 0x5c, 0x48, 0x6e, 0xf9,
	0xd8, 0x65, 0xf7, 0x4f, 0x02, 0x5c, 0x5a, 0x47, 0x6e, 0xc2, 0xcc, 0xc8, 0x70, 0x25, 0x1a, 0x78,
	0x85, 0x13, 0xc9, 0x5e, 0xe1, 0x84, 0xe7, 0x15, 0x8a, 0x07, 0x50, 0xb4, 0x6c, 0x0d, 0xd9, 0xca,
	0xde, 0x31, 0xf3, 0xb6, 0xef, 0xf2, 0x0d, 0x62, 0x30, 0x91, 0x4b, 0x5b, 0x18, 0xe9, 0xca, 0xb1,
	0x3c, 0x65, 0xd1, 0x3f, 0xa4, 0x6b, 0x30, 0xc5, 0x60, 0xd8, 0x23, 0xde, 0xdc, 0xda, 0x6c, 0x54,
	0x9f, 0x10, 0x67, 0x00, 0x76, 0xb7, 0xd7, 0xea, 0xad, 0xc6, 0x9a, 0x52, 0x6f, 0x55, 0x05, 0xe9,
	0x5f, 0xc3, 0xe5, 0x54, 0xbc, 0x8f, 0x9d, 0xf5, 0x9f, 0x23, 0xea, 0x12, 0x3f, 0x79, 0x7c, 0x2c,
	0x6c, 0x97, 0xfe, 0x46, 0x20, 0x1a, 0x96, 0xd0, 0x19, 0x1b, 0xe6, 0x65, 0x28, 0xbb, 0x96, 0xab,
	0x1a, 0xa1, 0xcb, 0xa7, 0x09, 0x19, 0x08, 0x88, 0x9e, 0x7a, 0xbf, 0x0b, 0xe5, 0xe0, 0x32, 0x97,
	0xce, 0x49, 0xee, 0x89, 0x13, 0xef, 0x56, 0x0e, 0xa3, 0x4a, 0x5e, 0x82, 0xf2, 0x9c, 0x4b, 0x50,
	0xa1, 0x7f, 0x09, 0xfa, 0x92, 0x00, 0xb5, 0x75, 0x14, 0xb1, 0x08, 0x2b, 0xc7, 0xc1, 0x8e, 0x77,
	0x1d, 0xa6, 0x9c, 0xde, 0x9e, 0xe2, 0xdd, 0xfd, 0x65, 0x3f, 0x02, 0x99, 0x74, 0xc8, 0x5f, 0xec,
	0x64, 0x25, 0x17, 0x9c, 0xac, 0xf4, 0x1d, 0x6d, 0xf4, 0x88, 0x84, 0xfb, 0x09, 0x79, 0xcc, 0x4b,
	0xce, 0x22, 0xb9, 0xef, 0xa3, 0x1b, 0x6b, 0x07, 0xf7, 0xe8, 0x04, 0x87, 0x41, 0x79, 0x6c, 0x50,
	0x05, 0x62, 0x50, 0xf1, 0x9f, 0x92, 0x43, 0xee, 0xf9, 0xa2, 0x75, 0x1f, 0xbb, 0xe6, 0xbf, 0x46,
	0xa6, 0xdd, 0x9b, 0xba, 0xe3, 0x5a, 0xb6, 0xde, 0x56, 0x0d, 0x6c, 0xf8, 0x18, 0x09, 0x1c, 0xc6,
	0xf2, 0x43, 0xb8, 0x92, 0xde, 0xfa, 0xb1, 0xd3, 0xfe, 0x10, 0xce, 0xb4, 0xd4, 0x87, 0x48, 0xb3,
	0x0e, 0xcd, 0x15, 0x55, 0x3b, 0x40, 0xbc, 0xf3, 0xf5, 0x3c, 0x94, 0xf6, 0x70, 0xfd, 0xd0, 0x8a,
	0x56, 0x24, 0x80, 0xa6, 0xe6, 0xe0, 0x69, 0x6b, 0x23, 0xd5, 0xb1, 0x4c, 0xef, 0x6c, 0x82, 0x96,
	0xa4, 0x9b, 0x30, 0x1f, 0xef, 0x8c, 0x0d, 0xf0, 0x49, 0x98, 0x21, 0xad, 0xf1, 0xee, 0xa4, 0x63,
	0x3d, 0x42, 0x1a, 0x13, 0xea, 0xf4, 0x1e, 0xab, 0x47, 0x80, 0xd2, 0xdb, 0xb0, 0xe0, 0x21, 0xa8,
	0x1b, 0x46, 0x26, 0x82, 0x03, 0x9a, 0x72, 0x11, 0x9a, 0x56, 0xe0, 0x5c, 0x02, 0xca, 0x6c, 0x64,
	0x7d, 0x53, 0x80, 0x73, 0xc1, 0xcc, 0xd8, 0x43, 0x36, 0x41, 0xc3, 0x49, 0x58, 0xe8, 0xf2, 0x36,
	0x17, 0xb9, 0xbc, 0x5d, 0x81, 0x4b, 0xba, 0xa3, 0xb4, 0x7b, 0x9d, 0x9e, 0xa1, 0xba, 0xfa, 0x23,
	0xa4, 0xb8, 0xc8, 0xec, 0xd9, 0x48, 0x31, 0x2c, 0x55, 0x53, 0x5c, 0xe4, 0xb8, 0xcc, 0xaa, 0xd4,
	0x74, 0x67, 0xd5, 0xaf, 0xd4, 0x22, 0x75, 0xee, 0x5a, 0xaa, 0xd6, 0x42, 0x8e, 0x2b, 0xfd, 0x38,
	0x62, 0x3c, 0x02, 0xca, 0xd8, 0xf8, 0x36, 0x01, 0xa8, 0x14, 0xc9, 0x49, 0x9f, 0x40, 0x16, 0xb0,
	0x67, 0xf8, 0x94, 0x8a, 0x20, 0x22, 0x47, 0x7c, 0x54, 0x11, 0xf0, 0x9f, 0x78, 0x83, 0x49, 0xf1,
	0x3d, 0x42, 0xb6, 0xa3, 0xfb, 0xbc, 0xae, 0x10, 0xe0, 0x3b, 0x14, 0x26, 0x5e, 0x85, 0x8a, 0x76,
	0x6c, 0xaa, 0x1d, 0xbd, 0xad, 0x68, 0xaa, 0xab, 0x32, 0x1d, 0x29, 0x33, 0x18, 0x76, 0x70, 0xa4,
	0x17, 0xc9, 0x94, 0x67, 0x0b, 0x59, 0x06, 0x66, 0x4a, 0x88, 0xcc, 0xff, 0x68, 0x43, 0x36, 0xd6,
	0xb7, 0x60, 0x92, 0x4a, 0x2d, 0xdb, 0xe4, 0x89, 0xe0, 0x62, 0x18, 0xa4, 0xaf, 0x0a, 0x70, 0x6e,
	0x0d, 0x19, 0xc8, 0x45, 0xd9, 0x69, 0xc4, 0xb6, 0xc0, 0x9b, 0x3a, 0x6c, 0xb5, 0x9b, 0x62, 0x33,
	0x47, 0x7c, 0x11, 0x16, 0xbc, 0x96, 0x4c, 0xd8, 0x1d, 0xe4, 0x3e, 0xb0, 0xb4, 0xe0, 0x2c, 0xe5,
	0x0c, 0xfb, 0x4e, 0xe5, 0xbc, 0x41, 0xbe, 0x36, 0x35, 0xe9, 0x7f, 0x0a, 0x50, 0x4b, 0x22, 0x88,
	0x8d, 0x3d, 0xb8, 0xfe, 0x9b, 0x20, 0x67, 0xe6, 0x37, 0x60, 0xde, 0x46, 0x1f, 0xf4, 0xf0, 0x8e,
	0xd3, 0xef, 0xc8, 0x32, 0xdd, 0x07, 0x0e, 0x23, 0xe8, 0xb4, 0xf7, 0x95, 0x75, 0x43, 0xbe, 0x8d,
	0x4e, 0xdd, 0x7b, 0xf0, 0x24, 0xbd, 0xda, 0x08, 0x13, 0xb7, 0xdb, 0xc5, 0x8a, 0xbc, 0x6a, 0x99,
	0xfb, 0xfa, 0x01, 0x27, 0xe7, 0x44, 0x28, 0x38, 0xfa, 0xe7, 0x11, 0x23, 0x92, 0xfc, 0x2d, 0x7d,
	0x4b, 0x80, 0xa7, 0x86, 0x21, 0x67, 0x5c, 0xb8, 0x08, 0xd0, 0x23, 0x70, 0xa5, 0x67, 0x1b, 0x1e,
	0x76, 0x0a, 0xd9, 0xb5, 0x0d, 0x6c, 0xd2, 0xd8, 0x67, 0x7f, 0x2a, 0x16, 0x29, 0x80, 0xda, 0x3b,
	0xbd, 0xa3, 0x1e, 0x20, 0xd2, 0x94, 0x5d, 0x68, 0x10, 0x00, 0x6e, 0x79, 0x0e, 0xe8, 0xdf, 0xc1,
	0xa1, 0xd6, 0x14, 0x29, 0x37, 0x35, 0xe9, 0x4f, 0x04, 0xef, 0xb6, 0x6c, 0x04, 0x4d, 0xb9, 0x04,
	0x65, 0x8a, 0xf7, 0xd9, 0xa3, 0xd0, 0x29, 0x1e, 0x01, 0x3d, 0x7b, 0x14, 0xfe, 0xbe, 0x7c, 0x14,
	0x3a, 0x6d, 0x23, 0xa0, 0xe5, 0xc8, 0xf7, 0x1b, 0x47, 0xa1, 0x0b, 0x72, 0x02, 0xba, 0x81, 0xbf,
	0xa7, 0xab, 0xc1, 0x44, 0xba, 0x1a, 0x48, 0xdf, 0xcc, 0x79, 0x37, 0x55, 0x5c, 0xba, 0x76, 0x05,
	0x2a, 0xfe, 0x20, 0x30, 0xf3, 0xd8, 0xb3, 0x47, 0x36, 0x0a, 0xcc, 0x3e, 0xbf, 0xc6, 0xf2, 0x51,
	0x88, 0xbd, 0xc0, 0xc6, 0x11, 0xa9, 0x71, 0x83, 0xd6, 0x28, 0x84, 0x6a, 0xdc, 0x20, 0x35, 0x46,
	0x1a, 0x4a, 0xf0, 0xfe, 0x71, 0x32, 0xfc, 0xfe, 0x71, 0x90, 0x9e, 0x4f, 0x0d, 0xd2, 0xf3, 0x57,
	0xc8, 0x32, 0xd0, 0xd2, 0x3b, 0xc8, 0xea, 0xb9, 0xf4, 0x91, 0x04, 0xef, 0xfa, 0x24, 0xad, 0x12,
	0x43, 0xdd, 0xd7, 0xb6, 0x6f, 0x21, 0x72, 0x69, 0x0d, 0x76, 0x3b, 0xc2, 0x16, 0x22, 0xd6, 0x4c,
	0xfa, 0x0f, 0x39, 0xa8, 0x84, 0x85, 0xf2, 0xfb, 0x2c, 0x8c, 0x1f, 0x0b, 0x70, 0x7d, 0x1d, 0xb9,
	0x8d, 0x23, 0x17, 0xd9, 0xa6, 0x6a, 0xb0, 0x8d, 0x75, 0x0b, 0x75, 0xba, 0xe4, 0xd1, 0xda, 0x9d,
	0xdd, 0x90, 0x60, 0x42, 0x47, 0xd6, 0xc2, 0xa0, 0x0b, 0xb6, 0xdc, 0x98, 0xe7, 0xc2, 0x57, 0xa1,
	0x42, 0x36, 0x24, 0xf6, 0xb1, 0x82, 0x51, 0x78, 0x4b, 0x1f, 0x83, 0xad, 0x5a, 0x1a, 0x92, 0xde,
	0x80, 0x27, 0x87, 0x50, 0xcd, 0x54, 0xe2, 0x0c, 0x4c, 0x3a, 0x0f, 0x7b, 0x01, 0xc9, 0x13, 0xce,
	0xc3, 0x5e, 0x53, 0x93, 0xfe, 0x54, 0x80, 0x8f, 0xf5, 0x23, 0x60, 0x27, 0xc7, 0xea, 0x9e, 0x11,
	0x1e, 0xf9, 0x6f, 0xc6, 0xad, 0x63, 0x9c, 0x29, 0x85, 0x7e, 0xa6, 0xd4, 0xe1, 0xe9, 0xe1, 0x63,
	0x1a, 0xcc, 0x97, 0x6d, 0x98, 0xa4, 0x5b, 0x1e, 0x71, 0x01, 0xa6, 0xd8, 0x40, 0xbc, 0x41, 0xb3,
	0x22, 0xd6, 0x40, 0x32, 0x7e, 0xef, 0x39, 0x34, 0x29, 0x90, 0x4d, 0x28, 0xb9, 0xa2, 0xf0, 0xbc,
	0x59, 0x5a, 0x92, 0x7e, 0x95, 0x87, 0xf2, 0xb6, 0xaa, 0x6b, 0xbb, 0xdd, 0x03, 0x5b, 0xd5, 0x90,
	0xb8, 0x8e, 0xd7, 0x75, 0x07, 0x8d, 0xba, 0x15, 0xc3, 0x5e, 0x80, 0x83, 0x30, 0x81, 0x1b, 0x50,
	0xee, 0x51, 0x9c, 0xca, 0x88, 0x37, 0xdb, 0x32, 0x30, 0x04, 0x18, 0xdd, 0x93, 0x30, 0x83, 0x4c,
	0x32, 0x99, 0x3a, 0xc8, 0x0c, 0x5d, 0xcb, 0x4c, 0x87, 0xa0, 0x4d, 0x72, 0xbc, 0x4f, 0x6e, 0x5d,
	0xb0, 0x53, 0x86, 0x38, 0xde, 0x57, 0x94, 0x48, 0xed, 0x35, 0xd5, 0xa5, 0x0f, 0xc6, 0x75, 0x76,
	0x4b, 0x58, 0x92, 0xc9, 0xdf, 0x98, 0x97, 0x5d, 0x5b, 0x6f, 0xd3, 0xd9, 0x3c, 0x21, 0xd3, 0x02,
	0xd6, 0x38, 0xf2, 0x47, 0x30, 0x7b, 0xa7, 0x48, 0xb9, 0x99, 0xf2, 0xc8, 0xa2, 0x78, 0xb2, 0x97,
	0xcf, 0xec, 0x06, 0xa4, 0x4d, 0x5e, 0x1f, 0x90, 0x1b, 0x90, 0x92, 0x77, 0x03, 0xb2, 0xea, 0xc3,
	0xa4, 0xf7, 0x88, 0xf7, 0x19, 0x12, 0xad, 0x6f, 0xc3, 0x6f, 0x41, 0xe1, 0x21, 0x3a, 0xf6, 0x3c,
	0xc8, 0x6c, 0x22, 0x21, 0x2d, 0xa5, 0x0f, 0x88, 0x83, 0x1a, 0xc5, 0xed, 0xef, 0x9f, 0xa7, 0xbb,
	0xaa, 0xae, 0x29, 0x4c, 0x74, 0x5e, 0x2f, 0xcf, 0x72, 0x4e, 0xac, 0x00, 0xa5, 0x5c, 0xe9, 0x86,
	0xf0, 0xe3, 0xf5, 0x7a, 0x81, 0xae, 0xd7, 0xe1, 0x3a, 0xfe, 0xf1, 0xc1, 0x6f, 0xa6, 0xd2, 0x26,
	0x6a, 0x43, 0xfe, 0x84, 0x9f, 0x22, 0x7c, 0xe0, 0xf9, 0x66, 0x11, 0xc6, 0x30, 0x71, 0xb4, 0xa0,
	0x12, 0x16, 0x07, 0xe3, 0xce, 0x08, 0xd2, 0x28, 0x87, 0xa4, 0x21, 0xfd, 0x48, 0x80, 0x05, 0xaa,
	0x6a, 0xbf, 0x3d, 0xc2, 0x90, 0xce, 0x7b, 0x8f, 0x84, 0x12, 0xf8, 0x24, 0x7d, 0x3b, 0x0f, 0xe7,
	0xd8, 0x3b, 0xb4, 0x84, 0x21, 0xfd, 0x4e, 0xbe, 0x07, 0x0b, 0xcb, 0x69, 0x72, 0x1c, 0x39, 0x7d,
	0x24, 0xef, 0x04, 0x6d, 0xff, 0x2d, 0xe7, 0x47, 0xa7, 0xe6, 0xbf, 0xcc, 0x81, 0xe4, 0xef, 0x11,
	0xdc, 0x4d, 0xcb, 0xd5, 0xf7, 0xf5, 0xb6, 0x4a, 0x48, 0xb2, 0x1e, 0xa2, 0x13, 0x78, 0x60, 0xf6,
	0x3a, 0x54, 0xd4, 0x47, 0xaa, 0x4e, 0x0c, 0xb6, 0xa2, 0xba, 0x1c, 0x8f, 0xb6, 0xca, 0x7e, 0xfd,
	0xba, 0x2b, 0x6e, 0x84, 0x6e, 0xcf, 0x47, 0x7f, 0x41, 0xee, 0xdf, 0xb8, 0x1f, 0xc0, 0x29, 0x13,
	0x1d, 0x2a, 0xde, 0xd3, 0x23, 0xd3, 0x45, 0xf6, 0x23, 0xd5, 0x60, 0x5a, 0xc5, 0x19, 0xf3, 0xb0,
	0x89, 0x0e, 0xe9, 0xb1, 0x5f, 0x93, 0x35, 0x97, 0xe7, 0xcc, 0x38, 0x48, 0xba, 0x09, 0xd7, 0x06,
	0xb2, 0x95, 0x09, 0x75, 0x01, 0xa6, 0x3a, 0xc8, 0x71, 0xd4, 0x03, 0x2f, 0x0a, 0xcd, 0x2b, 0x4a,
	0x5f, 0x11, 0x60, 0xae, 0xaf, 0x27, 0xc2, 0x4d, 0xfa, 0x1c, 0x99, 0xce, 0x26, 0x81, 0x83, 0x9b,
	0xa4, 0x3e, 0x9d, 0x4c, 0x2f, 0x03, 0x7b, 0xba, 0x4c, 0xe6, 0x52, 0x6e, 0xb8, 0xeb, 0x40, 0x6b,
	0x37, 0x4c, 0x4d, 0xfa, 0x79, 0x0e, 0x2e, 0xef, 0x3a, 0x43, 0xb5, 0xc4, 0xc5, 0xe5, 0x90, 0x96,
	0x90, 0x72, 0x53, 0x13, 0xaf, 0xc3, 0x8c, 0xda, 0x73, 0x1f, 0x20, 0x4d, 0x89, 0x9e, 0xa1, 0x55,
	0x28, 0x74, 0x97, 0x9e, 0xa4, 0x3d, 0x09, 0x33, 0xed, 0x9e, 0xe3, 0x5a, 0x1d, 0xc5, 0xe3, 0x0a,
	0xf3, 0x80, 0x28, 0x74, 0x83, 0x02, 0xc5, 0x5d, 0xa8, 0x38, 0x0f, 0x54, 0x1b, 0x29, 0x8e, 0x6b,
	0x23, 0xf5, 0xe1, 0x18, 0x8a, 0x51, 0x26, 0x78, 0x76, 0x08, 0x9a, 0xd8, 0xc6, 0x6f, 0x22, 0xbe,
	0xc9, 0x1f, 0x7e, 0xcc, 0x37, 0x39, 0xf4, 0x98, 0xef, 0x35, 0xb8, 0x92, 0xce, 0xc4, 0xa1, 0x3a,
	0xb1, 0x01, 0x12, 0x35, 0xef, 0x03, 0xa5, 0xc0, 0xfb, 0x3a, 0x88, 0xe8, 0xe8, 0x20, 0x74, 0x43,
	0xe9, 0xf9, 0x81, 0x00, 0x8b, 0xd1, 0x2b, 0xee, 0x81, 0x84, 0xa5, 0x46, 0xbf, 0x0c, 0x09, 0x2c,
	0x38, 0x89, 0xf3, 0xd5, 0xef, 0x0a, 0xf0, 0xaf, 0xb8, 0x48, 0x65, 0x83, 0x76, 0xe0, 0x6c, 0xfb,
	0x81, 0xea, 0x2a, 0x66, 0xa8, 0x86, 0x42, 0x94, 0x99, 0xcd, 0xb9, 0x57, 0xb9, 0x4f, 0x25, 0x13,
	0x7a, 0xc1, 0x3b, 0xe1, 0x7e, 0xb0, 0xa4, 0x92, 0x1d, 0x61, 0xdd, 0x30, 0x76, 0x1d, 0x12, 0x23,
	0xd2, 0x5f, 0xc5, 0x19, 0x93, 0x97, 0xd2, 0x7f, 0x17, 0xc8, 0x0e, 0x6d, 0x48, 0x1f, 0x8c, 0x09,
	0x1d, 0xa8, 0xf6, 0x1c, 0x1a, 0xd2, 0xe2, 0xd2, 0xc1, 0x7b, 0xbe, 0xee, 0x2a, 0xf7, 0xcd, 0x75,
	0x72, 0x1f, 0x4d, 0x17, 0x75, 0xe4, 0x99, 0x1e, 0xfb, 0x4c, 0xbb, 0x95, 0xbe, 0x2d, 0xc0, 0x72,
	0xdd, 0x30, 0xac, 0x43, 0x19, 0x75, 0x0d, 0xf5, 0xf8, 0xb6, 0x65, 0xdf, 0x55, 0xc9, 0xdb, 0x14,
	0x6d, 0x8c, 0xb5, 0x69, 0x90, 0x62, 0xcd, 0xc3, 0x24, 0x55, 0x25, 0x6f, 0xc3, 0x48, 0x4b, 0x18,
	0x4e, 0xcf, 0x2e, 0xd8, 0x16, 0x97, 0x95, 0xa4, 0xe7, 0xe1, 0xb9, 0x4c, 0xf4, 0x31, 0xc7, 0xeb,
	0xcf, 0x04, 0x38, 0x93, 0x58, 0xa3, 0x2f, 0xda, 0x23, 0x34, 0xd5, 0x72, 0x91, 0xa9, 0x86, 0x77,
	0x69, 0xe4, 0x64, 0xc6, 0x0b, 0x9a, 0x26, 0x05, 0xbc, 0x9f, 0x7b, 0xa8, 0x9b, 0x1e, 0x99, 0xe4,
	0x6f, 0xf1, 0x05, 0x38, 0xdb, 0x3f, 0x55, 0x68, 0x5b, 0x7a, 0xa8, 0x73, 0xa6, 0x1d, 0x9b, 0x24,
	0xe4, 0x58, 0x47, 0x5c, 0x82, 0x53, 0xd4, 0x9c, 0x46, 0xdb, 0xd0, 0x5d, 0xe1, 0x1c, 0xfd, 0x14,
	0xaa, 0x2f, 0x7d, 0xa5, 0x00, 0x17, 0x07, 0xca, 0x37, 0xd8, 0xa5, 0x0b, 0xe1, 0x5d, 0xfa, 0x02,
	0x4c, 0x31, 0x09, 0x78, 0x63, 0x64, 0xc5, 0xac, 0xe2, 0xc0, 0x7b, 0x44, 0x46, 0x31, 0xb1, 0xe2,
	0xd4, 0x64, 0x17, 0xe5, 0x0a, 0x05, 0xee, 0x10, 0x98, 0x78, 0x15, 0x58, 0x59, 0xa1, 0x21, 0x4f,
	0x74, 0x3c, 0x65, 0x0a, 0x7b, 0x07, 0x83, 0xf0, 0xc8, 0xa3, 0xab, 0x8e, 0x42, 0xa2, 0xaa, 0xe9,
	0xb6, 0x77, 0x2e, 0xb2, 0xf4, 0xb4, 0xd0, 0x91, 0x2b, 0x2e, 0xc3, 0x99, 0x58, 0x7d, 0xd6, 0x7f,
	0x91, 0xf4, 0x7f, 0x2a, 0xd2, 0x82, 0x91, 0x11, 0x3a, 0xcb, 0x28, 0x45, 0xcf, 0x32, 0xbc, 0x3d,
	0x39, 0x84, 0xf6, 0xe4, 0xe1, 0x37, 0x83, 0xe5, 0xe8, 0x9b, 0xc1, 0xab, 0x50, 0x51, 0xb1, 0x0e,
	0x2a, 0x36, 0x51, 0x42, 0xf6, 0x32, 0xb0, 0xac, 0x06, 0x7a, 0x89, 0x57, 0xf9, 0x36, 0xf1, 0x3d,
	0x34, 0xec, 0x70, 0x4d, 0x0f, 0x5f, 0xe5, 0x59, 0xed, 0xba, 0x1b, 0x7e, 0x3a, 0xa8, 0xba, 0x19,
	0x9e, 0x0e, 0xd6, 0x5d, 0xe9, 0xcf, 0x73, 0x50, 0x20, 0x8f, 0x17, 0xe7, 0x61, 0xd2, 0x41, 0xa6,
	0xe6, 0xcb, 0x9d, 0x95, 0xc4, 0x0b, 0x50, 0xb2, 0x51, 0x5b, 0xef, 0xea, 0x88, 0x45, 0xb8, 0x95,
	0xe4, 0x00, 0x10, 0x66, 0x50, 0x3e, 0xca, 0xa0, 0xe0, 0x58, 0xa7, 0x10, 0x3e, 0xd6, 0x11, 0x1b,
	0x5e, 0x1e, 0x81, 0x89, 0x2c, 0xd7, 0x61, 0x98, 0xc4, 0x1d, 0xdc, 0xcc, 0x4b, 0x3c, 0xf0, 0x22,
	0x94, 0x48, 0xe4, 0x1d, 0x39, 0x4d, 0x19, 0xfe, 0x12, 0xb5, 0x88, 0x2b, 0x93, 0xc3, 0x94, 0x3b,
	0xac, 0x61, 0x68, 0x2f, 0xb0, 0xc4, 0x4f, 0x03, 0xd9, 0x03, 0x10, 0x64, 0xe4, 0xbc, 0xe3, 0x3c,
	0x94, 0x54, 0xd3, 0x32, 0xe9, 0x63, 0x50, 0xaa, 0x47, 0x45, 0x0c, 0xc0, 0x55, 0xa5, 0xfb, 0x30,
	0x85, 0xff, 0x1f, 0x7c, 0x26, 0x16, 0xb0, 0x29, 0x17, 0x61, 0x53, 0x84, 0xed, 0xf9, 0x18, 0xdb,
	0xa5, 0xbf, 0x12, 0x60, 0xae, 0x69, 0x3a, 0xc8, 0x76, 0x71, 0x0f, 0x9e, 0x49, 0xfd, 0xa8, 0x44,
	0x18, 0x61, 0xe1, 0xc4, 0x49, 0xb2, 0x70, 0x32, 0xc6, 0xc2, 0x16, 0x88, 0xe1, 0x61, 0xb2, 0x05,
	0xee, 0x0d, 0x28, 0x90, 0xda, 0x74, 0x49, 0x5f, 0xe4, 0xef, 0x5a, 0x26, 0xed, 0xa4, 0x36, 0xcc,
	0x51, 0x0f, 0x2a, 0xcc, 0xbc, 0x93, 0x16, 0x11, 0x02, 0x31, 0xdc, 0x09, 0x23, 0x7d, 0x8b, 0x44,
	0x61, 0xb4, 0x91, 0x81, 0x34, 0x65, 0xc4, 0x31, 0x54, 0x3c, 0x04, 0x8c, 0x43, 0xb3, 0xeb, 0x88,
	0xb0, 0xc7, 0x77, 0x32, 0xea, 0x91, 0x53, 0xb4, 0x4f, 0xf2, 0xa3, 0x0e, 0x8e, 0xd1, 0x5a, 0x50,
	0x0d, 0xb0, 0x32, 0xd2, 0x6f, 0xc1, 0x04, 0x89, 0x87, 0x65, 0x78, 0xb3, 0x90, 0x4c, 0x1b, 0x4a,
	0x9f, 0x85, 0x99, 0x55, 0xd5, 0x7c, 0x8c, 0x1a, 0x2b, 0x7d, 0x02, 0x66, 0xfd, 0x1e, 0x18, 0xd9,
	0xe7, 0xa0, 0xd8, 0x56, 0xcd, 0x80, 0xd9, 0x45, 0x79, 0xaa, 0x4d, 0xab, 0x48, 0x87, 0x34, 0x54,
	0x86, 0x74, 0x19, 0xa6, 0xea, 0x3c, 0x94, 0x28, 0x1d, 0xa1, 0x28, 0x17, 0x0a, 0x18, 0xbe, 0x71,
	0xbe, 0x06, 0xd3, 0x64, 0x6e, 0x7c, 0xd0, 0x53, 0x4d, 0x57, 0x77, 0x8f, 0xd9, 0xcb, 0xaa, 0x0a,
	0x06, 0xbe, 0xcd, 0x60, 0xd2, 0x32, 0x9c, 0x89, 0x75, 0x3c, 0x9c, 0xd8, 0x3f, 0x10, 0xe0, 0xac,
	0x3f, 0x36, 0xc6, 0x89, 0x93, 0x20, 0xf8, 0x2a, 0x54, 0x7c, 0xce, 0x06, 0x47, 0x41, 0x65, 0x1f,
	0xd6, 0xd4, 0xa2, 0xf3, 0xbd, 0x30, 0xde, 0x7c, 0x97, 0x36, 0xc8, 0x01, 0x5d, 0x6c, 0x18, 0x43,
	0x87, 0x9f, 0xfa, 0xbe, 0xe4, 0x6b, 0x02, 0x94, 0x71, 0x85, 0xad, 0xfd, 0x7d, 0x32, 0xda, 0xf4,
	0x69, 0x1c, 0x19, 0x45, 0x6e, 0x4c, 0xab, 0x55, 0x83, 0x62, 0x4c, 0xc2, 0x7e, 0x59, 0xfa, 0x79,
	0x1e, 0xa6, 0x71, 0x93, 0x6d, 0xdb, 0xea, 0x58, 0xe4, 0x85, 0xfa, 0x90, 0x2b, 0xb0, 0xf3, 0x50,
	0x22, 0x41, 0x51, 0xe4, 0x3c, 0x9f, 0x46, 0xcb, 0x14, 0x4d, 0x74, 0xb8, 0x4d, 0x8e, 0xf4, 0xcf,
	0x43, 0xc9, 0x32, 0x34, 0xf6, 0x91, 0xc6, 0xcc, 0x14, 0x2d, 0x43, 0xa3, 0x1f, 0xef, 0xc1, 0xb4,
	0xa6, 0x3b, 0x34, 0x51, 0x48, 0x48, 0x3a, 0x9c, 0x7b, 0xea, 0x35, 0xd6, 0x94, 0x8c, 0xad, 0xa2,
	0x85, 0x4a, 0x78, 0x4b, 0xef, 0x23, 0xa6, 0x1e, 0x18, 0x4d, 0xca, 0xe1, 0x77, 0x47, 0x7d, 0xb0,
	0xd3, 0x30, 0x81, 0x6c, 0xdb, 0xb2, 0xbd, 0x3b, 0x45, 0x52, 0x10, 0x9f, 0x82, 0x59, 0xf7, 0x81,
	0x6e, 0x6b, 0x4a, 0x57, 0xb5, 0xdd, 0x63, 0x12, 0x64, 0x41, 0xbd, 0xb2, 0x69, 0x02, 0xde, 0xc6,
	0xd0, 0x9d, 0x87, 0x3d, 0xac, 0x7a, 0x78, 0xdc, 0x3e, 0x23, 0x8b, 0xd4, 0xc9, 0x33, 0xd1, 0xa1,
	0x37, 0x53, 0x70, 0x15, 0x3c, 0x7a, 0xbf, 0x4a, 0x89, 0x56, 0xb1, 0x0c, 0xcd, 0xaf, 0xb2, 0xcb,
	0x66, 0x9c, 0x85, 0x35, 0x00, 0xf3, 0x17, 0xb2, 0x1c, 0xb1, 0x85, 0x74, 0x47, 0x2e, 0x1f, 0x04,
	0x05, 0xe9, 0x1f, 0x05, 0x28, 0xfd, 0xbe, 0x4a, 0x50, 0xfa, 0x07, 0x9a, 0xd0, 0x23, 0xa2, 0xc5,
	0x9e, 0xb1, 0x89, 0x3d, 0xb7, 0x16, 0xe2, 0xcf, 0xad, 0xd3, 0x5f, 0x5c, 0x9d, 0xe4, 0xad, 0xe6,
	0x3d, 0x98, 0x89, 0x48, 0xdd, 0x61, 0x89, 0x6a, 0x46, 0x10, 0x7b, 0x25, 0x24, 0x76, 0x47, 0xfa,
	0x81, 0x00, 0x0b, 0xfd, 0x43, 0x67, 0x06, 0x6a, 0x09, 0x4e, 0x11, 0x0f, 0x9f, 0xc1, 0x15, 0xb5,
	0x8d, 0xf7, 0x63, 0xcc, 0x56, 0xcd, 0x61, 0x67, 0x9f, 0x7d, 0xa9, 0x93, 0x0f, 0xe2, 0xfb, 0x30,
	0x4b, 0xa8, 0xf4, 0x5b, 0x78, 0x4f, 0x61, 0x9f, 0xe3, 0x27, 0x33, 0xa0, 0x82, 0x8c, 0xd8, 0x2f,
	0x3a, 0xd2, 0x7b, 0xe4, 0x31, 0x76, 0xe8, 0x90, 0xb8, 0x4f, 0x56, 0xa9, 0xe7, 0x0d, 0x43, 0xdf,
	0xcc, 0xdb, 0xe4, 0xd1, 0x65, 0x32, 0x6e, 0xdf, 0x97, 0x81, 0xbe, 0x71, 0x71, 0xba, 0xf3, 0x01,
	0xb2, 0x10, 0x0a, 0xe9, 0x8b, 0x05, 0x38, 0xc5, 0x8e, 0xd2, 0x23, 0x0e, 0xcd, 0x38, 0xcb, 0xdb,
	0xc0, 0x6b, 0x8e, 0x93, 0x5c, 0xd8, 0xfa, 0x57, 0xfe, 0x89, 0xfe, 0x95, 0xff, 0x5f, 0x38, 0x2d,
	0xc6, 0x35, 0x98, 0x0e, 0xaf, 0xf5, 0xce, 0x42, 0x91, 0xc8, 0xbd, 0x12, 0x5a, 0xec, 0x9d, 0xa8,
	0x43, 0x5e, 0x8a, 0x3a, 0xe4, 0xa1, 0xdb, 0x7f, 0x08, 0xdd, 0xfe, 0x47, 0x66, 0x76, 0x79, 0xbc,
	0x99, 0x2d, 0xcd, 0xc3, 0xe9, 0xa8, 0x12, 0xb0, 0xf3, 0x98, 0xef, 0xe7, 0xe0, 0x32, 0x76, 0x99,
	0x48, 0x6a, 0x95, 0xd8, 0xe9, 0x05, 0x97, 0xa6, 0xc4, 0x3d, 0x9d, 0x5c, 0xbf, 0xa7, 0x33, 0x24,
	0xbc, 0x32, 0x7a, 0x30, 0x55, 0x48, 0x78, 0xb4, 0x1b, 0x70, 0x6e, 0x22, 0xc6, 0xb9, 0x88, 0xae,
	0x4d, 0x8e, 0xbf, 0x69, 0x0a, 0xb4, 0x7a, 0x2a, 0x16, 0xff, 0x2f, 0xc1, 0x95, 0x74, 0x3e, 0x31,
	0x66, 0xfe, 0x54, 0x80, 0x4b, 0xb8, 0xd2, 0xc6, 0xc6, 0xfa, 0x6f, 0x2c, 0x2f, 0x53, 0x93, 0xcb,
	0x48, 0x57, 0xa9, 0x26, 0x24, 0x12, 0xcf, 0x06, 0xf8, 0x6b, 0x01, 0xae, 0xb1, 0x3a, 0x64, 0xe2,
	0x8c, 0x34, 0xca, 0x21, 0xb6, 0x25, 0x3a, 0x84, 0x7c, 0x7c, 0x08, 0x7d, 0x06, 0xa1, 0x90, 0x60,
	0x10, 0x06, 0xea, 0x4c, 0x84, 0x09, 0x93, 0x31, 0x26, 0x3c, 0x05, 0xd7, 0x07, 0x0f, 0x90, 0x71,
	0xe2, 0xcb, 0x02, 0x94, 0xfc, 0xe5, 0x2e, 0xaa, 0x86, 0xc2, 0x98, 0x6a, 0x18, 0x58, 0x83, 0x5c,
	0xd8, 0x1a, 0x0c, 0x72, 0x8e, 0xff, 0x5e, 0x80, 0xd3, 0x6c, 0x79, 0x25, 0x04, 0xf9, 0x46, 0xfe,
	0x44, 0x09, 0xfb, 0x68, 0x1f, 0x95, 0x0d, 0x49, 0x94, 0x24, 0xe9, 0x70, 0x26, 0x36, 0x64, 0xb6,
	0x82, 0x6e, 0x43, 0x39, 0x70, 0x62, 0xbc, 0x8d, 0xf5, 0x33, 0x19, 0x3d, 0x18, 0x19, 0x7c, 0xff,
	0xc5, 0x61, 0x4f, 0x24, 0x65, 0x64, 0xa8, 0x6e, 0x90, 0xaf, 0x8a, 0xef, 0x25, 0x9e, 0xf4, 0x3a,
	0x79, 0x22, 0xd9, 0xd7, 0x36, 0x08, 0xf9, 0x09, 0x94, 0xdd, 0x77, 0xfb, 0x7c, 0x6d, 0x77, 0xf0,
	0xa6, 0x76, 0x1d, 0xb9, 0x24, 0x75, 0x26, 0x4d, 0xed, 0xc9, 0x11, 0x9c, 0x71, 0x83, 0x3c, 0x05,
	0x8a, 0xb4, 0x61, 0xdd, 0xd5, 0xa0, 0x48, 0x13, 0x8f, 0x22, 0xaf, 0x2f, 0xbf, 0x2c, 0xbd, 0x4c,
	0x3c, 0x34, 0x2f, 0x75, 0x62, 0xb4, 0xb3, 0x21, 0xcf, 0x40, 0xbf, 0x47, 0x43, 0x09, 0xe2, 0x6d,
	0x59, 0xa7, 0x41, 0xee, 0x53, 0x21, 0x92, 0xfb, 0x74, 0xcb, 0x3b, 0xb3, 0xa4, 0xba, 0xf4, 0x72,
	0xb6, 0xdc, 0x8e, 0xb4, 0x93, 0xc8, 0xe9, 0xe5, 0x65, 0x28, 0xeb, 0x8e, 0x82, 0x34, 0xdd, 0x25,
	0xaf, 0xa4, 0xe8, 0x45, 0x18, 0xe8, 0x4e, 0x83, 0x41, 0xa4, 0x5f, 0x08, 0x70, 0x86, 0xde, 0x44,
	0x7b, 0x58, 0x78, 0x5c, 0x3a, 0x4c, 0x96, 0xe2, 0xf4, 0xf6, 0x83, 0xec, 0xad, 0x80, 0x41, 0x3b,
	0x04, 0xc2, 0x61, 0x90, 0xe9, 0x2b, 0xd4, 0x97, 0xe2, 0x8f, 0x99, 0x97, 0x5f, 0x0a, 0x7d, 0x7e,
	0xfe, 0x85, 0xd0, 0x35, 0x2b, 0x83, 0xd0, 0xde, 0xe9, 0x2b, 0xd7, 0x67, 0x97, 0x03, 0x63, 0x05,
	0x1e, 0xa8, 0xa9, 0x61, 0x33, 0xd4, 0x37, 0xa2, 0xf8, 0x8b, 0x66, 0x7a, 0x9d, 0x22, 0x42, 0x81,
	0x4c, 0x34, 0x3a, 0x02, 0xf2, 0xf7, 0x30, 0xda, 0xcf, 0x41, 0xf1, 0xc0, 0xb6, 0x7a, 0xdd, 0xd0,
	0x0b, 0x71, 0x52, 0xa6, 0x91, 0x6f, 0xc1, 0x79, 0xb3, 0x97, 0xb7, 0x56, 0x52, 0xe0, 0x0c, 0x7d,
	0xcf, 0x1f, 0x67, 0x2f, 0x0f, 0x31, 0x12, 0x54, 0x34, 0xd2, 0xb8, 0x89, 0x87, 0xe7, 0xa5, 0x71,
	0x8b, 0xc0, 0xa4, 0x3d, 0x98, 0x8f, 0x77, 0xe0, 0xf0, 0x0f, 0xf7, 0x3a, 0x4c, 0x53, 0x6c, 0x5a,
	0xa4, 0x8b, 0x28, 0x50, 0x6a, 0x90, 0x60, 0xe1, 0xba, 0x61, 0x78, 0x7d, 0x38, 0x2b, 0xc7, 0xec,
	0xf1, 0x66, 0x28, 0x8a, 0x6b, 0xd8, 0x7e, 0x4d, 0xfa, 0xa2, 0x40, 0x42, 0x82, 0xd3, 0xf1, 0xf8,
	0xe1, 0xb0, 0x41, 0xae, 0x5f, 0xc2, 0x5d, 0xcf, 0x62, 0x65, 0xcc, 0x75, 0xba, 0x8e, 0xdb, 0xca,
	0x7e, 0x3e, 0x4f, 0x52, 0x74, 0xa4, 0x0f, 0x83, 0x2c, 0xb7, 0x04, 0x32, 0x6c, 0xcb, 0x7d, 0x17,
	0x4a, 0x1e, 0x06, 0x6f, 0xf3, 0xb1, 0x94, 0x8d, 0x0e, 0x39, 0x40, 0x20, 0x7d, 0x43, 0x80, 0xa2,
	0x07, 0xe7, 0x92, 0x50, 0x58, 0xe3, 0xf2, 0x51, 0x8d, 0x6b, 0x7a, 0x1a, 0x47, 0x77, 0x14, 0x19,
	0xb9, 0x13, 0xb6, 0x13, 0xd2, 0x0d, 0x62, 0xad, 0xb6, 0x55, 0xdb, 0x35, 0x91, 0xbd, 0xe3, 0xaa,
	0x24, 0x71, 0xf2, 0xd0, 0x74, 0x9c, 0x77, 0x88, 0x21, 0xef, 0x6b, 0xc5, 0xc4, 0xf8, 0x49, 0xb2,
	0x87, 0xd5, 0x4d, 0xe5, 0xc0, 0xb2, 0x34, 0xbc, 0x0b, 0x21, 0x9f, 0xd9, 0x1e, 0xb6, 0xaa, 0x3b,
	0x4d, 0x73, 0xdd, 0xb2, 0x34, 0xaf, 0x99, 0xd4, 0x82, 0xf3, 0x3b, 0xbd, 0xbd, 0x8e, 0x3e, 0x92,
	0xbd, 0x4d, 0xcb, 0x26, 0x2d, 0x5d, 0x82, 0x0b, 0xc9, 0x58, 0x99, 0xd3, 0xb2, 0x46, 0xb7, 0x9f,
	0x34, 0x53, 0x74, 0x48, 0x2d, 0x43, 0x7a, 0x7d, 0x15, 0x2a, 0xbe, 0x3a, 0x06, 0x8a, 0x5d, 0xf6,
	0x60, 0x58, 0xb3, 0x0f, 0x49, 0xec, 0x5f, 0x0a, 0x16, 0xc6, 0x8e, 0x9d, 0xb0, 0x1e, 0x51, 0x7d,
	0x7e, 0x9e, 0xd3, 0x57, 0x88, 0xe2, 0x0d, 0xab, 0xd3, 0xd7, 0x73, 0x54, 0x04, 0xb1, 0x9e, 0x3d,
	0xd2, 0xef, 0xfa, 0x89, 0x7f, 0xa8, 0xa3, 0x73, 0x23, 0x9b, 0x8a, 0x44, 0x73, 0xfc, 0x60, 0x0b,
	0x17, 0xe4, 0x9f, 0x9c, 0x90, 0x69, 0x01, 0xf7, 0xb1, 0xd7, 0x6b, 0x3f, 0x44, 0xde, 0xdb, 0xad,
	0x8c, 0x7d, 0xac, 0x90, 0xb6, 0x32, 0xc3, 0x21, 0xae, 0xc2, 0xac, 0xba, 0xef, 0x22, 0x5b, 0xf1,
	0xb3, 0x8d, 0x73, 0x3c, 0x09, 0x9c, 0x21, 0x4d, 0xfc, 0xb2, 0xf4, 0x75, 0x81, 0x44, 0xb8, 0xf6,
	0x73, 0xe5, 0x31, 0x8a, 0x22, 0x1e, 0xaa, 0x9c, 0x8b, 0x87, 0x2a, 0x4b, 0xff, 0x4d, 0x80, 0x8b,
	0x32, 0x7a, 0xa4, 0xa3, 0xc3, 0x34, 0x71, 0xbd, 0x0f, 0x53, 0x36, 0xa9, 0xe0, 0x51, 0xb5, 0xc2,
	0x47, 0x55, 0x22, 0x56, 0x86, 0x54, 0xf6, 0x50, 0x62, 0x4b, 0xa2, 0x6a, 0x9d, 0x70, 0xc6, 0xac,
	0x29, 0x52, 0x6e, 0x6a, 0xd2, 0x77, 0x04, 0xb8, 0x30, 0x08, 0x49, 0xd2, 0x4b, 0x04, 0x95, 0x24,
	0x54, 0xf7, 0xb2, 0x72, 0x78, 0x45, 0x72, 0x1c, 0x88, 0xda, 0x86, 0x6e, 0x22, 0x25, 0x12, 0x3b,
	0x3a, 0xcd, 0xa0, 0x32, 0x01, 0x8a, 0xcf, 0xc0, 0x29, 0xaf, 0x1a, 0x3a, 0xea, 0x1a, 0xaa, 0x49,
	0xf6, 0x12, 0x6c, 0x4d, 0x15, 0xd9, 0xa7, 0x46, 0xf0, 0x45, 0xfa, 0x02, 0x5c, 0x4a, 0x63, 0x1e,
	0x93, 0xea, 0xa7, 0xe3, 0xb9, 0x48, 0x56, 0xc7, 0xe2, 0x1e, 0xc5, 0xea, 0xa7, 0x24, 0x91, 0x8c,
	0x14, 0xe9, 0xa5, 0xae, 0xb7, 0x17, 0xa0, 0xe4, 0xf4, 0xda, 0x6d, 0x84, 0x34, 0xa4, 0x31, 0x2e,
	0x05, 0x00, 0x6c, 0xcf, 0x4c, 0x74, 0x18, 0x4e, 0xd0, 0x5a, 0x92, 0x4b, 0x26, 0x3a, 0x64, 0x39,
	0x59, 0xdf, 0x86, 0x99, 0xe8, 0x0c, 0xa1, 0x57, 0x55, 0x44, 0x1a, 0xc8, 0x8b, 0x04, 0x0a, 0x00,
	0xd8, 0x48, 0xd1, 0x19, 0x14, 0x51, 0xbf, 0x32, 0x85, 0x51, 0xfd, 0xfb, 0x9e, 0x00, 0xb3, 0x31,
	0xda, 0xfb, 0x68, 0x4e, 0x4b, 0xca, 0xef, 0xad, 0x4c, 0xf9, 0xe8, 0xca, 0xe4, 0xbb, 0xdb, 0x85,
	0xe8, 0xc3, 0x9a, 0x57, 0xa1, 0xcc, 0x42, 0xf0, 0xf0, 0x34, 0xe6, 0x79, 0x95, 0x4b, 0xab, 0x63,
	0x80, 0xf4, 0xd7, 0x13, 0x30, 0xc5, 0xbc, 0x82, 0xa4, 0x7c, 0xa7, 0xce, 0x03, 0xcb, 0x76, 0x69,
	0x66, 0x7e, 0xb6, 0x51, 0x26, 0x10, 0x92, 0x99, 0xff, 0x2a, 0x54, 0x34, 0xdd, 0xe9, 0x1a, 0xea,
	0x31, 0xad, 0xe0, 0x85, 0xa4, 0x52, 0x18, 0xa9, 0xf2, 0x34, 0x54, 0x63, 0x3f, 0x24, 0x40, 0x4f,
	0x74, 0x4b, 0x81, 0xa3, 0x40, 0x7e, 0x45, 0xc0, 0x09, 0x22, 0x1f, 0x26, 0x62, 0x91, 0x0f, 0x24,
	0xcd, 0xae, 0xaa, 0x39, 0xec, 0x16, 0x79, 0x0a, 0x97, 0xeb, 0x9a, 0x43, 0x9e, 0x6a, 0x78, 0x97,
	0xfd, 0x25, 0x99, 0xfc, 0x1d, 0x61, 0x52, 0x31, 0xca, 0x24, 0xef, 0x65, 0x47, 0x29, 0xf4, 0xb2,
	0xe3, 0x6d, 0x28, 0xfa, 0xaf, 0x4e, 0xe9, 0xf5, 0xc2, 0xf3, 0xdc, 0x07, 0x9d, 0xc4, 0x5f, 0xf1,
	0xde, 0x9c, 0xfa, 0x68, 0x48, 0xc8, 0x99, 0xee, 0xda, 0xaa, 0x8b, 0x14, 0xfa, 0x5c, 0x73, 0xa1,
	0xcc, 0x62, 0x9f, 0x29, 0xb4, 0x4e, 0x80, 0x2c, 0x5b, 0xbe, 0x65, 0x1a, 0xc7, 0x8a, 0x6a, 0xb7,
	0x1f, 0xe8, 0x8f, 0x90, 0xc3, 0x1e, 0x8f, 0xcc, 0x32, 0x78, 0x9d, 0x81, 0xc5, 0xa7, 0xfa, 0x7f,
	0x8b, 0x61, 0x9a, 0x45, 0xa2, 0x84, 0x39, 0x18, 0x09, 0x12, 0x99, 0x89, 0x06, 0x89, 0xf4, 0x1d,
	0x4f, 0xce, 0x8e, 0x77, 0x3c, 0x59, 0xcd, 0x74, 0x3c, 0x79, 0x09, 0x20, 0x94, 0x3c, 0x6b, 0x8e,
	0x6e, 0x8a, 0x02, 0x88, 0xf8, 0xa6, 0xe7, 0x58, 0x89, 0x59, 0xee, 0x48, 0xbc, 0x94, 0x2f, 0xe1,
	0xfd, 0x17, 0xbd, 0x5f, 0xee, 0xd9, 0x36, 0xf6, 0x7c, 0x4e, 0x51, 0x1b, 0xe0, 0x03, 0xa4, 0x0f,
	0x61, 0x36, 0x26, 0x37, 0xbc, 0x1d, 0xd5, 0x7a, 0xb6, 0xea, 0x27, 0x5e, 0x98, 0x90, 0xfd, 0xb2,
	0xb8, 0x01, 0x85, 0x9e, 0xc9, 0x52, 0x6b, 0x70, 0x6f, 0x0e, 0x63, 0x1d, 0xec, 0x9a, 0xba, 0x2b,
	0x13, 0x34, 0xd2, 0x2b, 0x34, 0x84, 0x85, 0x7e, 0x8f, 0xba, 0x3c, 0x43, 0x5d, 0x79, 0x44, 0x76,
	0xc6, 0xb1, 0xb6, 0xcc, 0x0e, 0x36, 0xb1, 0xd8, 0xe9, 0x87, 0x6c, 0x4f, 0x03, 0x18, 0x3a, 0xd9,
	0x6f, 0x2e, 0xdd, 0xa2, 0x6e, 0xa9, 0xdf, 0x0d, 0x9e, 0xc1, 0x3e, 0x91, 0xd7, 0x60, 0xda, 0x23,
	0x12, 0x4f, 0x76, 0x8f, 0xcc, 0x0a, 0x03, 0x92, 0xba, 0xd2, 0x01, 0xf5, 0x8f, 0xe2, 0x18, 0x4e,
	0x9e, 0xd4, 0x7b, 0x84, 0x54, 0x76, 0x9a, 0xe1, 0xf5, 0xc7, 0x9f, 0x84, 0xa1, 0x6d, 0x44, 0x4f,
	0x38, 0x8b, 0x14, 0xd0, 0xd4, 0xd8, 0x08, 0xfa, 0x10, 0x9f, 0xfc, 0x08, 0xde, 0x85, 0xd3, 0x34,
	0xf7, 0xa5, 0xf7, 0x89, 0x2f, 0xae, 0x32, 0x6e, 0x73, 0x73, 0x7d, 0x36, 0x57, 0x3a, 0x0b, 0x67,
	0x62, 0x98, 0x99, 0xf7, 0xfd, 0x45, 0xc1, 0xcb, 0xb7, 0x39, 0x1a, 0xe3, 0xc2, 0xc6, 0x38, 0x17,
	0x35, 0xc6, 0x49, 0xf6, 0x2c, 0x9f, 0x68, 0xcf, 0xa4, 0xcb, 0x70, 0x31, 0x85, 0x08, 0x46, 0xe6,
	0x7d, 0xb2, 0x49, 0x60, 0xc9, 0x3c, 0x6e, 0x5b, 0x76, 0xe8, 0x99, 0xf0, 0xb8, 0x0f, 0x6e, 0x1d,
	0xb2, 0x73, 0x48, 0x41, 0xed, 0xdf, 0x7f, 0x4d, 0xd1, 0x88, 0x84, 0x8c, 0xce, 0x2a, 0xc5, 0xba,
	0x6e, 0xab, 0xa6, 0x4b, 0xd2, 0x4d, 0x79, 0x58, 0xa4, 0xef, 0xe6, 0x60, 0x36, 0xf6, 0x31, 0x7a,
	0x04, 0x2c, 0x0c, 0x0b, 0xd3, 0xc9, 0x8d, 0x67, 0xae, 0x33, 0xa5, 0xe6, 0x8d, 0x25, 0x2c, 0x2c,
	0x64, 0x48, 0x58, 0x18, 0x7e, 0xeb, 0x68, 0x99, 0x1c, 0x7e, 0x88, 0xf7, 0xd6, 0x71, 0xcb, 0x5c,
	0x34, 0xa0, 0xe8, 0x1d, 0xd2, 0x8a, 0x73, 0x30, 0xed, 0xa5, 0x32, 0x55, 0x58, 0xce, 0xa6, 0x2a,
	0x54, 0x7c, 0xd0, 0xbd, 0xc6, 0x4a, 0x55, 0x88, 0x40, 0x9a, 0x5b, 0x3b, 0xd5, 0x9c, 0x78, 0x1a,
	0xaa, 0x3e, 0xa4, 0xbe, 0xb9, 0x26, 0x6f, 0x35, 0xd7, 0xaa, 0x79, 0xf1, 0x14, 0xcc, 0x06, 0xd0,
	0x8d, 0xfa, 0x7b, 0x5b, 0x9b, 0xd5, 0xc2, 0xe2, 0x5f, 0xe4, 0xa0, 0x1a, 0x8f, 0x01, 0x12, 0xcf,
	0xc0, 0xdc, 0xce, 0xee, 0xca, 0xce, 0xaa, 0xdc, 0xdc, 0x6e, 0x35, 0xb7, 0x36, 0x95, 0xed, 0x7a,
	0x73, 0xad, 0xfa, 0x84, 0x38, 0x0f, 0x62, 0x14, 0x4c, 0x52, 0xa9, 0x0a, 0x7d, 0xf0, 0xfa, 0xda,
	0x46, 0x73, 0xb3, 0x9a, 0x13, 0x25, 0xb8, 0x14, 0x81, 0xaf, 0x37, 0x6f, 0xb7, 0x08, 0x2e, 0x65,
	0x77, 0x7b, 0x5d, 0xae, 0xaf, 0x35, 0xaa, 0x79, 0xf1, 0x1a, 0x5c, 0xee, 0xc7, 0x19, 0xad, 0x54,
	0xe8, 0xa3, 0x87, 0x24, 0x74, 0x9d, 0x10, 0x9f, 0x84, 0xab, 0x11, 0xf0, 0xda, 0xa6, 0xbc, 0xa6,
	0xc8, 0x8d, 0x9d, 0xdd, 0x15, 0x45, 0x6e, 0xac, 0xee, 0xca, 0x72, 0x73, 0x73, 0xbd, 0x3a, 0x29,
	0x3e, 0x0d, 0xd7, 0xd3, 0xaa, 0x6d, 0x6e, 0x6d, 0x06, 0x35, 0xa7, 0xc4, 0x2b, 0x70, 0x21, 0x52,
	0x73, 0x75, 0x6b, 0xad, 0xa1, 0xc8, 0x8d, 0xb5, 0xc6, 0x06, 0x29, 0x57, 0x8b, 0xe2, 0x27, 0xe1,
	0xe3, 0x83, 0x6a, 0x44, 0x09, 0x2f, 0x2d, 0xae, 0x40, 0xc9, 0xcf, 0x73, 0x42, 0xf3, 0xcf, 0x2a,
	0x2b, 0xf5, 0xb5, 0x75, 0x2c, 0xc7, 0x39, 0x98, 0x5e, 0x6b, 0xdc, 0xae, 0xef, 0xde, 0x6d, 0x31,
	0x90, 0x80, 0xc5, 0xc6, 0x90, 0xaf, 0x34, 0x64, 0x06, 0xcd, 0x2d, 0xde, 0xa2, 0xb7, 0x1b, 0x64,
	0x79, 0x17, 0xa7, 0xa1, 0x44, 0xb8, 0xc8, 0x94, 0x61, 0x0e, 0xa6, 0x49, 0xb1, 0xbe, 0xba, 0xda,
	0xd8, 0x6e, 0x35, 0xd6, 0xaa, 0x82, 0x0f, 0x5a, 0xad, 0x6f, 0xae, 0x36, 0xee, 0x36, 0xd6, 0xaa,
	0xb9, 0xc5, 0x77, 0xa0, 0x12, 0x7e, 0x47, 0x41, 0xba, 0x6e, 0xee, 0xac, 0x6e, 0xed, 0x6e, 0xfa,
	0x88, 0xce, 0xc2, 0x29, 0x1f, 0xb4, 0xdd, 0x90, 0x57, 0x1b, 0x9b, 0xad, 0xad, 0xdb, 0xb7, 0xab,
	0x82, 0x58, 0x83, 0x79, 0xff, 0xc3, 0xed, 0xe6, 0xbb, 0x8d, 0xb5, 0x77, 0xea, 0x77, 0x77, 0x1b,
	0xf8, 0x5b, 0x6e, 0x71, 0x1f, 0x8a, 0xde, 0xd5, 0x84, 0x28, 0xc2, 0x0c, 0xe9, 0xb6, 0x75, 0x7f,
	0xbb, 0xe1, 0x21, 0x3d, 0x03, 0x73, 0x01, 0x6c, 0xe3, 0xfe, 0x4e, 0xab, 0x21, 0xdf, 0xa7, 0xea,
	0x12, 0x80, 0x77, 0x5a, 0xf5, 0xcd, 0xb5, 0xba, 0xbc, 0x56, 0xcd, 0x61, 0x1a, 0x02, 0xf8, 0xea,
	0xd6, 0xc6, 0xc6, 0xee, 0x66, 0xb3, 0x75, 0xbf, 0x9a, 0x5f, 0x3c, 0x0a, 0x4e, 0xce, 0x28, 0x17,
	0xe6, 0x41, 0x8c, 0x00, 0xbc, 0x0e, 0x17, 0xe0, 0x74, 0x14, 0x5e, 0x5f, 0x6d, 0x35, 0xdf, 0xc1,
	0xac, 0x3d, 0x07, 0x67, 0xa2, 0x5f, 0xb6, 0x1b, 0x9b, 0x6b, 0x58, 0xe8, 0x39, 0x3c, 0xc2, 0xe8,
	0xa7, 0xe6, 0x26, 0x6b, 0x96, 0x5f, 0x3c, 0x84, 0x53, 0x09, 0x87, 0xdc, 0x78, 0xb0, 0xdb, 0x72,
	0xe3, 0x76, 0xf3, 0x5d, 0x65, 0x77, 0xf3, 0xce, 0xe6, 0xd6, 0xbd, 0x4d, 0x36, 0x2f, 0x3d, 0xd8,
	0x4e, 0xa3, 0x45, 0x25, 0xc1, 0x20, 0x0c, 0x5f, 0x8e, 0x4c, 0x41, 0x0a, 0x92, 0x1b, 0x6f, 0x35,
	0x56, 0xb1, 0xc4, 0xf2, 0x21, 0x6c, 0x1e, 0x51, 0x85, 0xc5, 0xbd, 0x60, 0x1b, 0xc6, 0xd2, 0x1b,
	0x87, 0xc6, 0x4c, 0x21, 0x4a, 0xdd, 0x30, 0xaa, 0x4f, 0x84, 0xc9, 0x67, 0x70, 0x76, 0x2e, 0x56,
	0x15, 0xc4, 0x0b, 0xb0, 0x10, 0x6f, 0xb3, 0xbf, 0xaf, 0x1b, 0xba, 0xea, 0xa2, 0x6a, 0x6e, 0xf1,
	0x87, 0x02, 0x9c, 0x4a, 0xf0, 0xd2, 0x70, 0xab, 0x04, 0xb0, 0xc7, 0xe3, 0x94, 0xaf, 0xf7, 0x1a,
	0x8d, 0x3b, 0x55, 0x41, 0xbc, 0x08, 0xe7, 0x92, 0xbe, 0x6e, 0x6c, 0x6d, 0xb6, 0xde, 0xac, 0xe6,
	0xd2, 0x1a, 0xdf, 0x6f, 0xd4, 0xe5, 0x6a, 0x5e, 0xbc, 0x0c, 0xe7, 0x93, 0xbe, 0x6e, 0x6d, 0x36,
	0x5a, 0xd8, 0xd0, 0x14, 0x16, 0xdf, 0x87, 0x4a, 0xd8, 0xd9, 0xc5, 0xf2, 0x0e, 0x97, 0x43, 0xd2,
	0x38, 0xeb, 0x0f, 0xad, 0x5f, 0x11, 0x22, 0x1f, 0x7c, 0x61, 0xe7, 0x96, 0xbf, 0xf5, 0x19, 0x98,
	0x8e, 0x24, 0xbd, 0x13, 0xff, 0x87, 0xe0, 0xbf, 0xd7, 0x88, 0x24, 0x3a, 0xbe, 0xc5, 0x99, 0xe7,
	0x2d, 0xf5, 0x17, 0x30, 0x6a, 0xf5, 0x31, 0x30, 0xb0, 0xd5, 0xf9, 0x9b, 0x02, 0x88, 0xfd, 0x09,
	0xff, 0xc5, 0x9b, 0x9c, 0x01, 0x40, 0x69, 0xbf, 0xc0, 0x50, 0xbb, 0x35, 0x3a, 0x82, 0x30, 0x65,
	0x7d, 0x09, 0xfa, 0xb9, 0x29, 0x4b, 0xfb, 0x39, 0x01, 0x6e, 0xca, 0x52, 0x7f, 0x1b, 0x80, 0x50,
	0xd6, 0x9f, 0x5d, 0x9f, 0x97, 0xb2, 0xd4, 0x5f, 0x15, 0xe0, 0xa5, 0x2c, 0x3d, 0xb1, 0xbf, 0xf8,
	0xbf, 0x04, 0xcf, 0x0b, 0x8e, 0x66, 0x80, 0x17, 0xeb, 0x59, 0x50, 0x27, 0x26, 0xb5, 0xaf, 0xad,
	0x8c, 0x83, 0x82, 0xd1, 0xf7, 0xef, 0x04, 0xa8, 0x84, 0xd3, 0xee, 0x8b, 0x2f, 0x73, 0x0b, 0x23,
	0xfe, 0x63, 0x05, 0xb5, 0x57, 0x46, 0x69, 0xca, 0xe8, 0xf8, 0x8e, 0x00, 0x67, 0x12, 0x53, 0x03,
	0x8b, 0x2b, 0xe3, 0x27, 0x97, 0xaf, 0xad, 0x8e, 0x85, 0x83, 0x91, 0xf8, 0x7f, 0x85, 0x20, 0x57,
	0x7f, 0x52, 0x5a, 0x66, 0x31, 0x63, 0x1a, 0xfc, 0x01, 0xe9, 0xe9, 0x6b, 0x6f, 0x9d, 0x04, 0x2a,
	0x46, 0xf7, 0xaf, 0xfb, 0xc2, 0x26, 0x07, 0xe5, 0x2a, 0x16, 0xef, 0x71, 0x27, 0x2a, 0xcd, 0x96,
	0xf4, 0xbe, 0xf6, 0xee, 0xc9, 0x23, 0x0e, 0x4d, 0xb2, 0xa4, 0xc4, 0xb2, 0xbc, 0x93, 0x6c, 0x40,
	0x3a, 0x5b, 0xde, 0x49, 0x36, 0x30, 0xaf, 0xed, 0x0f, 0x69, 0xb6, 0xbd, 0x94, 0x61, 0x89, 0xeb,
	0xe3, 0x32, 0xc6, 0xa3, 0xf5, 0xcd, 0xf1, 0x11, 0x31, 0x8a, 0x7f, 0x24, 0xf8, 0x49, 0x7e, 0x93,
	0x32, 0x0f, 0x8b, 0xd9, 0x7a, 0x1a, 0x90, 0x12, 0xba, 0xd6, 0x3c, 0x01, 0x4c, 0x8c, 0xe8, 0xbf,
	0x0c, 0x82, 0x6e, 0x79, 0xd2, 0x25, 0x8b, 0xef, 0x8e, 0xdd, 0x75, 0x9a, 0xaa, 0xdf, 0x7f, 0x0c,
	0x98, 0xd9, 0x20, 0xbf, 0x2f, 0x84, 0x53, 0x19, 0x46, 0xa5, 0xb2, 0x76, 0x12, 0x39, 0x86, 0x6b,
	0x8d, 0x31, 0xb1, 0x44, 0x27, 0x65, 0x5f, 0x2e, 0xde, 0x0c, 0x93, 0x32, 0x2d, 0x69, 0x70, 0x86,
	0x49, 0x99, 0x9e, 0x0a, 0x18, 0x3b, 0x81, 0x09, 0x69, 0x6b, 0x79, 0x9d, 0xc0, 0xf4, 0xd4, 0xbb,
	0xb5, 0xfa, 0x18, 0x18, 0x18, 0x71, 0x5f, 0x15, 0x48, 0x78, 0x54, 0x38, 0x61, 0xad, 0xf8, 0x1a,
	0x37, 0xda, 0x84, 0x9c, 0xb8, 0xb5, 0xd7, 0x47, 0x6c, 0xcd, 0x08, 0xfa, 0x3f, 0xf4, 0x75, 0x79,
	0x62, 0x3a, 0x5a, 0x91, 0x5f, 0x63, 0x06, 0x25, 0xc3, 0xad, 0xdd, 0x1e, 0x17, 0x0d, 0xa3, 0xf5,
	0xcb, 0x02, 0xcc, 0x44, 0xf3, 0xc9, 0x8a, 0x9c, 0xe1, 0xf3, 0x89, 0x29, 0x6f, 0x6b, 0xaf, 0x8d,
	0xd6, 0x98, 0x51, 0xf3, 0x0d, 0x01, 0xe6, 0xfa, 0x32, 0xc9, 0x8a, 0x6f, 0x64, 0xc3, 0x19, 0xcf,
	0x6a, 0x5b, 0xbb, 0x39, 0x72, 0xfb, 0x90, 0xcb, 0xdc, 0x9f, 0x01, 0x96, 0xd7, 0x65, 0x4e, 0xcd,
	0x6a, 0x5b, 0xbb, 0x35, 0x3a, 0x82, 0xa8, 0xee, 0x47, 0xf2, 0x15, 0xbe, 0x96, 0xd5, 0x26, 0x45,
	0x68, 0x7a, 0x7d, 0xc4, 0xd6, 0x21, 0x56, 0xf5, 0x27, 0x51, 0xe5, 0x65, 0x55, 0x6a, 0x3e, 0x58,
	0x5e, 0x56, 0x0d, 0xc8, 0xdf, 0xfa, 0x53, 0x01, 0x2e, 0x0d, 0x4e, 0x72, 0x2a, 0xde, 0xc9, 0xb2,
	0xed, 0x1b, 0x92, 0x87, 0xb5, 0x76, 0xf7, 0x64, 0x90, 0xf5, 0xed, 0x74, 0x47, 0xe1, 0x6b, 0x6a,
	0xf6, 0xd4, 0x6c, 0x3b, 0xdd, 0x54, 0x89, 0xf7, 0x67, 0xdd, 0xcc, 0x30, 0x39, 0x92, 0x73, 0x7d,
	0x66, 0x98, 0x1c, 0x69, 0x09, 0x3f, 0x8f, 0xa1, 0xe8, 0xfd, 0x30, 0xb9, 0xc8, 0x79, 0x6c, 0x1f,
	0xfb, 0x99, 0xf4, 0xda, 0x0b, 0x59, 0x9b, 0x85, 0x96, 0x80, 0xb4, 0x1f, 0x77, 0xe6, 0x5d, 0x02,
	0x86, 0xfc, 0xbc, 0x34, 0xef, 0x12, 0x30, 0xf4, 0x37, 0xa6, 0xb1, 0xff, 0x3a, 0x20, 0x21, 0x12,
	0xaf, 0xff, 0x3a, 0x3c, 0x55, 0x15, 0xaf, 0xff, 0xca, 0x93, 0x9d, 0x09, 0x33, 0x38, 0x2d, 0x5d,
	0x0f, 0x2f, 0x83, 0x87, 0xe4, 0x4c, 0xe2, 0x65, 0xf0, 0xd0, 0xac, 0x41, 0x84, 0xc1, 0xe9, 0xd9,
	0x7c, 0xb8, 0x19, 0x3c, 0x34, 0xbf, 0x10, 0x37, 0x83, 0x39, 0x52, 0x0b, 0xfd, 0x91, 0xe0, 0xff,
	0x86, 0xcc, 0xa0, 0xac, 0x3c, 0xe2, 0xf6, 0x28, 0xfb, 0xa8, 0x81, 0x83, 0x78, 0xfb, 0x04, 0x31,
	0xb2, 0xc1, 0xfc, 0x4c, 0x20, 0x57, 0x7d, 0x03, 0x53, 0xeb, 0x88, 0x1b, 0xdc, 0xfd, 0xf2, 0xa4,
	0x01, 0xaa, 0x6d, 0x9e, 0x14, 0xba, 0xd0, 0x8e, 0x2d, 0x43, 0x8a, 0x1b, 0xde, 0x1d, 0x5b, 0xf6,
	0xac, 0x3e, 0xbc, 0x3b, 0xb6, 0x11, 0xf2, 0xf1, 0x78, 0xfe, 0x4c, 0xf8, 0x27, 0xbd, 0x33, 0xf8,
	0x33, 0x09, 0xbf, 0xeb, 0x9e, 0xc1, 0x9f, 0x49, 0xfc, 0x1d, 0x71, 0x4c, 0xd0, 0xce, 0x68, 0x04,
	0xed, 0x8c, 0x45, 0x50, 0xda, 0x0f, 0x9b, 0xff, 0x44, 0x80, 0x8b, 0x03, 0x93, 0x1b, 0x8b, 0x6f,
	0x71, 0x8f, 0x78, 0x68, 0x5e, 0xe7, 0xda, 0x9d, 0x13, 0xc1, 0x15, 0x9d, 0x85, 0x03, 0x53, 0x10,
	0x67, 0x98, 0x85, 0x3c, 0xe9, 0x99, 0x33, 0xcc, 0x42, 0xbe, 0xcc, 0xc8, 0x4c, 0x41, 0xc3, 0xc9,
	0x67, 0x33, 0x28, 0x68, 0x42, 0x3e, 0xdc, 0x0c, 0x0a, 0x9a, 0x98, 0xf1, 0x16, 0xbb, 0x5f, 0xfd,
	0xa9, 0x29, 0x79, 0xdd, 0xaf, 0xd4, 0xa4, 0xa3, 0xb5, 0x5b, 0xa3, 0x23, 0x08, 0x6d, 0xe6, 0xfa,
	0x52, 0xc3, 0xf2, 0x6e, 0xe6, 0xd2, 0x92, 0xed, 0xd6, 0x6e, 0x8e, 0xdc, 0x3e, 0x4c, 0x56, 0x3c,
	0x13, 0x2b, 0x37, 0x59, 0x29, 0x69, 0x67, 0x6b, 0x37, 0x47, 0x6e, 0xcf, 0xc8, 0xfa, 0x02, 0x40,
	0x90, 0x05, 0x47, 0xe4, 0xcc, 0x77, 0xd9, 0x97, 0x1e, 0xa8, 0xf6, 0x52, 0xf6, 0x86, 0x01, 0x01,
	0x41, 0x2e, 0x1b, 0x5e, 0x02, 0xfa, 0x52, 0xec, 0xf0, 0x12, 0x90, 0x90, 0x36, 0xe7, 0x18, 0x8a,
	0x5e, 0x3e, 0x1a, 0x5e, 0x77, 0x3d, 0x96, 0x15, 0x87, 0xd7, 0x5d, 0xef, 0x4b, 0x7b, 0xf3, 0x08,
	0xa6, 0x58, 0xbe, 0x12, 0xf1, 0x06, 0x37, 0xfd, 0xe1, 0x51, 0x3f, 0x9f, 0xb1, 0x15, 0xeb, 0xf7,
	0x3f, 0x0b, 0x7e, 0x0e, 0x9e, 0x20, 0x0d, 0xc5, 0xeb, 0x99, 0x06, 0x11, 0x4f, 0x07, 0x50, 0x7b,
	0x63, 0xd4, 0xe6, 0xd1, 0x43, 0xd3, 0xa4, 0xac, 0x00, 0x19, 0x0e, 0x4d, 0x07, 0x24, 0x2c, 0xc8,
	0x70, 0x68, 0x3a, 0x30, 0x35, 0xc1, 0xbf, 0x17, 0x60, 0x3a, 0x92, 0x61, 0x47, 0xcc, 0x70, 0xa9,
	0x16, 0xcf, 0x07, 0x54, 0x7b, 0x75, 0xa4, 0xb6, 0x21, 0x39, 0xc6, 0x13, 0xde, 0xf0, 0xca, 0x31,
	0x25, 0xdf, 0x4f, 0xed, 0x8d, 0x51, 0x9b, 0x87, 0x6e, 0x2b, 0xc3, 0x31, 0xf6, 0xbc, 0xb7, 0x95,
	0x09, 0xc9, 0x19, 0x78, 0x6f, 0x2b, 0x93, 0x42, 0xfa, 0xc9, 0x4e, 0x2d, 0x2d, 0x54, 0x9d, 0x77,
	0xa7, 0x36, 0x24, 0x25, 0x00, 0xef, 0x4e, 0x6d, 0x58, 0xc4, 0x3c, 0xd1, 0xfd, 0x94, 0xa0, 0x73,
	0x5e, 0xdd, 0x1f, 0x1c, 0x70, 0x5f, 0x6b, 0x8c, 0x89, 0x25, 0x74, 0xbf, 0x3a, 0x28, 0x30, 0x9c,
	0xf7, 0x7e, 0x95, 0x23, 0x7a, 0x9e, 0xf7, 0x7e, 0x95, 0x27, 0x4e, 0xdd, 0x3b, 0x2c, 0x8a, 0xc5,
	0x1f, 0x67, 0x38, 0x2c, 0x4a, 0x8e, 0x7a, 0xce, 0x70, 0x58, 0x94, 0x16, 0xfa, 0x8c, 0xad, 0x49,
	0x24, 0x80, 0x9b, 0xd7, 0x9a, 0x24, 0x05, 0xba, 0xf3, 0x5a, 0x93, 0xe4, 0x88, 0xf1, 0x2f, 0x0b,
	0x30, 0x13, 0x8d, 0x98, 0x16, 0xf9, 0xf1, 0xf5, 0xc7, 0x66, 0xd7, 0x5e, 0x1b, 0xad, 0x31, 0xa3,
	0xe6, 0x3f, 0x0a, 0x30, 0x13, 0x8d, 0xe9, 0xe5, 0xa5, 0x26, 0x31, 0xb6, 0xb9, 0x36, 0x62, 0xe3,
	0x80, 0x35, 0xd1, 0x90, 0x5b, 0x5e, 0x62, 0x12, 0x23, 0x81, 0x79, 0x59, 0x93, 0x12, 0xe5, 0xcb,
	0x6e, 0x7e, 0xd3, 0x82, 0x6a, 0x33, 0xdc, 0xfc, 0x0e, 0x89, 0xef, 0xcd, 0x70, 0xf3, 0x3b, 0x34,
	0xc2, 0x97, 0x4d, 0xc1, 0x58, 0xe4, 0x68, 0x86, 0x29, 0x98, 0x1c, 0xa9, 0x9a, 0x61, 0x0a, 0xa6,
	0x05, 0xad, 0x62, 0xcf, 0xbc, 0x2f, 0x6e, 0x5f, 0x7c, 0x23, 0x93, 0xf6, 0xf6, 0x05, 0xaf, 0xd6,
	0x6e, 0x8e, 0xdc, 0x3e, 0x74, 0x39, 0x9b, 0x14, 0xc7, 0xca, 0x7b, 0x39, 0x3b, 0x20, 0xb2, 0x96,
	0xf7, 0x72, 0x76, 0x50, 0x18, 0xad, 0x77, 0xdd, 0x98, 0x18, 0x01, 0x9b, 0xe1, 0xba, 0x71, 0x50,
	0x1c, 0x6e, 0x86, 0xeb, 0xc6, 0xc1, 0x81, 0xb8, 0xec, 0x22, 0x39, 0x5e, 0x29, 0xc3, 0x45, 0x72,
	0x4a, 0xfc, 0x66, 0x86, 0x8b, 0xe4, 0xd4, 0x20, 0xc6, 0xff, 0x2d, 0xc0, 0x7c, 0x72, 0x9c, 0xa3,
	0x38, 0x4e, 0x38, 0xa3, 0x4f, 0xe2, 0xda, 0x78, 0x48, 0xa2, 0x7b, 0x86, 0x48, 0xfc, 0x4f, 0x86,
	0x3d, 0x43, 0x52, 0xcc, 0x51, 0x86, 0x3d, 0x43, 0x72, 0xd8, 0x91, 0x67, 0x53, 0xa2, 0xa1, 0x3e,
	0x59, 0x6c, 0x4a, 0x62, 0x98, 0x51, 0x16, 0x9b, 0x92, 0x12, 0x65, 0xc4, 0x28, 0x8b, 0x45, 0x97,
	0x64, 0xa0, 0x2c, 0x39, 0x38, 0x26, 0x03, 0x65, 0x69, 0xd1, 0x43, 0xd8, 0xe1, 0x88, 0x44, 0xe6,
	0xf0, 0x3a, 0x1c, 0x49, 0x81, 0x42, 0xbc, 0xab, 0x6a, 0x62, 0x28, 0x10, 0x79, 0x50, 0x98, 0x18,
	0x85, 0x23, 0x66, 0x7a, 0x36, 0x99, 0xc2, 0xaa, 0xd5, 0xb1, 0x70, 0x84, 0xb4, 0xbe, 0xd1, 0x51,
	0x75, 0x23, 0xfc, 0x3a, 0xe6, 0x75, 0xde, 0x70, 0xf7, 0x68, 0xbb, 0x8c, 0x5a, 0xdf, 0xdf, 0x3c,
	0x4e, 0xd3, 0xba, 0x61, 0xed, 0xa9, 0x64, 0xd9, 0x45, 0x99, 0x68, 0x0a, 0xb5, 0x1b, 0x85, 0xa6,
	0x48, 0xf3, 0xd0, 0xf3, 0x39, 0xf2, 0x91, 0xd9, 0x0f, 0xba, 0x56, 0xd4, 0x49, 0x80, 0xb8, 0x6a,
	0xf0, 0x3e, 0x9f, 0x4b, 0xc7, 0x90, 0xf1, 0xf9, 0xdc, 0x20, 0x44, 0xd1, 0xe5, 0x2b, 0x31, 0x0c,
	0x2b, 0xc3, 0xf2, 0x35, 0x28, 0x42, 0x2c, 0xc3, 0xf2, 0x35, 0x30, 0x1a, 0x6c, 0xa5, 0xfc, 0x5e,
	0x09, 0xb7, 0x70, 0x0f, 0x75, 0xbb, 0xbb, 0x37, 0x49, 0x62, 0x98, 0x9e, 0xfb, 0xe7, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xaf, 0xc7, 0x33, 0x94, 0xee, 0x9d, 0x00, 0x00,
}
