package chatlog

import "code.justin.tv/safety/datastore/models"

const (
	// Chatlog table
	tableChatlog         = "Chatlogs"
	chatPrimaryKey       = "MessageID"
	chatChannelIDKey     = "ChannelID"
	chatGSISortKey       = "Timestamp"
	chatMessageTextKey   = "MessageText"
	chatSystemMessageKey = "SystemMessage"

	// ChatActivityLog table
	tableChatActivityLog = "ChatActivityLog"
	userIDKey            = "UserID"
)

// indexDynamoKeys maps indexes to its primary key
var indexDynamoKeys = map[string]string{
	models.ChatChannelIndex: chatChannelIDKey,
	models.ChatUserIndex:    "UserID",
}
