package datastore

import (
	"code.justin.tv/safety/datastore/chatlog"
	"code.justin.tv/safety/datastore/interfaces"
	"code.justin.tv/safety/datastore/leviathan"
	"code.justin.tv/safety/datastore/models"
	"code.justin.tv/safety/datastore/reportrouter"
)

type datastore struct {
	interfaces.Chatlog
	interfaces.Leviathan
	interfaces.ReportRouter
}

// Config defines a list of config parameter needed to initialize
type Config struct {
	Leviathan *leviathan.Config
	Chatlog   *chatlog.Config
	Router    *reportrouter.Config
}

// New creates a new datastore that can be used to access
func New(conf Config) (interfaces.Datastore, error) {
	ds := datastore{}
	if conf.Leviathan == nil && conf.Chatlog == nil {
		return nil, models.ErrAtLeastOneDBRequired
	}

	if conf.Chatlog != nil {
		chatDS, err := chatlog.New(conf.Chatlog)
		if err != nil {
			return nil, err
		}

		ds.Chatlog = chatDS
	}

	if conf.Leviathan != nil {
		leviathanDS, err := leviathan.New(conf.Leviathan)
		if err != nil {
			return nil, err
		}

		ds.Leviathan = leviathanDS
	}

	if conf.Router != nil {
		routerDS, err := reportrouter.New(conf.Router)
		if err != nil {
			return nil, err
		}

		ds.ReportRouter = routerDS
	}

	return &ds, nil
}
