package leviathan

import (
	"context"

	"code.justin.tv/safety/datastore/models"
	"github.com/Masterminds/squirrel"
	"github.com/pkg/errors"
)

// BanExceptionsByUsers returns a list of ban exceptions that applies to the given users
func (t *Transaction) BanExceptionsByUsers(ctx context.Context, userIDs []int64) ([]*models.BanException, error) {
	q := squirrel.Select("*").From(tableBanExceptions).
		Where(squirrel.Eq{"target_user_id": userIDs})

	sql, args, err := q.ToSql()
	if err != nil {
		return nil, errors.Wrap(err, msgSQLConversion)
	}

	var result []*models.BanException
	err = t.tx.SelectContext(ctx, &result, sql, args...)
	if err != nil {
		return nil, errors.Wrap(err, msgSelectContext)
	}

	return result, nil
}
