package leviathan

// DB tables
const (
	tableAutoResolves          = "auto_resolves"
	tableBanExceptions         = "ban_exceptions"
	tableFileUploads           = "file_uploads"
	tableFileUploadAudits      = "file_upload_audits"
	tableReportAudits          = "report_audits"
	tableReportComments        = "report_comments"
	tableReportHolds           = "report_holds"
	tableReports               = "reports"
	tableSuspensions           = "suspensions"
	tableEnforcements          = "enforcements"
	tableWarnings              = "warnings"
	tableUsers                 = "users"
	tableUserContentAudits     = "user_content_audits"
	tablePartnerEscalationList = "partner_escalation_partners"

	// Commented out for linting. Not in use atm but we'll need it one day
	// tableSuspensionChecks = "suspension_checks"
	tableSuspensionGuides               = "suspension_guides"
	tableSuspensionGuideContents        = "suspension_guide_contents"
	tableSuspensionGuideReasons         = "suspension_guide_reasons"
	tableSuspensionGuideDetailedReasons = "suspension_guide_detailed_reasons"
)

// Special columns
const (
	columnID = "id"
)

// Internal error messages
const (
	msgSelectContext = "calling selectContext"
	msgInsertContext = "calling insertContext"
	msgUpdateContext = "calling updateContext"
	msgDeleteContext = "calling deleteContext"

	msgRetrieveRowsAffected = "retrieving num rows affected"
	msgRetrieveLastID       = "retrieving last inserted id"
	msgSQLConversion        = "converting to sql query"
)
