package leviathan

import (
	"context"
	"time"

	"code.justin.tv/safety/datastore/models"
	"github.com/pkg/errors"
)

// CreateFileUpload creates a new file upload record
func (t *Transaction) CreateFileUpload(ctx context.Context, fileUpload models.FileUpload) (*int64, error) {
	now := time.Now()
	fileUpload.CreatedAt = now
	fileUpload.UpdatedAt = now

	sql, args, err := toInsertStatement(tableFileUploads, fileUpload)
	if err != nil {
		return nil, errors.Wrap(err, msgSQLConversion)
	}

	sqlResult, err := t.tx.ExecContext(ctx, sql, args...)
	if err != nil {
		return nil, errors.Wrap(err, msgInsertContext)
	}

	id, err := sqlResult.LastInsertId()
	if err != nil {
		return nil, errors.Wrap(err, msgRetrieveLastID)
	}

	return &id, nil
}
