package leviathan

import (
	"context"
	"time"

	"code.justin.tv/safety/datastore/models"
	"github.com/pkg/errors"
)

// CreateFileUploadAudit creates a new file upload audit
func (t *Transaction) CreateFileUploadAudit(ctx context.Context, audit models.FileUploadAudit) (*int64, error) {
	now := time.Now()
	audit.CreatedAt = now
	audit.UpdatedAt = now

	sql, args, err := toInsertStatement(tableFileUploadAudits, audit)
	if err != nil {
		return nil, errors.Wrap(err, msgSQLConversion)
	}

	sqlResult, err := t.tx.ExecContext(ctx, sql, args...)
	if err != nil {
		return nil, errors.Wrap(err, msgInsertContext)
	}

	// Update ID after we successfully insert report
	id, err := sqlResult.LastInsertId()
	if err != nil {
		return nil, errors.Wrap(err, msgRetrieveLastID)
	}

	return &id, nil
}
