package leviathan

import (
	"context"

	"github.com/jmoiron/sqlx"
)

// sqlxDB is interface for sqlx.DB
type sqlxDB interface {
	Beginx() (*sqlx.Tx, error)
	Close() error
}

// sqlxTx is interface for sqlx.Tx
type sqlxTx interface {
	sqlxCommands

	Commit() error
	Rollback() error
}

type sqlxCommands interface {
	sqlx.ExtContext
	SelectContext(ctx context.Context, dest interface{}, query string, args ...interface{}) error
}
