package audit

import (
	"encoding/json"

	"github.com/pkg/errors"
)

// Content is content of audit
type Content struct {
	TargetUserID string `json:"target_user_id"`
	FileURL      string `json:"file_url"`
}

// FormatContent return formatted content
func FormatContent(content Content) (string, error) {
	b, err := json.Marshal(content)
	if err != nil {
		return "", errors.Wrap(err, "marshalling content to json")
	}

	return string(b), nil
}
