package models

// FilterType is the type of the filter
type FilterType int

// Filter types
const (
	// FilterEqual filters the result only if the field matches. Support multiple values
	FilterEqual FilterType = iota
	// FilterNotEqual filters the result only if the field doesn't match. Support multiple values
	FilterNotEqual
	// FilterNullOrNotEqual filters the result only if the field is null or the field's value doesn't match.
	FilterNullOrNotEqual
	// FilterGreaterThan filters the result only if the field is greater than the value.
	FilterGreaterThan
	// FilterLessThan filters the result only if the field is less than the value.
	FilterLessThan
	// FilterIncludes filters the result only if the string field includes the string value.
	FilterIncludes
	// FilterBetween filteres the result only if the value is between the given values.
	// Expects an []interface{} slice of 2 values.
	FilterBetween
)

// Filter is a filter that
type Filter struct {
	Type  FilterType  // Type of filter to apply
	Value interface{} // Value of the field value to filter with
}

// ReportFilter defines filterable fields for reports
type ReportFilter struct {
	ID                    *Filter `db:"id"`
	Status                *Filter `db:"status"`
	AssignedTo            *Filter `db:"assigned_to"`
	AssignedToQueue       *Filter `db:"assigned_to_queue"`
	FromUserUsername      *Filter `db:"from_user_username"`
	FromUserID            *Filter `db:"from_user_id"`
	FromUserType          *Filter `db:"from_user_type"`
	FromUserPartner       *Filter `db:"from_user_partner"`
	TargetUserUsername    *Filter `db:"target_user_username"`
	TargetUserID          *Filter `db:"target_user_id"`
	TargetUserType        *Filter `db:"target_user_type"`
	TargetUserPartner     *Filter `db:"target_user_partner"`
	Content               *Filter `db:"content"`
	ContentID             *Filter `db:"content_id"`
	Reason                *Filter `db:"reason"`
	Description           *Filter `db:"description"`
	FromUserDisplayName   *Filter `db:"from_user_display_name"`
	TargetUserDisplayName *Filter `db:"target_user_display_name"`
	Origin                *Filter `db:"origin"`
	TargetUserGame        *Filter `db:"target_user_game"`
	Language              *Filter `db:"language"`
	CreatedAt             *Filter `db:"created_at"`
}

// SuspensionFilter defines filterable fields for suspensions
type SuspensionFilter struct {
	ID                    *Filter `db:"id"`
	FromUserID            *Filter `db:"from_user_id"`
	FromUserType          *Filter `db:"from_user_type"`
	TargetUserUsername    *Filter `db:"target_user_username"`
	TargetUserID          *Filter `db:"target_user_id"`
	TargetUserType        *Filter `db:"target_user_type"`
	TargetUserPartner     *Filter `db:"target_user_partner"`
	TargetUserDisplayName *Filter `db:"target_user_display_name"`
	Content               *Filter `db:"content"`
	Reason                *Filter `db:"reason"`
	DetailedReason        *Filter `db:"detailed_reason"`
	Description           *Filter `db:"description"`
	Duration              *Filter `db:"duration"`
	IPBan                 *Filter `db:"ip_ban"`
	ClearedChannelImages  *Filter `db:"cleared_channel_images"`
	Origin                *Filter `db:"origin"`
	TargetUserGame        *Filter `db:"target_user_game"`
	CurrentLiveVod        *Filter `db:"current_live_vod"`
	CreatedAt             *Filter `db:"created_at"`
}

// Warning is the list of fields you can filter on for warnings
type WarningFilter struct {
	ID                    *Filter `db:"id"`
	FromUserID            *Filter `db:"from_user_id"`
	FromUserType          *Filter `db:"from_user_type"`
	TargetUserUsername    *Filter `db:"target_user_username"`
	TargetUserID          *Filter `db:"target_user_user_id"`
	TargetUserType        *Filter `db:"target_user_type"`
	TargetUserPartner     *Filter `db:"target_user_partner"`
	TargetUserDisplayName *Filter `db:"target_user_display_name"`
	Content               *Filter `db:"content"`
	Reason                *Filter `db:"reason"`
	DetailedReason        *Filter `db:"detailed_reason"`
	Description           *Filter `db:"description"`
	Origin                *Filter `db:"origin"`
	TargetUserGame        *Filter `db:"target_user_game"`
	Seen                  *Filter `db:"seen"`
	CreatedAt             *Filter `db:"created_at"`
	UpdatedAt             *Filter `db:"updated_at"`
}

// EnforcementFilter is the list of fields to filter on for Enforcements
type EnforcementFilter struct {
	ID                *Filter `db:"id"`
	Reason            *Filter `db:"reason"`
	DetailedReason    *Filter `db:"detailed_reason"`
	FromUserID        *Filter `db:"from_user_id"`
	TargetUserID      *Filter `db:"target_user_user_id"`
	Content           *Filter `db:"content"`
	Description       *Filter `db:"description"`
	EnforcementType   *Filter `db:"enforcement_type"`
	EnforcementID     *Filter `db:"enforcement_id"`
	TargetUserType    *Filter `db:"target_user_type"`
	TargetUserPartner *Filter `db:"target_user_parter"`
	TargetUserGame    *Filter `db:"target_user_game"`
	CreatedAt         *Filter `db:"created_at"`
	UpdatedAt         *Filter `db:"updated_at"`
}
