package queue

// List of queues supported by the system
const (
	Main          = int64(0)
	Investigative = int64(1)
)

var (
	// NameToValueMap maps all name of queues in system to their value
	NameToValueMap = map[string]int64{
		"Main":          Main,
		"Investigative": Investigative,
	}

	// ValueToNameMap maps all values of their names to their respective values in system
	ValueToNameMap = make(map[int64]string, len(NameToValueMap))
)

func init() {
	for name, value := range NameToValueMap {
		ValueToNameMap[value] = name
	}
}
