package reportcontent

// Report Content Constants
const (
	ChannelFeedComment = "channel_feed_comment_report"
	ChannelFeedPost    = "channel_feed_post_report"
	Chat               = "chat_report"
	Clip               = "clip_report"
	Collection         = "collection_report"
	Community          = "community_report"
	CursePrivateGroup  = "curse_private_group"
	CursePublicGroup   = "curse_public_group"
	CursePublicServer  = "curse_public_server"
	CurseWhisper       = "curse_whisper"
	Emote              = "emote_report"
	Extension          = "extension_report"
	Event              = "event_report"
	LiveUp             = "live_up_report"
	Raid               = "raid_report"
	Room               = "room_report"
	User               = "user_report"
	VodComment         = "vod_comment_report"
	Vod                = "vod_report"
	Whisper            = "whisper_report"

	// Content for Twitch Sings
	SingsGroupName  = "sings_group_name_report"
	SingsGroupBio   = "sings_group_bio_report"
	SingsGroupChat  = "sings_group_chat_report"
	SingsVodComment = "sings_vod_comment_report"
	SingsDuetSeed   = "sings_duet_seed_report"
)

var (
	// Contents contains all report content types
	Contents = map[string]struct{}{
		ChannelFeedComment: struct{}{},
		ChannelFeedPost:    struct{}{},
		Chat:               struct{}{},
		Clip:               struct{}{},
		Collection:         struct{}{},
		Community:          struct{}{},
		CursePrivateGroup:  struct{}{},
		CursePublicGroup:   struct{}{},
		CursePublicServer:  struct{}{},
		CurseWhisper:       struct{}{},
		Emote:              struct{}{},
		Event:              struct{}{},
		Extension:          struct{}{},
		LiveUp:             struct{}{},
		Raid:               struct{}{},
		Room:               struct{}{},
		SingsDuetSeed:      struct{}{},
		SingsGroupBio:      struct{}{},
		SingsGroupChat:     struct{}{},
		SingsGroupName:     struct{}{},
		SingsVodComment:    struct{}{},
		User:               struct{}{},
		Vod:                struct{}{},
		VodComment:         struct{}{},
		Whisper:            struct{}{},
	}
)
