package reportreason

// Report reasons
const (
	BitsViolation     = "bits_violation"
	ChatBanEvasion    = "chat_ban_evasion"
	Cheating          = "cheating"
	Gore              = "gore"
	Harassment        = "harassment"
	Harm              = "harm"
	HatefulConduct    = "hateful_conduct"
	Impersonation     = "impersonation"
	Miscategorized    = "miscategorized"
	OffensiveUsername = "offensive_username"
	Other             = "other"
	Prohibited        = "prohibited"
	SelfHarm          = "selfharm"
	SexualContent     = "sexual_content"
	SexualViolence    = "sexual_violence"
	Spam              = "spam"
	TosBanEvasion     = "tos_ban_evasion"
	Underaged         = "underaged"

	// Legacy reasons
	CommunityRulesViolation = "community_rules_violation"
	CommunityTosViolation   = "community_tos_violation"
	CreativeConduct         = "creative_conduct"
	Ddos                    = "ddos"
	HateSpeech              = "hate_speech"
	MusicConduct            = "music_conduct"
	Nongaming               = "nongaming"
	Nudity                  = "nudity"
	Porn                    = "porn"
	SocialEatingViolation   = "social_eating_violation"
)

var (
	// Reasons contains all report reasons types
	Reasons = map[string]struct{}{
		BitsViolation:           struct{}{},
		ChatBanEvasion:          struct{}{},
		Cheating:                struct{}{},
		CommunityRulesViolation: struct{}{},
		CommunityTosViolation:   struct{}{},
		CreativeConduct:         struct{}{},
		Ddos:                    struct{}{},
		Gore:                    struct{}{},
		Harassment:              struct{}{},
		Harm:                    struct{}{},
		HatefulConduct:          struct{}{},
		HateSpeech:              struct{}{},
		Impersonation:           struct{}{},
		Miscategorized:          struct{}{},
		MusicConduct:            struct{}{},
		Nongaming:               struct{}{},
		Nudity:                  struct{}{},
		OffensiveUsername:       struct{}{},
		Other:                   struct{}{},
		Porn:                    struct{}{},
		Prohibited:              struct{}{},
		SelfHarm:                struct{}{},
		SexualContent:           struct{}{},
		SexualViolence:          struct{}{},
		SocialEatingViolation:   struct{}{},
		Spam:                    struct{}{},
		TosBanEvasion:           struct{}{},
		Underaged:               struct{}{},
	}
)
