package models

// SortType is the type of sorting
type SortType int

// List of sort types
const (
	SortAscending = iota
	SortDescending
)

// Sort is used to sort the result
type Sort struct {
	Type SortType // Type of sort to apply
}

// ReportSort defines sortable fields for reports
type ReportSort struct {
	ID        *Sort `db:"id"`
	CreatdAt  *Sort `db:"created_at"`
	UpdatedAt *Sort `db:"updated_at"`
}

// SuspensionSort defines sortable fields for suspensions
type SuspensionSort struct {
	ID        *Sort `db:"id"`
	CreatedAt *Sort `db:"created_at"`
	UpdatedAt *Sort `db:"updated_at"`
}

// WarningSort defines sortable fields for Warnings
type WarningSort struct {
	ID        *Sort `db:"id"`
	CreatedAt *Sort `db:"created_at"`
}

// EnforcementSort defines sortable fields for Enforcements
type EnforcementSort struct {
	ID        *Sort `db:"id"`
	CreatedAt *Sort `db:"created_at"`
}
