// Code generated by protoc-gen-twirp v5.5.2, DO NOT EDIT.
// source: rpc/gateway/gateway.proto

/*
Package gateway is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.2.

It is generated from these files:
	rpc/gateway/gateway.proto
*/
package gateway

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// =================
// Gateway Interface
// =================

// Gateway service is the gateway of aegis project for moderation.
type Gateway interface {
	// GetAllReasons return localized names for every reason we support for a specific locale
	GetAllReasons(context.Context, *GetAllReasonsRequest) (*GetReasonsResponse, error)

	// GetReasons returns localized reasons for requested report content and locale
	GetReasons(context.Context, *GetReasonsRequest) (*GetReasonsResponse, error)

	// GetSuspensionGuide returns the suspension guide
	GetSuspensionGuide(context.Context, *GetSuspensionGuideRequest) (*GetSuspensionGuideResponse, error)

	// CreateReport creates a new report
	CreateReport(context.Context, *CreateReportRequest) (*CreateReportResponse, error)

	// CreateSuspension creates a new suspension
	CreateSuspension(context.Context, *CreateSuspensionRequest) (*CreateSuspensionResponse, error)

	// CreateShift creates a shift, for Leviathan
	CreateShift(context.Context, *CreateShiftRequest) (*CreateShiftResponse, error)

	// ModifyShift modifies a shift, for Leviathan
	ModifyShift(context.Context, *ModifyShiftRequest) (*ModifyShiftResponse, error)

	// DeleteShift deletes a shift, for Leviathan
	DeleteShift(context.Context, *DeleteShiftRequest) (*DeleteShiftResponse, error)

	// GetShifts returns currently active shifts, for Leviathan
	GetShifts(context.Context, *GetShiftsRequest) (*GetShiftsResponse, error)

	// GetRoutedReports returns currently routed report IDs, for Leviathan
	GetRoutedReports(context.Context, *GetRoutedReportsRequest) (*GetRoutedReportsResponse, error)

	// CreateEnforcement will create a warning or suspenion on a user depending on the provided reason
	CreateEnforcement(context.Context, *CreateEnforcementRequest) (*CreateEnforcementResponse, error)

	// CreatePartnershipsNotification will create a notification for partnerships via partner-enforcements-topic SNS
	CreatePartnershipsNotification(context.Context, *CreatePartnershipsNotificationRequest) (*CreatePartnershipsNotificationResponse, error)
}

// =======================
// Gateway Protobuf Client
// =======================

type gatewayProtobufClient struct {
	client HTTPClient
	urls   [12]string
}

// NewGatewayProtobufClient creates a Protobuf client that implements the Gateway interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewGatewayProtobufClient(addr string, client HTTPClient) Gateway {
	prefix := urlBase(addr) + GatewayPathPrefix
	urls := [12]string{
		prefix + "GetAllReasons",
		prefix + "GetReasons",
		prefix + "GetSuspensionGuide",
		prefix + "CreateReport",
		prefix + "CreateSuspension",
		prefix + "CreateShift",
		prefix + "ModifyShift",
		prefix + "DeleteShift",
		prefix + "GetShifts",
		prefix + "GetRoutedReports",
		prefix + "CreateEnforcement",
		prefix + "CreatePartnershipsNotification",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &gatewayProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &gatewayProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *gatewayProtobufClient) GetAllReasons(ctx context.Context, in *GetAllReasonsRequest) (*GetReasonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllReasons")
	out := new(GetReasonsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) GetReasons(ctx context.Context, in *GetReasonsRequest) (*GetReasonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetReasons")
	out := new(GetReasonsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) GetSuspensionGuide(ctx context.Context, in *GetSuspensionGuideRequest) (*GetSuspensionGuideResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetSuspensionGuide")
	out := new(GetSuspensionGuideResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) CreateReport(ctx context.Context, in *CreateReportRequest) (*CreateReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateReport")
	out := new(CreateReportResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) CreateSuspension(ctx context.Context, in *CreateSuspensionRequest) (*CreateSuspensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSuspension")
	out := new(CreateSuspensionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) CreateShift(ctx context.Context, in *CreateShiftRequest) (*CreateShiftResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateShift")
	out := new(CreateShiftResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) ModifyShift(ctx context.Context, in *ModifyShiftRequest) (*ModifyShiftResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "ModifyShift")
	out := new(ModifyShiftResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) DeleteShift(ctx context.Context, in *DeleteShiftRequest) (*DeleteShiftResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteShift")
	out := new(DeleteShiftResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) GetShifts(ctx context.Context, in *GetShiftsRequest) (*GetShiftsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetShifts")
	out := new(GetShiftsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) GetRoutedReports(ctx context.Context, in *GetRoutedReportsRequest) (*GetRoutedReportsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoutedReports")
	out := new(GetRoutedReportsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) CreateEnforcement(ctx context.Context, in *CreateEnforcementRequest) (*CreateEnforcementResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEnforcement")
	out := new(CreateEnforcementResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayProtobufClient) CreatePartnershipsNotification(ctx context.Context, in *CreatePartnershipsNotificationRequest) (*CreatePartnershipsNotificationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreatePartnershipsNotification")
	out := new(CreatePartnershipsNotificationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===================
// Gateway JSON Client
// ===================

type gatewayJSONClient struct {
	client HTTPClient
	urls   [12]string
}

// NewGatewayJSONClient creates a JSON client that implements the Gateway interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewGatewayJSONClient(addr string, client HTTPClient) Gateway {
	prefix := urlBase(addr) + GatewayPathPrefix
	urls := [12]string{
		prefix + "GetAllReasons",
		prefix + "GetReasons",
		prefix + "GetSuspensionGuide",
		prefix + "CreateReport",
		prefix + "CreateSuspension",
		prefix + "CreateShift",
		prefix + "ModifyShift",
		prefix + "DeleteShift",
		prefix + "GetShifts",
		prefix + "GetRoutedReports",
		prefix + "CreateEnforcement",
		prefix + "CreatePartnershipsNotification",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &gatewayJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &gatewayJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *gatewayJSONClient) GetAllReasons(ctx context.Context, in *GetAllReasonsRequest) (*GetReasonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllReasons")
	out := new(GetReasonsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) GetReasons(ctx context.Context, in *GetReasonsRequest) (*GetReasonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetReasons")
	out := new(GetReasonsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) GetSuspensionGuide(ctx context.Context, in *GetSuspensionGuideRequest) (*GetSuspensionGuideResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetSuspensionGuide")
	out := new(GetSuspensionGuideResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) CreateReport(ctx context.Context, in *CreateReportRequest) (*CreateReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateReport")
	out := new(CreateReportResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) CreateSuspension(ctx context.Context, in *CreateSuspensionRequest) (*CreateSuspensionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSuspension")
	out := new(CreateSuspensionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) CreateShift(ctx context.Context, in *CreateShiftRequest) (*CreateShiftResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateShift")
	out := new(CreateShiftResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) ModifyShift(ctx context.Context, in *ModifyShiftRequest) (*ModifyShiftResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "ModifyShift")
	out := new(ModifyShiftResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) DeleteShift(ctx context.Context, in *DeleteShiftRequest) (*DeleteShiftResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteShift")
	out := new(DeleteShiftResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) GetShifts(ctx context.Context, in *GetShiftsRequest) (*GetShiftsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetShifts")
	out := new(GetShiftsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) GetRoutedReports(ctx context.Context, in *GetRoutedReportsRequest) (*GetRoutedReportsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoutedReports")
	out := new(GetRoutedReportsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) CreateEnforcement(ctx context.Context, in *CreateEnforcementRequest) (*CreateEnforcementResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEnforcement")
	out := new(CreateEnforcementResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayJSONClient) CreatePartnershipsNotification(ctx context.Context, in *CreatePartnershipsNotificationRequest) (*CreatePartnershipsNotificationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithMethodName(ctx, "CreatePartnershipsNotification")
	out := new(CreatePartnershipsNotificationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ======================
// Gateway Server Handler
// ======================

type gatewayServer struct {
	Gateway
	hooks *twirp.ServerHooks
}

func NewGatewayServer(svc Gateway, hooks *twirp.ServerHooks) TwirpServer {
	return &gatewayServer{
		Gateway: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *gatewayServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// GatewayPathPrefix is used for all URL paths on a twirp Gateway server.
// Requests are always: POST GatewayPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const GatewayPathPrefix = "/twirp/code.justin.tv.safety.gateway.Gateway/"

func (s *gatewayServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.safety.gateway")
	ctx = ctxsetters.WithServiceName(ctx, "Gateway")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.safety.gateway.Gateway/GetAllReasons":
		s.serveGetAllReasons(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/GetReasons":
		s.serveGetReasons(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/GetSuspensionGuide":
		s.serveGetSuspensionGuide(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/CreateReport":
		s.serveCreateReport(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/CreateSuspension":
		s.serveCreateSuspension(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/CreateShift":
		s.serveCreateShift(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/ModifyShift":
		s.serveModifyShift(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/DeleteShift":
		s.serveDeleteShift(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/GetShifts":
		s.serveGetShifts(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/GetRoutedReports":
		s.serveGetRoutedReports(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/CreateEnforcement":
		s.serveCreateEnforcement(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.safety.gateway.Gateway/CreatePartnershipsNotification":
		s.serveCreatePartnershipsNotification(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *gatewayServer) serveGetAllReasons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllReasonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllReasonsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveGetAllReasonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllReasons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllReasonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetReasonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetAllReasons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetReasonsResponse and nil error while calling GetAllReasons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetAllReasonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllReasons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllReasonsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetReasonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetAllReasons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetReasonsResponse and nil error while calling GetAllReasons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetReasons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetReasonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetReasonsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveGetReasonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetReasons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetReasonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetReasonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetReasons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetReasonsResponse and nil error while calling GetReasons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetReasonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetReasons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetReasonsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetReasonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetReasons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetReasonsResponse and nil error while calling GetReasons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetSuspensionGuide(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSuspensionGuideJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSuspensionGuideProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveGetSuspensionGuideJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSuspensionGuide")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSuspensionGuideRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSuspensionGuideResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetSuspensionGuide(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSuspensionGuideResponse and nil error while calling GetSuspensionGuide. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetSuspensionGuideProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSuspensionGuide")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSuspensionGuideRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSuspensionGuideResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetSuspensionGuide(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSuspensionGuideResponse and nil error while calling GetSuspensionGuide. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveCreateReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateReportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateReportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateReportResponse and nil error while calling CreateReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateReportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateReportResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateReportResponse and nil error while calling CreateReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateSuspension(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSuspensionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSuspensionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveCreateSuspensionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSuspension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateSuspensionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSuspensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateSuspension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSuspensionResponse and nil error while calling CreateSuspension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateSuspensionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSuspension")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateSuspensionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSuspensionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateSuspension(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSuspensionResponse and nil error while calling CreateSuspension. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateShift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateShiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateShiftProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveCreateShiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateShift")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateShiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateShiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateShift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateShiftResponse and nil error while calling CreateShift. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateShiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateShift")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateShiftRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateShiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateShift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateShiftResponse and nil error while calling CreateShift. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveModifyShift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveModifyShiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveModifyShiftProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveModifyShiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ModifyShift")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ModifyShiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ModifyShiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.ModifyShift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ModifyShiftResponse and nil error while calling ModifyShift. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveModifyShiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ModifyShift")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ModifyShiftRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ModifyShiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.ModifyShift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ModifyShiftResponse and nil error while calling ModifyShift. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveDeleteShift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteShiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteShiftProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveDeleteShiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteShift")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteShiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteShiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.DeleteShift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteShiftResponse and nil error while calling DeleteShift. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveDeleteShiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteShift")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteShiftRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteShiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.DeleteShift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteShiftResponse and nil error while calling DeleteShift. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetShifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetShiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetShiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveGetShiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetShifts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetShiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetShiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetShifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetShiftsResponse and nil error while calling GetShifts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetShiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetShifts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetShiftsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetShiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetShifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetShiftsResponse and nil error while calling GetShifts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetRoutedReports(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRoutedReportsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRoutedReportsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveGetRoutedReportsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoutedReports")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRoutedReportsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRoutedReportsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetRoutedReports(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRoutedReportsResponse and nil error while calling GetRoutedReports. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveGetRoutedReportsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoutedReports")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRoutedReportsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRoutedReportsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.GetRoutedReports(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRoutedReportsResponse and nil error while calling GetRoutedReports. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateEnforcement(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateEnforcementJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEnforcementProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveCreateEnforcementJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEnforcement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateEnforcementRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEnforcementResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateEnforcement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEnforcementResponse and nil error while calling CreateEnforcement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreateEnforcementProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEnforcement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateEnforcementRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEnforcementResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreateEnforcement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEnforcementResponse and nil error while calling CreateEnforcement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreatePartnershipsNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreatePartnershipsNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePartnershipsNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *gatewayServer) serveCreatePartnershipsNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreatePartnershipsNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreatePartnershipsNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePartnershipsNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreatePartnershipsNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePartnershipsNotificationResponse and nil error while calling CreatePartnershipsNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) serveCreatePartnershipsNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreatePartnershipsNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreatePartnershipsNotificationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePartnershipsNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Gateway.CreatePartnershipsNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePartnershipsNotificationResponse and nil error while calling CreatePartnershipsNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *gatewayServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *gatewayServer) ProtocGenTwirpVersion() string {
	return "v5.5.2"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.2")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1578 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdd, 0x6e, 0x1b, 0xc5,
	0x17, 0x97, 0xbd, 0xf5, 0xd7, 0xb1, 0xe3, 0xa4, 0x93, 0x8f, 0x3a, 0xdb, 0x7f, 0xfa, 0x0f, 0xab,
	0xa4, 0x14, 0x10, 0x4e, 0xeb, 0x96, 0x52, 0xaa, 0x82, 0x44, 0x9a, 0x10, 0x19, 0x0a, 0xa2, 0x4b,
	0xcb, 0x05, 0xaa, 0x64, 0x6d, 0xbc, 0x63, 0x77, 0xe8, 0x7a, 0x77, 0xbb, 0x3b, 0x6e, 0x30, 0x57,
	0x48, 0x48, 0x48, 0x5c, 0x72, 0xc7, 0x3b, 0x20, 0x5e, 0x80, 0x0b, 0x5e, 0x01, 0x9e, 0x82, 0x37,
	0xe0, 0x1e, 0xcd, 0xc7, 0xda, 0xb3, 0x1f, 0xce, 0xda, 0x81, 0x2b, 0x7b, 0xce, 0x9c, 0xaf, 0x3d,
	0xe7, 0x77, 0xce, 0x9c, 0x03, 0xdb, 0x81, 0xdf, 0x3f, 0x18, 0x5a, 0x14, 0x9f, 0x59, 0x93, 0xe8,
	0xb7, 0xed, 0x07, 0x1e, 0xf5, 0xd0, 0x4e, 0xdf, 0xb3, 0x71, 0xfb, 0xeb, 0x71, 0x48, 0x89, 0xdb,
	0xa6, 0xaf, 0xda, 0xa1, 0x35, 0xc0, 0x74, 0xd2, 0x96, 0x4c, 0xfa, 0xb5, 0xa1, 0xe7, 0x0d, 0x1d,
	0x7c, 0xc0, 0x99, 0x4f, 0xc7, 0x83, 0x83, 0xb3, 0xc0, 0xf2, 0x7d, 0x1c, 0x84, 0x42, 0x5c, 0xff,
	0x7f, 0xf2, 0x9e, 0x92, 0x11, 0x0e, 0xa9, 0x35, 0xf2, 0x25, 0x43, 0x4a, 0x81, 0x3d, 0x0e, 0x2c,
	0x4a, 0x3c, 0x57, 0xdc, 0x1b, 0x1d, 0xd8, 0x38, 0xc1, 0xf4, 0x43, 0xc7, 0x31, 0xb1, 0x15, 0x7a,
	0x6e, 0x68, 0xe2, 0x97, 0x63, 0x1c, 0x52, 0xa4, 0x43, 0xd5, 0xb1, 0xdc, 0xe1, 0xd8, 0x1a, 0xe2,
	0x56, 0x61, 0xb7, 0x70, 0xa3, 0x66, 0x4e, 0xcf, 0x86, 0x09, 0x97, 0x4f, 0x30, 0x4d, 0x08, 0xbc,
	0x06, 0x8d, 0xbe, 0xe7, 0x52, 0xec, 0xd2, 0x1e, 0x9d, 0xf8, 0x91, 0x50, 0x5d, 0xd2, 0x9e, 0x4c,
	0x7c, 0x1c, 0xd3, 0x59, 0x4c, 0xe8, 0x7c, 0x06, 0x48, 0xd5, 0x19, 0xfa, 0x9e, 0x1b, 0x62, 0xf4,
	0x11, 0x94, 0x03, 0x1c, 0x8e, 0x1d, 0xda, 0x2a, 0xec, 0x6a, 0x37, 0xea, 0x9d, 0x76, 0xfb, 0xdc,
	0x70, 0xb5, 0x1f, 0x79, 0x7d, 0xcb, 0x21, 0xdf, 0x62, 0x5b, 0x28, 0x32, 0xa5, 0xb4, 0x71, 0x15,
	0xb6, 0x4f, 0x30, 0xfd, 0x62, 0x1c, 0xfa, 0xd8, 0x0d, 0x89, 0xe7, 0x9e, 0x8c, 0x89, 0x8d, 0xa5,
	0xe7, 0xc6, 0xdf, 0x05, 0xd0, 0xb3, 0x6e, 0xa5, 0x0f, 0x7d, 0xa8, 0xca, 0x8f, 0x08, 0xa5, 0x17,
	0x27, 0x39, 0x5e, 0xcc, 0x57, 0xd6, 0x7e, 0x28, 0x35, 0x1d, 0xbb, 0x34, 0x98, 0x98, 0x53, 0xc5,
	0x7a, 0x00, 0x2b, 0xb1, 0x2b, 0xb4, 0x06, 0xda, 0x0b, 0x3c, 0x91, 0x51, 0x64, 0x7f, 0xd1, 0x27,
	0x50, 0x7a, 0x65, 0x39, 0x63, 0x11, 0xba, 0x7a, 0xe7, 0x9d, 0x1c, 0x27, 0x12, 0x1e, 0x48, 0xed,
	0xa6, 0xd0, 0x71, 0xbf, 0x78, 0xaf, 0x60, 0xfc, 0x5e, 0x84, 0xf5, 0x87, 0x01, 0xb6, 0x28, 0x36,
	0xb1, 0xef, 0x05, 0x34, 0xca, 0xe4, 0x2e, 0x34, 0x06, 0x81, 0x37, 0xea, 0x8d, 0x43, 0x1c, 0xf4,
	0x88, 0xcd, 0x7d, 0xd0, 0x4c, 0x60, 0xb4, 0xa7, 0x21, 0x0e, 0xba, 0x36, 0xda, 0x83, 0x26, 0xb5,
	0x82, 0x21, 0xa6, 0x53, 0x9e, 0x22, 0xe7, 0x69, 0x08, 0xaa, 0xe4, 0x6a, 0x41, 0x45, 0x7e, 0x5f,
	0x4b, 0xe3, 0x9f, 0x11, 0x1d, 0xd1, 0x16, 0x4b, 0x2b, 0x4b, 0x50, 0xeb, 0x12, 0xbf, 0x90, 0x27,
	0xb4, 0x0b, 0x75, 0x1b, 0x87, 0xfd, 0x80, 0xf8, 0x0c, 0xa1, 0xad, 0x92, 0x80, 0x90, 0x42, 0x42,
	0x3b, 0x00, 0x11, 0xca, 0x88, 0xdd, 0x2a, 0x73, 0x86, 0x9a, 0xa4, 0x74, 0x6d, 0xb4, 0x01, 0x25,
	0xfc, 0x0d, 0x0d, 0xac, 0x56, 0x85, 0xdf, 0x88, 0x03, 0x33, 0xe7, 0x05, 0x64, 0x48, 0xdc, 0x56,
	0x55, 0x98, 0x13, 0x27, 0xf4, 0x01, 0x34, 0x02, 0x3c, 0xc0, 0x01, 0x76, 0xfb, 0x98, 0xa9, 0xab,
	0xf1, 0xc0, 0x5e, 0x6d, 0x8b, 0x92, 0x69, 0x47, 0x25, 0xd3, 0xee, 0xba, 0xf4, 0xee, 0x9d, 0x2f,
	0x59, 0xdc, 0xcc, 0xfa, 0x54, 0xa0, 0x6b, 0x1b, 0xd7, 0x61, 0x23, 0x1e, 0x3f, 0x89, 0x98, 0x26,
	0x14, 0xa7, 0x61, 0x2b, 0x12, 0xdb, 0xf8, 0xb3, 0x08, 0x57, 0x04, 0xe3, 0x2c, 0x29, 0xe7, 0x05,
	0xbb, 0x76, 0x81, 0x60, 0x27, 0x42, 0xa7, 0xa5, 0x43, 0xa7, 0x43, 0x35, 0xaa, 0x7d, 0x1e, 0x76,
	0xcd, 0x9c, 0x9e, 0xd1, 0x26, 0x94, 0x89, 0xdf, 0x3b, 0xb5, 0x44, 0xcc, 0x35, 0xb3, 0x44, 0xfc,
	0x43, 0xcb, 0x45, 0xfb, 0xd0, 0xec, 0x3b, 0xd8, 0x0a, 0xb0, 0xdd, 0x23, 0x23, 0x6b, 0x88, 0x43,
	0x1e, 0xf1, 0xaa, 0xb9, 0x22, 0xa9, 0x5d, 0x4e, 0x54, 0xd2, 0x59, 0x89, 0xa5, 0x53, 0x01, 0x40,
	0x35, 0x0e, 0x80, 0xd7, 0x61, 0xd5, 0xc6, 0xd4, 0x22, 0x0e, 0xb6, 0x7b, 0x52, 0xb4, 0xc6, 0x39,
	0x9a, 0x11, 0x59, 0x14, 0xb0, 0x92, 0x3a, 0x50, 0x53, 0x67, 0xbc, 0x09, 0xad, 0x74, 0x44, 0xe7,
	0x84, 0x7f, 0x00, 0x48, 0xf2, 0x3e, 0x27, 0x83, 0x29, 0xca, 0xb7, 0xa1, 0x6a, 0xd9, 0x23, 0xe2,
	0xce, 0x10, 0x5e, 0xe1, 0xe7, 0xae, 0xcd, 0x40, 0x16, 0x32, 0x56, 0xd1, 0xc8, 0x44, 0xa7, 0xaa,
	0x71, 0x0a, 0x6f, 0x63, 0x5b, 0x50, 0x3e, 0xc3, 0x64, 0xf8, 0x5c, 0xc0, 0x5a, 0x33, 0xe5, 0xc9,
	0x78, 0x1c, 0x95, 0x93, 0xb4, 0x23, 0xdd, 0xb9, 0x0f, 0x25, 0x2e, 0xcb, 0xad, 0xd4, 0x3b, 0x7b,
	0x79, 0x75, 0xcb, 0x85, 0x85, 0x88, 0xf1, 0x00, 0xd0, 0xa7, 0x9e, 0x4d, 0x06, 0x93, 0x98, 0xeb,
	0xb3, 0x0f, 0xac, 0xb1, 0x0f, 0x54, 0x1c, 0x2a, 0x26, 0x1d, 0x8a, 0x49, 0xff, 0x07, 0x0e, 0xed,
	0x01, 0x3a, 0xc2, 0x0e, 0x4e, 0xc4, 0x32, 0xe1, 0x90, 0xb1, 0x09, 0xeb, 0x31, 0x2e, 0x61, 0xd8,
	0x40, 0xb0, 0xc6, 0x5a, 0x23, 0xa3, 0x45, 0xcf, 0x86, 0xf1, 0x98, 0xbf, 0x25, 0x11, 0x4d, 0x7a,
	0xf8, 0x00, 0xca, 0xdc, 0x5c, 0xd4, 0x70, 0x17, 0x73, 0x51, 0xca, 0x18, 0x47, 0x70, 0x85, 0x3d,
	0x25, 0xde, 0x98, 0x32, 0x18, 0xb1, 0xca, 0x0c, 0xe7, 0x45, 0x4e, 0x05, 0x41, 0x31, 0x06, 0x02,
	0xe3, 0x0e, 0xb4, 0xd2, 0x5a, 0xa4, 0x7f, 0x2d, 0xa8, 0x04, 0x82, 0xc4, 0x1d, 0xd4, 0xcc, 0xe8,
	0x68, 0xfc, 0xa6, 0x45, 0xc0, 0x3c, 0x76, 0x07, 0x5e, 0xd0, 0xc7, 0x23, 0xd6, 0x74, 0x17, 0xae,
	0xf5, 0xb7, 0x61, 0x5d, 0xad, 0x75, 0xb5, 0xe0, 0x6b, 0xe6, 0xda, 0xac, 0xe0, 0x25, 0xfb, 0xac,
	0xf0, 0xb4, 0x79, 0x85, 0x77, 0x29, 0xb7, 0xf0, 0x4a, 0x99, 0x85, 0x97, 0xe8, 0x27, 0xe5, 0x74,
	0x3f, 0xf9, 0x1f, 0xd4, 0x7c, 0x1c, 0x8c, 0x2c, 0x97, 0x99, 0xa9, 0xf0, 0xbe, 0x30, 0x23, 0xf0,
	0x1a, 0x7a, 0x41, 0xfc, 0x1e, 0x1e, 0x59, 0xc4, 0xe1, 0xe5, 0x5f, 0x35, 0x6b, 0x8c, 0x72, 0xcc,
	0x08, 0x4a, 0xc3, 0xa9, 0xf1, 0xab, 0xb9, 0x0d, 0x07, 0xb2, 0x1a, 0xce, 0xfb, 0xd0, 0x38, 0xb5,
	0x5c, 0x17, 0xdb, 0xbd, 0xb1, 0x4b, 0x89, 0xd3, 0xaa, 0x73, 0x20, 0xeb, 0xa9, 0xc6, 0xfd, 0x24,
	0x1a, 0x86, 0xcc, 0xba, 0xe0, 0x7f, 0xca, 0xd8, 0x95, 0xa6, 0xd2, 0x88, 0x35, 0x95, 0x11, 0x6c,
	0x67, 0xe4, 0x4e, 0xe6, 0x7c, 0x1f, 0x9a, 0x78, 0x46, 0x9e, 0xa5, 0x6f, 0x45, 0xa1, 0x76, 0x6d,
	0xf4, 0x06, 0xac, 0xa9, 0x6c, 0x4a, 0x07, 0x59, 0x55, 0xe8, 0xac, 0x8f, 0x18, 0x7f, 0x69, 0xb0,
	0x2f, 0xec, 0x7d, 0x6e, 0x05, 0xd4, 0xc5, 0x41, 0xf8, 0x9c, 0xf8, 0xe1, 0x67, 0x1e, 0x25, 0x03,
	0xd2, 0xe7, 0x7d, 0x39, 0x02, 0xce, 0x1e, 0x34, 0x67, 0xc0, 0x71, 0x6c, 0xcb, 0x97, 0xb6, 0x1b,
	0x11, 0x74, 0x1e, 0xd9, 0x96, 0x3f, 0xe7, 0xa1, 0xa8, 0x25, 0x1e, 0x8a, 0x2c, 0x07, 0xb5, 0x4c,
	0x07, 0x59, 0x75, 0xb0, 0x24, 0x39, 0x5e, 0xff, 0x05, 0xc7, 0x51, 0xd5, 0xac, 0x10, 0xff, 0x90,
	0x1d, 0xf9, 0xb4, 0xc7, 0x52, 0x12, 0xa5, 0xa9, 0xc4, 0xaf, 0xeb, 0x9c, 0x96, 0x7a, 0x15, 0xca,
	0xf3, 0xc0, 0x59, 0xc9, 0x05, 0x67, 0x75, 0xde, 0xab, 0x10, 0x52, 0x8b, 0x8e, 0x43, 0xf9, 0x6a,
	0xc8, 0x53, 0x12, 0xb4, 0x90, 0x06, 0x6d, 0x3a, 0x8b, 0x75, 0x5e, 0xf6, 0x89, 0x2c, 0x3e, 0x82,
	0x0d, 0x95, 0x6d, 0xfa, 0x6e, 0x36, 0x38, 0xd0, 0xb6, 0x53, 0x40, 0x3b, 0x92, 0x0c, 0xe6, 0xba,
	0x22, 0x16, 0x11, 0x8d, 0x1b, 0x70, 0x3d, 0x2f, 0xcf, 0xb2, 0x43, 0x8e, 0x60, 0x35, 0x31, 0xc2,
	0xa6, 0x5a, 0xd6, 0x0e, 0x80, 0x4d, 0x42, 0xdf, 0xb1, 0x26, 0x3d, 0xec, 0x46, 0x8f, 0x93, 0xa4,
	0x1c, 0xbb, 0xe8, 0x2d, 0xb8, 0x1c, 0x5d, 0x3b, 0x91, 0x26, 0x99, 0xdf, 0x35, 0x79, 0x31, 0xb5,
	0x60, 0xfc, 0x52, 0x84, 0xad, 0xec, 0x39, 0x51, 0xcd, 0x52, 0x21, 0x95, 0xa5, 0x68, 0x04, 0x93,
	0x0a, 0xa5, 0x17, 0x4d, 0x49, 0x3e, 0x12, 0x54, 0xf4, 0x8c, 0x75, 0x49, 0x3e, 0xcf, 0xb7, 0x34,
	0xde, 0xc6, 0x0f, 0x2f, 0x34, 0xb2, 0xb6, 0xe5, 0x52, 0x20, 0x46, 0xe6, 0x48, 0xa5, 0xee, 0x43,
	0x43, 0xbd, 0xc8, 0x18, 0x98, 0x3f, 0x8e, 0x0f, 0xcc, 0x77, 0x96, 0xb3, 0x2e, 0x37, 0x08, 0x65,
	0x5e, 0xfe, 0xa3, 0x08, 0x9b, 0x99, 0x4c, 0x0a, 0xd4, 0x0b, 0x31, 0xa8, 0xef, 0x43, 0x53, 0xfc,
	0x4b, 0x44, 0x6a, 0x45, 0x50, 0xa3, 0x40, 0x51, 0x58, 0x4b, 0xe0, 0x3e, 0x8a, 0x58, 0xf7, 0x22,
	0x3e, 0xb7, 0x8f, 0x62, 0xd5, 0x22, 0x03, 0xb7, 0x1a, 0xaf, 0xa1, 0x50, 0xff, 0xae, 0x00, 0x1b,
	0x59, 0x9c, 0x19, 0x91, 0x34, 0xe3, 0x91, 0x7c, 0xb0, 0x9c, 0x57, 0x71, 0x23, 0x6a, 0x44, 0x7f,
	0x2e, 0xc0, 0xce, 0xb9, 0xcc, 0x59, 0x2d, 0xa1, 0x90, 0xd9, 0x12, 0xee, 0xc2, 0x95, 0x04, 0x63,
	0x22, 0xe6, 0x9b, 0x71, 0x81, 0x28, 0xf6, 0x5b, 0x50, 0xf6, 0x3d, 0xc2, 0x76, 0x3b, 0x39, 0xcc,
	0x89, 0x93, 0x41, 0xa0, 0xc4, 0xa7, 0x8a, 0x25, 0x46, 0x86, 0xc4, 0xdc, 0xa8, 0xcd, 0x9f, 0x1b,
	0x2f, 0xa9, 0x63, 0x5a, 0xe7, 0xa7, 0x06, 0x54, 0x4e, 0x44, 0xe8, 0xd0, 0x19, 0xac, 0xc4, 0xd6,
	0x71, 0x74, 0x3b, 0x7f, 0xd7, 0x4c, 0x2d, 0xef, 0xfa, 0xad, 0x7c, 0xa1, 0xe4, 0xa6, 0xfd, 0x12,
	0x60, 0x46, 0x45, 0x37, 0x97, 0x50, 0x70, 0x61, 0x93, 0x3f, 0x16, 0xf8, 0xce, 0x9f, 0x00, 0x00,
	0xba, 0x77, 0x81, 0xed, 0x5a, 0xf8, 0xf0, 0xde, 0x85, 0xf7, 0x72, 0x74, 0x06, 0x0d, 0x75, 0x95,
	0x43, 0x9d, 0x1c, 0x55, 0x19, 0x7b, 0xb3, 0x7e, 0x7b, 0x29, 0x19, 0x69, 0xf8, 0xfb, 0x02, 0xac,
	0x25, 0x37, 0x19, 0x74, 0x77, 0x21, 0x4d, 0xa9, 0x65, 0x52, 0x7f, 0x77, 0x69, 0x39, 0xe9, 0x05,
	0x85, 0xba, 0xb2, 0xba, 0xa0, 0x5b, 0x8b, 0xe9, 0x51, 0x56, 0x00, 0xbd, 0xb3, 0x8c, 0xc8, 0xcc,
	0xaa, 0xb2, 0x9f, 0xe4, 0x5a, 0x4d, 0x6f, 0x42, 0xb9, 0x56, 0xb3, 0xd6, 0x1f, 0x0a, 0x75, 0x65,
	0x39, 0xc9, 0xb5, 0x9a, 0x5e, 0x77, 0x72, 0xad, 0x66, 0xec, 0x3e, 0xc8, 0x85, 0xda, 0x74, 0xcf,
	0x41, 0x07, 0x0b, 0x00, 0x55, 0xdd, 0x92, 0xf4, 0x9b, 0x8b, 0x0b, 0x28, 0xb8, 0x4a, 0xee, 0x2f,
	0xb9, 0xb8, 0x9a, 0xb3, 0x36, 0xe5, 0xe2, 0x6a, 0xee, 0xa2, 0xf4, 0x43, 0x01, 0x2e, 0xa7, 0x46,
	0x6a, 0xb4, 0x18, 0x4c, 0xd3, 0x0b, 0x94, 0x7e, 0x6f, 0x79, 0x41, 0xe9, 0xc8, 0xaf, 0x05, 0xb8,
	0x76, 0xfe, 0x0c, 0x86, 0x8e, 0x16, 0x52, 0x9e, 0x33, 0xaa, 0xeb, 0xc7, 0xff, 0x52, 0x8b, 0xf0,
	0xf7, 0xb0, 0xf6, 0x55, 0x45, 0x4a, 0x9c, 0x96, 0xf9, 0x94, 0x79, 0xfb, 0x9f, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x94, 0x47, 0x3f, 0x81, 0x45, 0x16, 0x00, 0x00,
}
