package middleware

import (
	"net/http"

	"github.com/a-h/hsts"
)

// HSTS Wraps github.com/a-h/hsts so we can use it as a goji middleware
func HSTS(hostname string) func(http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		hstsHandler := hsts.NewHandler(h)
		hstsHandler.HostOverride = hostname
		hstsHandler.SendPreloadDirective = true
		return hstsHandler
	}
}
