package middleware

import (
	"fmt"
	"math/rand"
	"net/http"

	"code.justin.tv/chat/golibs/logx"
)

// RequestID returns a middleware that genereates a unique ID
// for each request and stores it as a logx field in the context.
// This makes it easy to find all log lines for a specific request.
func RequestID(inner http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		requestID := fmt.Sprintf("%08x", rand.Uint32())
		r = r.WithContext(logx.WithFields(r.Context(), logx.Fields{
			"request_id": requestID,
		}))

		inner.ServeHTTP(w, r)
	})
}
