package middleware

import (
	"net/http"
)

// XFrameOptionValue is a value for X-Frame-Options header
type XFrameOptionValue string

// List of constant xframe options
const (
	XFrameOptionsDeny       = XFrameOptionValue("deny")
	XFrameOptionsSameOrigin = XFrameOptionValue("sameorigin")
)

// XFrameOptions adds the X-Frame-Options header to response with supplied value
// XFrameOptions is used to avoid clickjacking attacks
// For more see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options
// and https://www.owasp.org/index.php/Clickjacking_Defense_Cheat_Sheet#X-Frame-Options_Header_Types
func XFrameOptions(value XFrameOptionValue) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			w.Header().Set("X-Frame-Options", string(value))

			inner.ServeHTTP(w, r)
		})
	}
}
