package internal

import (
	"fmt"
	"strings"
	"time"

	"code.justin.tv/common/config"

	"github.com/cactus/go-statsd-client/statsd"
)

type dogstatsdSender struct {
	sender statsd.Sender
	suffix string
}

func newDogstatsdSender(hostPort string) (statsd.Sender, error) {
	sender, err := statsd.NewBufferedSender(hostPort, time.Second, 1432)
	if err != nil {
		return nil, err
	}

	org := "safety"
	app := config.App()
	env := config.Environment()

	suffix := fmt.Sprintf("|#org:%s,app:%s,env:%s", org, app, env)

	return dogstatsdSender{
		sender: sender,
		suffix: suffix,
	}, nil
}

func (s dogstatsdSender) Send(data []byte) (int, error) {
	datadogPayload := fmt.Sprintf("%s%s", data, s.suffix)
	return s.sender.Send([]byte(datadogPayload))
}

func (s dogstatsdSender) Close() error {
	return s.sender.Close()
}

func (s dogstatsdSender) withTags(tags map[string]string) dogstatsdSender {
	allTags := []string{s.suffix}
	for key, value := range tags {
		allTags = append(allTags, fmt.Sprintf("%s:%s", key, value))
	}

	return dogstatsdSender{
		sender: s.sender,
		suffix: strings.Join(allTags, ","),
	}
}
