package internal

import "regexp"

var invalidStatRegexp = regexp.MustCompile(`[^A-Za-z0-9-]+`)

// Sanitize returns a string that contains only valid characters
// to be used as metric names for statsd and dogstatsd protocols
func Sanitize(s string) string {
	return invalidStatRegexp.ReplaceAllString(s, "_")
}
