package internal

import (
	"fmt"
	"time"

	"code.justin.tv/common/config"

	"github.com/cactus/go-statsd-client/statsd"
)

type statsdSender struct {
	sender statsd.Sender
	prefix string
}

func newStatsdSender(hostPort string) (statsd.Sender, error) {
	// bare statsd uses defaults recommended on cacturs/go-statsd-client
	sender, err := statsd.NewBufferedSender(hostPort, time.Second, 1432)
	if err != nil {
		return nil, err
	}

	org := "safety"
	app := config.App()
	env := config.Environment()
	host := sanitizedHostname()

	prefix := fmt.Sprintf("%s.%s.%s.%s.", org, app, env, host)

	return statsdSender{
		sender: sender,
		prefix: prefix,
	}, nil
}

func (s statsdSender) Send(data []byte) (int, error) {
	statsdPayload := fmt.Sprintf("%s%s", s.prefix, data)
	return s.sender.Send([]byte(statsdPayload))
}

func (s statsdSender) Close() error {
	return s.sender.Close()
}
