package multistatter

import (
	"code.justin.tv/safety/multistatter/internal"

	"github.com/cactus/go-statsd-client/statsd"
)

// New creates a new MultiStatter that implements the necessary logic to
// send payloads to several different endpoints (twitch internal statd service,
// datadog agent and signalfx agent by default) using two different protocols (statsd and dogstatsd)
func New() (statsd.Statter, error) {
	multistat, err := internal.New()
	return internal.AsStatsdStatter(multistat), err
}
