// Code generated by protoc-gen-twirp v5.5.0, DO NOT EDIT.
// source: meepo.proto

/*
Package meepo is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.0.

It is generated from these files:
	meepo.proto
	models.proto
*/
package meepo

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ===============
// Meepo Interface
// ===============

// Meepo supports squad streaming on Twitch.
type Meepo interface {
	// GetSquadByChannelID returns the squad the given channel belongs to, if
	// they belong to one.
	GetSquadByChannelID(context.Context, *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error)

	// GetSquadByID returns the squad with the given ID.
	GetSquadByID(context.Context, *GetSquadByIDRequest) (*GetSquadByIDResponse, error)

	// CreateMembership sets a user as a member of a squad.
	CreateMembership(context.Context, *CreateMembershipRequest) (*CreateMembershipResponse, error)

	// UpdateSquad updates the squad with the given information and returns the
	// squad.
	UpdateSquad(context.Context, *UpdateSquadRequest) (*UpdateSquadResponse, error)

	// LeaveSquad deletes the user from the squad they are in, and updates the
	// owner and status of the squad if necessary.
	LeaveSquad(context.Context, *LeaveSquadRequest) (*LeaveSquadResponse, error)

	// RemoveMember removes a user from a squad, and updates the owner and
	// status of the squad if necessary.
	RemoveMember(context.Context, *RemoveMemberRequest) (*RemoveMemberResponse, error)

	// CreateInvitation creates an invitation from the sender to the recipient,
	// creating the squad if necessary.
	CreateInvitation(context.Context, *CreateInvitationRequest) (*CreateInvitationResponse, error)

	// GetIncomingInvitationsByChannelID returns a list of pending invitations
	// to the channel.
	GetIncomingInvitationsByChannelID(context.Context, *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error)

	// CreateSquad creates a pending squad with the given channel as the owner.
	CreateSquad(context.Context, *CreateSquadRequest) (*CreateSquadResponse, error)

	// GetInvitationsBySquadID returns a list of invitations to the squad with
	// the given ID and status.
	GetInvitationsBySquadID(context.Context, *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error)

	// AcceptInvitation accepts an invitation and makes the recipient of the
	// invitation a member of the squad.
	AcceptInvitation(context.Context, *AcceptInvitationRequest) (*AcceptInvitationResponse, error)

	// DeleteInvitation updates invitation status to deleted and
	// returns the deleted invitation.
	DeleteInvitation(context.Context, *DeleteInvitationRequest) (*DeleteInvitationResponse, error)

	// AuthorizeTopicSubscription determines whether the caller
	// is authorized to subscribe to a PubSub topic.
	AuthorizeTopicSubscription(context.Context, *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error)

	// RejectInvitation updates invitation status to rejected,
	// and ensures that a max number of rejected invitations is respected.
	// Returns the rejected invitation.
	RejectInvitation(context.Context, *RejectInvitationRequest) (*RejectInvitationResponse, error)

	// GetIncomingInvitationsCountByChannelID gets the number of incoming,
	// pending invitations for a channel.
	GetIncomingInvitationsCountByChannelID(context.Context, *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error)

	// SetPrimaryPlayer sets the primary player channel ID for a device & squad
	// pair.
	SetPrimaryPlayer(context.Context, *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error)

	// ShouldShowAd determines whether the ad should be declined.
	ShouldShowAd(context.Context, *ShouldShowAdRequest) (*ShouldShowAdResponse, error)

	// RejectOutOfNetworkInvitations updates a user's out-of-network invitations
	// to rejected, and ensures that a max number of rejected invitations is
	// respected.
	RejectOutOfNetworkInvitations(context.Context, *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error)

	// CanAccessSquads determines whether a user can access squad management
	// features such as inviting members to a squad and viewing the squad
	// stream dashboard widget.
	CanAccessSquads(context.Context, *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error)

	GetInvitePolicyByChannelID(context.Context, *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error)

	UpdateInvitePolicyByChannelID(context.Context, *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error)
}

// =====================
// Meepo Protobuf Client
// =====================

type meepoProtobufClient struct {
	client HTTPClient
	urls   [21]string
}

// NewMeepoProtobufClient creates a Protobuf client that implements the Meepo interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMeepoProtobufClient(addr string, client HTTPClient) Meepo {
	prefix := urlBase(addr) + MeepoPathPrefix
	urls := [21]string{
		prefix + "GetSquadByChannelID",
		prefix + "GetSquadByID",
		prefix + "CreateMembership",
		prefix + "UpdateSquad",
		prefix + "LeaveSquad",
		prefix + "RemoveMember",
		prefix + "CreateInvitation",
		prefix + "GetIncomingInvitationsByChannelID",
		prefix + "CreateSquad",
		prefix + "GetInvitationsBySquadID",
		prefix + "AcceptInvitation",
		prefix + "DeleteInvitation",
		prefix + "AuthorizeTopicSubscription",
		prefix + "RejectInvitation",
		prefix + "GetIncomingInvitationsCountByChannelID",
		prefix + "SetPrimaryPlayer",
		prefix + "ShouldShowAd",
		prefix + "RejectOutOfNetworkInvitations",
		prefix + "CanAccessSquads",
		prefix + "GetInvitePolicyByChannelID",
		prefix + "UpdateInvitePolicyByChannelID",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &meepoProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &meepoProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *meepoProtobufClient) GetSquadByChannelID(ctx context.Context, in *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	out := new(GetSquadByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) GetSquadByID(ctx context.Context, in *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	out := new(GetSquadByIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) CreateMembership(ctx context.Context, in *CreateMembershipRequest) (*CreateMembershipResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	out := new(CreateMembershipResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) UpdateSquad(ctx context.Context, in *UpdateSquadRequest) (*UpdateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	out := new(UpdateSquadResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) LeaveSquad(ctx context.Context, in *LeaveSquadRequest) (*LeaveSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	out := new(LeaveSquadResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) RemoveMember(ctx context.Context, in *RemoveMemberRequest) (*RemoveMemberResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	out := new(RemoveMemberResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) CreateInvitation(ctx context.Context, in *CreateInvitationRequest) (*CreateInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	out := new(CreateInvitationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) GetIncomingInvitationsByChannelID(ctx context.Context, in *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	out := new(GetIncomingInvitationsByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) CreateSquad(ctx context.Context, in *CreateSquadRequest) (*CreateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	out := new(CreateSquadResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) GetInvitationsBySquadID(ctx context.Context, in *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	out := new(GetInvitationsBySquadIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) AcceptInvitation(ctx context.Context, in *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	out := new(AcceptInvitationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) DeleteInvitation(ctx context.Context, in *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	out := new(DeleteInvitationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) AuthorizeTopicSubscription(ctx context.Context, in *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	out := new(AuthorizeTopicSubscriptionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) RejectInvitation(ctx context.Context, in *RejectInvitationRequest) (*RejectInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	out := new(RejectInvitationResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) GetIncomingInvitationsCountByChannelID(ctx context.Context, in *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	out := new(GetIncomingInvitationsCountByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) SetPrimaryPlayer(ctx context.Context, in *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	out := new(SetPrimaryPlayerResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) ShouldShowAd(ctx context.Context, in *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	out := new(ShouldShowAdResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) RejectOutOfNetworkInvitations(ctx context.Context, in *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	out := new(RejectOutOfNetworkInvitationsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) CanAccessSquads(ctx context.Context, in *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	out := new(CanAccessSquadsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) GetInvitePolicyByChannelID(ctx context.Context, in *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	out := new(GetInvitePolicyByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoProtobufClient) UpdateInvitePolicyByChannelID(ctx context.Context, in *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	out := new(UpdateInvitePolicyByChannelIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =================
// Meepo JSON Client
// =================

type meepoJSONClient struct {
	client HTTPClient
	urls   [21]string
}

// NewMeepoJSONClient creates a JSON client that implements the Meepo interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMeepoJSONClient(addr string, client HTTPClient) Meepo {
	prefix := urlBase(addr) + MeepoPathPrefix
	urls := [21]string{
		prefix + "GetSquadByChannelID",
		prefix + "GetSquadByID",
		prefix + "CreateMembership",
		prefix + "UpdateSquad",
		prefix + "LeaveSquad",
		prefix + "RemoveMember",
		prefix + "CreateInvitation",
		prefix + "GetIncomingInvitationsByChannelID",
		prefix + "CreateSquad",
		prefix + "GetInvitationsBySquadID",
		prefix + "AcceptInvitation",
		prefix + "DeleteInvitation",
		prefix + "AuthorizeTopicSubscription",
		prefix + "RejectInvitation",
		prefix + "GetIncomingInvitationsCountByChannelID",
		prefix + "SetPrimaryPlayer",
		prefix + "ShouldShowAd",
		prefix + "RejectOutOfNetworkInvitations",
		prefix + "CanAccessSquads",
		prefix + "GetInvitePolicyByChannelID",
		prefix + "UpdateInvitePolicyByChannelID",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &meepoJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &meepoJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *meepoJSONClient) GetSquadByChannelID(ctx context.Context, in *GetSquadByChannelIDRequest) (*GetSquadByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	out := new(GetSquadByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) GetSquadByID(ctx context.Context, in *GetSquadByIDRequest) (*GetSquadByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	out := new(GetSquadByIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) CreateMembership(ctx context.Context, in *CreateMembershipRequest) (*CreateMembershipResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	out := new(CreateMembershipResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) UpdateSquad(ctx context.Context, in *UpdateSquadRequest) (*UpdateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	out := new(UpdateSquadResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) LeaveSquad(ctx context.Context, in *LeaveSquadRequest) (*LeaveSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	out := new(LeaveSquadResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) RemoveMember(ctx context.Context, in *RemoveMemberRequest) (*RemoveMemberResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	out := new(RemoveMemberResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) CreateInvitation(ctx context.Context, in *CreateInvitationRequest) (*CreateInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	out := new(CreateInvitationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) GetIncomingInvitationsByChannelID(ctx context.Context, in *GetIncomingInvitationsByChannelIDRequest) (*GetIncomingInvitationsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	out := new(GetIncomingInvitationsByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) CreateSquad(ctx context.Context, in *CreateSquadRequest) (*CreateSquadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	out := new(CreateSquadResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) GetInvitationsBySquadID(ctx context.Context, in *GetInvitationsBySquadIDRequest) (*GetInvitationsBySquadIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	out := new(GetInvitationsBySquadIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) AcceptInvitation(ctx context.Context, in *AcceptInvitationRequest) (*AcceptInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	out := new(AcceptInvitationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) DeleteInvitation(ctx context.Context, in *DeleteInvitationRequest) (*DeleteInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	out := new(DeleteInvitationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) AuthorizeTopicSubscription(ctx context.Context, in *AuthorizeTopicSubscriptionRequest) (*AuthorizeTopicSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	out := new(AuthorizeTopicSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) RejectInvitation(ctx context.Context, in *RejectInvitationRequest) (*RejectInvitationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	out := new(RejectInvitationResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) GetIncomingInvitationsCountByChannelID(ctx context.Context, in *GetIncomingInvitationsCountByChannelIDRequest) (*GetIncomingInvitationsCountByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	out := new(GetIncomingInvitationsCountByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) SetPrimaryPlayer(ctx context.Context, in *SetPrimaryPlayerRequest) (*SetPrimaryPlayerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	out := new(SetPrimaryPlayerResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) ShouldShowAd(ctx context.Context, in *ShouldShowAdRequest) (*ShouldShowAdResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	out := new(ShouldShowAdResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) RejectOutOfNetworkInvitations(ctx context.Context, in *RejectOutOfNetworkInvitationsRequest) (*RejectOutOfNetworkInvitationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	out := new(RejectOutOfNetworkInvitationsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) CanAccessSquads(ctx context.Context, in *CanAccessSquadsRequest) (*CanAccessSquadsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	out := new(CanAccessSquadsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) GetInvitePolicyByChannelID(ctx context.Context, in *GetInvitePolicyByChannelIDRequest) (*GetInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	out := new(GetInvitePolicyByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *meepoJSONClient) UpdateInvitePolicyByChannelID(ctx context.Context, in *UpdateInvitePolicyByChannelIDRequest) (*UpdateInvitePolicyByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	out := new(UpdateInvitePolicyByChannelIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================
// Meepo Server Handler
// ====================

type meepoServer struct {
	Meepo
	hooks *twirp.ServerHooks
}

func NewMeepoServer(svc Meepo, hooks *twirp.ServerHooks) TwirpServer {
	return &meepoServer{
		Meepo: svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *meepoServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// MeepoPathPrefix is used for all URL paths on a twirp Meepo server.
// Requests are always: POST MeepoPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MeepoPathPrefix = "/twirp/meepo.v1.Meepo/"

func (s *meepoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "Meepo")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/meepo.v1.Meepo/GetSquadByChannelID":
		s.serveGetSquadByChannelID(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/GetSquadByID":
		s.serveGetSquadByID(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/CreateMembership":
		s.serveCreateMembership(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/UpdateSquad":
		s.serveUpdateSquad(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/LeaveSquad":
		s.serveLeaveSquad(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/RemoveMember":
		s.serveRemoveMember(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/CreateInvitation":
		s.serveCreateInvitation(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/GetIncomingInvitationsByChannelID":
		s.serveGetIncomingInvitationsByChannelID(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/CreateSquad":
		s.serveCreateSquad(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/GetInvitationsBySquadID":
		s.serveGetInvitationsBySquadID(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/AcceptInvitation":
		s.serveAcceptInvitation(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/DeleteInvitation":
		s.serveDeleteInvitation(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/AuthorizeTopicSubscription":
		s.serveAuthorizeTopicSubscription(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/RejectInvitation":
		s.serveRejectInvitation(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/GetIncomingInvitationsCountByChannelID":
		s.serveGetIncomingInvitationsCountByChannelID(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/SetPrimaryPlayer":
		s.serveSetPrimaryPlayer(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/ShouldShowAd":
		s.serveShouldShowAd(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/RejectOutOfNetworkInvitations":
		s.serveRejectOutOfNetworkInvitations(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/CanAccessSquads":
		s.serveCanAccessSquads(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/GetInvitePolicyByChannelID":
		s.serveGetInvitePolicyByChannelID(ctx, resp, req)
		return
	case "/twirp/meepo.v1.Meepo/UpdateInvitePolicyByChannelID":
		s.serveUpdateInvitePolicyByChannelID(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *meepoServer) serveGetSquadByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSquadByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSquadByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetSquadByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSquadByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSquadByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetSquadByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByChannelIDResponse and nil error while calling GetSquadByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetSquadByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSquadByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSquadByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetSquadByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByChannelIDResponse and nil error while calling GetSquadByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetSquadByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSquadByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSquadByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetSquadByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSquadByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSquadByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetSquadByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByIDResponse and nil error while calling GetSquadByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetSquadByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSquadByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSquadByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSquadByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetSquadByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSquadByIDResponse and nil error while calling GetSquadByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateMembership(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateMembershipJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateMembershipProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCreateMembershipJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateMembershipRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateMembershipResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CreateMembership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateMembershipResponse and nil error while calling CreateMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateMembershipProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateMembership")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateMembershipRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateMembershipResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CreateMembership(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateMembershipResponse and nil error while calling CreateMembership. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateSquad(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateSquadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSquadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveUpdateSquadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSquadRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSquadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.UpdateSquad(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSquadResponse and nil error while calling UpdateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateSquadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateSquadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSquadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.UpdateSquad(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSquadResponse and nil error while calling UpdateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveLeaveSquad(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLeaveSquadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLeaveSquadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveLeaveSquadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LeaveSquadRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LeaveSquadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.LeaveSquad(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveSquadResponse and nil error while calling LeaveSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveLeaveSquadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LeaveSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(LeaveSquadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LeaveSquadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.LeaveSquad(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LeaveSquadResponse and nil error while calling LeaveSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRemoveMember(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveMemberJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveMemberProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveRemoveMemberJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveMemberRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveMemberResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.RemoveMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveMemberResponse and nil error while calling RemoveMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRemoveMemberProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveMemberRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveMemberResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.RemoveMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveMemberResponse and nil error while calling RemoveMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCreateInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateInvitationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CreateInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateInvitationResponse and nil error while calling CreateInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CreateInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateInvitationResponse and nil error while calling CreateInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIncomingInvitationsByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIncomingInvitationsByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetIncomingInvitationsByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetIncomingInvitationsByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetIncomingInvitationsByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetIncomingInvitationsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsByChannelIDResponse and nil error while calling GetIncomingInvitationsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetIncomingInvitationsByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetIncomingInvitationsByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetIncomingInvitationsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsByChannelIDResponse and nil error while calling GetIncomingInvitationsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateSquad(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSquadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSquadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCreateSquadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateSquadRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSquadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CreateSquad(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSquadResponse and nil error while calling CreateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCreateSquadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSquad")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateSquadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSquadResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CreateSquad(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSquadResponse and nil error while calling CreateSquad. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitationsBySquadID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetInvitationsBySquadIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetInvitationsBySquadIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetInvitationsBySquadIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetInvitationsBySquadIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInvitationsBySquadIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetInvitationsBySquadID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitationsBySquadIDResponse and nil error while calling GetInvitationsBySquadID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitationsBySquadIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitationsBySquadID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetInvitationsBySquadIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInvitationsBySquadIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetInvitationsBySquadID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitationsBySquadIDResponse and nil error while calling GetInvitationsBySquadID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAcceptInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAcceptInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAcceptInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveAcceptInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AcceptInvitationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AcceptInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.AcceptInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcceptInvitationResponse and nil error while calling AcceptInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAcceptInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AcceptInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AcceptInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AcceptInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.AcceptInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AcceptInvitationResponse and nil error while calling AcceptInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveDeleteInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveDeleteInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteInvitationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.DeleteInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteInvitationResponse and nil error while calling DeleteInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveDeleteInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.DeleteInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteInvitationResponse and nil error while calling DeleteInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAuthorizeTopicSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAuthorizeTopicSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAuthorizeTopicSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveAuthorizeTopicSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AuthorizeTopicSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AuthorizeTopicSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.AuthorizeTopicSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AuthorizeTopicSubscriptionResponse and nil error while calling AuthorizeTopicSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveAuthorizeTopicSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthorizeTopicSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AuthorizeTopicSubscriptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AuthorizeTopicSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.AuthorizeTopicSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AuthorizeTopicSubscriptionResponse and nil error while calling AuthorizeTopicSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectInvitation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRejectInvitationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRejectInvitationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveRejectInvitationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RejectInvitationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RejectInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.RejectInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectInvitationResponse and nil error while calling RejectInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectInvitationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectInvitation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RejectInvitationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RejectInvitationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.RejectInvitation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectInvitationResponse and nil error while calling RejectInvitation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsCountByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIncomingInvitationsCountByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIncomingInvitationsCountByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetIncomingInvitationsCountByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetIncomingInvitationsCountByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetIncomingInvitationsCountByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetIncomingInvitationsCountByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsCountByChannelIDResponse and nil error while calling GetIncomingInvitationsCountByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetIncomingInvitationsCountByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIncomingInvitationsCountByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetIncomingInvitationsCountByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetIncomingInvitationsCountByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetIncomingInvitationsCountByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIncomingInvitationsCountByChannelIDResponse and nil error while calling GetIncomingInvitationsCountByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveSetPrimaryPlayer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetPrimaryPlayerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetPrimaryPlayerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveSetPrimaryPlayerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetPrimaryPlayerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetPrimaryPlayerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.SetPrimaryPlayer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetPrimaryPlayerResponse and nil error while calling SetPrimaryPlayer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveSetPrimaryPlayerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetPrimaryPlayer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetPrimaryPlayerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetPrimaryPlayerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.SetPrimaryPlayer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetPrimaryPlayerResponse and nil error while calling SetPrimaryPlayer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveShouldShowAd(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveShouldShowAdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveShouldShowAdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveShouldShowAdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ShouldShowAdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ShouldShowAdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.ShouldShowAd(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ShouldShowAdResponse and nil error while calling ShouldShowAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveShouldShowAdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ShouldShowAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ShouldShowAdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ShouldShowAdResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.ShouldShowAd(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ShouldShowAdResponse and nil error while calling ShouldShowAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectOutOfNetworkInvitations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRejectOutOfNetworkInvitationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRejectOutOfNetworkInvitationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveRejectOutOfNetworkInvitationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RejectOutOfNetworkInvitationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RejectOutOfNetworkInvitationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.RejectOutOfNetworkInvitations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectOutOfNetworkInvitationsResponse and nil error while calling RejectOutOfNetworkInvitations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveRejectOutOfNetworkInvitationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RejectOutOfNetworkInvitations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RejectOutOfNetworkInvitationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RejectOutOfNetworkInvitationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.RejectOutOfNetworkInvitations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RejectOutOfNetworkInvitationsResponse and nil error while calling RejectOutOfNetworkInvitations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCanAccessSquads(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCanAccessSquadsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanAccessSquadsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveCanAccessSquadsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CanAccessSquadsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanAccessSquadsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CanAccessSquads(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanAccessSquadsResponse and nil error while calling CanAccessSquads. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveCanAccessSquadsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CanAccessSquads")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanAccessSquadsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanAccessSquadsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.CanAccessSquads(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanAccessSquadsResponse and nil error while calling CanAccessSquads. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitePolicyByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetInvitePolicyByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetInvitePolicyByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveGetInvitePolicyByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetInvitePolicyByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInvitePolicyByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetInvitePolicyByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitePolicyByChannelIDResponse and nil error while calling GetInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveGetInvitePolicyByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetInvitePolicyByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInvitePolicyByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.GetInvitePolicyByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInvitePolicyByChannelIDResponse and nil error while calling GetInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateInvitePolicyByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateInvitePolicyByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateInvitePolicyByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *meepoServer) serveUpdateInvitePolicyByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateInvitePolicyByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateInvitePolicyByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.UpdateInvitePolicyByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateInvitePolicyByChannelIDResponse and nil error while calling UpdateInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) serveUpdateInvitePolicyByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateInvitePolicyByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateInvitePolicyByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateInvitePolicyByChannelIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Meepo.UpdateInvitePolicyByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateInvitePolicyByChannelIDResponse and nil error while calling UpdateInvitePolicyByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *meepoServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *meepoServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =======================
// InternalMeepo Interface
// =======================

type InternalMeepo interface {
	// LivecheckChannels checks all active memberships whether they are still
	// live, and removes memberships that are not live.
	LivecheckChannels(context.Context, *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error)
}

// =============================
// InternalMeepo Protobuf Client
// =============================

type internalMeepoProtobufClient struct {
	client HTTPClient
	urls   [1]string
}

// NewInternalMeepoProtobufClient creates a Protobuf client that implements the InternalMeepo interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewInternalMeepoProtobufClient(addr string, client HTTPClient) InternalMeepo {
	prefix := urlBase(addr) + InternalMeepoPathPrefix
	urls := [1]string{
		prefix + "LivecheckChannels",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &internalMeepoProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &internalMeepoProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *internalMeepoProtobufClient) LivecheckChannels(ctx context.Context, in *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	out := new(LivecheckChannelsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =========================
// InternalMeepo JSON Client
// =========================

type internalMeepoJSONClient struct {
	client HTTPClient
	urls   [1]string
}

// NewInternalMeepoJSONClient creates a JSON client that implements the InternalMeepo interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewInternalMeepoJSONClient(addr string, client HTTPClient) InternalMeepo {
	prefix := urlBase(addr) + InternalMeepoPathPrefix
	urls := [1]string{
		prefix + "LivecheckChannels",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &internalMeepoJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &internalMeepoJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *internalMeepoJSONClient) LivecheckChannels(ctx context.Context, in *LivecheckChannelsRequest) (*LivecheckChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	out := new(LivecheckChannelsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ============================
// InternalMeepo Server Handler
// ============================

type internalMeepoServer struct {
	InternalMeepo
	hooks *twirp.ServerHooks
}

func NewInternalMeepoServer(svc InternalMeepo, hooks *twirp.ServerHooks) TwirpServer {
	return &internalMeepoServer{
		InternalMeepo: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *internalMeepoServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// InternalMeepoPathPrefix is used for all URL paths on a twirp InternalMeepo server.
// Requests are always: POST InternalMeepoPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const InternalMeepoPathPrefix = "/twirp/meepo.v1.InternalMeepo/"

func (s *internalMeepoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "meepo.v1")
	ctx = ctxsetters.WithServiceName(ctx, "InternalMeepo")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/meepo.v1.InternalMeepo/LivecheckChannels":
		s.serveLivecheckChannels(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *internalMeepoServer) serveLivecheckChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveLivecheckChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveLivecheckChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *internalMeepoServer) serveLivecheckChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(LivecheckChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LivecheckChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InternalMeepo.LivecheckChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LivecheckChannelsResponse and nil error while calling LivecheckChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) serveLivecheckChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "LivecheckChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(LivecheckChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *LivecheckChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InternalMeepo.LivecheckChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LivecheckChannelsResponse and nil error while calling LivecheckChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *internalMeepoServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *internalMeepoServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1492 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xdd, 0x72, 0xd3, 0x46,
	0x14, 0x46, 0x71, 0x93, 0x38, 0xc7, 0x26, 0x84, 0x4d, 0x06, 0x27, 0x0a, 0xa1, 0x44, 0x24, 0x6d,
	0x68, 0xc1, 0x69, 0x93, 0x4e, 0x69, 0x07, 0xb8, 0x08, 0x09, 0xa5, 0x6a, 0x13, 0xe2, 0x91, 0x81,
	0x99, 0x94, 0xce, 0x78, 0x14, 0x69, 0xc1, 0x02, 0x5b, 0x52, 0xa4, 0xb5, 0x3d, 0xe9, 0x55, 0x1f,
	0x80, 0x3e, 0x41, 0x5f, 0xa1, 0x0f, 0xd2, 0xfb, 0xbe, 0x50, 0xc7, 0xbb, 0x6b, 0xef, 0xea, 0xd7,
	0x36, 0x09, 0x57, 0x64, 0x77, 0xcf, 0x9e, 0xf3, 0x7d, 0x67, 0x77, 0x8f, 0xbe, 0x63, 0xa0, 0xd4,
	0xc6, 0xd8, 0xf7, 0xaa, 0x7e, 0xe0, 0x11, 0x0f, 0x15, 0xd9, 0xa0, 0xfb, 0xad, 0x5a, 0x6e, 0x7b,
	0x36, 0x6e, 0x85, 0x6c, 0x5e, 0x7b, 0x08, 0xea, 0x33, 0x4c, 0xea, 0x67, 0x1d, 0xd3, 0x7e, 0x72,
	0xbe, 0xdf, 0x34, 0x5d, 0x17, 0xb7, 0xf4, 0x03, 0x03, 0x9f, 0x75, 0x70, 0x48, 0xd0, 0x1a, 0x80,
	0xc5, 0xe6, 0x1a, 0x8e, 0xbd, 0xac, 0xdc, 0x56, 0xb6, 0xe6, 0x8c, 0x39, 0x3e, 0xa3, 0xdb, 0xda,
	0x01, 0xac, 0xa6, 0x6e, 0x0e, 0x7d, 0xcf, 0x0d, 0x31, 0xda, 0x84, 0xe9, 0xb0, 0xbf, 0x46, 0x37,
	0x96, 0x76, 0xae, 0x55, 0x07, 0x18, 0xaa, 0x74, 0x8b, 0xc1, 0x56, 0xb5, 0x4d, 0x58, 0x14, 0x5e,
	0x44, 0xec, 0x79, 0x98, 0x1a, 0xc6, 0x9c, 0x72, 0x6c, 0xed, 0x31, 0x2c, 0x45, 0xcd, 0x26, 0x8b,
	0xd2, 0x83, 0xca, 0x7e, 0x80, 0x4d, 0x82, 0x8f, 0x70, 0xfb, 0x14, 0x07, 0x61, 0xd3, 0xf1, 0x07,
	0x91, 0x36, 0x60, 0x9e, 0x98, 0xc1, 0x5b, 0x4c, 0x1a, 0x9d, 0x10, 0x07, 0x82, 0x69, 0x99, 0xcd,
	0xbe, 0x0c, 0x71, 0xa0, 0xdb, 0x68, 0x15, 0xe6, 0x2c, 0xb3, 0xd5, 0x62, 0x06, 0x53, 0xd4, 0xa0,
	0xc8, 0x26, 0x74, 0x1b, 0xad, 0x40, 0x91, 0x86, 0xe9, 0xaf, 0x15, 0xe8, 0xda, 0x2c, 0x1d, 0xeb,
	0xb6, 0x76, 0x08, 0xcb, 0xc9, 0xc0, 0x1c, 0xfb, 0x37, 0x00, 0xed, 0xe1, 0x2c, 0x27, 0xb0, 0x20,
	0x08, 0xb0, 0x1d, 0x86, 0x64, 0xa3, 0x9d, 0x01, 0x7a, 0xe9, 0xdb, 0x26, 0xc1, 0x8c, 0x5c, 0x7a,
	0xae, 0x50, 0x15, 0x66, 0x42, 0x62, 0x92, 0x4e, 0x48, 0x81, 0xce, 0xef, 0xdc, 0x88, 0x25, 0xa5,
	0x5a, 0xa7, 0xab, 0x06, 0xb7, 0x8a, 0x72, 0x2b, 0x44, 0xb9, 0x69, 0x8f, 0x60, 0x31, 0x12, 0x72,
	0xb2, 0xbc, 0xff, 0x0a, 0xd7, 0x0f, 0xb1, 0xd9, 0x8d, 0xe2, 0x5d, 0x85, 0x39, 0xc6, 0x49, 0x24,
	0xbb, 0xc8, 0x26, 0x62, 0xb9, 0x9c, 0x8a, 0xe6, 0xf2, 0x21, 0x20, 0xd9, 0xd9, 0x64, 0x48, 0xde,
	0xc1, 0xa2, 0x81, 0xdb, 0x5e, 0x97, 0x1f, 0xc4, 0x58, 0x58, 0x3e, 0xf6, 0xd0, 0x1f, 0xc3, 0x52,
	0x34, 0xd6, 0x64, 0x50, 0x55, 0x58, 0x3e, 0x74, 0xba, 0xd8, 0x6a, 0x62, 0xeb, 0x3d, 0x7f, 0x57,
	0x21, 0xc7, 0xab, 0xad, 0xc2, 0x4a, 0xca, 0x1a, 0xf3, 0xaf, 0x75, 0x07, 0xb7, 0x5c, 0x77, 0xbb,
	0x0e, 0x31, 0x89, 0xe3, 0xb9, 0x12, 0xcf, 0x10, 0xbb, 0x76, 0x84, 0x27, 0x9b, 0xd0, 0x6d, 0xb4,
	0x0e, 0xe5, 0x00, 0x5b, 0x8e, 0xef, 0x60, 0x97, 0x08, 0xaa, 0xa5, 0xe1, 0x5c, 0x3c, 0x15, 0xf1,
	0x3b, 0x52, 0x1b, 0x5c, 0x72, 0x39, 0x2e, 0xe7, 0xfc, 0x1d, 0x80, 0x33, 0x9c, 0xe5, 0xc4, 0x97,
	0x04, 0x71, 0x69, 0x87, 0x64, 0xa7, 0xbd, 0x81, 0xad, 0x67, 0x98, 0xe8, 0xae, 0xe5, 0xb5, 0x1d,
	0xf7, 0xad, 0x30, 0x0a, 0x27, 0x2e, 0x53, 0xb9, 0x87, 0xa8, 0x59, 0x70, 0x77, 0x8c, 0x38, 0x9c,
	0xca, 0xf7, 0x50, 0x12, 0x10, 0xc3, 0x65, 0xe5, 0x76, 0x21, 0x93, 0x8b, 0x6c, 0xa8, 0x1d, 0x02,
	0x62, 0xe9, 0x89, 0xbc, 0x82, 0x15, 0x28, 0x7a, 0x3d, 0x57, 0x3e, 0x90, 0x59, 0x3a, 0x1e, 0x05,
	0xf9, 0x11, 0x2c, 0x46, 0xbc, 0x4d, 0x76, 0xb7, 0xfe, 0x52, 0xe0, 0x16, 0x65, 0x2c, 0x31, 0xa5,
	0x06, 0x22, 0x9f, 0xf2, 0xc5, 0x56, 0x22, 0x17, 0x3b, 0xff, 0x41, 0xec, 0x0e, 0xcb, 0x4e, 0x81,
	0x96, 0x9d, 0xd5, 0xb4, 0xcc, 0xc4, 0x6a, 0x8f, 0x76, 0x02, 0x9f, 0x67, 0xc2, 0xb9, 0x60, 0xda,
	0x5f, 0x43, 0x65, 0xcf, 0xb2, 0xb0, 0x4f, 0x92, 0xaf, 0xe1, 0x0e, 0x5c, 0x15, 0x96, 0x52, 0xc9,
	0x17, 0x93, 0xa3, 0x4e, 0xa1, 0x06, 0xcb, 0x49, 0xe7, 0x17, 0xba, 0xf2, 0xaf, 0xa1, 0x72, 0x80,
	0x5b, 0x38, 0xed, 0xf1, 0x5e, 0x0a, 0xdc, 0xa4, 0xf3, 0x0b, 0xc1, 0x7d, 0x05, 0xeb, 0x7b, 0x1d,
	0xd2, 0xf4, 0x02, 0xe7, 0x0f, 0xfc, 0xc2, 0xf3, 0x1d, 0xab, 0xde, 0x39, 0x0d, 0xad, 0xc0, 0xf1,
	0x65, 0xe0, 0x4b, 0x30, 0x4d, 0xfa, 0x6b, 0x1c, 0x30, 0x1b, 0xe4, 0x23, 0xd5, 0x41, 0xcb, 0xf3,
	0xcb, 0x31, 0xf7, 0x33, 0x12, 0x36, 0xcc, 0x81, 0x21, 0xcb, 0x48, 0xd1, 0x28, 0x3b, 0xe1, 0x70,
	0xb3, 0xdd, 0xcf, 0xa8, 0x81, 0xdf, 0x61, 0xeb, 0x53, 0x5d, 0x80, 0xa4, 0xf3, 0x0b, 0x65, 0xf4,
	0x3d, 0xdc, 0x4f, 0xaf, 0x45, 0xfb, 0x5e, 0xc7, 0x25, 0x97, 0x5c, 0xf8, 0x7e, 0x82, 0xea, 0xb8,
	0xc1, 0x38, 0xa9, 0x25, 0x98, 0xb6, 0xfa, 0x6b, 0x34, 0x50, 0xc1, 0x60, 0x03, 0xed, 0x83, 0x02,
	0x95, 0x3a, 0x26, 0xb5, 0xc0, 0x69, 0x9b, 0xc1, 0x79, 0xad, 0x65, 0x9e, 0x47, 0xbe, 0xad, 0x36,
	0xee, 0x3a, 0x16, 0x96, 0xbe, 0x39, 0x6c, 0x22, 0xf7, 0x3b, 0x8f, 0x7e, 0x84, 0x15, 0x9f, 0xf9,
	0x6b, 0xf8, 0xd4, 0x61, 0x43, 0xa2, 0xc9, 0xbe, 0x3d, 0x37, 0x7c, 0x39, 0xe0, 0xfe, 0x50, 0x93,
	0xbe, 0x84, 0xe5, 0x24, 0x1a, 0x4e, 0x20, 0xd7, 0xad, 0x92, 0xeb, 0xf6, 0xbf, 0x29, 0x58, 0xac,
	0x37, 0xbd, 0x4e, 0xcb, 0xae, 0x37, 0xbd, 0xde, 0xde, 0xb0, 0x86, 0x3f, 0x86, 0x59, 0xd3, 0x6e,
	0x90, 0x73, 0x1f, 0x53, 0x07, 0xf3, 0x3b, 0x1b, 0x52, 0xd9, 0x4d, 0xda, 0x57, 0xf7, 0xec, 0x17,
	0xe7, 0x3e, 0x36, 0x66, 0x4c, 0xfa, 0x6f, 0xec, 0x00, 0xa7, 0x52, 0x0e, 0x50, 0xe4, 0xaf, 0x10,
	0xcb, 0x5f, 0x05, 0x66, 0x07, 0x7a, 0xf5, 0x33, 0xba, 0x34, 0xd3, 0x61, 0x4a, 0x55, 0x87, 0x12,
	0xa7, 0x47, 0x71, 0x4d, 0x53, 0x5c, 0x5b, 0xf9, 0xb8, 0x18, 0x5f, 0x8a, 0x0d, 0xfc, 0xe1, 0xdf,
	0xda, 0x2e, 0xcc, 0x30, 0xc4, 0xa8, 0x0c, 0xc5, 0x9a, 0xf1, 0xb4, 0x61, 0x1c, 0x1f, 0x1e, 0x2e,
	0x5c, 0xe9, 0x8f, 0x8e, 0xf4, 0x03, 0x36, 0x52, 0xd0, 0x55, 0x98, 0xab, 0x1d, 0xd7, 0x5f, 0xb0,
	0xe1, 0x94, 0xb6, 0x05, 0x20, 0xdc, 0xa1, 0x12, 0xcc, 0xd6, 0x0c, 0xfd, 0x68, 0xcf, 0x38, 0x59,
	0xb8, 0xd2, 0xb7, 0xac, 0x3f, 0xdd, 0x3f, 0x7e, 0x7e, 0xd0, 0x1f, 0x2a, 0xda, 0x36, 0x2c, 0x45,
	0xc1, 0xf0, 0x83, 0xaa, 0xc0, 0x6c, 0xd8, 0xf4, 0x7a, 0x0d, 0x73, 0xf0, 0xac, 0x67, 0x42, 0x6a,
	0xa0, 0x9d, 0xc2, 0x06, 0x7b, 0x73, 0xc7, 0x1d, 0x72, 0xfc, 0xe6, 0x39, 0x26, 0x3d, 0x2f, 0x78,
	0x2f, 0xdd, 0xdd, 0xcb, 0x78, 0x18, 0x5f, 0xc2, 0xe6, 0x88, 0x18, 0x5c, 0x6c, 0x3d, 0x80, 0x1b,
	0xfb, 0xa6, 0xdb, 0xff, 0x08, 0x84, 0x21, 0xfd, 0x64, 0x8d, 0x19, 0x5e, 0x7b, 0x0a, 0x95, 0xc4,
	0x46, 0xce, 0xfc, 0x2b, 0xb8, 0x6e, 0x99, 0x6e, 0xc3, 0xa4, 0x6b, 0x0d, 0xfa, 0x1e, 0x42, 0x9e,
	0x83, 0x6b, 0x56, 0x74, 0x8f, 0xd6, 0x80, 0xf5, 0xc1, 0x97, 0x13, 0xd7, 0xbc, 0x96, 0x63, 0x9d,
	0x5f, 0x72, 0x89, 0x70, 0x41, 0xcb, 0x0b, 0xc0, 0x21, 0xff, 0xcc, 0x2b, 0x29, 0x6e, 0xf8, 0xd4,
	0x86, 0x3f, 0x84, 0x3b, 0xb1, 0x72, 0xc7, 0x3d, 0x44, 0x06, 0xbc, 0xdc, 0xf2, 0x91, 0xf6, 0x8f,
	0x02, 0x1b, 0xac, 0xd5, 0xf8, 0x74, 0xa4, 0x92, 0x70, 0x0b, 0x1f, 0x0b, 0xf7, 0x0c, 0x36, 0x47,
	0xa0, 0xbd, 0xec, 0x0c, 0xed, 0xfc, 0xbb, 0x00, 0xd3, 0x47, 0xfd, 0x4d, 0xe8, 0x54, 0xee, 0x9a,
	0x87, 0x21, 0x91, 0x54, 0x7e, 0xb2, 0xfb, 0x7a, 0x75, 0x73, 0x84, 0x15, 0xc7, 0x7d, 0x04, 0x65,
	0xb9, 0xe5, 0x46, 0x6b, 0x69, 0xdb, 0x84, 0xd7, 0x5b, 0x59, 0xcb, 0xdc, 0xdd, 0x09, 0x2c, 0xc4,
	0x3b, 0x61, 0xb4, 0x2e, 0xf6, 0x64, 0xb4, 0xe7, 0xaa, 0x96, 0x67, 0xc2, 0x5d, 0xff, 0x02, 0x25,
	0xa9, 0x47, 0x45, 0x37, 0xc5, 0x96, 0x64, 0xb7, 0xac, 0xae, 0x65, 0xac, 0x72, 0x5f, 0xcf, 0x00,
	0x44, 0x93, 0x89, 0x24, 0x0d, 0x9b, 0xe8, 0x63, 0xd5, 0x9b, 0xe9, 0x8b, 0x22, 0x7d, 0x72, 0x13,
	0x28, 0xa7, 0x2f, 0xa5, 0x11, 0x95, 0xd3, 0x97, 0xda, 0x3b, 0x0e, 0xd3, 0x27, 0x6a, 0x51, 0x32,
	0x7d, 0x09, 0xa1, 0x93, 0x4c, 0x5f, 0x8a, 0x5c, 0xf9, 0xa0, 0xf0, 0x52, 0x92, 0xd7, 0x05, 0xa1,
	0x9d, 0xc8, 0xf9, 0x8e, 0xd5, 0x9a, 0xa9, 0xbb, 0x13, 0xed, 0x11, 0xa7, 0x29, 0x35, 0x38, 0xf2,
	0x69, 0x26, 0xbb, 0x28, 0xf9, 0x34, 0xd3, 0xba, 0x22, 0x17, 0x2a, 0x19, 0xed, 0x05, 0xda, 0x8a,
	0x61, 0xcb, 0x6c, 0x88, 0xd4, 0xbb, 0x63, 0x58, 0x8a, 0x53, 0x8a, 0xb7, 0x05, 0xf2, 0x29, 0x65,
	0xf4, 0x23, 0xf2, 0x29, 0x65, 0x76, 0x15, 0x27, 0xb0, 0x10, 0x97, 0xf0, 0xb2, 0xeb, 0x8c, 0xde,
	0x41, 0x76, 0x9d, 0xd9, 0x01, 0xf4, 0x40, 0xcd, 0xd6, 0xdc, 0xe8, 0x6b, 0x09, 0xdc, 0x28, 0xc5,
	0xaf, 0xde, 0x1b, 0xcf, 0x58, 0x70, 0x8a, 0x8b, 0x68, 0x99, 0x53, 0x86, 0x7a, 0x97, 0x39, 0x65,
	0x6a, 0xf0, 0xbf, 0x15, 0xf8, 0x62, 0x3c, 0x85, 0x8b, 0x1e, 0x8c, 0xba, 0xa5, 0x19, 0x02, 0x5c,
	0xfd, 0x61, 0xf2, 0x8d, 0x82, 0x78, 0x5c, 0xa7, 0xca, 0xc4, 0x33, 0x14, 0xb5, 0x4c, 0x3c, 0x53,
	0xe6, 0x1e, 0x41, 0x59, 0x56, 0x55, 0x72, 0xdd, 0x49, 0x91, 0x7e, 0x72, 0xdd, 0x49, 0x15, 0x63,
	0x7f, 0x2a, 0xb0, 0x96, 0x2b, 0x88, 0x50, 0x35, 0x7e, 0x1a, 0xf9, 0xea, 0x4c, 0xdd, 0x1e, 0xdb,
	0x9e, 0x43, 0x78, 0x05, 0xd7, 0x62, 0x82, 0x09, 0xdd, 0x96, 0x9e, 0x7d, 0xaa, 0x08, 0x53, 0xd7,
	0x73, 0x2c, 0xc4, 0xb5, 0xcf, 0x16, 0x38, 0xf2, 0xb5, 0x1f, 0xa9, 0xb3, 0xe4, 0x6b, 0x3f, 0x86,
	0x66, 0xea, 0xe7, 0x34, 0x57, 0x3b, 0xc8, 0x39, 0x1d, 0x47, 0x12, 0xc9, 0x39, 0x1d, 0x4b, 0x94,
	0xec, 0xb4, 0xe1, 0xaa, 0xee, 0x12, 0x1c, 0xb8, 0x66, 0x8b, 0x29, 0x8a, 0xdf, 0xe1, 0x7a, 0xe2,
	0x87, 0x45, 0x24, 0xdd, 0xb7, 0xac, 0x5f, 0x24, 0xd5, 0x3b, 0xb9, 0x36, 0x2c, 0xdc, 0x93, 0xea,
	0x6f, 0xf7, 0x2c, 0xcf, 0xc6, 0xd5, 0x77, 0x9d, 0x90, 0x38, 0x6e, 0x95, 0x74, 0xb7, 0x49, 0xcf,
	0x21, 0x56, 0xf3, 0x3e, 0xee, 0x62, 0x97, 0x84, 0xdb, 0xd4, 0xc5, 0x76, 0xe0, 0x5b, 0xec, 0xaf,
	0xd3, 0x19, 0xfa, 0xff, 0x13, 0xbb, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0xa4, 0x1a, 0x17, 0xbe,
	0xc6, 0x18, 0x00, 0x00,
}
