package models

import "time"

// Broadcast represents a currently active broadcast of a channel
type Broadcast struct {
	ID                string
	ChannelID         string
	HandwaveLatencyMS *int64
	StartedOn         time.Time
	EndedOn           *time.Time
}

// HasEnded returns <true> if the broadcast has ended and <false> if it is still live
func (b *Broadcast) HasEnded() bool {
	return b == nil || b.EndedOn != nil
}

// Duration returns the broadcast's duration
func (b *Broadcast) Duration() time.Duration {
	if b == nil {
		return 0 * time.Second
	}

	if b.HasEnded() {
		return b.EndedOn.Sub(b.StartedOn)
	}
	return time.Now().Sub(b.StartedOn)
}
