package models

// CommentReport represents a report of a comment to the Twitch moderation team
type CommentReport struct {
	CommentID   string `json:"comment_id"`
	Reason      string `json:"reason"`
	Description string `json:"description"`

	// automatically populated by backend
	CommentParentID *string        `josn:"comment_parent_id,omitempty"`
	TargetUserID    string         `json:"target_user_id,omitempty"`
	ReporterUserID  string         `json:"reporter_user_id,omitempty"`
	ContentObject   *ContentObject `json:"content,omitempty"`
	ContentOffset   *ContentOffset `json:"content_offset,omitempty"`
	MessageLines    string         `json:"message_lines,omitempty"`
}
